% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_zoom.R
\name{add_zoom}
\alias{add_zoom}
\title{add_zoom: Zoom in on region of another function.
Allows you to easily change an existing function
so that [0,1]^n refers to a subregion of the original function}
\usage{
add_zoom(func, scale_low, scale_high)
}
\arguments{
\item{func}{Function to add linear terms to}

\item{scale_low}{Vector of low end of scale values for each dimension}

\item{scale_high}{Vector of high end of scale values for each dimension}
}
\value{
Function with added linear terms
}
\description{
add_zoom: Zoom in on region of another function.
Allows you to easily change an existing function
so that [0,1]^n refers to a subregion of the original function
}
\examples{
banana(c(.5,.85))
add_zoom(banana, c(0,.5), c(1,1))(c(.5,.7))
add_zoom(banana, c(.2,.5), c(.8,1))(matrix(c(.5,.7),ncol=2))
ContourFunctions::cf(banana)
ContourFunctions::cf(add_zoom(banana, c(0,.5), c(1,1)))
ContourFunctions::cf(add_zoom(banana, c(.2,.5), c(.8,1)))
}
