% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permuteRGB.R
\name{permuteRGB}
\alias{permuteRGB}
\title{RGB permutation}
\usage{
permuteRGB(hexcolor, permutation = "gbr")
}
\arguments{
\item{hexcolor}{vector or matrix or array of hexadecimal colors}

\item{permutation}{a character string with three letters \code{"r"}, 
\code{"g"} and \code{"b"}}
}
\value{
The colors after applying the permutation.
}
\description{
Permutes the R-G-B components of a color.
}
\examples{
library(RcppColors)
x <- y <- seq(-1.7, 1.7, length.out = 512L)
zarray <- outer(y, x, function(x, y) {
  z <- x + 1i*y
  (1 + 1i) * log(sin((z^3 - 1)))
})
# image
img1 <- colorMap1(zarray)
# r -> b, g -> r, b -> g
img2 <- permuteRGB(img1, "brg")
# plot
opar <- par(mar = c(0,0,0,0), mfrow = c(1, 2), bg = "#002240")
plot(
  c(0, 1), c(0, 1), type = "n", asp = 1,
  xlab = NA, ylab = NA, axes = FALSE
)
rasterImage(img1, 0, 0, 1, 1, interpolate = TRUE)
plot(
  c(0, 1), c(0, 1), type = "n", asp = 1,
  xlab = NA, ylab = NA, axes = FALSE
)
rasterImage(img2, 0, 0, 1, 1, interpolate = TRUE)
par(opar)
}
