% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsluv.R
\name{hsluv}
\alias{hsluv}
\alias{hsluv2rgb}
\title{HSLuv color specification}
\usage{
hsluv(h = 360, s = 100, l = 100, alpha = NULL)

hsluv2rgb(h = 360, s = 100, l = 100)
}
\arguments{
\item{h}{the hue, a number between \code{0} and \code{360}}

\item{s}{the saturation, a number between \code{0} and \code{100}}

\item{l}{the lightness, a number between \code{0} and \code{100}}

\item{alpha}{opacity, a number between \code{0} and \code{1}, 
or \code{NULL}}
}
\value{
The \code{hsluv} function returns a hexadecimal string representing 
  a color, and the \code{hsluv2rgb} returns the RGB coordinates of this 
  color, a named vector of three integers between \code{0} and \code{255}.
}
\description{
Converts a color given in HSLuv coordinates to a hexadecimal 
  string or a RGB color specification
}
\examples{
saturation <- 100
f <- Vectorize(
  function(x, y){
    z <- complex(real = x, imaginary = y)
    modulus <- Mod(z)
    if(modulus > 1){
      return("#ffffff")
    }
    radians <- Arg(z)
    if(radians < 0){
      radians <- radians + 2*pi
    }
    degrees <- 360 * radians / 2 / pi
    hsluv(h = degrees, s = saturation, l = 100*modulus)
  }
)

x <- y <- seq(-1, 1, length.out = 200L)
image <- outer(x, y, f)

opar <- par(mar = c(0, 0, 0, 0))
plot(NULL, xlim = c(-1, 1), ylim = c(-1, 1), asp = 1)
rasterImage(image, -1, -1, 1, 1)
par(opar)
}
