% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localMaxima.R
\name{localMaxima}
\alias{localMaxima}
\title{Local Maxima}
\usage{
localMaxima(x, hws = 1L)
}
\arguments{
\item{x}{\code{numeric}, vector that should be searched for local maxima.}

\item{hws}{\code{integer(1)}, half window size, the resulting window reaches from
\code{(i - hws):(i + hws)}.}
}
\value{
A \code{logical} of the same length as \code{x} that is \code{TRUE} for each local
maxima.
}
\description{
This function finds local maxima in a numeric vector. A local maximum is
defined as maximum in a window of the current index +/- \code{hws}.
}
\examples{
x <- c(1:5, 4:1, 1:10, 9:1, 1:5, 4:1)
localMaxima(x)
localMaxima(x, hws = 10)
}
\seealso{
Other extreme value functions: 
\code{\link{.peakRegionMask}()},
\code{\link{refineCentroids}()},
\code{\link{valleys}()}
}
\author{
Sebastian Gibb
}
\concept{extreme value functions}
