% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatRt.R
\name{rt2numeric}
\alias{rt2numeric}
\alias{rt2character}
\alias{formatRt}
\title{Format Retention Time}
\usage{
rt2numeric(rt)

rt2character(rt)

formatRt(rt)
}
\arguments{
\item{rt}{A vector of retention times of length > 1. Either a
\code{numeric()} in seconds or a \code{character()} as \code{"mm:ss"}
depending on the function.}
}
\value{
A reformatted retention time.
}
\description{
These vectorised functions convert retention times from a numeric
in seconds to/from a character as "mm:ss". \code{rt2character()}
performs the numeric to character conversion while \code{rt2numeric()}
performs the character to numeric conversion. \code{formatRt()} does
one of the other depending on the input type.
}
\examples{

## rt2numeric

rt2numeric("25:24")
rt2numeric(c("25:24", "25:25", "25:26"))

## rt2character

rt2character(1524)
rt2character(1)
rt2character(1:10)

## formatRt

formatRt(1524)
formatRt(1)
formatRt(1:10)
formatRt("25:24")
formatRt(c("25:24", "25:25", "25:26"))
}
\author{
Laurent Gatto
}
