/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.PopupMenuHandler;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.RelationPopupMenus;
import org.openstreetmap.josm.gui.dialogs.relation.RelationTree;
import org.openstreetmap.josm.gui.dialogs.relation.RelationTreeModel;
import org.openstreetmap.josm.gui.dialogs.relation.actions.DuplicateRelationAction;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class ChildRelationBrowser
extends JPanel {
    private RelationTree childTree;
    private final transient RelationTreeModel model;
    private final transient OsmDataLayer layer;
    private EditAction editAction;

    protected OsmDataLayer getLayer() {
        return this.layer;
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.childTree = new RelationTree(this.model);
        JScrollPane pane = new JScrollPane(this.childTree);
        this.add((Component)pane, "Center");
        JPopupMenu popupMenu = new JPopupMenu();
        final PopupMenuHandler popupMenuHandler = new PopupMenuHandler(popupMenu);
        RelationPopupMenus.setupHandler(popupMenuHandler, DuplicateRelationAction.class);
        this.add((Component)this.buildButtonPanel(), "South");
        this.childTree.setToggleClickCount(0);
        this.childTree.addMouseListener(new PopupMenuLauncher(popupMenu){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!(e.getClickCount() != 2 || e.isAltDown() || e.isAltGraphDown() || e.isControlDown() || e.isMetaDown() || e.isShiftDown() || ChildRelationBrowser.this.childTree.getRowForLocation(e.getX(), e.getY()) != ChildRelationBrowser.this.childTree.getMinSelectionRow())) {
                    Relation r = (Relation)ChildRelationBrowser.this.childTree.getLastSelectedPathComponent();
                    if (r != null && r.isIncomplete()) {
                        ChildRelationBrowser.this.childTree.expandPath(ChildRelationBrowser.this.childTree.getSelectionPath());
                    } else {
                        ChildRelationBrowser.this.editAction.actionPerformed(new ActionEvent(e.getSource(), 1001, null));
                    }
                }
            }

            @Override
            protected TreePath checkTreeSelection(JTree tree, Point p) {
                TreePath treeSelection = super.checkTreeSelection(tree, p);
                TreePath[] selectionPaths = tree.getSelectionPaths();
                if (selectionPaths == null) {
                    return treeSelection;
                }
                List relations = Arrays.stream(selectionPaths).map(TreePath::getLastPathComponent).map(OsmPrimitive.class::cast).collect(Collectors.toList());
                popupMenuHandler.setPrimitives(relations);
                return treeSelection;
            }
        });
    }

    protected JPanel buildButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout(0));
        DownloadAllChildRelationsAction downloadAction = new DownloadAllChildRelationsAction();
        pnl.add(new JButton(downloadAction));
        DownloadSelectedAction downloadSelectedAction = new DownloadSelectedAction();
        this.childTree.addTreeSelectionListener(downloadSelectedAction);
        pnl.add(new JButton(downloadSelectedAction));
        this.editAction = new EditAction();
        this.childTree.addTreeSelectionListener(this.editAction);
        pnl.add(new JButton(this.editAction));
        return pnl;
    }

    public ChildRelationBrowser(OsmDataLayer layer) {
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        this.layer = layer;
        this.model = new RelationTreeModel();
        this.build();
    }

    public ChildRelationBrowser(OsmDataLayer layer, Relation root) {
        this(layer);
        this.populate(root);
    }

    public void populate(Relation r) {
        this.model.populate(r);
    }

    public void populate(List<RelationMember> members) {
        this.model.populate(members);
    }

    protected Dialog getParentDialog() {
        Container c;
        for (c = this; c != null && !(c instanceof Dialog); c = c.getParent()) {
        }
        return (Dialog)c;
    }

    class DownloadAllChildRelationsAction
    extends AbstractAction {
        DownloadAllChildRelationsAction() {
            this.putValue("ShortDescription", I18n.tr("Download all child relations (recursively)", new Object[0]));
            new ImageProvider("download").getResource().attachImageIcon(this, true);
            this.putValue("Name", I18n.tr("Download All Children", new Object[0]));
        }

        public void run() {
            MainApplication.worker.submit(new DownloadAllChildrenTask(ChildRelationBrowser.this.getParentDialog(), (Relation)ChildRelationBrowser.this.model.getRoot()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.run();
        }
    }

    class DownloadSelectedAction
    extends AbstractAction
    implements TreeSelectionListener {
        DownloadSelectedAction() {
            this.putValue("ShortDescription", I18n.tr("Download selected relations", new Object[0]));
            new ImageProvider("download").getResource().attachImageIcon(this, true);
            this.putValue("Name", I18n.tr("Download Selected Children", new Object[0]));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            TreePath[] selection = ChildRelationBrowser.this.childTree.getSelectionPaths();
            this.setEnabled(selection != null && selection.length > 0);
        }

        public void run() {
            TreePath[] selection = ChildRelationBrowser.this.childTree.getSelectionPaths();
            if (selection == null || selection.length == 0) {
                return;
            }
            Set<Relation> relations = Arrays.stream(selection).map(s -> (Relation)s.getLastPathComponent()).collect(Collectors.toSet());
            MainApplication.worker.submit(new DownloadRelationSetTask(ChildRelationBrowser.this.getParentDialog(), relations));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.run();
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class EditAction
    extends AbstractAction
    implements TreeSelectionListener {
        EditAction() {
            this.putValue("ShortDescription", I18n.tr("Edit the relation the currently selected relation member refers to", new Object[0]));
            new ImageProvider("dialogs", "edit").getResource().attachImageIcon(this, true);
            this.putValue("Name", I18n.tr("Edit", new Object[0]));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            TreePath[] selection = ChildRelationBrowser.this.childTree.getSelectionPaths();
            this.setEnabled(selection != null && selection.length > 0);
        }

        public void run() {
            TreePath[] selection = ChildRelationBrowser.this.childTree.getSelectionPaths();
            if (selection == null || selection.length == 0) {
                return;
            }
            for (int i = 0; i < Math.min(selection.length, 10); ++i) {
                Relation r = (Relation)selection[i].getLastPathComponent();
                if (!r.isUsable()) continue;
                RelationEditor editor = RelationEditor.getEditor(ChildRelationBrowser.this.getLayer(), r, null);
                editor.setVisible(true);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.run();
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            this.refreshEnabled();
        }
    }

    class DownloadRelationSetTask
    extends DownloadTask {
        private final Set<Relation> relations;

        DownloadRelationSetTask(Dialog parent, Set<Relation> relations) {
            super(I18n.tr("Download relation members", new Object[0]), parent);
            this.relations = relations;
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                this.reader = this.createReader();
                this.reader.append(this.relations);
                DataSet dataSet = this.reader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
                this.mergeDataSet(dataSet);
                for (Relation rel : dataSet.getRelations()) {
                    this.refreshView((Relation)ChildRelationBrowser.this.getLayer().getDataSet().getPrimitiveById(rel));
                }
            }
            catch (OsmTransferException e) {
                if (this.canceled) {
                    Logging.warn(I18n.tr("Ignoring exception because task was canceled. Exception: {0}", e.toString()));
                    return;
                }
                this.lastException = e;
            }
        }
    }

    class DownloadAllChildrenTask
    extends DownloadTask {
        private final Relation relation;

        DownloadAllChildrenTask(Dialog parent, Relation r) {
            super(I18n.tr("Download relation members", new Object[0]), parent);
            this.relation = r;
        }

        protected void warnBecauseOfDeletedRelation(Relation r) {
            String message = I18n.tr("<html>The child relation<br>{0}<br>is deleted on the server. It cannot be loaded</html>", Utils.escapeReservedCharactersHTML(r.getDisplayName(DefaultNameFormatter.getInstance())));
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), message, I18n.tr("Relation is deleted", new Object[0]), 2);
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                this.reader = this.createReader();
                this.reader.append(this.relation.getMemberPrimitives(Relation.class));
                DataSet dataSet = this.reader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
                this.mergeDataSet(dataSet);
                Utils.filteredCollection(this.reader.getMissingPrimitives(), Relation.class).forEach(this::warnBecauseOfDeletedRelation);
                for (Relation rel : dataSet.getRelations()) {
                    this.refreshView((Relation)ChildRelationBrowser.this.getLayer().getDataSet().getPrimitiveById(rel));
                }
                SwingUtilities.invokeLater(MainApplication.getMap()::repaint);
            }
            catch (OsmTransferException e) {
                if (this.canceled) {
                    Logging.warn(I18n.tr("Ignoring exception because task was canceled. Exception: {0}", e.toString()));
                    return;
                }
                this.lastException = e;
            }
        }
    }

    abstract class DownloadTask
    extends PleaseWaitRunnable {
        protected boolean canceled;
        protected int conflictsCount;
        protected Exception lastException;
        protected MultiFetchServerObjectReader reader;

        DownloadTask(String title, Dialog parent) {
            super(title, new PleaseWaitProgressMonitor(parent), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void cancel() {
            this.canceled = true;
            DownloadTask downloadTask = this;
            synchronized (downloadTask) {
                if (this.reader != null) {
                    this.reader.cancel();
                }
            }
        }

        protected MultiFetchServerObjectReader createReader() {
            return MultiFetchServerObjectReader.create().setRecurseDownAppended(false).setRecurseDownRelations(true);
        }

        protected void mergeDataSet(DataSet ds) {
            if (ds != null) {
                DataSetMerger visitor = new DataSetMerger(ChildRelationBrowser.this.getLayer().getDataSet(), ds);
                visitor.merge();
                if (!visitor.getConflicts().isEmpty()) {
                    ChildRelationBrowser.this.getLayer().getConflicts().add(visitor.getConflicts());
                    this.conflictsCount += visitor.getConflicts().size();
                }
            }
        }

        protected void refreshView(Relation relation) {
            GuiHelper.runInEDT(() -> {
                for (int i = 0; i < ChildRelationBrowser.this.childTree.getRowCount(); ++i) {
                    Relation reference = (Relation)ChildRelationBrowser.this.childTree.getPathForRow(i).getLastPathComponent();
                    if (reference != relation) continue;
                    ChildRelationBrowser.this.model.refreshNode(ChildRelationBrowser.this.childTree.getPathForRow(i));
                }
            });
        }

        @Override
        protected void finish() {
            if (this.canceled) {
                return;
            }
            if (this.lastException != null) {
                ExceptionDialogUtil.explainException(this.lastException);
                return;
            }
            if (this.conflictsCount > 0) {
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.trn("There was {0} conflict during import.", "There were {0} conflicts during import.", this.conflictsCount, this.conflictsCount), I18n.trn("Conflict in data", "Conflicts in data", this.conflictsCount, new Object[0]), 2);
            }
        }
    }
}

