/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.upload;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class FixDataHook
implements UploadHook {
    private static final String ONEWAY = "oneway";
    private final List<FixData> deprecated = new LinkedList<FixData>();

    public FixDataHook() {
        this.deprecated.add(new FixDataSpace());
        this.deprecated.add(new FixDataKey("color", "colour"));
        this.deprecated.add(new FixDataTag("highway", "ford", "ford", "yes"));
        this.deprecated.add(new FixDataTag(ONEWAY, "false", ONEWAY, "no"));
        this.deprecated.add(new FixDataTag(ONEWAY, "0", ONEWAY, "no"));
        this.deprecated.add(new FixDataTag(ONEWAY, "true", ONEWAY, "yes"));
        this.deprecated.add(new FixDataTag(ONEWAY, "1", ONEWAY, "yes"));
        this.deprecated.add(new FixDataTag("highway", "stile", "barrier", "stile"));
        this.deprecated.add((keys, osm) -> {
            if (osm instanceof Relation && "multipolygon".equals(keys.get("type")) && "administrative".equals(keys.get("boundary"))) {
                keys.put("type", "boundary");
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean checkUpload(APIDataSet apiDataSet) {
        if (Config.getPref().getBoolean("fix.data.on.upload", true)) {
            LinkedList<Command> cmds = new LinkedList<Command>();
            for (OsmPrimitive osm : apiDataSet.getPrimitives()) {
                HashMap<String, String> keys = new HashMap<String, String>(osm.getKeys());
                if (keys.isEmpty()) continue;
                boolean modified = false;
                for (FixData fix : this.deprecated) {
                    if (!fix.fixKeys(keys, osm)) continue;
                    modified = true;
                }
                if (!modified) continue;
                cmds.add(new ChangePropertyCommand(Collections.singleton(osm), keys));
            }
            if (!cmds.isEmpty()) {
                UndoRedoHandler.getInstance().add(new SequenceCommand(I18n.tr("Fix deprecated tags", new Object[0]), cmds));
            }
        }
        return true;
    }

    public static class FixDataSpace
    implements FixData {
        @Override
        public boolean fixKeys(Map<String, String> keys, OsmPrimitive osm) {
            boolean changed;
            HashMap<String, String> newKeys = new HashMap<String, String>(keys);
            for (Map.Entry<String, String> e : keys.entrySet()) {
                boolean drop;
                String v = Utils.removeWhiteSpaces(e.getValue());
                String k = Utils.removeWhiteSpaces(e.getKey());
                boolean bl = drop = k.isEmpty() || v.isEmpty();
                if (!e.getKey().equals(k)) {
                    if (!drop && keys.containsKey(k)) continue;
                    newKeys.put(e.getKey(), null);
                    if (drop) continue;
                    newKeys.put(k, v);
                    continue;
                }
                if (!e.getValue().equals(v)) {
                    newKeys.put(k, v.isEmpty() ? null : v);
                    continue;
                }
                if (!drop) continue;
                newKeys.put(e.getKey(), null);
            }
            boolean bl = changed = !keys.equals(newKeys);
            if (changed) {
                keys.clear();
                keys.putAll(newKeys);
            }
            return changed;
        }
    }

    public static class FixDataKey
    implements FixData {
        private final String oldKey;
        private final String newKey;

        public FixDataKey(String oldKey, String newKey) {
            this.oldKey = oldKey;
            this.newKey = newKey;
        }

        @Override
        public boolean fixKeys(Map<String, String> keys, OsmPrimitive osm) {
            if (keys.containsKey(this.oldKey) && !keys.containsKey(this.newKey)) {
                keys.put(this.newKey, keys.get(this.oldKey));
                keys.put(this.oldKey, null);
                return true;
            }
            if (keys.containsKey(this.oldKey) && keys.containsKey(this.newKey) && keys.get(this.oldKey).equals(keys.get(this.newKey))) {
                keys.put(this.oldKey, null);
                return true;
            }
            return false;
        }
    }

    public static class FixDataTag
    implements FixData {
        private final String oldKey;
        private final String oldValue;
        private final String newKey;
        private final String newValue;

        public FixDataTag(String oldKey, String oldValue, String newKey, String newValue) {
            this.oldKey = oldKey;
            this.oldValue = oldValue;
            this.newKey = newKey;
            this.newValue = newValue;
        }

        @Override
        public boolean fixKeys(Map<String, String> keys, OsmPrimitive osm) {
            if (this.oldValue.equals(keys.get(this.oldKey)) && (this.newKey.equals(this.oldKey) || !keys.containsKey(this.newKey) || keys.get(this.newKey).equals(this.newValue))) {
                keys.put(this.newKey, this.newValue);
                if (!this.newKey.equals(this.oldKey)) {
                    keys.put(this.oldKey, null);
                }
                return true;
            }
            return false;
        }
    }

    @FunctionalInterface
    public static interface FixData {
        public boolean fixKeys(Map<String, String> var1, OsmPrimitive var2);
    }
}

