/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.log;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogFactory;

public class LogManager {
    private static String logSystem;
    public static final String LOGSYSTEM_JAVA_UTIL_LOGGING = "jul";
    public static final String LOGSYSTEM_LOG4J2 = "log4j2";

    public static void setLogSystem(String logSystem) {
        LogManager.logSystem = logSystem;
    }

    private static LogFactory getLogFactory() {
        return LogFactoryHolder.INSTANCE;
    }

    protected LogManager() {
    }

    public static void shutdown() {
        LogManager.getLogFactory().shutdown();
    }

    public static Log getLog(Class<?> clazz) {
        return LogManager.getLogFactory().getLog(clazz);
    }

    public static Log getLog(String name) {
        return LogManager.getLogFactory().getLog(name);
    }

    public static Log getRootLogger() {
        return LogManager.getLog("");
    }

    private static class LogFactoryHolder {
        static final LogFactory INSTANCE = LogFactoryHolder.createLogFactory();

        private LogFactoryHolder() {
        }

        private static LogFactory createLogFactory() {
            ServiceLoader<LogFactory> factories = ServiceLoader.load(LogFactory.class);
            if (logSystem == null) {
                logSystem = System.getProperty("jcs.logSystem", LogManager.LOGSYSTEM_JAVA_UTIL_LOGGING);
            }
            ArrayList<ServiceConfigurationError> errors = new ArrayList<ServiceConfigurationError>();
            Iterator<LogFactory> itr = factories.iterator();
            LogFactory factory = null;
            while (itr.hasNext()) {
                try {
                    LogFactory instance = itr.next();
                    if (!logSystem.equalsIgnoreCase(instance.getName())) continue;
                    factory = instance;
                    break;
                }
                catch (ServiceConfigurationError e2) {
                    errors.add(e2);
                }
            }
            if (factory != null) {
                if (!errors.isEmpty()) {
                    Log log = factory.getLog(LogFactoryHolder.class);
                    for (ServiceConfigurationError error : errors) {
                        log.debug("Error loading LogFactory", error);
                    }
                    log.debug("Found LogFactory for " + logSystem);
                }
                return factory;
            }
            errors.forEach(e -> System.err.println(e.getMessage()));
            throw new RuntimeException("Could not find factory implementation for log subsystem " + logSystem);
        }
    }
}

