/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.mappaint.StyleSetting;
import org.openstreetmap.josm.gui.mappaint.StyleSettingGui;
import org.openstreetmap.josm.gui.mappaint.loader.MapPaintStyleLoader;

class PropertyStyleSettingGui<T>
implements StyleSettingGui {
    private final StyleSetting.PropertyStyleSetting<T> setting;

    PropertyStyleSettingGui(StyleSetting.PropertyStyleSetting<T> setting) {
        this.setting = Objects.requireNonNull(setting);
    }

    @Override
    public void addMenuEntry(JMenu menu) {
        menu.add(new PropertyStyleSettingAction());
    }

    class PropertyStyleSettingAction
    extends AbstractAction {
        PropertyStyleSettingAction() {
            super(PropertyStyleSettingGui.this.setting.label);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String initialValue = String.valueOf(PropertyStyleSettingGui.this.setting.getValue());
            String userInput = JOptionPane.showInputDialog(PropertyStyleSettingGui.this.setting.label, (Object)initialValue);
            if (userInput != null && !initialValue.equals(userInput)) {
                PropertyStyleSettingGui.this.setting.setStringValue(userInput);
                MainApplication.worker.submit(new MapPaintStyleLoader(Collections.singletonList(PropertyStyleSettingGui.this.setting.parentStyle)));
            }
        }
    }
}

