#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 5870
#define LARGE_STATE_COUNT 1193
#define SYMBOL_COUNT 376
#define ALIAS_COUNT 7
#define TOKEN_COUNT 166
#define EXTERNAL_TOKEN_COUNT 10
#define FIELD_COUNT 40
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 340

enum ts_symbol_identifiers {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_export = 3,
  anon_sym_STAR = 4,
  anon_sym_default = 5,
  anon_sym_type = 6,
  anon_sym_EQ = 7,
  anon_sym_as = 8,
  anon_sym_namespace = 9,
  anon_sym_LBRACE = 10,
  anon_sym_COMMA = 11,
  anon_sym_RBRACE = 12,
  anon_sym_typeof = 13,
  anon_sym_import = 14,
  anon_sym_from = 15,
  anon_sym_with = 16,
  anon_sym_assert = 17,
  anon_sym_var = 18,
  anon_sym_let = 19,
  anon_sym_const = 20,
  anon_sym_BANG = 21,
  anon_sym_else = 22,
  anon_sym_if = 23,
  anon_sym_switch = 24,
  anon_sym_for = 25,
  anon_sym_LPAREN = 26,
  anon_sym_SEMI = 27,
  anon_sym_RPAREN = 28,
  anon_sym_await = 29,
  anon_sym_in = 30,
  anon_sym_of = 31,
  anon_sym_while = 32,
  anon_sym_do = 33,
  anon_sym_try = 34,
  anon_sym_break = 35,
  anon_sym_continue = 36,
  anon_sym_debugger = 37,
  anon_sym_return = 38,
  anon_sym_throw = 39,
  anon_sym_COLON = 40,
  anon_sym_case = 41,
  anon_sym_catch = 42,
  anon_sym_finally = 43,
  anon_sym_yield = 44,
  anon_sym_LBRACK = 45,
  anon_sym_RBRACK = 46,
  anon_sym_DOT = 47,
  anon_sym_class = 48,
  anon_sym_async = 49,
  anon_sym_function = 50,
  anon_sym_EQ_GT = 51,
  anon_sym_QMARK_DOT = 52,
  anon_sym_new = 53,
  anon_sym_using = 54,
  anon_sym_PLUS_EQ = 55,
  anon_sym_DASH_EQ = 56,
  anon_sym_STAR_EQ = 57,
  anon_sym_SLASH_EQ = 58,
  anon_sym_PERCENT_EQ = 59,
  anon_sym_CARET_EQ = 60,
  anon_sym_AMP_EQ = 61,
  anon_sym_PIPE_EQ = 62,
  anon_sym_GT_GT_EQ = 63,
  anon_sym_GT_GT_GT_EQ = 64,
  anon_sym_LT_LT_EQ = 65,
  anon_sym_STAR_STAR_EQ = 66,
  anon_sym_AMP_AMP_EQ = 67,
  anon_sym_PIPE_PIPE_EQ = 68,
  anon_sym_QMARK_QMARK_EQ = 69,
  anon_sym_DOT_DOT_DOT = 70,
  anon_sym_AMP_AMP = 71,
  anon_sym_PIPE_PIPE = 72,
  anon_sym_GT_GT = 73,
  anon_sym_GT_GT_GT = 74,
  anon_sym_LT_LT = 75,
  anon_sym_AMP = 76,
  anon_sym_CARET = 77,
  anon_sym_PIPE = 78,
  anon_sym_PLUS = 79,
  anon_sym_DASH = 80,
  anon_sym_SLASH = 81,
  anon_sym_PERCENT = 82,
  anon_sym_STAR_STAR = 83,
  anon_sym_LT = 84,
  anon_sym_LT_EQ = 85,
  anon_sym_EQ_EQ = 86,
  anon_sym_EQ_EQ_EQ = 87,
  anon_sym_BANG_EQ = 88,
  anon_sym_BANG_EQ_EQ = 89,
  anon_sym_GT_EQ = 90,
  anon_sym_GT = 91,
  anon_sym_QMARK_QMARK = 92,
  anon_sym_instanceof = 93,
  anon_sym_TILDE = 94,
  anon_sym_void = 95,
  anon_sym_delete = 96,
  anon_sym_PLUS_PLUS = 97,
  anon_sym_DASH_DASH = 98,
  anon_sym_DQUOTE = 99,
  anon_sym_SQUOTE = 100,
  sym_unescaped_double_string_fragment = 101,
  sym_unescaped_single_string_fragment = 102,
  sym_escape_sequence = 103,
  sym_comment = 104,
  anon_sym_BQUOTE = 105,
  anon_sym_DOLLAR_LBRACE = 106,
  anon_sym_SLASH2 = 107,
  sym_regex_pattern = 108,
  sym_regex_flags = 109,
  sym_number = 110,
  sym_private_property_identifier = 111,
  anon_sym_target = 112,
  anon_sym_meta = 113,
  sym_this = 114,
  sym_super = 115,
  sym_true = 116,
  sym_false = 117,
  sym_null = 118,
  sym_undefined = 119,
  anon_sym_AT = 120,
  anon_sym_static = 121,
  anon_sym_readonly = 122,
  anon_sym_get = 123,
  anon_sym_set = 124,
  anon_sym_QMARK = 125,
  anon_sym_declare = 126,
  anon_sym_public = 127,
  anon_sym_private = 128,
  anon_sym_protected = 129,
  anon_sym_override = 130,
  anon_sym_module = 131,
  anon_sym_any = 132,
  anon_sym_number = 133,
  anon_sym_boolean = 134,
  anon_sym_string = 135,
  anon_sym_symbol = 136,
  anon_sym_object = 137,
  anon_sym_abstract = 138,
  anon_sym_accessor = 139,
  anon_sym_satisfies = 140,
  anon_sym_require = 141,
  anon_sym_extends = 142,
  anon_sym_implements = 143,
  anon_sym_global = 144,
  anon_sym_interface = 145,
  anon_sym_enum = 146,
  anon_sym_DASH_QMARK_COLON = 147,
  anon_sym_PLUS_QMARK_COLON = 148,
  anon_sym_QMARK_COLON = 149,
  anon_sym_asserts = 150,
  anon_sym_infer = 151,
  anon_sym_is = 152,
  anon_sym_keyof = 153,
  anon_sym_unique = 154,
  anon_sym_unknown = 155,
  anon_sym_never = 156,
  anon_sym_LBRACE_PIPE = 157,
  anon_sym_PIPE_RBRACE = 158,
  sym__automatic_semicolon = 159,
  sym__template_chars = 160,
  sym__ternary_qmark = 161,
  sym_html_comment = 162,
  sym_jsx_text = 163,
  sym__function_signature_automatic_semicolon = 164,
  sym___error_recovery = 165,
  sym_program = 166,
  sym_export_statement = 167,
  sym_namespace_export = 168,
  sym_export_clause = 169,
  sym_export_specifier = 170,
  sym__module_export_name = 171,
  sym_declaration = 172,
  sym_import = 173,
  sym_import_statement = 174,
  sym_import_clause = 175,
  sym__from_clause = 176,
  sym_namespace_import = 177,
  sym_named_imports = 178,
  sym_import_specifier = 179,
  sym_import_attribute = 180,
  sym_statement = 181,
  sym_expression_statement = 182,
  sym_variable_declaration = 183,
  sym_lexical_declaration = 184,
  sym_variable_declarator = 185,
  sym_statement_block = 186,
  sym_else_clause = 187,
  sym_if_statement = 188,
  sym_switch_statement = 189,
  sym_for_statement = 190,
  sym_for_in_statement = 191,
  sym__for_header = 192,
  sym_while_statement = 193,
  sym_do_statement = 194,
  sym_try_statement = 195,
  sym_with_statement = 196,
  sym_break_statement = 197,
  sym_continue_statement = 198,
  sym_debugger_statement = 199,
  sym_return_statement = 200,
  sym_throw_statement = 201,
  sym_empty_statement = 202,
  sym_labeled_statement = 203,
  sym_switch_body = 204,
  sym_switch_case = 205,
  sym_switch_default = 206,
  sym_catch_clause = 207,
  sym_finally_clause = 208,
  sym_parenthesized_expression = 209,
  sym_expression = 210,
  sym_primary_expression = 211,
  sym_yield_expression = 212,
  sym_object = 213,
  sym_object_pattern = 214,
  sym_assignment_pattern = 215,
  sym_object_assignment_pattern = 216,
  sym_array = 217,
  sym_array_pattern = 218,
  sym_nested_identifier = 219,
  sym_class = 220,
  sym_class_declaration = 221,
  sym_class_heritage = 222,
  sym_function_expression = 223,
  sym_function_declaration = 224,
  sym_generator_function = 225,
  sym_generator_function_declaration = 226,
  sym_arrow_function = 227,
  sym__call_signature = 228,
  sym__formal_parameter = 229,
  sym_optional_chain = 230,
  sym_call_expression = 231,
  sym_new_expression = 232,
  sym_await_expression = 233,
  sym_member_expression = 234,
  sym_subscript_expression = 235,
  sym_assignment_expression = 236,
  sym__augmented_assignment_lhs = 237,
  sym_augmented_assignment_expression = 238,
  sym__initializer = 239,
  sym__destructuring_pattern = 240,
  sym_spread_element = 241,
  sym_ternary_expression = 242,
  sym_binary_expression = 243,
  sym_unary_expression = 244,
  sym_update_expression = 245,
  sym_sequence_expression = 246,
  sym_string = 247,
  sym_template_string = 248,
  sym_template_substitution = 249,
  sym_regex = 250,
  sym_meta_property = 251,
  sym_arguments = 252,
  sym_decorator = 253,
  sym_decorator_member_expression = 254,
  sym_decorator_call_expression = 255,
  sym_class_body = 256,
  sym_formal_parameters = 257,
  sym_class_static_block = 258,
  sym_pattern = 259,
  sym_rest_pattern = 260,
  sym_method_definition = 261,
  sym_pair = 262,
  sym_pair_pattern = 263,
  sym__property_name = 264,
  sym_computed_property_name = 265,
  sym_public_field_definition = 266,
  sym__import_identifier = 267,
  sym_non_null_expression = 268,
  sym_method_signature = 269,
  sym_abstract_method_signature = 270,
  sym_function_signature = 271,
  sym_decorator_parenthesized_expression = 272,
  sym_type_assertion = 273,
  sym_as_expression = 274,
  sym_satisfies_expression = 275,
  sym_instantiation_expression = 276,
  sym_import_require_clause = 277,
  sym_extends_clause = 278,
  sym__extends_clause_single = 279,
  sym_implements_clause = 280,
  sym_ambient_declaration = 281,
  sym_abstract_class_declaration = 282,
  sym_module = 283,
  sym_internal_module = 284,
  sym__module = 285,
  sym_import_alias = 286,
  sym_nested_type_identifier = 287,
  sym_interface_declaration = 288,
  sym_extends_type_clause = 289,
  sym_enum_declaration = 290,
  sym_enum_body = 291,
  sym_enum_assignment = 292,
  sym_type_alias_declaration = 293,
  sym_accessibility_modifier = 294,
  sym_override_modifier = 295,
  sym_required_parameter = 296,
  sym_optional_parameter = 297,
  sym__parameter_name = 298,
  sym_omitting_type_annotation = 299,
  sym_adding_type_annotation = 300,
  sym_opting_type_annotation = 301,
  sym_type_annotation = 302,
  sym__type_query_member_expression_in_type_annotation = 303,
  sym__type_query_call_expression_in_type_annotation = 304,
  sym_asserts = 305,
  sym_asserts_annotation = 306,
  sym_type = 307,
  sym_tuple_parameter = 308,
  sym_optional_tuple_parameter = 309,
  sym_optional_type = 310,
  sym_rest_type = 311,
  sym__tuple_type_member = 312,
  sym_constructor_type = 313,
  sym_primary_type = 314,
  sym_template_type = 315,
  sym_template_literal_type = 316,
  sym_infer_type = 317,
  sym_conditional_type = 318,
  sym_generic_type = 319,
  sym_type_predicate = 320,
  sym_type_predicate_annotation = 321,
  sym__type_query_member_expression = 322,
  sym__type_query_subscript_expression = 323,
  sym__type_query_call_expression = 324,
  sym__type_query_instantiation_expression = 325,
  sym_type_query = 326,
  sym_index_type_query = 327,
  sym_lookup_type = 328,
  sym_mapped_type_clause = 329,
  sym_literal_type = 330,
  sym__number = 331,
  sym_existential_type = 332,
  sym_flow_maybe_type = 333,
  sym_parenthesized_type = 334,
  sym_predefined_type = 335,
  sym_type_arguments = 336,
  sym_object_type = 337,
  sym_call_signature = 338,
  sym_property_signature = 339,
  sym_type_parameters = 340,
  sym_type_parameter = 341,
  sym_default_type = 342,
  sym_constraint = 343,
  sym_construct_signature = 344,
  sym_index_signature = 345,
  sym_array_type = 346,
  sym_tuple_type = 347,
  sym_readonly_type = 348,
  sym_union_type = 349,
  sym_intersection_type = 350,
  sym_function_type = 351,
  aux_sym_program_repeat1 = 352,
  aux_sym_export_statement_repeat1 = 353,
  aux_sym_export_clause_repeat1 = 354,
  aux_sym_named_imports_repeat1 = 355,
  aux_sym_variable_declaration_repeat1 = 356,
  aux_sym_switch_body_repeat1 = 357,
  aux_sym_object_repeat1 = 358,
  aux_sym_object_pattern_repeat1 = 359,
  aux_sym_array_repeat1 = 360,
  aux_sym_array_pattern_repeat1 = 361,
  aux_sym_sequence_expression_repeat1 = 362,
  aux_sym_string_repeat1 = 363,
  aux_sym_string_repeat2 = 364,
  aux_sym_template_string_repeat1 = 365,
  aux_sym_class_body_repeat1 = 366,
  aux_sym_formal_parameters_repeat1 = 367,
  aux_sym_extends_clause_repeat1 = 368,
  aux_sym_implements_clause_repeat1 = 369,
  aux_sym_extends_type_clause_repeat1 = 370,
  aux_sym_enum_body_repeat1 = 371,
  aux_sym_template_literal_type_repeat1 = 372,
  aux_sym_object_type_repeat1 = 373,
  aux_sym_type_parameters_repeat1 = 374,
  aux_sym_tuple_type_repeat1 = 375,
  alias_sym_interface_body = 376,
  alias_sym_property_identifier = 377,
  alias_sym_shorthand_property_identifier = 378,
  alias_sym_shorthand_property_identifier_pattern = 379,
  alias_sym_statement_identifier = 380,
  alias_sym_this_type = 381,
  alias_sym_type_identifier = 382,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_export] = "export",
  [anon_sym_STAR] = "*",
  [anon_sym_default] = "default",
  [anon_sym_type] = "type",
  [anon_sym_EQ] = "=",
  [anon_sym_as] = "as",
  [anon_sym_namespace] = "namespace",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_typeof] = "typeof",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_with] = "with",
  [anon_sym_assert] = "assert",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_BANG] = "!",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_switch] = "switch",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_SEMI] = ";",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_in] = "in",
  [anon_sym_of] = "of",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_debugger] = "debugger",
  [anon_sym_return] = "return",
  [anon_sym_throw] = "throw",
  [anon_sym_COLON] = ":",
  [anon_sym_case] = "case",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_async] = "async",
  [anon_sym_function] = "function",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_QMARK_DOT] = "\?.",
  [anon_sym_new] = "new",
  [anon_sym_using] = "using",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_AMP_AMP_EQ] = "&&=",
  [anon_sym_PIPE_PIPE_EQ] = "||=",
  [anon_sym_QMARK_QMARK_EQ] = "\?\?=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_TILDE] = "~",
  [anon_sym_void] = "void",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_unescaped_single_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [sym_comment] = "comment",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [sym_number] = "number",
  [sym_private_property_identifier] = "private_property_identifier",
  [anon_sym_target] = "target",
  [anon_sym_meta] = "meta",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_undefined] = "undefined",
  [anon_sym_AT] = "@",
  [anon_sym_static] = "static",
  [anon_sym_readonly] = "readonly",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [anon_sym_QMARK] = "\?",
  [anon_sym_declare] = "declare",
  [anon_sym_public] = "public",
  [anon_sym_private] = "private",
  [anon_sym_protected] = "protected",
  [anon_sym_override] = "override",
  [anon_sym_module] = "module",
  [anon_sym_any] = "any",
  [anon_sym_number] = "number",
  [anon_sym_boolean] = "boolean",
  [anon_sym_string] = "string",
  [anon_sym_symbol] = "symbol",
  [anon_sym_object] = "object",
  [anon_sym_abstract] = "abstract",
  [anon_sym_accessor] = "accessor",
  [anon_sym_satisfies] = "satisfies",
  [anon_sym_require] = "require",
  [anon_sym_extends] = "extends",
  [anon_sym_implements] = "implements",
  [anon_sym_global] = "global",
  [anon_sym_interface] = "interface",
  [anon_sym_enum] = "enum",
  [anon_sym_DASH_QMARK_COLON] = "-\?:",
  [anon_sym_PLUS_QMARK_COLON] = "+\?:",
  [anon_sym_QMARK_COLON] = "\?:",
  [anon_sym_asserts] = "asserts",
  [anon_sym_infer] = "infer",
  [anon_sym_is] = "is",
  [anon_sym_keyof] = "keyof",
  [anon_sym_unique] = "unique symbol",
  [anon_sym_unknown] = "unknown",
  [anon_sym_never] = "never",
  [anon_sym_LBRACE_PIPE] = "{|",
  [anon_sym_PIPE_RBRACE] = "|}",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars] = "string_fragment",
  [sym__ternary_qmark] = "\?",
  [sym_html_comment] = "html_comment",
  [sym_jsx_text] = "jsx_text",
  [sym__function_signature_automatic_semicolon] = "_function_signature_automatic_semicolon",
  [sym___error_recovery] = "__error_recovery",
  [sym_program] = "program",
  [sym_export_statement] = "export_statement",
  [sym_namespace_export] = "namespace_export",
  [sym_export_clause] = "export_clause",
  [sym_export_specifier] = "export_specifier",
  [sym__module_export_name] = "_module_export_name",
  [sym_declaration] = "declaration",
  [sym_import] = "import",
  [sym_import_statement] = "import_statement",
  [sym_import_clause] = "import_clause",
  [sym__from_clause] = "_from_clause",
  [sym_namespace_import] = "namespace_import",
  [sym_named_imports] = "named_imports",
  [sym_import_specifier] = "import_specifier",
  [sym_import_attribute] = "import_attribute",
  [sym_statement] = "statement",
  [sym_expression_statement] = "expression_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_lexical_declaration] = "lexical_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_statement_block] = "statement_block",
  [sym_else_clause] = "else_clause",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__for_header] = "_for_header",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_try_statement] = "try_statement",
  [sym_with_statement] = "with_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_debugger_statement] = "debugger_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_object] = "object",
  [sym_object_pattern] = "object_pattern",
  [sym_assignment_pattern] = "assignment_pattern",
  [sym_object_assignment_pattern] = "object_assignment_pattern",
  [sym_array] = "array",
  [sym_array_pattern] = "array_pattern",
  [sym_nested_identifier] = "nested_identifier",
  [sym_class] = "class",
  [sym_class_declaration] = "class_declaration",
  [sym_class_heritage] = "class_heritage",
  [sym_function_expression] = "function_expression",
  [sym_function_declaration] = "function_declaration",
  [sym_generator_function] = "generator_function",
  [sym_generator_function_declaration] = "generator_function_declaration",
  [sym_arrow_function] = "arrow_function",
  [sym__call_signature] = "_call_signature",
  [sym__formal_parameter] = "_formal_parameter",
  [sym_optional_chain] = "optional_chain",
  [sym_call_expression] = "call_expression",
  [sym_new_expression] = "new_expression",
  [sym_await_expression] = "await_expression",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym__augmented_assignment_lhs] = "_augmented_assignment_lhs",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym__initializer] = "_initializer",
  [sym__destructuring_pattern] = "_destructuring_pattern",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_sequence_expression] = "sequence_expression",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_substitution] = "template_substitution",
  [sym_regex] = "regex",
  [sym_meta_property] = "meta_property",
  [sym_arguments] = "arguments",
  [sym_decorator] = "decorator",
  [sym_decorator_member_expression] = "member_expression",
  [sym_decorator_call_expression] = "call_expression",
  [sym_class_body] = "class_body",
  [sym_formal_parameters] = "formal_parameters",
  [sym_class_static_block] = "class_static_block",
  [sym_pattern] = "pattern",
  [sym_rest_pattern] = "rest_pattern",
  [sym_method_definition] = "method_definition",
  [sym_pair] = "pair",
  [sym_pair_pattern] = "pair_pattern",
  [sym__property_name] = "_property_name",
  [sym_computed_property_name] = "computed_property_name",
  [sym_public_field_definition] = "public_field_definition",
  [sym__import_identifier] = "_import_identifier",
  [sym_non_null_expression] = "non_null_expression",
  [sym_method_signature] = "method_signature",
  [sym_abstract_method_signature] = "abstract_method_signature",
  [sym_function_signature] = "function_signature",
  [sym_decorator_parenthesized_expression] = "parenthesized_expression",
  [sym_type_assertion] = "type_assertion",
  [sym_as_expression] = "as_expression",
  [sym_satisfies_expression] = "satisfies_expression",
  [sym_instantiation_expression] = "instantiation_expression",
  [sym_import_require_clause] = "import_require_clause",
  [sym_extends_clause] = "extends_clause",
  [sym__extends_clause_single] = "_extends_clause_single",
  [sym_implements_clause] = "implements_clause",
  [sym_ambient_declaration] = "ambient_declaration",
  [sym_abstract_class_declaration] = "abstract_class_declaration",
  [sym_module] = "module",
  [sym_internal_module] = "internal_module",
  [sym__module] = "_module",
  [sym_import_alias] = "import_alias",
  [sym_nested_type_identifier] = "nested_type_identifier",
  [sym_interface_declaration] = "interface_declaration",
  [sym_extends_type_clause] = "extends_type_clause",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_enum_assignment] = "enum_assignment",
  [sym_type_alias_declaration] = "type_alias_declaration",
  [sym_accessibility_modifier] = "accessibility_modifier",
  [sym_override_modifier] = "override_modifier",
  [sym_required_parameter] = "required_parameter",
  [sym_optional_parameter] = "optional_parameter",
  [sym__parameter_name] = "_parameter_name",
  [sym_omitting_type_annotation] = "omitting_type_annotation",
  [sym_adding_type_annotation] = "adding_type_annotation",
  [sym_opting_type_annotation] = "opting_type_annotation",
  [sym_type_annotation] = "type_annotation",
  [sym__type_query_member_expression_in_type_annotation] = "member_expression",
  [sym__type_query_call_expression_in_type_annotation] = "call_expression",
  [sym_asserts] = "asserts",
  [sym_asserts_annotation] = "asserts_annotation",
  [sym_type] = "type",
  [sym_tuple_parameter] = "required_parameter",
  [sym_optional_tuple_parameter] = "optional_parameter",
  [sym_optional_type] = "optional_type",
  [sym_rest_type] = "rest_type",
  [sym__tuple_type_member] = "_tuple_type_member",
  [sym_constructor_type] = "constructor_type",
  [sym_primary_type] = "primary_type",
  [sym_template_type] = "template_type",
  [sym_template_literal_type] = "template_literal_type",
  [sym_infer_type] = "infer_type",
  [sym_conditional_type] = "conditional_type",
  [sym_generic_type] = "generic_type",
  [sym_type_predicate] = "type_predicate",
  [sym_type_predicate_annotation] = "type_predicate_annotation",
  [sym__type_query_member_expression] = "member_expression",
  [sym__type_query_subscript_expression] = "subscript_expression",
  [sym__type_query_call_expression] = "call_expression",
  [sym__type_query_instantiation_expression] = "instantiation_expression",
  [sym_type_query] = "type_query",
  [sym_index_type_query] = "index_type_query",
  [sym_lookup_type] = "lookup_type",
  [sym_mapped_type_clause] = "mapped_type_clause",
  [sym_literal_type] = "literal_type",
  [sym__number] = "unary_expression",
  [sym_existential_type] = "existential_type",
  [sym_flow_maybe_type] = "flow_maybe_type",
  [sym_parenthesized_type] = "parenthesized_type",
  [sym_predefined_type] = "predefined_type",
  [sym_type_arguments] = "type_arguments",
  [sym_object_type] = "object_type",
  [sym_call_signature] = "call_signature",
  [sym_property_signature] = "property_signature",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_default_type] = "default_type",
  [sym_constraint] = "constraint",
  [sym_construct_signature] = "construct_signature",
  [sym_index_signature] = "index_signature",
  [sym_array_type] = "array_type",
  [sym_tuple_type] = "tuple_type",
  [sym_readonly_type] = "readonly_type",
  [sym_union_type] = "union_type",
  [sym_intersection_type] = "intersection_type",
  [sym_function_type] = "function_type",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_export_clause_repeat1] = "export_clause_repeat1",
  [aux_sym_named_imports_repeat1] = "named_imports_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_object_pattern_repeat1] = "object_pattern_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_array_pattern_repeat1] = "array_pattern_repeat1",
  [aux_sym_sequence_expression_repeat1] = "sequence_expression_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_string_repeat1] = "template_string_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [aux_sym_extends_clause_repeat1] = "extends_clause_repeat1",
  [aux_sym_implements_clause_repeat1] = "implements_clause_repeat1",
  [aux_sym_extends_type_clause_repeat1] = "extends_type_clause_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_template_literal_type_repeat1] = "template_literal_type_repeat1",
  [aux_sym_object_type_repeat1] = "object_type_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [alias_sym_interface_body] = "interface_body",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_shorthand_property_identifier] = "shorthand_property_identifier",
  [alias_sym_shorthand_property_identifier_pattern] = "shorthand_property_identifier_pattern",
  [alias_sym_statement_identifier] = "statement_identifier",
  [alias_sym_this_type] = "this_type",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_namespace] = anon_sym_namespace,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_debugger] = anon_sym_debugger,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_QMARK_DOT] = anon_sym_QMARK_DOT,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_using] = anon_sym_using,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_AMP_AMP_EQ] = anon_sym_AMP_AMP_EQ,
  [anon_sym_PIPE_PIPE_EQ] = anon_sym_PIPE_PIPE_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym_unescaped_double_string_fragment] = sym__template_chars,
  [sym_unescaped_single_string_fragment] = sym__template_chars,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_comment] = sym_comment,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [sym_number] = sym_number,
  [sym_private_property_identifier] = sym_private_property_identifier,
  [anon_sym_target] = anon_sym_target,
  [anon_sym_meta] = anon_sym_meta,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_undefined] = sym_undefined,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_readonly] = anon_sym_readonly,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_declare] = anon_sym_declare,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_any] = anon_sym_any,
  [anon_sym_number] = anon_sym_number,
  [anon_sym_boolean] = anon_sym_boolean,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_symbol] = anon_sym_symbol,
  [anon_sym_object] = anon_sym_object,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_accessor] = anon_sym_accessor,
  [anon_sym_satisfies] = anon_sym_satisfies,
  [anon_sym_require] = anon_sym_require,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_DASH_QMARK_COLON] = anon_sym_DASH_QMARK_COLON,
  [anon_sym_PLUS_QMARK_COLON] = anon_sym_PLUS_QMARK_COLON,
  [anon_sym_QMARK_COLON] = anon_sym_QMARK_COLON,
  [anon_sym_asserts] = anon_sym_asserts,
  [anon_sym_infer] = anon_sym_infer,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_keyof] = anon_sym_keyof,
  [anon_sym_unique] = anon_sym_unique,
  [anon_sym_unknown] = anon_sym_unknown,
  [anon_sym_never] = anon_sym_never,
  [anon_sym_LBRACE_PIPE] = anon_sym_LBRACE_PIPE,
  [anon_sym_PIPE_RBRACE] = anon_sym_PIPE_RBRACE,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars] = sym__template_chars,
  [sym__ternary_qmark] = anon_sym_QMARK,
  [sym_html_comment] = sym_html_comment,
  [sym_jsx_text] = sym_jsx_text,
  [sym__function_signature_automatic_semicolon] = sym__function_signature_automatic_semicolon,
  [sym___error_recovery] = sym___error_recovery,
  [sym_program] = sym_program,
  [sym_export_statement] = sym_export_statement,
  [sym_namespace_export] = sym_namespace_export,
  [sym_export_clause] = sym_export_clause,
  [sym_export_specifier] = sym_export_specifier,
  [sym__module_export_name] = sym__module_export_name,
  [sym_declaration] = sym_declaration,
  [sym_import] = sym_import,
  [sym_import_statement] = sym_import_statement,
  [sym_import_clause] = sym_import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym_namespace_import] = sym_namespace_import,
  [sym_named_imports] = sym_named_imports,
  [sym_import_specifier] = sym_import_specifier,
  [sym_import_attribute] = sym_import_attribute,
  [sym_statement] = sym_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_lexical_declaration] = sym_lexical_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_statement_block] = sym_statement_block,
  [sym_else_clause] = sym_else_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__for_header] = sym__for_header,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_debugger_statement] = sym_debugger_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_object] = sym_object,
  [sym_object_pattern] = sym_object_pattern,
  [sym_assignment_pattern] = sym_assignment_pattern,
  [sym_object_assignment_pattern] = sym_object_assignment_pattern,
  [sym_array] = sym_array,
  [sym_array_pattern] = sym_array_pattern,
  [sym_nested_identifier] = sym_nested_identifier,
  [sym_class] = sym_class,
  [sym_class_declaration] = sym_class_declaration,
  [sym_class_heritage] = sym_class_heritage,
  [sym_function_expression] = sym_function_expression,
  [sym_function_declaration] = sym_function_declaration,
  [sym_generator_function] = sym_generator_function,
  [sym_generator_function_declaration] = sym_generator_function_declaration,
  [sym_arrow_function] = sym_arrow_function,
  [sym__call_signature] = sym__call_signature,
  [sym__formal_parameter] = sym__formal_parameter,
  [sym_optional_chain] = sym_optional_chain,
  [sym_call_expression] = sym_call_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym__augmented_assignment_lhs] = sym__augmented_assignment_lhs,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym__initializer] = sym__initializer,
  [sym__destructuring_pattern] = sym__destructuring_pattern,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_sequence_expression] = sym_sequence_expression,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_substitution] = sym_template_substitution,
  [sym_regex] = sym_regex,
  [sym_meta_property] = sym_meta_property,
  [sym_arguments] = sym_arguments,
  [sym_decorator] = sym_decorator,
  [sym_decorator_member_expression] = sym_member_expression,
  [sym_decorator_call_expression] = sym_call_expression,
  [sym_class_body] = sym_class_body,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_class_static_block] = sym_class_static_block,
  [sym_pattern] = sym_pattern,
  [sym_rest_pattern] = sym_rest_pattern,
  [sym_method_definition] = sym_method_definition,
  [sym_pair] = sym_pair,
  [sym_pair_pattern] = sym_pair_pattern,
  [sym__property_name] = sym__property_name,
  [sym_computed_property_name] = sym_computed_property_name,
  [sym_public_field_definition] = sym_public_field_definition,
  [sym__import_identifier] = sym__import_identifier,
  [sym_non_null_expression] = sym_non_null_expression,
  [sym_method_signature] = sym_method_signature,
  [sym_abstract_method_signature] = sym_abstract_method_signature,
  [sym_function_signature] = sym_function_signature,
  [sym_decorator_parenthesized_expression] = sym_parenthesized_expression,
  [sym_type_assertion] = sym_type_assertion,
  [sym_as_expression] = sym_as_expression,
  [sym_satisfies_expression] = sym_satisfies_expression,
  [sym_instantiation_expression] = sym_instantiation_expression,
  [sym_import_require_clause] = sym_import_require_clause,
  [sym_extends_clause] = sym_extends_clause,
  [sym__extends_clause_single] = sym__extends_clause_single,
  [sym_implements_clause] = sym_implements_clause,
  [sym_ambient_declaration] = sym_ambient_declaration,
  [sym_abstract_class_declaration] = sym_abstract_class_declaration,
  [sym_module] = sym_module,
  [sym_internal_module] = sym_internal_module,
  [sym__module] = sym__module,
  [sym_import_alias] = sym_import_alias,
  [sym_nested_type_identifier] = sym_nested_type_identifier,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_extends_type_clause] = sym_extends_type_clause,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_assignment] = sym_enum_assignment,
  [sym_type_alias_declaration] = sym_type_alias_declaration,
  [sym_accessibility_modifier] = sym_accessibility_modifier,
  [sym_override_modifier] = sym_override_modifier,
  [sym_required_parameter] = sym_required_parameter,
  [sym_optional_parameter] = sym_optional_parameter,
  [sym__parameter_name] = sym__parameter_name,
  [sym_omitting_type_annotation] = sym_omitting_type_annotation,
  [sym_adding_type_annotation] = sym_adding_type_annotation,
  [sym_opting_type_annotation] = sym_opting_type_annotation,
  [sym_type_annotation] = sym_type_annotation,
  [sym__type_query_member_expression_in_type_annotation] = sym_member_expression,
  [sym__type_query_call_expression_in_type_annotation] = sym_call_expression,
  [sym_asserts] = sym_asserts,
  [sym_asserts_annotation] = sym_asserts_annotation,
  [sym_type] = sym_type,
  [sym_tuple_parameter] = sym_required_parameter,
  [sym_optional_tuple_parameter] = sym_optional_parameter,
  [sym_optional_type] = sym_optional_type,
  [sym_rest_type] = sym_rest_type,
  [sym__tuple_type_member] = sym__tuple_type_member,
  [sym_constructor_type] = sym_constructor_type,
  [sym_primary_type] = sym_primary_type,
  [sym_template_type] = sym_template_type,
  [sym_template_literal_type] = sym_template_literal_type,
  [sym_infer_type] = sym_infer_type,
  [sym_conditional_type] = sym_conditional_type,
  [sym_generic_type] = sym_generic_type,
  [sym_type_predicate] = sym_type_predicate,
  [sym_type_predicate_annotation] = sym_type_predicate_annotation,
  [sym__type_query_member_expression] = sym_member_expression,
  [sym__type_query_subscript_expression] = sym_subscript_expression,
  [sym__type_query_call_expression] = sym_call_expression,
  [sym__type_query_instantiation_expression] = sym_instantiation_expression,
  [sym_type_query] = sym_type_query,
  [sym_index_type_query] = sym_index_type_query,
  [sym_lookup_type] = sym_lookup_type,
  [sym_mapped_type_clause] = sym_mapped_type_clause,
  [sym_literal_type] = sym_literal_type,
  [sym__number] = sym_unary_expression,
  [sym_existential_type] = sym_existential_type,
  [sym_flow_maybe_type] = sym_flow_maybe_type,
  [sym_parenthesized_type] = sym_parenthesized_type,
  [sym_predefined_type] = sym_predefined_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_object_type] = sym_object_type,
  [sym_call_signature] = sym_call_signature,
  [sym_property_signature] = sym_property_signature,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_default_type] = sym_default_type,
  [sym_constraint] = sym_constraint,
  [sym_construct_signature] = sym_construct_signature,
  [sym_index_signature] = sym_index_signature,
  [sym_array_type] = sym_array_type,
  [sym_tuple_type] = sym_tuple_type,
  [sym_readonly_type] = sym_readonly_type,
  [sym_union_type] = sym_union_type,
  [sym_intersection_type] = sym_intersection_type,
  [sym_function_type] = sym_function_type,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_export_clause_repeat1] = aux_sym_export_clause_repeat1,
  [aux_sym_named_imports_repeat1] = aux_sym_named_imports_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_object_pattern_repeat1] = aux_sym_object_pattern_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_array_pattern_repeat1] = aux_sym_array_pattern_repeat1,
  [aux_sym_sequence_expression_repeat1] = aux_sym_sequence_expression_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_string_repeat1] = aux_sym_template_string_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [aux_sym_extends_clause_repeat1] = aux_sym_extends_clause_repeat1,
  [aux_sym_implements_clause_repeat1] = aux_sym_implements_clause_repeat1,
  [aux_sym_extends_type_clause_repeat1] = aux_sym_extends_type_clause_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_template_literal_type_repeat1] = aux_sym_template_literal_type_repeat1,
  [aux_sym_object_type_repeat1] = aux_sym_object_type_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [alias_sym_interface_body] = alias_sym_interface_body,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_shorthand_property_identifier] = alias_sym_shorthand_property_identifier,
  [alias_sym_shorthand_property_identifier_pattern] = alias_sym_shorthand_property_identifier_pattern,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
  [alias_sym_this_type] = alias_sym_this_type,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debugger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_using] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_single_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_private_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_meta] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_undefined] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_declare] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_any] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_number] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_boolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_symbol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_object] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_accessor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_satisfies] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_require] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asserts] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_infer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_keyof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unique] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unknown] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_never] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = true,
    .named = true,
  },
  [sym__ternary_qmark] = {
    .visible = true,
    .named = false,
  },
  [sym_html_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_text] = {
    .visible = true,
    .named = true,
  },
  [sym__function_signature_automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym___error_recovery] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_export] = {
    .visible = true,
    .named = true,
  },
  [sym_export_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_export_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym__module_export_name] = {
    .visible = false,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace_import] = {
    .visible = true,
    .named = true,
  },
  [sym_named_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_import_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_import_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lexical_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_header] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debugger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_object_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_object_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_function_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_function] = {
    .visible = true,
    .named = true,
  },
  [sym__call_signature] = {
    .visible = false,
    .named = true,
  },
  [sym__formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_optional_chain] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__augmented_assignment_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__initializer] = {
    .visible = false,
    .named = true,
  },
  [sym__destructuring_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_property] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_class_static_block] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_rest_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_pair_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym_computed_property_name] = {
    .visible = true,
    .named = true,
  },
  [sym_public_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__import_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_non_null_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_function_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_assertion] = {
    .visible = true,
    .named = true,
  },
  [sym_as_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_satisfies_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_instantiation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_import_require_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__extends_clause_single] = {
    .visible = false,
    .named = true,
  },
  [sym_implements_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_ambient_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_internal_module] = {
    .visible = true,
    .named = true,
  },
  [sym__module] = {
    .visible = false,
    .named = true,
  },
  [sym_import_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_type_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_accessibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_override_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_required_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_name] = {
    .visible = false,
    .named = true,
  },
  [sym_omitting_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_adding_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_opting_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_member_expression_in_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_call_expression_in_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_asserts] = {
    .visible = true,
    .named = true,
  },
  [sym_asserts_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_tuple_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_tuple_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_rest_type] = {
    .visible = true,
    .named = true,
  },
  [sym__tuple_type_member] = {
    .visible = false,
    .named = true,
  },
  [sym_constructor_type] = {
    .visible = true,
    .named = true,
  },
  [sym_primary_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_template_type] = {
    .visible = true,
    .named = true,
  },
  [sym_template_literal_type] = {
    .visible = true,
    .named = true,
  },
  [sym_infer_type] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_predicate] = {
    .visible = true,
    .named = true,
  },
  [sym_type_predicate_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_instantiation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_index_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_lookup_type] = {
    .visible = true,
    .named = true,
  },
  [sym_mapped_type_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_type] = {
    .visible = true,
    .named = true,
  },
  [sym__number] = {
    .visible = true,
    .named = true,
  },
  [sym_existential_type] = {
    .visible = true,
    .named = true,
  },
  [sym_flow_maybe_type] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type] = {
    .visible = true,
    .named = true,
  },
  [sym_predefined_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_object_type] = {
    .visible = true,
    .named = true,
  },
  [sym_call_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_property_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_default_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_construct_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_index_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_readonly_type] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_intersection_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sequence_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_implements_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_type_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_literal_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_interface_body] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_this_type] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_body = 5,
  field_condition = 6,
  field_consequence = 7,
  field_constraint = 8,
  field_constructor = 9,
  field_declaration = 10,
  field_decorator = 11,
  field_finalizer = 12,
  field_flags = 13,
  field_function = 14,
  field_handler = 15,
  field_increment = 16,
  field_index = 17,
  field_index_type = 18,
  field_initializer = 19,
  field_key = 20,
  field_kind = 21,
  field_label = 22,
  field_left = 23,
  field_module = 24,
  field_name = 25,
  field_object = 26,
  field_operator = 27,
  field_optional_chain = 28,
  field_parameter = 29,
  field_parameters = 30,
  field_pattern = 31,
  field_property = 32,
  field_return_type = 33,
  field_right = 34,
  field_sign = 35,
  field_source = 36,
  field_type = 37,
  field_type_arguments = 38,
  field_type_parameters = 39,
  field_value = 40,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constraint] = "constraint",
  [field_constructor] = "constructor",
  [field_declaration] = "declaration",
  [field_decorator] = "decorator",
  [field_finalizer] = "finalizer",
  [field_flags] = "flags",
  [field_function] = "function",
  [field_handler] = "handler",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_index_type] = "index_type",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_kind] = "kind",
  [field_label] = "label",
  [field_left] = "left",
  [field_module] = "module",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_optional_chain] = "optional_chain",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_sign] = "sign",
  [field_source] = "source",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [5] = {.index = 3, .length = 1},
  [6] = {.index = 4, .length = 2},
  [8] = {.index = 6, .length = 2},
  [9] = {.index = 8, .length = 1},
  [10] = {.index = 9, .length = 2},
  [11] = {.index = 11, .length = 1},
  [12] = {.index = 12, .length = 1},
  [14] = {.index = 3, .length = 1},
  [16] = {.index = 13, .length = 2},
  [17] = {.index = 15, .length = 2},
  [18] = {.index = 17, .length = 2},
  [19] = {.index = 19, .length = 2},
  [20] = {.index = 21, .length = 2},
  [21] = {.index = 23, .length = 1},
  [22] = {.index = 24, .length = 2},
  [23] = {.index = 26, .length = 2},
  [24] = {.index = 28, .length = 2},
  [25] = {.index = 30, .length = 1},
  [26] = {.index = 31, .length = 2},
  [27] = {.index = 33, .length = 2},
  [28] = {.index = 35, .length = 2},
  [29] = {.index = 37, .length = 2},
  [33] = {.index = 39, .length = 1},
  [34] = {.index = 40, .length = 2},
  [35] = {.index = 42, .length = 2},
  [36] = {.index = 44, .length = 2},
  [37] = {.index = 46, .length = 1},
  [38] = {.index = 47, .length = 2},
  [39] = {.index = 49, .length = 2},
  [40] = {.index = 51, .length = 6},
  [41] = {.index = 57, .length = 1},
  [42] = {.index = 58, .length = 3},
  [43] = {.index = 61, .length = 3},
  [44] = {.index = 64, .length = 2},
  [45] = {.index = 66, .length = 2},
  [46] = {.index = 68, .length = 2},
  [47] = {.index = 70, .length = 2},
  [48] = {.index = 72, .length = 1},
  [49] = {.index = 73, .length = 2},
  [50] = {.index = 75, .length = 1},
  [51] = {.index = 76, .length = 2},
  [52] = {.index = 78, .length = 1},
  [53] = {.index = 79, .length = 2},
  [54] = {.index = 81, .length = 4},
  [55] = {.index = 85, .length = 2},
  [56] = {.index = 87, .length = 2},
  [57] = {.index = 89, .length = 3},
  [58] = {.index = 92, .length = 2},
  [59] = {.index = 94, .length = 2},
  [60] = {.index = 96, .length = 2},
  [61] = {.index = 98, .length = 2},
  [62] = {.index = 100, .length = 1},
  [63] = {.index = 101, .length = 2},
  [64] = {.index = 103, .length = 2},
  [65] = {.index = 105, .length = 2},
  [68] = {.index = 101, .length = 2},
  [69] = {.index = 107, .length = 4},
  [70] = {.index = 31, .length = 2},
  [71] = {.index = 35, .length = 2},
  [72] = {.index = 111, .length = 3},
  [73] = {.index = 73, .length = 2},
  [74] = {.index = 73, .length = 2},
  [75] = {.index = 114, .length = 2},
  [76] = {.index = 114, .length = 2},
  [77] = {.index = 116, .length = 3},
  [78] = {.index = 116, .length = 3},
  [79] = {.index = 119, .length = 3},
  [80] = {.index = 122, .length = 2},
  [81] = {.index = 124, .length = 4},
  [82] = {.index = 128, .length = 3},
  [83] = {.index = 131, .length = 2},
  [84] = {.index = 133, .length = 2},
  [85] = {.index = 135, .length = 1},
  [86] = {.index = 136, .length = 1},
  [87] = {.index = 100, .length = 1},
  [88] = {.index = 114, .length = 2},
  [89] = {.index = 31, .length = 2},
  [90] = {.index = 137, .length = 2},
  [91] = {.index = 139, .length = 5},
  [92] = {.index = 144, .length = 1},
  [93] = {.index = 145, .length = 1},
  [94] = {.index = 146, .length = 2},
  [95] = {.index = 148, .length = 3},
  [96] = {.index = 151, .length = 2},
  [97] = {.index = 153, .length = 3},
  [98] = {.index = 156, .length = 6},
  [99] = {.index = 162, .length = 1},
  [100] = {.index = 163, .length = 1},
  [101] = {.index = 164, .length = 3},
  [102] = {.index = 167, .length = 3},
  [103] = {.index = 170, .length = 4},
  [104] = {.index = 174, .length = 2},
  [105] = {.index = 176, .length = 2},
  [106] = {.index = 178, .length = 3},
  [107] = {.index = 181, .length = 4},
  [108] = {.index = 185, .length = 1},
  [109] = {.index = 186, .length = 2},
  [110] = {.index = 188, .length = 1},
  [111] = {.index = 189, .length = 2},
  [112] = {.index = 191, .length = 3},
  [113] = {.index = 194, .length = 2},
  [114] = {.index = 196, .length = 4},
  [115] = {.index = 200, .length = 2},
  [116] = {.index = 202, .length = 2},
  [117] = {.index = 204, .length = 4},
  [118] = {.index = 202, .length = 2},
  [119] = {.index = 208, .length = 4},
  [120] = {.index = 212, .length = 4},
  [121] = {.index = 216, .length = 5},
  [122] = {.index = 221, .length = 3},
  [123] = {.index = 224, .length = 2},
  [124] = {.index = 224, .length = 2},
  [125] = {.index = 226, .length = 2},
  [126] = {.index = 228, .length = 1},
  [127] = {.index = 229, .length = 2},
  [128] = {.index = 231, .length = 4},
  [129] = {.index = 235, .length = 4},
  [130] = {.index = 239, .length = 4},
  [131] = {.index = 243, .length = 2},
  [132] = {.index = 245, .length = 2},
  [133] = {.index = 247, .length = 2},
  [134] = {.index = 249, .length = 3},
  [135] = {.index = 252, .length = 2},
  [136] = {.index = 254, .length = 4},
  [137] = {.index = 254, .length = 4},
  [138] = {.index = 258, .length = 4},
  [139] = {.index = 258, .length = 4},
  [140] = {.index = 151, .length = 2},
  [141] = {.index = 262, .length = 1},
  [142] = {.index = 262, .length = 1},
  [143] = {.index = 189, .length = 2},
  [144] = {.index = 191, .length = 3},
  [145] = {.index = 263, .length = 2},
  [146] = {.index = 265, .length = 3},
  [147] = {.index = 268, .length = 2},
  [148] = {.index = 270, .length = 3},
  [149] = {.index = 273, .length = 2},
  [150] = {.index = 275, .length = 3},
  [151] = {.index = 278, .length = 1},
  [152] = {.index = 279, .length = 2},
  [153] = {.index = 281, .length = 2},
  [154] = {.index = 283, .length = 5},
  [155] = {.index = 279, .length = 2},
  [156] = {.index = 288, .length = 1},
  [157] = {.index = 289, .length = 4},
  [158] = {.index = 293, .length = 2},
  [159] = {.index = 295, .length = 1},
  [160] = {.index = 296, .length = 2},
  [161] = {.index = 298, .length = 2},
  [162] = {.index = 300, .length = 2},
  [163] = {.index = 302, .length = 4},
  [164] = {.index = 306, .length = 2},
  [165] = {.index = 308, .length = 3},
  [166] = {.index = 311, .length = 3},
  [167] = {.index = 314, .length = 3},
  [168] = {.index = 317, .length = 4},
  [169] = {.index = 321, .length = 4},
  [170] = {.index = 325, .length = 4},
  [171] = {.index = 329, .length = 5},
  [172] = {.index = 334, .length = 2},
  [173] = {.index = 336, .length = 2},
  [174] = {.index = 338, .length = 1},
  [175] = {.index = 339, .length = 4},
  [176] = {.index = 339, .length = 4},
  [177] = {.index = 343, .length = 3},
  [178] = {.index = 346, .length = 2},
  [179] = {.index = 348, .length = 3},
  [180] = {.index = 351, .length = 2},
  [181] = {.index = 353, .length = 3},
  [182] = {.index = 356, .length = 2},
  [183] = {.index = 356, .length = 2},
  [184] = {.index = 314, .length = 3},
  [185] = {.index = 358, .length = 3},
  [186] = {.index = 361, .length = 3},
  [187] = {.index = 146, .length = 2},
  [188] = {.index = 364, .length = 2},
  [189] = {.index = 366, .length = 3},
  [190] = {.index = 369, .length = 4},
  [191] = {.index = 373, .length = 3},
  [192] = {.index = 376, .length = 3},
  [193] = {.index = 379, .length = 2},
  [194] = {.index = 381, .length = 3},
  [195] = {.index = 384, .length = 5},
  [196] = {.index = 379, .length = 2},
  [197] = {.index = 389, .length = 3},
  [198] = {.index = 389, .length = 3},
  [199] = {.index = 392, .length = 3},
  [200] = {.index = 395, .length = 2},
  [201] = {.index = 397, .length = 4},
  [202] = {.index = 146, .length = 2},
  [203] = {.index = 401, .length = 1},
  [204] = {.index = 402, .length = 2},
  [205] = {.index = 404, .length = 2},
  [206] = {.index = 406, .length = 2},
  [207] = {.index = 408, .length = 2},
  [208] = {.index = 410, .length = 3},
  [209] = {.index = 413, .length = 1},
  [210] = {.index = 414, .length = 3},
  [211] = {.index = 417, .length = 2},
  [212] = {.index = 419, .length = 3},
  [213] = {.index = 422, .length = 3},
  [214] = {.index = 425, .length = 3},
  [215] = {.index = 428, .length = 3},
  [216] = {.index = 431, .length = 4},
  [217] = {.index = 435, .length = 5},
  [218] = {.index = 440, .length = 3},
  [219] = {.index = 443, .length = 2},
  [220] = {.index = 445, .length = 2},
  [221] = {.index = 447, .length = 4},
  [222] = {.index = 451, .length = 4},
  [223] = {.index = 455, .length = 4},
  [224] = {.index = 459, .length = 3},
  [225] = {.index = 462, .length = 2},
  [226] = {.index = 464, .length = 3},
  [227] = {.index = 467, .length = 2},
  [228] = {.index = 469, .length = 2},
  [229] = {.index = 471, .length = 2},
  [230] = {.index = 473, .length = 1},
  [231] = {.index = 474, .length = 4},
  [232] = {.index = 478, .length = 3},
  [233] = {.index = 481, .length = 4},
  [234] = {.index = 485, .length = 5},
  [235] = {.index = 490, .length = 1},
  [236] = {.index = 491, .length = 2},
  [237] = {.index = 493, .length = 4},
  [238] = {.index = 497, .length = 4},
  [239] = {.index = 501, .length = 4},
  [240] = {.index = 505, .length = 3},
  [241] = {.index = 508, .length = 2},
  [242] = {.index = 510, .length = 4},
  [243] = {.index = 514, .length = 4},
  [244] = {.index = 518, .length = 2},
  [245] = {.index = 520, .length = 2},
  [246] = {.index = 522, .length = 3},
  [247] = {.index = 525, .length = 3},
  [248] = {.index = 528, .length = 2},
  [249] = {.index = 530, .length = 2},
  [250] = {.index = 532, .length = 1},
  [251] = {.index = 533, .length = 1},
  [252] = {.index = 534, .length = 3},
  [253] = {.index = 537, .length = 3},
  [254] = {.index = 540, .length = 3},
  [255] = {.index = 543, .length = 3},
  [256] = {.index = 546, .length = 4},
  [257] = {.index = 550, .length = 2},
  [258] = {.index = 552, .length = 4},
  [259] = {.index = 556, .length = 3},
  [260] = {.index = 559, .length = 2},
  [261] = {.index = 561, .length = 4},
  [262] = {.index = 565, .length = 4},
  [263] = {.index = 569, .length = 4},
  [264] = {.index = 573, .length = 3},
  [266] = {.index = 576, .length = 4},
  [267] = {.index = 580, .length = 5},
  [268] = {.index = 585, .length = 5},
  [269] = {.index = 590, .length = 5},
  [270] = {.index = 595, .length = 4},
  [271] = {.index = 599, .length = 5},
  [272] = {.index = 604, .length = 4},
  [273] = {.index = 608, .length = 4},
  [274] = {.index = 612, .length = 3},
  [275] = {.index = 615, .length = 3},
  [276] = {.index = 618, .length = 3},
  [277] = {.index = 615, .length = 3},
  [278] = {.index = 621, .length = 2},
  [279] = {.index = 623, .length = 4},
  [280] = {.index = 627, .length = 4},
  [281] = {.index = 631, .length = 3},
  [282] = {.index = 634, .length = 2},
  [283] = {.index = 636, .length = 2},
  [284] = {.index = 638, .length = 3},
  [285] = {.index = 641, .length = 2},
  [286] = {.index = 643, .length = 2},
  [287] = {.index = 645, .length = 1},
  [288] = {.index = 646, .length = 3},
  [289] = {.index = 649, .length = 3},
  [290] = {.index = 652, .length = 4},
  [291] = {.index = 656, .length = 4},
  [292] = {.index = 660, .length = 3},
  [293] = {.index = 663, .length = 3},
  [294] = {.index = 666, .length = 2},
  [295] = {.index = 668, .length = 4},
  [296] = {.index = 672, .length = 5},
  [297] = {.index = 677, .length = 5},
  [298] = {.index = 682, .length = 5},
  [299] = {.index = 687, .length = 4},
  [300] = {.index = 691, .length = 4},
  [301] = {.index = 695, .length = 3},
  [302] = {.index = 698, .length = 3},
  [303] = {.index = 698, .length = 3},
  [304] = {.index = 701, .length = 2},
  [305] = {.index = 703, .length = 2},
  [306] = {.index = 705, .length = 3},
  [307] = {.index = 708, .length = 2},
  [308] = {.index = 710, .length = 2},
  [309] = {.index = 712, .length = 4},
  [310] = {.index = 716, .length = 3},
  [311] = {.index = 719, .length = 3},
  [312] = {.index = 722, .length = 4},
  [313] = {.index = 726, .length = 3},
  [314] = {.index = 729, .length = 3},
  [315] = {.index = 732, .length = 2},
  [316] = {.index = 734, .length = 5},
  [317] = {.index = 739, .length = 5},
  [318] = {.index = 744, .length = 4},
  [319] = {.index = 744, .length = 4},
  [320] = {.index = 748, .length = 4},
  [321] = {.index = 752, .length = 3},
  [322] = {.index = 755, .length = 2},
  [323] = {.index = 757, .length = 2},
  [324] = {.index = 759, .length = 3},
  [325] = {.index = 762, .length = 4},
  [326] = {.index = 766, .length = 4},
  [327] = {.index = 770, .length = 3},
  [328] = {.index = 773, .length = 3},
  [329] = {.index = 776, .length = 4},
  [330] = {.index = 780, .length = 3},
  [331] = {.index = 783, .length = 3},
  [332] = {.index = 786, .length = 5},
  [333] = {.index = 791, .length = 3},
  [334] = {.index = 794, .length = 4},
  [335] = {.index = 798, .length = 4},
  [336] = {.index = 802, .length = 3},
  [337] = {.index = 805, .length = 3},
  [338] = {.index = 808, .length = 4},
  [339] = {.index = 812, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_decorator, 0},
  [1] =
    {field_parameters, 0},
  [2] =
    {field_declaration, 1},
  [3] =
    {field_name, 0},
  [4] =
    {field_body, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [6] =
    {field_argument, 1},
    {field_operator, 0},
  [8] =
    {field_pattern, 0},
  [9] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
  [11] =
    {field_body, 1},
  [12] =
    {field_constructor, 1},
  [13] =
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [15] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
  [17] =
    {field_argument, 0, .inherited = true},
    {field_operator, 0, .inherited = true},
  [19] =
    {field_arguments, 1},
    {field_function, 0},
  [21] =
    {field_argument, 0},
    {field_operator, 1},
  [23] =
    {field_type_arguments, 1},
  [24] =
    {field_parameters, 0},
    {field_return_type, 1},
  [26] =
    {field_parameters, 1},
    {field_type_parameters, 0},
  [28] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
  [30] =
    {field_declaration, 2},
  [31] =
    {field_left, 0},
    {field_right, 2},
  [33] =
    {field_body, 2},
    {field_label, 0},
  [35] =
    {field_body, 2},
    {field_parameter, 0},
  [37] =
    {field_body, 1},
    {field_name, 0},
  [39] =
    {field_source, 1},
  [40] =
    {field_body, 2},
    {field_object, 1},
  [42] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [44] =
    {field_name, 0},
    {field_type, 1},
  [46] =
    {field_kind, 0},
  [47] =
    {field_condition, 1},
    {field_consequence, 2},
  [49] =
    {field_body, 2},
    {field_value, 1},
  [51] =
    {field_body, 2},
    {field_kind, 1, .inherited = true},
    {field_left, 1, .inherited = true},
    {field_operator, 1, .inherited = true},
    {field_right, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [57] =
    {field_pattern, 1},
  [58] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [61] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 1},
  [64] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 1},
  [66] =
    {field_body, 2},
    {field_condition, 1},
  [68] =
    {field_body, 1},
    {field_handler, 2},
  [70] =
    {field_body, 1},
    {field_finalizer, 2},
  [72] =
    {field_label, 1},
  [73] =
    {field_body, 2},
    {field_name, 1},
  [75] =
    {field_value, 0},
  [76] =
    {field_type_arguments, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [78] =
    {field_body, 2},
  [79] =
    {field_body, 2},
    {field_type_parameters, 1},
  [81] =
    {field_body, 2},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [85] =
    {field_arguments, 2},
    {field_constructor, 1},
  [87] =
    {field_constructor, 1},
    {field_type_arguments, 2},
  [89] =
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [92] =
    {field_object, 1, .inherited = true},
    {field_property, 1, .inherited = true},
  [94] =
    {field_index, 1, .inherited = true},
    {field_object, 1, .inherited = true},
  [96] =
    {field_arguments, 1, .inherited = true},
    {field_function, 1, .inherited = true},
  [98] =
    {field_function, 1, .inherited = true},
    {field_type_arguments, 1, .inherited = true},
  [100] =
    {field_name, 1},
  [101] =
    {field_name, 0},
    {field_type_arguments, 1},
  [103] =
    {field_name, 0},
    {field_value, 1},
  [105] =
    {field_constraint, 1},
    {field_name, 0},
  [107] =
    {field_arguments, 1},
    {field_function, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [111] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [114] =
    {field_object, 0},
    {field_property, 2},
  [116] =
    {field_object, 0},
    {field_optional_chain, 1},
    {field_property, 2},
  [119] =
    {field_arguments, 2},
    {field_function, 0},
    {field_type_arguments, 1},
  [122] =
    {field_arguments, 2},
    {field_function, 0},
  [124] =
    {field_body, 2},
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [128] =
    {field_parameters, 1},
    {field_return_type, 2},
    {field_type_parameters, 0},
  [131] =
    {field_declaration, 2},
    {field_decorator, 0, .inherited = true},
  [133] =
    {field_body, 2},
    {field_decorator, 0, .inherited = true},
  [135] =
    {field_source, 2, .inherited = true},
  [136] =
    {field_value, 2},
  [137] =
    {field_key, 0},
    {field_value, 2},
  [139] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [144] =
    {field_source, 2},
  [145] =
    {field_value, 1},
  [146] =
    {field_name, 0},
    {field_type, 2},
  [148] =
    {field_name, 0},
    {field_type, 1},
    {field_value, 2, .inherited = true},
  [151] =
    {field_body, 3},
    {field_name, 2},
  [153] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [156] =
    {field_body, 3},
    {field_kind, 2, .inherited = true},
    {field_left, 2, .inherited = true},
    {field_operator, 2, .inherited = true},
    {field_right, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [162] =
    {field_type, 2},
  [163] =
    {field_pattern, 2},
  [164] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_value, 2, .inherited = true},
  [167] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 2},
  [170] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 1},
    {field_value, 2, .inherited = true},
  [174] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 2},
  [176] =
    {field_body, 1},
    {field_condition, 3},
  [178] =
    {field_body, 1},
    {field_finalizer, 3},
    {field_handler, 2},
  [181] =
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [185] =
    {field_decorator, 0, .inherited = true},
  [186] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
  [188] =
    {field_decorator, 1, .inherited = true},
  [189] =
    {field_body, 3},
    {field_name, 1},
  [191] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [194] =
    {field_type_arguments, 1},
    {field_value, 0},
  [196] =
    {field_type_arguments, 1, .inherited = true},
    {field_type_arguments, 2, .inherited = true},
    {field_value, 1, .inherited = true},
    {field_value, 2, .inherited = true},
  [200] =
    {field_body, 3},
    {field_type_parameters, 1},
  [202] =
    {field_body, 3},
    {field_parameter, 1},
  [204] =
    {field_body, 3},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [208] =
    {field_body, 3},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [212] =
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [216] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [221] =
    {field_arguments, 3},
    {field_constructor, 1},
    {field_type_arguments, 2},
  [224] =
    {field_left, 1},
    {field_right, 3},
  [226] =
    {field_flags, 3},
    {field_pattern, 1},
  [228] =
    {field_parameters, 1},
  [229] =
    {field_function, 0},
    {field_type_arguments, 1},
  [231] =
    {field_function, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
    {field_type_arguments, 1},
  [235] =
    {field_arguments, 1},
    {field_function, 0},
    {field_index, 0, .inherited = true},
    {field_object, 0, .inherited = true},
  [239] =
    {field_function, 0},
    {field_index, 0, .inherited = true},
    {field_object, 0, .inherited = true},
    {field_type_arguments, 1},
  [243] =
    {field_name, 1},
    {field_value, 2},
  [245] =
    {field_constraint, 2},
    {field_name, 1},
  [247] =
    {field_module, 0},
    {field_name, 2},
  [249] =
    {field_constraint, 1},
    {field_name, 0},
    {field_value, 2},
  [252] =
    {field_parameters, 0},
    {field_return_type, 2},
  [254] =
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
    {field_property, 2},
  [258] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_object, 0},
    {field_property, 2},
  [262] =
    {field_type, 1},
  [263] =
    {field_index, 2},
    {field_object, 0},
  [265] =
    {field_arguments, 3},
    {field_function, 0},
    {field_type_arguments, 2},
  [268] =
    {field_declaration, 3},
    {field_decorator, 0, .inherited = true},
  [270] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [273] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
  [275] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [278] =
    {field_source, 3, .inherited = true},
  [279] =
    {field_alias, 2},
    {field_name, 0},
  [281] =
    {field_name, 1},
    {field_value, 3},
  [283] =
    {field_body, 3},
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [288] =
    {field_pattern, 3},
  [289] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [293] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 3},
  [295] =
    {field_name, 2},
  [296] =
    {field_name, 1},
    {field_value, 2, .inherited = true},
  [298] =
    {field_name, 1},
    {field_type, 2},
  [300] =
    {field_name, 0},
    {field_value, 2, .inherited = true},
  [302] =
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [306] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [308] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_value, 2, .inherited = true},
  [311] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 2},
  [314] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [317] =
    {field_type_arguments, 0, .inherited = true},
    {field_type_arguments, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [321] =
    {field_body, 4},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [325] =
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [329] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [334] =
    {field_parameters, 1},
    {field_type, 2},
  [336] =
    {field_parameters, 2},
    {field_type_parameters, 1},
  [338] =
    {field_parameters, 2},
  [339] =
    {field_index, 0, .inherited = true},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 2},
  [343] =
    {field_constraint, 2},
    {field_name, 1},
    {field_value, 3},
  [346] =
    {field_parameters, 1},
    {field_type, 3},
  [348] =
    {field_parameters, 1},
    {field_return_type, 3},
    {field_type_parameters, 0},
  [351] =
    {field_body, 4},
    {field_name, 2},
  [353] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [356] =
    {field_type, 1},
    {field_type, 2, .inherited = true},
  [358] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [361] =
    {field_index, 3},
    {field_object, 0},
    {field_optional_chain, 1},
  [364] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3},
  [366] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [369] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [373] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [376] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [379] =
    {field_alias, 3},
    {field_name, 1},
  [381] =
    {field_name, 1},
    {field_type_parameters, 2},
    {field_value, 4},
  [384] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [389] =
    {field_left, 1},
    {field_operator, 2},
    {field_right, 3},
  [392] =
    {field_body, 5},
    {field_condition, 3},
    {field_initializer, 2},
  [395] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 4},
  [397] =
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [401] =
    {field_type, 3},
  [402] =
    {field_name, 2},
    {field_value, 3, .inherited = true},
  [404] =
    {field_name, 2},
    {field_type, 3},
  [406] =
    {field_name, 1},
    {field_value, 3, .inherited = true},
  [408] =
    {field_name, 1},
    {field_type, 3},
  [410] =
    {field_name, 1},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [413] =
    {field_name, 3},
  [414] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [417] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [419] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_value, 3, .inherited = true},
  [422] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 3},
  [425] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_value, 3, .inherited = true},
  [428] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 3},
  [431] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [435] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [440] =
    {field_parameters, 2},
    {field_type, 3},
    {field_type_parameters, 1},
  [443] =
    {field_parameters, 2},
    {field_type, 3},
  [445] =
    {field_parameters, 3},
    {field_type_parameters, 2},
  [447] =
    {field_index, 2},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [451] =
    {field_index, 0, .inherited = true},
    {field_index, 2},
    {field_object, 0},
    {field_object, 0, .inherited = true},
  [455] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_index, 2},
    {field_object, 0},
  [459] =
    {field_parameters, 2},
    {field_type, 4},
    {field_type_parameters, 1},
  [462] =
    {field_parameters, 2},
    {field_type, 4},
  [464] =
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [467] =
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [469] =
    {field_name, 1},
    {field_name, 2, .inherited = true},
  [471] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [473] =
    {field_name, 2, .inherited = true},
  [474] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [478] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [481] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type_parameters, 4},
  [485] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [490] =
    {field_source, 4},
  [491] =
    {field_body, 3},
    {field_value, 1},
  [493] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 3},
    {field_right, 4},
  [497] =
    {field_body, 6},
    {field_condition, 3},
    {field_increment, 4},
    {field_initializer, 2},
  [501] =
    {field_body, 6},
    {field_condition, 3},
    {field_condition, 4},
    {field_initializer, 2},
  [505] =
    {field_body, 6},
    {field_condition, 4},
    {field_initializer, 2},
  [508] =
    {field_body, 4},
    {field_parameter, 2},
  [510] =
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [514] =
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [518] =
    {field_name, 2},
    {field_value, 4, .inherited = true},
  [520] =
    {field_name, 2},
    {field_type, 4},
  [522] =
    {field_name, 2},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [525] =
    {field_name, 1},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [528] =
    {field_name, 3},
    {field_value, 4, .inherited = true},
  [530] =
    {field_name, 3},
    {field_type, 4},
  [532] =
    {field_type, 4},
  [533] =
    {field_name, 4},
  [534] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_value, 4, .inherited = true},
  [537] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 4},
  [540] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_value, 4, .inherited = true},
  [543] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 4},
  [546] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [550] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
  [552] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [556] =
    {field_parameters, 3},
    {field_type, 4},
    {field_type_parameters, 2},
  [559] =
    {field_index, 3},
    {field_object, 0},
  [561] =
    {field_index, 3},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [565] =
    {field_index, 0, .inherited = true},
    {field_index, 3},
    {field_object, 0},
    {field_object, 0, .inherited = true},
  [569] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_index, 3},
    {field_object, 0},
  [573] =
    {field_parameters, 3},
    {field_type, 5},
    {field_type_parameters, 2},
  [576] =
    {field_body, 6},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type_parameters, 4},
  [580] =
    {field_body, 6},
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [585] =
    {field_body, 6},
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [590] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 4},
    {field_right, 5},
    {field_value, 3, .inherited = true},
  [595] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 4},
    {field_right, 5},
  [599] =
    {field_body, 7},
    {field_condition, 3},
    {field_condition, 4},
    {field_increment, 5},
    {field_initializer, 2},
  [604] =
    {field_body, 7},
    {field_condition, 4},
    {field_increment, 5},
    {field_initializer, 2},
  [608] =
    {field_body, 7},
    {field_condition, 4},
    {field_condition, 5},
    {field_initializer, 2},
  [612] =
    {field_body, 5},
    {field_parameter, 2},
    {field_type, 3},
  [615] =
    {field_index_type, 3},
    {field_name, 1},
    {field_type, 5},
  [618] =
    {field_alias, 4},
    {field_name, 0},
    {field_type, 2},
  [621] =
    {field_sign, 0},
    {field_type, 5},
  [623] =
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [627] =
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [631] =
    {field_name, 2},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [634] =
    {field_name, 3},
    {field_value, 5, .inherited = true},
  [636] =
    {field_name, 3},
    {field_type, 5},
  [638] =
    {field_name, 3},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [641] =
    {field_name, 4},
    {field_value, 5, .inherited = true},
  [643] =
    {field_name, 4},
    {field_type, 5},
  [645] =
    {field_name, 5},
  [646] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_value, 5, .inherited = true},
  [649] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 5},
  [652] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [656] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [660] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_value, 5, .inherited = true},
  [663] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 5},
  [666] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
  [668] =
    {field_alternative, 6},
    {field_consequence, 4},
    {field_left, 0},
    {field_right, 2},
  [672] =
    {field_body, 7},
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [677] =
    {field_body, 7},
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [682] =
    {field_body, 8},
    {field_condition, 4},
    {field_condition, 5},
    {field_increment, 6},
    {field_initializer, 2},
  [687] =
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [691] =
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [695] =
    {field_name, 3},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [698] =
    {field_index_type, 4},
    {field_name, 2},
    {field_type, 6},
  [701] =
    {field_name, 4},
    {field_value, 6, .inherited = true},
  [703] =
    {field_name, 4},
    {field_type, 6},
  [705] =
    {field_name, 4},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [708] =
    {field_name, 5},
    {field_value, 6, .inherited = true},
  [710] =
    {field_name, 5},
    {field_type, 6},
  [712] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [716] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_value, 6, .inherited = true},
  [719] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 6},
  [722] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [726] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_value, 6, .inherited = true},
  [729] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 6},
  [732] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
  [734] =
    {field_body, 8},
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [739] =
    {field_body, 8},
    {field_name, 6},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [744] =
    {field_index_type, 5},
    {field_name, 3},
    {field_sign, 0},
    {field_type, 7},
  [748] =
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [752] =
    {field_name, 4},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [755] =
    {field_name, 5},
    {field_value, 7, .inherited = true},
  [757] =
    {field_name, 5},
    {field_type, 7},
  [759] =
    {field_name, 5},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [762] =
    {field_name, 6},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [766] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [770] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_value, 7, .inherited = true},
  [773] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 7},
  [776] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [780] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_value, 7, .inherited = true},
  [783] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 7},
  [786] =
    {field_body, 9},
    {field_name, 6},
    {field_parameters, 8, .inherited = true},
    {field_return_type, 8, .inherited = true},
    {field_type_parameters, 8, .inherited = true},
  [791] =
    {field_name, 5},
    {field_type, 7},
    {field_value, 8, .inherited = true},
  [794] =
    {field_name, 6},
    {field_parameters, 8, .inherited = true},
    {field_return_type, 8, .inherited = true},
    {field_type_parameters, 8, .inherited = true},
  [798] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 7},
    {field_value, 8, .inherited = true},
  [802] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_value, 8, .inherited = true},
  [805] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 8},
  [808] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 7},
    {field_value, 8, .inherited = true},
  [812] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 8},
    {field_value, 9, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [7] = {
    [0] = alias_sym_property_identifier,
  },
  [13] = {
    [0] = alias_sym_type_identifier,
  },
  [14] = {
    [0] = alias_sym_type_identifier,
  },
  [15] = {
    [0] = alias_sym_this_type,
  },
  [26] = {
    [0] = sym_identifier,
  },
  [27] = {
    [0] = alias_sym_statement_identifier,
  },
  [28] = {
    [0] = sym_identifier,
  },
  [30] = {
    [1] = alias_sym_shorthand_property_identifier,
  },
  [31] = {
    [1] = alias_sym_shorthand_property_identifier_pattern,
  },
  [32] = {
    [1] = sym_identifier,
  },
  [48] = {
    [1] = alias_sym_statement_identifier,
  },
  [49] = {
    [1] = alias_sym_type_identifier,
  },
  [62] = {
    [1] = alias_sym_type_identifier,
  },
  [63] = {
    [0] = alias_sym_type_identifier,
  },
  [64] = {
    [0] = alias_sym_type_identifier,
  },
  [65] = {
    [0] = alias_sym_type_identifier,
  },
  [66] = {
    [1] = alias_sym_type_identifier,
  },
  [67] = {
    [1] = anon_sym_unique,
  },
  [73] = {
    [1] = alias_sym_type_identifier,
    [2] = alias_sym_interface_body,
  },
  [75] = {
    [2] = alias_sym_property_identifier,
  },
  [77] = {
    [2] = alias_sym_property_identifier,
  },
  [88] = {
    [0] = sym_member_expression,
    [2] = alias_sym_property_identifier,
  },
  [89] = {
    [0] = alias_sym_shorthand_property_identifier_pattern,
  },
  [111] = {
    [1] = alias_sym_type_identifier,
  },
  [112] = {
    [1] = alias_sym_type_identifier,
  },
  [116] = {
    [1] = sym_identifier,
  },
  [123] = {
    [1] = sym_identifier,
  },
  [131] = {
    [1] = alias_sym_type_identifier,
  },
  [132] = {
    [1] = alias_sym_type_identifier,
  },
  [133] = {
    [2] = alias_sym_type_identifier,
  },
  [134] = {
    [0] = alias_sym_type_identifier,
  },
  [136] = {
    [2] = alias_sym_property_identifier,
  },
  [138] = {
    [2] = alias_sym_property_identifier,
  },
  [140] = {
    [2] = alias_sym_type_identifier,
  },
  [141] = {
    [1] = alias_sym_type_identifier,
  },
  [143] = {
    [1] = alias_sym_type_identifier,
    [3] = alias_sym_interface_body,
  },
  [144] = {
    [1] = alias_sym_type_identifier,
    [3] = alias_sym_interface_body,
  },
  [148] = {
    [2] = alias_sym_type_identifier,
  },
  [153] = {
    [1] = alias_sym_type_identifier,
  },
  [155] = {
    [0] = sym_identifier,
  },
  [167] = {
    [1] = alias_sym_type_identifier,
  },
  [175] = {
    [2] = alias_sym_property_identifier,
  },
  [177] = {
    [1] = alias_sym_type_identifier,
  },
  [180] = {
    [2] = alias_sym_type_identifier,
  },
  [181] = {
    [2] = alias_sym_type_identifier,
  },
  [182] = {
    [1] = alias_sym_type_identifier,
  },
  [184] = {
    [1] = alias_sym_type_identifier,
    [4] = alias_sym_interface_body,
  },
  [187] = {
    [0] = sym_identifier,
  },
  [189] = {
    [2] = alias_sym_type_identifier,
  },
  [190] = {
    [2] = alias_sym_type_identifier,
  },
  [192] = {
    [3] = alias_sym_type_identifier,
  },
  [194] = {
    [1] = alias_sym_type_identifier,
  },
  [196] = {
    [1] = sym_identifier,
  },
  [197] = {
    [1] = sym_identifier,
  },
  [202] = {
    [0] = alias_sym_type_identifier,
  },
  [226] = {
    [2] = alias_sym_type_identifier,
  },
  [231] = {
    [2] = alias_sym_type_identifier,
  },
  [232] = {
    [3] = alias_sym_type_identifier,
  },
  [233] = {
    [3] = alias_sym_type_identifier,
  },
  [265] = {
    [3] = alias_sym_property_identifier,
  },
  [266] = {
    [3] = alias_sym_type_identifier,
  },
  [275] = {
    [1] = sym_identifier,
  },
  [276] = {
    [0] = alias_sym_type_identifier,
  },
  [302] = {
    [2] = sym_identifier,
  },
  [318] = {
    [3] = sym_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_nested_identifier, 2,
    sym_nested_identifier,
    sym_member_expression,
  sym_predefined_type, 2,
    sym_predefined_type,
    sym_identifier,
  sym_object_type, 2,
    sym_object_type,
    alias_sym_interface_body,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 4,
  [5] = 4,
  [6] = 4,
  [7] = 4,
  [8] = 4,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 14,
  [16] = 16,
  [17] = 17,
  [18] = 14,
  [19] = 19,
  [20] = 14,
  [21] = 19,
  [22] = 14,
  [23] = 19,
  [24] = 14,
  [25] = 19,
  [26] = 19,
  [27] = 14,
  [28] = 19,
  [29] = 19,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 31,
  [39] = 39,
  [40] = 31,
  [41] = 33,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 39,
  [51] = 42,
  [52] = 32,
  [53] = 31,
  [54] = 54,
  [55] = 43,
  [56] = 31,
  [57] = 37,
  [58] = 44,
  [59] = 45,
  [60] = 46,
  [61] = 47,
  [62] = 48,
  [63] = 31,
  [64] = 49,
  [65] = 34,
  [66] = 31,
  [67] = 31,
  [68] = 31,
  [69] = 31,
  [70] = 35,
  [71] = 36,
  [72] = 72,
  [73] = 72,
  [74] = 72,
  [75] = 75,
  [76] = 76,
  [77] = 76,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 76,
  [82] = 75,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 86,
  [90] = 86,
  [91] = 86,
  [92] = 86,
  [93] = 93,
  [94] = 94,
  [95] = 94,
  [96] = 87,
  [97] = 94,
  [98] = 98,
  [99] = 99,
  [100] = 93,
  [101] = 98,
  [102] = 94,
  [103] = 94,
  [104] = 94,
  [105] = 93,
  [106] = 99,
  [107] = 93,
  [108] = 94,
  [109] = 109,
  [110] = 88,
  [111] = 111,
  [112] = 112,
  [113] = 94,
  [114] = 87,
  [115] = 115,
  [116] = 93,
  [117] = 117,
  [118] = 94,
  [119] = 98,
  [120] = 94,
  [121] = 93,
  [122] = 98,
  [123] = 87,
  [124] = 94,
  [125] = 94,
  [126] = 93,
  [127] = 111,
  [128] = 93,
  [129] = 112,
  [130] = 94,
  [131] = 94,
  [132] = 93,
  [133] = 94,
  [134] = 94,
  [135] = 94,
  [136] = 94,
  [137] = 137,
  [138] = 137,
  [139] = 93,
  [140] = 137,
  [141] = 137,
  [142] = 137,
  [143] = 143,
  [144] = 137,
  [145] = 94,
  [146] = 137,
  [147] = 137,
  [148] = 137,
  [149] = 137,
  [150] = 150,
  [151] = 151,
  [152] = 151,
  [153] = 151,
  [154] = 151,
  [155] = 151,
  [156] = 156,
  [157] = 151,
  [158] = 151,
  [159] = 159,
  [160] = 151,
  [161] = 151,
  [162] = 151,
  [163] = 163,
  [164] = 163,
  [165] = 163,
  [166] = 163,
  [167] = 163,
  [168] = 163,
  [169] = 163,
  [170] = 163,
  [171] = 163,
  [172] = 163,
  [173] = 173,
  [174] = 173,
  [175] = 173,
  [176] = 176,
  [177] = 173,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 180,
  [182] = 176,
  [183] = 173,
  [184] = 179,
  [185] = 176,
  [186] = 180,
  [187] = 173,
  [188] = 179,
  [189] = 178,
  [190] = 173,
  [191] = 173,
  [192] = 173,
  [193] = 173,
  [194] = 194,
  [195] = 194,
  [196] = 196,
  [197] = 197,
  [198] = 197,
  [199] = 197,
  [200] = 200,
  [201] = 201,
  [202] = 196,
  [203] = 203,
  [204] = 204,
  [205] = 204,
  [206] = 206,
  [207] = 204,
  [208] = 196,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 215,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 215,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 215,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 215,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 215,
  [242] = 242,
  [243] = 243,
  [244] = 242,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 246,
  [249] = 249,
  [250] = 250,
  [251] = 242,
  [252] = 245,
  [253] = 249,
  [254] = 254,
  [255] = 242,
  [256] = 256,
  [257] = 257,
  [258] = 256,
  [259] = 257,
  [260] = 242,
  [261] = 242,
  [262] = 242,
  [263] = 242,
  [264] = 264,
  [265] = 264,
  [266] = 264,
  [267] = 267,
  [268] = 264,
  [269] = 264,
  [270] = 242,
  [271] = 264,
  [272] = 242,
  [273] = 264,
  [274] = 242,
  [275] = 275,
  [276] = 275,
  [277] = 275,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 275,
  [282] = 275,
  [283] = 275,
  [284] = 275,
  [285] = 275,
  [286] = 275,
  [287] = 287,
  [288] = 288,
  [289] = 280,
  [290] = 275,
  [291] = 275,
  [292] = 275,
  [293] = 275,
  [294] = 275,
  [295] = 275,
  [296] = 275,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 299,
  [305] = 301,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 306,
  [310] = 307,
  [311] = 308,
  [312] = 312,
  [313] = 313,
  [314] = 313,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 315,
  [327] = 319,
  [328] = 328,
  [329] = 321,
  [330] = 330,
  [331] = 331,
  [332] = 318,
  [333] = 321,
  [334] = 334,
  [335] = 317,
  [336] = 324,
  [337] = 330,
  [338] = 318,
  [339] = 321,
  [340] = 324,
  [341] = 325,
  [342] = 325,
  [343] = 315,
  [344] = 324,
  [345] = 345,
  [346] = 330,
  [347] = 318,
  [348] = 321,
  [349] = 324,
  [350] = 325,
  [351] = 315,
  [352] = 325,
  [353] = 353,
  [354] = 330,
  [355] = 355,
  [356] = 318,
  [357] = 321,
  [358] = 324,
  [359] = 318,
  [360] = 315,
  [361] = 330,
  [362] = 331,
  [363] = 330,
  [364] = 318,
  [365] = 321,
  [366] = 324,
  [367] = 325,
  [368] = 315,
  [369] = 369,
  [370] = 330,
  [371] = 318,
  [372] = 321,
  [373] = 324,
  [374] = 325,
  [375] = 315,
  [376] = 330,
  [377] = 318,
  [378] = 321,
  [379] = 324,
  [380] = 325,
  [381] = 315,
  [382] = 330,
  [383] = 318,
  [384] = 321,
  [385] = 324,
  [386] = 325,
  [387] = 315,
  [388] = 315,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 330,
  [395] = 325,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 412,
  [424] = 424,
  [425] = 425,
  [426] = 396,
  [427] = 427,
  [428] = 428,
  [429] = 412,
  [430] = 418,
  [431] = 431,
  [432] = 399,
  [433] = 400,
  [434] = 415,
  [435] = 416,
  [436] = 412,
  [437] = 425,
  [438] = 418,
  [439] = 439,
  [440] = 427,
  [441] = 418,
  [442] = 442,
  [443] = 443,
  [444] = 418,
  [445] = 418,
  [446] = 446,
  [447] = 447,
  [448] = 448,
  [449] = 418,
  [450] = 450,
  [451] = 451,
  [452] = 428,
  [453] = 401,
  [454] = 446,
  [455] = 455,
  [456] = 397,
  [457] = 398,
  [458] = 398,
  [459] = 396,
  [460] = 399,
  [461] = 401,
  [462] = 402,
  [463] = 403,
  [464] = 404,
  [465] = 405,
  [466] = 406,
  [467] = 407,
  [468] = 408,
  [469] = 409,
  [470] = 410,
  [471] = 411,
  [472] = 417,
  [473] = 402,
  [474] = 403,
  [475] = 404,
  [476] = 415,
  [477] = 416,
  [478] = 418,
  [479] = 405,
  [480] = 442,
  [481] = 422,
  [482] = 424,
  [483] = 451,
  [484] = 428,
  [485] = 446,
  [486] = 450,
  [487] = 455,
  [488] = 397,
  [489] = 398,
  [490] = 399,
  [491] = 400,
  [492] = 401,
  [493] = 402,
  [494] = 403,
  [495] = 404,
  [496] = 405,
  [497] = 406,
  [498] = 407,
  [499] = 408,
  [500] = 409,
  [501] = 410,
  [502] = 411,
  [503] = 412,
  [504] = 406,
  [505] = 415,
  [506] = 416,
  [507] = 418,
  [508] = 422,
  [509] = 424,
  [510] = 425,
  [511] = 418,
  [512] = 450,
  [513] = 428,
  [514] = 407,
  [515] = 446,
  [516] = 455,
  [517] = 397,
  [518] = 398,
  [519] = 396,
  [520] = 399,
  [521] = 401,
  [522] = 402,
  [523] = 403,
  [524] = 404,
  [525] = 405,
  [526] = 397,
  [527] = 407,
  [528] = 408,
  [529] = 409,
  [530] = 410,
  [531] = 411,
  [532] = 408,
  [533] = 415,
  [534] = 416,
  [535] = 418,
  [536] = 409,
  [537] = 422,
  [538] = 451,
  [539] = 428,
  [540] = 446,
  [541] = 455,
  [542] = 397,
  [543] = 398,
  [544] = 399,
  [545] = 401,
  [546] = 402,
  [547] = 403,
  [548] = 404,
  [549] = 405,
  [550] = 406,
  [551] = 407,
  [552] = 408,
  [553] = 409,
  [554] = 410,
  [555] = 411,
  [556] = 415,
  [557] = 416,
  [558] = 418,
  [559] = 422,
  [560] = 424,
  [561] = 425,
  [562] = 562,
  [563] = 418,
  [564] = 450,
  [565] = 396,
  [566] = 428,
  [567] = 446,
  [568] = 455,
  [569] = 397,
  [570] = 398,
  [571] = 399,
  [572] = 401,
  [573] = 402,
  [574] = 403,
  [575] = 404,
  [576] = 405,
  [577] = 406,
  [578] = 407,
  [579] = 408,
  [580] = 409,
  [581] = 410,
  [582] = 411,
  [583] = 415,
  [584] = 416,
  [585] = 455,
  [586] = 451,
  [587] = 422,
  [588] = 424,
  [589] = 425,
  [590] = 427,
  [591] = 418,
  [592] = 450,
  [593] = 396,
  [594] = 428,
  [595] = 446,
  [596] = 455,
  [597] = 397,
  [598] = 398,
  [599] = 399,
  [600] = 401,
  [601] = 402,
  [602] = 403,
  [603] = 404,
  [604] = 405,
  [605] = 406,
  [606] = 407,
  [607] = 408,
  [608] = 409,
  [609] = 410,
  [610] = 411,
  [611] = 410,
  [612] = 415,
  [613] = 416,
  [614] = 422,
  [615] = 424,
  [616] = 425,
  [617] = 418,
  [618] = 450,
  [619] = 396,
  [620] = 428,
  [621] = 446,
  [622] = 455,
  [623] = 397,
  [624] = 398,
  [625] = 399,
  [626] = 401,
  [627] = 402,
  [628] = 403,
  [629] = 404,
  [630] = 405,
  [631] = 406,
  [632] = 407,
  [633] = 408,
  [634] = 409,
  [635] = 410,
  [636] = 451,
  [637] = 411,
  [638] = 428,
  [639] = 446,
  [640] = 415,
  [641] = 416,
  [642] = 422,
  [643] = 422,
  [644] = 424,
  [645] = 425,
  [646] = 450,
  [647] = 428,
  [648] = 446,
  [649] = 455,
  [650] = 397,
  [651] = 398,
  [652] = 399,
  [653] = 401,
  [654] = 402,
  [655] = 403,
  [656] = 404,
  [657] = 405,
  [658] = 406,
  [659] = 407,
  [660] = 408,
  [661] = 409,
  [662] = 410,
  [663] = 411,
  [664] = 411,
  [665] = 415,
  [666] = 416,
  [667] = 422,
  [668] = 424,
  [669] = 425,
  [670] = 450,
  [671] = 396,
  [672] = 672,
  [673] = 424,
  [674] = 425,
  [675] = 451,
  [676] = 451,
  [677] = 677,
  [678] = 418,
  [679] = 424,
  [680] = 425,
  [681] = 451,
  [682] = 455,
  [683] = 451,
  [684] = 451,
  [685] = 450,
  [686] = 396,
  [687] = 450,
  [688] = 396,
  [689] = 406,
  [690] = 690,
  [691] = 690,
  [692] = 690,
  [693] = 693,
  [694] = 693,
  [695] = 693,
  [696] = 696,
  [697] = 696,
  [698] = 698,
  [699] = 698,
  [700] = 698,
  [701] = 701,
  [702] = 701,
  [703] = 703,
  [704] = 703,
  [705] = 703,
  [706] = 701,
  [707] = 707,
  [708] = 213,
  [709] = 219,
  [710] = 707,
  [711] = 711,
  [712] = 712,
  [713] = 713,
  [714] = 714,
  [715] = 715,
  [716] = 716,
  [717] = 716,
  [718] = 718,
  [719] = 718,
  [720] = 720,
  [721] = 720,
  [722] = 716,
  [723] = 718,
  [724] = 724,
  [725] = 725,
  [726] = 726,
  [727] = 726,
  [728] = 728,
  [729] = 728,
  [730] = 726,
  [731] = 724,
  [732] = 726,
  [733] = 725,
  [734] = 726,
  [735] = 726,
  [736] = 736,
  [737] = 726,
  [738] = 725,
  [739] = 726,
  [740] = 726,
  [741] = 726,
  [742] = 742,
  [743] = 726,
  [744] = 744,
  [745] = 745,
  [746] = 746,
  [747] = 212,
  [748] = 726,
  [749] = 749,
  [750] = 749,
  [751] = 725,
  [752] = 749,
  [753] = 236,
  [754] = 236,
  [755] = 235,
  [756] = 238,
  [757] = 211,
  [758] = 235,
  [759] = 212,
  [760] = 210,
  [761] = 726,
  [762] = 726,
  [763] = 726,
  [764] = 726,
  [765] = 742,
  [766] = 726,
  [767] = 726,
  [768] = 724,
  [769] = 210,
  [770] = 770,
  [771] = 771,
  [772] = 771,
  [773] = 771,
  [774] = 771,
  [775] = 771,
  [776] = 771,
  [777] = 726,
  [778] = 771,
  [779] = 771,
  [780] = 200,
  [781] = 771,
  [782] = 771,
  [783] = 201,
  [784] = 784,
  [785] = 785,
  [786] = 786,
  [787] = 787,
  [788] = 788,
  [789] = 239,
  [790] = 790,
  [791] = 791,
  [792] = 792,
  [793] = 784,
  [794] = 794,
  [795] = 784,
  [796] = 796,
  [797] = 797,
  [798] = 203,
  [799] = 799,
  [800] = 784,
  [801] = 801,
  [802] = 240,
  [803] = 803,
  [804] = 804,
  [805] = 784,
  [806] = 806,
  [807] = 807,
  [808] = 808,
  [809] = 809,
  [810] = 810,
  [811] = 811,
  [812] = 812,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 817,
  [818] = 818,
  [819] = 819,
  [820] = 820,
  [821] = 821,
  [822] = 822,
  [823] = 823,
  [824] = 824,
  [825] = 825,
  [826] = 826,
  [827] = 827,
  [828] = 828,
  [829] = 829,
  [830] = 830,
  [831] = 831,
  [832] = 832,
  [833] = 833,
  [834] = 834,
  [835] = 835,
  [836] = 836,
  [837] = 837,
  [838] = 838,
  [839] = 839,
  [840] = 840,
  [841] = 841,
  [842] = 842,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 847,
  [848] = 820,
  [849] = 849,
  [850] = 850,
  [851] = 851,
  [852] = 852,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 856,
  [857] = 857,
  [858] = 858,
  [859] = 859,
  [860] = 860,
  [861] = 861,
  [862] = 862,
  [863] = 863,
  [864] = 864,
  [865] = 238,
  [866] = 866,
  [867] = 867,
  [868] = 820,
  [869] = 869,
  [870] = 870,
  [871] = 871,
  [872] = 211,
  [873] = 873,
  [874] = 874,
  [875] = 875,
  [876] = 821,
  [877] = 877,
  [878] = 878,
  [879] = 879,
  [880] = 880,
  [881] = 881,
  [882] = 217,
  [883] = 883,
  [884] = 884,
  [885] = 885,
  [886] = 886,
  [887] = 231,
  [888] = 888,
  [889] = 821,
  [890] = 890,
  [891] = 891,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 895,
  [896] = 896,
  [897] = 897,
  [898] = 898,
  [899] = 899,
  [900] = 820,
  [901] = 901,
  [902] = 902,
  [903] = 903,
  [904] = 904,
  [905] = 905,
  [906] = 821,
  [907] = 907,
  [908] = 908,
  [909] = 909,
  [910] = 910,
  [911] = 911,
  [912] = 912,
  [913] = 913,
  [914] = 914,
  [915] = 915,
  [916] = 916,
  [917] = 917,
  [918] = 918,
  [919] = 919,
  [920] = 920,
  [921] = 921,
  [922] = 922,
  [923] = 923,
  [924] = 924,
  [925] = 925,
  [926] = 926,
  [927] = 927,
  [928] = 928,
  [929] = 929,
  [930] = 930,
  [931] = 931,
  [932] = 932,
  [933] = 820,
  [934] = 934,
  [935] = 821,
  [936] = 936,
  [937] = 937,
  [938] = 938,
  [939] = 939,
  [940] = 940,
  [941] = 941,
  [942] = 942,
  [943] = 943,
  [944] = 944,
  [945] = 945,
  [946] = 946,
  [947] = 947,
  [948] = 948,
  [949] = 946,
  [950] = 950,
  [951] = 948,
  [952] = 952,
  [953] = 946,
  [954] = 803,
  [955] = 955,
  [956] = 956,
  [957] = 948,
  [958] = 958,
  [959] = 959,
  [960] = 960,
  [961] = 959,
  [962] = 946,
  [963] = 959,
  [964] = 948,
  [965] = 965,
  [966] = 966,
  [967] = 948,
  [968] = 946,
  [969] = 787,
  [970] = 970,
  [971] = 948,
  [972] = 972,
  [973] = 948,
  [974] = 946,
  [975] = 975,
  [976] = 946,
  [977] = 977,
  [978] = 978,
  [979] = 979,
  [980] = 978,
  [981] = 981,
  [982] = 978,
  [983] = 977,
  [984] = 979,
  [985] = 978,
  [986] = 979,
  [987] = 978,
  [988] = 988,
  [989] = 977,
  [990] = 977,
  [991] = 991,
  [992] = 992,
  [993] = 977,
  [994] = 979,
  [995] = 978,
  [996] = 977,
  [997] = 979,
  [998] = 998,
  [999] = 999,
  [1000] = 1000,
  [1001] = 1001,
  [1002] = 1002,
  [1003] = 1003,
  [1004] = 1004,
  [1005] = 1005,
  [1006] = 1006,
  [1007] = 1007,
  [1008] = 1008,
  [1009] = 1001,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1013,
  [1014] = 1001,
  [1015] = 1015,
  [1016] = 1016,
  [1017] = 1017,
  [1018] = 1018,
  [1019] = 1019,
  [1020] = 998,
  [1021] = 1000,
  [1022] = 1002,
  [1023] = 1003,
  [1024] = 1024,
  [1025] = 1025,
  [1026] = 1010,
  [1027] = 1007,
  [1028] = 1008,
  [1029] = 1011,
  [1030] = 1012,
  [1031] = 1013,
  [1032] = 1015,
  [1033] = 1016,
  [1034] = 1034,
  [1035] = 1035,
  [1036] = 1036,
  [1037] = 1017,
  [1038] = 1018,
  [1039] = 998,
  [1040] = 1000,
  [1041] = 1015,
  [1042] = 1016,
  [1043] = 1002,
  [1044] = 1003,
  [1045] = 1004,
  [1046] = 1005,
  [1047] = 1024,
  [1048] = 1025,
  [1049] = 1049,
  [1050] = 1050,
  [1051] = 1051,
  [1052] = 1052,
  [1053] = 1017,
  [1054] = 1018,
  [1055] = 1055,
  [1056] = 1056,
  [1057] = 998,
  [1058] = 1000,
  [1059] = 1002,
  [1060] = 1003,
  [1061] = 1024,
  [1062] = 1025,
  [1063] = 1007,
  [1064] = 1008,
  [1065] = 1011,
  [1066] = 1012,
  [1067] = 1013,
  [1068] = 1015,
  [1069] = 1015,
  [1070] = 1016,
  [1071] = 1004,
  [1072] = 1017,
  [1073] = 1018,
  [1074] = 1004,
  [1075] = 1002,
  [1076] = 1003,
  [1077] = 1024,
  [1078] = 1025,
  [1079] = 1007,
  [1080] = 1008,
  [1081] = 1011,
  [1082] = 1012,
  [1083] = 1004,
  [1084] = 1001,
  [1085] = 1024,
  [1086] = 1016,
  [1087] = 1015,
  [1088] = 1016,
  [1089] = 1017,
  [1090] = 1018,
  [1091] = 999,
  [1092] = 1002,
  [1093] = 1003,
  [1094] = 1024,
  [1095] = 1025,
  [1096] = 1017,
  [1097] = 1018,
  [1098] = 1001,
  [1099] = 998,
  [1100] = 1000,
  [1101] = 1101,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 1025,
  [1105] = 1007,
  [1106] = 1008,
  [1107] = 1011,
  [1108] = 1012,
  [1109] = 1013,
  [1110] = 1006,
  [1111] = 1001,
  [1112] = 1112,
  [1113] = 1112,
  [1114] = 1114,
  [1115] = 1035,
  [1116] = 1015,
  [1117] = 1016,
  [1118] = 1017,
  [1119] = 1018,
  [1120] = 998,
  [1121] = 1000,
  [1122] = 1002,
  [1123] = 1003,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 1126,
  [1127] = 1024,
  [1128] = 1128,
  [1129] = 1025,
  [1130] = 1007,
  [1131] = 1008,
  [1132] = 1011,
  [1133] = 1012,
  [1134] = 1013,
  [1135] = 1004,
  [1136] = 998,
  [1137] = 1000,
  [1138] = 1114,
  [1139] = 1007,
  [1140] = 1008,
  [1141] = 1011,
  [1142] = 1012,
  [1143] = 999,
  [1144] = 1004,
  [1145] = 1013,
  [1146] = 999,
  [1147] = 999,
  [1148] = 999,
  [1149] = 999,
  [1150] = 1013,
  [1151] = 1151,
  [1152] = 1151,
  [1153] = 1151,
  [1154] = 1151,
  [1155] = 1151,
  [1156] = 1151,
  [1157] = 1151,
  [1158] = 1151,
  [1159] = 1151,
  [1160] = 1151,
  [1161] = 1151,
  [1162] = 1151,
  [1163] = 1163,
  [1164] = 1164,
  [1165] = 1163,
  [1166] = 1166,
  [1167] = 1167,
  [1168] = 1164,
  [1169] = 1163,
  [1170] = 1170,
  [1171] = 1171,
  [1172] = 1167,
  [1173] = 1167,
  [1174] = 1164,
  [1175] = 1175,
  [1176] = 1176,
  [1177] = 1177,
  [1178] = 1177,
  [1179] = 1179,
  [1180] = 1179,
  [1181] = 1177,
  [1182] = 1182,
  [1183] = 1183,
  [1184] = 1184,
  [1185] = 1175,
  [1186] = 1176,
  [1187] = 1177,
  [1188] = 1177,
  [1189] = 1177,
  [1190] = 1184,
  [1191] = 1183,
  [1192] = 1182,
  [1193] = 1193,
  [1194] = 1193,
  [1195] = 1195,
  [1196] = 1193,
  [1197] = 1197,
  [1198] = 1198,
  [1199] = 1199,
  [1200] = 1200,
  [1201] = 1177,
  [1202] = 1202,
  [1203] = 1203,
  [1204] = 1204,
  [1205] = 1205,
  [1206] = 1206,
  [1207] = 1207,
  [1208] = 1177,
  [1209] = 1177,
  [1210] = 1176,
  [1211] = 1177,
  [1212] = 1212,
  [1213] = 1213,
  [1214] = 1214,
  [1215] = 1215,
  [1216] = 1216,
  [1217] = 787,
  [1218] = 1177,
  [1219] = 803,
  [1220] = 1177,
  [1221] = 1221,
  [1222] = 1221,
  [1223] = 1223,
  [1224] = 1224,
  [1225] = 1225,
  [1226] = 1224,
  [1227] = 1216,
  [1228] = 1216,
  [1229] = 1176,
  [1230] = 1177,
  [1231] = 1223,
  [1232] = 1215,
  [1233] = 1215,
  [1234] = 1177,
  [1235] = 1177,
  [1236] = 1177,
  [1237] = 1177,
  [1238] = 1238,
  [1239] = 1177,
  [1240] = 1177,
  [1241] = 1241,
  [1242] = 1175,
  [1243] = 1203,
  [1244] = 1223,
  [1245] = 1245,
  [1246] = 1246,
  [1247] = 1223,
  [1248] = 1248,
  [1249] = 1223,
  [1250] = 1248,
  [1251] = 1248,
  [1252] = 1252,
  [1253] = 1248,
  [1254] = 1223,
  [1255] = 1255,
  [1256] = 1238,
  [1257] = 1248,
  [1258] = 1223,
  [1259] = 1248,
  [1260] = 1260,
  [1261] = 1223,
  [1262] = 1262,
  [1263] = 1223,
  [1264] = 1245,
  [1265] = 1265,
  [1266] = 1248,
  [1267] = 1177,
  [1268] = 1248,
  [1269] = 1269,
  [1270] = 1238,
  [1271] = 1248,
  [1272] = 1272,
  [1273] = 1273,
  [1274] = 1248,
  [1275] = 1245,
  [1276] = 1276,
  [1277] = 1277,
  [1278] = 1278,
  [1279] = 1279,
  [1280] = 1279,
  [1281] = 1223,
  [1282] = 1202,
  [1283] = 1223,
  [1284] = 1205,
  [1285] = 1285,
  [1286] = 1262,
  [1287] = 1287,
  [1288] = 1288,
  [1289] = 1238,
  [1290] = 1202,
  [1291] = 1205,
  [1292] = 1285,
  [1293] = 1223,
  [1294] = 1238,
  [1295] = 1295,
  [1296] = 1223,
  [1297] = 1297,
  [1298] = 1223,
  [1299] = 1299,
  [1300] = 1276,
  [1301] = 1277,
  [1302] = 1238,
  [1303] = 1276,
  [1304] = 1299,
  [1305] = 1262,
  [1306] = 1276,
  [1307] = 1299,
  [1308] = 1299,
  [1309] = 1238,
  [1310] = 1206,
  [1311] = 1207,
  [1312] = 1299,
  [1313] = 1277,
  [1314] = 1265,
  [1315] = 1315,
  [1316] = 1316,
  [1317] = 1317,
  [1318] = 1318,
  [1319] = 1260,
  [1320] = 1277,
  [1321] = 1197,
  [1322] = 1213,
  [1323] = 1238,
  [1324] = 1277,
  [1325] = 1198,
  [1326] = 1316,
  [1327] = 1223,
  [1328] = 1276,
  [1329] = 1277,
  [1330] = 1200,
  [1331] = 787,
  [1332] = 1332,
  [1333] = 1318,
  [1334] = 1213,
  [1335] = 803,
  [1336] = 1238,
  [1337] = 1299,
  [1338] = 1262,
  [1339] = 1202,
  [1340] = 1238,
  [1341] = 1273,
  [1342] = 1315,
  [1343] = 1276,
  [1344] = 1344,
  [1345] = 1205,
  [1346] = 1223,
  [1347] = 1212,
  [1348] = 1199,
  [1349] = 1277,
  [1350] = 1202,
  [1351] = 1351,
  [1352] = 1295,
  [1353] = 1299,
  [1354] = 1205,
  [1355] = 1299,
  [1356] = 1356,
  [1357] = 1238,
  [1358] = 1252,
  [1359] = 1351,
  [1360] = 1277,
  [1361] = 1276,
  [1362] = 1213,
  [1363] = 1278,
  [1364] = 1213,
  [1365] = 1365,
  [1366] = 1299,
  [1367] = 1205,
  [1368] = 1299,
  [1369] = 1202,
  [1370] = 1276,
  [1371] = 1260,
  [1372] = 1372,
  [1373] = 1276,
  [1374] = 1277,
  [1375] = 1277,
  [1376] = 1265,
  [1377] = 1377,
  [1378] = 1276,
  [1379] = 1379,
  [1380] = 1380,
  [1381] = 1381,
  [1382] = 1380,
  [1383] = 1299,
  [1384] = 1277,
  [1385] = 1299,
  [1386] = 1380,
  [1387] = 1213,
  [1388] = 1388,
  [1389] = 1380,
  [1390] = 1260,
  [1391] = 1265,
  [1392] = 1392,
  [1393] = 1276,
  [1394] = 1380,
  [1395] = 1380,
  [1396] = 1295,
  [1397] = 1202,
  [1398] = 1213,
  [1399] = 1399,
  [1400] = 1277,
  [1401] = 1205,
  [1402] = 1277,
  [1403] = 1277,
  [1404] = 1299,
  [1405] = 1277,
  [1406] = 1277,
  [1407] = 1277,
  [1408] = 1277,
  [1409] = 1273,
  [1410] = 1213,
  [1411] = 1356,
  [1412] = 1299,
  [1413] = 1365,
  [1414] = 1295,
  [1415] = 1299,
  [1416] = 1299,
  [1417] = 1299,
  [1418] = 1299,
  [1419] = 1419,
  [1420] = 1420,
  [1421] = 1421,
  [1422] = 1420,
  [1423] = 1423,
  [1424] = 1419,
  [1425] = 1421,
  [1426] = 1426,
  [1427] = 1299,
  [1428] = 1421,
  [1429] = 1421,
  [1430] = 1420,
  [1431] = 1420,
  [1432] = 1419,
  [1433] = 1426,
  [1434] = 1421,
  [1435] = 1420,
  [1436] = 1426,
  [1437] = 1423,
  [1438] = 1421,
  [1439] = 1426,
  [1440] = 1420,
  [1441] = 1426,
  [1442] = 1423,
  [1443] = 1423,
  [1444] = 1421,
  [1445] = 1420,
  [1446] = 1278,
  [1447] = 1381,
  [1448] = 1421,
  [1449] = 1421,
  [1450] = 1423,
  [1451] = 1420,
  [1452] = 1421,
  [1453] = 1420,
  [1454] = 1426,
  [1455] = 1419,
  [1456] = 1213,
  [1457] = 1213,
  [1458] = 1277,
  [1459] = 1213,
  [1460] = 1423,
  [1461] = 1420,
  [1462] = 1419,
  [1463] = 1419,
  [1464] = 1464,
  [1465] = 1464,
  [1466] = 1464,
  [1467] = 1464,
  [1468] = 1464,
  [1469] = 1464,
  [1470] = 1464,
  [1471] = 1464,
  [1472] = 1464,
  [1473] = 1464,
  [1474] = 1474,
  [1475] = 1474,
  [1476] = 1474,
  [1477] = 1477,
  [1478] = 1474,
  [1479] = 1474,
  [1480] = 1474,
  [1481] = 1481,
  [1482] = 1482,
  [1483] = 1483,
  [1484] = 1482,
  [1485] = 1485,
  [1486] = 1481,
  [1487] = 1481,
  [1488] = 1481,
  [1489] = 1483,
  [1490] = 1483,
  [1491] = 1482,
  [1492] = 1483,
  [1493] = 1481,
  [1494] = 1483,
  [1495] = 1482,
  [1496] = 1482,
  [1497] = 1497,
  [1498] = 1497,
  [1499] = 1497,
  [1500] = 1497,
  [1501] = 1501,
  [1502] = 1497,
  [1503] = 1497,
  [1504] = 1504,
  [1505] = 1505,
  [1506] = 1506,
  [1507] = 1507,
  [1508] = 219,
  [1509] = 1509,
  [1510] = 1510,
  [1511] = 213,
  [1512] = 1512,
  [1513] = 988,
  [1514] = 1514,
  [1515] = 1515,
  [1516] = 1516,
  [1517] = 213,
  [1518] = 992,
  [1519] = 219,
  [1520] = 1520,
  [1521] = 206,
  [1522] = 1522,
  [1523] = 1523,
  [1524] = 1524,
  [1525] = 1525,
  [1526] = 991,
  [1527] = 1527,
  [1528] = 1528,
  [1529] = 1529,
  [1530] = 1530,
  [1531] = 1531,
  [1532] = 1532,
  [1533] = 1533,
  [1534] = 212,
  [1535] = 1535,
  [1536] = 1536,
  [1537] = 1537,
  [1538] = 1538,
  [1539] = 1539,
  [1540] = 1540,
  [1541] = 714,
  [1542] = 1542,
  [1543] = 1543,
  [1544] = 1544,
  [1545] = 1545,
  [1546] = 1546,
  [1547] = 1547,
  [1548] = 1548,
  [1549] = 1549,
  [1550] = 1550,
  [1551] = 1551,
  [1552] = 1552,
  [1553] = 1553,
  [1554] = 1554,
  [1555] = 1166,
  [1556] = 1556,
  [1557] = 1557,
  [1558] = 1558,
  [1559] = 1559,
  [1560] = 1560,
  [1561] = 1561,
  [1562] = 1562,
  [1563] = 1563,
  [1564] = 713,
  [1565] = 1565,
  [1566] = 1566,
  [1567] = 1567,
  [1568] = 1568,
  [1569] = 1569,
  [1570] = 1570,
  [1571] = 1571,
  [1572] = 1572,
  [1573] = 1573,
  [1574] = 1574,
  [1575] = 1575,
  [1576] = 1576,
  [1577] = 1577,
  [1578] = 1578,
  [1579] = 236,
  [1580] = 1580,
  [1581] = 1581,
  [1582] = 711,
  [1583] = 1583,
  [1584] = 1584,
  [1585] = 1585,
  [1586] = 1586,
  [1587] = 1587,
  [1588] = 1588,
  [1589] = 1589,
  [1590] = 1170,
  [1591] = 1591,
  [1592] = 1592,
  [1593] = 1593,
  [1594] = 1594,
  [1595] = 1595,
  [1596] = 1596,
  [1597] = 1597,
  [1598] = 1598,
  [1599] = 1599,
  [1600] = 1600,
  [1601] = 715,
  [1602] = 1602,
  [1603] = 1603,
  [1604] = 1604,
  [1605] = 1605,
  [1606] = 200,
  [1607] = 1171,
  [1608] = 201,
  [1609] = 1609,
  [1610] = 1610,
  [1611] = 1611,
  [1612] = 203,
  [1613] = 1613,
  [1614] = 1614,
  [1615] = 200,
  [1616] = 201,
  [1617] = 203,
  [1618] = 712,
  [1619] = 1619,
  [1620] = 1620,
  [1621] = 1621,
  [1622] = 1622,
  [1623] = 1623,
  [1624] = 1624,
  [1625] = 1625,
  [1626] = 1626,
  [1627] = 1627,
  [1628] = 1628,
  [1629] = 1629,
  [1630] = 1630,
  [1631] = 1631,
  [1632] = 1632,
  [1633] = 1633,
  [1634] = 1634,
  [1635] = 1635,
  [1636] = 1636,
  [1637] = 1637,
  [1638] = 1638,
  [1639] = 1639,
  [1640] = 1640,
  [1641] = 1641,
  [1642] = 1642,
  [1643] = 1643,
  [1644] = 1644,
  [1645] = 1645,
  [1646] = 1646,
  [1647] = 1647,
  [1648] = 1648,
  [1649] = 1649,
  [1650] = 1650,
  [1651] = 1651,
  [1652] = 1652,
  [1653] = 1653,
  [1654] = 1654,
  [1655] = 1655,
  [1656] = 1656,
  [1657] = 1657,
  [1658] = 1658,
  [1659] = 1659,
  [1660] = 1660,
  [1661] = 1661,
  [1662] = 238,
  [1663] = 1663,
  [1664] = 1664,
  [1665] = 1665,
  [1666] = 1666,
  [1667] = 1667,
  [1668] = 1668,
  [1669] = 1669,
  [1670] = 1670,
  [1671] = 1671,
  [1672] = 1672,
  [1673] = 1673,
  [1674] = 1674,
  [1675] = 1675,
  [1676] = 1676,
  [1677] = 1677,
  [1678] = 211,
  [1679] = 1679,
  [1680] = 1680,
  [1681] = 1681,
  [1682] = 1682,
  [1683] = 1683,
  [1684] = 1684,
  [1685] = 1685,
  [1686] = 1686,
  [1687] = 1687,
  [1688] = 1688,
  [1689] = 1689,
  [1690] = 1690,
  [1691] = 1691,
  [1692] = 1692,
  [1693] = 1693,
  [1694] = 1694,
  [1695] = 1695,
  [1696] = 1501,
  [1697] = 1697,
  [1698] = 1698,
  [1699] = 1699,
  [1700] = 1700,
  [1701] = 1701,
  [1702] = 1702,
  [1703] = 1703,
  [1704] = 1704,
  [1705] = 1705,
  [1706] = 1706,
  [1707] = 1707,
  [1708] = 239,
  [1709] = 240,
  [1710] = 1710,
  [1711] = 231,
  [1712] = 217,
  [1713] = 235,
  [1714] = 239,
  [1715] = 240,
  [1716] = 210,
  [1717] = 1717,
  [1718] = 1717,
  [1719] = 1717,
  [1720] = 1717,
  [1721] = 1717,
  [1722] = 1722,
  [1723] = 1705,
  [1724] = 212,
  [1725] = 1725,
  [1726] = 1706,
  [1727] = 235,
  [1728] = 1728,
  [1729] = 236,
  [1730] = 1504,
  [1731] = 1731,
  [1732] = 1505,
  [1733] = 210,
  [1734] = 1734,
  [1735] = 1509,
  [1736] = 1731,
  [1737] = 1506,
  [1738] = 1734,
  [1739] = 1739,
  [1740] = 1740,
  [1741] = 1741,
  [1742] = 1742,
  [1743] = 1743,
  [1744] = 1744,
  [1745] = 1745,
  [1746] = 1746,
  [1747] = 1747,
  [1748] = 1748,
  [1749] = 1749,
  [1750] = 217,
  [1751] = 1751,
  [1752] = 1752,
  [1753] = 1753,
  [1754] = 1754,
  [1755] = 1755,
  [1756] = 1756,
  [1757] = 1757,
  [1758] = 1758,
  [1759] = 1759,
  [1760] = 1760,
  [1761] = 1761,
  [1762] = 1762,
  [1763] = 1763,
  [1764] = 1764,
  [1765] = 1765,
  [1766] = 211,
  [1767] = 1731,
  [1768] = 1651,
  [1769] = 1734,
  [1770] = 1731,
  [1771] = 231,
  [1772] = 1734,
  [1773] = 1731,
  [1774] = 238,
  [1775] = 1734,
  [1776] = 1776,
  [1777] = 1777,
  [1778] = 1778,
  [1779] = 1779,
  [1780] = 1525,
  [1781] = 1514,
  [1782] = 1743,
  [1783] = 1783,
  [1784] = 1784,
  [1785] = 1531,
  [1786] = 1516,
  [1787] = 1787,
  [1788] = 1512,
  [1789] = 1744,
  [1790] = 1745,
  [1791] = 1746,
  [1792] = 1783,
  [1793] = 1705,
  [1794] = 1794,
  [1795] = 988,
  [1796] = 1539,
  [1797] = 1706,
  [1798] = 1722,
  [1799] = 1651,
  [1800] = 1747,
  [1801] = 1801,
  [1802] = 1748,
  [1803] = 1749,
  [1804] = 1779,
  [1805] = 1751,
  [1806] = 1752,
  [1807] = 1753,
  [1808] = 1754,
  [1809] = 1755,
  [1810] = 1515,
  [1811] = 1756,
  [1812] = 1757,
  [1813] = 1813,
  [1814] = 1776,
  [1815] = 1760,
  [1816] = 1816,
  [1817] = 1761,
  [1818] = 1762,
  [1819] = 1763,
  [1820] = 1764,
  [1821] = 1523,
  [1822] = 1524,
  [1823] = 1778,
  [1824] = 1783,
  [1825] = 1816,
  [1826] = 1522,
  [1827] = 1827,
  [1828] = 1758,
  [1829] = 1783,
  [1830] = 1759,
  [1831] = 1777,
  [1832] = 1816,
  [1833] = 1783,
  [1834] = 1739,
  [1835] = 1739,
  [1836] = 1740,
  [1837] = 1741,
  [1838] = 991,
  [1839] = 1743,
  [1840] = 1744,
  [1841] = 1745,
  [1842] = 1746,
  [1843] = 1747,
  [1844] = 1748,
  [1845] = 1749,
  [1846] = 1779,
  [1847] = 1751,
  [1848] = 1752,
  [1849] = 1753,
  [1850] = 1754,
  [1851] = 1755,
  [1852] = 1756,
  [1853] = 1757,
  [1854] = 1758,
  [1855] = 1759,
  [1856] = 1760,
  [1857] = 1761,
  [1858] = 1762,
  [1859] = 1763,
  [1860] = 1764,
  [1861] = 1765,
  [1862] = 1531,
  [1863] = 1539,
  [1864] = 1816,
  [1865] = 1527,
  [1866] = 1740,
  [1867] = 1867,
  [1868] = 1741,
  [1869] = 1869,
  [1870] = 1870,
  [1871] = 992,
  [1872] = 1765,
  [1873] = 1776,
  [1874] = 1722,
  [1875] = 1778,
  [1876] = 1777,
  [1877] = 1877,
  [1878] = 1591,
  [1879] = 1650,
  [1880] = 1596,
  [1881] = 1597,
  [1882] = 1600,
  [1883] = 1605,
  [1884] = 1170,
  [1885] = 206,
  [1886] = 1740,
  [1887] = 1744,
  [1888] = 1741,
  [1889] = 1877,
  [1890] = 1745,
  [1891] = 1746,
  [1892] = 1892,
  [1893] = 1893,
  [1894] = 1894,
  [1895] = 1747,
  [1896] = 1748,
  [1897] = 1749,
  [1898] = 1779,
  [1899] = 1751,
  [1900] = 1752,
  [1901] = 1753,
  [1902] = 1902,
  [1903] = 1754,
  [1904] = 1755,
  [1905] = 1905,
  [1906] = 1756,
  [1907] = 1528,
  [1908] = 1757,
  [1909] = 1593,
  [1910] = 1619,
  [1911] = 1574,
  [1912] = 1544,
  [1913] = 1758,
  [1914] = 1759,
  [1915] = 1554,
  [1916] = 1556,
  [1917] = 1877,
  [1918] = 1536,
  [1919] = 1743,
  [1920] = 1670,
  [1921] = 1867,
  [1922] = 1777,
  [1923] = 1722,
  [1924] = 1778,
  [1925] = 1581,
  [1926] = 206,
  [1927] = 1760,
  [1928] = 1705,
  [1929] = 1929,
  [1930] = 1761,
  [1931] = 1620,
  [1932] = 1762,
  [1933] = 1933,
  [1934] = 1531,
  [1935] = 1535,
  [1936] = 1539,
  [1937] = 1549,
  [1938] = 714,
  [1939] = 1637,
  [1940] = 1940,
  [1941] = 1643,
  [1942] = 1645,
  [1943] = 1943,
  [1944] = 1944,
  [1945] = 1945,
  [1946] = 1763,
  [1947] = 1877,
  [1948] = 1648,
  [1949] = 1531,
  [1950] = 1539,
  [1951] = 1588,
  [1952] = 1647,
  [1953] = 1877,
  [1954] = 1531,
  [1955] = 1539,
  [1956] = 1707,
  [1957] = 1710,
  [1958] = 1670,
  [1959] = 1764,
  [1960] = 1776,
  [1961] = 1528,
  [1962] = 1962,
  [1963] = 715,
  [1964] = 1602,
  [1965] = 1603,
  [1966] = 1604,
  [1967] = 1609,
  [1968] = 1968,
  [1969] = 1969,
  [1970] = 1610,
  [1971] = 1971,
  [1972] = 1972,
  [1973] = 1611,
  [1974] = 1550,
  [1975] = 1632,
  [1976] = 1739,
  [1977] = 1562,
  [1978] = 1563,
  [1979] = 1535,
  [1980] = 1707,
  [1981] = 1549,
  [1982] = 1710,
  [1983] = 1588,
  [1984] = 1613,
  [1985] = 1614,
  [1986] = 1621,
  [1987] = 1624,
  [1988] = 1628,
  [1989] = 1629,
  [1990] = 1630,
  [1991] = 1631,
  [1992] = 1634,
  [1993] = 1638,
  [1994] = 1639,
  [1995] = 1640,
  [1996] = 1641,
  [1997] = 1166,
  [1998] = 1642,
  [1999] = 1644,
  [2000] = 1646,
  [2001] = 1627,
  [2002] = 2002,
  [2003] = 1801,
  [2004] = 1580,
  [2005] = 2005,
  [2006] = 1595,
  [2007] = 1598,
  [2008] = 1622,
  [2009] = 712,
  [2010] = 1540,
  [2011] = 1599,
  [2012] = 1623,
  [2013] = 1625,
  [2014] = 2014,
  [2015] = 1636,
  [2016] = 1530,
  [2017] = 1532,
  [2018] = 1533,
  [2019] = 1633,
  [2020] = 1531,
  [2021] = 1537,
  [2022] = 1538,
  [2023] = 1542,
  [2024] = 1543,
  [2025] = 1539,
  [2026] = 1546,
  [2027] = 2027,
  [2028] = 1962,
  [2029] = 1547,
  [2030] = 1647,
  [2031] = 1626,
  [2032] = 1551,
  [2033] = 1553,
  [2034] = 2002,
  [2035] = 1801,
  [2036] = 1557,
  [2037] = 1171,
  [2038] = 1559,
  [2039] = 1560,
  [2040] = 1561,
  [2041] = 1765,
  [2042] = 1592,
  [2043] = 1649,
  [2044] = 1552,
  [2045] = 1558,
  [2046] = 1867,
  [2047] = 1635,
  [2048] = 1529,
  [2049] = 713,
  [2050] = 1565,
  [2051] = 1566,
  [2052] = 1567,
  [2053] = 1568,
  [2054] = 1569,
  [2055] = 1570,
  [2056] = 1571,
  [2057] = 1572,
  [2058] = 1573,
  [2059] = 1575,
  [2060] = 1576,
  [2061] = 1577,
  [2062] = 1578,
  [2063] = 1545,
  [2064] = 1706,
  [2065] = 2065,
  [2066] = 2066,
  [2067] = 1548,
  [2068] = 2068,
  [2069] = 711,
  [2070] = 2070,
  [2071] = 2071,
  [2072] = 1583,
  [2073] = 1584,
  [2074] = 1651,
  [2075] = 1877,
  [2076] = 1585,
  [2077] = 1586,
  [2078] = 1587,
  [2079] = 1589,
  [2080] = 1739,
  [2081] = 1740,
  [2082] = 1741,
  [2083] = 1743,
  [2084] = 1744,
  [2085] = 1745,
  [2086] = 1746,
  [2087] = 1747,
  [2088] = 1748,
  [2089] = 1749,
  [2090] = 1779,
  [2091] = 1751,
  [2092] = 1752,
  [2093] = 1753,
  [2094] = 1754,
  [2095] = 1755,
  [2096] = 1756,
  [2097] = 1757,
  [2098] = 1758,
  [2099] = 1759,
  [2100] = 1760,
  [2101] = 1761,
  [2102] = 1762,
  [2103] = 1763,
  [2104] = 1764,
  [2105] = 1765,
  [2106] = 1776,
  [2107] = 1722,
  [2108] = 1778,
  [2109] = 1777,
  [2110] = 1594,
  [2111] = 2111,
  [2112] = 1531,
  [2113] = 1539,
  [2114] = 2114,
  [2115] = 1531,
  [2116] = 1539,
  [2117] = 2117,
  [2118] = 2118,
  [2119] = 2117,
  [2120] = 2118,
  [2121] = 2121,
  [2122] = 2117,
  [2123] = 2118,
  [2124] = 2124,
  [2125] = 2125,
  [2126] = 2126,
  [2127] = 2127,
  [2128] = 2128,
  [2129] = 2129,
  [2130] = 1655,
  [2131] = 1739,
  [2132] = 1740,
  [2133] = 1741,
  [2134] = 1677,
  [2135] = 2135,
  [2136] = 1743,
  [2137] = 2137,
  [2138] = 2138,
  [2139] = 1744,
  [2140] = 1745,
  [2141] = 1746,
  [2142] = 2142,
  [2143] = 1747,
  [2144] = 2144,
  [2145] = 1748,
  [2146] = 1749,
  [2147] = 1779,
  [2148] = 1751,
  [2149] = 1752,
  [2150] = 1753,
  [2151] = 1754,
  [2152] = 1755,
  [2153] = 1756,
  [2154] = 1757,
  [2155] = 1758,
  [2156] = 1759,
  [2157] = 2157,
  [2158] = 1760,
  [2159] = 1761,
  [2160] = 1762,
  [2161] = 1763,
  [2162] = 1764,
  [2163] = 220,
  [2164] = 224,
  [2165] = 222,
  [2166] = 2166,
  [2167] = 1765,
  [2168] = 223,
  [2169] = 2169,
  [2170] = 225,
  [2171] = 2171,
  [2172] = 2172,
  [2173] = 230,
  [2174] = 2174,
  [2175] = 1801,
  [2176] = 1670,
  [2177] = 2177,
  [2178] = 2178,
  [2179] = 2179,
  [2180] = 224,
  [2181] = 225,
  [2182] = 226,
  [2183] = 2183,
  [2184] = 209,
  [2185] = 220,
  [2186] = 222,
  [2187] = 223,
  [2188] = 2188,
  [2189] = 1667,
  [2190] = 227,
  [2191] = 228,
  [2192] = 232,
  [2193] = 1661,
  [2194] = 233,
  [2195] = 1668,
  [2196] = 2196,
  [2197] = 1679,
  [2198] = 1680,
  [2199] = 226,
  [2200] = 1681,
  [2201] = 1682,
  [2202] = 2202,
  [2203] = 2203,
  [2204] = 1683,
  [2205] = 2205,
  [2206] = 1684,
  [2207] = 1685,
  [2208] = 2142,
  [2209] = 1827,
  [2210] = 1686,
  [2211] = 1656,
  [2212] = 2142,
  [2213] = 1707,
  [2214] = 2169,
  [2215] = 2215,
  [2216] = 2216,
  [2217] = 2169,
  [2218] = 2172,
  [2219] = 2142,
  [2220] = 1669,
  [2221] = 1827,
  [2222] = 1687,
  [2223] = 2172,
  [2224] = 1794,
  [2225] = 2144,
  [2226] = 1707,
  [2227] = 2227,
  [2228] = 1657,
  [2229] = 1535,
  [2230] = 1663,
  [2231] = 2142,
  [2232] = 1549,
  [2233] = 1710,
  [2234] = 1664,
  [2235] = 2235,
  [2236] = 2236,
  [2237] = 2142,
  [2238] = 2142,
  [2239] = 1776,
  [2240] = 1722,
  [2241] = 1778,
  [2242] = 1777,
  [2243] = 2243,
  [2244] = 2244,
  [2245] = 1660,
  [2246] = 227,
  [2247] = 228,
  [2248] = 2248,
  [2249] = 2249,
  [2250] = 2166,
  [2251] = 1688,
  [2252] = 2252,
  [2253] = 2253,
  [2254] = 230,
  [2255] = 1671,
  [2256] = 1867,
  [2257] = 2257,
  [2258] = 1689,
  [2259] = 232,
  [2260] = 1690,
  [2261] = 2261,
  [2262] = 1672,
  [2263] = 2138,
  [2264] = 2236,
  [2265] = 1703,
  [2266] = 1653,
  [2267] = 1528,
  [2268] = 2268,
  [2269] = 2269,
  [2270] = 2270,
  [2271] = 1710,
  [2272] = 2272,
  [2273] = 2273,
  [2274] = 2274,
  [2275] = 2174,
  [2276] = 2177,
  [2277] = 1673,
  [2278] = 1867,
  [2279] = 1704,
  [2280] = 1658,
  [2281] = 1691,
  [2282] = 1692,
  [2283] = 1693,
  [2284] = 1694,
  [2285] = 2285,
  [2286] = 1674,
  [2287] = 2287,
  [2288] = 2288,
  [2289] = 2289,
  [2290] = 2269,
  [2291] = 2291,
  [2292] = 2292,
  [2293] = 2293,
  [2294] = 2294,
  [2295] = 2295,
  [2296] = 2296,
  [2297] = 2270,
  [2298] = 2298,
  [2299] = 1867,
  [2300] = 2300,
  [2301] = 2126,
  [2302] = 2302,
  [2303] = 2303,
  [2304] = 1695,
  [2305] = 2305,
  [2306] = 2306,
  [2307] = 2307,
  [2308] = 2308,
  [2309] = 233,
  [2310] = 1675,
  [2311] = 2227,
  [2312] = 2312,
  [2313] = 2313,
  [2314] = 2314,
  [2315] = 2315,
  [2316] = 1787,
  [2317] = 1659,
  [2318] = 1665,
  [2319] = 1697,
  [2320] = 1676,
  [2321] = 2169,
  [2322] = 2172,
  [2323] = 1698,
  [2324] = 1699,
  [2325] = 1700,
  [2326] = 1701,
  [2327] = 1702,
  [2328] = 2328,
  [2329] = 2272,
  [2330] = 2273,
  [2331] = 2331,
  [2332] = 2169,
  [2333] = 1666,
  [2334] = 2172,
  [2335] = 2274,
  [2336] = 2124,
  [2337] = 2292,
  [2338] = 1707,
  [2339] = 1710,
  [2340] = 2340,
  [2341] = 2341,
  [2342] = 1654,
  [2343] = 2343,
  [2344] = 2169,
  [2345] = 209,
  [2346] = 2172,
  [2347] = 2117,
  [2348] = 2118,
  [2349] = 2314,
  [2350] = 1588,
  [2351] = 1647,
  [2352] = 2352,
  [2353] = 1894,
  [2354] = 2117,
  [2355] = 2118,
  [2356] = 1528,
  [2357] = 2357,
  [2358] = 1652,
  [2359] = 2312,
  [2360] = 1755,
  [2361] = 1756,
  [2362] = 1757,
  [2363] = 1758,
  [2364] = 1759,
  [2365] = 1760,
  [2366] = 1761,
  [2367] = 1762,
  [2368] = 1763,
  [2369] = 1764,
  [2370] = 2370,
  [2371] = 2371,
  [2372] = 1588,
  [2373] = 1765,
  [2374] = 2374,
  [2375] = 2375,
  [2376] = 1588,
  [2377] = 2377,
  [2378] = 2374,
  [2379] = 2379,
  [2380] = 2380,
  [2381] = 1647,
  [2382] = 1647,
  [2383] = 2383,
  [2384] = 2384,
  [2385] = 1827,
  [2386] = 1894,
  [2387] = 1739,
  [2388] = 1740,
  [2389] = 1741,
  [2390] = 1743,
  [2391] = 1744,
  [2392] = 1745,
  [2393] = 1746,
  [2394] = 1747,
  [2395] = 1748,
  [2396] = 1749,
  [2397] = 2397,
  [2398] = 2398,
  [2399] = 1779,
  [2400] = 1751,
  [2401] = 2401,
  [2402] = 1752,
  [2403] = 1753,
  [2404] = 1776,
  [2405] = 1722,
  [2406] = 1778,
  [2407] = 1777,
  [2408] = 1754,
  [2409] = 1755,
  [2410] = 1756,
  [2411] = 2411,
  [2412] = 1757,
  [2413] = 1758,
  [2414] = 1776,
  [2415] = 1722,
  [2416] = 1778,
  [2417] = 1777,
  [2418] = 1759,
  [2419] = 1760,
  [2420] = 1761,
  [2421] = 1762,
  [2422] = 1813,
  [2423] = 1763,
  [2424] = 1764,
  [2425] = 2425,
  [2426] = 1765,
  [2427] = 1894,
  [2428] = 2383,
  [2429] = 2429,
  [2430] = 1531,
  [2431] = 2431,
  [2432] = 1705,
  [2433] = 2433,
  [2434] = 2434,
  [2435] = 2435,
  [2436] = 1706,
  [2437] = 2437,
  [2438] = 2374,
  [2439] = 2439,
  [2440] = 2440,
  [2441] = 2377,
  [2442] = 1539,
  [2443] = 2443,
  [2444] = 2444,
  [2445] = 2374,
  [2446] = 1753,
  [2447] = 1754,
  [2448] = 1651,
  [2449] = 1787,
  [2450] = 2439,
  [2451] = 2451,
  [2452] = 2440,
  [2453] = 214,
  [2454] = 2435,
  [2455] = 2455,
  [2456] = 1867,
  [2457] = 2374,
  [2458] = 1739,
  [2459] = 2444,
  [2460] = 1867,
  [2461] = 2461,
  [2462] = 1535,
  [2463] = 2463,
  [2464] = 1549,
  [2465] = 1740,
  [2466] = 2466,
  [2467] = 1794,
  [2468] = 1741,
  [2469] = 1743,
  [2470] = 1670,
  [2471] = 1744,
  [2472] = 1528,
  [2473] = 2374,
  [2474] = 1745,
  [2475] = 2443,
  [2476] = 1707,
  [2477] = 1670,
  [2478] = 2478,
  [2479] = 1746,
  [2480] = 1710,
  [2481] = 1747,
  [2482] = 1748,
  [2483] = 1749,
  [2484] = 1739,
  [2485] = 1740,
  [2486] = 1741,
  [2487] = 1743,
  [2488] = 1744,
  [2489] = 1745,
  [2490] = 1746,
  [2491] = 1747,
  [2492] = 1748,
  [2493] = 1749,
  [2494] = 1779,
  [2495] = 1751,
  [2496] = 1752,
  [2497] = 1753,
  [2498] = 1754,
  [2499] = 1755,
  [2500] = 1756,
  [2501] = 1757,
  [2502] = 1758,
  [2503] = 1759,
  [2504] = 1760,
  [2505] = 1761,
  [2506] = 1762,
  [2507] = 1763,
  [2508] = 1764,
  [2509] = 1765,
  [2510] = 2510,
  [2511] = 1706,
  [2512] = 1779,
  [2513] = 214,
  [2514] = 1776,
  [2515] = 1722,
  [2516] = 1778,
  [2517] = 1777,
  [2518] = 1751,
  [2519] = 1752,
  [2520] = 2520,
  [2521] = 1867,
  [2522] = 1528,
  [2523] = 1867,
  [2524] = 2524,
  [2525] = 991,
  [2526] = 2526,
  [2527] = 1739,
  [2528] = 1740,
  [2529] = 1743,
  [2530] = 1744,
  [2531] = 1745,
  [2532] = 1746,
  [2533] = 1747,
  [2534] = 1748,
  [2535] = 1749,
  [2536] = 1779,
  [2537] = 1751,
  [2538] = 1752,
  [2539] = 1753,
  [2540] = 1754,
  [2541] = 1755,
  [2542] = 1756,
  [2543] = 1757,
  [2544] = 1758,
  [2545] = 1759,
  [2546] = 1760,
  [2547] = 1761,
  [2548] = 1762,
  [2549] = 1763,
  [2550] = 1764,
  [2551] = 1765,
  [2552] = 1894,
  [2553] = 2553,
  [2554] = 2554,
  [2555] = 2555,
  [2556] = 2556,
  [2557] = 1670,
  [2558] = 1705,
  [2559] = 1706,
  [2560] = 1651,
  [2561] = 988,
  [2562] = 1787,
  [2563] = 992,
  [2564] = 1670,
  [2565] = 1588,
  [2566] = 1647,
  [2567] = 1707,
  [2568] = 1710,
  [2569] = 2569,
  [2570] = 2570,
  [2571] = 1867,
  [2572] = 2572,
  [2573] = 2573,
  [2574] = 2574,
  [2575] = 2575,
  [2576] = 2576,
  [2577] = 1776,
  [2578] = 1722,
  [2579] = 1778,
  [2580] = 1777,
  [2581] = 2581,
  [2582] = 2582,
  [2583] = 2583,
  [2584] = 2584,
  [2585] = 2585,
  [2586] = 2586,
  [2587] = 2572,
  [2588] = 2572,
  [2589] = 2572,
  [2590] = 2572,
  [2591] = 2553,
  [2592] = 2572,
  [2593] = 2593,
  [2594] = 2594,
  [2595] = 2572,
  [2596] = 2596,
  [2597] = 2597,
  [2598] = 2598,
  [2599] = 1528,
  [2600] = 2600,
  [2601] = 2572,
  [2602] = 2602,
  [2603] = 2603,
  [2604] = 2572,
  [2605] = 2605,
  [2606] = 2572,
  [2607] = 2607,
  [2608] = 1741,
  [2609] = 2118,
  [2610] = 2610,
  [2611] = 2611,
  [2612] = 2612,
  [2613] = 2117,
  [2614] = 2118,
  [2615] = 2117,
  [2616] = 2118,
  [2617] = 2117,
  [2618] = 2118,
  [2619] = 2619,
  [2620] = 2117,
  [2621] = 2621,
  [2622] = 2433,
  [2623] = 2623,
  [2624] = 2624,
  [2625] = 2625,
  [2626] = 2117,
  [2627] = 2117,
  [2628] = 2118,
  [2629] = 2118,
  [2630] = 2630,
  [2631] = 2631,
  [2632] = 2632,
  [2633] = 2633,
  [2634] = 2634,
  [2635] = 2635,
  [2636] = 2636,
  [2637] = 2637,
  [2638] = 1827,
  [2639] = 2639,
  [2640] = 2640,
  [2641] = 2641,
  [2642] = 1528,
  [2643] = 1528,
  [2644] = 2611,
  [2645] = 2645,
  [2646] = 1528,
  [2647] = 2647,
  [2648] = 236,
  [2649] = 2649,
  [2650] = 2650,
  [2651] = 2651,
  [2652] = 2652,
  [2653] = 2653,
  [2654] = 2654,
  [2655] = 2655,
  [2656] = 2656,
  [2657] = 2657,
  [2658] = 2658,
  [2659] = 2659,
  [2660] = 2660,
  [2661] = 2661,
  [2662] = 2662,
  [2663] = 2663,
  [2664] = 2664,
  [2665] = 2665,
  [2666] = 2666,
  [2667] = 2652,
  [2668] = 2668,
  [2669] = 2669,
  [2670] = 2670,
  [2671] = 2671,
  [2672] = 2672,
  [2673] = 2673,
  [2674] = 2674,
  [2675] = 2652,
  [2676] = 2652,
  [2677] = 2652,
  [2678] = 235,
  [2679] = 2679,
  [2680] = 2680,
  [2681] = 212,
  [2682] = 2652,
  [2683] = 2683,
  [2684] = 210,
  [2685] = 2685,
  [2686] = 2652,
  [2687] = 2687,
  [2688] = 2688,
  [2689] = 2652,
  [2690] = 2690,
  [2691] = 2691,
  [2692] = 2692,
  [2693] = 2693,
  [2694] = 1648,
  [2695] = 2695,
  [2696] = 2696,
  [2697] = 212,
  [2698] = 236,
  [2699] = 2699,
  [2700] = 2700,
  [2701] = 2701,
  [2702] = 2702,
  [2703] = 2703,
  [2704] = 2704,
  [2705] = 2705,
  [2706] = 2652,
  [2707] = 2707,
  [2708] = 2708,
  [2709] = 2652,
  [2710] = 2710,
  [2711] = 1246,
  [2712] = 2712,
  [2713] = 2554,
  [2714] = 2555,
  [2715] = 235,
  [2716] = 2716,
  [2717] = 2717,
  [2718] = 2718,
  [2719] = 1633,
  [2720] = 2720,
  [2721] = 2721,
  [2722] = 2722,
  [2723] = 210,
  [2724] = 2724,
  [2725] = 2725,
  [2726] = 2726,
  [2727] = 2727,
  [2728] = 2728,
  [2729] = 1272,
  [2730] = 2196,
  [2731] = 2731,
  [2732] = 2732,
  [2733] = 2340,
  [2734] = 2114,
  [2735] = 2735,
  [2736] = 2736,
  [2737] = 2252,
  [2738] = 2738,
  [2739] = 2380,
  [2740] = 2461,
  [2741] = 2524,
  [2742] = 2443,
  [2743] = 2443,
  [2744] = 2463,
  [2745] = 2375,
  [2746] = 2444,
  [2747] = 2383,
  [2748] = 2461,
  [2749] = 2434,
  [2750] = 2750,
  [2751] = 2444,
  [2752] = 2752,
  [2753] = 2524,
  [2754] = 2520,
  [2755] = 2520,
  [2756] = 2455,
  [2757] = 2757,
  [2758] = 2758,
  [2759] = 2455,
  [2760] = 2757,
  [2761] = 1269,
  [2762] = 2510,
  [2763] = 2750,
  [2764] = 2440,
  [2765] = 2440,
  [2766] = 2766,
  [2767] = 2767,
  [2768] = 2383,
  [2769] = 2769,
  [2770] = 2770,
  [2771] = 2771,
  [2772] = 2769,
  [2773] = 2773,
  [2774] = 2774,
  [2775] = 2775,
  [2776] = 2776,
  [2777] = 2775,
  [2778] = 2776,
  [2779] = 2779,
  [2780] = 2780,
  [2781] = 2781,
  [2782] = 2779,
  [2783] = 2780,
  [2784] = 2784,
  [2785] = 2784,
  [2786] = 2786,
  [2787] = 2770,
  [2788] = 2770,
  [2789] = 2789,
  [2790] = 1287,
  [2791] = 2791,
  [2792] = 2792,
  [2793] = 2793,
  [2794] = 2794,
  [2795] = 2795,
  [2796] = 2796,
  [2797] = 2797,
  [2798] = 2798,
  [2799] = 2799,
  [2800] = 2800,
  [2801] = 2801,
  [2802] = 1344,
  [2803] = 2803,
  [2804] = 1332,
  [2805] = 2805,
  [2806] = 1317,
  [2807] = 2807,
  [2808] = 2808,
  [2809] = 2809,
  [2810] = 1288,
  [2811] = 2811,
  [2812] = 2451,
  [2813] = 2813,
  [2814] = 2814,
  [2815] = 2815,
  [2816] = 2816,
  [2817] = 2817,
  [2818] = 2818,
  [2819] = 2819,
  [2820] = 2820,
  [2821] = 2821,
  [2822] = 2822,
  [2823] = 2823,
  [2824] = 2824,
  [2825] = 2825,
  [2826] = 2826,
  [2827] = 2827,
  [2828] = 2825,
  [2829] = 2829,
  [2830] = 2830,
  [2831] = 2831,
  [2832] = 2832,
  [2833] = 2833,
  [2834] = 2834,
  [2835] = 2835,
  [2836] = 2831,
  [2837] = 2817,
  [2838] = 2838,
  [2839] = 2839,
  [2840] = 2839,
  [2841] = 2841,
  [2842] = 2838,
  [2843] = 2843,
  [2844] = 2827,
  [2845] = 2845,
  [2846] = 2841,
  [2847] = 2847,
  [2848] = 2848,
  [2849] = 2849,
  [2850] = 2850,
  [2851] = 2851,
  [2852] = 2852,
  [2853] = 2853,
  [2854] = 2854,
  [2855] = 2845,
  [2856] = 2856,
  [2857] = 2857,
  [2858] = 2858,
  [2859] = 2859,
  [2860] = 2835,
  [2861] = 2832,
  [2862] = 2862,
  [2863] = 2863,
  [2864] = 2864,
  [2865] = 2865,
  [2866] = 2866,
  [2867] = 2834,
  [2868] = 2868,
  [2869] = 2822,
  [2870] = 2870,
  [2871] = 2871,
  [2872] = 2872,
  [2873] = 2873,
  [2874] = 2874,
  [2875] = 2875,
  [2876] = 1509,
  [2877] = 1506,
  [2878] = 1504,
  [2879] = 1623,
  [2880] = 1587,
  [2881] = 1591,
  [2882] = 1597,
  [2883] = 1572,
  [2884] = 1570,
  [2885] = 1573,
  [2886] = 1575,
  [2887] = 1571,
  [2888] = 1583,
  [2889] = 1540,
  [2890] = 1599,
  [2891] = 1585,
  [2892] = 1625,
  [2893] = 1584,
  [2894] = 1596,
  [2895] = 1530,
  [2896] = 1532,
  [2897] = 1533,
  [2898] = 1589,
  [2899] = 1537,
  [2900] = 1538,
  [2901] = 1542,
  [2902] = 1565,
  [2903] = 1566,
  [2904] = 1567,
  [2905] = 1543,
  [2906] = 1568,
  [2907] = 1546,
  [2908] = 1547,
  [2909] = 1569,
  [2910] = 1650,
  [2911] = 1586,
  [2912] = 1636,
  [2913] = 213,
  [2914] = 219,
  [2915] = 1639,
  [2916] = 1550,
  [2917] = 1602,
  [2918] = 1604,
  [2919] = 1641,
  [2920] = 1610,
  [2921] = 2921,
  [2922] = 1562,
  [2923] = 1512,
  [2924] = 1624,
  [2925] = 1504,
  [2926] = 1628,
  [2927] = 1629,
  [2928] = 1638,
  [2929] = 1630,
  [2930] = 1640,
  [2931] = 1509,
  [2932] = 1505,
  [2933] = 1506,
  [2934] = 1548,
  [2935] = 1522,
  [2936] = 1529,
  [2937] = 1514,
  [2938] = 1574,
  [2939] = 1527,
  [2940] = 1516,
  [2941] = 1589,
  [2942] = 2942,
  [2943] = 1568,
  [2944] = 2944,
  [2945] = 2945,
  [2946] = 1569,
  [2947] = 1553,
  [2948] = 2948,
  [2949] = 1649,
  [2950] = 1636,
  [2951] = 1506,
  [2952] = 1530,
  [2953] = 1532,
  [2954] = 1533,
  [2955] = 1577,
  [2956] = 1583,
  [2957] = 1551,
  [2958] = 1584,
  [2959] = 1585,
  [2960] = 1599,
  [2961] = 1586,
  [2962] = 1600,
  [2963] = 1587,
  [2964] = 1626,
  [2965] = 1591,
  [2966] = 1650,
  [2967] = 1596,
  [2968] = 2942,
  [2969] = 1597,
  [2970] = 1620,
  [2971] = 1558,
  [2972] = 1578,
  [2973] = 1611,
  [2974] = 2948,
  [2975] = 1609,
  [2976] = 1646,
  [2977] = 2942,
  [2978] = 1637,
  [2979] = 2979,
  [2980] = 2979,
  [2981] = 1554,
  [2982] = 2944,
  [2983] = 1570,
  [2984] = 2944,
  [2985] = 2945,
  [2986] = 2979,
  [2987] = 1540,
  [2988] = 1598,
  [2989] = 1571,
  [2990] = 1572,
  [2991] = 1580,
  [2992] = 1576,
  [2993] = 1567,
  [2994] = 1632,
  [2995] = 1565,
  [2996] = 2948,
  [2997] = 1573,
  [2998] = 1559,
  [2999] = 1613,
  [3000] = 2942,
  [3001] = 1614,
  [3002] = 2944,
  [3003] = 2979,
  [3004] = 2979,
  [3005] = 1623,
  [3006] = 2945,
  [3007] = 1544,
  [3008] = 2945,
  [3009] = 2979,
  [3010] = 1563,
  [3011] = 1621,
  [3012] = 1625,
  [3013] = 2979,
  [3014] = 1537,
  [3015] = 1603,
  [3016] = 1505,
  [3017] = 1538,
  [3018] = 1560,
  [3019] = 1594,
  [3020] = 2979,
  [3021] = 1642,
  [3022] = 1575,
  [3023] = 1631,
  [3024] = 1635,
  [3025] = 2979,
  [3026] = 1504,
  [3027] = 1542,
  [3028] = 1543,
  [3029] = 2979,
  [3030] = 1545,
  [3031] = 1546,
  [3032] = 2948,
  [3033] = 1547,
  [3034] = 2948,
  [3035] = 2942,
  [3036] = 2944,
  [3037] = 1509,
  [3038] = 1566,
  [3039] = 1556,
  [3040] = 2945,
  [3041] = 1536,
  [3042] = 1622,
  [3043] = 3043,
  [3044] = 3044,
  [3045] = 3045,
  [3046] = 3046,
  [3047] = 3047,
  [3048] = 3048,
  [3049] = 3047,
  [3050] = 3048,
  [3051] = 3048,
  [3052] = 3048,
  [3053] = 3047,
  [3054] = 1523,
  [3055] = 3047,
  [3056] = 1524,
  [3057] = 3057,
  [3058] = 3058,
  [3059] = 1525,
  [3060] = 3060,
  [3061] = 3047,
  [3062] = 3062,
  [3063] = 3063,
  [3064] = 3064,
  [3065] = 3065,
  [3066] = 3066,
  [3067] = 3067,
  [3068] = 3048,
  [3069] = 3069,
  [3070] = 3070,
  [3071] = 3071,
  [3072] = 3072,
  [3073] = 3073,
  [3074] = 3074,
  [3075] = 3047,
  [3076] = 1514,
  [3077] = 1512,
  [3078] = 3047,
  [3079] = 3079,
  [3080] = 3080,
  [3081] = 3081,
  [3082] = 3082,
  [3083] = 3083,
  [3084] = 1538,
  [3085] = 3085,
  [3086] = 1602,
  [3087] = 3087,
  [3088] = 988,
  [3089] = 1604,
  [3090] = 1610,
  [3091] = 1624,
  [3092] = 1628,
  [3093] = 1629,
  [3094] = 991,
  [3095] = 1634,
  [3096] = 1644,
  [3097] = 3097,
  [3098] = 3098,
  [3099] = 992,
  [3100] = 1630,
  [3101] = 1638,
  [3102] = 1639,
  [3103] = 1640,
  [3104] = 1641,
  [3105] = 3105,
  [3106] = 1552,
  [3107] = 1540,
  [3108] = 1599,
  [3109] = 1623,
  [3110] = 1625,
  [3111] = 3111,
  [3112] = 1636,
  [3113] = 1530,
  [3114] = 1532,
  [3115] = 1533,
  [3116] = 1537,
  [3117] = 1542,
  [3118] = 1543,
  [3119] = 1546,
  [3120] = 1547,
  [3121] = 1565,
  [3122] = 1566,
  [3123] = 1567,
  [3124] = 1562,
  [3125] = 1569,
  [3126] = 1570,
  [3127] = 1571,
  [3128] = 1572,
  [3129] = 1505,
  [3130] = 1573,
  [3131] = 1575,
  [3132] = 1583,
  [3133] = 1584,
  [3134] = 1585,
  [3135] = 3135,
  [3136] = 1586,
  [3137] = 1587,
  [3138] = 1589,
  [3139] = 1591,
  [3140] = 1650,
  [3141] = 1596,
  [3142] = 1597,
  [3143] = 3143,
  [3144] = 3144,
  [3145] = 1557,
  [3146] = 1561,
  [3147] = 3147,
  [3148] = 1643,
  [3149] = 1645,
  [3150] = 1595,
  [3151] = 1527,
  [3152] = 3152,
  [3153] = 1592,
  [3154] = 1605,
  [3155] = 1550,
  [3156] = 1568,
  [3157] = 3157,
  [3158] = 1512,
  [3159] = 3159,
  [3160] = 3160,
  [3161] = 3161,
  [3162] = 3162,
  [3163] = 3163,
  [3164] = 3164,
  [3165] = 1170,
  [3166] = 1525,
  [3167] = 3167,
  [3168] = 1548,
  [3169] = 3169,
  [3170] = 3170,
  [3171] = 3171,
  [3172] = 3172,
  [3173] = 3173,
  [3174] = 3174,
  [3175] = 3167,
  [3176] = 3176,
  [3177] = 3177,
  [3178] = 3178,
  [3179] = 1166,
  [3180] = 3180,
  [3181] = 1514,
  [3182] = 3182,
  [3183] = 3183,
  [3184] = 3167,
  [3185] = 3185,
  [3186] = 3167,
  [3187] = 3187,
  [3188] = 3188,
  [3189] = 3189,
  [3190] = 3190,
  [3191] = 3191,
  [3192] = 3192,
  [3193] = 1522,
  [3194] = 3194,
  [3195] = 3195,
  [3196] = 1504,
  [3197] = 1509,
  [3198] = 1506,
  [3199] = 3199,
  [3200] = 1574,
  [3201] = 1171,
  [3202] = 3202,
  [3203] = 3203,
  [3204] = 1516,
  [3205] = 3205,
  [3206] = 1529,
  [3207] = 1523,
  [3208] = 3208,
  [3209] = 3209,
  [3210] = 3210,
  [3211] = 3211,
  [3212] = 1524,
  [3213] = 3213,
  [3214] = 3167,
  [3215] = 1603,
  [3216] = 1649,
  [3217] = 1545,
  [3218] = 713,
  [3219] = 1552,
  [3220] = 1550,
  [3221] = 1562,
  [3222] = 1592,
  [3223] = 988,
  [3224] = 1602,
  [3225] = 1604,
  [3226] = 1610,
  [3227] = 3227,
  [3228] = 1624,
  [3229] = 1631,
  [3230] = 1628,
  [3231] = 1629,
  [3232] = 1576,
  [3233] = 1630,
  [3234] = 1638,
  [3235] = 1639,
  [3236] = 1640,
  [3237] = 1641,
  [3238] = 991,
  [3239] = 1577,
  [3240] = 1578,
  [3241] = 711,
  [3242] = 1634,
  [3243] = 1600,
  [3244] = 1605,
  [3245] = 715,
  [3246] = 1642,
  [3247] = 992,
  [3248] = 1644,
  [3249] = 1646,
  [3250] = 1626,
  [3251] = 1645,
  [3252] = 712,
  [3253] = 3253,
  [3254] = 1558,
  [3255] = 1609,
  [3256] = 3256,
  [3257] = 1611,
  [3258] = 1613,
  [3259] = 1551,
  [3260] = 1614,
  [3261] = 1553,
  [3262] = 1505,
  [3263] = 1621,
  [3264] = 1620,
  [3265] = 1632,
  [3266] = 1635,
  [3267] = 1557,
  [3268] = 3174,
  [3269] = 1559,
  [3270] = 1560,
  [3271] = 1544,
  [3272] = 1554,
  [3273] = 1556,
  [3274] = 1536,
  [3275] = 1561,
  [3276] = 1643,
  [3277] = 714,
  [3278] = 1527,
  [3279] = 3279,
  [3280] = 1563,
  [3281] = 1580,
  [3282] = 1594,
  [3283] = 1595,
  [3284] = 1598,
  [3285] = 1622,
  [3286] = 1637,
  [3287] = 1522,
  [3288] = 1525,
  [3289] = 1548,
  [3290] = 3290,
  [3291] = 3291,
  [3292] = 3292,
  [3293] = 3291,
  [3294] = 3294,
  [3295] = 3295,
  [3296] = 3296,
  [3297] = 3290,
  [3298] = 3298,
  [3299] = 3299,
  [3300] = 3290,
  [3301] = 1523,
  [3302] = 3302,
  [3303] = 1514,
  [3304] = 3304,
  [3305] = 1524,
  [3306] = 1505,
  [3307] = 3307,
  [3308] = 3291,
  [3309] = 1516,
  [3310] = 3294,
  [3311] = 1574,
  [3312] = 3312,
  [3313] = 3313,
  [3314] = 3314,
  [3315] = 3315,
  [3316] = 3298,
  [3317] = 1529,
  [3318] = 3318,
  [3319] = 1626,
  [3320] = 3320,
  [3321] = 3321,
  [3322] = 1613,
  [3323] = 3323,
  [3324] = 3324,
  [3325] = 1614,
  [3326] = 3326,
  [3327] = 1576,
  [3328] = 1577,
  [3329] = 1578,
  [3330] = 3315,
  [3331] = 711,
  [3332] = 1621,
  [3333] = 3333,
  [3334] = 3334,
  [3335] = 1592,
  [3336] = 1637,
  [3337] = 714,
  [3338] = 1649,
  [3339] = 1552,
  [3340] = 3302,
  [3341] = 3341,
  [3342] = 3342,
  [3343] = 3343,
  [3344] = 1600,
  [3345] = 1605,
  [3346] = 213,
  [3347] = 1558,
  [3348] = 3348,
  [3349] = 3349,
  [3350] = 3350,
  [3351] = 1170,
  [3352] = 219,
  [3353] = 3167,
  [3354] = 1645,
  [3355] = 1631,
  [3356] = 1634,
  [3357] = 1166,
  [3358] = 3358,
  [3359] = 1171,
  [3360] = 3360,
  [3361] = 3304,
  [3362] = 3362,
  [3363] = 1545,
  [3364] = 3167,
  [3365] = 3365,
  [3366] = 3366,
  [3367] = 3367,
  [3368] = 3368,
  [3369] = 3369,
  [3370] = 3167,
  [3371] = 3371,
  [3372] = 1166,
  [3373] = 1642,
  [3374] = 3167,
  [3375] = 1644,
  [3376] = 3376,
  [3377] = 3377,
  [3378] = 1646,
  [3379] = 3379,
  [3380] = 3380,
  [3381] = 3381,
  [3382] = 1170,
  [3383] = 1563,
  [3384] = 1643,
  [3385] = 3385,
  [3386] = 712,
  [3387] = 3387,
  [3388] = 1514,
  [3389] = 3349,
  [3390] = 715,
  [3391] = 3391,
  [3392] = 3392,
  [3393] = 3393,
  [3394] = 3394,
  [3395] = 3341,
  [3396] = 3396,
  [3397] = 3397,
  [3398] = 1622,
  [3399] = 3399,
  [3400] = 3400,
  [3401] = 1603,
  [3402] = 3402,
  [3403] = 3403,
  [3404] = 3404,
  [3405] = 3405,
  [3406] = 1594,
  [3407] = 3381,
  [3408] = 3408,
  [3409] = 3409,
  [3410] = 3410,
  [3411] = 3341,
  [3412] = 1512,
  [3413] = 3413,
  [3414] = 3414,
  [3415] = 3415,
  [3416] = 3416,
  [3417] = 3167,
  [3418] = 3418,
  [3419] = 3419,
  [3420] = 1609,
  [3421] = 3416,
  [3422] = 3422,
  [3423] = 3423,
  [3424] = 3413,
  [3425] = 3425,
  [3426] = 3426,
  [3427] = 3167,
  [3428] = 3428,
  [3429] = 3429,
  [3430] = 1551,
  [3431] = 1620,
  [3432] = 1553,
  [3433] = 1557,
  [3434] = 3349,
  [3435] = 3365,
  [3436] = 1595,
  [3437] = 1632,
  [3438] = 3362,
  [3439] = 1635,
  [3440] = 3440,
  [3441] = 3404,
  [3442] = 3442,
  [3443] = 1171,
  [3444] = 1559,
  [3445] = 1560,
  [3446] = 3446,
  [3447] = 1561,
  [3448] = 1544,
  [3449] = 3449,
  [3450] = 1554,
  [3451] = 3451,
  [3452] = 3452,
  [3453] = 1556,
  [3454] = 1536,
  [3455] = 1598,
  [3456] = 713,
  [3457] = 1611,
  [3458] = 3458,
  [3459] = 3459,
  [3460] = 3460,
  [3461] = 3461,
  [3462] = 3462,
  [3463] = 1580,
  [3464] = 3464,
  [3465] = 3465,
  [3466] = 3466,
  [3467] = 3467,
  [3468] = 3468,
  [3469] = 3469,
  [3470] = 3470,
  [3471] = 3174,
  [3472] = 3472,
  [3473] = 3473,
  [3474] = 3472,
  [3475] = 3473,
  [3476] = 3473,
  [3477] = 3473,
  [3478] = 3473,
  [3479] = 3473,
  [3480] = 3469,
  [3481] = 3472,
  [3482] = 213,
  [3483] = 219,
  [3484] = 3473,
  [3485] = 3485,
  [3486] = 3472,
  [3487] = 1527,
  [3488] = 3488,
  [3489] = 991,
  [3490] = 992,
  [3491] = 3491,
  [3492] = 3492,
  [3493] = 1523,
  [3494] = 1524,
  [3495] = 3495,
  [3496] = 3472,
  [3497] = 3497,
  [3498] = 3498,
  [3499] = 200,
  [3500] = 201,
  [3501] = 3473,
  [3502] = 3302,
  [3503] = 1525,
  [3504] = 3472,
  [3505] = 3505,
  [3506] = 988,
  [3507] = 3507,
  [3508] = 3508,
  [3509] = 3509,
  [3510] = 3510,
  [3511] = 3511,
  [3512] = 3512,
  [3513] = 3513,
  [3514] = 3514,
  [3515] = 3515,
  [3516] = 3516,
  [3517] = 3517,
  [3518] = 3518,
  [3519] = 3519,
  [3520] = 3520,
  [3521] = 3521,
  [3522] = 3522,
  [3523] = 3523,
  [3524] = 3524,
  [3525] = 3299,
  [3526] = 3526,
  [3527] = 3527,
  [3528] = 3528,
  [3529] = 3529,
  [3530] = 3530,
  [3531] = 3531,
  [3532] = 3532,
  [3533] = 3533,
  [3534] = 3534,
  [3535] = 3535,
  [3536] = 3536,
  [3537] = 3537,
  [3538] = 3538,
  [3539] = 3539,
  [3540] = 3540,
  [3541] = 3541,
  [3542] = 1605,
  [3543] = 3508,
  [3544] = 3544,
  [3545] = 3545,
  [3546] = 3540,
  [3547] = 3547,
  [3548] = 3548,
  [3549] = 1525,
  [3550] = 3550,
  [3551] = 3551,
  [3552] = 3552,
  [3553] = 3553,
  [3554] = 3554,
  [3555] = 3555,
  [3556] = 3556,
  [3557] = 3557,
  [3558] = 3558,
  [3559] = 3559,
  [3560] = 3560,
  [3561] = 3561,
  [3562] = 3562,
  [3563] = 3508,
  [3564] = 3564,
  [3565] = 3565,
  [3566] = 3566,
  [3567] = 3567,
  [3568] = 3568,
  [3569] = 3569,
  [3570] = 3508,
  [3571] = 3571,
  [3572] = 3540,
  [3573] = 3573,
  [3574] = 3508,
  [3575] = 3540,
  [3576] = 3576,
  [3577] = 3577,
  [3578] = 3578,
  [3579] = 3579,
  [3580] = 3580,
  [3581] = 3555,
  [3582] = 3582,
  [3583] = 3583,
  [3584] = 3584,
  [3585] = 3585,
  [3586] = 3586,
  [3587] = 3366,
  [3588] = 3588,
  [3589] = 3589,
  [3590] = 3590,
  [3591] = 3591,
  [3592] = 3592,
  [3593] = 3508,
  [3594] = 3594,
  [3595] = 3595,
  [3596] = 3595,
  [3597] = 3597,
  [3598] = 3598,
  [3599] = 3540,
  [3600] = 3577,
  [3601] = 3601,
  [3602] = 3602,
  [3603] = 3603,
  [3604] = 3604,
  [3605] = 3605,
  [3606] = 3606,
  [3607] = 3607,
  [3608] = 3608,
  [3609] = 3540,
  [3610] = 3605,
  [3611] = 3611,
  [3612] = 3612,
  [3613] = 3613,
  [3614] = 3371,
  [3615] = 3615,
  [3616] = 3545,
  [3617] = 3617,
  [3618] = 3618,
  [3619] = 3619,
  [3620] = 3620,
  [3621] = 3594,
  [3622] = 3622,
  [3623] = 3623,
  [3624] = 3624,
  [3625] = 3625,
  [3626] = 3626,
  [3627] = 3627,
  [3628] = 3628,
  [3629] = 3629,
  [3630] = 3630,
  [3631] = 3631,
  [3632] = 3632,
  [3633] = 3633,
  [3634] = 3634,
  [3635] = 3635,
  [3636] = 3636,
  [3637] = 3637,
  [3638] = 3507,
  [3639] = 3636,
  [3640] = 3640,
  [3641] = 3641,
  [3642] = 3642,
  [3643] = 3643,
  [3644] = 3377,
  [3645] = 3619,
  [3646] = 3646,
  [3647] = 3647,
  [3648] = 3648,
  [3649] = 3649,
  [3650] = 3634,
  [3651] = 3651,
  [3652] = 3652,
  [3653] = 3653,
  [3654] = 3654,
  [3655] = 3655,
  [3656] = 3656,
  [3657] = 3657,
  [3658] = 3658,
  [3659] = 3659,
  [3660] = 1595,
  [3661] = 1592,
  [3662] = 1552,
  [3663] = 3508,
  [3664] = 3664,
  [3665] = 3665,
  [3666] = 3666,
  [3667] = 3410,
  [3668] = 3668,
  [3669] = 3669,
  [3670] = 3670,
  [3671] = 3671,
  [3672] = 3672,
  [3673] = 3673,
  [3674] = 3674,
  [3675] = 3545,
  [3676] = 3643,
  [3677] = 3652,
  [3678] = 3678,
  [3679] = 3679,
  [3680] = 3532,
  [3681] = 3681,
  [3682] = 3682,
  [3683] = 3683,
  [3684] = 3684,
  [3685] = 3666,
  [3686] = 3686,
  [3687] = 3687,
  [3688] = 3688,
  [3689] = 3555,
  [3690] = 3690,
  [3691] = 3691,
  [3692] = 3579,
  [3693] = 3642,
  [3694] = 3253,
  [3695] = 3508,
  [3696] = 1523,
  [3697] = 1524,
  [3698] = 203,
  [3699] = 3699,
  [3700] = 3700,
  [3701] = 3701,
  [3702] = 3409,
  [3703] = 3703,
  [3704] = 3704,
  [3705] = 3705,
  [3706] = 3706,
  [3707] = 3707,
  [3708] = 3708,
  [3709] = 3709,
  [3710] = 3710,
  [3711] = 1634,
  [3712] = 3712,
  [3713] = 1644,
  [3714] = 3714,
  [3715] = 3715,
  [3716] = 3578,
  [3717] = 3590,
  [3718] = 3718,
  [3719] = 3642,
  [3720] = 3709,
  [3721] = 3721,
  [3722] = 3722,
  [3723] = 3634,
  [3724] = 3724,
  [3725] = 3725,
  [3726] = 3726,
  [3727] = 3727,
  [3728] = 3728,
  [3729] = 3729,
  [3730] = 1557,
  [3731] = 1561,
  [3732] = 1643,
  [3733] = 1645,
  [3734] = 3734,
  [3735] = 3735,
  [3736] = 3736,
  [3737] = 3737,
  [3738] = 3738,
  [3739] = 3540,
  [3740] = 239,
  [3741] = 3741,
  [3742] = 3742,
  [3743] = 240,
  [3744] = 3558,
  [3745] = 3745,
  [3746] = 3746,
  [3747] = 3747,
  [3748] = 3748,
  [3749] = 3749,
  [3750] = 3750,
  [3751] = 3606,
  [3752] = 3752,
  [3753] = 3753,
  [3754] = 3524,
  [3755] = 3755,
  [3756] = 3749,
  [3757] = 3527,
  [3758] = 3758,
  [3759] = 3625,
  [3760] = 712,
  [3761] = 3761,
  [3762] = 3668,
  [3763] = 1643,
  [3764] = 3764,
  [3765] = 3304,
  [3766] = 1645,
  [3767] = 1595,
  [3768] = 3755,
  [3769] = 1592,
  [3770] = 3649,
  [3771] = 1552,
  [3772] = 713,
  [3773] = 3773,
  [3774] = 3774,
  [3775] = 3755,
  [3776] = 711,
  [3777] = 3777,
  [3778] = 3778,
  [3779] = 3227,
  [3780] = 3780,
  [3781] = 3781,
  [3782] = 3782,
  [3783] = 3626,
  [3784] = 3755,
  [3785] = 3764,
  [3786] = 3786,
  [3787] = 3787,
  [3788] = 3755,
  [3789] = 3707,
  [3790] = 3786,
  [3791] = 3791,
  [3792] = 3792,
  [3793] = 3786,
  [3794] = 3794,
  [3795] = 3795,
  [3796] = 3631,
  [3797] = 3794,
  [3798] = 3798,
  [3799] = 3589,
  [3800] = 3632,
  [3801] = 3750,
  [3802] = 3802,
  [3803] = 3794,
  [3804] = 3804,
  [3805] = 3547,
  [3806] = 3315,
  [3807] = 3807,
  [3808] = 3794,
  [3809] = 3777,
  [3810] = 3777,
  [3811] = 3811,
  [3812] = 3812,
  [3813] = 3640,
  [3814] = 3786,
  [3815] = 3777,
  [3816] = 3816,
  [3817] = 3817,
  [3818] = 3818,
  [3819] = 3627,
  [3820] = 3598,
  [3821] = 3761,
  [3822] = 3752,
  [3823] = 3823,
  [3824] = 1557,
  [3825] = 3825,
  [3826] = 3826,
  [3827] = 3827,
  [3828] = 3780,
  [3829] = 3829,
  [3830] = 3774,
  [3831] = 3831,
  [3832] = 3832,
  [3833] = 3833,
  [3834] = 3834,
  [3835] = 3835,
  [3836] = 3836,
  [3837] = 3837,
  [3838] = 1605,
  [3839] = 3601,
  [3840] = 3840,
  [3841] = 3841,
  [3842] = 3826,
  [3843] = 3843,
  [3844] = 3777,
  [3845] = 3845,
  [3846] = 3846,
  [3847] = 3604,
  [3848] = 3597,
  [3849] = 1561,
  [3850] = 1644,
  [3851] = 3851,
  [3852] = 3852,
  [3853] = 3816,
  [3854] = 3823,
  [3855] = 3633,
  [3856] = 3856,
  [3857] = 1634,
  [3858] = 3858,
  [3859] = 3831,
  [3860] = 3833,
  [3861] = 3852,
  [3862] = 3862,
  [3863] = 3863,
  [3864] = 3750,
  [3865] = 3761,
  [3866] = 3804,
  [3867] = 3858,
  [3868] = 3794,
  [3869] = 3869,
  [3870] = 3608,
  [3871] = 3782,
  [3872] = 3851,
  [3873] = 3812,
  [3874] = 3874,
  [3875] = 3786,
  [3876] = 714,
  [3877] = 3877,
  [3878] = 3837,
  [3879] = 3750,
  [3880] = 3880,
  [3881] = 3559,
  [3882] = 3863,
  [3883] = 3755,
  [3884] = 3786,
  [3885] = 3521,
  [3886] = 3886,
  [3887] = 3777,
  [3888] = 3840,
  [3889] = 3750,
  [3890] = 3753,
  [3891] = 3750,
  [3892] = 715,
  [3893] = 3637,
  [3894] = 3831,
  [3895] = 3522,
  [3896] = 3794,
  [3897] = 3880,
  [3898] = 3836,
  [3899] = 3899,
  [3900] = 3714,
  [3901] = 3901,
  [3902] = 3902,
  [3903] = 3903,
  [3904] = 3904,
  [3905] = 3905,
  [3906] = 3906,
  [3907] = 3907,
  [3908] = 3908,
  [3909] = 3909,
  [3910] = 3910,
  [3911] = 3911,
  [3912] = 3912,
  [3913] = 3913,
  [3914] = 3914,
  [3915] = 3915,
  [3916] = 3916,
  [3917] = 3917,
  [3918] = 3811,
  [3919] = 3862,
  [3920] = 3920,
  [3921] = 3886,
  [3922] = 3922,
  [3923] = 3923,
  [3924] = 3924,
  [3925] = 921,
  [3926] = 929,
  [3927] = 938,
  [3928] = 942,
  [3929] = 944,
  [3930] = 3930,
  [3931] = 794,
  [3932] = 814,
  [3933] = 816,
  [3934] = 818,
  [3935] = 822,
  [3936] = 3936,
  [3937] = 3937,
  [3938] = 3938,
  [3939] = 3939,
  [3940] = 3940,
  [3941] = 3592,
  [3942] = 3942,
  [3943] = 839,
  [3944] = 3944,
  [3945] = 842,
  [3946] = 846,
  [3947] = 3947,
  [3948] = 3948,
  [3949] = 3949,
  [3950] = 3950,
  [3951] = 3951,
  [3952] = 3952,
  [3953] = 902,
  [3954] = 903,
  [3955] = 904,
  [3956] = 3956,
  [3957] = 3957,
  [3958] = 3958,
  [3959] = 3959,
  [3960] = 3960,
  [3961] = 3961,
  [3962] = 3962,
  [3963] = 3963,
  [3964] = 3964,
  [3965] = 3965,
  [3966] = 3966,
  [3967] = 3967,
  [3968] = 3968,
  [3969] = 3969,
  [3970] = 3970,
  [3971] = 3971,
  [3972] = 3972,
  [3973] = 3973,
  [3974] = 3974,
  [3975] = 3975,
  [3976] = 3976,
  [3977] = 3977,
  [3978] = 3978,
  [3979] = 812,
  [3980] = 3980,
  [3981] = 786,
  [3982] = 851,
  [3983] = 3983,
  [3984] = 869,
  [3985] = 870,
  [3986] = 3986,
  [3987] = 3987,
  [3988] = 3988,
  [3989] = 3989,
  [3990] = 3990,
  [3991] = 3991,
  [3992] = 873,
  [3993] = 3993,
  [3994] = 893,
  [3995] = 896,
  [3996] = 899,
  [3997] = 799,
  [3998] = 796,
  [3999] = 804,
  [4000] = 811,
  [4001] = 4001,
  [4002] = 788,
  [4003] = 4003,
  [4004] = 909,
  [4005] = 4005,
  [4006] = 4006,
  [4007] = 801,
  [4008] = 4008,
  [4009] = 4009,
  [4010] = 4010,
  [4011] = 923,
  [4012] = 4012,
  [4013] = 4013,
  [4014] = 4014,
  [4015] = 4015,
  [4016] = 879,
  [4017] = 857,
  [4018] = 866,
  [4019] = 4019,
  [4020] = 910,
  [4021] = 4021,
  [4022] = 4022,
  [4023] = 4023,
  [4024] = 4024,
  [4025] = 4025,
  [4026] = 4026,
  [4027] = 4027,
  [4028] = 4028,
  [4029] = 4029,
  [4030] = 4030,
  [4031] = 4031,
  [4032] = 934,
  [4033] = 936,
  [4034] = 939,
  [4035] = 941,
  [4036] = 911,
  [4037] = 4037,
  [4038] = 4038,
  [4039] = 3964,
  [4040] = 862,
  [4041] = 875,
  [4042] = 4012,
  [4043] = 912,
  [4044] = 792,
  [4045] = 797,
  [4046] = 3923,
  [4047] = 791,
  [4048] = 925,
  [4049] = 4049,
  [4050] = 4050,
  [4051] = 4051,
  [4052] = 4052,
  [4053] = 3944,
  [4054] = 4054,
  [4055] = 4055,
  [4056] = 4056,
  [4057] = 3901,
  [4058] = 4058,
  [4059] = 4059,
  [4060] = 4060,
  [4061] = 883,
  [4062] = 3964,
  [4063] = 885,
  [4064] = 4064,
  [4065] = 4065,
  [4066] = 4066,
  [4067] = 890,
  [4068] = 891,
  [4069] = 894,
  [4070] = 901,
  [4071] = 927,
  [4072] = 863,
  [4073] = 825,
  [4074] = 806,
  [4075] = 4075,
  [4076] = 4076,
  [4077] = 4077,
  [4078] = 859,
  [4079] = 4079,
  [4080] = 4080,
  [4081] = 4081,
  [4082] = 4082,
  [4083] = 4083,
  [4084] = 4084,
  [4085] = 3923,
  [4086] = 4086,
  [4087] = 3948,
  [4088] = 881,
  [4089] = 886,
  [4090] = 888,
  [4091] = 898,
  [4092] = 3901,
  [4093] = 4093,
  [4094] = 4009,
  [4095] = 4095,
  [4096] = 4096,
  [4097] = 4097,
  [4098] = 4098,
  [4099] = 4099,
  [4100] = 4100,
  [4101] = 4101,
  [4102] = 4102,
  [4103] = 4103,
  [4104] = 4005,
  [4105] = 4105,
  [4106] = 4106,
  [4107] = 3923,
  [4108] = 3901,
  [4109] = 4109,
  [4110] = 4110,
  [4111] = 4111,
  [4112] = 3901,
  [4113] = 4113,
  [4114] = 4114,
  [4115] = 4115,
  [4116] = 3971,
  [4117] = 4117,
  [4118] = 4118,
  [4119] = 4119,
  [4120] = 4120,
  [4121] = 4121,
  [4122] = 4122,
  [4123] = 4123,
  [4124] = 4124,
  [4125] = 3972,
  [4126] = 4126,
  [4127] = 4127,
  [4128] = 4128,
  [4129] = 4129,
  [4130] = 4130,
  [4131] = 4131,
  [4132] = 4132,
  [4133] = 4133,
  [4134] = 4134,
  [4135] = 4135,
  [4136] = 4136,
  [4137] = 4137,
  [4138] = 4138,
  [4139] = 4139,
  [4140] = 4140,
  [4141] = 4141,
  [4142] = 4142,
  [4143] = 4143,
  [4144] = 4144,
  [4145] = 4145,
  [4146] = 4146,
  [4147] = 3987,
  [4148] = 4148,
  [4149] = 4149,
  [4150] = 4150,
  [4151] = 3976,
  [4152] = 4152,
  [4153] = 4150,
  [4154] = 4154,
  [4155] = 4155,
  [4156] = 4156,
  [4157] = 4157,
  [4158] = 4158,
  [4159] = 4159,
  [4160] = 4160,
  [4161] = 4161,
  [4162] = 4162,
  [4163] = 4163,
  [4164] = 4164,
  [4165] = 4165,
  [4166] = 4166,
  [4167] = 4167,
  [4168] = 4168,
  [4169] = 4169,
  [4170] = 4170,
  [4171] = 3939,
  [4172] = 4172,
  [4173] = 4173,
  [4174] = 4174,
  [4175] = 4175,
  [4176] = 4038,
  [4177] = 4177,
  [4178] = 4178,
  [4179] = 4179,
  [4180] = 4180,
  [4181] = 4181,
  [4182] = 4182,
  [4183] = 4183,
  [4184] = 4184,
  [4185] = 4185,
  [4186] = 4186,
  [4187] = 4187,
  [4188] = 4188,
  [4189] = 4013,
  [4190] = 4190,
  [4191] = 3980,
  [4192] = 4192,
  [4193] = 4193,
  [4194] = 4194,
  [4195] = 4195,
  [4196] = 4196,
  [4197] = 4197,
  [4198] = 4198,
  [4199] = 4199,
  [4200] = 4031,
  [4201] = 4154,
  [4202] = 3983,
  [4203] = 4184,
  [4204] = 4204,
  [4205] = 4205,
  [4206] = 4206,
  [4207] = 4185,
  [4208] = 3951,
  [4209] = 4209,
  [4210] = 4210,
  [4211] = 4211,
  [4212] = 4212,
  [4213] = 4213,
  [4214] = 4214,
  [4215] = 4215,
  [4216] = 4216,
  [4217] = 3987,
  [4218] = 3923,
  [4219] = 4219,
  [4220] = 4220,
  [4221] = 4221,
  [4222] = 4150,
  [4223] = 4223,
  [4224] = 4160,
  [4225] = 4161,
  [4226] = 4226,
  [4227] = 4227,
  [4228] = 3986,
  [4229] = 4038,
  [4230] = 4230,
  [4231] = 4231,
  [4232] = 4232,
  [4233] = 4233,
  [4234] = 4234,
  [4235] = 4235,
  [4236] = 4236,
  [4237] = 4237,
  [4238] = 4238,
  [4239] = 4239,
  [4240] = 4240,
  [4241] = 4241,
  [4242] = 4242,
  [4243] = 4243,
  [4244] = 4244,
  [4245] = 4245,
  [4246] = 4246,
  [4247] = 4247,
  [4248] = 4172,
  [4249] = 4249,
  [4250] = 3961,
  [4251] = 4251,
  [4252] = 4252,
  [4253] = 4253,
  [4254] = 3962,
  [4255] = 4255,
  [4256] = 4256,
  [4257] = 4257,
  [4258] = 4258,
  [4259] = 4259,
  [4260] = 4173,
  [4261] = 4261,
  [4262] = 4262,
  [4263] = 4263,
  [4264] = 4264,
  [4265] = 4265,
  [4266] = 4266,
  [4267] = 4267,
  [4268] = 4268,
  [4269] = 4269,
  [4270] = 231,
  [4271] = 4271,
  [4272] = 4272,
  [4273] = 4174,
  [4274] = 4274,
  [4275] = 831,
  [4276] = 3654,
  [4277] = 3989,
  [4278] = 4278,
  [4279] = 4175,
  [4280] = 217,
  [4281] = 4281,
  [4282] = 4282,
  [4283] = 4283,
  [4284] = 4284,
  [4285] = 4285,
  [4286] = 919,
  [4287] = 824,
  [4288] = 4288,
  [4289] = 4289,
  [4290] = 3903,
  [4291] = 4291,
  [4292] = 4292,
  [4293] = 4193,
  [4294] = 4294,
  [4295] = 4295,
  [4296] = 4296,
  [4297] = 4297,
  [4298] = 4157,
  [4299] = 4299,
  [4300] = 4300,
  [4301] = 4301,
  [4302] = 4302,
  [4303] = 4303,
  [4304] = 4301,
  [4305] = 4197,
  [4306] = 4306,
  [4307] = 4307,
  [4308] = 4001,
  [4309] = 3722,
  [4310] = 867,
  [4311] = 878,
  [4312] = 4312,
  [4313] = 4313,
  [4314] = 4314,
  [4315] = 4315,
  [4316] = 4316,
  [4317] = 3948,
  [4318] = 4318,
  [4319] = 4249,
  [4320] = 4010,
  [4321] = 3971,
  [4322] = 3972,
  [4323] = 4190,
  [4324] = 3825,
  [4325] = 4325,
  [4326] = 3989,
  [4327] = 937,
  [4328] = 4328,
  [4329] = 4329,
  [4330] = 844,
  [4331] = 4331,
  [4332] = 4332,
  [4333] = 4333,
  [4334] = 4334,
  [4335] = 4335,
  [4336] = 4336,
  [4337] = 4337,
  [4338] = 4338,
  [4339] = 4339,
  [4340] = 3607,
  [4341] = 3687,
  [4342] = 850,
  [4343] = 856,
  [4344] = 4344,
  [4345] = 4345,
  [4346] = 4346,
  [4347] = 4347,
  [4348] = 4160,
  [4349] = 4349,
  [4350] = 1624,
  [4351] = 1630,
  [4352] = 4352,
  [4353] = 4353,
  [4354] = 4161,
  [4355] = 3944,
  [4356] = 4356,
  [4357] = 4357,
  [4358] = 4358,
  [4359] = 4196,
  [4360] = 4360,
  [4361] = 4361,
  [4362] = 4362,
  [4363] = 4363,
  [4364] = 4364,
  [4365] = 4365,
  [4366] = 4366,
  [4367] = 4367,
  [4368] = 4368,
  [4369] = 4369,
  [4370] = 4370,
  [4371] = 877,
  [4372] = 4372,
  [4373] = 4145,
  [4374] = 897,
  [4375] = 907,
  [4376] = 4376,
  [4377] = 4377,
  [4378] = 4378,
  [4379] = 4379,
  [4380] = 4380,
  [4381] = 4381,
  [4382] = 4382,
  [4383] = 4383,
  [4384] = 4382,
  [4385] = 4385,
  [4386] = 4386,
  [4387] = 4387,
  [4388] = 4382,
  [4389] = 4389,
  [4390] = 4390,
  [4391] = 4391,
  [4392] = 4380,
  [4393] = 4390,
  [4394] = 4394,
  [4395] = 4381,
  [4396] = 4380,
  [4397] = 4387,
  [4398] = 4398,
  [4399] = 4399,
  [4400] = 4400,
  [4401] = 4401,
  [4402] = 4394,
  [4403] = 4403,
  [4404] = 4390,
  [4405] = 4387,
  [4406] = 4406,
  [4407] = 4407,
  [4408] = 4408,
  [4409] = 4409,
  [4410] = 4410,
  [4411] = 4380,
  [4412] = 4394,
  [4413] = 4413,
  [4414] = 4414,
  [4415] = 4391,
  [4416] = 4416,
  [4417] = 3792,
  [4418] = 4418,
  [4419] = 4419,
  [4420] = 4420,
  [4421] = 4389,
  [4422] = 4422,
  [4423] = 4423,
  [4424] = 4424,
  [4425] = 3722,
  [4426] = 4426,
  [4427] = 4427,
  [4428] = 4413,
  [4429] = 4408,
  [4430] = 4413,
  [4431] = 4431,
  [4432] = 4409,
  [4433] = 4391,
  [4434] = 4387,
  [4435] = 4409,
  [4436] = 4436,
  [4437] = 4391,
  [4438] = 4413,
  [4439] = 4439,
  [4440] = 4440,
  [4441] = 4441,
  [4442] = 4442,
  [4443] = 4381,
  [4444] = 4444,
  [4445] = 4445,
  [4446] = 4446,
  [4447] = 4447,
  [4448] = 4420,
  [4449] = 4439,
  [4450] = 4385,
  [4451] = 4416,
  [4452] = 4381,
  [4453] = 4390,
  [4454] = 4391,
  [4455] = 4455,
  [4456] = 4381,
  [4457] = 3807,
  [4458] = 4458,
  [4459] = 4459,
  [4460] = 4427,
  [4461] = 4409,
  [4462] = 4462,
  [4463] = 4444,
  [4464] = 4426,
  [4465] = 4394,
  [4466] = 4381,
  [4467] = 4467,
  [4468] = 4382,
  [4469] = 4469,
  [4470] = 4413,
  [4471] = 4390,
  [4472] = 4439,
  [4473] = 4420,
  [4474] = 4439,
  [4475] = 4407,
  [4476] = 4394,
  [4477] = 4387,
  [4478] = 4381,
  [4479] = 4406,
  [4480] = 4480,
  [4481] = 4481,
  [4482] = 4380,
  [4483] = 4483,
  [4484] = 4484,
  [4485] = 4485,
  [4486] = 4409,
  [4487] = 4487,
  [4488] = 4488,
  [4489] = 4420,
  [4490] = 4391,
  [4491] = 4491,
  [4492] = 4420,
  [4493] = 4390,
  [4494] = 4494,
  [4495] = 4495,
  [4496] = 4380,
  [4497] = 4420,
  [4498] = 4391,
  [4499] = 4499,
  [4500] = 4382,
  [4501] = 4413,
  [4502] = 4382,
  [4503] = 4439,
  [4504] = 4413,
  [4505] = 4505,
  [4506] = 4459,
  [4507] = 4439,
  [4508] = 4439,
  [4509] = 4390,
  [4510] = 4420,
  [4511] = 4380,
  [4512] = 4394,
  [4513] = 4394,
  [4514] = 4514,
  [4515] = 4458,
  [4516] = 4516,
  [4517] = 4517,
  [4518] = 4518,
  [4519] = 4519,
  [4520] = 4520,
  [4521] = 4521,
  [4522] = 4522,
  [4523] = 4523,
  [4524] = 4524,
  [4525] = 4525,
  [4526] = 4526,
  [4527] = 4527,
  [4528] = 4528,
  [4529] = 4529,
  [4530] = 4530,
  [4531] = 4531,
  [4532] = 4532,
  [4533] = 4533,
  [4534] = 4534,
  [4535] = 4535,
  [4536] = 4536,
  [4537] = 4537,
  [4538] = 4538,
  [4539] = 4539,
  [4540] = 4540,
  [4541] = 4541,
  [4542] = 4542,
  [4543] = 4543,
  [4544] = 4544,
  [4545] = 4545,
  [4546] = 4546,
  [4547] = 4547,
  [4548] = 4548,
  [4549] = 4549,
  [4550] = 4550,
  [4551] = 4551,
  [4552] = 4552,
  [4553] = 4553,
  [4554] = 4554,
  [4555] = 4555,
  [4556] = 4556,
  [4557] = 4557,
  [4558] = 4558,
  [4559] = 4559,
  [4560] = 4560,
  [4561] = 4561,
  [4562] = 4562,
  [4563] = 4563,
  [4564] = 4564,
  [4565] = 4565,
  [4566] = 4566,
  [4567] = 4567,
  [4568] = 4540,
  [4569] = 4569,
  [4570] = 4570,
  [4571] = 4571,
  [4572] = 4572,
  [4573] = 4573,
  [4574] = 4574,
  [4575] = 4575,
  [4576] = 4576,
  [4577] = 4577,
  [4578] = 4531,
  [4579] = 4579,
  [4580] = 4580,
  [4581] = 4581,
  [4582] = 4582,
  [4583] = 4583,
  [4584] = 4584,
  [4585] = 4585,
  [4586] = 4540,
  [4587] = 4541,
  [4588] = 4542,
  [4589] = 4589,
  [4590] = 4544,
  [4591] = 4545,
  [4592] = 4592,
  [4593] = 4593,
  [4594] = 4533,
  [4595] = 4537,
  [4596] = 4543,
  [4597] = 4553,
  [4598] = 4598,
  [4599] = 4552,
  [4600] = 4600,
  [4601] = 4601,
  [4602] = 4554,
  [4603] = 4603,
  [4604] = 4604,
  [4605] = 4605,
  [4606] = 4606,
  [4607] = 4607,
  [4608] = 4608,
  [4609] = 4609,
  [4610] = 4610,
  [4611] = 4611,
  [4612] = 4612,
  [4613] = 4613,
  [4614] = 4614,
  [4615] = 4615,
  [4616] = 4616,
  [4617] = 4617,
  [4618] = 4618,
  [4619] = 4619,
  [4620] = 4552,
  [4621] = 4621,
  [4622] = 4541,
  [4623] = 4623,
  [4624] = 4624,
  [4625] = 4625,
  [4626] = 4626,
  [4627] = 4627,
  [4628] = 4628,
  [4629] = 4629,
  [4630] = 4630,
  [4631] = 4631,
  [4632] = 4632,
  [4633] = 4633,
  [4634] = 4634,
  [4635] = 4635,
  [4636] = 4542,
  [4637] = 4637,
  [4638] = 4544,
  [4639] = 4545,
  [4640] = 4640,
  [4641] = 4641,
  [4642] = 4642,
  [4643] = 4643,
  [4644] = 4554,
  [4645] = 4645,
  [4646] = 4646,
  [4647] = 4554,
  [4648] = 4648,
  [4649] = 4552,
  [4650] = 4531,
  [4651] = 4148,
  [4652] = 4652,
  [4653] = 4544,
  [4654] = 4545,
  [4655] = 4655,
  [4656] = 4554,
  [4657] = 4657,
  [4658] = 4658,
  [4659] = 4659,
  [4660] = 4660,
  [4661] = 4661,
  [4662] = 4662,
  [4663] = 4663,
  [4664] = 4664,
  [4665] = 4665,
  [4666] = 4666,
  [4667] = 4667,
  [4668] = 4668,
  [4669] = 4669,
  [4670] = 4670,
  [4671] = 4671,
  [4672] = 4672,
  [4673] = 4673,
  [4674] = 4674,
  [4675] = 4675,
  [4676] = 4676,
  [4677] = 4677,
  [4678] = 4678,
  [4679] = 4679,
  [4680] = 4680,
  [4681] = 4531,
  [4682] = 4682,
  [4683] = 4683,
  [4684] = 4684,
  [4685] = 4685,
  [4686] = 4671,
  [4687] = 4663,
  [4688] = 4643,
  [4689] = 4689,
  [4690] = 4690,
  [4691] = 4691,
  [4692] = 4646,
  [4693] = 4542,
  [4694] = 4694,
  [4695] = 4695,
  [4696] = 4696,
  [4697] = 790,
  [4698] = 4554,
  [4699] = 4699,
  [4700] = 4700,
  [4701] = 4701,
  [4702] = 4702,
  [4703] = 4703,
  [4704] = 4704,
  [4705] = 4705,
  [4706] = 4706,
  [4707] = 4707,
  [4708] = 4541,
  [4709] = 4709,
  [4710] = 4710,
  [4711] = 4711,
  [4712] = 4712,
  [4713] = 4713,
  [4714] = 4555,
  [4715] = 4715,
  [4716] = 4716,
  [4717] = 4717,
  [4718] = 4718,
  [4719] = 4719,
  [4720] = 4720,
  [4721] = 4576,
  [4722] = 4722,
  [4723] = 4723,
  [4724] = 4724,
  [4725] = 4725,
  [4726] = 4726,
  [4727] = 4727,
  [4728] = 4728,
  [4729] = 4729,
  [4730] = 4730,
  [4731] = 4731,
  [4732] = 4732,
  [4733] = 4524,
  [4734] = 4734,
  [4735] = 4735,
  [4736] = 4736,
  [4737] = 4737,
  [4738] = 4738,
  [4739] = 4739,
  [4740] = 4685,
  [4741] = 4741,
  [4742] = 4742,
  [4743] = 4743,
  [4744] = 4734,
  [4745] = 4736,
  [4746] = 4746,
  [4747] = 4747,
  [4748] = 4748,
  [4749] = 4749,
  [4750] = 4750,
  [4751] = 4751,
  [4752] = 4752,
  [4753] = 4753,
  [4754] = 4754,
  [4755] = 4755,
  [4756] = 4756,
  [4757] = 4757,
  [4758] = 4758,
  [4759] = 4759,
  [4760] = 4760,
  [4761] = 4761,
  [4762] = 4762,
  [4763] = 4763,
  [4764] = 4764,
  [4765] = 4765,
  [4766] = 4766,
  [4767] = 4767,
  [4768] = 4768,
  [4769] = 4769,
  [4770] = 4770,
  [4771] = 4771,
  [4772] = 4772,
  [4773] = 4773,
  [4774] = 4774,
  [4775] = 4775,
  [4776] = 4776,
  [4777] = 4777,
  [4778] = 4778,
  [4779] = 4779,
  [4780] = 4780,
  [4781] = 4781,
  [4782] = 4782,
  [4783] = 4783,
  [4784] = 4784,
  [4785] = 4785,
  [4786] = 4786,
  [4787] = 4787,
  [4788] = 4788,
  [4789] = 4544,
  [4790] = 4545,
  [4791] = 4791,
  [4792] = 4792,
  [4793] = 4793,
  [4794] = 4794,
  [4795] = 4795,
  [4796] = 4796,
  [4797] = 4672,
  [4798] = 4798,
  [4799] = 4799,
  [4800] = 4800,
  [4801] = 4801,
  [4802] = 4802,
  [4803] = 4803,
  [4804] = 4804,
  [4805] = 4805,
  [4806] = 4806,
  [4807] = 4807,
  [4808] = 4531,
  [4809] = 4809,
  [4810] = 4792,
  [4811] = 4811,
  [4812] = 4812,
  [4813] = 4813,
  [4814] = 3559,
  [4815] = 4802,
  [4816] = 4816,
  [4817] = 4817,
  [4818] = 4818,
  [4819] = 4819,
  [4820] = 4820,
  [4821] = 4821,
  [4822] = 4822,
  [4823] = 4823,
  [4824] = 4824,
  [4825] = 4825,
  [4826] = 4826,
  [4827] = 4827,
  [4828] = 4828,
  [4829] = 4829,
  [4830] = 4830,
  [4831] = 4831,
  [4832] = 4832,
  [4833] = 4833,
  [4834] = 4834,
  [4835] = 4835,
  [4836] = 4836,
  [4837] = 4837,
  [4838] = 4838,
  [4839] = 4839,
  [4840] = 4840,
  [4841] = 4841,
  [4842] = 4842,
  [4843] = 4843,
  [4844] = 4844,
  [4845] = 4845,
  [4846] = 4846,
  [4847] = 4847,
  [4848] = 4848,
  [4849] = 4849,
  [4850] = 4850,
  [4851] = 4851,
  [4852] = 4852,
  [4853] = 4853,
  [4854] = 4854,
  [4855] = 4855,
  [4856] = 4856,
  [4857] = 4857,
  [4858] = 4858,
  [4859] = 4859,
  [4860] = 4860,
  [4861] = 4861,
  [4862] = 4862,
  [4863] = 4863,
  [4864] = 4864,
  [4865] = 4865,
  [4866] = 4866,
  [4867] = 4867,
  [4868] = 4868,
  [4869] = 4869,
  [4870] = 4870,
  [4871] = 4871,
  [4872] = 4872,
  [4873] = 4873,
  [4874] = 4874,
  [4875] = 4875,
  [4876] = 4876,
  [4877] = 4877,
  [4878] = 4531,
  [4879] = 4879,
  [4880] = 4880,
  [4881] = 4881,
  [4882] = 4882,
  [4883] = 4883,
  [4884] = 4884,
  [4885] = 4885,
  [4886] = 4886,
  [4887] = 4887,
  [4888] = 4888,
  [4889] = 4889,
  [4890] = 4890,
  [4891] = 4288,
  [4892] = 4892,
  [4893] = 4893,
  [4894] = 4894,
  [4895] = 4895,
  [4896] = 4896,
  [4897] = 3807,
  [4898] = 4898,
  [4899] = 4621,
  [4900] = 4900,
  [4901] = 4901,
  [4902] = 4902,
  [4903] = 4903,
  [4904] = 4904,
  [4905] = 4905,
  [4906] = 4906,
  [4907] = 4907,
  [4908] = 4668,
  [4909] = 4909,
  [4910] = 4576,
  [4911] = 4911,
  [4912] = 4912,
  [4913] = 4913,
  [4914] = 4914,
  [4915] = 4915,
  [4916] = 4916,
  [4917] = 4917,
  [4918] = 4918,
  [4919] = 4919,
  [4920] = 4920,
  [4921] = 4921,
  [4922] = 4922,
  [4923] = 4923,
  [4924] = 4924,
  [4925] = 4734,
  [4926] = 4926,
  [4927] = 4927,
  [4928] = 4928,
  [4929] = 4929,
  [4930] = 4930,
  [4931] = 4931,
  [4932] = 4932,
  [4933] = 4933,
  [4934] = 4934,
  [4935] = 3668,
  [4936] = 4936,
  [4937] = 4937,
  [4938] = 4938,
  [4939] = 4621,
  [4940] = 4940,
  [4941] = 4941,
  [4942] = 4942,
  [4943] = 4943,
  [4944] = 4944,
  [4945] = 4945,
  [4946] = 4946,
  [4947] = 4947,
  [4948] = 4948,
  [4949] = 4949,
  [4950] = 4531,
  [4951] = 4951,
  [4952] = 4952,
  [4953] = 4953,
  [4954] = 4954,
  [4955] = 4955,
  [4956] = 4540,
  [4957] = 4957,
  [4958] = 4958,
  [4959] = 4806,
  [4960] = 4792,
  [4961] = 4812,
  [4962] = 4712,
  [4963] = 4963,
  [4964] = 4869,
  [4965] = 4812,
  [4966] = 4716,
  [4967] = 4967,
  [4968] = 4968,
  [4969] = 4927,
  [4970] = 4970,
  [4971] = 4946,
  [4972] = 4972,
  [4973] = 4973,
  [4974] = 4974,
  [4975] = 4955,
  [4976] = 4976,
  [4977] = 4977,
  [4978] = 4978,
  [4979] = 4979,
  [4980] = 4980,
  [4981] = 4541,
  [4982] = 4982,
  [4983] = 4983,
  [4984] = 4984,
  [4985] = 4985,
  [4986] = 4986,
  [4987] = 4879,
  [4988] = 4988,
  [4989] = 4989,
  [4990] = 4890,
  [4991] = 4991,
  [4992] = 4992,
  [4993] = 4993,
  [4994] = 4994,
  [4995] = 4995,
  [4996] = 4678,
  [4997] = 4700,
  [4998] = 4998,
  [4999] = 4540,
  [5000] = 5000,
  [5001] = 4541,
  [5002] = 5002,
  [5003] = 5003,
  [5004] = 5004,
  [5005] = 5000,
  [5006] = 4542,
  [5007] = 5007,
  [5008] = 4544,
  [5009] = 5009,
  [5010] = 5010,
  [5011] = 4545,
  [5012] = 5012,
  [5013] = 3707,
  [5014] = 4869,
  [5015] = 5015,
  [5016] = 4542,
  [5017] = 5017,
  [5018] = 5018,
  [5019] = 5003,
  [5020] = 5020,
  [5021] = 5021,
  [5022] = 4541,
  [5023] = 4977,
  [5024] = 5024,
  [5025] = 5025,
  [5026] = 3792,
  [5027] = 4533,
  [5028] = 5028,
  [5029] = 5029,
  [5030] = 4537,
  [5031] = 5031,
  [5032] = 4543,
  [5033] = 4553,
  [5034] = 5034,
  [5035] = 5035,
  [5036] = 5036,
  [5037] = 5037,
  [5038] = 4713,
  [5039] = 4564,
  [5040] = 5040,
  [5041] = 4566,
  [5042] = 5042,
  [5043] = 5043,
  [5044] = 5044,
  [5045] = 5045,
  [5046] = 5046,
  [5047] = 5047,
  [5048] = 5048,
  [5049] = 5049,
  [5050] = 5050,
  [5051] = 5051,
  [5052] = 4552,
  [5053] = 5053,
  [5054] = 5054,
  [5055] = 5055,
  [5056] = 5056,
  [5057] = 5057,
  [5058] = 5058,
  [5059] = 5059,
  [5060] = 5060,
  [5061] = 5061,
  [5062] = 4554,
  [5063] = 5063,
  [5064] = 5064,
  [5065] = 5065,
  [5066] = 5066,
  [5067] = 5067,
  [5068] = 5068,
  [5069] = 5069,
  [5070] = 5070,
  [5071] = 5071,
  [5072] = 5072,
  [5073] = 5073,
  [5074] = 5074,
  [5075] = 1626,
  [5076] = 1545,
  [5077] = 5077,
  [5078] = 5078,
  [5079] = 5079,
  [5080] = 5080,
  [5081] = 5081,
  [5082] = 5082,
  [5083] = 5083,
  [5084] = 5084,
  [5085] = 5085,
  [5086] = 5086,
  [5087] = 5087,
  [5088] = 5088,
  [5089] = 5089,
  [5090] = 5090,
  [5091] = 5091,
  [5092] = 5092,
  [5093] = 5093,
  [5094] = 5094,
  [5095] = 5095,
  [5096] = 3722,
  [5097] = 5097,
  [5098] = 5098,
  [5099] = 5099,
  [5100] = 5100,
  [5101] = 5101,
  [5102] = 5102,
  [5103] = 5103,
  [5104] = 5104,
  [5105] = 5105,
  [5106] = 4164,
  [5107] = 5107,
  [5108] = 4780,
  [5109] = 5109,
  [5110] = 5110,
  [5111] = 5111,
  [5112] = 5112,
  [5113] = 5113,
  [5114] = 5114,
  [5115] = 4544,
  [5116] = 4545,
  [5117] = 5117,
  [5118] = 5118,
  [5119] = 5119,
  [5120] = 5120,
  [5121] = 5121,
  [5122] = 5122,
  [5123] = 5123,
  [5124] = 5124,
  [5125] = 3547,
  [5126] = 5126,
  [5127] = 5127,
  [5128] = 5128,
  [5129] = 5129,
  [5130] = 5130,
  [5131] = 5131,
  [5132] = 5132,
  [5133] = 5133,
  [5134] = 2650,
  [5135] = 5135,
  [5136] = 5136,
  [5137] = 5137,
  [5138] = 5138,
  [5139] = 5139,
  [5140] = 5140,
  [5141] = 5141,
  [5142] = 5142,
  [5143] = 5143,
  [5144] = 5144,
  [5145] = 5145,
  [5146] = 5146,
  [5147] = 2672,
  [5148] = 5148,
  [5149] = 5149,
  [5150] = 5150,
  [5151] = 5151,
  [5152] = 5152,
  [5153] = 5153,
  [5154] = 5130,
  [5155] = 5155,
  [5156] = 5156,
  [5157] = 5157,
  [5158] = 5158,
  [5159] = 5159,
  [5160] = 5160,
  [5161] = 5161,
  [5162] = 5162,
  [5163] = 5163,
  [5164] = 5164,
  [5165] = 5165,
  [5166] = 5166,
  [5167] = 5167,
  [5168] = 5168,
  [5169] = 5169,
  [5170] = 5170,
  [5171] = 5171,
  [5172] = 5172,
  [5173] = 5130,
  [5174] = 5163,
  [5175] = 5175,
  [5176] = 5166,
  [5177] = 5177,
  [5178] = 5178,
  [5179] = 5167,
  [5180] = 5180,
  [5181] = 5181,
  [5182] = 5182,
  [5183] = 5183,
  [5184] = 5184,
  [5185] = 5185,
  [5186] = 5186,
  [5187] = 5187,
  [5188] = 5188,
  [5189] = 5189,
  [5190] = 5190,
  [5191] = 5191,
  [5192] = 5192,
  [5193] = 3811,
  [5194] = 1674,
  [5195] = 1675,
  [5196] = 3862,
  [5197] = 5197,
  [5198] = 5182,
  [5199] = 3886,
  [5200] = 5184,
  [5201] = 5149,
  [5202] = 5202,
  [5203] = 5161,
  [5204] = 5204,
  [5205] = 5146,
  [5206] = 5202,
  [5207] = 5172,
  [5208] = 5163,
  [5209] = 5209,
  [5210] = 5167,
  [5211] = 5189,
  [5212] = 5212,
  [5213] = 5213,
  [5214] = 2655,
  [5215] = 5215,
  [5216] = 5216,
  [5217] = 5127,
  [5218] = 5218,
  [5219] = 5219,
  [5220] = 5220,
  [5221] = 2657,
  [5222] = 5168,
  [5223] = 5223,
  [5224] = 5224,
  [5225] = 5225,
  [5226] = 5226,
  [5227] = 5227,
  [5228] = 5228,
  [5229] = 5138,
  [5230] = 5230,
  [5231] = 5219,
  [5232] = 5232,
  [5233] = 5233,
  [5234] = 5234,
  [5235] = 5235,
  [5236] = 5236,
  [5237] = 5183,
  [5238] = 2662,
  [5239] = 5239,
  [5240] = 5128,
  [5241] = 5228,
  [5242] = 5133,
  [5243] = 5146,
  [5244] = 5244,
  [5245] = 5245,
  [5246] = 5246,
  [5247] = 5247,
  [5248] = 5146,
  [5249] = 5233,
  [5250] = 5187,
  [5251] = 5146,
  [5252] = 5163,
  [5253] = 5167,
  [5254] = 5190,
  [5255] = 5144,
  [5256] = 5256,
  [5257] = 5257,
  [5258] = 5258,
  [5259] = 2708,
  [5260] = 5260,
  [5261] = 5137,
  [5262] = 2693,
  [5263] = 5263,
  [5264] = 5162,
  [5265] = 5265,
  [5266] = 5143,
  [5267] = 5267,
  [5268] = 5145,
  [5269] = 5162,
  [5270] = 5270,
  [5271] = 5191,
  [5272] = 5272,
  [5273] = 5143,
  [5274] = 5274,
  [5275] = 5166,
  [5276] = 5224,
  [5277] = 5277,
  [5278] = 5278,
  [5279] = 5184,
  [5280] = 5280,
  [5281] = 5190,
  [5282] = 5191,
  [5283] = 5283,
  [5284] = 5284,
  [5285] = 5285,
  [5286] = 5280,
  [5287] = 5287,
  [5288] = 5150,
  [5289] = 5289,
  [5290] = 5290,
  [5291] = 5158,
  [5292] = 5163,
  [5293] = 5293,
  [5294] = 5283,
  [5295] = 5295,
  [5296] = 5287,
  [5297] = 2710,
  [5298] = 5181,
  [5299] = 5175,
  [5300] = 5227,
  [5301] = 5155,
  [5302] = 5302,
  [5303] = 5303,
  [5304] = 5304,
  [5305] = 5305,
  [5306] = 3825,
  [5307] = 5307,
  [5308] = 5162,
  [5309] = 5309,
  [5310] = 5310,
  [5311] = 5143,
  [5312] = 5312,
  [5313] = 5313,
  [5314] = 5314,
  [5315] = 5315,
  [5316] = 2669,
  [5317] = 5191,
  [5318] = 5318,
  [5319] = 5319,
  [5320] = 5283,
  [5321] = 5130,
  [5322] = 5322,
  [5323] = 5283,
  [5324] = 5324,
  [5325] = 5166,
  [5326] = 5326,
  [5327] = 5130,
  [5328] = 5233,
  [5329] = 5329,
  [5330] = 5330,
  [5331] = 5331,
  [5332] = 5188,
  [5333] = 5333,
  [5334] = 5334,
  [5335] = 5335,
  [5336] = 5336,
  [5337] = 5337,
  [5338] = 5184,
  [5339] = 5190,
  [5340] = 5303,
  [5341] = 5304,
  [5342] = 5342,
  [5343] = 5343,
  [5344] = 5344,
  [5345] = 2712,
  [5346] = 5346,
  [5347] = 5302,
  [5348] = 2653,
  [5349] = 5349,
  [5350] = 5350,
  [5351] = 5218,
  [5352] = 5166,
  [5353] = 5353,
  [5354] = 5184,
  [5355] = 5355,
  [5356] = 5356,
  [5357] = 5190,
  [5358] = 5358,
  [5359] = 5359,
  [5360] = 5360,
  [5361] = 5146,
  [5362] = 5312,
  [5363] = 5315,
  [5364] = 5364,
  [5365] = 5318,
  [5366] = 5324,
  [5367] = 5367,
  [5368] = 2690,
  [5369] = 5326,
  [5370] = 5370,
  [5371] = 5197,
  [5372] = 5344,
  [5373] = 5373,
  [5374] = 5183,
  [5375] = 5163,
  [5376] = 5293,
  [5377] = 5224,
  [5378] = 5167,
  [5379] = 5379,
  [5380] = 5162,
  [5381] = 5381,
  [5382] = 5143,
  [5383] = 1659,
  [5384] = 5384,
  [5385] = 5385,
  [5386] = 5191,
  [5387] = 5167,
  [5388] = 5283,
  [5389] = 2659,
  [5390] = 5390,
  [5391] = 5135,
  [5392] = 2660,
  [5393] = 5393,
  [5394] = 5192,
  [5395] = 5395,
  [5396] = 5130,
  [5397] = 5227,
  [5398] = 5398,
  [5399] = 5390,
  [5400] = 5400,
  [5401] = 5401,
  [5402] = 5402,
  [5403] = 5364,
  [5404] = 5274,
  [5405] = 5310,
  [5406] = 5406,
  [5407] = 5239,
  [5408] = 5204,
  [5409] = 5175,
  [5410] = 5228,
  [5411] = 5411,
  [5412] = 5412,
  [5413] = 5413,
  [5414] = 5234,
  [5415] = 5415,
  [5416] = 2687,
  [5417] = 5417,
  [5418] = 5418,
  [5419] = 5419,
  [5420] = 2707,
  [5421] = 5235,
  [5422] = 5395,
  [5423] = 5423,
  [5424] = 5424,
  [5425] = 5424,
  [5426] = 5426,
  [5427] = 5130,
  [5428] = 5428,
  [5429] = 5236,
  [5430] = 5303,
  [5431] = 5431,
  [5432] = 5212,
  [5433] = 2695,
  [5434] = 2688,
  [5435] = 5426,
  [5436] = 5436,
  [5437] = 5437,
  [5438] = 5213,
  [5439] = 5439,
  [5440] = 5440,
  [5441] = 2696,
  [5442] = 5440,
  [5443] = 5443,
  [5444] = 5180,
  [5445] = 5186,
  [5446] = 5215,
  [5447] = 5346,
  [5448] = 5216,
  [5449] = 5418,
  [5450] = 5220,
  [5451] = 5350,
  [5452] = 5223,
  [5453] = 5247,
  [5454] = 5146,
  [5455] = 5158,
  [5456] = 5163,
  [5457] = 5423,
  [5458] = 5344,
  [5459] = 5167,
  [5460] = 5460,
  [5461] = 5428,
  [5462] = 5462,
  [5463] = 2702,
  [5464] = 2704,
  [5465] = 2668,
  [5466] = 5466,
  [5467] = 5467,
  [5468] = 5468,
  [5469] = 5469,
  [5470] = 5470,
  [5471] = 5471,
  [5472] = 5472,
  [5473] = 5471,
  [5474] = 5474,
  [5475] = 5475,
  [5476] = 5476,
  [5477] = 5466,
  [5478] = 5472,
  [5479] = 5479,
  [5480] = 5480,
  [5481] = 5481,
  [5482] = 5482,
  [5483] = 5469,
  [5484] = 5484,
  [5485] = 5467,
  [5486] = 5474,
  [5487] = 5487,
  [5488] = 5488,
  [5489] = 5489,
  [5490] = 5490,
  [5491] = 5472,
  [5492] = 5492,
  [5493] = 5493,
  [5494] = 5482,
  [5495] = 5495,
  [5496] = 5496,
  [5497] = 5497,
  [5498] = 5498,
  [5499] = 5469,
  [5500] = 5500,
  [5501] = 5501,
  [5502] = 5502,
  [5503] = 5493,
  [5504] = 5480,
  [5505] = 5469,
  [5506] = 5506,
  [5507] = 5476,
  [5508] = 5466,
  [5509] = 5509,
  [5510] = 5510,
  [5511] = 5511,
  [5512] = 5512,
  [5513] = 5513,
  [5514] = 5512,
  [5515] = 5515,
  [5516] = 5516,
  [5517] = 5495,
  [5518] = 5472,
  [5519] = 5475,
  [5520] = 5495,
  [5521] = 5521,
  [5522] = 5492,
  [5523] = 5496,
  [5524] = 5521,
  [5525] = 5525,
  [5526] = 5526,
  [5527] = 5475,
  [5528] = 5476,
  [5529] = 5466,
  [5530] = 5530,
  [5531] = 5479,
  [5532] = 5480,
  [5533] = 5481,
  [5534] = 5534,
  [5535] = 5474,
  [5536] = 5536,
  [5537] = 5521,
  [5538] = 5538,
  [5539] = 5539,
  [5540] = 5540,
  [5541] = 5489,
  [5542] = 5542,
  [5543] = 5543,
  [5544] = 5492,
  [5545] = 5545,
  [5546] = 5546,
  [5547] = 5547,
  [5548] = 5548,
  [5549] = 5493,
  [5550] = 5550,
  [5551] = 5551,
  [5552] = 5547,
  [5553] = 5553,
  [5554] = 5554,
  [5555] = 5479,
  [5556] = 5493,
  [5557] = 5557,
  [5558] = 5466,
  [5559] = 5559,
  [5560] = 5547,
  [5561] = 5561,
  [5562] = 5562,
  [5563] = 5563,
  [5564] = 5471,
  [5565] = 5565,
  [5566] = 5566,
  [5567] = 5474,
  [5568] = 5467,
  [5569] = 5475,
  [5570] = 5501,
  [5571] = 5484,
  [5572] = 5521,
  [5573] = 5548,
  [5574] = 5476,
  [5575] = 5513,
  [5576] = 5557,
  [5577] = 5472,
  [5578] = 5480,
  [5579] = 5579,
  [5580] = 5492,
  [5581] = 5559,
  [5582] = 5476,
  [5583] = 5583,
  [5584] = 5584,
  [5585] = 5466,
  [5586] = 5480,
  [5587] = 5495,
  [5588] = 5588,
  [5589] = 5479,
  [5590] = 5480,
  [5591] = 5481,
  [5592] = 5521,
  [5593] = 5495,
  [5594] = 5481,
  [5595] = 5595,
  [5596] = 5596,
  [5597] = 5597,
  [5598] = 5479,
  [5599] = 5467,
  [5600] = 5480,
  [5601] = 5481,
  [5602] = 5602,
  [5603] = 5603,
  [5604] = 5604,
  [5605] = 5605,
  [5606] = 5606,
  [5607] = 5607,
  [5608] = 5608,
  [5609] = 5609,
  [5610] = 5489,
  [5611] = 5611,
  [5612] = 5612,
  [5613] = 5613,
  [5614] = 5614,
  [5615] = 5489,
  [5616] = 5538,
  [5617] = 5617,
  [5618] = 5469,
  [5619] = 5475,
  [5620] = 5620,
  [5621] = 5548,
  [5622] = 5622,
  [5623] = 5534,
  [5624] = 5497,
  [5625] = 5625,
  [5626] = 5626,
  [5627] = 5482,
  [5628] = 5614,
  [5629] = 5626,
  [5630] = 5470,
  [5631] = 5631,
  [5632] = 5547,
  [5633] = 5474,
  [5634] = 5476,
  [5635] = 5635,
  [5636] = 5470,
  [5637] = 5637,
  [5638] = 5638,
  [5639] = 5475,
  [5640] = 5640,
  [5641] = 5596,
  [5642] = 5642,
  [5643] = 5643,
  [5644] = 5644,
  [5645] = 5645,
  [5646] = 5469,
  [5647] = 5472,
  [5648] = 5648,
  [5649] = 5553,
  [5650] = 5650,
  [5651] = 5493,
  [5652] = 5617,
  [5653] = 5547,
  [5654] = 5469,
  [5655] = 5482,
  [5656] = 5656,
  [5657] = 5657,
  [5658] = 5489,
  [5659] = 5659,
  [5660] = 5660,
  [5661] = 5603,
  [5662] = 5553,
  [5663] = 5663,
  [5664] = 5500,
  [5665] = 5665,
  [5666] = 5515,
  [5667] = 5607,
  [5668] = 5482,
  [5669] = 5510,
  [5670] = 5493,
  [5671] = 5547,
  [5672] = 5596,
  [5673] = 5501,
  [5674] = 5656,
  [5675] = 5501,
  [5676] = 5611,
  [5677] = 5603,
  [5678] = 5622,
  [5679] = 5513,
  [5680] = 5561,
  [5681] = 5681,
  [5682] = 5665,
  [5683] = 5553,
  [5684] = 5540,
  [5685] = 5607,
  [5686] = 5611,
  [5687] = 5511,
  [5688] = 5688,
  [5689] = 5635,
  [5690] = 5690,
  [5691] = 5691,
  [5692] = 5645,
  [5693] = 5481,
  [5694] = 5510,
  [5695] = 5642,
  [5696] = 5681,
  [5697] = 5583,
  [5698] = 5492,
  [5699] = 5540,
  [5700] = 5635,
  [5701] = 5497,
  [5702] = 5502,
  [5703] = 5512,
  [5704] = 5665,
  [5705] = 5648,
  [5706] = 5546,
  [5707] = 5638,
  [5708] = 5489,
  [5709] = 5493,
  [5710] = 5710,
  [5711] = 5547,
  [5712] = 5650,
  [5713] = 5659,
  [5714] = 5660,
  [5715] = 5691,
  [5716] = 5645,
  [5717] = 5583,
  [5718] = 5583,
  [5719] = 5497,
  [5720] = 5502,
  [5721] = 5512,
  [5722] = 5722,
  [5723] = 5562,
  [5724] = 5501,
  [5725] = 5642,
  [5726] = 5565,
  [5727] = 5650,
  [5728] = 5546,
  [5729] = 5729,
  [5730] = 5730,
  [5731] = 5617,
  [5732] = 5484,
  [5733] = 5602,
  [5734] = 5490,
  [5735] = 5735,
  [5736] = 5736,
  [5737] = 5596,
  [5738] = 5530,
  [5739] = 5739,
  [5740] = 5603,
  [5741] = 5470,
  [5742] = 5607,
  [5743] = 5659,
  [5744] = 5645,
  [5745] = 5611,
  [5746] = 5484,
  [5747] = 5501,
  [5748] = 5748,
  [5749] = 5546,
  [5750] = 5750,
  [5751] = 5542,
  [5752] = 5476,
  [5753] = 5635,
  [5754] = 5638,
  [5755] = 5466,
  [5756] = 5691,
  [5757] = 5642,
  [5758] = 5489,
  [5759] = 5596,
  [5760] = 5479,
  [5761] = 5603,
  [5762] = 5480,
  [5763] = 5607,
  [5764] = 5481,
  [5765] = 5650,
  [5766] = 5659,
  [5767] = 5660,
  [5768] = 5476,
  [5769] = 5472,
  [5770] = 5496,
  [5771] = 5466,
  [5772] = 5660,
  [5773] = 5492,
  [5774] = 5476,
  [5775] = 5665,
  [5776] = 5479,
  [5777] = 5495,
  [5778] = 5480,
  [5779] = 5481,
  [5780] = 5513,
  [5781] = 5611,
  [5782] = 5644,
  [5783] = 5489,
  [5784] = 5510,
  [5785] = 5471,
  [5786] = 5681,
  [5787] = 5496,
  [5788] = 5489,
  [5789] = 5538,
  [5790] = 5476,
  [5791] = 5540,
  [5792] = 5792,
  [5793] = 5793,
  [5794] = 5691,
  [5795] = 5635,
  [5796] = 5474,
  [5797] = 5645,
  [5798] = 5638,
  [5799] = 5583,
  [5800] = 5466,
  [5801] = 5553,
  [5802] = 5642,
  [5803] = 5492,
  [5804] = 5650,
  [5805] = 5538,
  [5806] = 5497,
  [5807] = 5502,
  [5808] = 5659,
  [5809] = 5512,
  [5810] = 5660,
  [5811] = 5546,
  [5812] = 5812,
  [5813] = 5813,
  [5814] = 5481,
  [5815] = 5492,
  [5816] = 5538,
  [5817] = 5812,
  [5818] = 5617,
  [5819] = 5681,
  [5820] = 5820,
  [5821] = 5466,
  [5822] = 5813,
  [5823] = 5492,
  [5824] = 5496,
  [5825] = 5479,
  [5826] = 5826,
  [5827] = 5492,
  [5828] = 5521,
  [5829] = 5479,
  [5830] = 5617,
  [5831] = 5480,
  [5832] = 5665,
  [5833] = 5471,
  [5834] = 5481,
  [5835] = 5498,
  [5836] = 5729,
  [5837] = 5487,
  [5838] = 5750,
  [5839] = 5488,
  [5840] = 5475,
  [5841] = 5665,
  [5842] = 5538,
  [5843] = 5617,
  [5844] = 5844,
  [5845] = 5845,
  [5846] = 5510,
  [5847] = 5739,
  [5848] = 5548,
  [5849] = 5597,
  [5850] = 5793,
  [5851] = 5710,
  [5852] = 5681,
  [5853] = 5484,
  [5854] = 5826,
  [5855] = 5516,
  [5856] = 5617,
  [5857] = 5584,
  [5858] = 5665,
  [5859] = 5479,
  [5860] = 5467,
  [5861] = 5501,
  [5862] = 5540,
  [5863] = 5863,
  [5864] = 5691,
  [5865] = 5538,
  [5866] = 5502,
  [5867] = 5489,
  [5868] = 5548,
  [5869] = 5638,
};

static TSCharacterRange extras_character_set_1[] = {
  {'\t', '\r'}, {' ', ' '}, {0xa0, 0xa0}, {0x1680, 0x1680}, {0x2000, 0x200b}, {0x2028, 0x2029}, {0x202f, 0x202f}, {0x205f, 0x2060},
  {0x3000, 0x3000}, {0xfeff, 0xfeff},
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'$', '$'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0x7f, 0x9f}, {0xa1, 0x167f}, {0x1681, 0x1fff},
  {0x200c, 0x2027}, {0x202a, 0x202e}, {0x2030, 0x205e}, {0x2061, 0x2fff}, {0x3001, 0xfefe}, {0xff00, 0x10ffff},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'$', '$'}, {'0', '9'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0x7f, 0x9f}, {0xa1, 0x167f},
  {0x1681, 0x1fff}, {0x200c, 0x2027}, {0x202a, 0x202e}, {0x2030, 0x205e}, {0x2061, 0x2fff}, {0x3001, 0xfefe}, {0xff00, 0x10ffff},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(76);
      ADVANCE_MAP(
        '!', 89,
        '"', 169,
        '#', 6,
        '$', 206,
        '%', 149,
        '&', 128,
        '\'', 170,
        '(', 90,
        ')', 92,
        '*', 79,
        '+', 141,
        ',', 86,
        '-', 145,
        '.', 97,
        '/', 192,
        '0', 197,
        ':', 93,
        ';', 91,
        '<', 153,
        '=', 82,
        '>', 162,
        '?', 212,
        '@', 209,
        '[', 94,
        '\\', 33,
        ']', 95,
        '^', 131,
        '`', 190,
        '{', 85,
        '|', 134,
        '}', 87,
        '~', 166,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(198);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(73);
      if (lookahead > '@') ADVANCE(207);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(24);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '[') ADVANCE(32);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(193);
      if (lookahead != 0) ADVANCE(194);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '!', 89,
        '"', 169,
        '#', 31,
        '%', 149,
        '&', 128,
        '\'', 170,
        '(', 90,
        ')', 92,
        '*', 79,
        '+', 140,
        ',', 86,
        '-', 144,
        '.', 97,
        '/', 147,
        '0', 197,
        ':', 93,
        ';', 91,
        '<', 153,
        '=', 82,
        '>', 162,
        '?', 212,
        '@', 209,
        '[', 94,
        '\\', 35,
        ']', 95,
        '^', 131,
        '`', 190,
        '{', 85,
        '|', 134,
        '}', 87,
        '~', 166,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(198);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(2);
      if (lookahead > '#') ADVANCE(207);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 89,
        '"', 169,
        '#', 31,
        '%', 149,
        '&', 128,
        '\'', 170,
        '(', 90,
        ')', 92,
        '*', 79,
        '+', 140,
        ',', 86,
        '-', 144,
        '.', 97,
        '/', 147,
        '0', 197,
        ':', 93,
        ';', 91,
        '<', 153,
        '=', 82,
        '>', 162,
        '?', 212,
        '@', 209,
        '[', 94,
        '\\', 35,
        ']', 95,
        '^', 131,
        '`', 190,
        '{', 84,
        '|', 133,
        '}', 87,
        '~', 166,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(198);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(3);
      if (lookahead > '#') ADVANCE(207);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 89,
        '%', 148,
        '&', 129,
        '(', 90,
        ')', 92,
        '*', 80,
        '+', 139,
        ',', 86,
        '-', 143,
        '.', 96,
        '/', 146,
        ':', 93,
        ';', 91,
        '<', 154,
        '=', 28,
        '>', 163,
        '?', 21,
        '[', 94,
        '\\', 35,
        ']', 95,
        '^', 130,
        '`', 190,
        '{', 84,
        '|', 135,
        '}', 87,
      );
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(195);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(5);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '`' || '~' < lookahead)) ADVANCE(207);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '!', 89,
        '%', 148,
        '&', 129,
        '(', 90,
        ')', 92,
        '*', 80,
        '+', 139,
        ',', 86,
        '-', 143,
        '.', 96,
        '/', 146,
        ':', 93,
        ';', 91,
        '<', 154,
        '=', 28,
        '>', 163,
        '?', 21,
        '[', 94,
        '\\', 35,
        ']', 95,
        '^', 130,
        '`', 190,
        '{', 84,
        '|', 135,
        '}', 87,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(5);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(207);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(77);
      if (lookahead == '\\') ADVANCE(34);
      if (set_contains(sym_identifier_character_set_1, 14, lookahead)) ADVANCE(208);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '!', 88,
        '"', 169,
        '#', 31,
        '&', 127,
        '\'', 170,
        '(', 90,
        ')', 92,
        '*', 78,
        '+', 139,
        ',', 86,
        '-', 143,
        '.', 97,
        '/', 146,
        '0', 197,
        ':', 93,
        ';', 91,
        '<', 152,
        '=', 83,
        '>', 161,
        '?', 211,
        '@', 209,
        '[', 94,
        '\\', 35,
        ']', 95,
        '`', 190,
        '{', 84,
        '|', 137,
        '}', 87,
        '~', 166,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(198);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(7);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead)) ADVANCE(207);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '!', 88,
        '"', 169,
        '#', 31,
        '&', 127,
        '\'', 170,
        '(', 90,
        ')', 92,
        '*', 78,
        '+', 139,
        ',', 86,
        '-', 143,
        '.', 97,
        '/', 146,
        '0', 197,
        '<', 152,
        '?', 210,
        '@', 209,
        '[', 94,
        '\\', 35,
        ']', 95,
        '`', 190,
        '{', 85,
        '|', 132,
        '~', 166,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(198);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(8);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(207);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '"', 169,
        '#', 31,
        '&', 127,
        '\'', 170,
        '(', 90,
        '*', 78,
        '+', 138,
        ',', 86,
        '-', 142,
        '.', 20,
        '/', 17,
        '0', 197,
        ';', 91,
        '<', 152,
        '>', 161,
        '?', 210,
        '@', 209,
        '[', 94,
        '\\', 35,
        ']', 95,
        '`', 190,
        '{', 85,
        '|', 137,
        '}', 87,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(198);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(9);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(207);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '"', 169,
        '#', 31,
        '\'', 170,
        '(', 90,
        '*', 78,
        '+', 138,
        ',', 86,
        '-', 142,
        '.', 20,
        '/', 17,
        '0', 197,
        ';', 91,
        '<', 152,
        '@', 209,
        '[', 94,
        '\\', 35,
        '{', 84,
        '|', 45,
        '}', 87,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(198);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(10);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(207);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(169);
      if (lookahead == '/') ADVANCE(17);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(11);
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(169);
      if (lookahead == '/') ADVANCE(171);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(11);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(174);
      if (lookahead != 0) ADVANCE(176);
      END_STATE();
    case 13:
      ADVANCE_MAP(
        '$', 37,
        '+', 29,
        '-', 30,
        '/', 17,
        ':', 93,
        '?', 27,
        '\\', 36,
        '`', 190,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(14);
      END_STATE();
    case 14:
      if (lookahead == '$') ADVANCE(37);
      if (lookahead == '+') ADVANCE(29);
      if (lookahead == '-') ADVANCE(30);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == ':') ADVANCE(93);
      if (lookahead == '?') ADVANCE(27);
      if (lookahead == '`') ADVANCE(190);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(14);
      END_STATE();
    case 15:
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '/') ADVANCE(17);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(15);
      END_STATE();
    case 16:
      if (lookahead == '\'') ADVANCE(170);
      if (lookahead == '/') ADVANCE(177);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(15);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(180);
      if (lookahead != 0) ADVANCE(182);
      END_STATE();
    case 17:
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == '/') ADVANCE(189);
      END_STATE();
    case 18:
      if (lookahead == '*') ADVANCE(18);
      if (lookahead == '/') ADVANCE(188);
      if (lookahead != 0) ADVANCE(19);
      END_STATE();
    case 19:
      if (lookahead == '*') ADVANCE(18);
      if (lookahead != 0) ADVANCE(19);
      END_STATE();
    case 20:
      if (lookahead == '.') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(203);
      END_STATE();
    case 21:
      if (lookahead == '.') ADVANCE(100);
      if (lookahead == '?') ADVANCE(164);
      END_STATE();
    case 22:
      if (lookahead == '.') ADVANCE(116);
      END_STATE();
    case 23:
      if (lookahead == '/') ADVANCE(192);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(24);
      END_STATE();
    case 24:
      if (lookahead == '/') ADVANCE(17);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(24);
      END_STATE();
    case 25:
      if (lookahead == ':') ADVANCE(215);
      END_STATE();
    case 26:
      if (lookahead == ':') ADVANCE(214);
      END_STATE();
    case 27:
      if (lookahead == ':') ADVANCE(216);
      END_STATE();
    case 28:
      if (lookahead == '=') ADVANCE(156);
      END_STATE();
    case 29:
      if (lookahead == '?') ADVANCE(25);
      END_STATE();
    case 30:
      if (lookahead == '?') ADVANCE(26);
      END_STATE();
    case 31:
      if (lookahead == '\\') ADVANCE(34);
      if (set_contains(sym_identifier_character_set_1, 14, lookahead)) ADVANCE(208);
      END_STATE();
    case 32:
      if (lookahead == '\\') ADVANCE(71);
      if (lookahead == ']') ADVANCE(194);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(32);
      END_STATE();
    case 33:
      if (lookahead == 'u') ADVANCE(38);
      if (lookahead == 'x') ADVANCE(63);
      if (lookahead == '\r' ||
          lookahead == '?') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(187);
      if (lookahead != 0) ADVANCE(183);
      END_STATE();
    case 34:
      if (lookahead == 'u') ADVANCE(39);
      END_STATE();
    case 35:
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 36:
      if (lookahead == 'u') ADVANCE(41);
      if (lookahead == 'x') ADVANCE(63);
      if (lookahead == '\r' ||
          lookahead == '?') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(187);
      if (lookahead != 0) ADVANCE(183);
      END_STATE();
    case 37:
      if (lookahead == '{') ADVANCE(191);
      END_STATE();
    case 38:
      if (lookahead == '{') ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(68);
      END_STATE();
    case 39:
      if (lookahead == '{') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(69);
      END_STATE();
    case 40:
      if (lookahead == '{') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(70);
      END_STATE();
    case 41:
      if (lookahead == '{') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(60);
      END_STATE();
    case 42:
      if (lookahead == '}') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(42);
      END_STATE();
    case 43:
      if (lookahead == '}') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 44:
      if (lookahead == '}') ADVANCE(183);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 45:
      if (lookahead == '}') ADVANCE(218);
      END_STATE();
    case 46:
      if (lookahead == '}') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 47:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(53);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(204);
      END_STATE();
    case 48:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(200);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(201);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(198);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(203);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(199);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(204);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(207);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(208);
      END_STATE();
    case 56:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(183);
      END_STATE();
    case 57:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(202);
      END_STATE();
    case 58:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 59:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(184);
      END_STATE();
    case 60:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(63);
      END_STATE();
    case 61:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 62:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(42);
      END_STATE();
    case 63:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(56);
      END_STATE();
    case 64:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 65:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(59);
      END_STATE();
    case 66:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 67:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 68:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(65);
      END_STATE();
    case 69:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(66);
      END_STATE();
    case 70:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      END_STATE();
    case 71:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(32);
      END_STATE();
    case 72:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(194);
      END_STATE();
    case 73:
      if (eof) ADVANCE(76);
      ADVANCE_MAP(
        '!', 89,
        '"', 169,
        '#', 6,
        '$', 206,
        '%', 149,
        '&', 128,
        '\'', 170,
        '(', 90,
        ')', 92,
        '*', 79,
        '+', 141,
        ',', 86,
        '-', 145,
        '.', 97,
        '/', 147,
        '0', 197,
        ':', 93,
        ';', 91,
        '<', 153,
        '=', 82,
        '>', 162,
        '?', 212,
        '@', 209,
        '[', 94,
        '\\', 35,
        ']', 95,
        '^', 131,
        '`', 190,
        '{', 85,
        '|', 134,
        '}', 87,
        '~', 166,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(198);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(73);
      if (lookahead > '@') ADVANCE(207);
      END_STATE();
    case 74:
      if (eof) ADVANCE(76);
      ADVANCE_MAP(
        '!', 89,
        '"', 169,
        '#', 31,
        '%', 148,
        '&', 129,
        '\'', 170,
        '(', 90,
        ')', 92,
        '*', 80,
        '+', 139,
        ',', 86,
        '-', 143,
        '.', 98,
        '/', 146,
        '0', 197,
        ':', 93,
        ';', 91,
        '<', 154,
        '=', 81,
        '>', 163,
        '?', 213,
        '@', 209,
        '[', 94,
        '\\', 35,
        ']', 95,
        '^', 130,
        '`', 190,
        '{', 84,
        '|', 136,
        '}', 87,
        '~', 166,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(198);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(74);
      if (lookahead > '#') ADVANCE(207);
      END_STATE();
    case 75:
      if (eof) ADVANCE(76);
      ADVANCE_MAP(
        '!', 88,
        '"', 169,
        '#', 6,
        '&', 127,
        '\'', 170,
        '(', 90,
        ')', 92,
        '*', 78,
        '+', 139,
        ',', 86,
        '-', 143,
        '.', 97,
        '/', 146,
        '0', 197,
        ':', 93,
        ';', 91,
        '<', 152,
        '=', 83,
        '>', 161,
        '?', 210,
        '@', 209,
        '[', 94,
        '\\', 35,
        ']', 95,
        '`', 190,
        '{', 84,
        '|', 137,
        '}', 87,
        '~', 166,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(198);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(75);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead)) ADVANCE(207);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(77);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(151);
      if (lookahead == '=') ADVANCE(103);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(150);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(156);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(156);
      if (lookahead == '>') ADVANCE(99);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(99);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '|') ADVANCE(217);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(158);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(203);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(203);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_AMP_AMP_EQ);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE_EQ);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (lookahead == '=') ADVANCE(113);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(109);
      if (lookahead == '>') ADVANCE(124);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(123);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(110);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(111);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(118);
      if (lookahead == '=') ADVANCE(107);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(117);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(106);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(108);
      if (lookahead == '|') ADVANCE(120);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(108);
      if (lookahead == '|') ADVANCE(120);
      if (lookahead == '}') ADVANCE(218);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(119);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(119);
      if (lookahead == '}') ADVANCE(218);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '}') ADVANCE(218);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(167);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(167);
      if (lookahead == '=') ADVANCE(101);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(167);
      if (lookahead == '=') ADVANCE(101);
      if (lookahead == '?') ADVANCE(25);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(168);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(168);
      if (lookahead == '=') ADVANCE(102);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(168);
      if (lookahead == '=') ADVANCE(102);
      if (lookahead == '?') ADVANCE(26);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == '/') ADVANCE(189);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == '/') ADVANCE(189);
      if (lookahead == '=') ADVANCE(104);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(105);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(112);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(126);
      if (lookahead == '=') ADVANCE(155);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(125);
      if (lookahead == '=') ADVANCE(155);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(157);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(159);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(121);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(122);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      if (lookahead == '=') ADVANCE(115);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(173);
      if (lookahead == '/') ADVANCE(175);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(176);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(172);
      if (lookahead == '/') ADVANCE(176);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(173);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(172);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(173);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '/') ADVANCE(171);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(174);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(176);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(176);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(175);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(176);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(179);
      if (lookahead == '/') ADVANCE(181);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(182);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(178);
      if (lookahead == '/') ADVANCE(182);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(179);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(178);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(179);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '/') ADVANCE(177);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(180);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(182);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(182);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(181);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(182);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(35);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(207);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(183);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(183);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(186);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != 0x2028 &&
          lookahead != 0x2029) ADVANCE(189);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '\n') SKIP(24);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '[') ADVANCE(32);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(193);
      if (lookahead != 0) ADVANCE(194);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(32);
      if (lookahead == '\\') ADVANCE(72);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(194);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_regex_flags);
      if (lookahead == '\\') ADVANCE(35);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(195);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(207);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_number);
      ADVANCE_MAP(
        '.', 205,
        '0', 199,
        '_', 52,
        'n', 196,
        'B', 48,
        'b', 48,
        'E', 47,
        'e', 47,
        'O', 49,
        'o', 49,
        'X', 57,
        'x', 57,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(198);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(205);
      if (lookahead == '_') ADVANCE(50);
      if (lookahead == 'n') ADVANCE(196);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(198);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(52);
      if (lookahead == 'n') ADVANCE(196);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(199);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(196);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(200);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(49);
      if (lookahead == 'n') ADVANCE(196);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(201);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(57);
      if (lookahead == 'n') ADVANCE(196);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(202);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(51);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(203);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(53);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(204);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(203);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == '{') ADVANCE(191);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(207);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(35);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(207);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_private_property_identifier);
      if (lookahead == '\\') ADVANCE(34);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(208);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(100);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(100);
      if (lookahead == '?') ADVANCE(165);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(100);
      if (lookahead == '?') ADVANCE(164);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_DASH_QMARK_COLON);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_PLUS_QMARK_COLON);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_QMARK_COLON);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_LBRACE_PIPE);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_PIPE_RBRACE);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'b', 2,
        'c', 3,
        'd', 4,
        'e', 5,
        'f', 6,
        'g', 7,
        'i', 8,
        'k', 9,
        'l', 10,
        'm', 11,
        'n', 12,
        'o', 13,
        'p', 14,
        'r', 15,
        's', 16,
        't', 17,
        'u', 18,
        'v', 19,
        'w', 20,
        'y', 21,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(22);
      if (lookahead == 'c') ADVANCE(23);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead == 's') ADVANCE(25);
      if (lookahead == 'w') ADVANCE(26);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(27);
      if (lookahead == 'r') ADVANCE(28);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'l') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(32);
      if (lookahead == 'o') ADVANCE(33);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(34);
      if (lookahead == 'n') ADVANCE(35);
      if (lookahead == 'x') ADVANCE(36);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(38);
      if (lookahead == 'o') ADVANCE(39);
      if (lookahead == 'r') ADVANCE(40);
      if (lookahead == 'u') ADVANCE(41);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(42);
      if (lookahead == 'l') ADVANCE(43);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(44);
      if (lookahead == 'm') ADVANCE(45);
      if (lookahead == 'n') ADVANCE(46);
      if (lookahead == 's') ADVANCE(47);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(49);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(50);
      if (lookahead == 'o') ADVANCE(51);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(52);
      if (lookahead == 'e') ADVANCE(53);
      if (lookahead == 'u') ADVANCE(54);
      END_STATE();
    case 13:
      if (lookahead == 'b') ADVANCE(55);
      if (lookahead == 'f') ADVANCE(56);
      if (lookahead == 'v') ADVANCE(57);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(58);
      if (lookahead == 'u') ADVANCE(59);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(61);
      if (lookahead == 'e') ADVANCE(62);
      if (lookahead == 't') ADVANCE(63);
      if (lookahead == 'u') ADVANCE(64);
      if (lookahead == 'w') ADVANCE(65);
      if (lookahead == 'y') ADVANCE(66);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(67);
      if (lookahead == 'h') ADVANCE(68);
      if (lookahead == 'r') ADVANCE(69);
      if (lookahead == 'y') ADVANCE(70);
      END_STATE();
    case 18:
      if (lookahead == 'n') ADVANCE(71);
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(73);
      if (lookahead == 'o') ADVANCE(74);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(75);
      if (lookahead == 'i') ADVANCE(76);
      END_STATE();
    case 21:
      if (lookahead == 'i') ADVANCE(77);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(78);
      END_STATE();
    case 23:
      if (lookahead == 'c') ADVANCE(79);
      END_STATE();
    case 24:
      if (lookahead == 'y') ADVANCE(80);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(81);
      if (lookahead == 'y') ADVANCE(82);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(83);
      END_STATE();
    case 27:
      if (lookahead == 'o') ADVANCE(84);
      END_STATE();
    case 28:
      if (lookahead == 'e') ADVANCE(85);
      END_STATE();
    case 29:
      if (lookahead == 's') ADVANCE(86);
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 30:
      if (lookahead == 'a') ADVANCE(88);
      END_STATE();
    case 31:
      if (lookahead == 'n') ADVANCE(89);
      END_STATE();
    case 32:
      if (lookahead == 'b') ADVANCE(90);
      if (lookahead == 'c') ADVANCE(91);
      if (lookahead == 'f') ADVANCE(92);
      if (lookahead == 'l') ADVANCE(93);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 34:
      if (lookahead == 's') ADVANCE(94);
      END_STATE();
    case 35:
      if (lookahead == 'u') ADVANCE(95);
      END_STATE();
    case 36:
      if (lookahead == 'p') ADVANCE(96);
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 37:
      if (lookahead == 'l') ADVANCE(98);
      END_STATE();
    case 38:
      if (lookahead == 'n') ADVANCE(99);
      END_STATE();
    case 39:
      if (lookahead == 'r') ADVANCE(100);
      END_STATE();
    case 40:
      if (lookahead == 'o') ADVANCE(101);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(102);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(103);
      END_STATE();
    case 43:
      if (lookahead == 'o') ADVANCE(104);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 45:
      if (lookahead == 'p') ADVANCE(105);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'f') ADVANCE(106);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == 't') ADVANCE(108);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 48:
      if (lookahead == 'y') ADVANCE(109);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(110);
      END_STATE();
    case 50:
      if (lookahead == 't') ADVANCE(111);
      END_STATE();
    case 51:
      if (lookahead == 'd') ADVANCE(112);
      END_STATE();
    case 52:
      if (lookahead == 'm') ADVANCE(113);
      END_STATE();
    case 53:
      if (lookahead == 'v') ADVANCE(114);
      if (lookahead == 'w') ADVANCE(115);
      END_STATE();
    case 54:
      if (lookahead == 'l') ADVANCE(116);
      if (lookahead == 'm') ADVANCE(117);
      END_STATE();
    case 55:
      if (lookahead == 'j') ADVANCE(118);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(119);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(120);
      if (lookahead == 'o') ADVANCE(121);
      END_STATE();
    case 59:
      if (lookahead == 'b') ADVANCE(122);
      END_STATE();
    case 60:
      if (lookahead == 'a') ADVANCE(123);
      if (lookahead == 'q') ADVANCE(124);
      if (lookahead == 't') ADVANCE(125);
      END_STATE();
    case 61:
      if (lookahead == 't') ADVANCE(126);
      END_STATE();
    case 62:
      if (lookahead == 't') ADVANCE(127);
      END_STATE();
    case 63:
      if (lookahead == 'a') ADVANCE(128);
      if (lookahead == 'r') ADVANCE(129);
      END_STATE();
    case 64:
      if (lookahead == 'p') ADVANCE(130);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(131);
      END_STATE();
    case 66:
      if (lookahead == 'm') ADVANCE(132);
      END_STATE();
    case 67:
      if (lookahead == 'r') ADVANCE(133);
      END_STATE();
    case 68:
      if (lookahead == 'i') ADVANCE(134);
      if (lookahead == 'r') ADVANCE(135);
      END_STATE();
    case 69:
      if (lookahead == 'u') ADVANCE(136);
      if (lookahead == 'y') ADVANCE(137);
      END_STATE();
    case 70:
      if (lookahead == 'p') ADVANCE(138);
      END_STATE();
    case 71:
      if (lookahead == 'd') ADVANCE(139);
      if (lookahead == 'i') ADVANCE(140);
      if (lookahead == 'k') ADVANCE(141);
      END_STATE();
    case 72:
      if (lookahead == 'i') ADVANCE(142);
      END_STATE();
    case 73:
      if (lookahead == 'r') ADVANCE(143);
      END_STATE();
    case 74:
      if (lookahead == 'i') ADVANCE(144);
      END_STATE();
    case 75:
      if (lookahead == 'i') ADVANCE(145);
      END_STATE();
    case 76:
      if (lookahead == 't') ADVANCE(146);
      END_STATE();
    case 77:
      if (lookahead == 'e') ADVANCE(147);
      END_STATE();
    case 78:
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_any);
      END_STATE();
    case 81:
      if (lookahead == 'e') ADVANCE(150);
      END_STATE();
    case 82:
      if (lookahead == 'n') ADVANCE(151);
      END_STATE();
    case 83:
      if (lookahead == 'i') ADVANCE(152);
      END_STATE();
    case 84:
      if (lookahead == 'l') ADVANCE(153);
      END_STATE();
    case 85:
      if (lookahead == 'a') ADVANCE(154);
      END_STATE();
    case 86:
      if (lookahead == 'e') ADVANCE(155);
      END_STATE();
    case 87:
      if (lookahead == 'c') ADVANCE(156);
      END_STATE();
    case 88:
      if (lookahead == 's') ADVANCE(157);
      END_STATE();
    case 89:
      if (lookahead == 's') ADVANCE(158);
      if (lookahead == 't') ADVANCE(159);
      END_STATE();
    case 90:
      if (lookahead == 'u') ADVANCE(160);
      END_STATE();
    case 91:
      if (lookahead == 'l') ADVANCE(161);
      END_STATE();
    case 92:
      if (lookahead == 'a') ADVANCE(162);
      END_STATE();
    case 93:
      if (lookahead == 'e') ADVANCE(163);
      END_STATE();
    case 94:
      if (lookahead == 'e') ADVANCE(164);
      END_STATE();
    case 95:
      if (lookahead == 'm') ADVANCE(165);
      END_STATE();
    case 96:
      if (lookahead == 'o') ADVANCE(166);
      END_STATE();
    case 97:
      if (lookahead == 'e') ADVANCE(167);
      END_STATE();
    case 98:
      if (lookahead == 's') ADVANCE(168);
      END_STATE();
    case 99:
      if (lookahead == 'a') ADVANCE(169);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 101:
      if (lookahead == 'm') ADVANCE(170);
      END_STATE();
    case 102:
      if (lookahead == 'c') ADVANCE(171);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 104:
      if (lookahead == 'b') ADVANCE(172);
      END_STATE();
    case 105:
      if (lookahead == 'l') ADVANCE(173);
      if (lookahead == 'o') ADVANCE(174);
      END_STATE();
    case 106:
      if (lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 107:
      if (lookahead == 't') ADVANCE(176);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 109:
      if (lookahead == 'o') ADVANCE(178);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 111:
      if (lookahead == 'a') ADVANCE(179);
      END_STATE();
    case 112:
      if (lookahead == 'u') ADVANCE(180);
      END_STATE();
    case 113:
      if (lookahead == 'e') ADVANCE(181);
      END_STATE();
    case 114:
      if (lookahead == 'e') ADVANCE(182);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 116:
      if (lookahead == 'l') ADVANCE(183);
      END_STATE();
    case 117:
      if (lookahead == 'b') ADVANCE(184);
      END_STATE();
    case 118:
      if (lookahead == 'e') ADVANCE(185);
      END_STATE();
    case 119:
      if (lookahead == 'r') ADVANCE(186);
      END_STATE();
    case 120:
      if (lookahead == 'v') ADVANCE(187);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(188);
      END_STATE();
    case 122:
      if (lookahead == 'l') ADVANCE(189);
      END_STATE();
    case 123:
      if (lookahead == 'd') ADVANCE(190);
      END_STATE();
    case 124:
      if (lookahead == 'u') ADVANCE(191);
      END_STATE();
    case 125:
      if (lookahead == 'u') ADVANCE(192);
      END_STATE();
    case 126:
      if (lookahead == 'i') ADVANCE(193);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 128:
      if (lookahead == 't') ADVANCE(194);
      END_STATE();
    case 129:
      if (lookahead == 'i') ADVANCE(195);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(196);
      END_STATE();
    case 131:
      if (lookahead == 't') ADVANCE(197);
      END_STATE();
    case 132:
      if (lookahead == 'b') ADVANCE(198);
      END_STATE();
    case 133:
      if (lookahead == 'g') ADVANCE(199);
      END_STATE();
    case 134:
      if (lookahead == 's') ADVANCE(200);
      END_STATE();
    case 135:
      if (lookahead == 'o') ADVANCE(201);
      END_STATE();
    case 136:
      if (lookahead == 'e') ADVANCE(202);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 138:
      if (lookahead == 'e') ADVANCE(203);
      END_STATE();
    case 139:
      if (lookahead == 'e') ADVANCE(204);
      END_STATE();
    case 140:
      if (lookahead == 'q') ADVANCE(205);
      END_STATE();
    case 141:
      if (lookahead == 'n') ADVANCE(206);
      END_STATE();
    case 142:
      if (lookahead == 'n') ADVANCE(207);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 144:
      if (lookahead == 'd') ADVANCE(208);
      END_STATE();
    case 145:
      if (lookahead == 'l') ADVANCE(209);
      END_STATE();
    case 146:
      if (lookahead == 'h') ADVANCE(210);
      END_STATE();
    case 147:
      if (lookahead == 'l') ADVANCE(211);
      END_STATE();
    case 148:
      if (lookahead == 'r') ADVANCE(212);
      END_STATE();
    case 149:
      if (lookahead == 's') ADVANCE(213);
      END_STATE();
    case 150:
      if (lookahead == 'r') ADVANCE(214);
      END_STATE();
    case 151:
      if (lookahead == 'c') ADVANCE(215);
      END_STATE();
    case 152:
      if (lookahead == 't') ADVANCE(216);
      END_STATE();
    case 153:
      if (lookahead == 'e') ADVANCE(217);
      END_STATE();
    case 154:
      if (lookahead == 'k') ADVANCE(218);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 156:
      if (lookahead == 'h') ADVANCE(219);
      END_STATE();
    case 157:
      if (lookahead == 's') ADVANCE(220);
      END_STATE();
    case 158:
      if (lookahead == 't') ADVANCE(221);
      END_STATE();
    case 159:
      if (lookahead == 'i') ADVANCE(222);
      END_STATE();
    case 160:
      if (lookahead == 'g') ADVANCE(223);
      END_STATE();
    case 161:
      if (lookahead == 'a') ADVANCE(224);
      END_STATE();
    case 162:
      if (lookahead == 'u') ADVANCE(225);
      END_STATE();
    case 163:
      if (lookahead == 't') ADVANCE(226);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 166:
      if (lookahead == 'r') ADVANCE(227);
      END_STATE();
    case 167:
      if (lookahead == 'n') ADVANCE(228);
      END_STATE();
    case 168:
      if (lookahead == 'e') ADVANCE(229);
      END_STATE();
    case 169:
      if (lookahead == 'l') ADVANCE(230);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 171:
      if (lookahead == 't') ADVANCE(231);
      END_STATE();
    case 172:
      if (lookahead == 'a') ADVANCE(232);
      END_STATE();
    case 173:
      if (lookahead == 'e') ADVANCE(233);
      END_STATE();
    case 174:
      if (lookahead == 'r') ADVANCE(234);
      END_STATE();
    case 175:
      if (lookahead == 'r') ADVANCE(235);
      END_STATE();
    case 176:
      if (lookahead == 'a') ADVANCE(236);
      END_STATE();
    case 177:
      if (lookahead == 'r') ADVANCE(237);
      END_STATE();
    case 178:
      if (lookahead == 'f') ADVANCE(238);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_meta);
      END_STATE();
    case 180:
      if (lookahead == 'l') ADVANCE(239);
      END_STATE();
    case 181:
      if (lookahead == 's') ADVANCE(240);
      END_STATE();
    case 182:
      if (lookahead == 'r') ADVANCE(241);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 184:
      if (lookahead == 'e') ADVANCE(242);
      END_STATE();
    case 185:
      if (lookahead == 'c') ADVANCE(243);
      END_STATE();
    case 186:
      if (lookahead == 'r') ADVANCE(244);
      END_STATE();
    case 187:
      if (lookahead == 'a') ADVANCE(245);
      END_STATE();
    case 188:
      if (lookahead == 'e') ADVANCE(246);
      END_STATE();
    case 189:
      if (lookahead == 'i') ADVANCE(247);
      END_STATE();
    case 190:
      if (lookahead == 'o') ADVANCE(248);
      END_STATE();
    case 191:
      if (lookahead == 'i') ADVANCE(249);
      END_STATE();
    case 192:
      if (lookahead == 'r') ADVANCE(250);
      END_STATE();
    case 193:
      if (lookahead == 's') ADVANCE(251);
      END_STATE();
    case 194:
      if (lookahead == 'i') ADVANCE(252);
      END_STATE();
    case 195:
      if (lookahead == 'n') ADVANCE(253);
      END_STATE();
    case 196:
      if (lookahead == 'r') ADVANCE(254);
      END_STATE();
    case 197:
      if (lookahead == 'c') ADVANCE(255);
      END_STATE();
    case 198:
      if (lookahead == 'o') ADVANCE(256);
      END_STATE();
    case 199:
      if (lookahead == 'e') ADVANCE(257);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 201:
      if (lookahead == 'w') ADVANCE(258);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_type);
      if (lookahead == 'o') ADVANCE(259);
      END_STATE();
    case 204:
      if (lookahead == 'f') ADVANCE(260);
      END_STATE();
    case 205:
      if (lookahead == 'u') ADVANCE(261);
      END_STATE();
    case 206:
      if (lookahead == 'o') ADVANCE(262);
      END_STATE();
    case 207:
      if (lookahead == 'g') ADVANCE(263);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 209:
      if (lookahead == 'e') ADVANCE(264);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 211:
      if (lookahead == 'd') ADVANCE(265);
      END_STATE();
    case 212:
      if (lookahead == 'a') ADVANCE(266);
      END_STATE();
    case 213:
      if (lookahead == 's') ADVANCE(267);
      END_STATE();
    case 214:
      if (lookahead == 't') ADVANCE(268);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 217:
      if (lookahead == 'a') ADVANCE(269);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 222:
      if (lookahead == 'n') ADVANCE(270);
      END_STATE();
    case 223:
      if (lookahead == 'g') ADVANCE(271);
      END_STATE();
    case 224:
      if (lookahead == 'r') ADVANCE(272);
      END_STATE();
    case 225:
      if (lookahead == 'l') ADVANCE(273);
      END_STATE();
    case 226:
      if (lookahead == 'e') ADVANCE(274);
      END_STATE();
    case 227:
      if (lookahead == 't') ADVANCE(275);
      END_STATE();
    case 228:
      if (lookahead == 'd') ADVANCE(276);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 230:
      if (lookahead == 'l') ADVANCE(277);
      END_STATE();
    case 231:
      if (lookahead == 'i') ADVANCE(278);
      END_STATE();
    case 232:
      if (lookahead == 'l') ADVANCE(279);
      END_STATE();
    case 233:
      if (lookahead == 'm') ADVANCE(280);
      END_STATE();
    case 234:
      if (lookahead == 't') ADVANCE(281);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_infer);
      END_STATE();
    case 236:
      if (lookahead == 'n') ADVANCE(282);
      END_STATE();
    case 237:
      if (lookahead == 'f') ADVANCE(283);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_keyof);
      END_STATE();
    case 239:
      if (lookahead == 'e') ADVANCE(284);
      END_STATE();
    case 240:
      if (lookahead == 'p') ADVANCE(285);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_never);
      END_STATE();
    case 242:
      if (lookahead == 'r') ADVANCE(286);
      END_STATE();
    case 243:
      if (lookahead == 't') ADVANCE(287);
      END_STATE();
    case 244:
      if (lookahead == 'i') ADVANCE(288);
      END_STATE();
    case 245:
      if (lookahead == 't') ADVANCE(289);
      END_STATE();
    case 246:
      if (lookahead == 'c') ADVANCE(290);
      END_STATE();
    case 247:
      if (lookahead == 'c') ADVANCE(291);
      END_STATE();
    case 248:
      if (lookahead == 'n') ADVANCE(292);
      END_STATE();
    case 249:
      if (lookahead == 'r') ADVANCE(293);
      END_STATE();
    case 250:
      if (lookahead == 'n') ADVANCE(294);
      END_STATE();
    case 251:
      if (lookahead == 'f') ADVANCE(295);
      END_STATE();
    case 252:
      if (lookahead == 'c') ADVANCE(296);
      END_STATE();
    case 253:
      if (lookahead == 'g') ADVANCE(297);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 255:
      if (lookahead == 'h') ADVANCE(298);
      END_STATE();
    case 256:
      if (lookahead == 'l') ADVANCE(299);
      END_STATE();
    case 257:
      if (lookahead == 't') ADVANCE(300);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 259:
      if (lookahead == 'f') ADVANCE(301);
      END_STATE();
    case 260:
      if (lookahead == 'i') ADVANCE(302);
      END_STATE();
    case 261:
      if (lookahead == 'e') ADVANCE(303);
      END_STATE();
    case 262:
      if (lookahead == 'w') ADVANCE(304);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_using);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 266:
      if (lookahead == 'c') ADVANCE(305);
      END_STATE();
    case 267:
      if (lookahead == 'o') ADVANCE(306);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_assert);
      if (lookahead == 's') ADVANCE(307);
      END_STATE();
    case 269:
      if (lookahead == 'n') ADVANCE(308);
      END_STATE();
    case 270:
      if (lookahead == 'u') ADVANCE(309);
      END_STATE();
    case 271:
      if (lookahead == 'e') ADVANCE(310);
      END_STATE();
    case 272:
      if (lookahead == 'e') ADVANCE(311);
      END_STATE();
    case 273:
      if (lookahead == 't') ADVANCE(312);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 276:
      if (lookahead == 's') ADVANCE(313);
      END_STATE();
    case 277:
      if (lookahead == 'y') ADVANCE(314);
      END_STATE();
    case 278:
      if (lookahead == 'o') ADVANCE(315);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 280:
      if (lookahead == 'e') ADVANCE(316);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 282:
      if (lookahead == 'c') ADVANCE(317);
      END_STATE();
    case 283:
      if (lookahead == 'a') ADVANCE(318);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 285:
      if (lookahead == 'a') ADVANCE(319);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_number);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_object);
      END_STATE();
    case 288:
      if (lookahead == 'd') ADVANCE(320);
      END_STATE();
    case 289:
      if (lookahead == 'e') ADVANCE(321);
      END_STATE();
    case 290:
      if (lookahead == 't') ADVANCE(322);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 292:
      if (lookahead == 'l') ADVANCE(323);
      END_STATE();
    case 293:
      if (lookahead == 'e') ADVANCE(324);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 295:
      if (lookahead == 'i') ADVANCE(325);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_symbol);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 302:
      if (lookahead == 'n') ADVANCE(326);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_unique);
      END_STATE();
    case 304:
      if (lookahead == 'n') ADVANCE(327);
      END_STATE();
    case 305:
      if (lookahead == 't') ADVANCE(328);
      END_STATE();
    case 306:
      if (lookahead == 'r') ADVANCE(329);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_asserts);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_boolean);
      END_STATE();
    case 309:
      if (lookahead == 'e') ADVANCE(330);
      END_STATE();
    case 310:
      if (lookahead == 'r') ADVANCE(331);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_declare);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 315:
      if (lookahead == 'n') ADVANCE(332);
      END_STATE();
    case 316:
      if (lookahead == 'n') ADVANCE(333);
      END_STATE();
    case 317:
      if (lookahead == 'e') ADVANCE(334);
      END_STATE();
    case 318:
      if (lookahead == 'c') ADVANCE(335);
      END_STATE();
    case 319:
      if (lookahead == 'c') ADVANCE(336);
      END_STATE();
    case 320:
      if (lookahead == 'e') ADVANCE(337);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 322:
      if (lookahead == 'e') ADVANCE(338);
      END_STATE();
    case 323:
      if (lookahead == 'y') ADVANCE(339);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_require);
      END_STATE();
    case 325:
      if (lookahead == 'e') ADVANCE(340);
      END_STATE();
    case 326:
      if (lookahead == 'e') ADVANCE(341);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(anon_sym_unknown);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_accessor);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_debugger);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 333:
      if (lookahead == 't') ADVANCE(342);
      END_STATE();
    case 334:
      if (lookahead == 'o') ADVANCE(343);
      END_STATE();
    case 335:
      if (lookahead == 'e') ADVANCE(344);
      END_STATE();
    case 336:
      if (lookahead == 'e') ADVANCE(345);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_override);
      END_STATE();
    case 338:
      if (lookahead == 'd') ADVANCE(346);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_readonly);
      END_STATE();
    case 340:
      if (lookahead == 's') ADVANCE(347);
      END_STATE();
    case 341:
      if (lookahead == 'd') ADVANCE(348);
      END_STATE();
    case 342:
      if (lookahead == 's') ADVANCE(349);
      END_STATE();
    case 343:
      if (lookahead == 'f') ADVANCE(350);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_namespace);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_satisfies);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_undefined);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 75, .external_lex_state = 2},
  [2] = {.lex_state = 2, .external_lex_state = 3},
  [3] = {.lex_state = 2, .external_lex_state = 3},
  [4] = {.lex_state = 75, .external_lex_state = 2},
  [5] = {.lex_state = 75, .external_lex_state = 2},
  [6] = {.lex_state = 75, .external_lex_state = 2},
  [7] = {.lex_state = 75, .external_lex_state = 2},
  [8] = {.lex_state = 75, .external_lex_state = 2},
  [9] = {.lex_state = 75, .external_lex_state = 2},
  [10] = {.lex_state = 75, .external_lex_state = 2},
  [11] = {.lex_state = 75, .external_lex_state = 2},
  [12] = {.lex_state = 75, .external_lex_state = 2},
  [13] = {.lex_state = 75, .external_lex_state = 2},
  [14] = {.lex_state = 75, .external_lex_state = 2},
  [15] = {.lex_state = 75, .external_lex_state = 2},
  [16] = {.lex_state = 75, .external_lex_state = 2},
  [17] = {.lex_state = 75, .external_lex_state = 2},
  [18] = {.lex_state = 75, .external_lex_state = 2},
  [19] = {.lex_state = 75, .external_lex_state = 2},
  [20] = {.lex_state = 75, .external_lex_state = 2},
  [21] = {.lex_state = 75, .external_lex_state = 2},
  [22] = {.lex_state = 75, .external_lex_state = 2},
  [23] = {.lex_state = 75, .external_lex_state = 2},
  [24] = {.lex_state = 75, .external_lex_state = 2},
  [25] = {.lex_state = 75, .external_lex_state = 2},
  [26] = {.lex_state = 75, .external_lex_state = 2},
  [27] = {.lex_state = 75, .external_lex_state = 2},
  [28] = {.lex_state = 75, .external_lex_state = 2},
  [29] = {.lex_state = 75, .external_lex_state = 2},
  [30] = {.lex_state = 75, .external_lex_state = 2},
  [31] = {.lex_state = 8, .external_lex_state = 2},
  [32] = {.lex_state = 75, .external_lex_state = 2},
  [33] = {.lex_state = 75, .external_lex_state = 2},
  [34] = {.lex_state = 75, .external_lex_state = 2},
  [35] = {.lex_state = 75, .external_lex_state = 2},
  [36] = {.lex_state = 75, .external_lex_state = 2},
  [37] = {.lex_state = 75, .external_lex_state = 2},
  [38] = {.lex_state = 8, .external_lex_state = 2},
  [39] = {.lex_state = 75, .external_lex_state = 2},
  [40] = {.lex_state = 8, .external_lex_state = 2},
  [41] = {.lex_state = 75, .external_lex_state = 2},
  [42] = {.lex_state = 75, .external_lex_state = 2},
  [43] = {.lex_state = 75, .external_lex_state = 2},
  [44] = {.lex_state = 75, .external_lex_state = 2},
  [45] = {.lex_state = 75, .external_lex_state = 2},
  [46] = {.lex_state = 75, .external_lex_state = 2},
  [47] = {.lex_state = 75, .external_lex_state = 2},
  [48] = {.lex_state = 75, .external_lex_state = 2},
  [49] = {.lex_state = 75, .external_lex_state = 2},
  [50] = {.lex_state = 75, .external_lex_state = 2},
  [51] = {.lex_state = 75, .external_lex_state = 2},
  [52] = {.lex_state = 75, .external_lex_state = 2},
  [53] = {.lex_state = 8, .external_lex_state = 2},
  [54] = {.lex_state = 75, .external_lex_state = 2},
  [55] = {.lex_state = 75, .external_lex_state = 2},
  [56] = {.lex_state = 8, .external_lex_state = 2},
  [57] = {.lex_state = 75, .external_lex_state = 2},
  [58] = {.lex_state = 75, .external_lex_state = 2},
  [59] = {.lex_state = 75, .external_lex_state = 2},
  [60] = {.lex_state = 75, .external_lex_state = 2},
  [61] = {.lex_state = 75, .external_lex_state = 2},
  [62] = {.lex_state = 75, .external_lex_state = 2},
  [63] = {.lex_state = 8, .external_lex_state = 2},
  [64] = {.lex_state = 75, .external_lex_state = 2},
  [65] = {.lex_state = 75, .external_lex_state = 2},
  [66] = {.lex_state = 8, .external_lex_state = 2},
  [67] = {.lex_state = 8, .external_lex_state = 2},
  [68] = {.lex_state = 8, .external_lex_state = 2},
  [69] = {.lex_state = 8, .external_lex_state = 2},
  [70] = {.lex_state = 75, .external_lex_state = 2},
  [71] = {.lex_state = 75, .external_lex_state = 2},
  [72] = {.lex_state = 3, .external_lex_state = 4},
  [73] = {.lex_state = 3, .external_lex_state = 4},
  [74] = {.lex_state = 3, .external_lex_state = 4},
  [75] = {.lex_state = 3, .external_lex_state = 3},
  [76] = {.lex_state = 8, .external_lex_state = 2},
  [77] = {.lex_state = 8, .external_lex_state = 2},
  [78] = {.lex_state = 3, .external_lex_state = 3},
  [79] = {.lex_state = 3, .external_lex_state = 3},
  [80] = {.lex_state = 3, .external_lex_state = 3},
  [81] = {.lex_state = 8, .external_lex_state = 2},
  [82] = {.lex_state = 3, .external_lex_state = 3},
  [83] = {.lex_state = 3, .external_lex_state = 3},
  [84] = {.lex_state = 3, .external_lex_state = 3},
  [85] = {.lex_state = 3, .external_lex_state = 3},
  [86] = {.lex_state = 8, .external_lex_state = 2},
  [87] = {.lex_state = 3, .external_lex_state = 3},
  [88] = {.lex_state = 3, .external_lex_state = 3},
  [89] = {.lex_state = 8, .external_lex_state = 2},
  [90] = {.lex_state = 8, .external_lex_state = 2},
  [91] = {.lex_state = 8, .external_lex_state = 2},
  [92] = {.lex_state = 8, .external_lex_state = 2},
  [93] = {.lex_state = 3, .external_lex_state = 3},
  [94] = {.lex_state = 3, .external_lex_state = 3},
  [95] = {.lex_state = 3, .external_lex_state = 3},
  [96] = {.lex_state = 3, .external_lex_state = 3},
  [97] = {.lex_state = 3, .external_lex_state = 4},
  [98] = {.lex_state = 3, .external_lex_state = 3},
  [99] = {.lex_state = 3, .external_lex_state = 4},
  [100] = {.lex_state = 3, .external_lex_state = 4},
  [101] = {.lex_state = 3, .external_lex_state = 3},
  [102] = {.lex_state = 3, .external_lex_state = 4},
  [103] = {.lex_state = 3, .external_lex_state = 4},
  [104] = {.lex_state = 3, .external_lex_state = 4},
  [105] = {.lex_state = 3, .external_lex_state = 4},
  [106] = {.lex_state = 3, .external_lex_state = 4},
  [107] = {.lex_state = 3, .external_lex_state = 3},
  [108] = {.lex_state = 3, .external_lex_state = 3},
  [109] = {.lex_state = 3, .external_lex_state = 3},
  [110] = {.lex_state = 3, .external_lex_state = 3},
  [111] = {.lex_state = 3, .external_lex_state = 3},
  [112] = {.lex_state = 3, .external_lex_state = 3},
  [113] = {.lex_state = 3, .external_lex_state = 3},
  [114] = {.lex_state = 3, .external_lex_state = 3},
  [115] = {.lex_state = 3, .external_lex_state = 3},
  [116] = {.lex_state = 3, .external_lex_state = 4},
  [117] = {.lex_state = 3, .external_lex_state = 3},
  [118] = {.lex_state = 3, .external_lex_state = 4},
  [119] = {.lex_state = 3, .external_lex_state = 3},
  [120] = {.lex_state = 3, .external_lex_state = 4},
  [121] = {.lex_state = 3, .external_lex_state = 3},
  [122] = {.lex_state = 3, .external_lex_state = 3},
  [123] = {.lex_state = 3, .external_lex_state = 3},
  [124] = {.lex_state = 3, .external_lex_state = 3},
  [125] = {.lex_state = 3, .external_lex_state = 3},
  [126] = {.lex_state = 3, .external_lex_state = 3},
  [127] = {.lex_state = 3, .external_lex_state = 3},
  [128] = {.lex_state = 3, .external_lex_state = 3},
  [129] = {.lex_state = 3, .external_lex_state = 3},
  [130] = {.lex_state = 3, .external_lex_state = 3},
  [131] = {.lex_state = 3, .external_lex_state = 3},
  [132] = {.lex_state = 3, .external_lex_state = 3},
  [133] = {.lex_state = 3, .external_lex_state = 3},
  [134] = {.lex_state = 3, .external_lex_state = 3},
  [135] = {.lex_state = 3, .external_lex_state = 3},
  [136] = {.lex_state = 3, .external_lex_state = 3},
  [137] = {.lex_state = 3, .external_lex_state = 3},
  [138] = {.lex_state = 3, .external_lex_state = 3},
  [139] = {.lex_state = 3, .external_lex_state = 3},
  [140] = {.lex_state = 3, .external_lex_state = 3},
  [141] = {.lex_state = 3, .external_lex_state = 3},
  [142] = {.lex_state = 3, .external_lex_state = 3},
  [143] = {.lex_state = 8, .external_lex_state = 2},
  [144] = {.lex_state = 3, .external_lex_state = 3},
  [145] = {.lex_state = 3, .external_lex_state = 3},
  [146] = {.lex_state = 3, .external_lex_state = 3},
  [147] = {.lex_state = 3, .external_lex_state = 3},
  [148] = {.lex_state = 3, .external_lex_state = 3},
  [149] = {.lex_state = 3, .external_lex_state = 3},
  [150] = {.lex_state = 8, .external_lex_state = 2},
  [151] = {.lex_state = 8, .external_lex_state = 2},
  [152] = {.lex_state = 8, .external_lex_state = 2},
  [153] = {.lex_state = 8, .external_lex_state = 2},
  [154] = {.lex_state = 8, .external_lex_state = 2},
  [155] = {.lex_state = 8, .external_lex_state = 2},
  [156] = {.lex_state = 8, .external_lex_state = 2},
  [157] = {.lex_state = 8, .external_lex_state = 2},
  [158] = {.lex_state = 8, .external_lex_state = 2},
  [159] = {.lex_state = 8, .external_lex_state = 2},
  [160] = {.lex_state = 8, .external_lex_state = 2},
  [161] = {.lex_state = 8, .external_lex_state = 2},
  [162] = {.lex_state = 8, .external_lex_state = 2},
  [163] = {.lex_state = 74, .external_lex_state = 3},
  [164] = {.lex_state = 74, .external_lex_state = 4},
  [165] = {.lex_state = 74, .external_lex_state = 4},
  [166] = {.lex_state = 74, .external_lex_state = 3},
  [167] = {.lex_state = 74, .external_lex_state = 3},
  [168] = {.lex_state = 74, .external_lex_state = 4},
  [169] = {.lex_state = 74, .external_lex_state = 3},
  [170] = {.lex_state = 74, .external_lex_state = 3},
  [171] = {.lex_state = 74, .external_lex_state = 3},
  [172] = {.lex_state = 74, .external_lex_state = 3},
  [173] = {.lex_state = 2, .external_lex_state = 3},
  [174] = {.lex_state = 2, .external_lex_state = 4},
  [175] = {.lex_state = 2, .external_lex_state = 4},
  [176] = {.lex_state = 2, .external_lex_state = 3},
  [177] = {.lex_state = 2, .external_lex_state = 3},
  [178] = {.lex_state = 2, .external_lex_state = 3},
  [179] = {.lex_state = 75, .external_lex_state = 2},
  [180] = {.lex_state = 75, .external_lex_state = 2},
  [181] = {.lex_state = 75, .external_lex_state = 2},
  [182] = {.lex_state = 2, .external_lex_state = 3},
  [183] = {.lex_state = 2, .external_lex_state = 4},
  [184] = {.lex_state = 75, .external_lex_state = 2},
  [185] = {.lex_state = 2, .external_lex_state = 3},
  [186] = {.lex_state = 75, .external_lex_state = 2},
  [187] = {.lex_state = 2, .external_lex_state = 3},
  [188] = {.lex_state = 75, .external_lex_state = 2},
  [189] = {.lex_state = 2, .external_lex_state = 3},
  [190] = {.lex_state = 2, .external_lex_state = 3},
  [191] = {.lex_state = 2, .external_lex_state = 3},
  [192] = {.lex_state = 2, .external_lex_state = 3},
  [193] = {.lex_state = 2, .external_lex_state = 3},
  [194] = {.lex_state = 75, .external_lex_state = 2},
  [195] = {.lex_state = 75, .external_lex_state = 2},
  [196] = {.lex_state = 75, .external_lex_state = 2},
  [197] = {.lex_state = 75, .external_lex_state = 2},
  [198] = {.lex_state = 75, .external_lex_state = 2},
  [199] = {.lex_state = 75, .external_lex_state = 2},
  [200] = {.lex_state = 74, .external_lex_state = 4},
  [201] = {.lex_state = 74, .external_lex_state = 4},
  [202] = {.lex_state = 75, .external_lex_state = 2},
  [203] = {.lex_state = 74, .external_lex_state = 4},
  [204] = {.lex_state = 75, .external_lex_state = 2},
  [205] = {.lex_state = 75, .external_lex_state = 2},
  [206] = {.lex_state = 74, .external_lex_state = 4},
  [207] = {.lex_state = 75, .external_lex_state = 2},
  [208] = {.lex_state = 75, .external_lex_state = 2},
  [209] = {.lex_state = 74, .external_lex_state = 4},
  [210] = {.lex_state = 74, .external_lex_state = 4},
  [211] = {.lex_state = 74, .external_lex_state = 4},
  [212] = {.lex_state = 74, .external_lex_state = 4},
  [213] = {.lex_state = 74, .external_lex_state = 4},
  [214] = {.lex_state = 74, .external_lex_state = 4},
  [215] = {.lex_state = 75, .external_lex_state = 2},
  [216] = {.lex_state = 75, .external_lex_state = 2},
  [217] = {.lex_state = 74, .external_lex_state = 4},
  [218] = {.lex_state = 75, .external_lex_state = 2},
  [219] = {.lex_state = 74, .external_lex_state = 4},
  [220] = {.lex_state = 74, .external_lex_state = 4},
  [221] = {.lex_state = 75, .external_lex_state = 2},
  [222] = {.lex_state = 74, .external_lex_state = 4},
  [223] = {.lex_state = 74, .external_lex_state = 4},
  [224] = {.lex_state = 74, .external_lex_state = 4},
  [225] = {.lex_state = 74, .external_lex_state = 4},
  [226] = {.lex_state = 74, .external_lex_state = 4},
  [227] = {.lex_state = 74, .external_lex_state = 4},
  [228] = {.lex_state = 74, .external_lex_state = 4},
  [229] = {.lex_state = 75, .external_lex_state = 2},
  [230] = {.lex_state = 74, .external_lex_state = 4},
  [231] = {.lex_state = 74, .external_lex_state = 4},
  [232] = {.lex_state = 74, .external_lex_state = 4},
  [233] = {.lex_state = 74, .external_lex_state = 4},
  [234] = {.lex_state = 75, .external_lex_state = 2},
  [235] = {.lex_state = 74, .external_lex_state = 4},
  [236] = {.lex_state = 74, .external_lex_state = 4},
  [237] = {.lex_state = 75, .external_lex_state = 2},
  [238] = {.lex_state = 74, .external_lex_state = 4},
  [239] = {.lex_state = 74, .external_lex_state = 4},
  [240] = {.lex_state = 74, .external_lex_state = 4},
  [241] = {.lex_state = 75, .external_lex_state = 2},
  [242] = {.lex_state = 75, .external_lex_state = 5},
  [243] = {.lex_state = 75, .external_lex_state = 2},
  [244] = {.lex_state = 75, .external_lex_state = 2},
  [245] = {.lex_state = 75, .external_lex_state = 2},
  [246] = {.lex_state = 75, .external_lex_state = 2},
  [247] = {.lex_state = 75, .external_lex_state = 2},
  [248] = {.lex_state = 75, .external_lex_state = 2},
  [249] = {.lex_state = 75, .external_lex_state = 2},
  [250] = {.lex_state = 75, .external_lex_state = 2},
  [251] = {.lex_state = 75, .external_lex_state = 2},
  [252] = {.lex_state = 75, .external_lex_state = 2},
  [253] = {.lex_state = 75, .external_lex_state = 2},
  [254] = {.lex_state = 75, .external_lex_state = 2},
  [255] = {.lex_state = 75, .external_lex_state = 2},
  [256] = {.lex_state = 3, .external_lex_state = 3},
  [257] = {.lex_state = 3, .external_lex_state = 3},
  [258] = {.lex_state = 3, .external_lex_state = 3},
  [259] = {.lex_state = 3, .external_lex_state = 3},
  [260] = {.lex_state = 75, .external_lex_state = 2},
  [261] = {.lex_state = 75, .external_lex_state = 2},
  [262] = {.lex_state = 75, .external_lex_state = 2},
  [263] = {.lex_state = 75, .external_lex_state = 2},
  [264] = {.lex_state = 75, .external_lex_state = 2},
  [265] = {.lex_state = 75, .external_lex_state = 2},
  [266] = {.lex_state = 75, .external_lex_state = 2},
  [267] = {.lex_state = 75, .external_lex_state = 2},
  [268] = {.lex_state = 75, .external_lex_state = 2},
  [269] = {.lex_state = 75, .external_lex_state = 2},
  [270] = {.lex_state = 75, .external_lex_state = 2},
  [271] = {.lex_state = 75, .external_lex_state = 2},
  [272] = {.lex_state = 75, .external_lex_state = 2},
  [273] = {.lex_state = 75, .external_lex_state = 2},
  [274] = {.lex_state = 75, .external_lex_state = 2},
  [275] = {.lex_state = 75, .external_lex_state = 2},
  [276] = {.lex_state = 75, .external_lex_state = 2},
  [277] = {.lex_state = 75, .external_lex_state = 2},
  [278] = {.lex_state = 75, .external_lex_state = 2},
  [279] = {.lex_state = 75, .external_lex_state = 2},
  [280] = {.lex_state = 75, .external_lex_state = 2},
  [281] = {.lex_state = 75, .external_lex_state = 2},
  [282] = {.lex_state = 75, .external_lex_state = 2},
  [283] = {.lex_state = 75, .external_lex_state = 2},
  [284] = {.lex_state = 75, .external_lex_state = 2},
  [285] = {.lex_state = 75, .external_lex_state = 2},
  [286] = {.lex_state = 75, .external_lex_state = 2},
  [287] = {.lex_state = 75, .external_lex_state = 2},
  [288] = {.lex_state = 75, .external_lex_state = 2},
  [289] = {.lex_state = 75, .external_lex_state = 2},
  [290] = {.lex_state = 75, .external_lex_state = 2},
  [291] = {.lex_state = 75, .external_lex_state = 2},
  [292] = {.lex_state = 75, .external_lex_state = 2},
  [293] = {.lex_state = 75, .external_lex_state = 2},
  [294] = {.lex_state = 75, .external_lex_state = 2},
  [295] = {.lex_state = 75, .external_lex_state = 2},
  [296] = {.lex_state = 75, .external_lex_state = 2},
  [297] = {.lex_state = 75, .external_lex_state = 5},
  [298] = {.lex_state = 75, .external_lex_state = 2},
  [299] = {.lex_state = 75, .external_lex_state = 2},
  [300] = {.lex_state = 75, .external_lex_state = 2},
  [301] = {.lex_state = 75, .external_lex_state = 2},
  [302] = {.lex_state = 75, .external_lex_state = 2},
  [303] = {.lex_state = 75, .external_lex_state = 2},
  [304] = {.lex_state = 75, .external_lex_state = 2},
  [305] = {.lex_state = 75, .external_lex_state = 2},
  [306] = {.lex_state = 75, .external_lex_state = 2},
  [307] = {.lex_state = 75, .external_lex_state = 2},
  [308] = {.lex_state = 75, .external_lex_state = 2},
  [309] = {.lex_state = 75, .external_lex_state = 2},
  [310] = {.lex_state = 75, .external_lex_state = 2},
  [311] = {.lex_state = 75, .external_lex_state = 2},
  [312] = {.lex_state = 75, .external_lex_state = 2},
  [313] = {.lex_state = 75, .external_lex_state = 2},
  [314] = {.lex_state = 75, .external_lex_state = 2},
  [315] = {.lex_state = 75, .external_lex_state = 2},
  [316] = {.lex_state = 75, .external_lex_state = 2},
  [317] = {.lex_state = 75, .external_lex_state = 2},
  [318] = {.lex_state = 75, .external_lex_state = 2},
  [319] = {.lex_state = 75, .external_lex_state = 2},
  [320] = {.lex_state = 75, .external_lex_state = 2},
  [321] = {.lex_state = 75, .external_lex_state = 2},
  [322] = {.lex_state = 75, .external_lex_state = 2},
  [323] = {.lex_state = 75, .external_lex_state = 2},
  [324] = {.lex_state = 75, .external_lex_state = 2},
  [325] = {.lex_state = 75, .external_lex_state = 2},
  [326] = {.lex_state = 75, .external_lex_state = 2},
  [327] = {.lex_state = 75, .external_lex_state = 2},
  [328] = {.lex_state = 75, .external_lex_state = 2},
  [329] = {.lex_state = 75, .external_lex_state = 2},
  [330] = {.lex_state = 75, .external_lex_state = 2},
  [331] = {.lex_state = 75, .external_lex_state = 2},
  [332] = {.lex_state = 75, .external_lex_state = 2},
  [333] = {.lex_state = 75, .external_lex_state = 2},
  [334] = {.lex_state = 75, .external_lex_state = 2},
  [335] = {.lex_state = 75, .external_lex_state = 2},
  [336] = {.lex_state = 75, .external_lex_state = 2},
  [337] = {.lex_state = 75, .external_lex_state = 2},
  [338] = {.lex_state = 75, .external_lex_state = 2},
  [339] = {.lex_state = 75, .external_lex_state = 2},
  [340] = {.lex_state = 75, .external_lex_state = 2},
  [341] = {.lex_state = 75, .external_lex_state = 2},
  [342] = {.lex_state = 75, .external_lex_state = 2},
  [343] = {.lex_state = 75, .external_lex_state = 2},
  [344] = {.lex_state = 75, .external_lex_state = 2},
  [345] = {.lex_state = 75, .external_lex_state = 2},
  [346] = {.lex_state = 75, .external_lex_state = 2},
  [347] = {.lex_state = 75, .external_lex_state = 2},
  [348] = {.lex_state = 75, .external_lex_state = 2},
  [349] = {.lex_state = 75, .external_lex_state = 2},
  [350] = {.lex_state = 75, .external_lex_state = 2},
  [351] = {.lex_state = 75, .external_lex_state = 2},
  [352] = {.lex_state = 75, .external_lex_state = 2},
  [353] = {.lex_state = 75, .external_lex_state = 2},
  [354] = {.lex_state = 75, .external_lex_state = 2},
  [355] = {.lex_state = 75, .external_lex_state = 2},
  [356] = {.lex_state = 75, .external_lex_state = 2},
  [357] = {.lex_state = 75, .external_lex_state = 2},
  [358] = {.lex_state = 75, .external_lex_state = 2},
  [359] = {.lex_state = 75, .external_lex_state = 2},
  [360] = {.lex_state = 75, .external_lex_state = 2},
  [361] = {.lex_state = 75, .external_lex_state = 2},
  [362] = {.lex_state = 75, .external_lex_state = 2},
  [363] = {.lex_state = 75, .external_lex_state = 2},
  [364] = {.lex_state = 75, .external_lex_state = 2},
  [365] = {.lex_state = 75, .external_lex_state = 2},
  [366] = {.lex_state = 75, .external_lex_state = 2},
  [367] = {.lex_state = 75, .external_lex_state = 2},
  [368] = {.lex_state = 75, .external_lex_state = 2},
  [369] = {.lex_state = 75, .external_lex_state = 2},
  [370] = {.lex_state = 75, .external_lex_state = 2},
  [371] = {.lex_state = 75, .external_lex_state = 2},
  [372] = {.lex_state = 75, .external_lex_state = 2},
  [373] = {.lex_state = 75, .external_lex_state = 2},
  [374] = {.lex_state = 75, .external_lex_state = 2},
  [375] = {.lex_state = 75, .external_lex_state = 2},
  [376] = {.lex_state = 75, .external_lex_state = 2},
  [377] = {.lex_state = 75, .external_lex_state = 2},
  [378] = {.lex_state = 75, .external_lex_state = 2},
  [379] = {.lex_state = 75, .external_lex_state = 2},
  [380] = {.lex_state = 75, .external_lex_state = 2},
  [381] = {.lex_state = 75, .external_lex_state = 2},
  [382] = {.lex_state = 75, .external_lex_state = 2},
  [383] = {.lex_state = 75, .external_lex_state = 2},
  [384] = {.lex_state = 75, .external_lex_state = 2},
  [385] = {.lex_state = 75, .external_lex_state = 2},
  [386] = {.lex_state = 75, .external_lex_state = 2},
  [387] = {.lex_state = 75, .external_lex_state = 2},
  [388] = {.lex_state = 75, .external_lex_state = 2},
  [389] = {.lex_state = 75, .external_lex_state = 2},
  [390] = {.lex_state = 75, .external_lex_state = 2},
  [391] = {.lex_state = 75, .external_lex_state = 2},
  [392] = {.lex_state = 75, .external_lex_state = 2},
  [393] = {.lex_state = 75, .external_lex_state = 2},
  [394] = {.lex_state = 75, .external_lex_state = 2},
  [395] = {.lex_state = 75, .external_lex_state = 2},
  [396] = {.lex_state = 75, .external_lex_state = 2},
  [397] = {.lex_state = 75, .external_lex_state = 2},
  [398] = {.lex_state = 75, .external_lex_state = 2},
  [399] = {.lex_state = 75, .external_lex_state = 2},
  [400] = {.lex_state = 75, .external_lex_state = 2},
  [401] = {.lex_state = 75, .external_lex_state = 2},
  [402] = {.lex_state = 75, .external_lex_state = 2},
  [403] = {.lex_state = 75, .external_lex_state = 2},
  [404] = {.lex_state = 75, .external_lex_state = 2},
  [405] = {.lex_state = 75, .external_lex_state = 2},
  [406] = {.lex_state = 75, .external_lex_state = 2},
  [407] = {.lex_state = 75, .external_lex_state = 2},
  [408] = {.lex_state = 75, .external_lex_state = 2},
  [409] = {.lex_state = 75, .external_lex_state = 2},
  [410] = {.lex_state = 75, .external_lex_state = 2},
  [411] = {.lex_state = 75, .external_lex_state = 2},
  [412] = {.lex_state = 75, .external_lex_state = 2},
  [413] = {.lex_state = 75, .external_lex_state = 2},
  [414] = {.lex_state = 75, .external_lex_state = 2},
  [415] = {.lex_state = 75, .external_lex_state = 2},
  [416] = {.lex_state = 75, .external_lex_state = 2},
  [417] = {.lex_state = 75, .external_lex_state = 2},
  [418] = {.lex_state = 75, .external_lex_state = 2},
  [419] = {.lex_state = 75, .external_lex_state = 2},
  [420] = {.lex_state = 75, .external_lex_state = 2},
  [421] = {.lex_state = 75, .external_lex_state = 2},
  [422] = {.lex_state = 75, .external_lex_state = 2},
  [423] = {.lex_state = 75, .external_lex_state = 2},
  [424] = {.lex_state = 75, .external_lex_state = 2},
  [425] = {.lex_state = 75, .external_lex_state = 2},
  [426] = {.lex_state = 75, .external_lex_state = 2},
  [427] = {.lex_state = 3, .external_lex_state = 4},
  [428] = {.lex_state = 75, .external_lex_state = 2},
  [429] = {.lex_state = 75, .external_lex_state = 2},
  [430] = {.lex_state = 75, .external_lex_state = 2},
  [431] = {.lex_state = 75, .external_lex_state = 2},
  [432] = {.lex_state = 75, .external_lex_state = 2},
  [433] = {.lex_state = 75, .external_lex_state = 2},
  [434] = {.lex_state = 75, .external_lex_state = 2},
  [435] = {.lex_state = 75, .external_lex_state = 2},
  [436] = {.lex_state = 75, .external_lex_state = 2},
  [437] = {.lex_state = 75, .external_lex_state = 2},
  [438] = {.lex_state = 75, .external_lex_state = 2},
  [439] = {.lex_state = 75, .external_lex_state = 2},
  [440] = {.lex_state = 3, .external_lex_state = 4},
  [441] = {.lex_state = 75, .external_lex_state = 2},
  [442] = {.lex_state = 75, .external_lex_state = 2},
  [443] = {.lex_state = 75, .external_lex_state = 2},
  [444] = {.lex_state = 75, .external_lex_state = 2},
  [445] = {.lex_state = 75, .external_lex_state = 2},
  [446] = {.lex_state = 75, .external_lex_state = 2},
  [447] = {.lex_state = 75, .external_lex_state = 2},
  [448] = {.lex_state = 75, .external_lex_state = 2},
  [449] = {.lex_state = 75, .external_lex_state = 2},
  [450] = {.lex_state = 75, .external_lex_state = 2},
  [451] = {.lex_state = 75, .external_lex_state = 2},
  [452] = {.lex_state = 75, .external_lex_state = 2},
  [453] = {.lex_state = 75, .external_lex_state = 2},
  [454] = {.lex_state = 75, .external_lex_state = 2},
  [455] = {.lex_state = 75, .external_lex_state = 2},
  [456] = {.lex_state = 75, .external_lex_state = 2},
  [457] = {.lex_state = 75, .external_lex_state = 2},
  [458] = {.lex_state = 75, .external_lex_state = 2},
  [459] = {.lex_state = 75, .external_lex_state = 2},
  [460] = {.lex_state = 75, .external_lex_state = 2},
  [461] = {.lex_state = 75, .external_lex_state = 2},
  [462] = {.lex_state = 75, .external_lex_state = 2},
  [463] = {.lex_state = 75, .external_lex_state = 2},
  [464] = {.lex_state = 75, .external_lex_state = 2},
  [465] = {.lex_state = 75, .external_lex_state = 2},
  [466] = {.lex_state = 75, .external_lex_state = 2},
  [467] = {.lex_state = 75, .external_lex_state = 2},
  [468] = {.lex_state = 75, .external_lex_state = 2},
  [469] = {.lex_state = 75, .external_lex_state = 2},
  [470] = {.lex_state = 75, .external_lex_state = 2},
  [471] = {.lex_state = 75, .external_lex_state = 2},
  [472] = {.lex_state = 75, .external_lex_state = 2},
  [473] = {.lex_state = 75, .external_lex_state = 2},
  [474] = {.lex_state = 75, .external_lex_state = 2},
  [475] = {.lex_state = 75, .external_lex_state = 2},
  [476] = {.lex_state = 75, .external_lex_state = 2},
  [477] = {.lex_state = 75, .external_lex_state = 2},
  [478] = {.lex_state = 75, .external_lex_state = 2},
  [479] = {.lex_state = 75, .external_lex_state = 2},
  [480] = {.lex_state = 75, .external_lex_state = 2},
  [481] = {.lex_state = 75, .external_lex_state = 2},
  [482] = {.lex_state = 75, .external_lex_state = 2},
  [483] = {.lex_state = 75, .external_lex_state = 2},
  [484] = {.lex_state = 75, .external_lex_state = 2},
  [485] = {.lex_state = 75, .external_lex_state = 2},
  [486] = {.lex_state = 75, .external_lex_state = 2},
  [487] = {.lex_state = 75, .external_lex_state = 2},
  [488] = {.lex_state = 75, .external_lex_state = 2},
  [489] = {.lex_state = 75, .external_lex_state = 2},
  [490] = {.lex_state = 75, .external_lex_state = 2},
  [491] = {.lex_state = 75, .external_lex_state = 2},
  [492] = {.lex_state = 75, .external_lex_state = 2},
  [493] = {.lex_state = 75, .external_lex_state = 2},
  [494] = {.lex_state = 75, .external_lex_state = 2},
  [495] = {.lex_state = 75, .external_lex_state = 2},
  [496] = {.lex_state = 75, .external_lex_state = 2},
  [497] = {.lex_state = 75, .external_lex_state = 2},
  [498] = {.lex_state = 75, .external_lex_state = 2},
  [499] = {.lex_state = 75, .external_lex_state = 2},
  [500] = {.lex_state = 75, .external_lex_state = 2},
  [501] = {.lex_state = 75, .external_lex_state = 2},
  [502] = {.lex_state = 75, .external_lex_state = 2},
  [503] = {.lex_state = 75, .external_lex_state = 2},
  [504] = {.lex_state = 75, .external_lex_state = 2},
  [505] = {.lex_state = 75, .external_lex_state = 2},
  [506] = {.lex_state = 75, .external_lex_state = 2},
  [507] = {.lex_state = 75, .external_lex_state = 2},
  [508] = {.lex_state = 75, .external_lex_state = 2},
  [509] = {.lex_state = 75, .external_lex_state = 2},
  [510] = {.lex_state = 75, .external_lex_state = 2},
  [511] = {.lex_state = 75, .external_lex_state = 2},
  [512] = {.lex_state = 75, .external_lex_state = 2},
  [513] = {.lex_state = 75, .external_lex_state = 2},
  [514] = {.lex_state = 75, .external_lex_state = 2},
  [515] = {.lex_state = 75, .external_lex_state = 2},
  [516] = {.lex_state = 75, .external_lex_state = 2},
  [517] = {.lex_state = 75, .external_lex_state = 2},
  [518] = {.lex_state = 75, .external_lex_state = 2},
  [519] = {.lex_state = 75, .external_lex_state = 2},
  [520] = {.lex_state = 75, .external_lex_state = 2},
  [521] = {.lex_state = 75, .external_lex_state = 2},
  [522] = {.lex_state = 75, .external_lex_state = 2},
  [523] = {.lex_state = 75, .external_lex_state = 2},
  [524] = {.lex_state = 75, .external_lex_state = 2},
  [525] = {.lex_state = 75, .external_lex_state = 2},
  [526] = {.lex_state = 75, .external_lex_state = 2},
  [527] = {.lex_state = 75, .external_lex_state = 2},
  [528] = {.lex_state = 75, .external_lex_state = 2},
  [529] = {.lex_state = 75, .external_lex_state = 2},
  [530] = {.lex_state = 75, .external_lex_state = 2},
  [531] = {.lex_state = 75, .external_lex_state = 2},
  [532] = {.lex_state = 75, .external_lex_state = 2},
  [533] = {.lex_state = 75, .external_lex_state = 2},
  [534] = {.lex_state = 75, .external_lex_state = 2},
  [535] = {.lex_state = 75, .external_lex_state = 2},
  [536] = {.lex_state = 75, .external_lex_state = 2},
  [537] = {.lex_state = 75, .external_lex_state = 2},
  [538] = {.lex_state = 75, .external_lex_state = 2},
  [539] = {.lex_state = 75, .external_lex_state = 2},
  [540] = {.lex_state = 75, .external_lex_state = 2},
  [541] = {.lex_state = 75, .external_lex_state = 2},
  [542] = {.lex_state = 75, .external_lex_state = 2},
  [543] = {.lex_state = 75, .external_lex_state = 2},
  [544] = {.lex_state = 75, .external_lex_state = 2},
  [545] = {.lex_state = 75, .external_lex_state = 2},
  [546] = {.lex_state = 75, .external_lex_state = 2},
  [547] = {.lex_state = 75, .external_lex_state = 2},
  [548] = {.lex_state = 75, .external_lex_state = 2},
  [549] = {.lex_state = 75, .external_lex_state = 2},
  [550] = {.lex_state = 75, .external_lex_state = 2},
  [551] = {.lex_state = 75, .external_lex_state = 2},
  [552] = {.lex_state = 75, .external_lex_state = 2},
  [553] = {.lex_state = 75, .external_lex_state = 2},
  [554] = {.lex_state = 75, .external_lex_state = 2},
  [555] = {.lex_state = 75, .external_lex_state = 2},
  [556] = {.lex_state = 75, .external_lex_state = 2},
  [557] = {.lex_state = 75, .external_lex_state = 2},
  [558] = {.lex_state = 75, .external_lex_state = 2},
  [559] = {.lex_state = 75, .external_lex_state = 2},
  [560] = {.lex_state = 75, .external_lex_state = 2},
  [561] = {.lex_state = 75, .external_lex_state = 2},
  [562] = {.lex_state = 75, .external_lex_state = 2},
  [563] = {.lex_state = 75, .external_lex_state = 2},
  [564] = {.lex_state = 75, .external_lex_state = 2},
  [565] = {.lex_state = 75, .external_lex_state = 2},
  [566] = {.lex_state = 75, .external_lex_state = 2},
  [567] = {.lex_state = 75, .external_lex_state = 2},
  [568] = {.lex_state = 75, .external_lex_state = 2},
  [569] = {.lex_state = 75, .external_lex_state = 2},
  [570] = {.lex_state = 75, .external_lex_state = 2},
  [571] = {.lex_state = 75, .external_lex_state = 2},
  [572] = {.lex_state = 75, .external_lex_state = 2},
  [573] = {.lex_state = 75, .external_lex_state = 2},
  [574] = {.lex_state = 75, .external_lex_state = 2},
  [575] = {.lex_state = 75, .external_lex_state = 2},
  [576] = {.lex_state = 75, .external_lex_state = 2},
  [577] = {.lex_state = 75, .external_lex_state = 2},
  [578] = {.lex_state = 75, .external_lex_state = 2},
  [579] = {.lex_state = 75, .external_lex_state = 2},
  [580] = {.lex_state = 75, .external_lex_state = 2},
  [581] = {.lex_state = 75, .external_lex_state = 2},
  [582] = {.lex_state = 75, .external_lex_state = 2},
  [583] = {.lex_state = 75, .external_lex_state = 2},
  [584] = {.lex_state = 75, .external_lex_state = 2},
  [585] = {.lex_state = 75, .external_lex_state = 2},
  [586] = {.lex_state = 75, .external_lex_state = 2},
  [587] = {.lex_state = 75, .external_lex_state = 2},
  [588] = {.lex_state = 75, .external_lex_state = 2},
  [589] = {.lex_state = 75, .external_lex_state = 2},
  [590] = {.lex_state = 3, .external_lex_state = 4},
  [591] = {.lex_state = 75, .external_lex_state = 2},
  [592] = {.lex_state = 75, .external_lex_state = 2},
  [593] = {.lex_state = 75, .external_lex_state = 2},
  [594] = {.lex_state = 75, .external_lex_state = 2},
  [595] = {.lex_state = 75, .external_lex_state = 2},
  [596] = {.lex_state = 75, .external_lex_state = 2},
  [597] = {.lex_state = 75, .external_lex_state = 2},
  [598] = {.lex_state = 75, .external_lex_state = 2},
  [599] = {.lex_state = 75, .external_lex_state = 2},
  [600] = {.lex_state = 75, .external_lex_state = 2},
  [601] = {.lex_state = 75, .external_lex_state = 2},
  [602] = {.lex_state = 75, .external_lex_state = 2},
  [603] = {.lex_state = 75, .external_lex_state = 2},
  [604] = {.lex_state = 75, .external_lex_state = 2},
  [605] = {.lex_state = 75, .external_lex_state = 2},
  [606] = {.lex_state = 75, .external_lex_state = 2},
  [607] = {.lex_state = 75, .external_lex_state = 2},
  [608] = {.lex_state = 75, .external_lex_state = 2},
  [609] = {.lex_state = 75, .external_lex_state = 2},
  [610] = {.lex_state = 75, .external_lex_state = 2},
  [611] = {.lex_state = 75, .external_lex_state = 2},
  [612] = {.lex_state = 75, .external_lex_state = 2},
  [613] = {.lex_state = 75, .external_lex_state = 2},
  [614] = {.lex_state = 75, .external_lex_state = 2},
  [615] = {.lex_state = 75, .external_lex_state = 2},
  [616] = {.lex_state = 75, .external_lex_state = 2},
  [617] = {.lex_state = 75, .external_lex_state = 2},
  [618] = {.lex_state = 75, .external_lex_state = 2},
  [619] = {.lex_state = 75, .external_lex_state = 2},
  [620] = {.lex_state = 75, .external_lex_state = 2},
  [621] = {.lex_state = 75, .external_lex_state = 2},
  [622] = {.lex_state = 75, .external_lex_state = 2},
  [623] = {.lex_state = 75, .external_lex_state = 2},
  [624] = {.lex_state = 75, .external_lex_state = 2},
  [625] = {.lex_state = 75, .external_lex_state = 2},
  [626] = {.lex_state = 75, .external_lex_state = 2},
  [627] = {.lex_state = 75, .external_lex_state = 2},
  [628] = {.lex_state = 75, .external_lex_state = 2},
  [629] = {.lex_state = 75, .external_lex_state = 2},
  [630] = {.lex_state = 75, .external_lex_state = 2},
  [631] = {.lex_state = 75, .external_lex_state = 2},
  [632] = {.lex_state = 75, .external_lex_state = 2},
  [633] = {.lex_state = 75, .external_lex_state = 2},
  [634] = {.lex_state = 75, .external_lex_state = 2},
  [635] = {.lex_state = 75, .external_lex_state = 2},
  [636] = {.lex_state = 75, .external_lex_state = 2},
  [637] = {.lex_state = 75, .external_lex_state = 2},
  [638] = {.lex_state = 75, .external_lex_state = 2},
  [639] = {.lex_state = 75, .external_lex_state = 2},
  [640] = {.lex_state = 75, .external_lex_state = 2},
  [641] = {.lex_state = 75, .external_lex_state = 2},
  [642] = {.lex_state = 75, .external_lex_state = 2},
  [643] = {.lex_state = 75, .external_lex_state = 2},
  [644] = {.lex_state = 75, .external_lex_state = 2},
  [645] = {.lex_state = 75, .external_lex_state = 2},
  [646] = {.lex_state = 75, .external_lex_state = 2},
  [647] = {.lex_state = 75, .external_lex_state = 2},
  [648] = {.lex_state = 75, .external_lex_state = 2},
  [649] = {.lex_state = 75, .external_lex_state = 2},
  [650] = {.lex_state = 75, .external_lex_state = 2},
  [651] = {.lex_state = 75, .external_lex_state = 2},
  [652] = {.lex_state = 75, .external_lex_state = 2},
  [653] = {.lex_state = 75, .external_lex_state = 2},
  [654] = {.lex_state = 75, .external_lex_state = 2},
  [655] = {.lex_state = 75, .external_lex_state = 2},
  [656] = {.lex_state = 75, .external_lex_state = 2},
  [657] = {.lex_state = 75, .external_lex_state = 2},
  [658] = {.lex_state = 75, .external_lex_state = 2},
  [659] = {.lex_state = 75, .external_lex_state = 2},
  [660] = {.lex_state = 75, .external_lex_state = 2},
  [661] = {.lex_state = 75, .external_lex_state = 2},
  [662] = {.lex_state = 75, .external_lex_state = 2},
  [663] = {.lex_state = 75, .external_lex_state = 2},
  [664] = {.lex_state = 75, .external_lex_state = 2},
  [665] = {.lex_state = 75, .external_lex_state = 2},
  [666] = {.lex_state = 75, .external_lex_state = 2},
  [667] = {.lex_state = 75, .external_lex_state = 2},
  [668] = {.lex_state = 75, .external_lex_state = 2},
  [669] = {.lex_state = 75, .external_lex_state = 2},
  [670] = {.lex_state = 75, .external_lex_state = 2},
  [671] = {.lex_state = 75, .external_lex_state = 2},
  [672] = {.lex_state = 75, .external_lex_state = 2},
  [673] = {.lex_state = 75, .external_lex_state = 2},
  [674] = {.lex_state = 75, .external_lex_state = 2},
  [675] = {.lex_state = 75, .external_lex_state = 2},
  [676] = {.lex_state = 75, .external_lex_state = 2},
  [677] = {.lex_state = 75, .external_lex_state = 2},
  [678] = {.lex_state = 75, .external_lex_state = 2},
  [679] = {.lex_state = 75, .external_lex_state = 2},
  [680] = {.lex_state = 75, .external_lex_state = 2},
  [681] = {.lex_state = 75, .external_lex_state = 2},
  [682] = {.lex_state = 75, .external_lex_state = 2},
  [683] = {.lex_state = 75, .external_lex_state = 2},
  [684] = {.lex_state = 75, .external_lex_state = 2},
  [685] = {.lex_state = 75, .external_lex_state = 2},
  [686] = {.lex_state = 75, .external_lex_state = 2},
  [687] = {.lex_state = 75, .external_lex_state = 2},
  [688] = {.lex_state = 75, .external_lex_state = 2},
  [689] = {.lex_state = 75, .external_lex_state = 2},
  [690] = {.lex_state = 2, .external_lex_state = 4},
  [691] = {.lex_state = 2, .external_lex_state = 4},
  [692] = {.lex_state = 2, .external_lex_state = 4},
  [693] = {.lex_state = 2, .external_lex_state = 4},
  [694] = {.lex_state = 2, .external_lex_state = 4},
  [695] = {.lex_state = 2, .external_lex_state = 4},
  [696] = {.lex_state = 3, .external_lex_state = 4},
  [697] = {.lex_state = 3, .external_lex_state = 4},
  [698] = {.lex_state = 2, .external_lex_state = 4},
  [699] = {.lex_state = 2, .external_lex_state = 4},
  [700] = {.lex_state = 2, .external_lex_state = 4},
  [701] = {.lex_state = 2, .external_lex_state = 4},
  [702] = {.lex_state = 2, .external_lex_state = 4},
  [703] = {.lex_state = 2, .external_lex_state = 4},
  [704] = {.lex_state = 2, .external_lex_state = 4},
  [705] = {.lex_state = 2, .external_lex_state = 4},
  [706] = {.lex_state = 2, .external_lex_state = 4},
  [707] = {.lex_state = 2, .external_lex_state = 4},
  [708] = {.lex_state = 75, .external_lex_state = 2},
  [709] = {.lex_state = 75, .external_lex_state = 2},
  [710] = {.lex_state = 2, .external_lex_state = 4},
  [711] = {.lex_state = 75, .external_lex_state = 2},
  [712] = {.lex_state = 75, .external_lex_state = 2},
  [713] = {.lex_state = 75, .external_lex_state = 2},
  [714] = {.lex_state = 75, .external_lex_state = 2},
  [715] = {.lex_state = 75, .external_lex_state = 2},
  [716] = {.lex_state = 2, .external_lex_state = 4},
  [717] = {.lex_state = 2, .external_lex_state = 4},
  [718] = {.lex_state = 2, .external_lex_state = 4},
  [719] = {.lex_state = 2, .external_lex_state = 4},
  [720] = {.lex_state = 2, .external_lex_state = 4},
  [721] = {.lex_state = 2, .external_lex_state = 4},
  [722] = {.lex_state = 2, .external_lex_state = 4},
  [723] = {.lex_state = 2, .external_lex_state = 4},
  [724] = {.lex_state = 2, .external_lex_state = 3},
  [725] = {.lex_state = 2, .external_lex_state = 3},
  [726] = {.lex_state = 2, .external_lex_state = 3},
  [727] = {.lex_state = 2, .external_lex_state = 3},
  [728] = {.lex_state = 2, .external_lex_state = 4},
  [729] = {.lex_state = 2, .external_lex_state = 4},
  [730] = {.lex_state = 2, .external_lex_state = 4},
  [731] = {.lex_state = 2, .external_lex_state = 3},
  [732] = {.lex_state = 2, .external_lex_state = 4},
  [733] = {.lex_state = 2, .external_lex_state = 3},
  [734] = {.lex_state = 2, .external_lex_state = 4},
  [735] = {.lex_state = 2, .external_lex_state = 4},
  [736] = {.lex_state = 2, .external_lex_state = 3},
  [737] = {.lex_state = 3, .external_lex_state = 3},
  [738] = {.lex_state = 2, .external_lex_state = 3},
  [739] = {.lex_state = 2, .external_lex_state = 3},
  [740] = {.lex_state = 3, .external_lex_state = 3},
  [741] = {.lex_state = 2, .external_lex_state = 3},
  [742] = {.lex_state = 2, .external_lex_state = 3},
  [743] = {.lex_state = 2, .external_lex_state = 4},
  [744] = {.lex_state = 2, .external_lex_state = 3},
  [745] = {.lex_state = 75, .external_lex_state = 2},
  [746] = {.lex_state = 2, .external_lex_state = 3},
  [747] = {.lex_state = 75, .external_lex_state = 5},
  [748] = {.lex_state = 2, .external_lex_state = 4},
  [749] = {.lex_state = 2, .external_lex_state = 4},
  [750] = {.lex_state = 2, .external_lex_state = 4},
  [751] = {.lex_state = 2, .external_lex_state = 3},
  [752] = {.lex_state = 2, .external_lex_state = 4},
  [753] = {.lex_state = 75, .external_lex_state = 5},
  [754] = {.lex_state = 75, .external_lex_state = 5},
  [755] = {.lex_state = 75, .external_lex_state = 2},
  [756] = {.lex_state = 75, .external_lex_state = 5},
  [757] = {.lex_state = 75, .external_lex_state = 5},
  [758] = {.lex_state = 75, .external_lex_state = 5},
  [759] = {.lex_state = 75, .external_lex_state = 5},
  [760] = {.lex_state = 75, .external_lex_state = 5},
  [761] = {.lex_state = 2, .external_lex_state = 3},
  [762] = {.lex_state = 2, .external_lex_state = 3},
  [763] = {.lex_state = 2, .external_lex_state = 3},
  [764] = {.lex_state = 2, .external_lex_state = 3},
  [765] = {.lex_state = 2, .external_lex_state = 3},
  [766] = {.lex_state = 2, .external_lex_state = 3},
  [767] = {.lex_state = 2, .external_lex_state = 3},
  [768] = {.lex_state = 2, .external_lex_state = 3},
  [769] = {.lex_state = 75, .external_lex_state = 2},
  [770] = {.lex_state = 75, .external_lex_state = 2},
  [771] = {.lex_state = 2, .external_lex_state = 3},
  [772] = {.lex_state = 2, .external_lex_state = 3},
  [773] = {.lex_state = 2, .external_lex_state = 3},
  [774] = {.lex_state = 2, .external_lex_state = 3},
  [775] = {.lex_state = 2, .external_lex_state = 3},
  [776] = {.lex_state = 2, .external_lex_state = 3},
  [777] = {.lex_state = 2, .external_lex_state = 3},
  [778] = {.lex_state = 2, .external_lex_state = 3},
  [779] = {.lex_state = 2, .external_lex_state = 3},
  [780] = {.lex_state = 75, .external_lex_state = 2},
  [781] = {.lex_state = 2, .external_lex_state = 3},
  [782] = {.lex_state = 2, .external_lex_state = 3},
  [783] = {.lex_state = 75, .external_lex_state = 2},
  [784] = {.lex_state = 9, .external_lex_state = 2},
  [785] = {.lex_state = 75, .external_lex_state = 5},
  [786] = {.lex_state = 75, .external_lex_state = 5},
  [787] = {.lex_state = 75, .external_lex_state = 5},
  [788] = {.lex_state = 75, .external_lex_state = 5},
  [789] = {.lex_state = 75, .external_lex_state = 2},
  [790] = {.lex_state = 75, .external_lex_state = 2},
  [791] = {.lex_state = 75, .external_lex_state = 5},
  [792] = {.lex_state = 75, .external_lex_state = 5},
  [793] = {.lex_state = 9, .external_lex_state = 2},
  [794] = {.lex_state = 75, .external_lex_state = 5},
  [795] = {.lex_state = 9, .external_lex_state = 2},
  [796] = {.lex_state = 75, .external_lex_state = 5},
  [797] = {.lex_state = 75, .external_lex_state = 5},
  [798] = {.lex_state = 75, .external_lex_state = 2},
  [799] = {.lex_state = 75, .external_lex_state = 5},
  [800] = {.lex_state = 9, .external_lex_state = 2},
  [801] = {.lex_state = 75, .external_lex_state = 5},
  [802] = {.lex_state = 75, .external_lex_state = 2},
  [803] = {.lex_state = 75, .external_lex_state = 5},
  [804] = {.lex_state = 75, .external_lex_state = 5},
  [805] = {.lex_state = 9, .external_lex_state = 2},
  [806] = {.lex_state = 75, .external_lex_state = 5},
  [807] = {.lex_state = 75, .external_lex_state = 2},
  [808] = {.lex_state = 75, .external_lex_state = 2},
  [809] = {.lex_state = 75, .external_lex_state = 2},
  [810] = {.lex_state = 75, .external_lex_state = 2},
  [811] = {.lex_state = 75, .external_lex_state = 5},
  [812] = {.lex_state = 75, .external_lex_state = 2},
  [813] = {.lex_state = 75, .external_lex_state = 2},
  [814] = {.lex_state = 75, .external_lex_state = 2},
  [815] = {.lex_state = 75, .external_lex_state = 2},
  [816] = {.lex_state = 75, .external_lex_state = 2},
  [817] = {.lex_state = 75, .external_lex_state = 2},
  [818] = {.lex_state = 75, .external_lex_state = 2},
  [819] = {.lex_state = 75, .external_lex_state = 2},
  [820] = {.lex_state = 9, .external_lex_state = 2},
  [821] = {.lex_state = 9, .external_lex_state = 2},
  [822] = {.lex_state = 75, .external_lex_state = 2},
  [823] = {.lex_state = 75, .external_lex_state = 2},
  [824] = {.lex_state = 75, .external_lex_state = 2},
  [825] = {.lex_state = 75, .external_lex_state = 2},
  [826] = {.lex_state = 75, .external_lex_state = 2},
  [827] = {.lex_state = 75, .external_lex_state = 2},
  [828] = {.lex_state = 75, .external_lex_state = 2},
  [829] = {.lex_state = 75, .external_lex_state = 2},
  [830] = {.lex_state = 75, .external_lex_state = 2},
  [831] = {.lex_state = 75, .external_lex_state = 2},
  [832] = {.lex_state = 75, .external_lex_state = 2},
  [833] = {.lex_state = 75, .external_lex_state = 2},
  [834] = {.lex_state = 75, .external_lex_state = 2},
  [835] = {.lex_state = 75, .external_lex_state = 2},
  [836] = {.lex_state = 75, .external_lex_state = 2},
  [837] = {.lex_state = 75, .external_lex_state = 2},
  [838] = {.lex_state = 75, .external_lex_state = 2},
  [839] = {.lex_state = 75, .external_lex_state = 2},
  [840] = {.lex_state = 75, .external_lex_state = 2},
  [841] = {.lex_state = 75, .external_lex_state = 2},
  [842] = {.lex_state = 75, .external_lex_state = 2},
  [843] = {.lex_state = 75, .external_lex_state = 2},
  [844] = {.lex_state = 75, .external_lex_state = 2},
  [845] = {.lex_state = 75, .external_lex_state = 2},
  [846] = {.lex_state = 75, .external_lex_state = 2},
  [847] = {.lex_state = 75, .external_lex_state = 2},
  [848] = {.lex_state = 9, .external_lex_state = 2},
  [849] = {.lex_state = 75, .external_lex_state = 2},
  [850] = {.lex_state = 75, .external_lex_state = 2},
  [851] = {.lex_state = 75, .external_lex_state = 2},
  [852] = {.lex_state = 75, .external_lex_state = 2},
  [853] = {.lex_state = 75, .external_lex_state = 2},
  [854] = {.lex_state = 75, .external_lex_state = 2},
  [855] = {.lex_state = 75, .external_lex_state = 2},
  [856] = {.lex_state = 75, .external_lex_state = 2},
  [857] = {.lex_state = 75, .external_lex_state = 2},
  [858] = {.lex_state = 75, .external_lex_state = 2},
  [859] = {.lex_state = 75, .external_lex_state = 2},
  [860] = {.lex_state = 75, .external_lex_state = 2},
  [861] = {.lex_state = 75, .external_lex_state = 2},
  [862] = {.lex_state = 75, .external_lex_state = 2},
  [863] = {.lex_state = 75, .external_lex_state = 2},
  [864] = {.lex_state = 75, .external_lex_state = 2},
  [865] = {.lex_state = 75, .external_lex_state = 2},
  [866] = {.lex_state = 75, .external_lex_state = 2},
  [867] = {.lex_state = 75, .external_lex_state = 2},
  [868] = {.lex_state = 9, .external_lex_state = 2},
  [869] = {.lex_state = 75, .external_lex_state = 2},
  [870] = {.lex_state = 75, .external_lex_state = 2},
  [871] = {.lex_state = 75, .external_lex_state = 2},
  [872] = {.lex_state = 75, .external_lex_state = 2},
  [873] = {.lex_state = 75, .external_lex_state = 2},
  [874] = {.lex_state = 75, .external_lex_state = 2},
  [875] = {.lex_state = 75, .external_lex_state = 2},
  [876] = {.lex_state = 9, .external_lex_state = 2},
  [877] = {.lex_state = 75, .external_lex_state = 2},
  [878] = {.lex_state = 75, .external_lex_state = 2},
  [879] = {.lex_state = 75, .external_lex_state = 2},
  [880] = {.lex_state = 75, .external_lex_state = 2},
  [881] = {.lex_state = 75, .external_lex_state = 2},
  [882] = {.lex_state = 75, .external_lex_state = 2},
  [883] = {.lex_state = 75, .external_lex_state = 2},
  [884] = {.lex_state = 75, .external_lex_state = 2},
  [885] = {.lex_state = 75, .external_lex_state = 2},
  [886] = {.lex_state = 75, .external_lex_state = 2},
  [887] = {.lex_state = 75, .external_lex_state = 2},
  [888] = {.lex_state = 75, .external_lex_state = 2},
  [889] = {.lex_state = 9, .external_lex_state = 2},
  [890] = {.lex_state = 75, .external_lex_state = 2},
  [891] = {.lex_state = 75, .external_lex_state = 2},
  [892] = {.lex_state = 75, .external_lex_state = 2},
  [893] = {.lex_state = 75, .external_lex_state = 2},
  [894] = {.lex_state = 75, .external_lex_state = 2},
  [895] = {.lex_state = 75, .external_lex_state = 2},
  [896] = {.lex_state = 75, .external_lex_state = 2},
  [897] = {.lex_state = 75, .external_lex_state = 2},
  [898] = {.lex_state = 75, .external_lex_state = 2},
  [899] = {.lex_state = 75, .external_lex_state = 2},
  [900] = {.lex_state = 9, .external_lex_state = 2},
  [901] = {.lex_state = 75, .external_lex_state = 2},
  [902] = {.lex_state = 75, .external_lex_state = 2},
  [903] = {.lex_state = 75, .external_lex_state = 2},
  [904] = {.lex_state = 75, .external_lex_state = 2},
  [905] = {.lex_state = 75, .external_lex_state = 2},
  [906] = {.lex_state = 9, .external_lex_state = 2},
  [907] = {.lex_state = 75, .external_lex_state = 2},
  [908] = {.lex_state = 75, .external_lex_state = 2},
  [909] = {.lex_state = 75, .external_lex_state = 2},
  [910] = {.lex_state = 75, .external_lex_state = 2},
  [911] = {.lex_state = 75, .external_lex_state = 2},
  [912] = {.lex_state = 75, .external_lex_state = 2},
  [913] = {.lex_state = 75, .external_lex_state = 2},
  [914] = {.lex_state = 75, .external_lex_state = 2},
  [915] = {.lex_state = 75, .external_lex_state = 2},
  [916] = {.lex_state = 75, .external_lex_state = 2},
  [917] = {.lex_state = 75, .external_lex_state = 2},
  [918] = {.lex_state = 75, .external_lex_state = 2},
  [919] = {.lex_state = 75, .external_lex_state = 2},
  [920] = {.lex_state = 75, .external_lex_state = 2},
  [921] = {.lex_state = 75, .external_lex_state = 2},
  [922] = {.lex_state = 75, .external_lex_state = 2},
  [923] = {.lex_state = 75, .external_lex_state = 2},
  [924] = {.lex_state = 75, .external_lex_state = 2},
  [925] = {.lex_state = 75, .external_lex_state = 2},
  [926] = {.lex_state = 75, .external_lex_state = 2},
  [927] = {.lex_state = 75, .external_lex_state = 2},
  [928] = {.lex_state = 75, .external_lex_state = 2},
  [929] = {.lex_state = 75, .external_lex_state = 2},
  [930] = {.lex_state = 75, .external_lex_state = 2},
  [931] = {.lex_state = 75, .external_lex_state = 2},
  [932] = {.lex_state = 75, .external_lex_state = 2},
  [933] = {.lex_state = 9, .external_lex_state = 2},
  [934] = {.lex_state = 75, .external_lex_state = 2},
  [935] = {.lex_state = 9, .external_lex_state = 2},
  [936] = {.lex_state = 75, .external_lex_state = 2},
  [937] = {.lex_state = 75, .external_lex_state = 2},
  [938] = {.lex_state = 75, .external_lex_state = 2},
  [939] = {.lex_state = 75, .external_lex_state = 2},
  [940] = {.lex_state = 75, .external_lex_state = 2},
  [941] = {.lex_state = 75, .external_lex_state = 2},
  [942] = {.lex_state = 75, .external_lex_state = 2},
  [943] = {.lex_state = 75, .external_lex_state = 2},
  [944] = {.lex_state = 75, .external_lex_state = 2},
  [945] = {.lex_state = 9, .external_lex_state = 2},
  [946] = {.lex_state = 9, .external_lex_state = 2},
  [947] = {.lex_state = 75, .external_lex_state = 2},
  [948] = {.lex_state = 9, .external_lex_state = 2},
  [949] = {.lex_state = 9, .external_lex_state = 2},
  [950] = {.lex_state = 75, .external_lex_state = 2},
  [951] = {.lex_state = 9, .external_lex_state = 2},
  [952] = {.lex_state = 75, .external_lex_state = 2},
  [953] = {.lex_state = 9, .external_lex_state = 2},
  [954] = {.lex_state = 75, .external_lex_state = 2},
  [955] = {.lex_state = 75, .external_lex_state = 2},
  [956] = {.lex_state = 75, .external_lex_state = 2},
  [957] = {.lex_state = 9, .external_lex_state = 2},
  [958] = {.lex_state = 75, .external_lex_state = 2},
  [959] = {.lex_state = 9, .external_lex_state = 2},
  [960] = {.lex_state = 75, .external_lex_state = 2},
  [961] = {.lex_state = 9, .external_lex_state = 2},
  [962] = {.lex_state = 9, .external_lex_state = 2},
  [963] = {.lex_state = 9, .external_lex_state = 2},
  [964] = {.lex_state = 9, .external_lex_state = 2},
  [965] = {.lex_state = 75, .external_lex_state = 2},
  [966] = {.lex_state = 75, .external_lex_state = 2},
  [967] = {.lex_state = 9, .external_lex_state = 2},
  [968] = {.lex_state = 9, .external_lex_state = 2},
  [969] = {.lex_state = 75, .external_lex_state = 2},
  [970] = {.lex_state = 75, .external_lex_state = 2},
  [971] = {.lex_state = 9, .external_lex_state = 2},
  [972] = {.lex_state = 75, .external_lex_state = 2},
  [973] = {.lex_state = 9, .external_lex_state = 2},
  [974] = {.lex_state = 9, .external_lex_state = 2},
  [975] = {.lex_state = 75, .external_lex_state = 2},
  [976] = {.lex_state = 9, .external_lex_state = 2},
  [977] = {.lex_state = 9, .external_lex_state = 2},
  [978] = {.lex_state = 9, .external_lex_state = 2},
  [979] = {.lex_state = 9, .external_lex_state = 2},
  [980] = {.lex_state = 9, .external_lex_state = 2},
  [981] = {.lex_state = 9, .external_lex_state = 2},
  [982] = {.lex_state = 9, .external_lex_state = 2},
  [983] = {.lex_state = 9, .external_lex_state = 2},
  [984] = {.lex_state = 9, .external_lex_state = 2},
  [985] = {.lex_state = 9, .external_lex_state = 2},
  [986] = {.lex_state = 9, .external_lex_state = 2},
  [987] = {.lex_state = 9, .external_lex_state = 2},
  [988] = {.lex_state = 7, .external_lex_state = 2},
  [989] = {.lex_state = 9, .external_lex_state = 2},
  [990] = {.lex_state = 9, .external_lex_state = 2},
  [991] = {.lex_state = 7, .external_lex_state = 2},
  [992] = {.lex_state = 7, .external_lex_state = 2},
  [993] = {.lex_state = 9, .external_lex_state = 2},
  [994] = {.lex_state = 9, .external_lex_state = 2},
  [995] = {.lex_state = 9, .external_lex_state = 2},
  [996] = {.lex_state = 9, .external_lex_state = 2},
  [997] = {.lex_state = 9, .external_lex_state = 2},
  [998] = {.lex_state = 9, .external_lex_state = 2},
  [999] = {.lex_state = 9, .external_lex_state = 2},
  [1000] = {.lex_state = 9, .external_lex_state = 2},
  [1001] = {.lex_state = 9, .external_lex_state = 2},
  [1002] = {.lex_state = 9, .external_lex_state = 2},
  [1003] = {.lex_state = 9, .external_lex_state = 2},
  [1004] = {.lex_state = 9, .external_lex_state = 2},
  [1005] = {.lex_state = 9, .external_lex_state = 2},
  [1006] = {.lex_state = 9, .external_lex_state = 2},
  [1007] = {.lex_state = 9, .external_lex_state = 2},
  [1008] = {.lex_state = 9, .external_lex_state = 2},
  [1009] = {.lex_state = 9, .external_lex_state = 2},
  [1010] = {.lex_state = 9, .external_lex_state = 2},
  [1011] = {.lex_state = 9, .external_lex_state = 2},
  [1012] = {.lex_state = 9, .external_lex_state = 2},
  [1013] = {.lex_state = 9, .external_lex_state = 2},
  [1014] = {.lex_state = 9, .external_lex_state = 2},
  [1015] = {.lex_state = 9, .external_lex_state = 2},
  [1016] = {.lex_state = 9, .external_lex_state = 2},
  [1017] = {.lex_state = 9, .external_lex_state = 2},
  [1018] = {.lex_state = 9, .external_lex_state = 2},
  [1019] = {.lex_state = 9, .external_lex_state = 2},
  [1020] = {.lex_state = 9, .external_lex_state = 2},
  [1021] = {.lex_state = 9, .external_lex_state = 2},
  [1022] = {.lex_state = 9, .external_lex_state = 2},
  [1023] = {.lex_state = 9, .external_lex_state = 2},
  [1024] = {.lex_state = 9, .external_lex_state = 2},
  [1025] = {.lex_state = 9, .external_lex_state = 2},
  [1026] = {.lex_state = 9, .external_lex_state = 2},
  [1027] = {.lex_state = 9, .external_lex_state = 2},
  [1028] = {.lex_state = 9, .external_lex_state = 2},
  [1029] = {.lex_state = 9, .external_lex_state = 2},
  [1030] = {.lex_state = 9, .external_lex_state = 2},
  [1031] = {.lex_state = 9, .external_lex_state = 2},
  [1032] = {.lex_state = 9, .external_lex_state = 2},
  [1033] = {.lex_state = 9, .external_lex_state = 2},
  [1034] = {.lex_state = 9, .external_lex_state = 2},
  [1035] = {.lex_state = 9, .external_lex_state = 2},
  [1036] = {.lex_state = 9, .external_lex_state = 2},
  [1037] = {.lex_state = 9, .external_lex_state = 2},
  [1038] = {.lex_state = 9, .external_lex_state = 2},
  [1039] = {.lex_state = 9, .external_lex_state = 2},
  [1040] = {.lex_state = 9, .external_lex_state = 2},
  [1041] = {.lex_state = 9, .external_lex_state = 2},
  [1042] = {.lex_state = 9, .external_lex_state = 2},
  [1043] = {.lex_state = 9, .external_lex_state = 2},
  [1044] = {.lex_state = 9, .external_lex_state = 2},
  [1045] = {.lex_state = 9, .external_lex_state = 2},
  [1046] = {.lex_state = 9, .external_lex_state = 2},
  [1047] = {.lex_state = 9, .external_lex_state = 2},
  [1048] = {.lex_state = 9, .external_lex_state = 2},
  [1049] = {.lex_state = 9, .external_lex_state = 2},
  [1050] = {.lex_state = 9, .external_lex_state = 2},
  [1051] = {.lex_state = 9, .external_lex_state = 2},
  [1052] = {.lex_state = 9, .external_lex_state = 2},
  [1053] = {.lex_state = 9, .external_lex_state = 2},
  [1054] = {.lex_state = 9, .external_lex_state = 2},
  [1055] = {.lex_state = 9, .external_lex_state = 2},
  [1056] = {.lex_state = 9, .external_lex_state = 2},
  [1057] = {.lex_state = 9, .external_lex_state = 2},
  [1058] = {.lex_state = 9, .external_lex_state = 2},
  [1059] = {.lex_state = 9, .external_lex_state = 2},
  [1060] = {.lex_state = 9, .external_lex_state = 2},
  [1061] = {.lex_state = 9, .external_lex_state = 2},
  [1062] = {.lex_state = 9, .external_lex_state = 2},
  [1063] = {.lex_state = 9, .external_lex_state = 2},
  [1064] = {.lex_state = 9, .external_lex_state = 2},
  [1065] = {.lex_state = 9, .external_lex_state = 2},
  [1066] = {.lex_state = 9, .external_lex_state = 2},
  [1067] = {.lex_state = 9, .external_lex_state = 2},
  [1068] = {.lex_state = 9, .external_lex_state = 2},
  [1069] = {.lex_state = 9, .external_lex_state = 2},
  [1070] = {.lex_state = 9, .external_lex_state = 2},
  [1071] = {.lex_state = 9, .external_lex_state = 2},
  [1072] = {.lex_state = 9, .external_lex_state = 2},
  [1073] = {.lex_state = 9, .external_lex_state = 2},
  [1074] = {.lex_state = 9, .external_lex_state = 2},
  [1075] = {.lex_state = 9, .external_lex_state = 2},
  [1076] = {.lex_state = 9, .external_lex_state = 2},
  [1077] = {.lex_state = 9, .external_lex_state = 2},
  [1078] = {.lex_state = 9, .external_lex_state = 2},
  [1079] = {.lex_state = 9, .external_lex_state = 2},
  [1080] = {.lex_state = 9, .external_lex_state = 2},
  [1081] = {.lex_state = 9, .external_lex_state = 2},
  [1082] = {.lex_state = 9, .external_lex_state = 2},
  [1083] = {.lex_state = 9, .external_lex_state = 2},
  [1084] = {.lex_state = 9, .external_lex_state = 2},
  [1085] = {.lex_state = 9, .external_lex_state = 2},
  [1086] = {.lex_state = 9, .external_lex_state = 2},
  [1087] = {.lex_state = 9, .external_lex_state = 2},
  [1088] = {.lex_state = 9, .external_lex_state = 2},
  [1089] = {.lex_state = 9, .external_lex_state = 2},
  [1090] = {.lex_state = 9, .external_lex_state = 2},
  [1091] = {.lex_state = 9, .external_lex_state = 2},
  [1092] = {.lex_state = 9, .external_lex_state = 2},
  [1093] = {.lex_state = 9, .external_lex_state = 2},
  [1094] = {.lex_state = 9, .external_lex_state = 2},
  [1095] = {.lex_state = 9, .external_lex_state = 2},
  [1096] = {.lex_state = 9, .external_lex_state = 2},
  [1097] = {.lex_state = 9, .external_lex_state = 2},
  [1098] = {.lex_state = 9, .external_lex_state = 2},
  [1099] = {.lex_state = 9, .external_lex_state = 2},
  [1100] = {.lex_state = 9, .external_lex_state = 2},
  [1101] = {.lex_state = 9, .external_lex_state = 2},
  [1102] = {.lex_state = 9, .external_lex_state = 2},
  [1103] = {.lex_state = 9, .external_lex_state = 2},
  [1104] = {.lex_state = 9, .external_lex_state = 2},
  [1105] = {.lex_state = 9, .external_lex_state = 2},
  [1106] = {.lex_state = 9, .external_lex_state = 2},
  [1107] = {.lex_state = 9, .external_lex_state = 2},
  [1108] = {.lex_state = 9, .external_lex_state = 2},
  [1109] = {.lex_state = 9, .external_lex_state = 2},
  [1110] = {.lex_state = 9, .external_lex_state = 2},
  [1111] = {.lex_state = 9, .external_lex_state = 2},
  [1112] = {.lex_state = 9, .external_lex_state = 2},
  [1113] = {.lex_state = 9, .external_lex_state = 2},
  [1114] = {.lex_state = 9, .external_lex_state = 2},
  [1115] = {.lex_state = 9, .external_lex_state = 2},
  [1116] = {.lex_state = 9, .external_lex_state = 2},
  [1117] = {.lex_state = 9, .external_lex_state = 2},
  [1118] = {.lex_state = 9, .external_lex_state = 2},
  [1119] = {.lex_state = 9, .external_lex_state = 2},
  [1120] = {.lex_state = 9, .external_lex_state = 2},
  [1121] = {.lex_state = 9, .external_lex_state = 2},
  [1122] = {.lex_state = 9, .external_lex_state = 2},
  [1123] = {.lex_state = 9, .external_lex_state = 2},
  [1124] = {.lex_state = 9, .external_lex_state = 2},
  [1125] = {.lex_state = 9, .external_lex_state = 2},
  [1126] = {.lex_state = 9, .external_lex_state = 2},
  [1127] = {.lex_state = 9, .external_lex_state = 2},
  [1128] = {.lex_state = 9, .external_lex_state = 2},
  [1129] = {.lex_state = 9, .external_lex_state = 2},
  [1130] = {.lex_state = 9, .external_lex_state = 2},
  [1131] = {.lex_state = 9, .external_lex_state = 2},
  [1132] = {.lex_state = 9, .external_lex_state = 2},
  [1133] = {.lex_state = 9, .external_lex_state = 2},
  [1134] = {.lex_state = 9, .external_lex_state = 2},
  [1135] = {.lex_state = 9, .external_lex_state = 2},
  [1136] = {.lex_state = 9, .external_lex_state = 2},
  [1137] = {.lex_state = 9, .external_lex_state = 2},
  [1138] = {.lex_state = 9, .external_lex_state = 2},
  [1139] = {.lex_state = 9, .external_lex_state = 2},
  [1140] = {.lex_state = 9, .external_lex_state = 2},
  [1141] = {.lex_state = 9, .external_lex_state = 2},
  [1142] = {.lex_state = 9, .external_lex_state = 2},
  [1143] = {.lex_state = 9, .external_lex_state = 2},
  [1144] = {.lex_state = 9, .external_lex_state = 2},
  [1145] = {.lex_state = 9, .external_lex_state = 2},
  [1146] = {.lex_state = 9, .external_lex_state = 2},
  [1147] = {.lex_state = 9, .external_lex_state = 2},
  [1148] = {.lex_state = 9, .external_lex_state = 2},
  [1149] = {.lex_state = 9, .external_lex_state = 2},
  [1150] = {.lex_state = 9, .external_lex_state = 2},
  [1151] = {.lex_state = 10, .external_lex_state = 2},
  [1152] = {.lex_state = 10, .external_lex_state = 2},
  [1153] = {.lex_state = 10, .external_lex_state = 2},
  [1154] = {.lex_state = 10, .external_lex_state = 2},
  [1155] = {.lex_state = 10, .external_lex_state = 2},
  [1156] = {.lex_state = 10, .external_lex_state = 2},
  [1157] = {.lex_state = 10, .external_lex_state = 2},
  [1158] = {.lex_state = 10, .external_lex_state = 2},
  [1159] = {.lex_state = 10, .external_lex_state = 2},
  [1160] = {.lex_state = 10, .external_lex_state = 2},
  [1161] = {.lex_state = 10, .external_lex_state = 2},
  [1162] = {.lex_state = 10, .external_lex_state = 2},
  [1163] = {.lex_state = 3, .external_lex_state = 4},
  [1164] = {.lex_state = 2, .external_lex_state = 4},
  [1165] = {.lex_state = 3, .external_lex_state = 4},
  [1166] = {.lex_state = 75, .external_lex_state = 2},
  [1167] = {.lex_state = 2, .external_lex_state = 4},
  [1168] = {.lex_state = 2, .external_lex_state = 4},
  [1169] = {.lex_state = 3, .external_lex_state = 4},
  [1170] = {.lex_state = 75, .external_lex_state = 2},
  [1171] = {.lex_state = 75, .external_lex_state = 2},
  [1172] = {.lex_state = 2, .external_lex_state = 4},
  [1173] = {.lex_state = 2, .external_lex_state = 4},
  [1174] = {.lex_state = 2, .external_lex_state = 4},
  [1175] = {.lex_state = 2, .external_lex_state = 3},
  [1176] = {.lex_state = 2, .external_lex_state = 3},
  [1177] = {.lex_state = 2, .external_lex_state = 3},
  [1178] = {.lex_state = 2, .external_lex_state = 3},
  [1179] = {.lex_state = 10, .external_lex_state = 2},
  [1180] = {.lex_state = 10, .external_lex_state = 2},
  [1181] = {.lex_state = 2, .external_lex_state = 4},
  [1182] = {.lex_state = 3, .external_lex_state = 4},
  [1183] = {.lex_state = 2, .external_lex_state = 4},
  [1184] = {.lex_state = 2, .external_lex_state = 4},
  [1185] = {.lex_state = 2, .external_lex_state = 3},
  [1186] = {.lex_state = 2, .external_lex_state = 3},
  [1187] = {.lex_state = 2, .external_lex_state = 4},
  [1188] = {.lex_state = 2, .external_lex_state = 4},
  [1189] = {.lex_state = 2, .external_lex_state = 4},
  [1190] = {.lex_state = 2, .external_lex_state = 4},
  [1191] = {.lex_state = 2, .external_lex_state = 4},
  [1192] = {.lex_state = 3, .external_lex_state = 4},
  [1193] = {.lex_state = 2, .external_lex_state = 4},
  [1194] = {.lex_state = 2, .external_lex_state = 4},
  [1195] = {.lex_state = 2, .external_lex_state = 3},
  [1196] = {.lex_state = 2, .external_lex_state = 4},
  [1197] = {.lex_state = 3, .external_lex_state = 3},
  [1198] = {.lex_state = 3, .external_lex_state = 3},
  [1199] = {.lex_state = 3, .external_lex_state = 3},
  [1200] = {.lex_state = 3, .external_lex_state = 3},
  [1201] = {.lex_state = 3, .external_lex_state = 3},
  [1202] = {.lex_state = 3, .external_lex_state = 3},
  [1203] = {.lex_state = 2, .external_lex_state = 3},
  [1204] = {.lex_state = 3, .external_lex_state = 3},
  [1205] = {.lex_state = 3, .external_lex_state = 3},
  [1206] = {.lex_state = 3, .external_lex_state = 3},
  [1207] = {.lex_state = 3, .external_lex_state = 3},
  [1208] = {.lex_state = 2, .external_lex_state = 3},
  [1209] = {.lex_state = 3, .external_lex_state = 3},
  [1210] = {.lex_state = 2, .external_lex_state = 3},
  [1211] = {.lex_state = 2, .external_lex_state = 3},
  [1212] = {.lex_state = 3, .external_lex_state = 3},
  [1213] = {.lex_state = 3, .external_lex_state = 3},
  [1214] = {.lex_state = 2, .external_lex_state = 3},
  [1215] = {.lex_state = 2, .external_lex_state = 4},
  [1216] = {.lex_state = 2, .external_lex_state = 4},
  [1217] = {.lex_state = 3, .external_lex_state = 3},
  [1218] = {.lex_state = 2, .external_lex_state = 4},
  [1219] = {.lex_state = 3, .external_lex_state = 3},
  [1220] = {.lex_state = 2, .external_lex_state = 4},
  [1221] = {.lex_state = 3, .external_lex_state = 4},
  [1222] = {.lex_state = 3, .external_lex_state = 4},
  [1223] = {.lex_state = 2, .external_lex_state = 3},
  [1224] = {.lex_state = 2, .external_lex_state = 4},
  [1225] = {.lex_state = 2, .external_lex_state = 3},
  [1226] = {.lex_state = 2, .external_lex_state = 4},
  [1227] = {.lex_state = 2, .external_lex_state = 4},
  [1228] = {.lex_state = 2, .external_lex_state = 4},
  [1229] = {.lex_state = 2, .external_lex_state = 3},
  [1230] = {.lex_state = 2, .external_lex_state = 4},
  [1231] = {.lex_state = 2, .external_lex_state = 4},
  [1232] = {.lex_state = 2, .external_lex_state = 4},
  [1233] = {.lex_state = 2, .external_lex_state = 4},
  [1234] = {.lex_state = 2, .external_lex_state = 3},
  [1235] = {.lex_state = 2, .external_lex_state = 3},
  [1236] = {.lex_state = 2, .external_lex_state = 3},
  [1237] = {.lex_state = 2, .external_lex_state = 3},
  [1238] = {.lex_state = 2, .external_lex_state = 3},
  [1239] = {.lex_state = 2, .external_lex_state = 3},
  [1240] = {.lex_state = 2, .external_lex_state = 3},
  [1241] = {.lex_state = 2, .external_lex_state = 3},
  [1242] = {.lex_state = 2, .external_lex_state = 3},
  [1243] = {.lex_state = 2, .external_lex_state = 3},
  [1244] = {.lex_state = 2, .external_lex_state = 4},
  [1245] = {.lex_state = 2, .external_lex_state = 4},
  [1246] = {.lex_state = 75, .external_lex_state = 2},
  [1247] = {.lex_state = 2, .external_lex_state = 4},
  [1248] = {.lex_state = 2, .external_lex_state = 3},
  [1249] = {.lex_state = 2, .external_lex_state = 4},
  [1250] = {.lex_state = 2, .external_lex_state = 3},
  [1251] = {.lex_state = 2, .external_lex_state = 3},
  [1252] = {.lex_state = 2, .external_lex_state = 3},
  [1253] = {.lex_state = 2, .external_lex_state = 3},
  [1254] = {.lex_state = 3, .external_lex_state = 3},
  [1255] = {.lex_state = 3, .external_lex_state = 3},
  [1256] = {.lex_state = 2, .external_lex_state = 4},
  [1257] = {.lex_state = 2, .external_lex_state = 3},
  [1258] = {.lex_state = 2, .external_lex_state = 3},
  [1259] = {.lex_state = 2, .external_lex_state = 3},
  [1260] = {.lex_state = 2, .external_lex_state = 3},
  [1261] = {.lex_state = 2, .external_lex_state = 3},
  [1262] = {.lex_state = 2, .external_lex_state = 4},
  [1263] = {.lex_state = 2, .external_lex_state = 3},
  [1264] = {.lex_state = 2, .external_lex_state = 3},
  [1265] = {.lex_state = 2, .external_lex_state = 3},
  [1266] = {.lex_state = 2, .external_lex_state = 3},
  [1267] = {.lex_state = 2, .external_lex_state = 3},
  [1268] = {.lex_state = 2, .external_lex_state = 3},
  [1269] = {.lex_state = 75, .external_lex_state = 2},
  [1270] = {.lex_state = 2, .external_lex_state = 4},
  [1271] = {.lex_state = 2, .external_lex_state = 3},
  [1272] = {.lex_state = 75, .external_lex_state = 2},
  [1273] = {.lex_state = 2, .external_lex_state = 3},
  [1274] = {.lex_state = 2, .external_lex_state = 3},
  [1275] = {.lex_state = 2, .external_lex_state = 3},
  [1276] = {.lex_state = 2, .external_lex_state = 3},
  [1277] = {.lex_state = 2, .external_lex_state = 3},
  [1278] = {.lex_state = 2, .external_lex_state = 3},
  [1279] = {.lex_state = 2, .external_lex_state = 3},
  [1280] = {.lex_state = 2, .external_lex_state = 3},
  [1281] = {.lex_state = 2, .external_lex_state = 3},
  [1282] = {.lex_state = 2, .external_lex_state = 4},
  [1283] = {.lex_state = 2, .external_lex_state = 3},
  [1284] = {.lex_state = 2, .external_lex_state = 4},
  [1285] = {.lex_state = 2, .external_lex_state = 4},
  [1286] = {.lex_state = 2, .external_lex_state = 3},
  [1287] = {.lex_state = 75, .external_lex_state = 2},
  [1288] = {.lex_state = 75, .external_lex_state = 2},
  [1289] = {.lex_state = 2, .external_lex_state = 3},
  [1290] = {.lex_state = 2, .external_lex_state = 4},
  [1291] = {.lex_state = 2, .external_lex_state = 4},
  [1292] = {.lex_state = 2, .external_lex_state = 4},
  [1293] = {.lex_state = 2, .external_lex_state = 3},
  [1294] = {.lex_state = 2, .external_lex_state = 4},
  [1295] = {.lex_state = 2, .external_lex_state = 3},
  [1296] = {.lex_state = 2, .external_lex_state = 3},
  [1297] = {.lex_state = 75, .external_lex_state = 2},
  [1298] = {.lex_state = 2, .external_lex_state = 3},
  [1299] = {.lex_state = 2, .external_lex_state = 3},
  [1300] = {.lex_state = 2, .external_lex_state = 4},
  [1301] = {.lex_state = 2, .external_lex_state = 3},
  [1302] = {.lex_state = 3, .external_lex_state = 3},
  [1303] = {.lex_state = 2, .external_lex_state = 4},
  [1304] = {.lex_state = 2, .external_lex_state = 3},
  [1305] = {.lex_state = 2, .external_lex_state = 3},
  [1306] = {.lex_state = 2, .external_lex_state = 3},
  [1307] = {.lex_state = 2, .external_lex_state = 4},
  [1308] = {.lex_state = 2, .external_lex_state = 4},
  [1309] = {.lex_state = 2, .external_lex_state = 3},
  [1310] = {.lex_state = 2, .external_lex_state = 4},
  [1311] = {.lex_state = 2, .external_lex_state = 4},
  [1312] = {.lex_state = 2, .external_lex_state = 4},
  [1313] = {.lex_state = 2, .external_lex_state = 4},
  [1314] = {.lex_state = 2, .external_lex_state = 3},
  [1315] = {.lex_state = 2, .external_lex_state = 4},
  [1316] = {.lex_state = 2, .external_lex_state = 4},
  [1317] = {.lex_state = 75, .external_lex_state = 2},
  [1318] = {.lex_state = 2, .external_lex_state = 3},
  [1319] = {.lex_state = 2, .external_lex_state = 3},
  [1320] = {.lex_state = 2, .external_lex_state = 4},
  [1321] = {.lex_state = 2, .external_lex_state = 4},
  [1322] = {.lex_state = 2, .external_lex_state = 3},
  [1323] = {.lex_state = 2, .external_lex_state = 3},
  [1324] = {.lex_state = 2, .external_lex_state = 4},
  [1325] = {.lex_state = 2, .external_lex_state = 4},
  [1326] = {.lex_state = 2, .external_lex_state = 4},
  [1327] = {.lex_state = 2, .external_lex_state = 3},
  [1328] = {.lex_state = 2, .external_lex_state = 4},
  [1329] = {.lex_state = 2, .external_lex_state = 4},
  [1330] = {.lex_state = 2, .external_lex_state = 4},
  [1331] = {.lex_state = 2, .external_lex_state = 4},
  [1332] = {.lex_state = 75, .external_lex_state = 2},
  [1333] = {.lex_state = 2, .external_lex_state = 3},
  [1334] = {.lex_state = 2, .external_lex_state = 4},
  [1335] = {.lex_state = 2, .external_lex_state = 4},
  [1336] = {.lex_state = 2, .external_lex_state = 3},
  [1337] = {.lex_state = 2, .external_lex_state = 4},
  [1338] = {.lex_state = 2, .external_lex_state = 3},
  [1339] = {.lex_state = 2, .external_lex_state = 3},
  [1340] = {.lex_state = 2, .external_lex_state = 3},
  [1341] = {.lex_state = 2, .external_lex_state = 3},
  [1342] = {.lex_state = 2, .external_lex_state = 4},
  [1343] = {.lex_state = 3, .external_lex_state = 3},
  [1344] = {.lex_state = 75, .external_lex_state = 2},
  [1345] = {.lex_state = 2, .external_lex_state = 3},
  [1346] = {.lex_state = 2, .external_lex_state = 3},
  [1347] = {.lex_state = 2, .external_lex_state = 4},
  [1348] = {.lex_state = 2, .external_lex_state = 4},
  [1349] = {.lex_state = 2, .external_lex_state = 3},
  [1350] = {.lex_state = 2, .external_lex_state = 4},
  [1351] = {.lex_state = 2, .external_lex_state = 4},
  [1352] = {.lex_state = 2, .external_lex_state = 3},
  [1353] = {.lex_state = 3, .external_lex_state = 3},
  [1354] = {.lex_state = 2, .external_lex_state = 3},
  [1355] = {.lex_state = 3, .external_lex_state = 3},
  [1356] = {.lex_state = 2, .external_lex_state = 3},
  [1357] = {.lex_state = 2, .external_lex_state = 3},
  [1358] = {.lex_state = 2, .external_lex_state = 3},
  [1359] = {.lex_state = 2, .external_lex_state = 4},
  [1360] = {.lex_state = 2, .external_lex_state = 3},
  [1361] = {.lex_state = 2, .external_lex_state = 3},
  [1362] = {.lex_state = 2, .external_lex_state = 4},
  [1363] = {.lex_state = 2, .external_lex_state = 3},
  [1364] = {.lex_state = 2, .external_lex_state = 4},
  [1365] = {.lex_state = 2, .external_lex_state = 3},
  [1366] = {.lex_state = 2, .external_lex_state = 3},
  [1367] = {.lex_state = 2, .external_lex_state = 4},
  [1368] = {.lex_state = 2, .external_lex_state = 3},
  [1369] = {.lex_state = 2, .external_lex_state = 3},
  [1370] = {.lex_state = 2, .external_lex_state = 3},
  [1371] = {.lex_state = 2, .external_lex_state = 3},
  [1372] = {.lex_state = 2, .external_lex_state = 3},
  [1373] = {.lex_state = 2, .external_lex_state = 3},
  [1374] = {.lex_state = 3, .external_lex_state = 3},
  [1375] = {.lex_state = 3, .external_lex_state = 3},
  [1376] = {.lex_state = 2, .external_lex_state = 3},
  [1377] = {.lex_state = 2, .external_lex_state = 3},
  [1378] = {.lex_state = 2, .external_lex_state = 3},
  [1379] = {.lex_state = 2, .external_lex_state = 3},
  [1380] = {.lex_state = 9, .external_lex_state = 2},
  [1381] = {.lex_state = 2, .external_lex_state = 3},
  [1382] = {.lex_state = 9, .external_lex_state = 2},
  [1383] = {.lex_state = 2, .external_lex_state = 4},
  [1384] = {.lex_state = 2, .external_lex_state = 4},
  [1385] = {.lex_state = 2, .external_lex_state = 4},
  [1386] = {.lex_state = 9, .external_lex_state = 2},
  [1387] = {.lex_state = 3, .external_lex_state = 3},
  [1388] = {.lex_state = 2, .external_lex_state = 3},
  [1389] = {.lex_state = 9, .external_lex_state = 2},
  [1390] = {.lex_state = 2, .external_lex_state = 3},
  [1391] = {.lex_state = 2, .external_lex_state = 3},
  [1392] = {.lex_state = 2, .external_lex_state = 3},
  [1393] = {.lex_state = 2, .external_lex_state = 3},
  [1394] = {.lex_state = 9, .external_lex_state = 2},
  [1395] = {.lex_state = 9, .external_lex_state = 2},
  [1396] = {.lex_state = 2, .external_lex_state = 3},
  [1397] = {.lex_state = 2, .external_lex_state = 3},
  [1398] = {.lex_state = 2, .external_lex_state = 3},
  [1399] = {.lex_state = 2, .external_lex_state = 3},
  [1400] = {.lex_state = 2, .external_lex_state = 4},
  [1401] = {.lex_state = 2, .external_lex_state = 3},
  [1402] = {.lex_state = 2, .external_lex_state = 3},
  [1403] = {.lex_state = 2, .external_lex_state = 3},
  [1404] = {.lex_state = 2, .external_lex_state = 3},
  [1405] = {.lex_state = 2, .external_lex_state = 3},
  [1406] = {.lex_state = 2, .external_lex_state = 3},
  [1407] = {.lex_state = 2, .external_lex_state = 3},
  [1408] = {.lex_state = 2, .external_lex_state = 3},
  [1409] = {.lex_state = 2, .external_lex_state = 3},
  [1410] = {.lex_state = 2, .external_lex_state = 4},
  [1411] = {.lex_state = 2, .external_lex_state = 3},
  [1412] = {.lex_state = 2, .external_lex_state = 3},
  [1413] = {.lex_state = 2, .external_lex_state = 3},
  [1414] = {.lex_state = 2, .external_lex_state = 3},
  [1415] = {.lex_state = 2, .external_lex_state = 3},
  [1416] = {.lex_state = 2, .external_lex_state = 3},
  [1417] = {.lex_state = 2, .external_lex_state = 3},
  [1418] = {.lex_state = 2, .external_lex_state = 3},
  [1419] = {.lex_state = 9, .external_lex_state = 2},
  [1420] = {.lex_state = 2, .external_lex_state = 3},
  [1421] = {.lex_state = 2, .external_lex_state = 3},
  [1422] = {.lex_state = 2, .external_lex_state = 3},
  [1423] = {.lex_state = 9, .external_lex_state = 2},
  [1424] = {.lex_state = 9, .external_lex_state = 2},
  [1425] = {.lex_state = 2, .external_lex_state = 3},
  [1426] = {.lex_state = 9, .external_lex_state = 2},
  [1427] = {.lex_state = 2, .external_lex_state = 3},
  [1428] = {.lex_state = 2, .external_lex_state = 3},
  [1429] = {.lex_state = 2, .external_lex_state = 3},
  [1430] = {.lex_state = 2, .external_lex_state = 3},
  [1431] = {.lex_state = 2, .external_lex_state = 3},
  [1432] = {.lex_state = 9, .external_lex_state = 2},
  [1433] = {.lex_state = 9, .external_lex_state = 2},
  [1434] = {.lex_state = 2, .external_lex_state = 3},
  [1435] = {.lex_state = 2, .external_lex_state = 3},
  [1436] = {.lex_state = 9, .external_lex_state = 2},
  [1437] = {.lex_state = 9, .external_lex_state = 2},
  [1438] = {.lex_state = 2, .external_lex_state = 3},
  [1439] = {.lex_state = 9, .external_lex_state = 2},
  [1440] = {.lex_state = 2, .external_lex_state = 3},
  [1441] = {.lex_state = 9, .external_lex_state = 2},
  [1442] = {.lex_state = 9, .external_lex_state = 2},
  [1443] = {.lex_state = 9, .external_lex_state = 2},
  [1444] = {.lex_state = 2, .external_lex_state = 3},
  [1445] = {.lex_state = 2, .external_lex_state = 3},
  [1446] = {.lex_state = 2, .external_lex_state = 3},
  [1447] = {.lex_state = 2, .external_lex_state = 3},
  [1448] = {.lex_state = 2, .external_lex_state = 3},
  [1449] = {.lex_state = 2, .external_lex_state = 3},
  [1450] = {.lex_state = 9, .external_lex_state = 2},
  [1451] = {.lex_state = 2, .external_lex_state = 3},
  [1452] = {.lex_state = 2, .external_lex_state = 3},
  [1453] = {.lex_state = 2, .external_lex_state = 3},
  [1454] = {.lex_state = 9, .external_lex_state = 2},
  [1455] = {.lex_state = 9, .external_lex_state = 2},
  [1456] = {.lex_state = 2, .external_lex_state = 3},
  [1457] = {.lex_state = 2, .external_lex_state = 3},
  [1458] = {.lex_state = 2, .external_lex_state = 3},
  [1459] = {.lex_state = 2, .external_lex_state = 3},
  [1460] = {.lex_state = 9, .external_lex_state = 2},
  [1461] = {.lex_state = 2, .external_lex_state = 3},
  [1462] = {.lex_state = 9, .external_lex_state = 2},
  [1463] = {.lex_state = 9, .external_lex_state = 2},
  [1464] = {.lex_state = 2, .external_lex_state = 3},
  [1465] = {.lex_state = 2, .external_lex_state = 3},
  [1466] = {.lex_state = 2, .external_lex_state = 3},
  [1467] = {.lex_state = 2, .external_lex_state = 3},
  [1468] = {.lex_state = 2, .external_lex_state = 3},
  [1469] = {.lex_state = 2, .external_lex_state = 3},
  [1470] = {.lex_state = 2, .external_lex_state = 3},
  [1471] = {.lex_state = 2, .external_lex_state = 3},
  [1472] = {.lex_state = 2, .external_lex_state = 3},
  [1473] = {.lex_state = 2, .external_lex_state = 3},
  [1474] = {.lex_state = 9, .external_lex_state = 2},
  [1475] = {.lex_state = 9, .external_lex_state = 2},
  [1476] = {.lex_state = 9, .external_lex_state = 2},
  [1477] = {.lex_state = 9, .external_lex_state = 2},
  [1478] = {.lex_state = 9, .external_lex_state = 2},
  [1479] = {.lex_state = 9, .external_lex_state = 2},
  [1480] = {.lex_state = 9, .external_lex_state = 2},
  [1481] = {.lex_state = 75, .external_lex_state = 5},
  [1482] = {.lex_state = 9, .external_lex_state = 2},
  [1483] = {.lex_state = 9, .external_lex_state = 2},
  [1484] = {.lex_state = 9, .external_lex_state = 2},
  [1485] = {.lex_state = 9, .external_lex_state = 2},
  [1486] = {.lex_state = 75, .external_lex_state = 5},
  [1487] = {.lex_state = 75, .external_lex_state = 5},
  [1488] = {.lex_state = 75, .external_lex_state = 5},
  [1489] = {.lex_state = 9, .external_lex_state = 2},
  [1490] = {.lex_state = 9, .external_lex_state = 2},
  [1491] = {.lex_state = 9, .external_lex_state = 2},
  [1492] = {.lex_state = 9, .external_lex_state = 2},
  [1493] = {.lex_state = 75, .external_lex_state = 5},
  [1494] = {.lex_state = 9, .external_lex_state = 2},
  [1495] = {.lex_state = 9, .external_lex_state = 2},
  [1496] = {.lex_state = 9, .external_lex_state = 2},
  [1497] = {.lex_state = 75, .external_lex_state = 2},
  [1498] = {.lex_state = 75, .external_lex_state = 2},
  [1499] = {.lex_state = 75, .external_lex_state = 2},
  [1500] = {.lex_state = 75, .external_lex_state = 2},
  [1501] = {.lex_state = 74, .external_lex_state = 3},
  [1502] = {.lex_state = 75, .external_lex_state = 2},
  [1503] = {.lex_state = 75, .external_lex_state = 2},
  [1504] = {.lex_state = 74, .external_lex_state = 3},
  [1505] = {.lex_state = 74, .external_lex_state = 3},
  [1506] = {.lex_state = 74, .external_lex_state = 3},
  [1507] = {.lex_state = 75, .external_lex_state = 5},
  [1508] = {.lex_state = 74, .external_lex_state = 4},
  [1509] = {.lex_state = 74, .external_lex_state = 3},
  [1510] = {.lex_state = 75, .external_lex_state = 5},
  [1511] = {.lex_state = 74, .external_lex_state = 4},
  [1512] = {.lex_state = 74, .external_lex_state = 3},
  [1513] = {.lex_state = 74, .external_lex_state = 3},
  [1514] = {.lex_state = 74, .external_lex_state = 3},
  [1515] = {.lex_state = 74, .external_lex_state = 3},
  [1516] = {.lex_state = 74, .external_lex_state = 3},
  [1517] = {.lex_state = 74, .external_lex_state = 3},
  [1518] = {.lex_state = 74, .external_lex_state = 3},
  [1519] = {.lex_state = 74, .external_lex_state = 3},
  [1520] = {.lex_state = 75, .external_lex_state = 2},
  [1521] = {.lex_state = 74, .external_lex_state = 4},
  [1522] = {.lex_state = 74, .external_lex_state = 3},
  [1523] = {.lex_state = 74, .external_lex_state = 3},
  [1524] = {.lex_state = 74, .external_lex_state = 3},
  [1525] = {.lex_state = 74, .external_lex_state = 3},
  [1526] = {.lex_state = 74, .external_lex_state = 3},
  [1527] = {.lex_state = 74, .external_lex_state = 3},
  [1528] = {.lex_state = 74, .external_lex_state = 3},
  [1529] = {.lex_state = 74, .external_lex_state = 3},
  [1530] = {.lex_state = 74, .external_lex_state = 3},
  [1531] = {.lex_state = 74, .external_lex_state = 3},
  [1532] = {.lex_state = 74, .external_lex_state = 3},
  [1533] = {.lex_state = 74, .external_lex_state = 3},
  [1534] = {.lex_state = 74, .external_lex_state = 4},
  [1535] = {.lex_state = 74, .external_lex_state = 3},
  [1536] = {.lex_state = 74, .external_lex_state = 3},
  [1537] = {.lex_state = 74, .external_lex_state = 3},
  [1538] = {.lex_state = 74, .external_lex_state = 3},
  [1539] = {.lex_state = 74, .external_lex_state = 3},
  [1540] = {.lex_state = 74, .external_lex_state = 3},
  [1541] = {.lex_state = 74, .external_lex_state = 3},
  [1542] = {.lex_state = 74, .external_lex_state = 3},
  [1543] = {.lex_state = 74, .external_lex_state = 3},
  [1544] = {.lex_state = 74, .external_lex_state = 3},
  [1545] = {.lex_state = 74, .external_lex_state = 3},
  [1546] = {.lex_state = 74, .external_lex_state = 3},
  [1547] = {.lex_state = 74, .external_lex_state = 3},
  [1548] = {.lex_state = 74, .external_lex_state = 3},
  [1549] = {.lex_state = 74, .external_lex_state = 3},
  [1550] = {.lex_state = 74, .external_lex_state = 3},
  [1551] = {.lex_state = 74, .external_lex_state = 3},
  [1552] = {.lex_state = 74, .external_lex_state = 3},
  [1553] = {.lex_state = 74, .external_lex_state = 3},
  [1554] = {.lex_state = 74, .external_lex_state = 3},
  [1555] = {.lex_state = 74, .external_lex_state = 3},
  [1556] = {.lex_state = 74, .external_lex_state = 3},
  [1557] = {.lex_state = 74, .external_lex_state = 3},
  [1558] = {.lex_state = 74, .external_lex_state = 3},
  [1559] = {.lex_state = 74, .external_lex_state = 3},
  [1560] = {.lex_state = 74, .external_lex_state = 3},
  [1561] = {.lex_state = 74, .external_lex_state = 3},
  [1562] = {.lex_state = 74, .external_lex_state = 3},
  [1563] = {.lex_state = 74, .external_lex_state = 3},
  [1564] = {.lex_state = 74, .external_lex_state = 3},
  [1565] = {.lex_state = 74, .external_lex_state = 3},
  [1566] = {.lex_state = 74, .external_lex_state = 3},
  [1567] = {.lex_state = 74, .external_lex_state = 3},
  [1568] = {.lex_state = 74, .external_lex_state = 3},
  [1569] = {.lex_state = 74, .external_lex_state = 3},
  [1570] = {.lex_state = 74, .external_lex_state = 3},
  [1571] = {.lex_state = 74, .external_lex_state = 3},
  [1572] = {.lex_state = 74, .external_lex_state = 3},
  [1573] = {.lex_state = 74, .external_lex_state = 3},
  [1574] = {.lex_state = 74, .external_lex_state = 3},
  [1575] = {.lex_state = 74, .external_lex_state = 3},
  [1576] = {.lex_state = 74, .external_lex_state = 3},
  [1577] = {.lex_state = 74, .external_lex_state = 3},
  [1578] = {.lex_state = 74, .external_lex_state = 3},
  [1579] = {.lex_state = 74, .external_lex_state = 4},
  [1580] = {.lex_state = 74, .external_lex_state = 3},
  [1581] = {.lex_state = 74, .external_lex_state = 3},
  [1582] = {.lex_state = 74, .external_lex_state = 3},
  [1583] = {.lex_state = 74, .external_lex_state = 3},
  [1584] = {.lex_state = 74, .external_lex_state = 3},
  [1585] = {.lex_state = 74, .external_lex_state = 3},
  [1586] = {.lex_state = 74, .external_lex_state = 3},
  [1587] = {.lex_state = 74, .external_lex_state = 3},
  [1588] = {.lex_state = 74, .external_lex_state = 3},
  [1589] = {.lex_state = 74, .external_lex_state = 3},
  [1590] = {.lex_state = 74, .external_lex_state = 3},
  [1591] = {.lex_state = 74, .external_lex_state = 3},
  [1592] = {.lex_state = 74, .external_lex_state = 3},
  [1593] = {.lex_state = 74, .external_lex_state = 3},
  [1594] = {.lex_state = 74, .external_lex_state = 3},
  [1595] = {.lex_state = 74, .external_lex_state = 3},
  [1596] = {.lex_state = 74, .external_lex_state = 3},
  [1597] = {.lex_state = 74, .external_lex_state = 3},
  [1598] = {.lex_state = 74, .external_lex_state = 3},
  [1599] = {.lex_state = 74, .external_lex_state = 3},
  [1600] = {.lex_state = 74, .external_lex_state = 3},
  [1601] = {.lex_state = 74, .external_lex_state = 3},
  [1602] = {.lex_state = 74, .external_lex_state = 3},
  [1603] = {.lex_state = 74, .external_lex_state = 3},
  [1604] = {.lex_state = 74, .external_lex_state = 3},
  [1605] = {.lex_state = 74, .external_lex_state = 3},
  [1606] = {.lex_state = 74, .external_lex_state = 4},
  [1607] = {.lex_state = 74, .external_lex_state = 3},
  [1608] = {.lex_state = 74, .external_lex_state = 4},
  [1609] = {.lex_state = 74, .external_lex_state = 3},
  [1610] = {.lex_state = 74, .external_lex_state = 3},
  [1611] = {.lex_state = 74, .external_lex_state = 3},
  [1612] = {.lex_state = 74, .external_lex_state = 4},
  [1613] = {.lex_state = 74, .external_lex_state = 3},
  [1614] = {.lex_state = 74, .external_lex_state = 3},
  [1615] = {.lex_state = 74, .external_lex_state = 3},
  [1616] = {.lex_state = 74, .external_lex_state = 3},
  [1617] = {.lex_state = 74, .external_lex_state = 3},
  [1618] = {.lex_state = 74, .external_lex_state = 3},
  [1619] = {.lex_state = 74, .external_lex_state = 3},
  [1620] = {.lex_state = 74, .external_lex_state = 3},
  [1621] = {.lex_state = 74, .external_lex_state = 3},
  [1622] = {.lex_state = 74, .external_lex_state = 3},
  [1623] = {.lex_state = 74, .external_lex_state = 3},
  [1624] = {.lex_state = 74, .external_lex_state = 3},
  [1625] = {.lex_state = 74, .external_lex_state = 3},
  [1626] = {.lex_state = 74, .external_lex_state = 3},
  [1627] = {.lex_state = 74, .external_lex_state = 3},
  [1628] = {.lex_state = 74, .external_lex_state = 3},
  [1629] = {.lex_state = 74, .external_lex_state = 3},
  [1630] = {.lex_state = 74, .external_lex_state = 3},
  [1631] = {.lex_state = 74, .external_lex_state = 3},
  [1632] = {.lex_state = 74, .external_lex_state = 3},
  [1633] = {.lex_state = 74, .external_lex_state = 3},
  [1634] = {.lex_state = 74, .external_lex_state = 3},
  [1635] = {.lex_state = 74, .external_lex_state = 3},
  [1636] = {.lex_state = 74, .external_lex_state = 3},
  [1637] = {.lex_state = 74, .external_lex_state = 3},
  [1638] = {.lex_state = 74, .external_lex_state = 3},
  [1639] = {.lex_state = 74, .external_lex_state = 3},
  [1640] = {.lex_state = 74, .external_lex_state = 3},
  [1641] = {.lex_state = 74, .external_lex_state = 3},
  [1642] = {.lex_state = 74, .external_lex_state = 3},
  [1643] = {.lex_state = 74, .external_lex_state = 3},
  [1644] = {.lex_state = 74, .external_lex_state = 3},
  [1645] = {.lex_state = 74, .external_lex_state = 3},
  [1646] = {.lex_state = 74, .external_lex_state = 3},
  [1647] = {.lex_state = 74, .external_lex_state = 3},
  [1648] = {.lex_state = 74, .external_lex_state = 3},
  [1649] = {.lex_state = 74, .external_lex_state = 3},
  [1650] = {.lex_state = 74, .external_lex_state = 3},
  [1651] = {.lex_state = 74, .external_lex_state = 3},
  [1652] = {.lex_state = 74, .external_lex_state = 3},
  [1653] = {.lex_state = 74, .external_lex_state = 3},
  [1654] = {.lex_state = 74, .external_lex_state = 3},
  [1655] = {.lex_state = 74, .external_lex_state = 3},
  [1656] = {.lex_state = 74, .external_lex_state = 3},
  [1657] = {.lex_state = 74, .external_lex_state = 3},
  [1658] = {.lex_state = 74, .external_lex_state = 3},
  [1659] = {.lex_state = 74, .external_lex_state = 3},
  [1660] = {.lex_state = 74, .external_lex_state = 3},
  [1661] = {.lex_state = 74, .external_lex_state = 3},
  [1662] = {.lex_state = 74, .external_lex_state = 3},
  [1663] = {.lex_state = 74, .external_lex_state = 3},
  [1664] = {.lex_state = 74, .external_lex_state = 3},
  [1665] = {.lex_state = 74, .external_lex_state = 3},
  [1666] = {.lex_state = 74, .external_lex_state = 3},
  [1667] = {.lex_state = 74, .external_lex_state = 3},
  [1668] = {.lex_state = 74, .external_lex_state = 3},
  [1669] = {.lex_state = 74, .external_lex_state = 3},
  [1670] = {.lex_state = 74, .external_lex_state = 3},
  [1671] = {.lex_state = 74, .external_lex_state = 3},
  [1672] = {.lex_state = 74, .external_lex_state = 3},
  [1673] = {.lex_state = 74, .external_lex_state = 3},
  [1674] = {.lex_state = 74, .external_lex_state = 3},
  [1675] = {.lex_state = 74, .external_lex_state = 3},
  [1676] = {.lex_state = 74, .external_lex_state = 3},
  [1677] = {.lex_state = 74, .external_lex_state = 3},
  [1678] = {.lex_state = 74, .external_lex_state = 3},
  [1679] = {.lex_state = 74, .external_lex_state = 3},
  [1680] = {.lex_state = 74, .external_lex_state = 3},
  [1681] = {.lex_state = 74, .external_lex_state = 3},
  [1682] = {.lex_state = 74, .external_lex_state = 3},
  [1683] = {.lex_state = 74, .external_lex_state = 3},
  [1684] = {.lex_state = 74, .external_lex_state = 3},
  [1685] = {.lex_state = 74, .external_lex_state = 3},
  [1686] = {.lex_state = 74, .external_lex_state = 3},
  [1687] = {.lex_state = 74, .external_lex_state = 3},
  [1688] = {.lex_state = 74, .external_lex_state = 3},
  [1689] = {.lex_state = 74, .external_lex_state = 3},
  [1690] = {.lex_state = 74, .external_lex_state = 3},
  [1691] = {.lex_state = 74, .external_lex_state = 3},
  [1692] = {.lex_state = 74, .external_lex_state = 3},
  [1693] = {.lex_state = 74, .external_lex_state = 3},
  [1694] = {.lex_state = 74, .external_lex_state = 3},
  [1695] = {.lex_state = 74, .external_lex_state = 3},
  [1696] = {.lex_state = 74, .external_lex_state = 4},
  [1697] = {.lex_state = 74, .external_lex_state = 3},
  [1698] = {.lex_state = 74, .external_lex_state = 3},
  [1699] = {.lex_state = 74, .external_lex_state = 3},
  [1700] = {.lex_state = 74, .external_lex_state = 3},
  [1701] = {.lex_state = 74, .external_lex_state = 3},
  [1702] = {.lex_state = 74, .external_lex_state = 3},
  [1703] = {.lex_state = 74, .external_lex_state = 3},
  [1704] = {.lex_state = 74, .external_lex_state = 3},
  [1705] = {.lex_state = 74, .external_lex_state = 3},
  [1706] = {.lex_state = 74, .external_lex_state = 3},
  [1707] = {.lex_state = 74, .external_lex_state = 3},
  [1708] = {.lex_state = 74, .external_lex_state = 4},
  [1709] = {.lex_state = 74, .external_lex_state = 4},
  [1710] = {.lex_state = 74, .external_lex_state = 3},
  [1711] = {.lex_state = 74, .external_lex_state = 3},
  [1712] = {.lex_state = 74, .external_lex_state = 3},
  [1713] = {.lex_state = 74, .external_lex_state = 3},
  [1714] = {.lex_state = 74, .external_lex_state = 3},
  [1715] = {.lex_state = 74, .external_lex_state = 3},
  [1716] = {.lex_state = 74, .external_lex_state = 3},
  [1717] = {.lex_state = 75, .external_lex_state = 5},
  [1718] = {.lex_state = 75, .external_lex_state = 5},
  [1719] = {.lex_state = 75, .external_lex_state = 5},
  [1720] = {.lex_state = 75, .external_lex_state = 5},
  [1721] = {.lex_state = 75, .external_lex_state = 5},
  [1722] = {.lex_state = 74, .external_lex_state = 3},
  [1723] = {.lex_state = 74, .external_lex_state = 3},
  [1724] = {.lex_state = 74, .external_lex_state = 4},
  [1725] = {.lex_state = 75, .external_lex_state = 5},
  [1726] = {.lex_state = 74, .external_lex_state = 3},
  [1727] = {.lex_state = 74, .external_lex_state = 4},
  [1728] = {.lex_state = 75, .external_lex_state = 5},
  [1729] = {.lex_state = 74, .external_lex_state = 4},
  [1730] = {.lex_state = 74, .external_lex_state = 4},
  [1731] = {.lex_state = 75, .external_lex_state = 5},
  [1732] = {.lex_state = 74, .external_lex_state = 4},
  [1733] = {.lex_state = 74, .external_lex_state = 4},
  [1734] = {.lex_state = 75, .external_lex_state = 5},
  [1735] = {.lex_state = 74, .external_lex_state = 4},
  [1736] = {.lex_state = 75, .external_lex_state = 5},
  [1737] = {.lex_state = 74, .external_lex_state = 4},
  [1738] = {.lex_state = 75, .external_lex_state = 5},
  [1739] = {.lex_state = 74, .external_lex_state = 3},
  [1740] = {.lex_state = 74, .external_lex_state = 3},
  [1741] = {.lex_state = 74, .external_lex_state = 3},
  [1742] = {.lex_state = 75, .external_lex_state = 5},
  [1743] = {.lex_state = 74, .external_lex_state = 3},
  [1744] = {.lex_state = 74, .external_lex_state = 3},
  [1745] = {.lex_state = 74, .external_lex_state = 3},
  [1746] = {.lex_state = 74, .external_lex_state = 3},
  [1747] = {.lex_state = 74, .external_lex_state = 3},
  [1748] = {.lex_state = 74, .external_lex_state = 3},
  [1749] = {.lex_state = 74, .external_lex_state = 3},
  [1750] = {.lex_state = 74, .external_lex_state = 4},
  [1751] = {.lex_state = 74, .external_lex_state = 3},
  [1752] = {.lex_state = 74, .external_lex_state = 3},
  [1753] = {.lex_state = 74, .external_lex_state = 3},
  [1754] = {.lex_state = 74, .external_lex_state = 3},
  [1755] = {.lex_state = 74, .external_lex_state = 3},
  [1756] = {.lex_state = 74, .external_lex_state = 3},
  [1757] = {.lex_state = 74, .external_lex_state = 3},
  [1758] = {.lex_state = 74, .external_lex_state = 3},
  [1759] = {.lex_state = 74, .external_lex_state = 3},
  [1760] = {.lex_state = 74, .external_lex_state = 3},
  [1761] = {.lex_state = 74, .external_lex_state = 3},
  [1762] = {.lex_state = 74, .external_lex_state = 3},
  [1763] = {.lex_state = 74, .external_lex_state = 3},
  [1764] = {.lex_state = 74, .external_lex_state = 3},
  [1765] = {.lex_state = 74, .external_lex_state = 3},
  [1766] = {.lex_state = 74, .external_lex_state = 4},
  [1767] = {.lex_state = 75, .external_lex_state = 5},
  [1768] = {.lex_state = 74, .external_lex_state = 3},
  [1769] = {.lex_state = 75, .external_lex_state = 5},
  [1770] = {.lex_state = 75, .external_lex_state = 5},
  [1771] = {.lex_state = 74, .external_lex_state = 4},
  [1772] = {.lex_state = 75, .external_lex_state = 5},
  [1773] = {.lex_state = 75, .external_lex_state = 5},
  [1774] = {.lex_state = 74, .external_lex_state = 4},
  [1775] = {.lex_state = 75, .external_lex_state = 5},
  [1776] = {.lex_state = 74, .external_lex_state = 3},
  [1777] = {.lex_state = 74, .external_lex_state = 3},
  [1778] = {.lex_state = 74, .external_lex_state = 3},
  [1779] = {.lex_state = 74, .external_lex_state = 3},
  [1780] = {.lex_state = 74, .external_lex_state = 4},
  [1781] = {.lex_state = 74, .external_lex_state = 4},
  [1782] = {.lex_state = 74, .external_lex_state = 4},
  [1783] = {.lex_state = 75, .external_lex_state = 5},
  [1784] = {.lex_state = 75, .external_lex_state = 5},
  [1785] = {.lex_state = 74, .external_lex_state = 4},
  [1786] = {.lex_state = 74, .external_lex_state = 4},
  [1787] = {.lex_state = 74, .external_lex_state = 3},
  [1788] = {.lex_state = 74, .external_lex_state = 4},
  [1789] = {.lex_state = 74, .external_lex_state = 4},
  [1790] = {.lex_state = 74, .external_lex_state = 4},
  [1791] = {.lex_state = 74, .external_lex_state = 4},
  [1792] = {.lex_state = 75, .external_lex_state = 5},
  [1793] = {.lex_state = 74, .external_lex_state = 3},
  [1794] = {.lex_state = 74, .external_lex_state = 3},
  [1795] = {.lex_state = 74, .external_lex_state = 4},
  [1796] = {.lex_state = 74, .external_lex_state = 4},
  [1797] = {.lex_state = 74, .external_lex_state = 3},
  [1798] = {.lex_state = 74, .external_lex_state = 4},
  [1799] = {.lex_state = 74, .external_lex_state = 3},
  [1800] = {.lex_state = 74, .external_lex_state = 4},
  [1801] = {.lex_state = 74, .external_lex_state = 4},
  [1802] = {.lex_state = 74, .external_lex_state = 4},
  [1803] = {.lex_state = 74, .external_lex_state = 4},
  [1804] = {.lex_state = 74, .external_lex_state = 4},
  [1805] = {.lex_state = 74, .external_lex_state = 4},
  [1806] = {.lex_state = 74, .external_lex_state = 4},
  [1807] = {.lex_state = 74, .external_lex_state = 4},
  [1808] = {.lex_state = 74, .external_lex_state = 4},
  [1809] = {.lex_state = 74, .external_lex_state = 4},
  [1810] = {.lex_state = 74, .external_lex_state = 4},
  [1811] = {.lex_state = 74, .external_lex_state = 4},
  [1812] = {.lex_state = 74, .external_lex_state = 4},
  [1813] = {.lex_state = 74, .external_lex_state = 3},
  [1814] = {.lex_state = 74, .external_lex_state = 4},
  [1815] = {.lex_state = 74, .external_lex_state = 4},
  [1816] = {.lex_state = 74, .external_lex_state = 3},
  [1817] = {.lex_state = 74, .external_lex_state = 4},
  [1818] = {.lex_state = 74, .external_lex_state = 4},
  [1819] = {.lex_state = 74, .external_lex_state = 4},
  [1820] = {.lex_state = 74, .external_lex_state = 4},
  [1821] = {.lex_state = 74, .external_lex_state = 4},
  [1822] = {.lex_state = 74, .external_lex_state = 4},
  [1823] = {.lex_state = 74, .external_lex_state = 4},
  [1824] = {.lex_state = 75, .external_lex_state = 5},
  [1825] = {.lex_state = 74, .external_lex_state = 3},
  [1826] = {.lex_state = 74, .external_lex_state = 4},
  [1827] = {.lex_state = 4, .external_lex_state = 3},
  [1828] = {.lex_state = 74, .external_lex_state = 4},
  [1829] = {.lex_state = 75, .external_lex_state = 5},
  [1830] = {.lex_state = 74, .external_lex_state = 4},
  [1831] = {.lex_state = 74, .external_lex_state = 4},
  [1832] = {.lex_state = 74, .external_lex_state = 3},
  [1833] = {.lex_state = 75, .external_lex_state = 5},
  [1834] = {.lex_state = 74, .external_lex_state = 4},
  [1835] = {.lex_state = 74, .external_lex_state = 4},
  [1836] = {.lex_state = 74, .external_lex_state = 4},
  [1837] = {.lex_state = 74, .external_lex_state = 4},
  [1838] = {.lex_state = 74, .external_lex_state = 4},
  [1839] = {.lex_state = 74, .external_lex_state = 4},
  [1840] = {.lex_state = 74, .external_lex_state = 4},
  [1841] = {.lex_state = 74, .external_lex_state = 4},
  [1842] = {.lex_state = 74, .external_lex_state = 4},
  [1843] = {.lex_state = 74, .external_lex_state = 4},
  [1844] = {.lex_state = 74, .external_lex_state = 4},
  [1845] = {.lex_state = 74, .external_lex_state = 4},
  [1846] = {.lex_state = 74, .external_lex_state = 4},
  [1847] = {.lex_state = 74, .external_lex_state = 4},
  [1848] = {.lex_state = 74, .external_lex_state = 4},
  [1849] = {.lex_state = 74, .external_lex_state = 4},
  [1850] = {.lex_state = 74, .external_lex_state = 4},
  [1851] = {.lex_state = 74, .external_lex_state = 4},
  [1852] = {.lex_state = 74, .external_lex_state = 4},
  [1853] = {.lex_state = 74, .external_lex_state = 4},
  [1854] = {.lex_state = 74, .external_lex_state = 4},
  [1855] = {.lex_state = 74, .external_lex_state = 4},
  [1856] = {.lex_state = 74, .external_lex_state = 4},
  [1857] = {.lex_state = 74, .external_lex_state = 4},
  [1858] = {.lex_state = 74, .external_lex_state = 4},
  [1859] = {.lex_state = 74, .external_lex_state = 4},
  [1860] = {.lex_state = 74, .external_lex_state = 4},
  [1861] = {.lex_state = 74, .external_lex_state = 4},
  [1862] = {.lex_state = 74, .external_lex_state = 4},
  [1863] = {.lex_state = 74, .external_lex_state = 4},
  [1864] = {.lex_state = 74, .external_lex_state = 3},
  [1865] = {.lex_state = 74, .external_lex_state = 4},
  [1866] = {.lex_state = 74, .external_lex_state = 4},
  [1867] = {.lex_state = 74, .external_lex_state = 3},
  [1868] = {.lex_state = 74, .external_lex_state = 4},
  [1869] = {.lex_state = 75, .external_lex_state = 5},
  [1870] = {.lex_state = 75, .external_lex_state = 5},
  [1871] = {.lex_state = 74, .external_lex_state = 4},
  [1872] = {.lex_state = 74, .external_lex_state = 4},
  [1873] = {.lex_state = 74, .external_lex_state = 4},
  [1874] = {.lex_state = 74, .external_lex_state = 4},
  [1875] = {.lex_state = 74, .external_lex_state = 4},
  [1876] = {.lex_state = 74, .external_lex_state = 4},
  [1877] = {.lex_state = 75, .external_lex_state = 2},
  [1878] = {.lex_state = 74, .external_lex_state = 4},
  [1879] = {.lex_state = 74, .external_lex_state = 4},
  [1880] = {.lex_state = 74, .external_lex_state = 4},
  [1881] = {.lex_state = 74, .external_lex_state = 4},
  [1882] = {.lex_state = 74, .external_lex_state = 4},
  [1883] = {.lex_state = 74, .external_lex_state = 4},
  [1884] = {.lex_state = 74, .external_lex_state = 4},
  [1885] = {.lex_state = 74, .external_lex_state = 4},
  [1886] = {.lex_state = 74, .external_lex_state = 3},
  [1887] = {.lex_state = 74, .external_lex_state = 3},
  [1888] = {.lex_state = 74, .external_lex_state = 3},
  [1889] = {.lex_state = 75, .external_lex_state = 2},
  [1890] = {.lex_state = 74, .external_lex_state = 3},
  [1891] = {.lex_state = 74, .external_lex_state = 3},
  [1892] = {.lex_state = 75, .external_lex_state = 5},
  [1893] = {.lex_state = 74, .external_lex_state = 4},
  [1894] = {.lex_state = 74, .external_lex_state = 4},
  [1895] = {.lex_state = 74, .external_lex_state = 3},
  [1896] = {.lex_state = 74, .external_lex_state = 3},
  [1897] = {.lex_state = 74, .external_lex_state = 3},
  [1898] = {.lex_state = 74, .external_lex_state = 3},
  [1899] = {.lex_state = 74, .external_lex_state = 3},
  [1900] = {.lex_state = 74, .external_lex_state = 3},
  [1901] = {.lex_state = 74, .external_lex_state = 3},
  [1902] = {.lex_state = 74, .external_lex_state = 4},
  [1903] = {.lex_state = 74, .external_lex_state = 3},
  [1904] = {.lex_state = 74, .external_lex_state = 3},
  [1905] = {.lex_state = 74, .external_lex_state = 4},
  [1906] = {.lex_state = 74, .external_lex_state = 3},
  [1907] = {.lex_state = 74, .external_lex_state = 3},
  [1908] = {.lex_state = 74, .external_lex_state = 3},
  [1909] = {.lex_state = 74, .external_lex_state = 4},
  [1910] = {.lex_state = 74, .external_lex_state = 4},
  [1911] = {.lex_state = 74, .external_lex_state = 4},
  [1912] = {.lex_state = 74, .external_lex_state = 4},
  [1913] = {.lex_state = 74, .external_lex_state = 3},
  [1914] = {.lex_state = 74, .external_lex_state = 3},
  [1915] = {.lex_state = 74, .external_lex_state = 4},
  [1916] = {.lex_state = 74, .external_lex_state = 4},
  [1917] = {.lex_state = 75, .external_lex_state = 2},
  [1918] = {.lex_state = 74, .external_lex_state = 4},
  [1919] = {.lex_state = 74, .external_lex_state = 3},
  [1920] = {.lex_state = 74, .external_lex_state = 4},
  [1921] = {.lex_state = 74, .external_lex_state = 4},
  [1922] = {.lex_state = 74, .external_lex_state = 3},
  [1923] = {.lex_state = 74, .external_lex_state = 3},
  [1924] = {.lex_state = 74, .external_lex_state = 3},
  [1925] = {.lex_state = 74, .external_lex_state = 4},
  [1926] = {.lex_state = 74, .external_lex_state = 4},
  [1927] = {.lex_state = 74, .external_lex_state = 3},
  [1928] = {.lex_state = 74, .external_lex_state = 4},
  [1929] = {.lex_state = 75, .external_lex_state = 5},
  [1930] = {.lex_state = 74, .external_lex_state = 3},
  [1931] = {.lex_state = 74, .external_lex_state = 4},
  [1932] = {.lex_state = 74, .external_lex_state = 3},
  [1933] = {.lex_state = 75, .external_lex_state = 5},
  [1934] = {.lex_state = 74, .external_lex_state = 3},
  [1935] = {.lex_state = 74, .external_lex_state = 4},
  [1936] = {.lex_state = 74, .external_lex_state = 3},
  [1937] = {.lex_state = 74, .external_lex_state = 4},
  [1938] = {.lex_state = 74, .external_lex_state = 4},
  [1939] = {.lex_state = 74, .external_lex_state = 4},
  [1940] = {.lex_state = 74, .external_lex_state = 4},
  [1941] = {.lex_state = 74, .external_lex_state = 4},
  [1942] = {.lex_state = 74, .external_lex_state = 4},
  [1943] = {.lex_state = 74, .external_lex_state = 4},
  [1944] = {.lex_state = 74, .external_lex_state = 4},
  [1945] = {.lex_state = 74, .external_lex_state = 4},
  [1946] = {.lex_state = 74, .external_lex_state = 3},
  [1947] = {.lex_state = 75, .external_lex_state = 2},
  [1948] = {.lex_state = 74, .external_lex_state = 4},
  [1949] = {.lex_state = 74, .external_lex_state = 3},
  [1950] = {.lex_state = 74, .external_lex_state = 3},
  [1951] = {.lex_state = 74, .external_lex_state = 4},
  [1952] = {.lex_state = 74, .external_lex_state = 4},
  [1953] = {.lex_state = 75, .external_lex_state = 2},
  [1954] = {.lex_state = 74, .external_lex_state = 3},
  [1955] = {.lex_state = 74, .external_lex_state = 3},
  [1956] = {.lex_state = 74, .external_lex_state = 4},
  [1957] = {.lex_state = 74, .external_lex_state = 4},
  [1958] = {.lex_state = 74, .external_lex_state = 4},
  [1959] = {.lex_state = 74, .external_lex_state = 3},
  [1960] = {.lex_state = 74, .external_lex_state = 3},
  [1961] = {.lex_state = 74, .external_lex_state = 4},
  [1962] = {.lex_state = 75, .external_lex_state = 2},
  [1963] = {.lex_state = 74, .external_lex_state = 4},
  [1964] = {.lex_state = 74, .external_lex_state = 4},
  [1965] = {.lex_state = 74, .external_lex_state = 4},
  [1966] = {.lex_state = 74, .external_lex_state = 4},
  [1967] = {.lex_state = 74, .external_lex_state = 4},
  [1968] = {.lex_state = 75, .external_lex_state = 5},
  [1969] = {.lex_state = 75, .external_lex_state = 5},
  [1970] = {.lex_state = 74, .external_lex_state = 4},
  [1971] = {.lex_state = 75, .external_lex_state = 5},
  [1972] = {.lex_state = 75, .external_lex_state = 5},
  [1973] = {.lex_state = 74, .external_lex_state = 4},
  [1974] = {.lex_state = 74, .external_lex_state = 4},
  [1975] = {.lex_state = 74, .external_lex_state = 4},
  [1976] = {.lex_state = 74, .external_lex_state = 3},
  [1977] = {.lex_state = 74, .external_lex_state = 4},
  [1978] = {.lex_state = 74, .external_lex_state = 4},
  [1979] = {.lex_state = 74, .external_lex_state = 4},
  [1980] = {.lex_state = 74, .external_lex_state = 4},
  [1981] = {.lex_state = 74, .external_lex_state = 4},
  [1982] = {.lex_state = 74, .external_lex_state = 4},
  [1983] = {.lex_state = 74, .external_lex_state = 4},
  [1984] = {.lex_state = 74, .external_lex_state = 4},
  [1985] = {.lex_state = 74, .external_lex_state = 4},
  [1986] = {.lex_state = 74, .external_lex_state = 4},
  [1987] = {.lex_state = 74, .external_lex_state = 4},
  [1988] = {.lex_state = 74, .external_lex_state = 4},
  [1989] = {.lex_state = 74, .external_lex_state = 4},
  [1990] = {.lex_state = 74, .external_lex_state = 4},
  [1991] = {.lex_state = 74, .external_lex_state = 4},
  [1992] = {.lex_state = 74, .external_lex_state = 4},
  [1993] = {.lex_state = 74, .external_lex_state = 4},
  [1994] = {.lex_state = 74, .external_lex_state = 4},
  [1995] = {.lex_state = 74, .external_lex_state = 4},
  [1996] = {.lex_state = 74, .external_lex_state = 4},
  [1997] = {.lex_state = 74, .external_lex_state = 4},
  [1998] = {.lex_state = 74, .external_lex_state = 4},
  [1999] = {.lex_state = 74, .external_lex_state = 4},
  [2000] = {.lex_state = 74, .external_lex_state = 4},
  [2001] = {.lex_state = 74, .external_lex_state = 4},
  [2002] = {.lex_state = 74, .external_lex_state = 3},
  [2003] = {.lex_state = 74, .external_lex_state = 3},
  [2004] = {.lex_state = 74, .external_lex_state = 4},
  [2005] = {.lex_state = 74, .external_lex_state = 4},
  [2006] = {.lex_state = 74, .external_lex_state = 4},
  [2007] = {.lex_state = 74, .external_lex_state = 4},
  [2008] = {.lex_state = 74, .external_lex_state = 4},
  [2009] = {.lex_state = 74, .external_lex_state = 4},
  [2010] = {.lex_state = 74, .external_lex_state = 4},
  [2011] = {.lex_state = 74, .external_lex_state = 4},
  [2012] = {.lex_state = 74, .external_lex_state = 4},
  [2013] = {.lex_state = 74, .external_lex_state = 4},
  [2014] = {.lex_state = 75, .external_lex_state = 5},
  [2015] = {.lex_state = 74, .external_lex_state = 4},
  [2016] = {.lex_state = 74, .external_lex_state = 4},
  [2017] = {.lex_state = 74, .external_lex_state = 4},
  [2018] = {.lex_state = 74, .external_lex_state = 4},
  [2019] = {.lex_state = 74, .external_lex_state = 4},
  [2020] = {.lex_state = 74, .external_lex_state = 3},
  [2021] = {.lex_state = 74, .external_lex_state = 4},
  [2022] = {.lex_state = 74, .external_lex_state = 4},
  [2023] = {.lex_state = 74, .external_lex_state = 4},
  [2024] = {.lex_state = 74, .external_lex_state = 4},
  [2025] = {.lex_state = 74, .external_lex_state = 3},
  [2026] = {.lex_state = 74, .external_lex_state = 4},
  [2027] = {.lex_state = 74, .external_lex_state = 3},
  [2028] = {.lex_state = 75, .external_lex_state = 2},
  [2029] = {.lex_state = 74, .external_lex_state = 4},
  [2030] = {.lex_state = 74, .external_lex_state = 4},
  [2031] = {.lex_state = 74, .external_lex_state = 4},
  [2032] = {.lex_state = 74, .external_lex_state = 4},
  [2033] = {.lex_state = 74, .external_lex_state = 4},
  [2034] = {.lex_state = 74, .external_lex_state = 3},
  [2035] = {.lex_state = 74, .external_lex_state = 3},
  [2036] = {.lex_state = 74, .external_lex_state = 4},
  [2037] = {.lex_state = 74, .external_lex_state = 4},
  [2038] = {.lex_state = 74, .external_lex_state = 4},
  [2039] = {.lex_state = 74, .external_lex_state = 4},
  [2040] = {.lex_state = 74, .external_lex_state = 4},
  [2041] = {.lex_state = 74, .external_lex_state = 3},
  [2042] = {.lex_state = 74, .external_lex_state = 4},
  [2043] = {.lex_state = 74, .external_lex_state = 4},
  [2044] = {.lex_state = 74, .external_lex_state = 4},
  [2045] = {.lex_state = 74, .external_lex_state = 4},
  [2046] = {.lex_state = 74, .external_lex_state = 4},
  [2047] = {.lex_state = 74, .external_lex_state = 4},
  [2048] = {.lex_state = 74, .external_lex_state = 4},
  [2049] = {.lex_state = 74, .external_lex_state = 4},
  [2050] = {.lex_state = 74, .external_lex_state = 4},
  [2051] = {.lex_state = 74, .external_lex_state = 4},
  [2052] = {.lex_state = 74, .external_lex_state = 4},
  [2053] = {.lex_state = 74, .external_lex_state = 4},
  [2054] = {.lex_state = 74, .external_lex_state = 4},
  [2055] = {.lex_state = 74, .external_lex_state = 4},
  [2056] = {.lex_state = 74, .external_lex_state = 4},
  [2057] = {.lex_state = 74, .external_lex_state = 4},
  [2058] = {.lex_state = 74, .external_lex_state = 4},
  [2059] = {.lex_state = 74, .external_lex_state = 4},
  [2060] = {.lex_state = 74, .external_lex_state = 4},
  [2061] = {.lex_state = 74, .external_lex_state = 4},
  [2062] = {.lex_state = 74, .external_lex_state = 4},
  [2063] = {.lex_state = 74, .external_lex_state = 4},
  [2064] = {.lex_state = 74, .external_lex_state = 4},
  [2065] = {.lex_state = 75, .external_lex_state = 5},
  [2066] = {.lex_state = 75, .external_lex_state = 5},
  [2067] = {.lex_state = 74, .external_lex_state = 4},
  [2068] = {.lex_state = 75, .external_lex_state = 5},
  [2069] = {.lex_state = 74, .external_lex_state = 4},
  [2070] = {.lex_state = 75, .external_lex_state = 5},
  [2071] = {.lex_state = 75, .external_lex_state = 5},
  [2072] = {.lex_state = 74, .external_lex_state = 4},
  [2073] = {.lex_state = 74, .external_lex_state = 4},
  [2074] = {.lex_state = 74, .external_lex_state = 4},
  [2075] = {.lex_state = 75, .external_lex_state = 2},
  [2076] = {.lex_state = 74, .external_lex_state = 4},
  [2077] = {.lex_state = 74, .external_lex_state = 4},
  [2078] = {.lex_state = 74, .external_lex_state = 4},
  [2079] = {.lex_state = 74, .external_lex_state = 4},
  [2080] = {.lex_state = 74, .external_lex_state = 3},
  [2081] = {.lex_state = 74, .external_lex_state = 3},
  [2082] = {.lex_state = 74, .external_lex_state = 3},
  [2083] = {.lex_state = 74, .external_lex_state = 3},
  [2084] = {.lex_state = 74, .external_lex_state = 3},
  [2085] = {.lex_state = 74, .external_lex_state = 3},
  [2086] = {.lex_state = 74, .external_lex_state = 3},
  [2087] = {.lex_state = 74, .external_lex_state = 3},
  [2088] = {.lex_state = 74, .external_lex_state = 3},
  [2089] = {.lex_state = 74, .external_lex_state = 3},
  [2090] = {.lex_state = 74, .external_lex_state = 3},
  [2091] = {.lex_state = 74, .external_lex_state = 3},
  [2092] = {.lex_state = 74, .external_lex_state = 3},
  [2093] = {.lex_state = 74, .external_lex_state = 3},
  [2094] = {.lex_state = 74, .external_lex_state = 3},
  [2095] = {.lex_state = 74, .external_lex_state = 3},
  [2096] = {.lex_state = 74, .external_lex_state = 3},
  [2097] = {.lex_state = 74, .external_lex_state = 3},
  [2098] = {.lex_state = 74, .external_lex_state = 3},
  [2099] = {.lex_state = 74, .external_lex_state = 3},
  [2100] = {.lex_state = 74, .external_lex_state = 3},
  [2101] = {.lex_state = 74, .external_lex_state = 3},
  [2102] = {.lex_state = 74, .external_lex_state = 3},
  [2103] = {.lex_state = 74, .external_lex_state = 3},
  [2104] = {.lex_state = 74, .external_lex_state = 3},
  [2105] = {.lex_state = 74, .external_lex_state = 3},
  [2106] = {.lex_state = 74, .external_lex_state = 3},
  [2107] = {.lex_state = 74, .external_lex_state = 3},
  [2108] = {.lex_state = 74, .external_lex_state = 3},
  [2109] = {.lex_state = 74, .external_lex_state = 3},
  [2110] = {.lex_state = 74, .external_lex_state = 4},
  [2111] = {.lex_state = 75, .external_lex_state = 5},
  [2112] = {.lex_state = 74, .external_lex_state = 3},
  [2113] = {.lex_state = 74, .external_lex_state = 3},
  [2114] = {.lex_state = 75, .external_lex_state = 5},
  [2115] = {.lex_state = 74, .external_lex_state = 4},
  [2116] = {.lex_state = 74, .external_lex_state = 4},
  [2117] = {.lex_state = 75, .external_lex_state = 5},
  [2118] = {.lex_state = 75, .external_lex_state = 5},
  [2119] = {.lex_state = 75, .external_lex_state = 5},
  [2120] = {.lex_state = 75, .external_lex_state = 5},
  [2121] = {.lex_state = 74, .external_lex_state = 3},
  [2122] = {.lex_state = 75, .external_lex_state = 5},
  [2123] = {.lex_state = 75, .external_lex_state = 5},
  [2124] = {.lex_state = 74, .external_lex_state = 3},
  [2125] = {.lex_state = 74, .external_lex_state = 3},
  [2126] = {.lex_state = 74, .external_lex_state = 3},
  [2127] = {.lex_state = 74, .external_lex_state = 3},
  [2128] = {.lex_state = 74, .external_lex_state = 3},
  [2129] = {.lex_state = 74, .external_lex_state = 3},
  [2130] = {.lex_state = 74, .external_lex_state = 4},
  [2131] = {.lex_state = 74, .external_lex_state = 4},
  [2132] = {.lex_state = 74, .external_lex_state = 4},
  [2133] = {.lex_state = 74, .external_lex_state = 4},
  [2134] = {.lex_state = 74, .external_lex_state = 4},
  [2135] = {.lex_state = 74, .external_lex_state = 3},
  [2136] = {.lex_state = 74, .external_lex_state = 4},
  [2137] = {.lex_state = 75, .external_lex_state = 5},
  [2138] = {.lex_state = 75, .external_lex_state = 5},
  [2139] = {.lex_state = 74, .external_lex_state = 4},
  [2140] = {.lex_state = 74, .external_lex_state = 4},
  [2141] = {.lex_state = 74, .external_lex_state = 4},
  [2142] = {.lex_state = 74, .external_lex_state = 3},
  [2143] = {.lex_state = 74, .external_lex_state = 4},
  [2144] = {.lex_state = 74, .external_lex_state = 3},
  [2145] = {.lex_state = 74, .external_lex_state = 4},
  [2146] = {.lex_state = 74, .external_lex_state = 4},
  [2147] = {.lex_state = 74, .external_lex_state = 4},
  [2148] = {.lex_state = 74, .external_lex_state = 4},
  [2149] = {.lex_state = 74, .external_lex_state = 4},
  [2150] = {.lex_state = 74, .external_lex_state = 4},
  [2151] = {.lex_state = 74, .external_lex_state = 4},
  [2152] = {.lex_state = 74, .external_lex_state = 4},
  [2153] = {.lex_state = 74, .external_lex_state = 4},
  [2154] = {.lex_state = 74, .external_lex_state = 4},
  [2155] = {.lex_state = 74, .external_lex_state = 4},
  [2156] = {.lex_state = 74, .external_lex_state = 4},
  [2157] = {.lex_state = 75, .external_lex_state = 5},
  [2158] = {.lex_state = 74, .external_lex_state = 4},
  [2159] = {.lex_state = 74, .external_lex_state = 4},
  [2160] = {.lex_state = 74, .external_lex_state = 4},
  [2161] = {.lex_state = 74, .external_lex_state = 4},
  [2162] = {.lex_state = 74, .external_lex_state = 4},
  [2163] = {.lex_state = 74, .external_lex_state = 4},
  [2164] = {.lex_state = 74, .external_lex_state = 4},
  [2165] = {.lex_state = 74, .external_lex_state = 4},
  [2166] = {.lex_state = 74, .external_lex_state = 3},
  [2167] = {.lex_state = 74, .external_lex_state = 4},
  [2168] = {.lex_state = 74, .external_lex_state = 4},
  [2169] = {.lex_state = 75, .external_lex_state = 2},
  [2170] = {.lex_state = 74, .external_lex_state = 4},
  [2171] = {.lex_state = 75, .external_lex_state = 5},
  [2172] = {.lex_state = 75, .external_lex_state = 2},
  [2173] = {.lex_state = 74, .external_lex_state = 4},
  [2174] = {.lex_state = 74, .external_lex_state = 3},
  [2175] = {.lex_state = 74, .external_lex_state = 3},
  [2176] = {.lex_state = 74, .external_lex_state = 3},
  [2177] = {.lex_state = 75, .external_lex_state = 5},
  [2178] = {.lex_state = 75, .external_lex_state = 5},
  [2179] = {.lex_state = 75, .external_lex_state = 5},
  [2180] = {.lex_state = 74, .external_lex_state = 4},
  [2181] = {.lex_state = 74, .external_lex_state = 4},
  [2182] = {.lex_state = 74, .external_lex_state = 4},
  [2183] = {.lex_state = 74, .external_lex_state = 3},
  [2184] = {.lex_state = 74, .external_lex_state = 4},
  [2185] = {.lex_state = 74, .external_lex_state = 4},
  [2186] = {.lex_state = 74, .external_lex_state = 4},
  [2187] = {.lex_state = 74, .external_lex_state = 4},
  [2188] = {.lex_state = 74, .external_lex_state = 3},
  [2189] = {.lex_state = 74, .external_lex_state = 4},
  [2190] = {.lex_state = 74, .external_lex_state = 4},
  [2191] = {.lex_state = 74, .external_lex_state = 4},
  [2192] = {.lex_state = 74, .external_lex_state = 4},
  [2193] = {.lex_state = 74, .external_lex_state = 4},
  [2194] = {.lex_state = 74, .external_lex_state = 4},
  [2195] = {.lex_state = 74, .external_lex_state = 4},
  [2196] = {.lex_state = 75, .external_lex_state = 5},
  [2197] = {.lex_state = 74, .external_lex_state = 4},
  [2198] = {.lex_state = 74, .external_lex_state = 4},
  [2199] = {.lex_state = 74, .external_lex_state = 4},
  [2200] = {.lex_state = 74, .external_lex_state = 4},
  [2201] = {.lex_state = 74, .external_lex_state = 4},
  [2202] = {.lex_state = 74, .external_lex_state = 4},
  [2203] = {.lex_state = 75, .external_lex_state = 5},
  [2204] = {.lex_state = 74, .external_lex_state = 4},
  [2205] = {.lex_state = 75, .external_lex_state = 5},
  [2206] = {.lex_state = 74, .external_lex_state = 4},
  [2207] = {.lex_state = 74, .external_lex_state = 4},
  [2208] = {.lex_state = 74, .external_lex_state = 3},
  [2209] = {.lex_state = 4, .external_lex_state = 4},
  [2210] = {.lex_state = 74, .external_lex_state = 4},
  [2211] = {.lex_state = 74, .external_lex_state = 4},
  [2212] = {.lex_state = 74, .external_lex_state = 3},
  [2213] = {.lex_state = 74, .external_lex_state = 3},
  [2214] = {.lex_state = 75, .external_lex_state = 2},
  [2215] = {.lex_state = 75, .external_lex_state = 5},
  [2216] = {.lex_state = 75, .external_lex_state = 5},
  [2217] = {.lex_state = 75, .external_lex_state = 2},
  [2218] = {.lex_state = 75, .external_lex_state = 2},
  [2219] = {.lex_state = 74, .external_lex_state = 3},
  [2220] = {.lex_state = 74, .external_lex_state = 4},
  [2221] = {.lex_state = 4, .external_lex_state = 4},
  [2222] = {.lex_state = 74, .external_lex_state = 4},
  [2223] = {.lex_state = 75, .external_lex_state = 2},
  [2224] = {.lex_state = 74, .external_lex_state = 4},
  [2225] = {.lex_state = 74, .external_lex_state = 3},
  [2226] = {.lex_state = 74, .external_lex_state = 3},
  [2227] = {.lex_state = 74, .external_lex_state = 3},
  [2228] = {.lex_state = 74, .external_lex_state = 4},
  [2229] = {.lex_state = 74, .external_lex_state = 3},
  [2230] = {.lex_state = 74, .external_lex_state = 4},
  [2231] = {.lex_state = 74, .external_lex_state = 3},
  [2232] = {.lex_state = 74, .external_lex_state = 3},
  [2233] = {.lex_state = 74, .external_lex_state = 3},
  [2234] = {.lex_state = 74, .external_lex_state = 4},
  [2235] = {.lex_state = 75, .external_lex_state = 5},
  [2236] = {.lex_state = 74, .external_lex_state = 3},
  [2237] = {.lex_state = 74, .external_lex_state = 3},
  [2238] = {.lex_state = 74, .external_lex_state = 3},
  [2239] = {.lex_state = 74, .external_lex_state = 4},
  [2240] = {.lex_state = 74, .external_lex_state = 4},
  [2241] = {.lex_state = 74, .external_lex_state = 4},
  [2242] = {.lex_state = 74, .external_lex_state = 4},
  [2243] = {.lex_state = 74, .external_lex_state = 3},
  [2244] = {.lex_state = 75, .external_lex_state = 5},
  [2245] = {.lex_state = 74, .external_lex_state = 4},
  [2246] = {.lex_state = 74, .external_lex_state = 4},
  [2247] = {.lex_state = 74, .external_lex_state = 4},
  [2248] = {.lex_state = 75, .external_lex_state = 5},
  [2249] = {.lex_state = 74, .external_lex_state = 4},
  [2250] = {.lex_state = 74, .external_lex_state = 3},
  [2251] = {.lex_state = 74, .external_lex_state = 4},
  [2252] = {.lex_state = 75, .external_lex_state = 5},
  [2253] = {.lex_state = 75, .external_lex_state = 5},
  [2254] = {.lex_state = 74, .external_lex_state = 4},
  [2255] = {.lex_state = 74, .external_lex_state = 4},
  [2256] = {.lex_state = 74, .external_lex_state = 4},
  [2257] = {.lex_state = 75, .external_lex_state = 5},
  [2258] = {.lex_state = 74, .external_lex_state = 4},
  [2259] = {.lex_state = 74, .external_lex_state = 4},
  [2260] = {.lex_state = 74, .external_lex_state = 4},
  [2261] = {.lex_state = 74, .external_lex_state = 3},
  [2262] = {.lex_state = 74, .external_lex_state = 4},
  [2263] = {.lex_state = 75, .external_lex_state = 5},
  [2264] = {.lex_state = 74, .external_lex_state = 3},
  [2265] = {.lex_state = 74, .external_lex_state = 4},
  [2266] = {.lex_state = 74, .external_lex_state = 4},
  [2267] = {.lex_state = 74, .external_lex_state = 4},
  [2268] = {.lex_state = 75, .external_lex_state = 5},
  [2269] = {.lex_state = 74, .external_lex_state = 3},
  [2270] = {.lex_state = 75, .external_lex_state = 5},
  [2271] = {.lex_state = 74, .external_lex_state = 3},
  [2272] = {.lex_state = 74, .external_lex_state = 3},
  [2273] = {.lex_state = 74, .external_lex_state = 3},
  [2274] = {.lex_state = 75, .external_lex_state = 5},
  [2275] = {.lex_state = 74, .external_lex_state = 3},
  [2276] = {.lex_state = 75, .external_lex_state = 5},
  [2277] = {.lex_state = 74, .external_lex_state = 4},
  [2278] = {.lex_state = 74, .external_lex_state = 3},
  [2279] = {.lex_state = 74, .external_lex_state = 4},
  [2280] = {.lex_state = 74, .external_lex_state = 4},
  [2281] = {.lex_state = 74, .external_lex_state = 4},
  [2282] = {.lex_state = 74, .external_lex_state = 4},
  [2283] = {.lex_state = 74, .external_lex_state = 4},
  [2284] = {.lex_state = 74, .external_lex_state = 4},
  [2285] = {.lex_state = 74, .external_lex_state = 3},
  [2286] = {.lex_state = 74, .external_lex_state = 4},
  [2287] = {.lex_state = 74, .external_lex_state = 3},
  [2288] = {.lex_state = 74, .external_lex_state = 3},
  [2289] = {.lex_state = 74, .external_lex_state = 3},
  [2290] = {.lex_state = 74, .external_lex_state = 3},
  [2291] = {.lex_state = 74, .external_lex_state = 3},
  [2292] = {.lex_state = 74, .external_lex_state = 3},
  [2293] = {.lex_state = 74, .external_lex_state = 3},
  [2294] = {.lex_state = 74, .external_lex_state = 3},
  [2295] = {.lex_state = 74, .external_lex_state = 3},
  [2296] = {.lex_state = 74, .external_lex_state = 3},
  [2297] = {.lex_state = 75, .external_lex_state = 5},
  [2298] = {.lex_state = 75, .external_lex_state = 5},
  [2299] = {.lex_state = 74, .external_lex_state = 3},
  [2300] = {.lex_state = 75, .external_lex_state = 5},
  [2301] = {.lex_state = 74, .external_lex_state = 3},
  [2302] = {.lex_state = 74, .external_lex_state = 4},
  [2303] = {.lex_state = 75, .external_lex_state = 5},
  [2304] = {.lex_state = 74, .external_lex_state = 4},
  [2305] = {.lex_state = 74, .external_lex_state = 3},
  [2306] = {.lex_state = 75, .external_lex_state = 5},
  [2307] = {.lex_state = 75, .external_lex_state = 5},
  [2308] = {.lex_state = 74, .external_lex_state = 3},
  [2309] = {.lex_state = 74, .external_lex_state = 4},
  [2310] = {.lex_state = 74, .external_lex_state = 4},
  [2311] = {.lex_state = 74, .external_lex_state = 3},
  [2312] = {.lex_state = 74, .external_lex_state = 3},
  [2313] = {.lex_state = 75, .external_lex_state = 5},
  [2314] = {.lex_state = 74, .external_lex_state = 3},
  [2315] = {.lex_state = 75, .external_lex_state = 2},
  [2316] = {.lex_state = 74, .external_lex_state = 3},
  [2317] = {.lex_state = 74, .external_lex_state = 4},
  [2318] = {.lex_state = 74, .external_lex_state = 4},
  [2319] = {.lex_state = 74, .external_lex_state = 4},
  [2320] = {.lex_state = 74, .external_lex_state = 4},
  [2321] = {.lex_state = 75, .external_lex_state = 2},
  [2322] = {.lex_state = 75, .external_lex_state = 2},
  [2323] = {.lex_state = 74, .external_lex_state = 4},
  [2324] = {.lex_state = 74, .external_lex_state = 4},
  [2325] = {.lex_state = 74, .external_lex_state = 4},
  [2326] = {.lex_state = 74, .external_lex_state = 4},
  [2327] = {.lex_state = 74, .external_lex_state = 4},
  [2328] = {.lex_state = 74, .external_lex_state = 3},
  [2329] = {.lex_state = 74, .external_lex_state = 3},
  [2330] = {.lex_state = 74, .external_lex_state = 3},
  [2331] = {.lex_state = 74, .external_lex_state = 3},
  [2332] = {.lex_state = 75, .external_lex_state = 2},
  [2333] = {.lex_state = 74, .external_lex_state = 4},
  [2334] = {.lex_state = 75, .external_lex_state = 2},
  [2335] = {.lex_state = 75, .external_lex_state = 5},
  [2336] = {.lex_state = 74, .external_lex_state = 3},
  [2337] = {.lex_state = 74, .external_lex_state = 3},
  [2338] = {.lex_state = 74, .external_lex_state = 3},
  [2339] = {.lex_state = 74, .external_lex_state = 3},
  [2340] = {.lex_state = 75, .external_lex_state = 5},
  [2341] = {.lex_state = 74, .external_lex_state = 3},
  [2342] = {.lex_state = 74, .external_lex_state = 4},
  [2343] = {.lex_state = 75, .external_lex_state = 2},
  [2344] = {.lex_state = 75, .external_lex_state = 2},
  [2345] = {.lex_state = 74, .external_lex_state = 4},
  [2346] = {.lex_state = 75, .external_lex_state = 2},
  [2347] = {.lex_state = 75, .external_lex_state = 5},
  [2348] = {.lex_state = 75, .external_lex_state = 5},
  [2349] = {.lex_state = 74, .external_lex_state = 3},
  [2350] = {.lex_state = 74, .external_lex_state = 3},
  [2351] = {.lex_state = 74, .external_lex_state = 3},
  [2352] = {.lex_state = 75, .external_lex_state = 5},
  [2353] = {.lex_state = 74, .external_lex_state = 4},
  [2354] = {.lex_state = 75, .external_lex_state = 5},
  [2355] = {.lex_state = 75, .external_lex_state = 5},
  [2356] = {.lex_state = 74, .external_lex_state = 4},
  [2357] = {.lex_state = 75, .external_lex_state = 5},
  [2358] = {.lex_state = 74, .external_lex_state = 4},
  [2359] = {.lex_state = 74, .external_lex_state = 3},
  [2360] = {.lex_state = 74, .external_lex_state = 3},
  [2361] = {.lex_state = 74, .external_lex_state = 3},
  [2362] = {.lex_state = 74, .external_lex_state = 3},
  [2363] = {.lex_state = 74, .external_lex_state = 3},
  [2364] = {.lex_state = 74, .external_lex_state = 3},
  [2365] = {.lex_state = 74, .external_lex_state = 3},
  [2366] = {.lex_state = 74, .external_lex_state = 3},
  [2367] = {.lex_state = 74, .external_lex_state = 3},
  [2368] = {.lex_state = 74, .external_lex_state = 3},
  [2369] = {.lex_state = 74, .external_lex_state = 3},
  [2370] = {.lex_state = 74, .external_lex_state = 3},
  [2371] = {.lex_state = 74, .external_lex_state = 3},
  [2372] = {.lex_state = 74, .external_lex_state = 4},
  [2373] = {.lex_state = 74, .external_lex_state = 3},
  [2374] = {.lex_state = 75, .external_lex_state = 2},
  [2375] = {.lex_state = 75, .external_lex_state = 5},
  [2376] = {.lex_state = 74, .external_lex_state = 3},
  [2377] = {.lex_state = 74, .external_lex_state = 4},
  [2378] = {.lex_state = 75, .external_lex_state = 2},
  [2379] = {.lex_state = 75, .external_lex_state = 5},
  [2380] = {.lex_state = 75, .external_lex_state = 5},
  [2381] = {.lex_state = 74, .external_lex_state = 4},
  [2382] = {.lex_state = 74, .external_lex_state = 3},
  [2383] = {.lex_state = 75, .external_lex_state = 5},
  [2384] = {.lex_state = 75, .external_lex_state = 2},
  [2385] = {.lex_state = 4, .external_lex_state = 3},
  [2386] = {.lex_state = 74, .external_lex_state = 3},
  [2387] = {.lex_state = 74, .external_lex_state = 3},
  [2388] = {.lex_state = 74, .external_lex_state = 3},
  [2389] = {.lex_state = 74, .external_lex_state = 3},
  [2390] = {.lex_state = 74, .external_lex_state = 3},
  [2391] = {.lex_state = 74, .external_lex_state = 3},
  [2392] = {.lex_state = 74, .external_lex_state = 3},
  [2393] = {.lex_state = 74, .external_lex_state = 3},
  [2394] = {.lex_state = 74, .external_lex_state = 3},
  [2395] = {.lex_state = 74, .external_lex_state = 3},
  [2396] = {.lex_state = 74, .external_lex_state = 3},
  [2397] = {.lex_state = 75, .external_lex_state = 2},
  [2398] = {.lex_state = 75, .external_lex_state = 5},
  [2399] = {.lex_state = 74, .external_lex_state = 3},
  [2400] = {.lex_state = 74, .external_lex_state = 3},
  [2401] = {.lex_state = 75, .external_lex_state = 5},
  [2402] = {.lex_state = 74, .external_lex_state = 3},
  [2403] = {.lex_state = 74, .external_lex_state = 3},
  [2404] = {.lex_state = 74, .external_lex_state = 3},
  [2405] = {.lex_state = 74, .external_lex_state = 3},
  [2406] = {.lex_state = 74, .external_lex_state = 3},
  [2407] = {.lex_state = 74, .external_lex_state = 3},
  [2408] = {.lex_state = 74, .external_lex_state = 3},
  [2409] = {.lex_state = 74, .external_lex_state = 3},
  [2410] = {.lex_state = 74, .external_lex_state = 3},
  [2411] = {.lex_state = 74, .external_lex_state = 4},
  [2412] = {.lex_state = 74, .external_lex_state = 3},
  [2413] = {.lex_state = 74, .external_lex_state = 3},
  [2414] = {.lex_state = 74, .external_lex_state = 3},
  [2415] = {.lex_state = 74, .external_lex_state = 3},
  [2416] = {.lex_state = 74, .external_lex_state = 3},
  [2417] = {.lex_state = 74, .external_lex_state = 3},
  [2418] = {.lex_state = 74, .external_lex_state = 3},
  [2419] = {.lex_state = 74, .external_lex_state = 3},
  [2420] = {.lex_state = 74, .external_lex_state = 3},
  [2421] = {.lex_state = 74, .external_lex_state = 3},
  [2422] = {.lex_state = 74, .external_lex_state = 3},
  [2423] = {.lex_state = 74, .external_lex_state = 3},
  [2424] = {.lex_state = 74, .external_lex_state = 3},
  [2425] = {.lex_state = 74, .external_lex_state = 3},
  [2426] = {.lex_state = 74, .external_lex_state = 3},
  [2427] = {.lex_state = 74, .external_lex_state = 3},
  [2428] = {.lex_state = 75, .external_lex_state = 5},
  [2429] = {.lex_state = 75, .external_lex_state = 2},
  [2430] = {.lex_state = 74, .external_lex_state = 3},
  [2431] = {.lex_state = 75, .external_lex_state = 5},
  [2432] = {.lex_state = 74, .external_lex_state = 3},
  [2433] = {.lex_state = 74, .external_lex_state = 3},
  [2434] = {.lex_state = 75, .external_lex_state = 5},
  [2435] = {.lex_state = 74, .external_lex_state = 4},
  [2436] = {.lex_state = 74, .external_lex_state = 3},
  [2437] = {.lex_state = 75, .external_lex_state = 5},
  [2438] = {.lex_state = 75, .external_lex_state = 2},
  [2439] = {.lex_state = 74, .external_lex_state = 3},
  [2440] = {.lex_state = 75, .external_lex_state = 5},
  [2441] = {.lex_state = 74, .external_lex_state = 4},
  [2442] = {.lex_state = 74, .external_lex_state = 3},
  [2443] = {.lex_state = 75, .external_lex_state = 5},
  [2444] = {.lex_state = 75, .external_lex_state = 5},
  [2445] = {.lex_state = 75, .external_lex_state = 2},
  [2446] = {.lex_state = 74, .external_lex_state = 3},
  [2447] = {.lex_state = 74, .external_lex_state = 3},
  [2448] = {.lex_state = 74, .external_lex_state = 3},
  [2449] = {.lex_state = 74, .external_lex_state = 3},
  [2450] = {.lex_state = 74, .external_lex_state = 3},
  [2451] = {.lex_state = 75, .external_lex_state = 5},
  [2452] = {.lex_state = 75, .external_lex_state = 5},
  [2453] = {.lex_state = 74, .external_lex_state = 4},
  [2454] = {.lex_state = 74, .external_lex_state = 4},
  [2455] = {.lex_state = 75, .external_lex_state = 5},
  [2456] = {.lex_state = 74, .external_lex_state = 3},
  [2457] = {.lex_state = 75, .external_lex_state = 2},
  [2458] = {.lex_state = 74, .external_lex_state = 3},
  [2459] = {.lex_state = 75, .external_lex_state = 5},
  [2460] = {.lex_state = 74, .external_lex_state = 3},
  [2461] = {.lex_state = 75, .external_lex_state = 5},
  [2462] = {.lex_state = 74, .external_lex_state = 3},
  [2463] = {.lex_state = 75, .external_lex_state = 5},
  [2464] = {.lex_state = 74, .external_lex_state = 3},
  [2465] = {.lex_state = 74, .external_lex_state = 3},
  [2466] = {.lex_state = 75, .external_lex_state = 5},
  [2467] = {.lex_state = 74, .external_lex_state = 3},
  [2468] = {.lex_state = 74, .external_lex_state = 3},
  [2469] = {.lex_state = 74, .external_lex_state = 3},
  [2470] = {.lex_state = 74, .external_lex_state = 3},
  [2471] = {.lex_state = 74, .external_lex_state = 3},
  [2472] = {.lex_state = 74, .external_lex_state = 3},
  [2473] = {.lex_state = 75, .external_lex_state = 2},
  [2474] = {.lex_state = 74, .external_lex_state = 3},
  [2475] = {.lex_state = 75, .external_lex_state = 5},
  [2476] = {.lex_state = 74, .external_lex_state = 4},
  [2477] = {.lex_state = 74, .external_lex_state = 4},
  [2478] = {.lex_state = 75, .external_lex_state = 2},
  [2479] = {.lex_state = 74, .external_lex_state = 3},
  [2480] = {.lex_state = 74, .external_lex_state = 4},
  [2481] = {.lex_state = 74, .external_lex_state = 3},
  [2482] = {.lex_state = 74, .external_lex_state = 3},
  [2483] = {.lex_state = 74, .external_lex_state = 3},
  [2484] = {.lex_state = 74, .external_lex_state = 3},
  [2485] = {.lex_state = 74, .external_lex_state = 3},
  [2486] = {.lex_state = 74, .external_lex_state = 3},
  [2487] = {.lex_state = 74, .external_lex_state = 3},
  [2488] = {.lex_state = 74, .external_lex_state = 3},
  [2489] = {.lex_state = 74, .external_lex_state = 3},
  [2490] = {.lex_state = 74, .external_lex_state = 3},
  [2491] = {.lex_state = 74, .external_lex_state = 3},
  [2492] = {.lex_state = 74, .external_lex_state = 3},
  [2493] = {.lex_state = 74, .external_lex_state = 3},
  [2494] = {.lex_state = 74, .external_lex_state = 3},
  [2495] = {.lex_state = 74, .external_lex_state = 3},
  [2496] = {.lex_state = 74, .external_lex_state = 3},
  [2497] = {.lex_state = 74, .external_lex_state = 3},
  [2498] = {.lex_state = 74, .external_lex_state = 3},
  [2499] = {.lex_state = 74, .external_lex_state = 3},
  [2500] = {.lex_state = 74, .external_lex_state = 3},
  [2501] = {.lex_state = 74, .external_lex_state = 3},
  [2502] = {.lex_state = 74, .external_lex_state = 3},
  [2503] = {.lex_state = 74, .external_lex_state = 3},
  [2504] = {.lex_state = 74, .external_lex_state = 3},
  [2505] = {.lex_state = 74, .external_lex_state = 3},
  [2506] = {.lex_state = 74, .external_lex_state = 3},
  [2507] = {.lex_state = 74, .external_lex_state = 3},
  [2508] = {.lex_state = 74, .external_lex_state = 3},
  [2509] = {.lex_state = 74, .external_lex_state = 3},
  [2510] = {.lex_state = 75, .external_lex_state = 5},
  [2511] = {.lex_state = 74, .external_lex_state = 3},
  [2512] = {.lex_state = 74, .external_lex_state = 3},
  [2513] = {.lex_state = 74, .external_lex_state = 4},
  [2514] = {.lex_state = 74, .external_lex_state = 3},
  [2515] = {.lex_state = 74, .external_lex_state = 3},
  [2516] = {.lex_state = 74, .external_lex_state = 3},
  [2517] = {.lex_state = 74, .external_lex_state = 3},
  [2518] = {.lex_state = 74, .external_lex_state = 3},
  [2519] = {.lex_state = 74, .external_lex_state = 3},
  [2520] = {.lex_state = 75, .external_lex_state = 5},
  [2521] = {.lex_state = 74, .external_lex_state = 3},
  [2522] = {.lex_state = 74, .external_lex_state = 3},
  [2523] = {.lex_state = 74, .external_lex_state = 3},
  [2524] = {.lex_state = 75, .external_lex_state = 5},
  [2525] = {.lex_state = 75, .external_lex_state = 2},
  [2526] = {.lex_state = 75, .external_lex_state = 5},
  [2527] = {.lex_state = 74, .external_lex_state = 3},
  [2528] = {.lex_state = 74, .external_lex_state = 3},
  [2529] = {.lex_state = 74, .external_lex_state = 3},
  [2530] = {.lex_state = 74, .external_lex_state = 3},
  [2531] = {.lex_state = 74, .external_lex_state = 3},
  [2532] = {.lex_state = 74, .external_lex_state = 3},
  [2533] = {.lex_state = 74, .external_lex_state = 3},
  [2534] = {.lex_state = 74, .external_lex_state = 3},
  [2535] = {.lex_state = 74, .external_lex_state = 3},
  [2536] = {.lex_state = 74, .external_lex_state = 3},
  [2537] = {.lex_state = 74, .external_lex_state = 3},
  [2538] = {.lex_state = 74, .external_lex_state = 3},
  [2539] = {.lex_state = 74, .external_lex_state = 3},
  [2540] = {.lex_state = 74, .external_lex_state = 3},
  [2541] = {.lex_state = 74, .external_lex_state = 3},
  [2542] = {.lex_state = 74, .external_lex_state = 3},
  [2543] = {.lex_state = 74, .external_lex_state = 3},
  [2544] = {.lex_state = 74, .external_lex_state = 3},
  [2545] = {.lex_state = 74, .external_lex_state = 3},
  [2546] = {.lex_state = 74, .external_lex_state = 3},
  [2547] = {.lex_state = 74, .external_lex_state = 3},
  [2548] = {.lex_state = 74, .external_lex_state = 3},
  [2549] = {.lex_state = 74, .external_lex_state = 3},
  [2550] = {.lex_state = 74, .external_lex_state = 3},
  [2551] = {.lex_state = 74, .external_lex_state = 3},
  [2552] = {.lex_state = 74, .external_lex_state = 3},
  [2553] = {.lex_state = 74, .external_lex_state = 3},
  [2554] = {.lex_state = 75, .external_lex_state = 5},
  [2555] = {.lex_state = 75, .external_lex_state = 5},
  [2556] = {.lex_state = 75, .external_lex_state = 2},
  [2557] = {.lex_state = 74, .external_lex_state = 3},
  [2558] = {.lex_state = 74, .external_lex_state = 3},
  [2559] = {.lex_state = 74, .external_lex_state = 3},
  [2560] = {.lex_state = 74, .external_lex_state = 3},
  [2561] = {.lex_state = 75, .external_lex_state = 2},
  [2562] = {.lex_state = 74, .external_lex_state = 3},
  [2563] = {.lex_state = 75, .external_lex_state = 2},
  [2564] = {.lex_state = 74, .external_lex_state = 3},
  [2565] = {.lex_state = 74, .external_lex_state = 3},
  [2566] = {.lex_state = 74, .external_lex_state = 3},
  [2567] = {.lex_state = 74, .external_lex_state = 3},
  [2568] = {.lex_state = 74, .external_lex_state = 3},
  [2569] = {.lex_state = 75, .external_lex_state = 2},
  [2570] = {.lex_state = 75, .external_lex_state = 2},
  [2571] = {.lex_state = 74, .external_lex_state = 3},
  [2572] = {.lex_state = 74, .external_lex_state = 3},
  [2573] = {.lex_state = 74, .external_lex_state = 3},
  [2574] = {.lex_state = 74, .external_lex_state = 3},
  [2575] = {.lex_state = 74, .external_lex_state = 3},
  [2576] = {.lex_state = 74, .external_lex_state = 3},
  [2577] = {.lex_state = 74, .external_lex_state = 3},
  [2578] = {.lex_state = 74, .external_lex_state = 3},
  [2579] = {.lex_state = 74, .external_lex_state = 3},
  [2580] = {.lex_state = 74, .external_lex_state = 3},
  [2581] = {.lex_state = 75, .external_lex_state = 2},
  [2582] = {.lex_state = 75, .external_lex_state = 2},
  [2583] = {.lex_state = 75, .external_lex_state = 5},
  [2584] = {.lex_state = 75, .external_lex_state = 5},
  [2585] = {.lex_state = 75, .external_lex_state = 5},
  [2586] = {.lex_state = 75, .external_lex_state = 5},
  [2587] = {.lex_state = 74, .external_lex_state = 3},
  [2588] = {.lex_state = 74, .external_lex_state = 3},
  [2589] = {.lex_state = 74, .external_lex_state = 3},
  [2590] = {.lex_state = 74, .external_lex_state = 3},
  [2591] = {.lex_state = 74, .external_lex_state = 3},
  [2592] = {.lex_state = 74, .external_lex_state = 3},
  [2593] = {.lex_state = 75, .external_lex_state = 5},
  [2594] = {.lex_state = 75, .external_lex_state = 5},
  [2595] = {.lex_state = 74, .external_lex_state = 3},
  [2596] = {.lex_state = 74, .external_lex_state = 3},
  [2597] = {.lex_state = 74, .external_lex_state = 3},
  [2598] = {.lex_state = 74, .external_lex_state = 3},
  [2599] = {.lex_state = 74, .external_lex_state = 4},
  [2600] = {.lex_state = 75, .external_lex_state = 5},
  [2601] = {.lex_state = 74, .external_lex_state = 3},
  [2602] = {.lex_state = 75, .external_lex_state = 5},
  [2603] = {.lex_state = 74, .external_lex_state = 3},
  [2604] = {.lex_state = 74, .external_lex_state = 3},
  [2605] = {.lex_state = 74, .external_lex_state = 3},
  [2606] = {.lex_state = 74, .external_lex_state = 3},
  [2607] = {.lex_state = 75, .external_lex_state = 5},
  [2608] = {.lex_state = 74, .external_lex_state = 3},
  [2609] = {.lex_state = 75, .external_lex_state = 2},
  [2610] = {.lex_state = 75, .external_lex_state = 2},
  [2611] = {.lex_state = 74, .external_lex_state = 3},
  [2612] = {.lex_state = 75, .external_lex_state = 5},
  [2613] = {.lex_state = 75, .external_lex_state = 2},
  [2614] = {.lex_state = 75, .external_lex_state = 2},
  [2615] = {.lex_state = 75, .external_lex_state = 2},
  [2616] = {.lex_state = 75, .external_lex_state = 2},
  [2617] = {.lex_state = 75, .external_lex_state = 2},
  [2618] = {.lex_state = 75, .external_lex_state = 2},
  [2619] = {.lex_state = 75, .external_lex_state = 5},
  [2620] = {.lex_state = 75, .external_lex_state = 2},
  [2621] = {.lex_state = 75, .external_lex_state = 2},
  [2622] = {.lex_state = 74, .external_lex_state = 3},
  [2623] = {.lex_state = 75, .external_lex_state = 2},
  [2624] = {.lex_state = 75, .external_lex_state = 5},
  [2625] = {.lex_state = 75, .external_lex_state = 5},
  [2626] = {.lex_state = 75, .external_lex_state = 2},
  [2627] = {.lex_state = 75, .external_lex_state = 2},
  [2628] = {.lex_state = 75, .external_lex_state = 2},
  [2629] = {.lex_state = 75, .external_lex_state = 2},
  [2630] = {.lex_state = 75, .external_lex_state = 2},
  [2631] = {.lex_state = 75, .external_lex_state = 5},
  [2632] = {.lex_state = 75, .external_lex_state = 5},
  [2633] = {.lex_state = 75, .external_lex_state = 5},
  [2634] = {.lex_state = 75, .external_lex_state = 5},
  [2635] = {.lex_state = 75, .external_lex_state = 5},
  [2636] = {.lex_state = 75, .external_lex_state = 5},
  [2637] = {.lex_state = 75, .external_lex_state = 5},
  [2638] = {.lex_state = 4, .external_lex_state = 3},
  [2639] = {.lex_state = 75, .external_lex_state = 5},
  [2640] = {.lex_state = 75, .external_lex_state = 5},
  [2641] = {.lex_state = 75, .external_lex_state = 5},
  [2642] = {.lex_state = 74, .external_lex_state = 3},
  [2643] = {.lex_state = 74, .external_lex_state = 3},
  [2644] = {.lex_state = 74, .external_lex_state = 3},
  [2645] = {.lex_state = 75, .external_lex_state = 5},
  [2646] = {.lex_state = 74, .external_lex_state = 3},
  [2647] = {.lex_state = 75, .external_lex_state = 5},
  [2648] = {.lex_state = 9, .external_lex_state = 5},
  [2649] = {.lex_state = 9, .external_lex_state = 5},
  [2650] = {.lex_state = 9, .external_lex_state = 5},
  [2651] = {.lex_state = 9, .external_lex_state = 5},
  [2652] = {.lex_state = 74, .external_lex_state = 3},
  [2653] = {.lex_state = 9, .external_lex_state = 5},
  [2654] = {.lex_state = 9, .external_lex_state = 5},
  [2655] = {.lex_state = 9, .external_lex_state = 5},
  [2656] = {.lex_state = 9, .external_lex_state = 5},
  [2657] = {.lex_state = 9, .external_lex_state = 5},
  [2658] = {.lex_state = 9, .external_lex_state = 5},
  [2659] = {.lex_state = 9, .external_lex_state = 5},
  [2660] = {.lex_state = 9, .external_lex_state = 5},
  [2661] = {.lex_state = 9, .external_lex_state = 5},
  [2662] = {.lex_state = 9, .external_lex_state = 5},
  [2663] = {.lex_state = 9, .external_lex_state = 5},
  [2664] = {.lex_state = 9, .external_lex_state = 5},
  [2665] = {.lex_state = 9, .external_lex_state = 5},
  [2666] = {.lex_state = 9, .external_lex_state = 5},
  [2667] = {.lex_state = 74, .external_lex_state = 3},
  [2668] = {.lex_state = 9, .external_lex_state = 5},
  [2669] = {.lex_state = 9, .external_lex_state = 5},
  [2670] = {.lex_state = 9, .external_lex_state = 5},
  [2671] = {.lex_state = 9, .external_lex_state = 5},
  [2672] = {.lex_state = 9, .external_lex_state = 5},
  [2673] = {.lex_state = 9, .external_lex_state = 5},
  [2674] = {.lex_state = 9, .external_lex_state = 5},
  [2675] = {.lex_state = 74, .external_lex_state = 3},
  [2676] = {.lex_state = 74, .external_lex_state = 3},
  [2677] = {.lex_state = 74, .external_lex_state = 3},
  [2678] = {.lex_state = 9, .external_lex_state = 5},
  [2679] = {.lex_state = 9, .external_lex_state = 5},
  [2680] = {.lex_state = 9, .external_lex_state = 5},
  [2681] = {.lex_state = 9, .external_lex_state = 5},
  [2682] = {.lex_state = 74, .external_lex_state = 3},
  [2683] = {.lex_state = 75, .external_lex_state = 2},
  [2684] = {.lex_state = 9, .external_lex_state = 5},
  [2685] = {.lex_state = 9, .external_lex_state = 5},
  [2686] = {.lex_state = 74, .external_lex_state = 3},
  [2687] = {.lex_state = 9, .external_lex_state = 5},
  [2688] = {.lex_state = 9, .external_lex_state = 5},
  [2689] = {.lex_state = 74, .external_lex_state = 3},
  [2690] = {.lex_state = 9, .external_lex_state = 5},
  [2691] = {.lex_state = 9, .external_lex_state = 5},
  [2692] = {.lex_state = 9, .external_lex_state = 5},
  [2693] = {.lex_state = 9, .external_lex_state = 5},
  [2694] = {.lex_state = 74, .external_lex_state = 3},
  [2695] = {.lex_state = 9, .external_lex_state = 5},
  [2696] = {.lex_state = 9, .external_lex_state = 5},
  [2697] = {.lex_state = 9, .external_lex_state = 5},
  [2698] = {.lex_state = 9, .external_lex_state = 5},
  [2699] = {.lex_state = 9, .external_lex_state = 5},
  [2700] = {.lex_state = 9, .external_lex_state = 5},
  [2701] = {.lex_state = 9, .external_lex_state = 5},
  [2702] = {.lex_state = 9, .external_lex_state = 5},
  [2703] = {.lex_state = 9, .external_lex_state = 5},
  [2704] = {.lex_state = 9, .external_lex_state = 5},
  [2705] = {.lex_state = 9, .external_lex_state = 5},
  [2706] = {.lex_state = 74, .external_lex_state = 3},
  [2707] = {.lex_state = 9, .external_lex_state = 5},
  [2708] = {.lex_state = 9, .external_lex_state = 5},
  [2709] = {.lex_state = 74, .external_lex_state = 3},
  [2710] = {.lex_state = 9, .external_lex_state = 5},
  [2711] = {.lex_state = 75, .external_lex_state = 2},
  [2712] = {.lex_state = 9, .external_lex_state = 5},
  [2713] = {.lex_state = 75, .external_lex_state = 2},
  [2714] = {.lex_state = 75, .external_lex_state = 2},
  [2715] = {.lex_state = 9, .external_lex_state = 2},
  [2716] = {.lex_state = 9, .external_lex_state = 2},
  [2717] = {.lex_state = 9, .external_lex_state = 2},
  [2718] = {.lex_state = 9, .external_lex_state = 2},
  [2719] = {.lex_state = 74, .external_lex_state = 3},
  [2720] = {.lex_state = 9, .external_lex_state = 2},
  [2721] = {.lex_state = 9, .external_lex_state = 2},
  [2722] = {.lex_state = 75, .external_lex_state = 2},
  [2723] = {.lex_state = 9, .external_lex_state = 2},
  [2724] = {.lex_state = 75, .external_lex_state = 2},
  [2725] = {.lex_state = 75, .external_lex_state = 2},
  [2726] = {.lex_state = 75, .external_lex_state = 2},
  [2727] = {.lex_state = 75, .external_lex_state = 2},
  [2728] = {.lex_state = 75, .external_lex_state = 2},
  [2729] = {.lex_state = 75, .external_lex_state = 2},
  [2730] = {.lex_state = 75, .external_lex_state = 2},
  [2731] = {.lex_state = 75, .external_lex_state = 2},
  [2732] = {.lex_state = 75, .external_lex_state = 2},
  [2733] = {.lex_state = 75, .external_lex_state = 2},
  [2734] = {.lex_state = 75, .external_lex_state = 2},
  [2735] = {.lex_state = 75, .external_lex_state = 2},
  [2736] = {.lex_state = 75, .external_lex_state = 2},
  [2737] = {.lex_state = 75, .external_lex_state = 2},
  [2738] = {.lex_state = 75, .external_lex_state = 2},
  [2739] = {.lex_state = 75, .external_lex_state = 2},
  [2740] = {.lex_state = 75, .external_lex_state = 2},
  [2741] = {.lex_state = 75, .external_lex_state = 2},
  [2742] = {.lex_state = 75, .external_lex_state = 2},
  [2743] = {.lex_state = 75, .external_lex_state = 2},
  [2744] = {.lex_state = 75, .external_lex_state = 2},
  [2745] = {.lex_state = 75, .external_lex_state = 2},
  [2746] = {.lex_state = 75, .external_lex_state = 2},
  [2747] = {.lex_state = 75, .external_lex_state = 2},
  [2748] = {.lex_state = 75, .external_lex_state = 2},
  [2749] = {.lex_state = 75, .external_lex_state = 2},
  [2750] = {.lex_state = 75, .external_lex_state = 2},
  [2751] = {.lex_state = 75, .external_lex_state = 2},
  [2752] = {.lex_state = 75, .external_lex_state = 2},
  [2753] = {.lex_state = 75, .external_lex_state = 2},
  [2754] = {.lex_state = 75, .external_lex_state = 2},
  [2755] = {.lex_state = 75, .external_lex_state = 2},
  [2756] = {.lex_state = 75, .external_lex_state = 2},
  [2757] = {.lex_state = 75, .external_lex_state = 2},
  [2758] = {.lex_state = 75, .external_lex_state = 2},
  [2759] = {.lex_state = 75, .external_lex_state = 2},
  [2760] = {.lex_state = 75, .external_lex_state = 2},
  [2761] = {.lex_state = 75, .external_lex_state = 2},
  [2762] = {.lex_state = 75, .external_lex_state = 2},
  [2763] = {.lex_state = 75, .external_lex_state = 2},
  [2764] = {.lex_state = 75, .external_lex_state = 2},
  [2765] = {.lex_state = 75, .external_lex_state = 2},
  [2766] = {.lex_state = 75, .external_lex_state = 2},
  [2767] = {.lex_state = 75, .external_lex_state = 2},
  [2768] = {.lex_state = 75, .external_lex_state = 2},
  [2769] = {.lex_state = 75, .external_lex_state = 2},
  [2770] = {.lex_state = 75, .external_lex_state = 2},
  [2771] = {.lex_state = 75, .external_lex_state = 2},
  [2772] = {.lex_state = 75, .external_lex_state = 2},
  [2773] = {.lex_state = 75, .external_lex_state = 2},
  [2774] = {.lex_state = 75, .external_lex_state = 2},
  [2775] = {.lex_state = 75, .external_lex_state = 2},
  [2776] = {.lex_state = 75, .external_lex_state = 2},
  [2777] = {.lex_state = 75, .external_lex_state = 2},
  [2778] = {.lex_state = 75, .external_lex_state = 2},
  [2779] = {.lex_state = 75, .external_lex_state = 2},
  [2780] = {.lex_state = 75, .external_lex_state = 2},
  [2781] = {.lex_state = 75, .external_lex_state = 2},
  [2782] = {.lex_state = 75, .external_lex_state = 2},
  [2783] = {.lex_state = 75, .external_lex_state = 2},
  [2784] = {.lex_state = 75, .external_lex_state = 2},
  [2785] = {.lex_state = 75, .external_lex_state = 2},
  [2786] = {.lex_state = 75, .external_lex_state = 2},
  [2787] = {.lex_state = 75, .external_lex_state = 2},
  [2788] = {.lex_state = 75, .external_lex_state = 2},
  [2789] = {.lex_state = 75, .external_lex_state = 2},
  [2790] = {.lex_state = 75, .external_lex_state = 2},
  [2791] = {.lex_state = 75, .external_lex_state = 2},
  [2792] = {.lex_state = 75, .external_lex_state = 2},
  [2793] = {.lex_state = 75, .external_lex_state = 2},
  [2794] = {.lex_state = 75, .external_lex_state = 2},
  [2795] = {.lex_state = 75, .external_lex_state = 2},
  [2796] = {.lex_state = 75, .external_lex_state = 2},
  [2797] = {.lex_state = 75, .external_lex_state = 2},
  [2798] = {.lex_state = 75, .external_lex_state = 2},
  [2799] = {.lex_state = 75, .external_lex_state = 2},
  [2800] = {.lex_state = 75, .external_lex_state = 2},
  [2801] = {.lex_state = 75, .external_lex_state = 2},
  [2802] = {.lex_state = 75, .external_lex_state = 2},
  [2803] = {.lex_state = 75, .external_lex_state = 2},
  [2804] = {.lex_state = 75, .external_lex_state = 2},
  [2805] = {.lex_state = 75, .external_lex_state = 2},
  [2806] = {.lex_state = 75, .external_lex_state = 2},
  [2807] = {.lex_state = 75, .external_lex_state = 2},
  [2808] = {.lex_state = 75, .external_lex_state = 2},
  [2809] = {.lex_state = 75, .external_lex_state = 2},
  [2810] = {.lex_state = 75, .external_lex_state = 2},
  [2811] = {.lex_state = 75, .external_lex_state = 2},
  [2812] = {.lex_state = 75, .external_lex_state = 2},
  [2813] = {.lex_state = 75, .external_lex_state = 2},
  [2814] = {.lex_state = 75, .external_lex_state = 2},
  [2815] = {.lex_state = 75, .external_lex_state = 2},
  [2816] = {.lex_state = 75, .external_lex_state = 2},
  [2817] = {.lex_state = 75, .external_lex_state = 2},
  [2818] = {.lex_state = 75, .external_lex_state = 2},
  [2819] = {.lex_state = 75, .external_lex_state = 2},
  [2820] = {.lex_state = 75, .external_lex_state = 2},
  [2821] = {.lex_state = 75, .external_lex_state = 2},
  [2822] = {.lex_state = 75, .external_lex_state = 2},
  [2823] = {.lex_state = 75, .external_lex_state = 2},
  [2824] = {.lex_state = 75, .external_lex_state = 2},
  [2825] = {.lex_state = 75, .external_lex_state = 2},
  [2826] = {.lex_state = 75, .external_lex_state = 2},
  [2827] = {.lex_state = 75, .external_lex_state = 2},
  [2828] = {.lex_state = 75, .external_lex_state = 2},
  [2829] = {.lex_state = 75, .external_lex_state = 2},
  [2830] = {.lex_state = 75, .external_lex_state = 2},
  [2831] = {.lex_state = 75, .external_lex_state = 2},
  [2832] = {.lex_state = 75, .external_lex_state = 2},
  [2833] = {.lex_state = 75, .external_lex_state = 2},
  [2834] = {.lex_state = 75, .external_lex_state = 2},
  [2835] = {.lex_state = 75, .external_lex_state = 2},
  [2836] = {.lex_state = 75, .external_lex_state = 2},
  [2837] = {.lex_state = 75, .external_lex_state = 2},
  [2838] = {.lex_state = 75, .external_lex_state = 2},
  [2839] = {.lex_state = 75, .external_lex_state = 2},
  [2840] = {.lex_state = 75, .external_lex_state = 2},
  [2841] = {.lex_state = 75, .external_lex_state = 2},
  [2842] = {.lex_state = 75, .external_lex_state = 2},
  [2843] = {.lex_state = 75, .external_lex_state = 2},
  [2844] = {.lex_state = 75, .external_lex_state = 2},
  [2845] = {.lex_state = 75, .external_lex_state = 2},
  [2846] = {.lex_state = 75, .external_lex_state = 2},
  [2847] = {.lex_state = 75, .external_lex_state = 2},
  [2848] = {.lex_state = 75, .external_lex_state = 2},
  [2849] = {.lex_state = 75, .external_lex_state = 2},
  [2850] = {.lex_state = 75, .external_lex_state = 2},
  [2851] = {.lex_state = 75, .external_lex_state = 2},
  [2852] = {.lex_state = 75, .external_lex_state = 2},
  [2853] = {.lex_state = 75, .external_lex_state = 2},
  [2854] = {.lex_state = 75, .external_lex_state = 2},
  [2855] = {.lex_state = 75, .external_lex_state = 2},
  [2856] = {.lex_state = 75, .external_lex_state = 2},
  [2857] = {.lex_state = 75, .external_lex_state = 2},
  [2858] = {.lex_state = 75, .external_lex_state = 2},
  [2859] = {.lex_state = 75, .external_lex_state = 2},
  [2860] = {.lex_state = 75, .external_lex_state = 2},
  [2861] = {.lex_state = 75, .external_lex_state = 2},
  [2862] = {.lex_state = 75, .external_lex_state = 2},
  [2863] = {.lex_state = 75, .external_lex_state = 2},
  [2864] = {.lex_state = 75, .external_lex_state = 2},
  [2865] = {.lex_state = 75, .external_lex_state = 2},
  [2866] = {.lex_state = 75, .external_lex_state = 2},
  [2867] = {.lex_state = 75, .external_lex_state = 2},
  [2868] = {.lex_state = 75, .external_lex_state = 2},
  [2869] = {.lex_state = 75, .external_lex_state = 2},
  [2870] = {.lex_state = 75, .external_lex_state = 2},
  [2871] = {.lex_state = 75, .external_lex_state = 2},
  [2872] = {.lex_state = 75, .external_lex_state = 2},
  [2873] = {.lex_state = 75, .external_lex_state = 2},
  [2874] = {.lex_state = 75, .external_lex_state = 2},
  [2875] = {.lex_state = 75, .external_lex_state = 2},
  [2876] = {.lex_state = 7, .external_lex_state = 2},
  [2877] = {.lex_state = 7, .external_lex_state = 2},
  [2878] = {.lex_state = 7, .external_lex_state = 2},
  [2879] = {.lex_state = 7, .external_lex_state = 2},
  [2880] = {.lex_state = 7, .external_lex_state = 2},
  [2881] = {.lex_state = 7, .external_lex_state = 2},
  [2882] = {.lex_state = 7, .external_lex_state = 2},
  [2883] = {.lex_state = 7, .external_lex_state = 2},
  [2884] = {.lex_state = 7, .external_lex_state = 2},
  [2885] = {.lex_state = 7, .external_lex_state = 2},
  [2886] = {.lex_state = 7, .external_lex_state = 2},
  [2887] = {.lex_state = 7, .external_lex_state = 2},
  [2888] = {.lex_state = 7, .external_lex_state = 2},
  [2889] = {.lex_state = 7, .external_lex_state = 2},
  [2890] = {.lex_state = 7, .external_lex_state = 2},
  [2891] = {.lex_state = 7, .external_lex_state = 2},
  [2892] = {.lex_state = 7, .external_lex_state = 2},
  [2893] = {.lex_state = 7, .external_lex_state = 2},
  [2894] = {.lex_state = 7, .external_lex_state = 2},
  [2895] = {.lex_state = 7, .external_lex_state = 2},
  [2896] = {.lex_state = 7, .external_lex_state = 2},
  [2897] = {.lex_state = 7, .external_lex_state = 2},
  [2898] = {.lex_state = 7, .external_lex_state = 2},
  [2899] = {.lex_state = 7, .external_lex_state = 2},
  [2900] = {.lex_state = 7, .external_lex_state = 2},
  [2901] = {.lex_state = 7, .external_lex_state = 2},
  [2902] = {.lex_state = 7, .external_lex_state = 2},
  [2903] = {.lex_state = 7, .external_lex_state = 2},
  [2904] = {.lex_state = 7, .external_lex_state = 2},
  [2905] = {.lex_state = 7, .external_lex_state = 2},
  [2906] = {.lex_state = 7, .external_lex_state = 2},
  [2907] = {.lex_state = 7, .external_lex_state = 2},
  [2908] = {.lex_state = 7, .external_lex_state = 2},
  [2909] = {.lex_state = 7, .external_lex_state = 2},
  [2910] = {.lex_state = 7, .external_lex_state = 2},
  [2911] = {.lex_state = 7, .external_lex_state = 2},
  [2912] = {.lex_state = 7, .external_lex_state = 2},
  [2913] = {.lex_state = 75, .external_lex_state = 5},
  [2914] = {.lex_state = 75, .external_lex_state = 5},
  [2915] = {.lex_state = 75, .external_lex_state = 2},
  [2916] = {.lex_state = 7, .external_lex_state = 2},
  [2917] = {.lex_state = 7, .external_lex_state = 2},
  [2918] = {.lex_state = 7, .external_lex_state = 2},
  [2919] = {.lex_state = 75, .external_lex_state = 2},
  [2920] = {.lex_state = 7, .external_lex_state = 2},
  [2921] = {.lex_state = 7, .external_lex_state = 2},
  [2922] = {.lex_state = 7, .external_lex_state = 2},
  [2923] = {.lex_state = 75, .external_lex_state = 2},
  [2924] = {.lex_state = 75, .external_lex_state = 2},
  [2925] = {.lex_state = 7, .external_lex_state = 5},
  [2926] = {.lex_state = 75, .external_lex_state = 2},
  [2927] = {.lex_state = 75, .external_lex_state = 2},
  [2928] = {.lex_state = 75, .external_lex_state = 2},
  [2929] = {.lex_state = 75, .external_lex_state = 2},
  [2930] = {.lex_state = 75, .external_lex_state = 2},
  [2931] = {.lex_state = 7, .external_lex_state = 5},
  [2932] = {.lex_state = 75, .external_lex_state = 2},
  [2933] = {.lex_state = 7, .external_lex_state = 5},
  [2934] = {.lex_state = 75, .external_lex_state = 2},
  [2935] = {.lex_state = 75, .external_lex_state = 2},
  [2936] = {.lex_state = 75, .external_lex_state = 2},
  [2937] = {.lex_state = 75, .external_lex_state = 2},
  [2938] = {.lex_state = 75, .external_lex_state = 2},
  [2939] = {.lex_state = 75, .external_lex_state = 2},
  [2940] = {.lex_state = 75, .external_lex_state = 2},
  [2941] = {.lex_state = 7, .external_lex_state = 5},
  [2942] = {.lex_state = 75, .external_lex_state = 2},
  [2943] = {.lex_state = 7, .external_lex_state = 5},
  [2944] = {.lex_state = 75, .external_lex_state = 2},
  [2945] = {.lex_state = 75, .external_lex_state = 2},
  [2946] = {.lex_state = 7, .external_lex_state = 5},
  [2947] = {.lex_state = 75, .external_lex_state = 2},
  [2948] = {.lex_state = 75, .external_lex_state = 2},
  [2949] = {.lex_state = 75, .external_lex_state = 2},
  [2950] = {.lex_state = 7, .external_lex_state = 5},
  [2951] = {.lex_state = 7, .external_lex_state = 6},
  [2952] = {.lex_state = 7, .external_lex_state = 5},
  [2953] = {.lex_state = 7, .external_lex_state = 5},
  [2954] = {.lex_state = 7, .external_lex_state = 5},
  [2955] = {.lex_state = 75, .external_lex_state = 2},
  [2956] = {.lex_state = 7, .external_lex_state = 5},
  [2957] = {.lex_state = 75, .external_lex_state = 2},
  [2958] = {.lex_state = 7, .external_lex_state = 5},
  [2959] = {.lex_state = 7, .external_lex_state = 5},
  [2960] = {.lex_state = 7, .external_lex_state = 5},
  [2961] = {.lex_state = 7, .external_lex_state = 5},
  [2962] = {.lex_state = 75, .external_lex_state = 2},
  [2963] = {.lex_state = 7, .external_lex_state = 5},
  [2964] = {.lex_state = 75, .external_lex_state = 2},
  [2965] = {.lex_state = 7, .external_lex_state = 5},
  [2966] = {.lex_state = 7, .external_lex_state = 5},
  [2967] = {.lex_state = 7, .external_lex_state = 5},
  [2968] = {.lex_state = 75, .external_lex_state = 2},
  [2969] = {.lex_state = 7, .external_lex_state = 5},
  [2970] = {.lex_state = 75, .external_lex_state = 2},
  [2971] = {.lex_state = 75, .external_lex_state = 2},
  [2972] = {.lex_state = 75, .external_lex_state = 2},
  [2973] = {.lex_state = 75, .external_lex_state = 2},
  [2974] = {.lex_state = 75, .external_lex_state = 2},
  [2975] = {.lex_state = 75, .external_lex_state = 2},
  [2976] = {.lex_state = 75, .external_lex_state = 2},
  [2977] = {.lex_state = 75, .external_lex_state = 2},
  [2978] = {.lex_state = 75, .external_lex_state = 2},
  [2979] = {.lex_state = 2, .external_lex_state = 2},
  [2980] = {.lex_state = 2, .external_lex_state = 2},
  [2981] = {.lex_state = 75, .external_lex_state = 2},
  [2982] = {.lex_state = 75, .external_lex_state = 2},
  [2983] = {.lex_state = 7, .external_lex_state = 5},
  [2984] = {.lex_state = 75, .external_lex_state = 2},
  [2985] = {.lex_state = 75, .external_lex_state = 2},
  [2986] = {.lex_state = 2, .external_lex_state = 2},
  [2987] = {.lex_state = 7, .external_lex_state = 5},
  [2988] = {.lex_state = 75, .external_lex_state = 2},
  [2989] = {.lex_state = 7, .external_lex_state = 5},
  [2990] = {.lex_state = 7, .external_lex_state = 5},
  [2991] = {.lex_state = 75, .external_lex_state = 2},
  [2992] = {.lex_state = 75, .external_lex_state = 2},
  [2993] = {.lex_state = 7, .external_lex_state = 5},
  [2994] = {.lex_state = 75, .external_lex_state = 2},
  [2995] = {.lex_state = 7, .external_lex_state = 5},
  [2996] = {.lex_state = 75, .external_lex_state = 2},
  [2997] = {.lex_state = 7, .external_lex_state = 5},
  [2998] = {.lex_state = 75, .external_lex_state = 2},
  [2999] = {.lex_state = 75, .external_lex_state = 2},
  [3000] = {.lex_state = 75, .external_lex_state = 2},
  [3001] = {.lex_state = 75, .external_lex_state = 2},
  [3002] = {.lex_state = 75, .external_lex_state = 2},
  [3003] = {.lex_state = 2, .external_lex_state = 2},
  [3004] = {.lex_state = 2, .external_lex_state = 2},
  [3005] = {.lex_state = 7, .external_lex_state = 5},
  [3006] = {.lex_state = 75, .external_lex_state = 2},
  [3007] = {.lex_state = 75, .external_lex_state = 2},
  [3008] = {.lex_state = 75, .external_lex_state = 2},
  [3009] = {.lex_state = 2, .external_lex_state = 2},
  [3010] = {.lex_state = 75, .external_lex_state = 2},
  [3011] = {.lex_state = 75, .external_lex_state = 2},
  [3012] = {.lex_state = 7, .external_lex_state = 5},
  [3013] = {.lex_state = 2, .external_lex_state = 2},
  [3014] = {.lex_state = 7, .external_lex_state = 5},
  [3015] = {.lex_state = 75, .external_lex_state = 2},
  [3016] = {.lex_state = 75, .external_lex_state = 5},
  [3017] = {.lex_state = 7, .external_lex_state = 5},
  [3018] = {.lex_state = 75, .external_lex_state = 2},
  [3019] = {.lex_state = 75, .external_lex_state = 2},
  [3020] = {.lex_state = 2, .external_lex_state = 2},
  [3021] = {.lex_state = 75, .external_lex_state = 2},
  [3022] = {.lex_state = 7, .external_lex_state = 5},
  [3023] = {.lex_state = 75, .external_lex_state = 2},
  [3024] = {.lex_state = 75, .external_lex_state = 2},
  [3025] = {.lex_state = 2, .external_lex_state = 2},
  [3026] = {.lex_state = 7, .external_lex_state = 6},
  [3027] = {.lex_state = 7, .external_lex_state = 5},
  [3028] = {.lex_state = 7, .external_lex_state = 5},
  [3029] = {.lex_state = 2, .external_lex_state = 2},
  [3030] = {.lex_state = 75, .external_lex_state = 2},
  [3031] = {.lex_state = 7, .external_lex_state = 5},
  [3032] = {.lex_state = 75, .external_lex_state = 2},
  [3033] = {.lex_state = 7, .external_lex_state = 5},
  [3034] = {.lex_state = 75, .external_lex_state = 2},
  [3035] = {.lex_state = 75, .external_lex_state = 2},
  [3036] = {.lex_state = 75, .external_lex_state = 2},
  [3037] = {.lex_state = 7, .external_lex_state = 6},
  [3038] = {.lex_state = 7, .external_lex_state = 5},
  [3039] = {.lex_state = 75, .external_lex_state = 2},
  [3040] = {.lex_state = 75, .external_lex_state = 2},
  [3041] = {.lex_state = 75, .external_lex_state = 2},
  [3042] = {.lex_state = 75, .external_lex_state = 2},
  [3043] = {.lex_state = 75, .external_lex_state = 5},
  [3044] = {.lex_state = 75, .external_lex_state = 5},
  [3045] = {.lex_state = 75, .external_lex_state = 5},
  [3046] = {.lex_state = 75, .external_lex_state = 2},
  [3047] = {.lex_state = 75, .external_lex_state = 2},
  [3048] = {.lex_state = 75, .external_lex_state = 5},
  [3049] = {.lex_state = 75, .external_lex_state = 2},
  [3050] = {.lex_state = 75, .external_lex_state = 5},
  [3051] = {.lex_state = 75, .external_lex_state = 5},
  [3052] = {.lex_state = 75, .external_lex_state = 5},
  [3053] = {.lex_state = 75, .external_lex_state = 2},
  [3054] = {.lex_state = 75, .external_lex_state = 2},
  [3055] = {.lex_state = 75, .external_lex_state = 2},
  [3056] = {.lex_state = 75, .external_lex_state = 2},
  [3057] = {.lex_state = 75, .external_lex_state = 5},
  [3058] = {.lex_state = 75, .external_lex_state = 5},
  [3059] = {.lex_state = 75, .external_lex_state = 2},
  [3060] = {.lex_state = 75, .external_lex_state = 5},
  [3061] = {.lex_state = 75, .external_lex_state = 2},
  [3062] = {.lex_state = 75, .external_lex_state = 5},
  [3063] = {.lex_state = 75, .external_lex_state = 5},
  [3064] = {.lex_state = 75, .external_lex_state = 5},
  [3065] = {.lex_state = 75, .external_lex_state = 5},
  [3066] = {.lex_state = 75, .external_lex_state = 5},
  [3067] = {.lex_state = 75, .external_lex_state = 5},
  [3068] = {.lex_state = 75, .external_lex_state = 5},
  [3069] = {.lex_state = 75, .external_lex_state = 5},
  [3070] = {.lex_state = 75, .external_lex_state = 5},
  [3071] = {.lex_state = 75, .external_lex_state = 5},
  [3072] = {.lex_state = 75, .external_lex_state = 5},
  [3073] = {.lex_state = 75, .external_lex_state = 5},
  [3074] = {.lex_state = 75, .external_lex_state = 5},
  [3075] = {.lex_state = 75, .external_lex_state = 2},
  [3076] = {.lex_state = 75, .external_lex_state = 5},
  [3077] = {.lex_state = 75, .external_lex_state = 5},
  [3078] = {.lex_state = 75, .external_lex_state = 2},
  [3079] = {.lex_state = 75, .external_lex_state = 5},
  [3080] = {.lex_state = 75, .external_lex_state = 5},
  [3081] = {.lex_state = 75, .external_lex_state = 5},
  [3082] = {.lex_state = 75, .external_lex_state = 5},
  [3083] = {.lex_state = 75, .external_lex_state = 5},
  [3084] = {.lex_state = 7, .external_lex_state = 6},
  [3085] = {.lex_state = 75, .external_lex_state = 5},
  [3086] = {.lex_state = 7, .external_lex_state = 5},
  [3087] = {.lex_state = 75, .external_lex_state = 2},
  [3088] = {.lex_state = 7, .external_lex_state = 5},
  [3089] = {.lex_state = 7, .external_lex_state = 5},
  [3090] = {.lex_state = 7, .external_lex_state = 5},
  [3091] = {.lex_state = 75, .external_lex_state = 5},
  [3092] = {.lex_state = 75, .external_lex_state = 5},
  [3093] = {.lex_state = 75, .external_lex_state = 5},
  [3094] = {.lex_state = 7, .external_lex_state = 5},
  [3095] = {.lex_state = 75, .external_lex_state = 2},
  [3096] = {.lex_state = 75, .external_lex_state = 2},
  [3097] = {.lex_state = 75, .external_lex_state = 5},
  [3098] = {.lex_state = 75, .external_lex_state = 5},
  [3099] = {.lex_state = 7, .external_lex_state = 5},
  [3100] = {.lex_state = 75, .external_lex_state = 5},
  [3101] = {.lex_state = 75, .external_lex_state = 5},
  [3102] = {.lex_state = 75, .external_lex_state = 5},
  [3103] = {.lex_state = 75, .external_lex_state = 5},
  [3104] = {.lex_state = 75, .external_lex_state = 5},
  [3105] = {.lex_state = 75, .external_lex_state = 5},
  [3106] = {.lex_state = 75, .external_lex_state = 2},
  [3107] = {.lex_state = 7, .external_lex_state = 6},
  [3108] = {.lex_state = 7, .external_lex_state = 6},
  [3109] = {.lex_state = 7, .external_lex_state = 6},
  [3110] = {.lex_state = 7, .external_lex_state = 6},
  [3111] = {.lex_state = 75, .external_lex_state = 5},
  [3112] = {.lex_state = 7, .external_lex_state = 6},
  [3113] = {.lex_state = 7, .external_lex_state = 6},
  [3114] = {.lex_state = 7, .external_lex_state = 6},
  [3115] = {.lex_state = 7, .external_lex_state = 6},
  [3116] = {.lex_state = 7, .external_lex_state = 6},
  [3117] = {.lex_state = 7, .external_lex_state = 6},
  [3118] = {.lex_state = 7, .external_lex_state = 6},
  [3119] = {.lex_state = 7, .external_lex_state = 6},
  [3120] = {.lex_state = 7, .external_lex_state = 6},
  [3121] = {.lex_state = 7, .external_lex_state = 6},
  [3122] = {.lex_state = 7, .external_lex_state = 6},
  [3123] = {.lex_state = 7, .external_lex_state = 6},
  [3124] = {.lex_state = 7, .external_lex_state = 5},
  [3125] = {.lex_state = 7, .external_lex_state = 6},
  [3126] = {.lex_state = 7, .external_lex_state = 6},
  [3127] = {.lex_state = 7, .external_lex_state = 6},
  [3128] = {.lex_state = 7, .external_lex_state = 6},
  [3129] = {.lex_state = 75, .external_lex_state = 6},
  [3130] = {.lex_state = 7, .external_lex_state = 6},
  [3131] = {.lex_state = 7, .external_lex_state = 6},
  [3132] = {.lex_state = 7, .external_lex_state = 6},
  [3133] = {.lex_state = 7, .external_lex_state = 6},
  [3134] = {.lex_state = 7, .external_lex_state = 6},
  [3135] = {.lex_state = 75, .external_lex_state = 5},
  [3136] = {.lex_state = 7, .external_lex_state = 6},
  [3137] = {.lex_state = 7, .external_lex_state = 6},
  [3138] = {.lex_state = 7, .external_lex_state = 6},
  [3139] = {.lex_state = 7, .external_lex_state = 6},
  [3140] = {.lex_state = 7, .external_lex_state = 6},
  [3141] = {.lex_state = 7, .external_lex_state = 6},
  [3142] = {.lex_state = 7, .external_lex_state = 6},
  [3143] = {.lex_state = 75, .external_lex_state = 5},
  [3144] = {.lex_state = 75, .external_lex_state = 5},
  [3145] = {.lex_state = 75, .external_lex_state = 2},
  [3146] = {.lex_state = 75, .external_lex_state = 2},
  [3147] = {.lex_state = 75, .external_lex_state = 5},
  [3148] = {.lex_state = 75, .external_lex_state = 2},
  [3149] = {.lex_state = 75, .external_lex_state = 2},
  [3150] = {.lex_state = 75, .external_lex_state = 2},
  [3151] = {.lex_state = 75, .external_lex_state = 5},
  [3152] = {.lex_state = 75, .external_lex_state = 5},
  [3153] = {.lex_state = 75, .external_lex_state = 2},
  [3154] = {.lex_state = 75, .external_lex_state = 2},
  [3155] = {.lex_state = 7, .external_lex_state = 5},
  [3156] = {.lex_state = 7, .external_lex_state = 6},
  [3157] = {.lex_state = 75, .external_lex_state = 5},
  [3158] = {.lex_state = 75, .external_lex_state = 6},
  [3159] = {.lex_state = 75, .external_lex_state = 5},
  [3160] = {.lex_state = 75, .external_lex_state = 5},
  [3161] = {.lex_state = 75, .external_lex_state = 5},
  [3162] = {.lex_state = 75, .external_lex_state = 5},
  [3163] = {.lex_state = 75, .external_lex_state = 5},
  [3164] = {.lex_state = 75, .external_lex_state = 5},
  [3165] = {.lex_state = 75, .external_lex_state = 5},
  [3166] = {.lex_state = 75, .external_lex_state = 5},
  [3167] = {.lex_state = 75, .external_lex_state = 5},
  [3168] = {.lex_state = 75, .external_lex_state = 5},
  [3169] = {.lex_state = 75, .external_lex_state = 5},
  [3170] = {.lex_state = 75, .external_lex_state = 5},
  [3171] = {.lex_state = 75, .external_lex_state = 5},
  [3172] = {.lex_state = 75, .external_lex_state = 5},
  [3173] = {.lex_state = 75, .external_lex_state = 5},
  [3174] = {.lex_state = 75, .external_lex_state = 2},
  [3175] = {.lex_state = 75, .external_lex_state = 5},
  [3176] = {.lex_state = 75, .external_lex_state = 5},
  [3177] = {.lex_state = 75, .external_lex_state = 2},
  [3178] = {.lex_state = 75, .external_lex_state = 5},
  [3179] = {.lex_state = 75, .external_lex_state = 5},
  [3180] = {.lex_state = 75, .external_lex_state = 5},
  [3181] = {.lex_state = 75, .external_lex_state = 6},
  [3182] = {.lex_state = 75, .external_lex_state = 5},
  [3183] = {.lex_state = 75, .external_lex_state = 5},
  [3184] = {.lex_state = 75, .external_lex_state = 5},
  [3185] = {.lex_state = 75, .external_lex_state = 5},
  [3186] = {.lex_state = 75, .external_lex_state = 5},
  [3187] = {.lex_state = 75, .external_lex_state = 5},
  [3188] = {.lex_state = 75, .external_lex_state = 5},
  [3189] = {.lex_state = 75, .external_lex_state = 2},
  [3190] = {.lex_state = 75, .external_lex_state = 5},
  [3191] = {.lex_state = 75, .external_lex_state = 5},
  [3192] = {.lex_state = 75, .external_lex_state = 5},
  [3193] = {.lex_state = 75, .external_lex_state = 5},
  [3194] = {.lex_state = 75, .external_lex_state = 5},
  [3195] = {.lex_state = 75, .external_lex_state = 5},
  [3196] = {.lex_state = 7, .external_lex_state = 2},
  [3197] = {.lex_state = 7, .external_lex_state = 2},
  [3198] = {.lex_state = 7, .external_lex_state = 2},
  [3199] = {.lex_state = 75, .external_lex_state = 5},
  [3200] = {.lex_state = 75, .external_lex_state = 5},
  [3201] = {.lex_state = 75, .external_lex_state = 5},
  [3202] = {.lex_state = 75, .external_lex_state = 5},
  [3203] = {.lex_state = 75, .external_lex_state = 5},
  [3204] = {.lex_state = 75, .external_lex_state = 5},
  [3205] = {.lex_state = 75, .external_lex_state = 5},
  [3206] = {.lex_state = 75, .external_lex_state = 5},
  [3207] = {.lex_state = 75, .external_lex_state = 5},
  [3208] = {.lex_state = 75, .external_lex_state = 5},
  [3209] = {.lex_state = 75, .external_lex_state = 5},
  [3210] = {.lex_state = 75, .external_lex_state = 5},
  [3211] = {.lex_state = 75, .external_lex_state = 5},
  [3212] = {.lex_state = 75, .external_lex_state = 5},
  [3213] = {.lex_state = 75, .external_lex_state = 5},
  [3214] = {.lex_state = 75, .external_lex_state = 5},
  [3215] = {.lex_state = 75, .external_lex_state = 5},
  [3216] = {.lex_state = 75, .external_lex_state = 5},
  [3217] = {.lex_state = 75, .external_lex_state = 5},
  [3218] = {.lex_state = 75, .external_lex_state = 5},
  [3219] = {.lex_state = 75, .external_lex_state = 5},
  [3220] = {.lex_state = 7, .external_lex_state = 6},
  [3221] = {.lex_state = 7, .external_lex_state = 6},
  [3222] = {.lex_state = 75, .external_lex_state = 5},
  [3223] = {.lex_state = 7, .external_lex_state = 6},
  [3224] = {.lex_state = 7, .external_lex_state = 6},
  [3225] = {.lex_state = 7, .external_lex_state = 6},
  [3226] = {.lex_state = 7, .external_lex_state = 6},
  [3227] = {.lex_state = 75, .external_lex_state = 5},
  [3228] = {.lex_state = 75, .external_lex_state = 6},
  [3229] = {.lex_state = 75, .external_lex_state = 5},
  [3230] = {.lex_state = 75, .external_lex_state = 6},
  [3231] = {.lex_state = 75, .external_lex_state = 6},
  [3232] = {.lex_state = 75, .external_lex_state = 5},
  [3233] = {.lex_state = 75, .external_lex_state = 6},
  [3234] = {.lex_state = 75, .external_lex_state = 6},
  [3235] = {.lex_state = 75, .external_lex_state = 6},
  [3236] = {.lex_state = 75, .external_lex_state = 6},
  [3237] = {.lex_state = 75, .external_lex_state = 6},
  [3238] = {.lex_state = 7, .external_lex_state = 6},
  [3239] = {.lex_state = 75, .external_lex_state = 5},
  [3240] = {.lex_state = 75, .external_lex_state = 5},
  [3241] = {.lex_state = 75, .external_lex_state = 5},
  [3242] = {.lex_state = 75, .external_lex_state = 5},
  [3243] = {.lex_state = 75, .external_lex_state = 5},
  [3244] = {.lex_state = 75, .external_lex_state = 5},
  [3245] = {.lex_state = 75, .external_lex_state = 5},
  [3246] = {.lex_state = 75, .external_lex_state = 5},
  [3247] = {.lex_state = 7, .external_lex_state = 6},
  [3248] = {.lex_state = 75, .external_lex_state = 5},
  [3249] = {.lex_state = 75, .external_lex_state = 5},
  [3250] = {.lex_state = 75, .external_lex_state = 5},
  [3251] = {.lex_state = 75, .external_lex_state = 5},
  [3252] = {.lex_state = 75, .external_lex_state = 5},
  [3253] = {.lex_state = 75, .external_lex_state = 5},
  [3254] = {.lex_state = 75, .external_lex_state = 5},
  [3255] = {.lex_state = 75, .external_lex_state = 5},
  [3256] = {.lex_state = 75, .external_lex_state = 2},
  [3257] = {.lex_state = 75, .external_lex_state = 5},
  [3258] = {.lex_state = 75, .external_lex_state = 5},
  [3259] = {.lex_state = 75, .external_lex_state = 5},
  [3260] = {.lex_state = 75, .external_lex_state = 5},
  [3261] = {.lex_state = 75, .external_lex_state = 5},
  [3262] = {.lex_state = 75, .external_lex_state = 2},
  [3263] = {.lex_state = 75, .external_lex_state = 5},
  [3264] = {.lex_state = 75, .external_lex_state = 5},
  [3265] = {.lex_state = 75, .external_lex_state = 5},
  [3266] = {.lex_state = 75, .external_lex_state = 5},
  [3267] = {.lex_state = 75, .external_lex_state = 5},
  [3268] = {.lex_state = 75, .external_lex_state = 5},
  [3269] = {.lex_state = 75, .external_lex_state = 5},
  [3270] = {.lex_state = 75, .external_lex_state = 5},
  [3271] = {.lex_state = 75, .external_lex_state = 5},
  [3272] = {.lex_state = 75, .external_lex_state = 5},
  [3273] = {.lex_state = 75, .external_lex_state = 5},
  [3274] = {.lex_state = 75, .external_lex_state = 5},
  [3275] = {.lex_state = 75, .external_lex_state = 5},
  [3276] = {.lex_state = 75, .external_lex_state = 5},
  [3277] = {.lex_state = 75, .external_lex_state = 5},
  [3278] = {.lex_state = 75, .external_lex_state = 6},
  [3279] = {.lex_state = 75, .external_lex_state = 5},
  [3280] = {.lex_state = 75, .external_lex_state = 5},
  [3281] = {.lex_state = 75, .external_lex_state = 5},
  [3282] = {.lex_state = 75, .external_lex_state = 5},
  [3283] = {.lex_state = 75, .external_lex_state = 5},
  [3284] = {.lex_state = 75, .external_lex_state = 5},
  [3285] = {.lex_state = 75, .external_lex_state = 5},
  [3286] = {.lex_state = 75, .external_lex_state = 5},
  [3287] = {.lex_state = 75, .external_lex_state = 6},
  [3288] = {.lex_state = 75, .external_lex_state = 6},
  [3289] = {.lex_state = 75, .external_lex_state = 6},
  [3290] = {.lex_state = 75, .external_lex_state = 2},
  [3291] = {.lex_state = 75, .external_lex_state = 2},
  [3292] = {.lex_state = 75, .external_lex_state = 2},
  [3293] = {.lex_state = 75, .external_lex_state = 2},
  [3294] = {.lex_state = 75, .external_lex_state = 2},
  [3295] = {.lex_state = 75, .external_lex_state = 2},
  [3296] = {.lex_state = 75, .external_lex_state = 2},
  [3297] = {.lex_state = 75, .external_lex_state = 2},
  [3298] = {.lex_state = 75, .external_lex_state = 2},
  [3299] = {.lex_state = 75, .external_lex_state = 5},
  [3300] = {.lex_state = 75, .external_lex_state = 2},
  [3301] = {.lex_state = 75, .external_lex_state = 6},
  [3302] = {.lex_state = 75, .external_lex_state = 5},
  [3303] = {.lex_state = 75, .external_lex_state = 2},
  [3304] = {.lex_state = 75, .external_lex_state = 5},
  [3305] = {.lex_state = 75, .external_lex_state = 6},
  [3306] = {.lex_state = 75, .external_lex_state = 2},
  [3307] = {.lex_state = 75, .external_lex_state = 2},
  [3308] = {.lex_state = 75, .external_lex_state = 2},
  [3309] = {.lex_state = 75, .external_lex_state = 6},
  [3310] = {.lex_state = 75, .external_lex_state = 2},
  [3311] = {.lex_state = 75, .external_lex_state = 6},
  [3312] = {.lex_state = 75, .external_lex_state = 2},
  [3313] = {.lex_state = 75, .external_lex_state = 5},
  [3314] = {.lex_state = 75, .external_lex_state = 5},
  [3315] = {.lex_state = 75, .external_lex_state = 5},
  [3316] = {.lex_state = 75, .external_lex_state = 2},
  [3317] = {.lex_state = 75, .external_lex_state = 6},
  [3318] = {.lex_state = 75, .external_lex_state = 2},
  [3319] = {.lex_state = 75, .external_lex_state = 6},
  [3320] = {.lex_state = 75, .external_lex_state = 5},
  [3321] = {.lex_state = 75, .external_lex_state = 5},
  [3322] = {.lex_state = 75, .external_lex_state = 6},
  [3323] = {.lex_state = 75, .external_lex_state = 5},
  [3324] = {.lex_state = 75, .external_lex_state = 5},
  [3325] = {.lex_state = 75, .external_lex_state = 6},
  [3326] = {.lex_state = 75, .external_lex_state = 5},
  [3327] = {.lex_state = 75, .external_lex_state = 6},
  [3328] = {.lex_state = 75, .external_lex_state = 6},
  [3329] = {.lex_state = 75, .external_lex_state = 6},
  [3330] = {.lex_state = 75, .external_lex_state = 6},
  [3331] = {.lex_state = 75, .external_lex_state = 6},
  [3332] = {.lex_state = 75, .external_lex_state = 6},
  [3333] = {.lex_state = 75, .external_lex_state = 5},
  [3334] = {.lex_state = 75, .external_lex_state = 5},
  [3335] = {.lex_state = 75, .external_lex_state = 6},
  [3336] = {.lex_state = 75, .external_lex_state = 6},
  [3337] = {.lex_state = 75, .external_lex_state = 6},
  [3338] = {.lex_state = 75, .external_lex_state = 6},
  [3339] = {.lex_state = 75, .external_lex_state = 6},
  [3340] = {.lex_state = 75, .external_lex_state = 2},
  [3341] = {.lex_state = 75, .external_lex_state = 2},
  [3342] = {.lex_state = 75, .external_lex_state = 5},
  [3343] = {.lex_state = 75, .external_lex_state = 5},
  [3344] = {.lex_state = 75, .external_lex_state = 6},
  [3345] = {.lex_state = 75, .external_lex_state = 6},
  [3346] = {.lex_state = 75, .external_lex_state = 6},
  [3347] = {.lex_state = 75, .external_lex_state = 6},
  [3348] = {.lex_state = 75, .external_lex_state = 5},
  [3349] = {.lex_state = 75, .external_lex_state = 2},
  [3350] = {.lex_state = 75, .external_lex_state = 5},
  [3351] = {.lex_state = 75, .external_lex_state = 6},
  [3352] = {.lex_state = 75, .external_lex_state = 6},
  [3353] = {.lex_state = 75, .external_lex_state = 2},
  [3354] = {.lex_state = 75, .external_lex_state = 6},
  [3355] = {.lex_state = 75, .external_lex_state = 6},
  [3356] = {.lex_state = 75, .external_lex_state = 6},
  [3357] = {.lex_state = 75, .external_lex_state = 6},
  [3358] = {.lex_state = 75, .external_lex_state = 5},
  [3359] = {.lex_state = 75, .external_lex_state = 6},
  [3360] = {.lex_state = 75, .external_lex_state = 5},
  [3361] = {.lex_state = 75, .external_lex_state = 6},
  [3362] = {.lex_state = 75, .external_lex_state = 2},
  [3363] = {.lex_state = 75, .external_lex_state = 6},
  [3364] = {.lex_state = 75, .external_lex_state = 2},
  [3365] = {.lex_state = 75, .external_lex_state = 2},
  [3366] = {.lex_state = 75, .external_lex_state = 2},
  [3367] = {.lex_state = 75, .external_lex_state = 5},
  [3368] = {.lex_state = 75, .external_lex_state = 5},
  [3369] = {.lex_state = 75, .external_lex_state = 5},
  [3370] = {.lex_state = 75, .external_lex_state = 2},
  [3371] = {.lex_state = 75, .external_lex_state = 2},
  [3372] = {.lex_state = 8, .external_lex_state = 2},
  [3373] = {.lex_state = 75, .external_lex_state = 6},
  [3374] = {.lex_state = 75, .external_lex_state = 2},
  [3375] = {.lex_state = 75, .external_lex_state = 6},
  [3376] = {.lex_state = 75, .external_lex_state = 5},
  [3377] = {.lex_state = 75, .external_lex_state = 2},
  [3378] = {.lex_state = 75, .external_lex_state = 6},
  [3379] = {.lex_state = 75, .external_lex_state = 5},
  [3380] = {.lex_state = 75, .external_lex_state = 2},
  [3381] = {.lex_state = 75, .external_lex_state = 2},
  [3382] = {.lex_state = 8, .external_lex_state = 2},
  [3383] = {.lex_state = 75, .external_lex_state = 6},
  [3384] = {.lex_state = 75, .external_lex_state = 6},
  [3385] = {.lex_state = 75, .external_lex_state = 5},
  [3386] = {.lex_state = 75, .external_lex_state = 6},
  [3387] = {.lex_state = 75, .external_lex_state = 5},
  [3388] = {.lex_state = 75, .external_lex_state = 2},
  [3389] = {.lex_state = 75, .external_lex_state = 2},
  [3390] = {.lex_state = 75, .external_lex_state = 6},
  [3391] = {.lex_state = 75, .external_lex_state = 5},
  [3392] = {.lex_state = 75, .external_lex_state = 5},
  [3393] = {.lex_state = 75, .external_lex_state = 5},
  [3394] = {.lex_state = 75, .external_lex_state = 5},
  [3395] = {.lex_state = 75, .external_lex_state = 2},
  [3396] = {.lex_state = 75, .external_lex_state = 2},
  [3397] = {.lex_state = 75, .external_lex_state = 5},
  [3398] = {.lex_state = 75, .external_lex_state = 6},
  [3399] = {.lex_state = 75, .external_lex_state = 5},
  [3400] = {.lex_state = 75, .external_lex_state = 5},
  [3401] = {.lex_state = 75, .external_lex_state = 6},
  [3402] = {.lex_state = 75, .external_lex_state = 5},
  [3403] = {.lex_state = 75, .external_lex_state = 5},
  [3404] = {.lex_state = 75, .external_lex_state = 2},
  [3405] = {.lex_state = 75, .external_lex_state = 5},
  [3406] = {.lex_state = 75, .external_lex_state = 6},
  [3407] = {.lex_state = 75, .external_lex_state = 2},
  [3408] = {.lex_state = 75, .external_lex_state = 5},
  [3409] = {.lex_state = 75, .external_lex_state = 2},
  [3410] = {.lex_state = 75, .external_lex_state = 2},
  [3411] = {.lex_state = 75, .external_lex_state = 2},
  [3412] = {.lex_state = 75, .external_lex_state = 2},
  [3413] = {.lex_state = 75, .external_lex_state = 2},
  [3414] = {.lex_state = 75, .external_lex_state = 5},
  [3415] = {.lex_state = 75, .external_lex_state = 5},
  [3416] = {.lex_state = 75, .external_lex_state = 2},
  [3417] = {.lex_state = 75, .external_lex_state = 2},
  [3418] = {.lex_state = 75, .external_lex_state = 5},
  [3419] = {.lex_state = 75, .external_lex_state = 5},
  [3420] = {.lex_state = 75, .external_lex_state = 6},
  [3421] = {.lex_state = 75, .external_lex_state = 2},
  [3422] = {.lex_state = 75, .external_lex_state = 5},
  [3423] = {.lex_state = 75, .external_lex_state = 5},
  [3424] = {.lex_state = 75, .external_lex_state = 2},
  [3425] = {.lex_state = 75, .external_lex_state = 5},
  [3426] = {.lex_state = 75, .external_lex_state = 5},
  [3427] = {.lex_state = 75, .external_lex_state = 2},
  [3428] = {.lex_state = 75, .external_lex_state = 5},
  [3429] = {.lex_state = 75, .external_lex_state = 5},
  [3430] = {.lex_state = 75, .external_lex_state = 6},
  [3431] = {.lex_state = 75, .external_lex_state = 6},
  [3432] = {.lex_state = 75, .external_lex_state = 6},
  [3433] = {.lex_state = 75, .external_lex_state = 6},
  [3434] = {.lex_state = 75, .external_lex_state = 2},
  [3435] = {.lex_state = 75, .external_lex_state = 2},
  [3436] = {.lex_state = 75, .external_lex_state = 6},
  [3437] = {.lex_state = 75, .external_lex_state = 6},
  [3438] = {.lex_state = 75, .external_lex_state = 2},
  [3439] = {.lex_state = 75, .external_lex_state = 6},
  [3440] = {.lex_state = 75, .external_lex_state = 2},
  [3441] = {.lex_state = 75, .external_lex_state = 2},
  [3442] = {.lex_state = 75, .external_lex_state = 5},
  [3443] = {.lex_state = 8, .external_lex_state = 2},
  [3444] = {.lex_state = 75, .external_lex_state = 6},
  [3445] = {.lex_state = 75, .external_lex_state = 6},
  [3446] = {.lex_state = 75, .external_lex_state = 5},
  [3447] = {.lex_state = 75, .external_lex_state = 6},
  [3448] = {.lex_state = 75, .external_lex_state = 6},
  [3449] = {.lex_state = 75, .external_lex_state = 5},
  [3450] = {.lex_state = 75, .external_lex_state = 6},
  [3451] = {.lex_state = 75, .external_lex_state = 5},
  [3452] = {.lex_state = 75, .external_lex_state = 5},
  [3453] = {.lex_state = 75, .external_lex_state = 6},
  [3454] = {.lex_state = 75, .external_lex_state = 6},
  [3455] = {.lex_state = 75, .external_lex_state = 6},
  [3456] = {.lex_state = 75, .external_lex_state = 6},
  [3457] = {.lex_state = 75, .external_lex_state = 6},
  [3458] = {.lex_state = 75, .external_lex_state = 5},
  [3459] = {.lex_state = 75, .external_lex_state = 5},
  [3460] = {.lex_state = 75, .external_lex_state = 5},
  [3461] = {.lex_state = 75, .external_lex_state = 5},
  [3462] = {.lex_state = 75, .external_lex_state = 5},
  [3463] = {.lex_state = 75, .external_lex_state = 6},
  [3464] = {.lex_state = 75, .external_lex_state = 5},
  [3465] = {.lex_state = 13, .external_lex_state = 2},
  [3466] = {.lex_state = 75, .external_lex_state = 5},
  [3467] = {.lex_state = 75, .external_lex_state = 5},
  [3468] = {.lex_state = 13, .external_lex_state = 2},
  [3469] = {.lex_state = 75, .external_lex_state = 2},
  [3470] = {.lex_state = 13, .external_lex_state = 2},
  [3471] = {.lex_state = 75, .external_lex_state = 2},
  [3472] = {.lex_state = 75, .external_lex_state = 2},
  [3473] = {.lex_state = 13, .external_lex_state = 7},
  [3474] = {.lex_state = 75, .external_lex_state = 2},
  [3475] = {.lex_state = 13, .external_lex_state = 7},
  [3476] = {.lex_state = 13, .external_lex_state = 7},
  [3477] = {.lex_state = 13, .external_lex_state = 7},
  [3478] = {.lex_state = 13, .external_lex_state = 7},
  [3479] = {.lex_state = 13, .external_lex_state = 7},
  [3480] = {.lex_state = 75, .external_lex_state = 2},
  [3481] = {.lex_state = 75, .external_lex_state = 2},
  [3482] = {.lex_state = 75, .external_lex_state = 2},
  [3483] = {.lex_state = 75, .external_lex_state = 2},
  [3484] = {.lex_state = 13, .external_lex_state = 7},
  [3485] = {.lex_state = 13, .external_lex_state = 2},
  [3486] = {.lex_state = 75, .external_lex_state = 2},
  [3487] = {.lex_state = 75, .external_lex_state = 2},
  [3488] = {.lex_state = 13, .external_lex_state = 2},
  [3489] = {.lex_state = 7, .external_lex_state = 2},
  [3490] = {.lex_state = 7, .external_lex_state = 2},
  [3491] = {.lex_state = 75, .external_lex_state = 5},
  [3492] = {.lex_state = 75, .external_lex_state = 2},
  [3493] = {.lex_state = 75, .external_lex_state = 2},
  [3494] = {.lex_state = 75, .external_lex_state = 2},
  [3495] = {.lex_state = 13, .external_lex_state = 2},
  [3496] = {.lex_state = 75, .external_lex_state = 2},
  [3497] = {.lex_state = 13, .external_lex_state = 2},
  [3498] = {.lex_state = 13, .external_lex_state = 2},
  [3499] = {.lex_state = 75, .external_lex_state = 5},
  [3500] = {.lex_state = 75, .external_lex_state = 5},
  [3501] = {.lex_state = 13, .external_lex_state = 7},
  [3502] = {.lex_state = 75, .external_lex_state = 6},
  [3503] = {.lex_state = 75, .external_lex_state = 2},
  [3504] = {.lex_state = 75, .external_lex_state = 2},
  [3505] = {.lex_state = 13, .external_lex_state = 2},
  [3506] = {.lex_state = 7, .external_lex_state = 2},
  [3507] = {.lex_state = 75, .external_lex_state = 2},
  [3508] = {.lex_state = 7, .external_lex_state = 2},
  [3509] = {.lex_state = 75, .external_lex_state = 5},
  [3510] = {.lex_state = 75, .external_lex_state = 5},
  [3511] = {.lex_state = 75, .external_lex_state = 5},
  [3512] = {.lex_state = 75, .external_lex_state = 5},
  [3513] = {.lex_state = 75, .external_lex_state = 2},
  [3514] = {.lex_state = 75, .external_lex_state = 5},
  [3515] = {.lex_state = 75, .external_lex_state = 5},
  [3516] = {.lex_state = 75, .external_lex_state = 5},
  [3517] = {.lex_state = 75, .external_lex_state = 5},
  [3518] = {.lex_state = 75, .external_lex_state = 5},
  [3519] = {.lex_state = 75, .external_lex_state = 5},
  [3520] = {.lex_state = 75, .external_lex_state = 5},
  [3521] = {.lex_state = 75, .external_lex_state = 5},
  [3522] = {.lex_state = 75, .external_lex_state = 5},
  [3523] = {.lex_state = 75, .external_lex_state = 5},
  [3524] = {.lex_state = 75, .external_lex_state = 5},
  [3525] = {.lex_state = 75, .external_lex_state = 2},
  [3526] = {.lex_state = 75, .external_lex_state = 2},
  [3527] = {.lex_state = 75, .external_lex_state = 5},
  [3528] = {.lex_state = 75, .external_lex_state = 5},
  [3529] = {.lex_state = 75, .external_lex_state = 5},
  [3530] = {.lex_state = 75, .external_lex_state = 5},
  [3531] = {.lex_state = 75, .external_lex_state = 5},
  [3532] = {.lex_state = 75, .external_lex_state = 2},
  [3533] = {.lex_state = 75, .external_lex_state = 5},
  [3534] = {.lex_state = 75, .external_lex_state = 5},
  [3535] = {.lex_state = 75, .external_lex_state = 2},
  [3536] = {.lex_state = 75, .external_lex_state = 5},
  [3537] = {.lex_state = 75, .external_lex_state = 5},
  [3538] = {.lex_state = 75, .external_lex_state = 5},
  [3539] = {.lex_state = 75, .external_lex_state = 5},
  [3540] = {.lex_state = 7, .external_lex_state = 2},
  [3541] = {.lex_state = 75, .external_lex_state = 5},
  [3542] = {.lex_state = 75, .external_lex_state = 2},
  [3543] = {.lex_state = 7, .external_lex_state = 2},
  [3544] = {.lex_state = 75, .external_lex_state = 5},
  [3545] = {.lex_state = 75, .external_lex_state = 2},
  [3546] = {.lex_state = 7, .external_lex_state = 2},
  [3547] = {.lex_state = 75, .external_lex_state = 5},
  [3548] = {.lex_state = 75, .external_lex_state = 5},
  [3549] = {.lex_state = 75, .external_lex_state = 2},
  [3550] = {.lex_state = 75, .external_lex_state = 5},
  [3551] = {.lex_state = 75, .external_lex_state = 5},
  [3552] = {.lex_state = 75, .external_lex_state = 5},
  [3553] = {.lex_state = 75, .external_lex_state = 5},
  [3554] = {.lex_state = 75, .external_lex_state = 5},
  [3555] = {.lex_state = 75, .external_lex_state = 2},
  [3556] = {.lex_state = 75, .external_lex_state = 5},
  [3557] = {.lex_state = 75, .external_lex_state = 5},
  [3558] = {.lex_state = 75, .external_lex_state = 2},
  [3559] = {.lex_state = 75, .external_lex_state = 5},
  [3560] = {.lex_state = 75, .external_lex_state = 5},
  [3561] = {.lex_state = 75, .external_lex_state = 5},
  [3562] = {.lex_state = 75, .external_lex_state = 5},
  [3563] = {.lex_state = 7, .external_lex_state = 2},
  [3564] = {.lex_state = 75, .external_lex_state = 5},
  [3565] = {.lex_state = 75, .external_lex_state = 5},
  [3566] = {.lex_state = 75, .external_lex_state = 5},
  [3567] = {.lex_state = 75, .external_lex_state = 5},
  [3568] = {.lex_state = 75, .external_lex_state = 2},
  [3569] = {.lex_state = 75, .external_lex_state = 5},
  [3570] = {.lex_state = 7, .external_lex_state = 2},
  [3571] = {.lex_state = 75, .external_lex_state = 5},
  [3572] = {.lex_state = 7, .external_lex_state = 2},
  [3573] = {.lex_state = 75, .external_lex_state = 5},
  [3574] = {.lex_state = 7, .external_lex_state = 2},
  [3575] = {.lex_state = 7, .external_lex_state = 2},
  [3576] = {.lex_state = 75, .external_lex_state = 5},
  [3577] = {.lex_state = 75, .external_lex_state = 2},
  [3578] = {.lex_state = 75, .external_lex_state = 2},
  [3579] = {.lex_state = 75, .external_lex_state = 2},
  [3580] = {.lex_state = 75, .external_lex_state = 5},
  [3581] = {.lex_state = 75, .external_lex_state = 2},
  [3582] = {.lex_state = 75, .external_lex_state = 5},
  [3583] = {.lex_state = 75, .external_lex_state = 5},
  [3584] = {.lex_state = 75, .external_lex_state = 5},
  [3585] = {.lex_state = 75, .external_lex_state = 5},
  [3586] = {.lex_state = 75, .external_lex_state = 5},
  [3587] = {.lex_state = 75, .external_lex_state = 5},
  [3588] = {.lex_state = 75, .external_lex_state = 5},
  [3589] = {.lex_state = 75, .external_lex_state = 5},
  [3590] = {.lex_state = 75, .external_lex_state = 2},
  [3591] = {.lex_state = 75, .external_lex_state = 5},
  [3592] = {.lex_state = 75, .external_lex_state = 5},
  [3593] = {.lex_state = 7, .external_lex_state = 2},
  [3594] = {.lex_state = 75, .external_lex_state = 2},
  [3595] = {.lex_state = 75, .external_lex_state = 2},
  [3596] = {.lex_state = 75, .external_lex_state = 2},
  [3597] = {.lex_state = 75, .external_lex_state = 5},
  [3598] = {.lex_state = 75, .external_lex_state = 5},
  [3599] = {.lex_state = 7, .external_lex_state = 2},
  [3600] = {.lex_state = 75, .external_lex_state = 2},
  [3601] = {.lex_state = 75, .external_lex_state = 5},
  [3602] = {.lex_state = 75, .external_lex_state = 5},
  [3603] = {.lex_state = 75, .external_lex_state = 5},
  [3604] = {.lex_state = 75, .external_lex_state = 5},
  [3605] = {.lex_state = 75, .external_lex_state = 2},
  [3606] = {.lex_state = 75, .external_lex_state = 5},
  [3607] = {.lex_state = 75, .external_lex_state = 5},
  [3608] = {.lex_state = 75, .external_lex_state = 5},
  [3609] = {.lex_state = 7, .external_lex_state = 2},
  [3610] = {.lex_state = 75, .external_lex_state = 2},
  [3611] = {.lex_state = 75, .external_lex_state = 5},
  [3612] = {.lex_state = 75, .external_lex_state = 5},
  [3613] = {.lex_state = 75, .external_lex_state = 5},
  [3614] = {.lex_state = 75, .external_lex_state = 5},
  [3615] = {.lex_state = 75, .external_lex_state = 5},
  [3616] = {.lex_state = 75, .external_lex_state = 2},
  [3617] = {.lex_state = 75, .external_lex_state = 5},
  [3618] = {.lex_state = 75, .external_lex_state = 2},
  [3619] = {.lex_state = 75, .external_lex_state = 2},
  [3620] = {.lex_state = 8, .external_lex_state = 2},
  [3621] = {.lex_state = 75, .external_lex_state = 2},
  [3622] = {.lex_state = 75, .external_lex_state = 5},
  [3623] = {.lex_state = 75, .external_lex_state = 5},
  [3624] = {.lex_state = 75, .external_lex_state = 2},
  [3625] = {.lex_state = 75, .external_lex_state = 5},
  [3626] = {.lex_state = 75, .external_lex_state = 5},
  [3627] = {.lex_state = 75, .external_lex_state = 5},
  [3628] = {.lex_state = 75, .external_lex_state = 5},
  [3629] = {.lex_state = 75, .external_lex_state = 5},
  [3630] = {.lex_state = 75, .external_lex_state = 5},
  [3631] = {.lex_state = 75, .external_lex_state = 5},
  [3632] = {.lex_state = 75, .external_lex_state = 5},
  [3633] = {.lex_state = 75, .external_lex_state = 5},
  [3634] = {.lex_state = 75, .external_lex_state = 2},
  [3635] = {.lex_state = 75, .external_lex_state = 5},
  [3636] = {.lex_state = 7, .external_lex_state = 2},
  [3637] = {.lex_state = 75, .external_lex_state = 5},
  [3638] = {.lex_state = 75, .external_lex_state = 2},
  [3639] = {.lex_state = 7, .external_lex_state = 2},
  [3640] = {.lex_state = 75, .external_lex_state = 5},
  [3641] = {.lex_state = 75, .external_lex_state = 5},
  [3642] = {.lex_state = 75, .external_lex_state = 2},
  [3643] = {.lex_state = 75, .external_lex_state = 2},
  [3644] = {.lex_state = 75, .external_lex_state = 5},
  [3645] = {.lex_state = 75, .external_lex_state = 2},
  [3646] = {.lex_state = 75, .external_lex_state = 5},
  [3647] = {.lex_state = 75, .external_lex_state = 2},
  [3648] = {.lex_state = 75, .external_lex_state = 2},
  [3649] = {.lex_state = 75, .external_lex_state = 5},
  [3650] = {.lex_state = 75, .external_lex_state = 2},
  [3651] = {.lex_state = 75, .external_lex_state = 5},
  [3652] = {.lex_state = 8, .external_lex_state = 2},
  [3653] = {.lex_state = 75, .external_lex_state = 5},
  [3654] = {.lex_state = 75, .external_lex_state = 2},
  [3655] = {.lex_state = 75, .external_lex_state = 5},
  [3656] = {.lex_state = 75, .external_lex_state = 5},
  [3657] = {.lex_state = 75, .external_lex_state = 5},
  [3658] = {.lex_state = 75, .external_lex_state = 5},
  [3659] = {.lex_state = 75, .external_lex_state = 5},
  [3660] = {.lex_state = 75, .external_lex_state = 2},
  [3661] = {.lex_state = 75, .external_lex_state = 2},
  [3662] = {.lex_state = 75, .external_lex_state = 2},
  [3663] = {.lex_state = 7, .external_lex_state = 2},
  [3664] = {.lex_state = 75, .external_lex_state = 5},
  [3665] = {.lex_state = 75, .external_lex_state = 5},
  [3666] = {.lex_state = 75, .external_lex_state = 2},
  [3667] = {.lex_state = 75, .external_lex_state = 5},
  [3668] = {.lex_state = 75, .external_lex_state = 5},
  [3669] = {.lex_state = 75, .external_lex_state = 5},
  [3670] = {.lex_state = 75, .external_lex_state = 2},
  [3671] = {.lex_state = 75, .external_lex_state = 5},
  [3672] = {.lex_state = 75, .external_lex_state = 5},
  [3673] = {.lex_state = 75, .external_lex_state = 5},
  [3674] = {.lex_state = 75, .external_lex_state = 5},
  [3675] = {.lex_state = 75, .external_lex_state = 2},
  [3676] = {.lex_state = 75, .external_lex_state = 2},
  [3677] = {.lex_state = 8, .external_lex_state = 2},
  [3678] = {.lex_state = 75, .external_lex_state = 5},
  [3679] = {.lex_state = 75, .external_lex_state = 5},
  [3680] = {.lex_state = 75, .external_lex_state = 2},
  [3681] = {.lex_state = 75, .external_lex_state = 5},
  [3682] = {.lex_state = 75, .external_lex_state = 5},
  [3683] = {.lex_state = 75, .external_lex_state = 5},
  [3684] = {.lex_state = 75, .external_lex_state = 2},
  [3685] = {.lex_state = 75, .external_lex_state = 2},
  [3686] = {.lex_state = 75, .external_lex_state = 5},
  [3687] = {.lex_state = 75, .external_lex_state = 5},
  [3688] = {.lex_state = 75, .external_lex_state = 2},
  [3689] = {.lex_state = 75, .external_lex_state = 2},
  [3690] = {.lex_state = 75, .external_lex_state = 5},
  [3691] = {.lex_state = 75, .external_lex_state = 5},
  [3692] = {.lex_state = 75, .external_lex_state = 2},
  [3693] = {.lex_state = 75, .external_lex_state = 2},
  [3694] = {.lex_state = 75, .external_lex_state = 2},
  [3695] = {.lex_state = 7, .external_lex_state = 2},
  [3696] = {.lex_state = 75, .external_lex_state = 2},
  [3697] = {.lex_state = 75, .external_lex_state = 2},
  [3698] = {.lex_state = 75, .external_lex_state = 5},
  [3699] = {.lex_state = 75, .external_lex_state = 2},
  [3700] = {.lex_state = 75, .external_lex_state = 5},
  [3701] = {.lex_state = 75, .external_lex_state = 5},
  [3702] = {.lex_state = 75, .external_lex_state = 5},
  [3703] = {.lex_state = 75, .external_lex_state = 5},
  [3704] = {.lex_state = 75, .external_lex_state = 5},
  [3705] = {.lex_state = 75, .external_lex_state = 5},
  [3706] = {.lex_state = 75, .external_lex_state = 5},
  [3707] = {.lex_state = 75, .external_lex_state = 5},
  [3708] = {.lex_state = 75, .external_lex_state = 5},
  [3709] = {.lex_state = 75, .external_lex_state = 2},
  [3710] = {.lex_state = 75, .external_lex_state = 5},
  [3711] = {.lex_state = 75, .external_lex_state = 2},
  [3712] = {.lex_state = 75, .external_lex_state = 5},
  [3713] = {.lex_state = 75, .external_lex_state = 2},
  [3714] = {.lex_state = 75, .external_lex_state = 5},
  [3715] = {.lex_state = 75, .external_lex_state = 2},
  [3716] = {.lex_state = 75, .external_lex_state = 2},
  [3717] = {.lex_state = 75, .external_lex_state = 2},
  [3718] = {.lex_state = 75, .external_lex_state = 5},
  [3719] = {.lex_state = 75, .external_lex_state = 2},
  [3720] = {.lex_state = 75, .external_lex_state = 2},
  [3721] = {.lex_state = 75, .external_lex_state = 5},
  [3722] = {.lex_state = 75, .external_lex_state = 2},
  [3723] = {.lex_state = 75, .external_lex_state = 2},
  [3724] = {.lex_state = 75, .external_lex_state = 5},
  [3725] = {.lex_state = 75, .external_lex_state = 5},
  [3726] = {.lex_state = 75, .external_lex_state = 5},
  [3727] = {.lex_state = 75, .external_lex_state = 5},
  [3728] = {.lex_state = 75, .external_lex_state = 5},
  [3729] = {.lex_state = 75, .external_lex_state = 5},
  [3730] = {.lex_state = 75, .external_lex_state = 2},
  [3731] = {.lex_state = 75, .external_lex_state = 2},
  [3732] = {.lex_state = 75, .external_lex_state = 2},
  [3733] = {.lex_state = 75, .external_lex_state = 2},
  [3734] = {.lex_state = 75, .external_lex_state = 5},
  [3735] = {.lex_state = 75, .external_lex_state = 5},
  [3736] = {.lex_state = 75, .external_lex_state = 5},
  [3737] = {.lex_state = 75, .external_lex_state = 5},
  [3738] = {.lex_state = 75, .external_lex_state = 5},
  [3739] = {.lex_state = 7, .external_lex_state = 2},
  [3740] = {.lex_state = 75, .external_lex_state = 5},
  [3741] = {.lex_state = 75, .external_lex_state = 5},
  [3742] = {.lex_state = 75, .external_lex_state = 2},
  [3743] = {.lex_state = 75, .external_lex_state = 5},
  [3744] = {.lex_state = 75, .external_lex_state = 2},
  [3745] = {.lex_state = 75, .external_lex_state = 5},
  [3746] = {.lex_state = 75, .external_lex_state = 5},
  [3747] = {.lex_state = 75, .external_lex_state = 5},
  [3748] = {.lex_state = 75, .external_lex_state = 5},
  [3749] = {.lex_state = 75, .external_lex_state = 5},
  [3750] = {.lex_state = 75, .external_lex_state = 5},
  [3751] = {.lex_state = 75, .external_lex_state = 6},
  [3752] = {.lex_state = 75, .external_lex_state = 2},
  [3753] = {.lex_state = 75, .external_lex_state = 2},
  [3754] = {.lex_state = 75, .external_lex_state = 6},
  [3755] = {.lex_state = 75, .external_lex_state = 2},
  [3756] = {.lex_state = 75, .external_lex_state = 6},
  [3757] = {.lex_state = 75, .external_lex_state = 6},
  [3758] = {.lex_state = 75, .external_lex_state = 2},
  [3759] = {.lex_state = 75, .external_lex_state = 6},
  [3760] = {.lex_state = 75, .external_lex_state = 2},
  [3761] = {.lex_state = 75, .external_lex_state = 2},
  [3762] = {.lex_state = 75, .external_lex_state = 6},
  [3763] = {.lex_state = 75, .external_lex_state = 2},
  [3764] = {.lex_state = 13, .external_lex_state = 7},
  [3765] = {.lex_state = 75, .external_lex_state = 2},
  [3766] = {.lex_state = 75, .external_lex_state = 2},
  [3767] = {.lex_state = 75, .external_lex_state = 2},
  [3768] = {.lex_state = 75, .external_lex_state = 2},
  [3769] = {.lex_state = 75, .external_lex_state = 2},
  [3770] = {.lex_state = 75, .external_lex_state = 6},
  [3771] = {.lex_state = 75, .external_lex_state = 2},
  [3772] = {.lex_state = 75, .external_lex_state = 2},
  [3773] = {.lex_state = 75, .external_lex_state = 2},
  [3774] = {.lex_state = 75, .external_lex_state = 2},
  [3775] = {.lex_state = 75, .external_lex_state = 2},
  [3776] = {.lex_state = 75, .external_lex_state = 2},
  [3777] = {.lex_state = 75, .external_lex_state = 5},
  [3778] = {.lex_state = 75, .external_lex_state = 2},
  [3779] = {.lex_state = 75, .external_lex_state = 2},
  [3780] = {.lex_state = 75, .external_lex_state = 2},
  [3781] = {.lex_state = 75, .external_lex_state = 2},
  [3782] = {.lex_state = 75, .external_lex_state = 2},
  [3783] = {.lex_state = 75, .external_lex_state = 6},
  [3784] = {.lex_state = 75, .external_lex_state = 2},
  [3785] = {.lex_state = 13, .external_lex_state = 7},
  [3786] = {.lex_state = 75, .external_lex_state = 5},
  [3787] = {.lex_state = 75, .external_lex_state = 2},
  [3788] = {.lex_state = 75, .external_lex_state = 2},
  [3789] = {.lex_state = 75, .external_lex_state = 6},
  [3790] = {.lex_state = 75, .external_lex_state = 5},
  [3791] = {.lex_state = 75, .external_lex_state = 2},
  [3792] = {.lex_state = 75, .external_lex_state = 2},
  [3793] = {.lex_state = 75, .external_lex_state = 5},
  [3794] = {.lex_state = 75, .external_lex_state = 5},
  [3795] = {.lex_state = 75, .external_lex_state = 2},
  [3796] = {.lex_state = 75, .external_lex_state = 6},
  [3797] = {.lex_state = 75, .external_lex_state = 5},
  [3798] = {.lex_state = 75, .external_lex_state = 2},
  [3799] = {.lex_state = 75, .external_lex_state = 6},
  [3800] = {.lex_state = 75, .external_lex_state = 6},
  [3801] = {.lex_state = 75, .external_lex_state = 5},
  [3802] = {.lex_state = 75, .external_lex_state = 2},
  [3803] = {.lex_state = 75, .external_lex_state = 5},
  [3804] = {.lex_state = 75, .external_lex_state = 2},
  [3805] = {.lex_state = 75, .external_lex_state = 6},
  [3806] = {.lex_state = 75, .external_lex_state = 2},
  [3807] = {.lex_state = 75, .external_lex_state = 2},
  [3808] = {.lex_state = 75, .external_lex_state = 5},
  [3809] = {.lex_state = 75, .external_lex_state = 5},
  [3810] = {.lex_state = 75, .external_lex_state = 5},
  [3811] = {.lex_state = 75, .external_lex_state = 5},
  [3812] = {.lex_state = 75, .external_lex_state = 2},
  [3813] = {.lex_state = 75, .external_lex_state = 6},
  [3814] = {.lex_state = 75, .external_lex_state = 5},
  [3815] = {.lex_state = 75, .external_lex_state = 5},
  [3816] = {.lex_state = 75, .external_lex_state = 2},
  [3817] = {.lex_state = 75, .external_lex_state = 2},
  [3818] = {.lex_state = 8, .external_lex_state = 2},
  [3819] = {.lex_state = 75, .external_lex_state = 6},
  [3820] = {.lex_state = 75, .external_lex_state = 6},
  [3821] = {.lex_state = 75, .external_lex_state = 2},
  [3822] = {.lex_state = 75, .external_lex_state = 2},
  [3823] = {.lex_state = 75, .external_lex_state = 2},
  [3824] = {.lex_state = 75, .external_lex_state = 2},
  [3825] = {.lex_state = 75, .external_lex_state = 5},
  [3826] = {.lex_state = 75, .external_lex_state = 2},
  [3827] = {.lex_state = 75, .external_lex_state = 2},
  [3828] = {.lex_state = 75, .external_lex_state = 2},
  [3829] = {.lex_state = 75, .external_lex_state = 2},
  [3830] = {.lex_state = 75, .external_lex_state = 2},
  [3831] = {.lex_state = 75, .external_lex_state = 2},
  [3832] = {.lex_state = 13, .external_lex_state = 7},
  [3833] = {.lex_state = 75, .external_lex_state = 2},
  [3834] = {.lex_state = 75, .external_lex_state = 5},
  [3835] = {.lex_state = 75, .external_lex_state = 2},
  [3836] = {.lex_state = 75, .external_lex_state = 2},
  [3837] = {.lex_state = 75, .external_lex_state = 2},
  [3838] = {.lex_state = 75, .external_lex_state = 2},
  [3839] = {.lex_state = 75, .external_lex_state = 6},
  [3840] = {.lex_state = 75, .external_lex_state = 2},
  [3841] = {.lex_state = 75, .external_lex_state = 2},
  [3842] = {.lex_state = 75, .external_lex_state = 2},
  [3843] = {.lex_state = 75, .external_lex_state = 2},
  [3844] = {.lex_state = 75, .external_lex_state = 5},
  [3845] = {.lex_state = 75, .external_lex_state = 2},
  [3846] = {.lex_state = 75, .external_lex_state = 2},
  [3847] = {.lex_state = 75, .external_lex_state = 6},
  [3848] = {.lex_state = 75, .external_lex_state = 6},
  [3849] = {.lex_state = 75, .external_lex_state = 2},
  [3850] = {.lex_state = 75, .external_lex_state = 2},
  [3851] = {.lex_state = 75, .external_lex_state = 2},
  [3852] = {.lex_state = 13, .external_lex_state = 7},
  [3853] = {.lex_state = 75, .external_lex_state = 2},
  [3854] = {.lex_state = 75, .external_lex_state = 2},
  [3855] = {.lex_state = 75, .external_lex_state = 6},
  [3856] = {.lex_state = 75, .external_lex_state = 2},
  [3857] = {.lex_state = 75, .external_lex_state = 2},
  [3858] = {.lex_state = 75, .external_lex_state = 2},
  [3859] = {.lex_state = 75, .external_lex_state = 2},
  [3860] = {.lex_state = 75, .external_lex_state = 2},
  [3861] = {.lex_state = 13, .external_lex_state = 7},
  [3862] = {.lex_state = 75, .external_lex_state = 5},
  [3863] = {.lex_state = 75, .external_lex_state = 2},
  [3864] = {.lex_state = 75, .external_lex_state = 5},
  [3865] = {.lex_state = 75, .external_lex_state = 2},
  [3866] = {.lex_state = 75, .external_lex_state = 2},
  [3867] = {.lex_state = 75, .external_lex_state = 2},
  [3868] = {.lex_state = 75, .external_lex_state = 5},
  [3869] = {.lex_state = 8, .external_lex_state = 2},
  [3870] = {.lex_state = 75, .external_lex_state = 6},
  [3871] = {.lex_state = 75, .external_lex_state = 2},
  [3872] = {.lex_state = 75, .external_lex_state = 2},
  [3873] = {.lex_state = 75, .external_lex_state = 2},
  [3874] = {.lex_state = 75, .external_lex_state = 2},
  [3875] = {.lex_state = 75, .external_lex_state = 5},
  [3876] = {.lex_state = 75, .external_lex_state = 2},
  [3877] = {.lex_state = 75, .external_lex_state = 2},
  [3878] = {.lex_state = 75, .external_lex_state = 2},
  [3879] = {.lex_state = 75, .external_lex_state = 5},
  [3880] = {.lex_state = 75, .external_lex_state = 2},
  [3881] = {.lex_state = 75, .external_lex_state = 6},
  [3882] = {.lex_state = 75, .external_lex_state = 2},
  [3883] = {.lex_state = 75, .external_lex_state = 2},
  [3884] = {.lex_state = 75, .external_lex_state = 5},
  [3885] = {.lex_state = 75, .external_lex_state = 6},
  [3886] = {.lex_state = 75, .external_lex_state = 5},
  [3887] = {.lex_state = 75, .external_lex_state = 5},
  [3888] = {.lex_state = 75, .external_lex_state = 2},
  [3889] = {.lex_state = 75, .external_lex_state = 5},
  [3890] = {.lex_state = 75, .external_lex_state = 2},
  [3891] = {.lex_state = 75, .external_lex_state = 5},
  [3892] = {.lex_state = 75, .external_lex_state = 2},
  [3893] = {.lex_state = 75, .external_lex_state = 6},
  [3894] = {.lex_state = 75, .external_lex_state = 2},
  [3895] = {.lex_state = 75, .external_lex_state = 6},
  [3896] = {.lex_state = 75, .external_lex_state = 5},
  [3897] = {.lex_state = 75, .external_lex_state = 2},
  [3898] = {.lex_state = 75, .external_lex_state = 2},
  [3899] = {.lex_state = 75, .external_lex_state = 2},
  [3900] = {.lex_state = 75, .external_lex_state = 6},
  [3901] = {.lex_state = 13, .external_lex_state = 8},
  [3902] = {.lex_state = 75, .external_lex_state = 5},
  [3903] = {.lex_state = 75, .external_lex_state = 2},
  [3904] = {.lex_state = 75, .external_lex_state = 5},
  [3905] = {.lex_state = 75, .external_lex_state = 5},
  [3906] = {.lex_state = 75, .external_lex_state = 2},
  [3907] = {.lex_state = 75, .external_lex_state = 5},
  [3908] = {.lex_state = 75, .external_lex_state = 5},
  [3909] = {.lex_state = 75, .external_lex_state = 5},
  [3910] = {.lex_state = 75, .external_lex_state = 5},
  [3911] = {.lex_state = 75, .external_lex_state = 5},
  [3912] = {.lex_state = 75, .external_lex_state = 5},
  [3913] = {.lex_state = 75, .external_lex_state = 5},
  [3914] = {.lex_state = 75, .external_lex_state = 2},
  [3915] = {.lex_state = 75, .external_lex_state = 5},
  [3916] = {.lex_state = 75, .external_lex_state = 5},
  [3917] = {.lex_state = 75, .external_lex_state = 5},
  [3918] = {.lex_state = 75, .external_lex_state = 6},
  [3919] = {.lex_state = 75, .external_lex_state = 6},
  [3920] = {.lex_state = 75, .external_lex_state = 5},
  [3921] = {.lex_state = 75, .external_lex_state = 6},
  [3922] = {.lex_state = 75, .external_lex_state = 2},
  [3923] = {.lex_state = 13, .external_lex_state = 8},
  [3924] = {.lex_state = 75, .external_lex_state = 2},
  [3925] = {.lex_state = 75, .external_lex_state = 5},
  [3926] = {.lex_state = 75, .external_lex_state = 5},
  [3927] = {.lex_state = 75, .external_lex_state = 5},
  [3928] = {.lex_state = 75, .external_lex_state = 5},
  [3929] = {.lex_state = 75, .external_lex_state = 5},
  [3930] = {.lex_state = 75, .external_lex_state = 2},
  [3931] = {.lex_state = 75, .external_lex_state = 5},
  [3932] = {.lex_state = 75, .external_lex_state = 5},
  [3933] = {.lex_state = 75, .external_lex_state = 5},
  [3934] = {.lex_state = 75, .external_lex_state = 5},
  [3935] = {.lex_state = 75, .external_lex_state = 5},
  [3936] = {.lex_state = 75, .external_lex_state = 5},
  [3937] = {.lex_state = 75, .external_lex_state = 5},
  [3938] = {.lex_state = 75, .external_lex_state = 5},
  [3939] = {.lex_state = 75, .external_lex_state = 2},
  [3940] = {.lex_state = 75, .external_lex_state = 5},
  [3941] = {.lex_state = 75, .external_lex_state = 2},
  [3942] = {.lex_state = 75, .external_lex_state = 5},
  [3943] = {.lex_state = 75, .external_lex_state = 5},
  [3944] = {.lex_state = 75, .external_lex_state = 6},
  [3945] = {.lex_state = 75, .external_lex_state = 5},
  [3946] = {.lex_state = 75, .external_lex_state = 5},
  [3947] = {.lex_state = 75, .external_lex_state = 5},
  [3948] = {.lex_state = 75, .external_lex_state = 2},
  [3949] = {.lex_state = 75, .external_lex_state = 5},
  [3950] = {.lex_state = 75, .external_lex_state = 5},
  [3951] = {.lex_state = 2, .external_lex_state = 2},
  [3952] = {.lex_state = 75, .external_lex_state = 5},
  [3953] = {.lex_state = 75, .external_lex_state = 5},
  [3954] = {.lex_state = 75, .external_lex_state = 5},
  [3955] = {.lex_state = 75, .external_lex_state = 5},
  [3956] = {.lex_state = 75, .external_lex_state = 5},
  [3957] = {.lex_state = 75, .external_lex_state = 5},
  [3958] = {.lex_state = 75, .external_lex_state = 5},
  [3959] = {.lex_state = 75, .external_lex_state = 5},
  [3960] = {.lex_state = 75, .external_lex_state = 5},
  [3961] = {.lex_state = 75, .external_lex_state = 6},
  [3962] = {.lex_state = 75, .external_lex_state = 5},
  [3963] = {.lex_state = 75, .external_lex_state = 5},
  [3964] = {.lex_state = 75, .external_lex_state = 6},
  [3965] = {.lex_state = 75, .external_lex_state = 5},
  [3966] = {.lex_state = 75, .external_lex_state = 5},
  [3967] = {.lex_state = 75, .external_lex_state = 5},
  [3968] = {.lex_state = 75, .external_lex_state = 5},
  [3969] = {.lex_state = 75, .external_lex_state = 5},
  [3970] = {.lex_state = 75, .external_lex_state = 5},
  [3971] = {.lex_state = 75, .external_lex_state = 2},
  [3972] = {.lex_state = 75, .external_lex_state = 2},
  [3973] = {.lex_state = 75, .external_lex_state = 5},
  [3974] = {.lex_state = 75, .external_lex_state = 5},
  [3975] = {.lex_state = 75, .external_lex_state = 5},
  [3976] = {.lex_state = 75, .external_lex_state = 2},
  [3977] = {.lex_state = 75, .external_lex_state = 5},
  [3978] = {.lex_state = 75, .external_lex_state = 5},
  [3979] = {.lex_state = 75, .external_lex_state = 5},
  [3980] = {.lex_state = 75, .external_lex_state = 6},
  [3981] = {.lex_state = 75, .external_lex_state = 5},
  [3982] = {.lex_state = 75, .external_lex_state = 5},
  [3983] = {.lex_state = 75, .external_lex_state = 5},
  [3984] = {.lex_state = 75, .external_lex_state = 5},
  [3985] = {.lex_state = 75, .external_lex_state = 5},
  [3986] = {.lex_state = 75, .external_lex_state = 2},
  [3987] = {.lex_state = 75, .external_lex_state = 2},
  [3988] = {.lex_state = 75, .external_lex_state = 5},
  [3989] = {.lex_state = 75, .external_lex_state = 2},
  [3990] = {.lex_state = 75, .external_lex_state = 5},
  [3991] = {.lex_state = 75, .external_lex_state = 5},
  [3992] = {.lex_state = 75, .external_lex_state = 5},
  [3993] = {.lex_state = 75, .external_lex_state = 5},
  [3994] = {.lex_state = 75, .external_lex_state = 5},
  [3995] = {.lex_state = 75, .external_lex_state = 5},
  [3996] = {.lex_state = 75, .external_lex_state = 5},
  [3997] = {.lex_state = 75, .external_lex_state = 5},
  [3998] = {.lex_state = 75, .external_lex_state = 5},
  [3999] = {.lex_state = 75, .external_lex_state = 5},
  [4000] = {.lex_state = 75, .external_lex_state = 5},
  [4001] = {.lex_state = 75, .external_lex_state = 2},
  [4002] = {.lex_state = 75, .external_lex_state = 5},
  [4003] = {.lex_state = 75, .external_lex_state = 5},
  [4004] = {.lex_state = 75, .external_lex_state = 5},
  [4005] = {.lex_state = 75, .external_lex_state = 5},
  [4006] = {.lex_state = 75, .external_lex_state = 5},
  [4007] = {.lex_state = 75, .external_lex_state = 5},
  [4008] = {.lex_state = 75, .external_lex_state = 5},
  [4009] = {.lex_state = 75, .external_lex_state = 2},
  [4010] = {.lex_state = 75, .external_lex_state = 2},
  [4011] = {.lex_state = 75, .external_lex_state = 5},
  [4012] = {.lex_state = 75, .external_lex_state = 2},
  [4013] = {.lex_state = 75, .external_lex_state = 2},
  [4014] = {.lex_state = 75, .external_lex_state = 5},
  [4015] = {.lex_state = 75, .external_lex_state = 5},
  [4016] = {.lex_state = 75, .external_lex_state = 5},
  [4017] = {.lex_state = 75, .external_lex_state = 5},
  [4018] = {.lex_state = 75, .external_lex_state = 5},
  [4019] = {.lex_state = 75, .external_lex_state = 5},
  [4020] = {.lex_state = 75, .external_lex_state = 5},
  [4021] = {.lex_state = 75, .external_lex_state = 5},
  [4022] = {.lex_state = 75, .external_lex_state = 5},
  [4023] = {.lex_state = 75, .external_lex_state = 5},
  [4024] = {.lex_state = 75, .external_lex_state = 2},
  [4025] = {.lex_state = 75, .external_lex_state = 5},
  [4026] = {.lex_state = 75, .external_lex_state = 5},
  [4027] = {.lex_state = 75, .external_lex_state = 5},
  [4028] = {.lex_state = 75, .external_lex_state = 5},
  [4029] = {.lex_state = 75, .external_lex_state = 5},
  [4030] = {.lex_state = 75, .external_lex_state = 5},
  [4031] = {.lex_state = 75, .external_lex_state = 2},
  [4032] = {.lex_state = 75, .external_lex_state = 5},
  [4033] = {.lex_state = 75, .external_lex_state = 5},
  [4034] = {.lex_state = 75, .external_lex_state = 5},
  [4035] = {.lex_state = 75, .external_lex_state = 5},
  [4036] = {.lex_state = 75, .external_lex_state = 5},
  [4037] = {.lex_state = 75, .external_lex_state = 5},
  [4038] = {.lex_state = 75, .external_lex_state = 2},
  [4039] = {.lex_state = 75, .external_lex_state = 6},
  [4040] = {.lex_state = 75, .external_lex_state = 5},
  [4041] = {.lex_state = 75, .external_lex_state = 5},
  [4042] = {.lex_state = 75, .external_lex_state = 2},
  [4043] = {.lex_state = 75, .external_lex_state = 5},
  [4044] = {.lex_state = 75, .external_lex_state = 5},
  [4045] = {.lex_state = 75, .external_lex_state = 5},
  [4046] = {.lex_state = 13, .external_lex_state = 8},
  [4047] = {.lex_state = 75, .external_lex_state = 5},
  [4048] = {.lex_state = 75, .external_lex_state = 5},
  [4049] = {.lex_state = 75, .external_lex_state = 5},
  [4050] = {.lex_state = 75, .external_lex_state = 5},
  [4051] = {.lex_state = 75, .external_lex_state = 5},
  [4052] = {.lex_state = 75, .external_lex_state = 5},
  [4053] = {.lex_state = 75, .external_lex_state = 6},
  [4054] = {.lex_state = 75, .external_lex_state = 5},
  [4055] = {.lex_state = 75, .external_lex_state = 5},
  [4056] = {.lex_state = 75, .external_lex_state = 5},
  [4057] = {.lex_state = 13, .external_lex_state = 8},
  [4058] = {.lex_state = 75, .external_lex_state = 5},
  [4059] = {.lex_state = 75, .external_lex_state = 5},
  [4060] = {.lex_state = 75, .external_lex_state = 5},
  [4061] = {.lex_state = 75, .external_lex_state = 5},
  [4062] = {.lex_state = 75, .external_lex_state = 6},
  [4063] = {.lex_state = 75, .external_lex_state = 5},
  [4064] = {.lex_state = 75, .external_lex_state = 5},
  [4065] = {.lex_state = 75, .external_lex_state = 5},
  [4066] = {.lex_state = 75, .external_lex_state = 5},
  [4067] = {.lex_state = 75, .external_lex_state = 5},
  [4068] = {.lex_state = 75, .external_lex_state = 5},
  [4069] = {.lex_state = 75, .external_lex_state = 5},
  [4070] = {.lex_state = 75, .external_lex_state = 5},
  [4071] = {.lex_state = 75, .external_lex_state = 5},
  [4072] = {.lex_state = 75, .external_lex_state = 5},
  [4073] = {.lex_state = 75, .external_lex_state = 5},
  [4074] = {.lex_state = 75, .external_lex_state = 5},
  [4075] = {.lex_state = 75, .external_lex_state = 5},
  [4076] = {.lex_state = 75, .external_lex_state = 5},
  [4077] = {.lex_state = 75, .external_lex_state = 5},
  [4078] = {.lex_state = 75, .external_lex_state = 5},
  [4079] = {.lex_state = 75, .external_lex_state = 5},
  [4080] = {.lex_state = 75, .external_lex_state = 5},
  [4081] = {.lex_state = 75, .external_lex_state = 5},
  [4082] = {.lex_state = 75, .external_lex_state = 5},
  [4083] = {.lex_state = 75, .external_lex_state = 5},
  [4084] = {.lex_state = 75, .external_lex_state = 5},
  [4085] = {.lex_state = 13, .external_lex_state = 8},
  [4086] = {.lex_state = 75, .external_lex_state = 5},
  [4087] = {.lex_state = 75, .external_lex_state = 2},
  [4088] = {.lex_state = 75, .external_lex_state = 5},
  [4089] = {.lex_state = 75, .external_lex_state = 5},
  [4090] = {.lex_state = 75, .external_lex_state = 5},
  [4091] = {.lex_state = 75, .external_lex_state = 5},
  [4092] = {.lex_state = 13, .external_lex_state = 8},
  [4093] = {.lex_state = 75, .external_lex_state = 5},
  [4094] = {.lex_state = 75, .external_lex_state = 2},
  [4095] = {.lex_state = 75, .external_lex_state = 5},
  [4096] = {.lex_state = 75, .external_lex_state = 5},
  [4097] = {.lex_state = 75, .external_lex_state = 5},
  [4098] = {.lex_state = 75, .external_lex_state = 5},
  [4099] = {.lex_state = 75, .external_lex_state = 5},
  [4100] = {.lex_state = 75, .external_lex_state = 5},
  [4101] = {.lex_state = 75, .external_lex_state = 5},
  [4102] = {.lex_state = 75, .external_lex_state = 5},
  [4103] = {.lex_state = 75, .external_lex_state = 5},
  [4104] = {.lex_state = 75, .external_lex_state = 5},
  [4105] = {.lex_state = 75, .external_lex_state = 5},
  [4106] = {.lex_state = 75, .external_lex_state = 5},
  [4107] = {.lex_state = 13, .external_lex_state = 8},
  [4108] = {.lex_state = 13, .external_lex_state = 8},
  [4109] = {.lex_state = 75, .external_lex_state = 5},
  [4110] = {.lex_state = 75, .external_lex_state = 5},
  [4111] = {.lex_state = 75, .external_lex_state = 5},
  [4112] = {.lex_state = 13, .external_lex_state = 8},
  [4113] = {.lex_state = 75, .external_lex_state = 5},
  [4114] = {.lex_state = 75, .external_lex_state = 5},
  [4115] = {.lex_state = 75, .external_lex_state = 2},
  [4116] = {.lex_state = 75, .external_lex_state = 2},
  [4117] = {.lex_state = 75, .external_lex_state = 5},
  [4118] = {.lex_state = 75, .external_lex_state = 5},
  [4119] = {.lex_state = 75, .external_lex_state = 5},
  [4120] = {.lex_state = 75, .external_lex_state = 5},
  [4121] = {.lex_state = 75, .external_lex_state = 5},
  [4122] = {.lex_state = 75, .external_lex_state = 5},
  [4123] = {.lex_state = 75, .external_lex_state = 5},
  [4124] = {.lex_state = 75, .external_lex_state = 5},
  [4125] = {.lex_state = 75, .external_lex_state = 2},
  [4126] = {.lex_state = 75, .external_lex_state = 5},
  [4127] = {.lex_state = 75, .external_lex_state = 5},
  [4128] = {.lex_state = 75, .external_lex_state = 5},
  [4129] = {.lex_state = 75, .external_lex_state = 2},
  [4130] = {.lex_state = 75, .external_lex_state = 5},
  [4131] = {.lex_state = 75, .external_lex_state = 5},
  [4132] = {.lex_state = 75, .external_lex_state = 2},
  [4133] = {.lex_state = 75, .external_lex_state = 2},
  [4134] = {.lex_state = 75, .external_lex_state = 5},
  [4135] = {.lex_state = 75, .external_lex_state = 5},
  [4136] = {.lex_state = 13, .external_lex_state = 8},
  [4137] = {.lex_state = 75, .external_lex_state = 2},
  [4138] = {.lex_state = 75, .external_lex_state = 5},
  [4139] = {.lex_state = 75, .external_lex_state = 5},
  [4140] = {.lex_state = 75, .external_lex_state = 5},
  [4141] = {.lex_state = 75, .external_lex_state = 5},
  [4142] = {.lex_state = 75, .external_lex_state = 5},
  [4143] = {.lex_state = 8, .external_lex_state = 2},
  [4144] = {.lex_state = 75, .external_lex_state = 5},
  [4145] = {.lex_state = 7, .external_lex_state = 2},
  [4146] = {.lex_state = 75, .external_lex_state = 5},
  [4147] = {.lex_state = 75, .external_lex_state = 2},
  [4148] = {.lex_state = 75, .external_lex_state = 2},
  [4149] = {.lex_state = 75, .external_lex_state = 5},
  [4150] = {.lex_state = 75, .external_lex_state = 2},
  [4151] = {.lex_state = 75, .external_lex_state = 2},
  [4152] = {.lex_state = 75, .external_lex_state = 5},
  [4153] = {.lex_state = 75, .external_lex_state = 2},
  [4154] = {.lex_state = 75, .external_lex_state = 2},
  [4155] = {.lex_state = 75, .external_lex_state = 5},
  [4156] = {.lex_state = 75, .external_lex_state = 5},
  [4157] = {.lex_state = 75, .external_lex_state = 2},
  [4158] = {.lex_state = 75, .external_lex_state = 5},
  [4159] = {.lex_state = 75, .external_lex_state = 5},
  [4160] = {.lex_state = 75, .external_lex_state = 2},
  [4161] = {.lex_state = 75, .external_lex_state = 2},
  [4162] = {.lex_state = 75, .external_lex_state = 5},
  [4163] = {.lex_state = 75, .external_lex_state = 2},
  [4164] = {.lex_state = 75, .external_lex_state = 2},
  [4165] = {.lex_state = 75, .external_lex_state = 5},
  [4166] = {.lex_state = 75, .external_lex_state = 5},
  [4167] = {.lex_state = 75, .external_lex_state = 5},
  [4168] = {.lex_state = 75, .external_lex_state = 5},
  [4169] = {.lex_state = 75, .external_lex_state = 5},
  [4170] = {.lex_state = 75, .external_lex_state = 5},
  [4171] = {.lex_state = 75, .external_lex_state = 2},
  [4172] = {.lex_state = 75, .external_lex_state = 2},
  [4173] = {.lex_state = 75, .external_lex_state = 2},
  [4174] = {.lex_state = 75, .external_lex_state = 2},
  [4175] = {.lex_state = 75, .external_lex_state = 2},
  [4176] = {.lex_state = 75, .external_lex_state = 2},
  [4177] = {.lex_state = 75, .external_lex_state = 5},
  [4178] = {.lex_state = 75, .external_lex_state = 2},
  [4179] = {.lex_state = 75, .external_lex_state = 5},
  [4180] = {.lex_state = 75, .external_lex_state = 2},
  [4181] = {.lex_state = 75, .external_lex_state = 5},
  [4182] = {.lex_state = 75, .external_lex_state = 5},
  [4183] = {.lex_state = 75, .external_lex_state = 5},
  [4184] = {.lex_state = 75, .external_lex_state = 2},
  [4185] = {.lex_state = 75, .external_lex_state = 2},
  [4186] = {.lex_state = 75, .external_lex_state = 5},
  [4187] = {.lex_state = 75, .external_lex_state = 5},
  [4188] = {.lex_state = 75, .external_lex_state = 5},
  [4189] = {.lex_state = 75, .external_lex_state = 2},
  [4190] = {.lex_state = 75, .external_lex_state = 2},
  [4191] = {.lex_state = 75, .external_lex_state = 6},
  [4192] = {.lex_state = 75, .external_lex_state = 5},
  [4193] = {.lex_state = 75, .external_lex_state = 2},
  [4194] = {.lex_state = 75, .external_lex_state = 5},
  [4195] = {.lex_state = 75, .external_lex_state = 5},
  [4196] = {.lex_state = 75, .external_lex_state = 2},
  [4197] = {.lex_state = 75, .external_lex_state = 2},
  [4198] = {.lex_state = 75, .external_lex_state = 5},
  [4199] = {.lex_state = 75, .external_lex_state = 5},
  [4200] = {.lex_state = 75, .external_lex_state = 2},
  [4201] = {.lex_state = 75, .external_lex_state = 2},
  [4202] = {.lex_state = 75, .external_lex_state = 5},
  [4203] = {.lex_state = 75, .external_lex_state = 2},
  [4204] = {.lex_state = 75, .external_lex_state = 5},
  [4205] = {.lex_state = 75, .external_lex_state = 5},
  [4206] = {.lex_state = 75, .external_lex_state = 5},
  [4207] = {.lex_state = 75, .external_lex_state = 2},
  [4208] = {.lex_state = 2, .external_lex_state = 2},
  [4209] = {.lex_state = 75, .external_lex_state = 5},
  [4210] = {.lex_state = 75, .external_lex_state = 2},
  [4211] = {.lex_state = 75, .external_lex_state = 5},
  [4212] = {.lex_state = 75, .external_lex_state = 5},
  [4213] = {.lex_state = 75, .external_lex_state = 5},
  [4214] = {.lex_state = 75, .external_lex_state = 5},
  [4215] = {.lex_state = 75, .external_lex_state = 5},
  [4216] = {.lex_state = 75, .external_lex_state = 5},
  [4217] = {.lex_state = 75, .external_lex_state = 2},
  [4218] = {.lex_state = 13, .external_lex_state = 8},
  [4219] = {.lex_state = 75, .external_lex_state = 5},
  [4220] = {.lex_state = 75, .external_lex_state = 2},
  [4221] = {.lex_state = 75, .external_lex_state = 5},
  [4222] = {.lex_state = 75, .external_lex_state = 2},
  [4223] = {.lex_state = 75, .external_lex_state = 2},
  [4224] = {.lex_state = 75, .external_lex_state = 2},
  [4225] = {.lex_state = 75, .external_lex_state = 2},
  [4226] = {.lex_state = 75, .external_lex_state = 2},
  [4227] = {.lex_state = 75, .external_lex_state = 2},
  [4228] = {.lex_state = 75, .external_lex_state = 2},
  [4229] = {.lex_state = 75, .external_lex_state = 2},
  [4230] = {.lex_state = 75, .external_lex_state = 5},
  [4231] = {.lex_state = 75, .external_lex_state = 5},
  [4232] = {.lex_state = 75, .external_lex_state = 5},
  [4233] = {.lex_state = 75, .external_lex_state = 5},
  [4234] = {.lex_state = 75, .external_lex_state = 5},
  [4235] = {.lex_state = 75, .external_lex_state = 5},
  [4236] = {.lex_state = 75, .external_lex_state = 5},
  [4237] = {.lex_state = 75, .external_lex_state = 5},
  [4238] = {.lex_state = 75, .external_lex_state = 5},
  [4239] = {.lex_state = 75, .external_lex_state = 5},
  [4240] = {.lex_state = 75, .external_lex_state = 5},
  [4241] = {.lex_state = 75, .external_lex_state = 5},
  [4242] = {.lex_state = 75, .external_lex_state = 5},
  [4243] = {.lex_state = 75, .external_lex_state = 5},
  [4244] = {.lex_state = 75, .external_lex_state = 5},
  [4245] = {.lex_state = 75, .external_lex_state = 5},
  [4246] = {.lex_state = 75, .external_lex_state = 5},
  [4247] = {.lex_state = 75, .external_lex_state = 2},
  [4248] = {.lex_state = 75, .external_lex_state = 2},
  [4249] = {.lex_state = 75, .external_lex_state = 2},
  [4250] = {.lex_state = 75, .external_lex_state = 6},
  [4251] = {.lex_state = 75, .external_lex_state = 5},
  [4252] = {.lex_state = 75, .external_lex_state = 5},
  [4253] = {.lex_state = 75, .external_lex_state = 2},
  [4254] = {.lex_state = 75, .external_lex_state = 5},
  [4255] = {.lex_state = 75, .external_lex_state = 5},
  [4256] = {.lex_state = 75, .external_lex_state = 2},
  [4257] = {.lex_state = 75, .external_lex_state = 5},
  [4258] = {.lex_state = 75, .external_lex_state = 2},
  [4259] = {.lex_state = 75, .external_lex_state = 5},
  [4260] = {.lex_state = 75, .external_lex_state = 2},
  [4261] = {.lex_state = 75, .external_lex_state = 5},
  [4262] = {.lex_state = 75, .external_lex_state = 5},
  [4263] = {.lex_state = 75, .external_lex_state = 5},
  [4264] = {.lex_state = 75, .external_lex_state = 5},
  [4265] = {.lex_state = 75, .external_lex_state = 5},
  [4266] = {.lex_state = 75, .external_lex_state = 5},
  [4267] = {.lex_state = 75, .external_lex_state = 5},
  [4268] = {.lex_state = 75, .external_lex_state = 5},
  [4269] = {.lex_state = 75, .external_lex_state = 5},
  [4270] = {.lex_state = 75, .external_lex_state = 5},
  [4271] = {.lex_state = 75, .external_lex_state = 5},
  [4272] = {.lex_state = 75, .external_lex_state = 5},
  [4273] = {.lex_state = 75, .external_lex_state = 2},
  [4274] = {.lex_state = 75, .external_lex_state = 5},
  [4275] = {.lex_state = 75, .external_lex_state = 5},
  [4276] = {.lex_state = 75, .external_lex_state = 2},
  [4277] = {.lex_state = 75, .external_lex_state = 2},
  [4278] = {.lex_state = 75, .external_lex_state = 5},
  [4279] = {.lex_state = 75, .external_lex_state = 2},
  [4280] = {.lex_state = 75, .external_lex_state = 5},
  [4281] = {.lex_state = 75, .external_lex_state = 5},
  [4282] = {.lex_state = 75, .external_lex_state = 5},
  [4283] = {.lex_state = 75, .external_lex_state = 5},
  [4284] = {.lex_state = 75, .external_lex_state = 5},
  [4285] = {.lex_state = 75, .external_lex_state = 2},
  [4286] = {.lex_state = 75, .external_lex_state = 5},
  [4287] = {.lex_state = 75, .external_lex_state = 5},
  [4288] = {.lex_state = 75, .external_lex_state = 2},
  [4289] = {.lex_state = 75, .external_lex_state = 5},
  [4290] = {.lex_state = 75, .external_lex_state = 2},
  [4291] = {.lex_state = 75, .external_lex_state = 2},
  [4292] = {.lex_state = 75, .external_lex_state = 2},
  [4293] = {.lex_state = 75, .external_lex_state = 2},
  [4294] = {.lex_state = 75, .external_lex_state = 5},
  [4295] = {.lex_state = 75, .external_lex_state = 5},
  [4296] = {.lex_state = 75, .external_lex_state = 5},
  [4297] = {.lex_state = 75, .external_lex_state = 5},
  [4298] = {.lex_state = 75, .external_lex_state = 2},
  [4299] = {.lex_state = 75, .external_lex_state = 5},
  [4300] = {.lex_state = 75, .external_lex_state = 5},
  [4301] = {.lex_state = 75, .external_lex_state = 2},
  [4302] = {.lex_state = 75, .external_lex_state = 5},
  [4303] = {.lex_state = 75, .external_lex_state = 2},
  [4304] = {.lex_state = 75, .external_lex_state = 2},
  [4305] = {.lex_state = 75, .external_lex_state = 2},
  [4306] = {.lex_state = 75, .external_lex_state = 2},
  [4307] = {.lex_state = 75, .external_lex_state = 5},
  [4308] = {.lex_state = 75, .external_lex_state = 2},
  [4309] = {.lex_state = 75, .external_lex_state = 2},
  [4310] = {.lex_state = 75, .external_lex_state = 5},
  [4311] = {.lex_state = 75, .external_lex_state = 5},
  [4312] = {.lex_state = 75, .external_lex_state = 2},
  [4313] = {.lex_state = 75, .external_lex_state = 5},
  [4314] = {.lex_state = 75, .external_lex_state = 5},
  [4315] = {.lex_state = 75, .external_lex_state = 5},
  [4316] = {.lex_state = 75, .external_lex_state = 5},
  [4317] = {.lex_state = 75, .external_lex_state = 2},
  [4318] = {.lex_state = 75, .external_lex_state = 5},
  [4319] = {.lex_state = 75, .external_lex_state = 2},
  [4320] = {.lex_state = 75, .external_lex_state = 2},
  [4321] = {.lex_state = 75, .external_lex_state = 2},
  [4322] = {.lex_state = 75, .external_lex_state = 2},
  [4323] = {.lex_state = 75, .external_lex_state = 2},
  [4324] = {.lex_state = 75, .external_lex_state = 6},
  [4325] = {.lex_state = 75, .external_lex_state = 5},
  [4326] = {.lex_state = 75, .external_lex_state = 2},
  [4327] = {.lex_state = 75, .external_lex_state = 5},
  [4328] = {.lex_state = 75, .external_lex_state = 5},
  [4329] = {.lex_state = 75, .external_lex_state = 2},
  [4330] = {.lex_state = 75, .external_lex_state = 5},
  [4331] = {.lex_state = 75, .external_lex_state = 5},
  [4332] = {.lex_state = 75, .external_lex_state = 5},
  [4333] = {.lex_state = 75, .external_lex_state = 5},
  [4334] = {.lex_state = 75, .external_lex_state = 5},
  [4335] = {.lex_state = 75, .external_lex_state = 2},
  [4336] = {.lex_state = 75, .external_lex_state = 5},
  [4337] = {.lex_state = 75, .external_lex_state = 5},
  [4338] = {.lex_state = 75, .external_lex_state = 5},
  [4339] = {.lex_state = 75, .external_lex_state = 2},
  [4340] = {.lex_state = 75, .external_lex_state = 2},
  [4341] = {.lex_state = 75, .external_lex_state = 2},
  [4342] = {.lex_state = 75, .external_lex_state = 5},
  [4343] = {.lex_state = 75, .external_lex_state = 5},
  [4344] = {.lex_state = 75, .external_lex_state = 5},
  [4345] = {.lex_state = 75, .external_lex_state = 5},
  [4346] = {.lex_state = 75, .external_lex_state = 5},
  [4347] = {.lex_state = 75, .external_lex_state = 5},
  [4348] = {.lex_state = 75, .external_lex_state = 2},
  [4349] = {.lex_state = 75, .external_lex_state = 5},
  [4350] = {.lex_state = 8, .external_lex_state = 2},
  [4351] = {.lex_state = 8, .external_lex_state = 2},
  [4352] = {.lex_state = 75, .external_lex_state = 5},
  [4353] = {.lex_state = 75, .external_lex_state = 5},
  [4354] = {.lex_state = 75, .external_lex_state = 2},
  [4355] = {.lex_state = 75, .external_lex_state = 6},
  [4356] = {.lex_state = 75, .external_lex_state = 5},
  [4357] = {.lex_state = 75, .external_lex_state = 5},
  [4358] = {.lex_state = 75, .external_lex_state = 5},
  [4359] = {.lex_state = 75, .external_lex_state = 2},
  [4360] = {.lex_state = 75, .external_lex_state = 5},
  [4361] = {.lex_state = 75, .external_lex_state = 5},
  [4362] = {.lex_state = 75, .external_lex_state = 5},
  [4363] = {.lex_state = 75, .external_lex_state = 5},
  [4364] = {.lex_state = 75, .external_lex_state = 5},
  [4365] = {.lex_state = 75, .external_lex_state = 5},
  [4366] = {.lex_state = 75, .external_lex_state = 5},
  [4367] = {.lex_state = 75, .external_lex_state = 5},
  [4368] = {.lex_state = 75, .external_lex_state = 5},
  [4369] = {.lex_state = 75, .external_lex_state = 5},
  [4370] = {.lex_state = 75, .external_lex_state = 5},
  [4371] = {.lex_state = 75, .external_lex_state = 5},
  [4372] = {.lex_state = 75, .external_lex_state = 5},
  [4373] = {.lex_state = 7, .external_lex_state = 2},
  [4374] = {.lex_state = 75, .external_lex_state = 5},
  [4375] = {.lex_state = 75, .external_lex_state = 5},
  [4376] = {.lex_state = 75, .external_lex_state = 5},
  [4377] = {.lex_state = 75, .external_lex_state = 5},
  [4378] = {.lex_state = 75, .external_lex_state = 5},
  [4379] = {.lex_state = 75, .external_lex_state = 5},
  [4380] = {.lex_state = 16, .external_lex_state = 9},
  [4381] = {.lex_state = 16, .external_lex_state = 9},
  [4382] = {.lex_state = 75, .external_lex_state = 2},
  [4383] = {.lex_state = 75, .external_lex_state = 2},
  [4384] = {.lex_state = 75, .external_lex_state = 2},
  [4385] = {.lex_state = 75, .external_lex_state = 5},
  [4386] = {.lex_state = 75, .external_lex_state = 2},
  [4387] = {.lex_state = 75, .external_lex_state = 2},
  [4388] = {.lex_state = 75, .external_lex_state = 2},
  [4389] = {.lex_state = 7, .external_lex_state = 2},
  [4390] = {.lex_state = 12, .external_lex_state = 9},
  [4391] = {.lex_state = 75, .external_lex_state = 2},
  [4392] = {.lex_state = 16, .external_lex_state = 9},
  [4393] = {.lex_state = 12, .external_lex_state = 9},
  [4394] = {.lex_state = 12, .external_lex_state = 9},
  [4395] = {.lex_state = 16, .external_lex_state = 9},
  [4396] = {.lex_state = 16, .external_lex_state = 9},
  [4397] = {.lex_state = 75, .external_lex_state = 2},
  [4398] = {.lex_state = 75, .external_lex_state = 2},
  [4399] = {.lex_state = 2, .external_lex_state = 2},
  [4400] = {.lex_state = 2, .external_lex_state = 2},
  [4401] = {.lex_state = 2, .external_lex_state = 2},
  [4402] = {.lex_state = 12, .external_lex_state = 9},
  [4403] = {.lex_state = 75, .external_lex_state = 2},
  [4404] = {.lex_state = 12, .external_lex_state = 9},
  [4405] = {.lex_state = 75, .external_lex_state = 2},
  [4406] = {.lex_state = 75, .external_lex_state = 2},
  [4407] = {.lex_state = 75, .external_lex_state = 2},
  [4408] = {.lex_state = 75, .external_lex_state = 2},
  [4409] = {.lex_state = 75, .external_lex_state = 2},
  [4410] = {.lex_state = 75, .external_lex_state = 2},
  [4411] = {.lex_state = 16, .external_lex_state = 9},
  [4412] = {.lex_state = 12, .external_lex_state = 9},
  [4413] = {.lex_state = 75, .external_lex_state = 2},
  [4414] = {.lex_state = 75, .external_lex_state = 2},
  [4415] = {.lex_state = 75, .external_lex_state = 2},
  [4416] = {.lex_state = 75, .external_lex_state = 5},
  [4417] = {.lex_state = 75, .external_lex_state = 5},
  [4418] = {.lex_state = 75, .external_lex_state = 2},
  [4419] = {.lex_state = 75, .external_lex_state = 2},
  [4420] = {.lex_state = 75, .external_lex_state = 2},
  [4421] = {.lex_state = 7, .external_lex_state = 2},
  [4422] = {.lex_state = 75, .external_lex_state = 2},
  [4423] = {.lex_state = 75, .external_lex_state = 2},
  [4424] = {.lex_state = 75, .external_lex_state = 2},
  [4425] = {.lex_state = 75, .external_lex_state = 2},
  [4426] = {.lex_state = 75, .external_lex_state = 5},
  [4427] = {.lex_state = 75, .external_lex_state = 5},
  [4428] = {.lex_state = 75, .external_lex_state = 2},
  [4429] = {.lex_state = 75, .external_lex_state = 2},
  [4430] = {.lex_state = 75, .external_lex_state = 2},
  [4431] = {.lex_state = 75, .external_lex_state = 2},
  [4432] = {.lex_state = 75, .external_lex_state = 2},
  [4433] = {.lex_state = 75, .external_lex_state = 2},
  [4434] = {.lex_state = 75, .external_lex_state = 2},
  [4435] = {.lex_state = 75, .external_lex_state = 2},
  [4436] = {.lex_state = 75, .external_lex_state = 2},
  [4437] = {.lex_state = 75, .external_lex_state = 2},
  [4438] = {.lex_state = 75, .external_lex_state = 2},
  [4439] = {.lex_state = 75, .external_lex_state = 2},
  [4440] = {.lex_state = 75, .external_lex_state = 6},
  [4441] = {.lex_state = 75, .external_lex_state = 2},
  [4442] = {.lex_state = 75, .external_lex_state = 2},
  [4443] = {.lex_state = 16, .external_lex_state = 9},
  [4444] = {.lex_state = 75, .external_lex_state = 2},
  [4445] = {.lex_state = 13, .external_lex_state = 7},
  [4446] = {.lex_state = 75, .external_lex_state = 2},
  [4447] = {.lex_state = 2, .external_lex_state = 2},
  [4448] = {.lex_state = 75, .external_lex_state = 2},
  [4449] = {.lex_state = 75, .external_lex_state = 2},
  [4450] = {.lex_state = 75, .external_lex_state = 5},
  [4451] = {.lex_state = 75, .external_lex_state = 5},
  [4452] = {.lex_state = 16, .external_lex_state = 9},
  [4453] = {.lex_state = 12, .external_lex_state = 9},
  [4454] = {.lex_state = 75, .external_lex_state = 2},
  [4455] = {.lex_state = 75, .external_lex_state = 5},
  [4456] = {.lex_state = 16, .external_lex_state = 9},
  [4457] = {.lex_state = 75, .external_lex_state = 5},
  [4458] = {.lex_state = 75, .external_lex_state = 5},
  [4459] = {.lex_state = 75, .external_lex_state = 5},
  [4460] = {.lex_state = 75, .external_lex_state = 5},
  [4461] = {.lex_state = 75, .external_lex_state = 2},
  [4462] = {.lex_state = 75, .external_lex_state = 2},
  [4463] = {.lex_state = 75, .external_lex_state = 2},
  [4464] = {.lex_state = 75, .external_lex_state = 5},
  [4465] = {.lex_state = 12, .external_lex_state = 9},
  [4466] = {.lex_state = 16, .external_lex_state = 9},
  [4467] = {.lex_state = 75, .external_lex_state = 5},
  [4468] = {.lex_state = 75, .external_lex_state = 2},
  [4469] = {.lex_state = 75, .external_lex_state = 5},
  [4470] = {.lex_state = 75, .external_lex_state = 2},
  [4471] = {.lex_state = 12, .external_lex_state = 9},
  [4472] = {.lex_state = 75, .external_lex_state = 2},
  [4473] = {.lex_state = 75, .external_lex_state = 2},
  [4474] = {.lex_state = 75, .external_lex_state = 2},
  [4475] = {.lex_state = 75, .external_lex_state = 2},
  [4476] = {.lex_state = 12, .external_lex_state = 9},
  [4477] = {.lex_state = 75, .external_lex_state = 2},
  [4478] = {.lex_state = 16, .external_lex_state = 9},
  [4479] = {.lex_state = 75, .external_lex_state = 2},
  [4480] = {.lex_state = 75, .external_lex_state = 2},
  [4481] = {.lex_state = 75, .external_lex_state = 2},
  [4482] = {.lex_state = 16, .external_lex_state = 9},
  [4483] = {.lex_state = 75, .external_lex_state = 2},
  [4484] = {.lex_state = 75, .external_lex_state = 2},
  [4485] = {.lex_state = 2, .external_lex_state = 2},
  [4486] = {.lex_state = 75, .external_lex_state = 2},
  [4487] = {.lex_state = 13, .external_lex_state = 7},
  [4488] = {.lex_state = 75, .external_lex_state = 2},
  [4489] = {.lex_state = 75, .external_lex_state = 2},
  [4490] = {.lex_state = 75, .external_lex_state = 2},
  [4491] = {.lex_state = 75, .external_lex_state = 2},
  [4492] = {.lex_state = 75, .external_lex_state = 2},
  [4493] = {.lex_state = 12, .external_lex_state = 9},
  [4494] = {.lex_state = 12, .external_lex_state = 9},
  [4495] = {.lex_state = 16, .external_lex_state = 9},
  [4496] = {.lex_state = 16, .external_lex_state = 9},
  [4497] = {.lex_state = 75, .external_lex_state = 2},
  [4498] = {.lex_state = 75, .external_lex_state = 2},
  [4499] = {.lex_state = 75, .external_lex_state = 2},
  [4500] = {.lex_state = 75, .external_lex_state = 2},
  [4501] = {.lex_state = 75, .external_lex_state = 2},
  [4502] = {.lex_state = 75, .external_lex_state = 2},
  [4503] = {.lex_state = 75, .external_lex_state = 2},
  [4504] = {.lex_state = 75, .external_lex_state = 2},
  [4505] = {.lex_state = 75, .external_lex_state = 2},
  [4506] = {.lex_state = 75, .external_lex_state = 5},
  [4507] = {.lex_state = 75, .external_lex_state = 2},
  [4508] = {.lex_state = 75, .external_lex_state = 2},
  [4509] = {.lex_state = 12, .external_lex_state = 9},
  [4510] = {.lex_state = 75, .external_lex_state = 2},
  [4511] = {.lex_state = 16, .external_lex_state = 9},
  [4512] = {.lex_state = 12, .external_lex_state = 9},
  [4513] = {.lex_state = 12, .external_lex_state = 9},
  [4514] = {.lex_state = 75, .external_lex_state = 2},
  [4515] = {.lex_state = 75, .external_lex_state = 5},
  [4516] = {.lex_state = 75, .external_lex_state = 5},
  [4517] = {.lex_state = 75, .external_lex_state = 5},
  [4518] = {.lex_state = 75, .external_lex_state = 5},
  [4519] = {.lex_state = 75, .external_lex_state = 5},
  [4520] = {.lex_state = 75, .external_lex_state = 5},
  [4521] = {.lex_state = 75, .external_lex_state = 5},
  [4522] = {.lex_state = 75, .external_lex_state = 5},
  [4523] = {.lex_state = 75, .external_lex_state = 2},
  [4524] = {.lex_state = 75, .external_lex_state = 2},
  [4525] = {.lex_state = 75, .external_lex_state = 5},
  [4526] = {.lex_state = 75, .external_lex_state = 5},
  [4527] = {.lex_state = 75, .external_lex_state = 5},
  [4528] = {.lex_state = 75, .external_lex_state = 5},
  [4529] = {.lex_state = 75, .external_lex_state = 5},
  [4530] = {.lex_state = 75, .external_lex_state = 5},
  [4531] = {.lex_state = 75, .external_lex_state = 2},
  [4532] = {.lex_state = 75, .external_lex_state = 5},
  [4533] = {.lex_state = 75, .external_lex_state = 2},
  [4534] = {.lex_state = 75, .external_lex_state = 5},
  [4535] = {.lex_state = 75, .external_lex_state = 5},
  [4536] = {.lex_state = 75, .external_lex_state = 5},
  [4537] = {.lex_state = 75, .external_lex_state = 2},
  [4538] = {.lex_state = 75, .external_lex_state = 5},
  [4539] = {.lex_state = 75, .external_lex_state = 5},
  [4540] = {.lex_state = 75, .external_lex_state = 2},
  [4541] = {.lex_state = 75, .external_lex_state = 2},
  [4542] = {.lex_state = 75, .external_lex_state = 2},
  [4543] = {.lex_state = 75, .external_lex_state = 2},
  [4544] = {.lex_state = 75, .external_lex_state = 2},
  [4545] = {.lex_state = 75, .external_lex_state = 2},
  [4546] = {.lex_state = 75, .external_lex_state = 5},
  [4547] = {.lex_state = 75, .external_lex_state = 5},
  [4548] = {.lex_state = 75, .external_lex_state = 5},
  [4549] = {.lex_state = 75, .external_lex_state = 5},
  [4550] = {.lex_state = 75, .external_lex_state = 5},
  [4551] = {.lex_state = 75, .external_lex_state = 5},
  [4552] = {.lex_state = 75, .external_lex_state = 2},
  [4553] = {.lex_state = 75, .external_lex_state = 2},
  [4554] = {.lex_state = 75, .external_lex_state = 2},
  [4555] = {.lex_state = 75, .external_lex_state = 2},
  [4556] = {.lex_state = 75, .external_lex_state = 5},
  [4557] = {.lex_state = 75, .external_lex_state = 5},
  [4558] = {.lex_state = 75, .external_lex_state = 5},
  [4559] = {.lex_state = 75, .external_lex_state = 5},
  [4560] = {.lex_state = 75, .external_lex_state = 5},
  [4561] = {.lex_state = 75, .external_lex_state = 5},
  [4562] = {.lex_state = 75, .external_lex_state = 5},
  [4563] = {.lex_state = 75, .external_lex_state = 5},
  [4564] = {.lex_state = 75, .external_lex_state = 5},
  [4565] = {.lex_state = 75, .external_lex_state = 5},
  [4566] = {.lex_state = 75, .external_lex_state = 5},
  [4567] = {.lex_state = 75, .external_lex_state = 5},
  [4568] = {.lex_state = 75, .external_lex_state = 2},
  [4569] = {.lex_state = 75, .external_lex_state = 5},
  [4570] = {.lex_state = 75, .external_lex_state = 5},
  [4571] = {.lex_state = 75, .external_lex_state = 5},
  [4572] = {.lex_state = 75, .external_lex_state = 5},
  [4573] = {.lex_state = 75, .external_lex_state = 5},
  [4574] = {.lex_state = 75, .external_lex_state = 5},
  [4575] = {.lex_state = 75, .external_lex_state = 5},
  [4576] = {.lex_state = 75, .external_lex_state = 2},
  [4577] = {.lex_state = 75, .external_lex_state = 5},
  [4578] = {.lex_state = 75, .external_lex_state = 2},
  [4579] = {.lex_state = 75, .external_lex_state = 5},
  [4580] = {.lex_state = 75, .external_lex_state = 5},
  [4581] = {.lex_state = 75, .external_lex_state = 5},
  [4582] = {.lex_state = 75, .external_lex_state = 5},
  [4583] = {.lex_state = 75, .external_lex_state = 5},
  [4584] = {.lex_state = 75, .external_lex_state = 5},
  [4585] = {.lex_state = 75, .external_lex_state = 5},
  [4586] = {.lex_state = 75, .external_lex_state = 2},
  [4587] = {.lex_state = 75, .external_lex_state = 2},
  [4588] = {.lex_state = 75, .external_lex_state = 2},
  [4589] = {.lex_state = 75, .external_lex_state = 5},
  [4590] = {.lex_state = 75, .external_lex_state = 2},
  [4591] = {.lex_state = 75, .external_lex_state = 2},
  [4592] = {.lex_state = 75, .external_lex_state = 5},
  [4593] = {.lex_state = 75, .external_lex_state = 5},
  [4594] = {.lex_state = 75, .external_lex_state = 2},
  [4595] = {.lex_state = 75, .external_lex_state = 2},
  [4596] = {.lex_state = 75, .external_lex_state = 2},
  [4597] = {.lex_state = 75, .external_lex_state = 2},
  [4598] = {.lex_state = 75, .external_lex_state = 5},
  [4599] = {.lex_state = 75, .external_lex_state = 2},
  [4600] = {.lex_state = 75, .external_lex_state = 5},
  [4601] = {.lex_state = 75, .external_lex_state = 5},
  [4602] = {.lex_state = 75, .external_lex_state = 2},
  [4603] = {.lex_state = 75, .external_lex_state = 5},
  [4604] = {.lex_state = 75, .external_lex_state = 5},
  [4605] = {.lex_state = 75, .external_lex_state = 5},
  [4606] = {.lex_state = 75, .external_lex_state = 5},
  [4607] = {.lex_state = 75, .external_lex_state = 5},
  [4608] = {.lex_state = 75, .external_lex_state = 5},
  [4609] = {.lex_state = 75, .external_lex_state = 5},
  [4610] = {.lex_state = 75, .external_lex_state = 5},
  [4611] = {.lex_state = 75, .external_lex_state = 5},
  [4612] = {.lex_state = 75, .external_lex_state = 5},
  [4613] = {.lex_state = 75, .external_lex_state = 5},
  [4614] = {.lex_state = 75, .external_lex_state = 5},
  [4615] = {.lex_state = 75, .external_lex_state = 5},
  [4616] = {.lex_state = 75, .external_lex_state = 5},
  [4617] = {.lex_state = 75, .external_lex_state = 5},
  [4618] = {.lex_state = 75, .external_lex_state = 5},
  [4619] = {.lex_state = 75, .external_lex_state = 5},
  [4620] = {.lex_state = 75, .external_lex_state = 2},
  [4621] = {.lex_state = 75, .external_lex_state = 2},
  [4622] = {.lex_state = 75, .external_lex_state = 2},
  [4623] = {.lex_state = 75, .external_lex_state = 5},
  [4624] = {.lex_state = 75, .external_lex_state = 5},
  [4625] = {.lex_state = 75, .external_lex_state = 5},
  [4626] = {.lex_state = 75, .external_lex_state = 5},
  [4627] = {.lex_state = 75, .external_lex_state = 5},
  [4628] = {.lex_state = 75, .external_lex_state = 5},
  [4629] = {.lex_state = 75, .external_lex_state = 2},
  [4630] = {.lex_state = 75, .external_lex_state = 5},
  [4631] = {.lex_state = 75, .external_lex_state = 5},
  [4632] = {.lex_state = 75, .external_lex_state = 5},
  [4633] = {.lex_state = 75, .external_lex_state = 5},
  [4634] = {.lex_state = 75, .external_lex_state = 5},
  [4635] = {.lex_state = 75, .external_lex_state = 5},
  [4636] = {.lex_state = 75, .external_lex_state = 2},
  [4637] = {.lex_state = 75, .external_lex_state = 5},
  [4638] = {.lex_state = 75, .external_lex_state = 2},
  [4639] = {.lex_state = 75, .external_lex_state = 2},
  [4640] = {.lex_state = 75, .external_lex_state = 5},
  [4641] = {.lex_state = 75, .external_lex_state = 5},
  [4642] = {.lex_state = 75, .external_lex_state = 5},
  [4643] = {.lex_state = 2, .external_lex_state = 2},
  [4644] = {.lex_state = 75, .external_lex_state = 2},
  [4645] = {.lex_state = 75, .external_lex_state = 5},
  [4646] = {.lex_state = 75, .external_lex_state = 2},
  [4647] = {.lex_state = 75, .external_lex_state = 2},
  [4648] = {.lex_state = 75, .external_lex_state = 5},
  [4649] = {.lex_state = 75, .external_lex_state = 2},
  [4650] = {.lex_state = 75, .external_lex_state = 2},
  [4651] = {.lex_state = 2, .external_lex_state = 2},
  [4652] = {.lex_state = 75, .external_lex_state = 5},
  [4653] = {.lex_state = 75, .external_lex_state = 2},
  [4654] = {.lex_state = 75, .external_lex_state = 2},
  [4655] = {.lex_state = 75, .external_lex_state = 5},
  [4656] = {.lex_state = 75, .external_lex_state = 2},
  [4657] = {.lex_state = 75, .external_lex_state = 5},
  [4658] = {.lex_state = 75, .external_lex_state = 5},
  [4659] = {.lex_state = 75, .external_lex_state = 5},
  [4660] = {.lex_state = 75, .external_lex_state = 5},
  [4661] = {.lex_state = 75, .external_lex_state = 2},
  [4662] = {.lex_state = 75, .external_lex_state = 5},
  [4663] = {.lex_state = 75, .external_lex_state = 2},
  [4664] = {.lex_state = 75, .external_lex_state = 5},
  [4665] = {.lex_state = 75, .external_lex_state = 5},
  [4666] = {.lex_state = 75, .external_lex_state = 5},
  [4667] = {.lex_state = 75, .external_lex_state = 5},
  [4668] = {.lex_state = 75, .external_lex_state = 2},
  [4669] = {.lex_state = 75, .external_lex_state = 5},
  [4670] = {.lex_state = 75, .external_lex_state = 5},
  [4671] = {.lex_state = 75, .external_lex_state = 2},
  [4672] = {.lex_state = 75, .external_lex_state = 2},
  [4673] = {.lex_state = 75, .external_lex_state = 5},
  [4674] = {.lex_state = 75, .external_lex_state = 5},
  [4675] = {.lex_state = 75, .external_lex_state = 5},
  [4676] = {.lex_state = 75, .external_lex_state = 5},
  [4677] = {.lex_state = 75, .external_lex_state = 5},
  [4678] = {.lex_state = 75, .external_lex_state = 2},
  [4679] = {.lex_state = 75, .external_lex_state = 5},
  [4680] = {.lex_state = 75, .external_lex_state = 5},
  [4681] = {.lex_state = 75, .external_lex_state = 2},
  [4682] = {.lex_state = 75, .external_lex_state = 5},
  [4683] = {.lex_state = 2, .external_lex_state = 2},
  [4684] = {.lex_state = 75, .external_lex_state = 2},
  [4685] = {.lex_state = 75, .external_lex_state = 2},
  [4686] = {.lex_state = 75, .external_lex_state = 2},
  [4687] = {.lex_state = 75, .external_lex_state = 2},
  [4688] = {.lex_state = 2, .external_lex_state = 2},
  [4689] = {.lex_state = 75, .external_lex_state = 5},
  [4690] = {.lex_state = 75, .external_lex_state = 5},
  [4691] = {.lex_state = 75, .external_lex_state = 5},
  [4692] = {.lex_state = 75, .external_lex_state = 2},
  [4693] = {.lex_state = 75, .external_lex_state = 2},
  [4694] = {.lex_state = 75, .external_lex_state = 5},
  [4695] = {.lex_state = 75, .external_lex_state = 2},
  [4696] = {.lex_state = 75, .external_lex_state = 5},
  [4697] = {.lex_state = 75, .external_lex_state = 2},
  [4698] = {.lex_state = 75, .external_lex_state = 2},
  [4699] = {.lex_state = 75, .external_lex_state = 5},
  [4700] = {.lex_state = 75, .external_lex_state = 2},
  [4701] = {.lex_state = 75, .external_lex_state = 5},
  [4702] = {.lex_state = 75, .external_lex_state = 5},
  [4703] = {.lex_state = 75, .external_lex_state = 5},
  [4704] = {.lex_state = 75, .external_lex_state = 5},
  [4705] = {.lex_state = 75, .external_lex_state = 5},
  [4706] = {.lex_state = 75, .external_lex_state = 5},
  [4707] = {.lex_state = 75, .external_lex_state = 5},
  [4708] = {.lex_state = 75, .external_lex_state = 2},
  [4709] = {.lex_state = 75, .external_lex_state = 5},
  [4710] = {.lex_state = 75, .external_lex_state = 5},
  [4711] = {.lex_state = 75, .external_lex_state = 5},
  [4712] = {.lex_state = 75, .external_lex_state = 2},
  [4713] = {.lex_state = 75, .external_lex_state = 2},
  [4714] = {.lex_state = 75, .external_lex_state = 2},
  [4715] = {.lex_state = 75, .external_lex_state = 5},
  [4716] = {.lex_state = 75, .external_lex_state = 2},
  [4717] = {.lex_state = 75, .external_lex_state = 5},
  [4718] = {.lex_state = 75, .external_lex_state = 5},
  [4719] = {.lex_state = 75, .external_lex_state = 5},
  [4720] = {.lex_state = 75, .external_lex_state = 5},
  [4721] = {.lex_state = 75, .external_lex_state = 2},
  [4722] = {.lex_state = 75, .external_lex_state = 5},
  [4723] = {.lex_state = 75, .external_lex_state = 5},
  [4724] = {.lex_state = 75, .external_lex_state = 5},
  [4725] = {.lex_state = 75, .external_lex_state = 5},
  [4726] = {.lex_state = 75, .external_lex_state = 5},
  [4727] = {.lex_state = 75, .external_lex_state = 5},
  [4728] = {.lex_state = 75, .external_lex_state = 5},
  [4729] = {.lex_state = 75, .external_lex_state = 5},
  [4730] = {.lex_state = 75, .external_lex_state = 2},
  [4731] = {.lex_state = 75, .external_lex_state = 5},
  [4732] = {.lex_state = 75, .external_lex_state = 5},
  [4733] = {.lex_state = 75, .external_lex_state = 2},
  [4734] = {.lex_state = 75, .external_lex_state = 2},
  [4735] = {.lex_state = 75, .external_lex_state = 2},
  [4736] = {.lex_state = 75, .external_lex_state = 2},
  [4737] = {.lex_state = 75, .external_lex_state = 5},
  [4738] = {.lex_state = 75, .external_lex_state = 5},
  [4739] = {.lex_state = 75, .external_lex_state = 5},
  [4740] = {.lex_state = 75, .external_lex_state = 2},
  [4741] = {.lex_state = 75, .external_lex_state = 5},
  [4742] = {.lex_state = 75, .external_lex_state = 5},
  [4743] = {.lex_state = 75, .external_lex_state = 5},
  [4744] = {.lex_state = 75, .external_lex_state = 2},
  [4745] = {.lex_state = 75, .external_lex_state = 2},
  [4746] = {.lex_state = 75, .external_lex_state = 2},
  [4747] = {.lex_state = 75, .external_lex_state = 5},
  [4748] = {.lex_state = 75, .external_lex_state = 5},
  [4749] = {.lex_state = 75, .external_lex_state = 5},
  [4750] = {.lex_state = 75, .external_lex_state = 5},
  [4751] = {.lex_state = 75, .external_lex_state = 5},
  [4752] = {.lex_state = 75, .external_lex_state = 5},
  [4753] = {.lex_state = 75, .external_lex_state = 5},
  [4754] = {.lex_state = 75, .external_lex_state = 5},
  [4755] = {.lex_state = 75, .external_lex_state = 5},
  [4756] = {.lex_state = 75, .external_lex_state = 5},
  [4757] = {.lex_state = 75, .external_lex_state = 5},
  [4758] = {.lex_state = 75, .external_lex_state = 5},
  [4759] = {.lex_state = 75, .external_lex_state = 5},
  [4760] = {.lex_state = 75, .external_lex_state = 5},
  [4761] = {.lex_state = 75, .external_lex_state = 5},
  [4762] = {.lex_state = 75, .external_lex_state = 5},
  [4763] = {.lex_state = 75, .external_lex_state = 5},
  [4764] = {.lex_state = 75, .external_lex_state = 5},
  [4765] = {.lex_state = 75, .external_lex_state = 5},
  [4766] = {.lex_state = 75, .external_lex_state = 5},
  [4767] = {.lex_state = 75, .external_lex_state = 5},
  [4768] = {.lex_state = 75, .external_lex_state = 5},
  [4769] = {.lex_state = 75, .external_lex_state = 5},
  [4770] = {.lex_state = 75, .external_lex_state = 5},
  [4771] = {.lex_state = 75, .external_lex_state = 5},
  [4772] = {.lex_state = 75, .external_lex_state = 5},
  [4773] = {.lex_state = 75, .external_lex_state = 5},
  [4774] = {.lex_state = 75, .external_lex_state = 5},
  [4775] = {.lex_state = 75, .external_lex_state = 5},
  [4776] = {.lex_state = 75, .external_lex_state = 5},
  [4777] = {.lex_state = 75, .external_lex_state = 5},
  [4778] = {.lex_state = 75, .external_lex_state = 5},
  [4779] = {.lex_state = 75, .external_lex_state = 5},
  [4780] = {.lex_state = 2, .external_lex_state = 2},
  [4781] = {.lex_state = 75, .external_lex_state = 5},
  [4782] = {.lex_state = 75, .external_lex_state = 5},
  [4783] = {.lex_state = 75, .external_lex_state = 2},
  [4784] = {.lex_state = 75, .external_lex_state = 2},
  [4785] = {.lex_state = 75, .external_lex_state = 2},
  [4786] = {.lex_state = 75, .external_lex_state = 5},
  [4787] = {.lex_state = 75, .external_lex_state = 2},
  [4788] = {.lex_state = 75, .external_lex_state = 5},
  [4789] = {.lex_state = 75, .external_lex_state = 2},
  [4790] = {.lex_state = 75, .external_lex_state = 2},
  [4791] = {.lex_state = 75, .external_lex_state = 5},
  [4792] = {.lex_state = 75, .external_lex_state = 2},
  [4793] = {.lex_state = 75, .external_lex_state = 5},
  [4794] = {.lex_state = 75, .external_lex_state = 5},
  [4795] = {.lex_state = 75, .external_lex_state = 5},
  [4796] = {.lex_state = 75, .external_lex_state = 5},
  [4797] = {.lex_state = 75, .external_lex_state = 2},
  [4798] = {.lex_state = 75, .external_lex_state = 5},
  [4799] = {.lex_state = 75, .external_lex_state = 5},
  [4800] = {.lex_state = 75, .external_lex_state = 5},
  [4801] = {.lex_state = 75, .external_lex_state = 5},
  [4802] = {.lex_state = 75, .external_lex_state = 2},
  [4803] = {.lex_state = 75, .external_lex_state = 5},
  [4804] = {.lex_state = 75, .external_lex_state = 5},
  [4805] = {.lex_state = 75, .external_lex_state = 5},
  [4806] = {.lex_state = 75, .external_lex_state = 2},
  [4807] = {.lex_state = 75, .external_lex_state = 5},
  [4808] = {.lex_state = 75, .external_lex_state = 2},
  [4809] = {.lex_state = 75, .external_lex_state = 5},
  [4810] = {.lex_state = 75, .external_lex_state = 2},
  [4811] = {.lex_state = 75, .external_lex_state = 5},
  [4812] = {.lex_state = 75, .external_lex_state = 2},
  [4813] = {.lex_state = 75, .external_lex_state = 5},
  [4814] = {.lex_state = 75, .external_lex_state = 2},
  [4815] = {.lex_state = 75, .external_lex_state = 2},
  [4816] = {.lex_state = 75, .external_lex_state = 5},
  [4817] = {.lex_state = 75, .external_lex_state = 5},
  [4818] = {.lex_state = 75, .external_lex_state = 5},
  [4819] = {.lex_state = 75, .external_lex_state = 5},
  [4820] = {.lex_state = 75, .external_lex_state = 5},
  [4821] = {.lex_state = 75, .external_lex_state = 5},
  [4822] = {.lex_state = 75, .external_lex_state = 5},
  [4823] = {.lex_state = 75, .external_lex_state = 5},
  [4824] = {.lex_state = 75, .external_lex_state = 5},
  [4825] = {.lex_state = 75, .external_lex_state = 5},
  [4826] = {.lex_state = 75, .external_lex_state = 5},
  [4827] = {.lex_state = 75, .external_lex_state = 5},
  [4828] = {.lex_state = 75, .external_lex_state = 5},
  [4829] = {.lex_state = 75, .external_lex_state = 2},
  [4830] = {.lex_state = 75, .external_lex_state = 5},
  [4831] = {.lex_state = 75, .external_lex_state = 5},
  [4832] = {.lex_state = 75, .external_lex_state = 5},
  [4833] = {.lex_state = 75, .external_lex_state = 5},
  [4834] = {.lex_state = 75, .external_lex_state = 5},
  [4835] = {.lex_state = 75, .external_lex_state = 5},
  [4836] = {.lex_state = 75, .external_lex_state = 5},
  [4837] = {.lex_state = 75, .external_lex_state = 5},
  [4838] = {.lex_state = 75, .external_lex_state = 5},
  [4839] = {.lex_state = 75, .external_lex_state = 5},
  [4840] = {.lex_state = 75, .external_lex_state = 5},
  [4841] = {.lex_state = 75, .external_lex_state = 5},
  [4842] = {.lex_state = 75, .external_lex_state = 5},
  [4843] = {.lex_state = 75, .external_lex_state = 5},
  [4844] = {.lex_state = 75, .external_lex_state = 5},
  [4845] = {.lex_state = 75, .external_lex_state = 5},
  [4846] = {.lex_state = 75, .external_lex_state = 5},
  [4847] = {.lex_state = 75, .external_lex_state = 5},
  [4848] = {.lex_state = 75, .external_lex_state = 5},
  [4849] = {.lex_state = 75, .external_lex_state = 5},
  [4850] = {.lex_state = 75, .external_lex_state = 5},
  [4851] = {.lex_state = 75, .external_lex_state = 5},
  [4852] = {.lex_state = 75, .external_lex_state = 5},
  [4853] = {.lex_state = 75, .external_lex_state = 5},
  [4854] = {.lex_state = 75, .external_lex_state = 5},
  [4855] = {.lex_state = 75, .external_lex_state = 5},
  [4856] = {.lex_state = 75, .external_lex_state = 5},
  [4857] = {.lex_state = 75, .external_lex_state = 5},
  [4858] = {.lex_state = 75, .external_lex_state = 5},
  [4859] = {.lex_state = 75, .external_lex_state = 5},
  [4860] = {.lex_state = 75, .external_lex_state = 5},
  [4861] = {.lex_state = 75, .external_lex_state = 5},
  [4862] = {.lex_state = 75, .external_lex_state = 5},
  [4863] = {.lex_state = 75, .external_lex_state = 5},
  [4864] = {.lex_state = 75, .external_lex_state = 5},
  [4865] = {.lex_state = 75, .external_lex_state = 5},
  [4866] = {.lex_state = 75, .external_lex_state = 5},
  [4867] = {.lex_state = 75, .external_lex_state = 5},
  [4868] = {.lex_state = 75, .external_lex_state = 5},
  [4869] = {.lex_state = 75, .external_lex_state = 2},
  [4870] = {.lex_state = 75, .external_lex_state = 5},
  [4871] = {.lex_state = 75, .external_lex_state = 5},
  [4872] = {.lex_state = 75, .external_lex_state = 5},
  [4873] = {.lex_state = 75, .external_lex_state = 5},
  [4874] = {.lex_state = 75, .external_lex_state = 5},
  [4875] = {.lex_state = 75, .external_lex_state = 5},
  [4876] = {.lex_state = 75, .external_lex_state = 5},
  [4877] = {.lex_state = 75, .external_lex_state = 5},
  [4878] = {.lex_state = 75, .external_lex_state = 2},
  [4879] = {.lex_state = 75, .external_lex_state = 2},
  [4880] = {.lex_state = 75, .external_lex_state = 5},
  [4881] = {.lex_state = 75, .external_lex_state = 2},
  [4882] = {.lex_state = 75, .external_lex_state = 5},
  [4883] = {.lex_state = 75, .external_lex_state = 5},
  [4884] = {.lex_state = 75, .external_lex_state = 5},
  [4885] = {.lex_state = 75, .external_lex_state = 5},
  [4886] = {.lex_state = 75, .external_lex_state = 5},
  [4887] = {.lex_state = 75, .external_lex_state = 2},
  [4888] = {.lex_state = 75, .external_lex_state = 5},
  [4889] = {.lex_state = 75, .external_lex_state = 5},
  [4890] = {.lex_state = 75, .external_lex_state = 2},
  [4891] = {.lex_state = 2, .external_lex_state = 2},
  [4892] = {.lex_state = 75, .external_lex_state = 5},
  [4893] = {.lex_state = 75, .external_lex_state = 5},
  [4894] = {.lex_state = 75, .external_lex_state = 2},
  [4895] = {.lex_state = 75, .external_lex_state = 5},
  [4896] = {.lex_state = 75, .external_lex_state = 2},
  [4897] = {.lex_state = 75, .external_lex_state = 2},
  [4898] = {.lex_state = 75, .external_lex_state = 5},
  [4899] = {.lex_state = 75, .external_lex_state = 2},
  [4900] = {.lex_state = 75, .external_lex_state = 5},
  [4901] = {.lex_state = 75, .external_lex_state = 5},
  [4902] = {.lex_state = 75, .external_lex_state = 5},
  [4903] = {.lex_state = 75, .external_lex_state = 5},
  [4904] = {.lex_state = 75, .external_lex_state = 5},
  [4905] = {.lex_state = 75, .external_lex_state = 2},
  [4906] = {.lex_state = 75, .external_lex_state = 5},
  [4907] = {.lex_state = 75, .external_lex_state = 5},
  [4908] = {.lex_state = 75, .external_lex_state = 2},
  [4909] = {.lex_state = 75, .external_lex_state = 5},
  [4910] = {.lex_state = 75, .external_lex_state = 2},
  [4911] = {.lex_state = 75, .external_lex_state = 5},
  [4912] = {.lex_state = 75, .external_lex_state = 5},
  [4913] = {.lex_state = 75, .external_lex_state = 5},
  [4914] = {.lex_state = 75, .external_lex_state = 5},
  [4915] = {.lex_state = 75, .external_lex_state = 5},
  [4916] = {.lex_state = 75, .external_lex_state = 5},
  [4917] = {.lex_state = 75, .external_lex_state = 5},
  [4918] = {.lex_state = 75, .external_lex_state = 5},
  [4919] = {.lex_state = 75, .external_lex_state = 5},
  [4920] = {.lex_state = 75, .external_lex_state = 5},
  [4921] = {.lex_state = 75, .external_lex_state = 5},
  [4922] = {.lex_state = 75, .external_lex_state = 5},
  [4923] = {.lex_state = 75, .external_lex_state = 5},
  [4924] = {.lex_state = 75, .external_lex_state = 5},
  [4925] = {.lex_state = 75, .external_lex_state = 2},
  [4926] = {.lex_state = 75, .external_lex_state = 5},
  [4927] = {.lex_state = 75, .external_lex_state = 2},
  [4928] = {.lex_state = 75, .external_lex_state = 5},
  [4929] = {.lex_state = 75, .external_lex_state = 5},
  [4930] = {.lex_state = 75, .external_lex_state = 2},
  [4931] = {.lex_state = 75, .external_lex_state = 5},
  [4932] = {.lex_state = 75, .external_lex_state = 5},
  [4933] = {.lex_state = 75, .external_lex_state = 5},
  [4934] = {.lex_state = 75, .external_lex_state = 5},
  [4935] = {.lex_state = 75, .external_lex_state = 2},
  [4936] = {.lex_state = 75, .external_lex_state = 5},
  [4937] = {.lex_state = 75, .external_lex_state = 5},
  [4938] = {.lex_state = 75, .external_lex_state = 5},
  [4939] = {.lex_state = 75, .external_lex_state = 2},
  [4940] = {.lex_state = 75, .external_lex_state = 5},
  [4941] = {.lex_state = 75, .external_lex_state = 5},
  [4942] = {.lex_state = 75, .external_lex_state = 5},
  [4943] = {.lex_state = 75, .external_lex_state = 5},
  [4944] = {.lex_state = 75, .external_lex_state = 5},
  [4945] = {.lex_state = 75, .external_lex_state = 5},
  [4946] = {.lex_state = 75, .external_lex_state = 2},
  [4947] = {.lex_state = 75, .external_lex_state = 5},
  [4948] = {.lex_state = 75, .external_lex_state = 5},
  [4949] = {.lex_state = 75, .external_lex_state = 2},
  [4950] = {.lex_state = 75, .external_lex_state = 2},
  [4951] = {.lex_state = 75, .external_lex_state = 5},
  [4952] = {.lex_state = 13, .external_lex_state = 8},
  [4953] = {.lex_state = 75, .external_lex_state = 5},
  [4954] = {.lex_state = 75, .external_lex_state = 5},
  [4955] = {.lex_state = 75, .external_lex_state = 2},
  [4956] = {.lex_state = 75, .external_lex_state = 2},
  [4957] = {.lex_state = 75, .external_lex_state = 5},
  [4958] = {.lex_state = 75, .external_lex_state = 2},
  [4959] = {.lex_state = 75, .external_lex_state = 2},
  [4960] = {.lex_state = 75, .external_lex_state = 2},
  [4961] = {.lex_state = 75, .external_lex_state = 2},
  [4962] = {.lex_state = 75, .external_lex_state = 2},
  [4963] = {.lex_state = 75, .external_lex_state = 5},
  [4964] = {.lex_state = 75, .external_lex_state = 2},
  [4965] = {.lex_state = 75, .external_lex_state = 2},
  [4966] = {.lex_state = 75, .external_lex_state = 2},
  [4967] = {.lex_state = 75, .external_lex_state = 2},
  [4968] = {.lex_state = 75, .external_lex_state = 5},
  [4969] = {.lex_state = 75, .external_lex_state = 2},
  [4970] = {.lex_state = 75, .external_lex_state = 5},
  [4971] = {.lex_state = 75, .external_lex_state = 2},
  [4972] = {.lex_state = 75, .external_lex_state = 2},
  [4973] = {.lex_state = 75, .external_lex_state = 2},
  [4974] = {.lex_state = 75, .external_lex_state = 2},
  [4975] = {.lex_state = 75, .external_lex_state = 2},
  [4976] = {.lex_state = 75, .external_lex_state = 5},
  [4977] = {.lex_state = 75, .external_lex_state = 2},
  [4978] = {.lex_state = 75, .external_lex_state = 5},
  [4979] = {.lex_state = 75, .external_lex_state = 5},
  [4980] = {.lex_state = 75, .external_lex_state = 2},
  [4981] = {.lex_state = 75, .external_lex_state = 2},
  [4982] = {.lex_state = 75, .external_lex_state = 2},
  [4983] = {.lex_state = 75, .external_lex_state = 5},
  [4984] = {.lex_state = 75, .external_lex_state = 5},
  [4985] = {.lex_state = 75, .external_lex_state = 5},
  [4986] = {.lex_state = 75, .external_lex_state = 5},
  [4987] = {.lex_state = 75, .external_lex_state = 2},
  [4988] = {.lex_state = 75, .external_lex_state = 5},
  [4989] = {.lex_state = 75, .external_lex_state = 2},
  [4990] = {.lex_state = 75, .external_lex_state = 2},
  [4991] = {.lex_state = 75, .external_lex_state = 5},
  [4992] = {.lex_state = 75, .external_lex_state = 2},
  [4993] = {.lex_state = 75, .external_lex_state = 2},
  [4994] = {.lex_state = 75, .external_lex_state = 2},
  [4995] = {.lex_state = 75, .external_lex_state = 5},
  [4996] = {.lex_state = 75, .external_lex_state = 2},
  [4997] = {.lex_state = 75, .external_lex_state = 2},
  [4998] = {.lex_state = 75, .external_lex_state = 2},
  [4999] = {.lex_state = 75, .external_lex_state = 2},
  [5000] = {.lex_state = 75, .external_lex_state = 2},
  [5001] = {.lex_state = 75, .external_lex_state = 2},
  [5002] = {.lex_state = 75, .external_lex_state = 5},
  [5003] = {.lex_state = 75, .external_lex_state = 2},
  [5004] = {.lex_state = 75, .external_lex_state = 2},
  [5005] = {.lex_state = 75, .external_lex_state = 2},
  [5006] = {.lex_state = 75, .external_lex_state = 2},
  [5007] = {.lex_state = 75, .external_lex_state = 5},
  [5008] = {.lex_state = 75, .external_lex_state = 2},
  [5009] = {.lex_state = 75, .external_lex_state = 5},
  [5010] = {.lex_state = 75, .external_lex_state = 5},
  [5011] = {.lex_state = 75, .external_lex_state = 2},
  [5012] = {.lex_state = 75, .external_lex_state = 5},
  [5013] = {.lex_state = 75, .external_lex_state = 2},
  [5014] = {.lex_state = 75, .external_lex_state = 2},
  [5015] = {.lex_state = 75, .external_lex_state = 5},
  [5016] = {.lex_state = 75, .external_lex_state = 2},
  [5017] = {.lex_state = 75, .external_lex_state = 5},
  [5018] = {.lex_state = 75, .external_lex_state = 2},
  [5019] = {.lex_state = 75, .external_lex_state = 2},
  [5020] = {.lex_state = 75, .external_lex_state = 2},
  [5021] = {.lex_state = 75, .external_lex_state = 5},
  [5022] = {.lex_state = 75, .external_lex_state = 2},
  [5023] = {.lex_state = 75, .external_lex_state = 2},
  [5024] = {.lex_state = 75, .external_lex_state = 5},
  [5025] = {.lex_state = 75, .external_lex_state = 5},
  [5026] = {.lex_state = 75, .external_lex_state = 2},
  [5027] = {.lex_state = 75, .external_lex_state = 2},
  [5028] = {.lex_state = 75, .external_lex_state = 5},
  [5029] = {.lex_state = 75, .external_lex_state = 2},
  [5030] = {.lex_state = 75, .external_lex_state = 2},
  [5031] = {.lex_state = 75, .external_lex_state = 5},
  [5032] = {.lex_state = 75, .external_lex_state = 2},
  [5033] = {.lex_state = 75, .external_lex_state = 2},
  [5034] = {.lex_state = 75, .external_lex_state = 5},
  [5035] = {.lex_state = 75, .external_lex_state = 5},
  [5036] = {.lex_state = 75, .external_lex_state = 5},
  [5037] = {.lex_state = 75, .external_lex_state = 5},
  [5038] = {.lex_state = 75, .external_lex_state = 2},
  [5039] = {.lex_state = 75, .external_lex_state = 5},
  [5040] = {.lex_state = 75, .external_lex_state = 5},
  [5041] = {.lex_state = 75, .external_lex_state = 5},
  [5042] = {.lex_state = 75, .external_lex_state = 5},
  [5043] = {.lex_state = 75, .external_lex_state = 5},
  [5044] = {.lex_state = 75, .external_lex_state = 5},
  [5045] = {.lex_state = 75, .external_lex_state = 5},
  [5046] = {.lex_state = 75, .external_lex_state = 5},
  [5047] = {.lex_state = 75, .external_lex_state = 5},
  [5048] = {.lex_state = 75, .external_lex_state = 5},
  [5049] = {.lex_state = 75, .external_lex_state = 5},
  [5050] = {.lex_state = 75, .external_lex_state = 5},
  [5051] = {.lex_state = 75, .external_lex_state = 5},
  [5052] = {.lex_state = 75, .external_lex_state = 2},
  [5053] = {.lex_state = 75, .external_lex_state = 5},
  [5054] = {.lex_state = 75, .external_lex_state = 5},
  [5055] = {.lex_state = 75, .external_lex_state = 5},
  [5056] = {.lex_state = 75, .external_lex_state = 5},
  [5057] = {.lex_state = 75, .external_lex_state = 5},
  [5058] = {.lex_state = 75, .external_lex_state = 5},
  [5059] = {.lex_state = 75, .external_lex_state = 5},
  [5060] = {.lex_state = 75, .external_lex_state = 5},
  [5061] = {.lex_state = 75, .external_lex_state = 5},
  [5062] = {.lex_state = 75, .external_lex_state = 2},
  [5063] = {.lex_state = 75, .external_lex_state = 5},
  [5064] = {.lex_state = 75, .external_lex_state = 5},
  [5065] = {.lex_state = 75, .external_lex_state = 5},
  [5066] = {.lex_state = 75, .external_lex_state = 5},
  [5067] = {.lex_state = 75, .external_lex_state = 5},
  [5068] = {.lex_state = 75, .external_lex_state = 5},
  [5069] = {.lex_state = 75, .external_lex_state = 5},
  [5070] = {.lex_state = 75, .external_lex_state = 5},
  [5071] = {.lex_state = 75, .external_lex_state = 5},
  [5072] = {.lex_state = 75, .external_lex_state = 5},
  [5073] = {.lex_state = 75, .external_lex_state = 5},
  [5074] = {.lex_state = 75, .external_lex_state = 5},
  [5075] = {.lex_state = 2, .external_lex_state = 2},
  [5076] = {.lex_state = 2, .external_lex_state = 2},
  [5077] = {.lex_state = 75, .external_lex_state = 5},
  [5078] = {.lex_state = 75, .external_lex_state = 5},
  [5079] = {.lex_state = 75, .external_lex_state = 5},
  [5080] = {.lex_state = 75, .external_lex_state = 2},
  [5081] = {.lex_state = 75, .external_lex_state = 5},
  [5082] = {.lex_state = 75, .external_lex_state = 5},
  [5083] = {.lex_state = 75, .external_lex_state = 5},
  [5084] = {.lex_state = 75, .external_lex_state = 5},
  [5085] = {.lex_state = 75, .external_lex_state = 5},
  [5086] = {.lex_state = 75, .external_lex_state = 5},
  [5087] = {.lex_state = 75, .external_lex_state = 5},
  [5088] = {.lex_state = 75, .external_lex_state = 5},
  [5089] = {.lex_state = 75, .external_lex_state = 5},
  [5090] = {.lex_state = 75, .external_lex_state = 5},
  [5091] = {.lex_state = 75, .external_lex_state = 5},
  [5092] = {.lex_state = 75, .external_lex_state = 5},
  [5093] = {.lex_state = 75, .external_lex_state = 5},
  [5094] = {.lex_state = 75, .external_lex_state = 5},
  [5095] = {.lex_state = 75, .external_lex_state = 5},
  [5096] = {.lex_state = 75, .external_lex_state = 2},
  [5097] = {.lex_state = 75, .external_lex_state = 5},
  [5098] = {.lex_state = 75, .external_lex_state = 5},
  [5099] = {.lex_state = 75, .external_lex_state = 5},
  [5100] = {.lex_state = 75, .external_lex_state = 5},
  [5101] = {.lex_state = 75, .external_lex_state = 5},
  [5102] = {.lex_state = 75, .external_lex_state = 5},
  [5103] = {.lex_state = 75, .external_lex_state = 5},
  [5104] = {.lex_state = 75, .external_lex_state = 5},
  [5105] = {.lex_state = 75, .external_lex_state = 5},
  [5106] = {.lex_state = 2, .external_lex_state = 2},
  [5107] = {.lex_state = 75, .external_lex_state = 5},
  [5108] = {.lex_state = 2, .external_lex_state = 2},
  [5109] = {.lex_state = 75, .external_lex_state = 5},
  [5110] = {.lex_state = 75, .external_lex_state = 5},
  [5111] = {.lex_state = 75, .external_lex_state = 5},
  [5112] = {.lex_state = 75, .external_lex_state = 5},
  [5113] = {.lex_state = 75, .external_lex_state = 5},
  [5114] = {.lex_state = 75, .external_lex_state = 5},
  [5115] = {.lex_state = 75, .external_lex_state = 2},
  [5116] = {.lex_state = 75, .external_lex_state = 2},
  [5117] = {.lex_state = 75, .external_lex_state = 5},
  [5118] = {.lex_state = 75, .external_lex_state = 5},
  [5119] = {.lex_state = 75, .external_lex_state = 5},
  [5120] = {.lex_state = 75, .external_lex_state = 5},
  [5121] = {.lex_state = 75, .external_lex_state = 2},
  [5122] = {.lex_state = 75, .external_lex_state = 5},
  [5123] = {.lex_state = 75, .external_lex_state = 5},
  [5124] = {.lex_state = 75, .external_lex_state = 5},
  [5125] = {.lex_state = 75, .external_lex_state = 2},
  [5126] = {.lex_state = 75, .external_lex_state = 2},
  [5127] = {.lex_state = 75, .external_lex_state = 2},
  [5128] = {.lex_state = 75, .external_lex_state = 2},
  [5129] = {.lex_state = 75, .external_lex_state = 5},
  [5130] = {.lex_state = 75, .external_lex_state = 2},
  [5131] = {.lex_state = 75, .external_lex_state = 2},
  [5132] = {.lex_state = 75, .external_lex_state = 2},
  [5133] = {.lex_state = 75, .external_lex_state = 2},
  [5134] = {.lex_state = 75, .external_lex_state = 2},
  [5135] = {.lex_state = 75, .external_lex_state = 2},
  [5136] = {.lex_state = 75, .external_lex_state = 2},
  [5137] = {.lex_state = 75, .external_lex_state = 2},
  [5138] = {.lex_state = 75, .external_lex_state = 2},
  [5139] = {.lex_state = 75, .external_lex_state = 2},
  [5140] = {.lex_state = 75, .external_lex_state = 2},
  [5141] = {.lex_state = 75, .external_lex_state = 2},
  [5142] = {.lex_state = 75, .external_lex_state = 2},
  [5143] = {.lex_state = 75, .external_lex_state = 2},
  [5144] = {.lex_state = 75, .external_lex_state = 2},
  [5145] = {.lex_state = 75, .external_lex_state = 2},
  [5146] = {.lex_state = 75, .external_lex_state = 2},
  [5147] = {.lex_state = 75, .external_lex_state = 2},
  [5148] = {.lex_state = 75, .external_lex_state = 2},
  [5149] = {.lex_state = 75, .external_lex_state = 2},
  [5150] = {.lex_state = 75, .external_lex_state = 2},
  [5151] = {.lex_state = 75, .external_lex_state = 2},
  [5152] = {.lex_state = 75, .external_lex_state = 2},
  [5153] = {.lex_state = 75, .external_lex_state = 2},
  [5154] = {.lex_state = 75, .external_lex_state = 2},
  [5155] = {.lex_state = 75, .external_lex_state = 2},
  [5156] = {.lex_state = 75, .external_lex_state = 2},
  [5157] = {.lex_state = 75, .external_lex_state = 2},
  [5158] = {.lex_state = 75, .external_lex_state = 2},
  [5159] = {.lex_state = 75, .external_lex_state = 2},
  [5160] = {.lex_state = 75, .external_lex_state = 2},
  [5161] = {.lex_state = 75, .external_lex_state = 5},
  [5162] = {.lex_state = 75, .external_lex_state = 2},
  [5163] = {.lex_state = 75, .external_lex_state = 2},
  [5164] = {.lex_state = 75, .external_lex_state = 2},
  [5165] = {.lex_state = 75, .external_lex_state = 2},
  [5166] = {.lex_state = 75, .external_lex_state = 2},
  [5167] = {.lex_state = 75, .external_lex_state = 2},
  [5168] = {.lex_state = 75, .external_lex_state = 2},
  [5169] = {.lex_state = 75, .external_lex_state = 2},
  [5170] = {.lex_state = 75, .external_lex_state = 2},
  [5171] = {.lex_state = 75, .external_lex_state = 2},
  [5172] = {.lex_state = 75, .external_lex_state = 5},
  [5173] = {.lex_state = 75, .external_lex_state = 2},
  [5174] = {.lex_state = 75, .external_lex_state = 2},
  [5175] = {.lex_state = 75, .external_lex_state = 2},
  [5176] = {.lex_state = 75, .external_lex_state = 2},
  [5177] = {.lex_state = 75, .external_lex_state = 2},
  [5178] = {.lex_state = 75, .external_lex_state = 2},
  [5179] = {.lex_state = 75, .external_lex_state = 2},
  [5180] = {.lex_state = 75, .external_lex_state = 2},
  [5181] = {.lex_state = 75, .external_lex_state = 2},
  [5182] = {.lex_state = 75, .external_lex_state = 2},
  [5183] = {.lex_state = 75, .external_lex_state = 2},
  [5184] = {.lex_state = 75, .external_lex_state = 2},
  [5185] = {.lex_state = 75, .external_lex_state = 2},
  [5186] = {.lex_state = 75, .external_lex_state = 2},
  [5187] = {.lex_state = 75, .external_lex_state = 2},
  [5188] = {.lex_state = 75, .external_lex_state = 2},
  [5189] = {.lex_state = 75, .external_lex_state = 2},
  [5190] = {.lex_state = 75, .external_lex_state = 2},
  [5191] = {.lex_state = 75, .external_lex_state = 2},
  [5192] = {.lex_state = 75, .external_lex_state = 2},
  [5193] = {.lex_state = 75, .external_lex_state = 2},
  [5194] = {.lex_state = 75, .external_lex_state = 5},
  [5195] = {.lex_state = 75, .external_lex_state = 5},
  [5196] = {.lex_state = 75, .external_lex_state = 2},
  [5197] = {.lex_state = 75, .external_lex_state = 5},
  [5198] = {.lex_state = 75, .external_lex_state = 2},
  [5199] = {.lex_state = 75, .external_lex_state = 2},
  [5200] = {.lex_state = 75, .external_lex_state = 2},
  [5201] = {.lex_state = 75, .external_lex_state = 2},
  [5202] = {.lex_state = 75, .external_lex_state = 2},
  [5203] = {.lex_state = 75, .external_lex_state = 5},
  [5204] = {.lex_state = 75, .external_lex_state = 2},
  [5205] = {.lex_state = 75, .external_lex_state = 2},
  [5206] = {.lex_state = 75, .external_lex_state = 2},
  [5207] = {.lex_state = 75, .external_lex_state = 5},
  [5208] = {.lex_state = 75, .external_lex_state = 2},
  [5209] = {.lex_state = 75, .external_lex_state = 2},
  [5210] = {.lex_state = 75, .external_lex_state = 2},
  [5211] = {.lex_state = 75, .external_lex_state = 2},
  [5212] = {.lex_state = 75, .external_lex_state = 2},
  [5213] = {.lex_state = 75, .external_lex_state = 2},
  [5214] = {.lex_state = 75, .external_lex_state = 2},
  [5215] = {.lex_state = 75, .external_lex_state = 2},
  [5216] = {.lex_state = 75, .external_lex_state = 2},
  [5217] = {.lex_state = 75, .external_lex_state = 2},
  [5218] = {.lex_state = 75, .external_lex_state = 2},
  [5219] = {.lex_state = 75, .external_lex_state = 2},
  [5220] = {.lex_state = 75, .external_lex_state = 2},
  [5221] = {.lex_state = 75, .external_lex_state = 2},
  [5222] = {.lex_state = 75, .external_lex_state = 2},
  [5223] = {.lex_state = 75, .external_lex_state = 2},
  [5224] = {.lex_state = 75, .external_lex_state = 2},
  [5225] = {.lex_state = 75, .external_lex_state = 2},
  [5226] = {.lex_state = 75, .external_lex_state = 2},
  [5227] = {.lex_state = 75, .external_lex_state = 2},
  [5228] = {.lex_state = 75, .external_lex_state = 2},
  [5229] = {.lex_state = 75, .external_lex_state = 2},
  [5230] = {.lex_state = 75, .external_lex_state = 2},
  [5231] = {.lex_state = 75, .external_lex_state = 2},
  [5232] = {.lex_state = 75, .external_lex_state = 2},
  [5233] = {.lex_state = 75, .external_lex_state = 2},
  [5234] = {.lex_state = 75, .external_lex_state = 2},
  [5235] = {.lex_state = 75, .external_lex_state = 2},
  [5236] = {.lex_state = 75, .external_lex_state = 2},
  [5237] = {.lex_state = 75, .external_lex_state = 2},
  [5238] = {.lex_state = 75, .external_lex_state = 2},
  [5239] = {.lex_state = 75, .external_lex_state = 2},
  [5240] = {.lex_state = 75, .external_lex_state = 2},
  [5241] = {.lex_state = 75, .external_lex_state = 2},
  [5242] = {.lex_state = 75, .external_lex_state = 2},
  [5243] = {.lex_state = 75, .external_lex_state = 2},
  [5244] = {.lex_state = 75, .external_lex_state = 2},
  [5245] = {.lex_state = 75, .external_lex_state = 5},
  [5246] = {.lex_state = 75, .external_lex_state = 2},
  [5247] = {.lex_state = 75, .external_lex_state = 2},
  [5248] = {.lex_state = 75, .external_lex_state = 2},
  [5249] = {.lex_state = 75, .external_lex_state = 2},
  [5250] = {.lex_state = 75, .external_lex_state = 2},
  [5251] = {.lex_state = 75, .external_lex_state = 2},
  [5252] = {.lex_state = 75, .external_lex_state = 2},
  [5253] = {.lex_state = 75, .external_lex_state = 2},
  [5254] = {.lex_state = 75, .external_lex_state = 2},
  [5255] = {.lex_state = 75, .external_lex_state = 2},
  [5256] = {.lex_state = 75, .external_lex_state = 2},
  [5257] = {.lex_state = 75, .external_lex_state = 2},
  [5258] = {.lex_state = 75, .external_lex_state = 2},
  [5259] = {.lex_state = 75, .external_lex_state = 2},
  [5260] = {.lex_state = 75, .external_lex_state = 2},
  [5261] = {.lex_state = 75, .external_lex_state = 2},
  [5262] = {.lex_state = 75, .external_lex_state = 2},
  [5263] = {.lex_state = 75, .external_lex_state = 2},
  [5264] = {.lex_state = 75, .external_lex_state = 2},
  [5265] = {.lex_state = 75, .external_lex_state = 2},
  [5266] = {.lex_state = 75, .external_lex_state = 2},
  [5267] = {.lex_state = 75, .external_lex_state = 2},
  [5268] = {.lex_state = 75, .external_lex_state = 2},
  [5269] = {.lex_state = 75, .external_lex_state = 2},
  [5270] = {.lex_state = 75, .external_lex_state = 2},
  [5271] = {.lex_state = 75, .external_lex_state = 2},
  [5272] = {.lex_state = 75, .external_lex_state = 2},
  [5273] = {.lex_state = 75, .external_lex_state = 2},
  [5274] = {.lex_state = 75, .external_lex_state = 2},
  [5275] = {.lex_state = 75, .external_lex_state = 2},
  [5276] = {.lex_state = 75, .external_lex_state = 2},
  [5277] = {.lex_state = 75, .external_lex_state = 2},
  [5278] = {.lex_state = 75, .external_lex_state = 2},
  [5279] = {.lex_state = 75, .external_lex_state = 2},
  [5280] = {.lex_state = 75, .external_lex_state = 2},
  [5281] = {.lex_state = 75, .external_lex_state = 2},
  [5282] = {.lex_state = 75, .external_lex_state = 2},
  [5283] = {.lex_state = 75, .external_lex_state = 2},
  [5284] = {.lex_state = 75, .external_lex_state = 5},
  [5285] = {.lex_state = 75, .external_lex_state = 2},
  [5286] = {.lex_state = 75, .external_lex_state = 2},
  [5287] = {.lex_state = 75, .external_lex_state = 2},
  [5288] = {.lex_state = 75, .external_lex_state = 2},
  [5289] = {.lex_state = 75, .external_lex_state = 2},
  [5290] = {.lex_state = 75, .external_lex_state = 2},
  [5291] = {.lex_state = 75, .external_lex_state = 2},
  [5292] = {.lex_state = 75, .external_lex_state = 2},
  [5293] = {.lex_state = 75, .external_lex_state = 2},
  [5294] = {.lex_state = 75, .external_lex_state = 2},
  [5295] = {.lex_state = 75, .external_lex_state = 2},
  [5296] = {.lex_state = 75, .external_lex_state = 2},
  [5297] = {.lex_state = 75, .external_lex_state = 2},
  [5298] = {.lex_state = 75, .external_lex_state = 2},
  [5299] = {.lex_state = 75, .external_lex_state = 2},
  [5300] = {.lex_state = 75, .external_lex_state = 2},
  [5301] = {.lex_state = 75, .external_lex_state = 2},
  [5302] = {.lex_state = 75, .external_lex_state = 2},
  [5303] = {.lex_state = 75, .external_lex_state = 2},
  [5304] = {.lex_state = 75, .external_lex_state = 2},
  [5305] = {.lex_state = 75, .external_lex_state = 5},
  [5306] = {.lex_state = 75, .external_lex_state = 2},
  [5307] = {.lex_state = 75, .external_lex_state = 2},
  [5308] = {.lex_state = 75, .external_lex_state = 2},
  [5309] = {.lex_state = 75, .external_lex_state = 5},
  [5310] = {.lex_state = 75, .external_lex_state = 2},
  [5311] = {.lex_state = 75, .external_lex_state = 2},
  [5312] = {.lex_state = 75, .external_lex_state = 2},
  [5313] = {.lex_state = 75, .external_lex_state = 2},
  [5314] = {.lex_state = 75, .external_lex_state = 2},
  [5315] = {.lex_state = 75, .external_lex_state = 2},
  [5316] = {.lex_state = 75, .external_lex_state = 2},
  [5317] = {.lex_state = 75, .external_lex_state = 2},
  [5318] = {.lex_state = 75, .external_lex_state = 2},
  [5319] = {.lex_state = 75, .external_lex_state = 2},
  [5320] = {.lex_state = 75, .external_lex_state = 2},
  [5321] = {.lex_state = 75, .external_lex_state = 2},
  [5322] = {.lex_state = 75, .external_lex_state = 2},
  [5323] = {.lex_state = 75, .external_lex_state = 2},
  [5324] = {.lex_state = 75, .external_lex_state = 2},
  [5325] = {.lex_state = 75, .external_lex_state = 2},
  [5326] = {.lex_state = 75, .external_lex_state = 2},
  [5327] = {.lex_state = 75, .external_lex_state = 2},
  [5328] = {.lex_state = 75, .external_lex_state = 2},
  [5329] = {.lex_state = 75, .external_lex_state = 2},
  [5330] = {.lex_state = 75, .external_lex_state = 2},
  [5331] = {.lex_state = 75, .external_lex_state = 5},
  [5332] = {.lex_state = 75, .external_lex_state = 2},
  [5333] = {.lex_state = 75, .external_lex_state = 5},
  [5334] = {.lex_state = 75, .external_lex_state = 5},
  [5335] = {.lex_state = 75, .external_lex_state = 2},
  [5336] = {.lex_state = 75, .external_lex_state = 2},
  [5337] = {.lex_state = 75, .external_lex_state = 2},
  [5338] = {.lex_state = 75, .external_lex_state = 2},
  [5339] = {.lex_state = 75, .external_lex_state = 2},
  [5340] = {.lex_state = 75, .external_lex_state = 2},
  [5341] = {.lex_state = 75, .external_lex_state = 2},
  [5342] = {.lex_state = 75, .external_lex_state = 2},
  [5343] = {.lex_state = 75, .external_lex_state = 2},
  [5344] = {.lex_state = 75, .external_lex_state = 2},
  [5345] = {.lex_state = 75, .external_lex_state = 2},
  [5346] = {.lex_state = 75, .external_lex_state = 2},
  [5347] = {.lex_state = 75, .external_lex_state = 2},
  [5348] = {.lex_state = 75, .external_lex_state = 2},
  [5349] = {.lex_state = 75, .external_lex_state = 2},
  [5350] = {.lex_state = 75, .external_lex_state = 2},
  [5351] = {.lex_state = 75, .external_lex_state = 2},
  [5352] = {.lex_state = 75, .external_lex_state = 2},
  [5353] = {.lex_state = 75, .external_lex_state = 2},
  [5354] = {.lex_state = 75, .external_lex_state = 2},
  [5355] = {.lex_state = 75, .external_lex_state = 2},
  [5356] = {.lex_state = 75, .external_lex_state = 5},
  [5357] = {.lex_state = 75, .external_lex_state = 2},
  [5358] = {.lex_state = 75, .external_lex_state = 2},
  [5359] = {.lex_state = 75, .external_lex_state = 5},
  [5360] = {.lex_state = 75, .external_lex_state = 2},
  [5361] = {.lex_state = 75, .external_lex_state = 2},
  [5362] = {.lex_state = 75, .external_lex_state = 2},
  [5363] = {.lex_state = 75, .external_lex_state = 2},
  [5364] = {.lex_state = 75, .external_lex_state = 2},
  [5365] = {.lex_state = 75, .external_lex_state = 2},
  [5366] = {.lex_state = 75, .external_lex_state = 2},
  [5367] = {.lex_state = 75, .external_lex_state = 2},
  [5368] = {.lex_state = 75, .external_lex_state = 2},
  [5369] = {.lex_state = 75, .external_lex_state = 2},
  [5370] = {.lex_state = 75, .external_lex_state = 2},
  [5371] = {.lex_state = 75, .external_lex_state = 5},
  [5372] = {.lex_state = 75, .external_lex_state = 2},
  [5373] = {.lex_state = 75, .external_lex_state = 2},
  [5374] = {.lex_state = 75, .external_lex_state = 2},
  [5375] = {.lex_state = 75, .external_lex_state = 2},
  [5376] = {.lex_state = 75, .external_lex_state = 2},
  [5377] = {.lex_state = 75, .external_lex_state = 2},
  [5378] = {.lex_state = 75, .external_lex_state = 2},
  [5379] = {.lex_state = 75, .external_lex_state = 2},
  [5380] = {.lex_state = 75, .external_lex_state = 2},
  [5381] = {.lex_state = 75, .external_lex_state = 2},
  [5382] = {.lex_state = 75, .external_lex_state = 2},
  [5383] = {.lex_state = 75, .external_lex_state = 5},
  [5384] = {.lex_state = 75, .external_lex_state = 2},
  [5385] = {.lex_state = 75, .external_lex_state = 2},
  [5386] = {.lex_state = 75, .external_lex_state = 2},
  [5387] = {.lex_state = 75, .external_lex_state = 2},
  [5388] = {.lex_state = 75, .external_lex_state = 2},
  [5389] = {.lex_state = 75, .external_lex_state = 2},
  [5390] = {.lex_state = 75, .external_lex_state = 2},
  [5391] = {.lex_state = 75, .external_lex_state = 2},
  [5392] = {.lex_state = 75, .external_lex_state = 2},
  [5393] = {.lex_state = 75, .external_lex_state = 2},
  [5394] = {.lex_state = 75, .external_lex_state = 2},
  [5395] = {.lex_state = 75, .external_lex_state = 2},
  [5396] = {.lex_state = 75, .external_lex_state = 2},
  [5397] = {.lex_state = 75, .external_lex_state = 2},
  [5398] = {.lex_state = 75, .external_lex_state = 5},
  [5399] = {.lex_state = 75, .external_lex_state = 2},
  [5400] = {.lex_state = 75, .external_lex_state = 5},
  [5401] = {.lex_state = 75, .external_lex_state = 2},
  [5402] = {.lex_state = 75, .external_lex_state = 2},
  [5403] = {.lex_state = 75, .external_lex_state = 2},
  [5404] = {.lex_state = 75, .external_lex_state = 2},
  [5405] = {.lex_state = 75, .external_lex_state = 2},
  [5406] = {.lex_state = 75, .external_lex_state = 2},
  [5407] = {.lex_state = 75, .external_lex_state = 2},
  [5408] = {.lex_state = 75, .external_lex_state = 2},
  [5409] = {.lex_state = 75, .external_lex_state = 2},
  [5410] = {.lex_state = 75, .external_lex_state = 2},
  [5411] = {.lex_state = 75, .external_lex_state = 2},
  [5412] = {.lex_state = 75, .external_lex_state = 2},
  [5413] = {.lex_state = 75, .external_lex_state = 5},
  [5414] = {.lex_state = 75, .external_lex_state = 2},
  [5415] = {.lex_state = 75, .external_lex_state = 2},
  [5416] = {.lex_state = 75, .external_lex_state = 2},
  [5417] = {.lex_state = 75, .external_lex_state = 2},
  [5418] = {.lex_state = 75, .external_lex_state = 2},
  [5419] = {.lex_state = 75, .external_lex_state = 2},
  [5420] = {.lex_state = 75, .external_lex_state = 2},
  [5421] = {.lex_state = 75, .external_lex_state = 2},
  [5422] = {.lex_state = 75, .external_lex_state = 2},
  [5423] = {.lex_state = 75, .external_lex_state = 5},
  [5424] = {.lex_state = 75, .external_lex_state = 2},
  [5425] = {.lex_state = 75, .external_lex_state = 2},
  [5426] = {.lex_state = 75, .external_lex_state = 2},
  [5427] = {.lex_state = 75, .external_lex_state = 2},
  [5428] = {.lex_state = 75, .external_lex_state = 5},
  [5429] = {.lex_state = 75, .external_lex_state = 2},
  [5430] = {.lex_state = 75, .external_lex_state = 2},
  [5431] = {.lex_state = 75, .external_lex_state = 2},
  [5432] = {.lex_state = 75, .external_lex_state = 2},
  [5433] = {.lex_state = 75, .external_lex_state = 2},
  [5434] = {.lex_state = 75, .external_lex_state = 2},
  [5435] = {.lex_state = 75, .external_lex_state = 2},
  [5436] = {.lex_state = 75, .external_lex_state = 2},
  [5437] = {.lex_state = 75, .external_lex_state = 5},
  [5438] = {.lex_state = 75, .external_lex_state = 2},
  [5439] = {.lex_state = 75, .external_lex_state = 2},
  [5440] = {.lex_state = 75, .external_lex_state = 2},
  [5441] = {.lex_state = 75, .external_lex_state = 2},
  [5442] = {.lex_state = 75, .external_lex_state = 2},
  [5443] = {.lex_state = 75, .external_lex_state = 2},
  [5444] = {.lex_state = 75, .external_lex_state = 2},
  [5445] = {.lex_state = 75, .external_lex_state = 2},
  [5446] = {.lex_state = 75, .external_lex_state = 2},
  [5447] = {.lex_state = 75, .external_lex_state = 2},
  [5448] = {.lex_state = 75, .external_lex_state = 2},
  [5449] = {.lex_state = 75, .external_lex_state = 2},
  [5450] = {.lex_state = 75, .external_lex_state = 2},
  [5451] = {.lex_state = 75, .external_lex_state = 2},
  [5452] = {.lex_state = 75, .external_lex_state = 2},
  [5453] = {.lex_state = 75, .external_lex_state = 2},
  [5454] = {.lex_state = 75, .external_lex_state = 2},
  [5455] = {.lex_state = 75, .external_lex_state = 2},
  [5456] = {.lex_state = 75, .external_lex_state = 2},
  [5457] = {.lex_state = 75, .external_lex_state = 5},
  [5458] = {.lex_state = 75, .external_lex_state = 2},
  [5459] = {.lex_state = 75, .external_lex_state = 2},
  [5460] = {.lex_state = 75, .external_lex_state = 5},
  [5461] = {.lex_state = 75, .external_lex_state = 5},
  [5462] = {.lex_state = 75, .external_lex_state = 2},
  [5463] = {.lex_state = 75, .external_lex_state = 2},
  [5464] = {.lex_state = 75, .external_lex_state = 2},
  [5465] = {.lex_state = 75, .external_lex_state = 2},
  [5466] = {.lex_state = 75, .external_lex_state = 2},
  [5467] = {.lex_state = 75, .external_lex_state = 2},
  [5468] = {.lex_state = 75, .external_lex_state = 2},
  [5469] = {.lex_state = 75, .external_lex_state = 2},
  [5470] = {.lex_state = 75, .external_lex_state = 2},
  [5471] = {.lex_state = 75, .external_lex_state = 2},
  [5472] = {.lex_state = 75, .external_lex_state = 2},
  [5473] = {.lex_state = 75, .external_lex_state = 2},
  [5474] = {.lex_state = 75, .external_lex_state = 2},
  [5475] = {.lex_state = 75, .external_lex_state = 2},
  [5476] = {.lex_state = 75, .external_lex_state = 2},
  [5477] = {.lex_state = 75, .external_lex_state = 2},
  [5478] = {.lex_state = 75, .external_lex_state = 2},
  [5479] = {.lex_state = 75, .external_lex_state = 2},
  [5480] = {.lex_state = 75, .external_lex_state = 2},
  [5481] = {.lex_state = 75, .external_lex_state = 2},
  [5482] = {.lex_state = 1, .external_lex_state = 10},
  [5483] = {.lex_state = 75, .external_lex_state = 2},
  [5484] = {.lex_state = 75, .external_lex_state = 2},
  [5485] = {.lex_state = 75, .external_lex_state = 2},
  [5486] = {.lex_state = 75, .external_lex_state = 2},
  [5487] = {.lex_state = 75, .external_lex_state = 2},
  [5488] = {.lex_state = 75, .external_lex_state = 2},
  [5489] = {.lex_state = 75, .external_lex_state = 2},
  [5490] = {.lex_state = 75, .external_lex_state = 2},
  [5491] = {.lex_state = 75, .external_lex_state = 2},
  [5492] = {.lex_state = 75, .external_lex_state = 2},
  [5493] = {.lex_state = 75, .external_lex_state = 2},
  [5494] = {.lex_state = 1, .external_lex_state = 10},
  [5495] = {.lex_state = 75, .external_lex_state = 2},
  [5496] = {.lex_state = 75, .external_lex_state = 2},
  [5497] = {.lex_state = 75, .external_lex_state = 2},
  [5498] = {.lex_state = 75, .external_lex_state = 2},
  [5499] = {.lex_state = 75, .external_lex_state = 2},
  [5500] = {.lex_state = 75, .external_lex_state = 2},
  [5501] = {.lex_state = 75, .external_lex_state = 2},
  [5502] = {.lex_state = 75, .external_lex_state = 2},
  [5503] = {.lex_state = 75, .external_lex_state = 2},
  [5504] = {.lex_state = 75, .external_lex_state = 2},
  [5505] = {.lex_state = 75, .external_lex_state = 2},
  [5506] = {.lex_state = 75, .external_lex_state = 2},
  [5507] = {.lex_state = 75, .external_lex_state = 2},
  [5508] = {.lex_state = 75, .external_lex_state = 2},
  [5509] = {.lex_state = 75, .external_lex_state = 2},
  [5510] = {.lex_state = 75, .external_lex_state = 2},
  [5511] = {.lex_state = 75, .external_lex_state = 2},
  [5512] = {.lex_state = 75, .external_lex_state = 2},
  [5513] = {.lex_state = 75, .external_lex_state = 2},
  [5514] = {.lex_state = 75, .external_lex_state = 2},
  [5515] = {.lex_state = 75, .external_lex_state = 2},
  [5516] = {.lex_state = 75, .external_lex_state = 2},
  [5517] = {.lex_state = 75, .external_lex_state = 2},
  [5518] = {.lex_state = 75, .external_lex_state = 2},
  [5519] = {.lex_state = 75, .external_lex_state = 2},
  [5520] = {.lex_state = 75, .external_lex_state = 2},
  [5521] = {.lex_state = 75, .external_lex_state = 2},
  [5522] = {.lex_state = 75, .external_lex_state = 2},
  [5523] = {.lex_state = 75, .external_lex_state = 2},
  [5524] = {.lex_state = 75, .external_lex_state = 2},
  [5525] = {.lex_state = 75, .external_lex_state = 2},
  [5526] = {.lex_state = 75, .external_lex_state = 2},
  [5527] = {.lex_state = 75, .external_lex_state = 2},
  [5528] = {.lex_state = 75, .external_lex_state = 2},
  [5529] = {.lex_state = 75, .external_lex_state = 2},
  [5530] = {.lex_state = 75, .external_lex_state = 2},
  [5531] = {.lex_state = 75, .external_lex_state = 2},
  [5532] = {.lex_state = 75, .external_lex_state = 2},
  [5533] = {.lex_state = 75, .external_lex_state = 2},
  [5534] = {.lex_state = 75, .external_lex_state = 2},
  [5535] = {.lex_state = 75, .external_lex_state = 2},
  [5536] = {.lex_state = 75, .external_lex_state = 2},
  [5537] = {.lex_state = 75, .external_lex_state = 2},
  [5538] = {.lex_state = 75, .external_lex_state = 2},
  [5539] = {.lex_state = 75, .external_lex_state = 2},
  [5540] = {.lex_state = 75, .external_lex_state = 2},
  [5541] = {.lex_state = 75, .external_lex_state = 2},
  [5542] = {.lex_state = 75, .external_lex_state = 2},
  [5543] = {.lex_state = 75, .external_lex_state = 2},
  [5544] = {.lex_state = 75, .external_lex_state = 2},
  [5545] = {.lex_state = 75, .external_lex_state = 2},
  [5546] = {.lex_state = 75, .external_lex_state = 2},
  [5547] = {.lex_state = 75, .external_lex_state = 2},
  [5548] = {.lex_state = 75, .external_lex_state = 2},
  [5549] = {.lex_state = 75, .external_lex_state = 2},
  [5550] = {.lex_state = 75, .external_lex_state = 2},
  [5551] = {.lex_state = 75, .external_lex_state = 2},
  [5552] = {.lex_state = 75, .external_lex_state = 2},
  [5553] = {.lex_state = 23, .external_lex_state = 2},
  [5554] = {.lex_state = 75, .external_lex_state = 2},
  [5555] = {.lex_state = 75, .external_lex_state = 2},
  [5556] = {.lex_state = 75, .external_lex_state = 2},
  [5557] = {.lex_state = 75, .external_lex_state = 2},
  [5558] = {.lex_state = 75, .external_lex_state = 2},
  [5559] = {.lex_state = 75, .external_lex_state = 2},
  [5560] = {.lex_state = 75, .external_lex_state = 2},
  [5561] = {.lex_state = 75, .external_lex_state = 2},
  [5562] = {.lex_state = 75, .external_lex_state = 2},
  [5563] = {.lex_state = 75, .external_lex_state = 2},
  [5564] = {.lex_state = 75, .external_lex_state = 2},
  [5565] = {.lex_state = 75, .external_lex_state = 2},
  [5566] = {.lex_state = 75, .external_lex_state = 2},
  [5567] = {.lex_state = 75, .external_lex_state = 2},
  [5568] = {.lex_state = 75, .external_lex_state = 2},
  [5569] = {.lex_state = 75, .external_lex_state = 2},
  [5570] = {.lex_state = 75, .external_lex_state = 2},
  [5571] = {.lex_state = 75, .external_lex_state = 2},
  [5572] = {.lex_state = 75, .external_lex_state = 2},
  [5573] = {.lex_state = 75, .external_lex_state = 2},
  [5574] = {.lex_state = 75, .external_lex_state = 2},
  [5575] = {.lex_state = 75, .external_lex_state = 2},
  [5576] = {.lex_state = 75, .external_lex_state = 2},
  [5577] = {.lex_state = 75, .external_lex_state = 2},
  [5578] = {.lex_state = 75, .external_lex_state = 2},
  [5579] = {.lex_state = 75, .external_lex_state = 2},
  [5580] = {.lex_state = 75, .external_lex_state = 2},
  [5581] = {.lex_state = 75, .external_lex_state = 2},
  [5582] = {.lex_state = 75, .external_lex_state = 2},
  [5583] = {.lex_state = 75, .external_lex_state = 2},
  [5584] = {.lex_state = 75, .external_lex_state = 2},
  [5585] = {.lex_state = 75, .external_lex_state = 2},
  [5586] = {.lex_state = 75, .external_lex_state = 2},
  [5587] = {.lex_state = 75, .external_lex_state = 2},
  [5588] = {.lex_state = 75, .external_lex_state = 2},
  [5589] = {.lex_state = 75, .external_lex_state = 2},
  [5590] = {.lex_state = 75, .external_lex_state = 2},
  [5591] = {.lex_state = 75, .external_lex_state = 2},
  [5592] = {.lex_state = 75, .external_lex_state = 2},
  [5593] = {.lex_state = 75, .external_lex_state = 2},
  [5594] = {.lex_state = 75, .external_lex_state = 2},
  [5595] = {.lex_state = 75, .external_lex_state = 2},
  [5596] = {.lex_state = 75, .external_lex_state = 2},
  [5597] = {.lex_state = 75, .external_lex_state = 2},
  [5598] = {.lex_state = 75, .external_lex_state = 2},
  [5599] = {.lex_state = 75, .external_lex_state = 2},
  [5600] = {.lex_state = 75, .external_lex_state = 2},
  [5601] = {.lex_state = 75, .external_lex_state = 2},
  [5602] = {.lex_state = 75, .external_lex_state = 2},
  [5603] = {.lex_state = 75, .external_lex_state = 2},
  [5604] = {.lex_state = 75, .external_lex_state = 2},
  [5605] = {.lex_state = 75, .external_lex_state = 2},
  [5606] = {.lex_state = 75, .external_lex_state = 2},
  [5607] = {.lex_state = 75, .external_lex_state = 2},
  [5608] = {.lex_state = 75, .external_lex_state = 2},
  [5609] = {.lex_state = 75, .external_lex_state = 2},
  [5610] = {.lex_state = 75, .external_lex_state = 2},
  [5611] = {.lex_state = 75, .external_lex_state = 2},
  [5612] = {.lex_state = 75, .external_lex_state = 2},
  [5613] = {.lex_state = 75, .external_lex_state = 2},
  [5614] = {.lex_state = 75, .external_lex_state = 2},
  [5615] = {.lex_state = 75, .external_lex_state = 2},
  [5616] = {.lex_state = 75, .external_lex_state = 2},
  [5617] = {.lex_state = 75, .external_lex_state = 2},
  [5618] = {.lex_state = 75, .external_lex_state = 2},
  [5619] = {.lex_state = 75, .external_lex_state = 2},
  [5620] = {.lex_state = 75, .external_lex_state = 2},
  [5621] = {.lex_state = 75, .external_lex_state = 2},
  [5622] = {.lex_state = 75, .external_lex_state = 2},
  [5623] = {.lex_state = 75, .external_lex_state = 2},
  [5624] = {.lex_state = 75, .external_lex_state = 2},
  [5625] = {.lex_state = 75, .external_lex_state = 2},
  [5626] = {.lex_state = 75, .external_lex_state = 2},
  [5627] = {.lex_state = 1, .external_lex_state = 10},
  [5628] = {.lex_state = 75, .external_lex_state = 2},
  [5629] = {.lex_state = 75, .external_lex_state = 2},
  [5630] = {.lex_state = 75, .external_lex_state = 2},
  [5631] = {.lex_state = 75, .external_lex_state = 2},
  [5632] = {.lex_state = 75, .external_lex_state = 2},
  [5633] = {.lex_state = 75, .external_lex_state = 2},
  [5634] = {.lex_state = 75, .external_lex_state = 2},
  [5635] = {.lex_state = 75, .external_lex_state = 2},
  [5636] = {.lex_state = 75, .external_lex_state = 2},
  [5637] = {.lex_state = 75, .external_lex_state = 2},
  [5638] = {.lex_state = 75, .external_lex_state = 2},
  [5639] = {.lex_state = 75, .external_lex_state = 2},
  [5640] = {.lex_state = 75, .external_lex_state = 2},
  [5641] = {.lex_state = 75, .external_lex_state = 2},
  [5642] = {.lex_state = 75, .external_lex_state = 2},
  [5643] = {.lex_state = 75, .external_lex_state = 2},
  [5644] = {.lex_state = 75, .external_lex_state = 2},
  [5645] = {.lex_state = 75, .external_lex_state = 2},
  [5646] = {.lex_state = 75, .external_lex_state = 2},
  [5647] = {.lex_state = 75, .external_lex_state = 2},
  [5648] = {.lex_state = 75, .external_lex_state = 2},
  [5649] = {.lex_state = 23, .external_lex_state = 2},
  [5650] = {.lex_state = 75, .external_lex_state = 2},
  [5651] = {.lex_state = 75, .external_lex_state = 2},
  [5652] = {.lex_state = 75, .external_lex_state = 2},
  [5653] = {.lex_state = 75, .external_lex_state = 2},
  [5654] = {.lex_state = 75, .external_lex_state = 2},
  [5655] = {.lex_state = 1, .external_lex_state = 10},
  [5656] = {.lex_state = 75, .external_lex_state = 2},
  [5657] = {.lex_state = 75, .external_lex_state = 2},
  [5658] = {.lex_state = 75, .external_lex_state = 2},
  [5659] = {.lex_state = 75, .external_lex_state = 2},
  [5660] = {.lex_state = 75, .external_lex_state = 2},
  [5661] = {.lex_state = 75, .external_lex_state = 2},
  [5662] = {.lex_state = 23, .external_lex_state = 2},
  [5663] = {.lex_state = 75, .external_lex_state = 2},
  [5664] = {.lex_state = 75, .external_lex_state = 2},
  [5665] = {.lex_state = 75, .external_lex_state = 2},
  [5666] = {.lex_state = 75, .external_lex_state = 2},
  [5667] = {.lex_state = 75, .external_lex_state = 2},
  [5668] = {.lex_state = 1, .external_lex_state = 10},
  [5669] = {.lex_state = 75, .external_lex_state = 2},
  [5670] = {.lex_state = 75, .external_lex_state = 2},
  [5671] = {.lex_state = 75, .external_lex_state = 2},
  [5672] = {.lex_state = 75, .external_lex_state = 2},
  [5673] = {.lex_state = 75, .external_lex_state = 2},
  [5674] = {.lex_state = 75, .external_lex_state = 2},
  [5675] = {.lex_state = 75, .external_lex_state = 2},
  [5676] = {.lex_state = 75, .external_lex_state = 2},
  [5677] = {.lex_state = 75, .external_lex_state = 2},
  [5678] = {.lex_state = 75, .external_lex_state = 2},
  [5679] = {.lex_state = 75, .external_lex_state = 2},
  [5680] = {.lex_state = 75, .external_lex_state = 2},
  [5681] = {.lex_state = 75, .external_lex_state = 2},
  [5682] = {.lex_state = 75, .external_lex_state = 2},
  [5683] = {.lex_state = 23, .external_lex_state = 2},
  [5684] = {.lex_state = 75, .external_lex_state = 2},
  [5685] = {.lex_state = 75, .external_lex_state = 2},
  [5686] = {.lex_state = 75, .external_lex_state = 2},
  [5687] = {.lex_state = 75, .external_lex_state = 2},
  [5688] = {.lex_state = 75, .external_lex_state = 2},
  [5689] = {.lex_state = 75, .external_lex_state = 2},
  [5690] = {.lex_state = 75, .external_lex_state = 2},
  [5691] = {.lex_state = 75, .external_lex_state = 2},
  [5692] = {.lex_state = 75, .external_lex_state = 2},
  [5693] = {.lex_state = 75, .external_lex_state = 2},
  [5694] = {.lex_state = 75, .external_lex_state = 2},
  [5695] = {.lex_state = 75, .external_lex_state = 2},
  [5696] = {.lex_state = 75, .external_lex_state = 2},
  [5697] = {.lex_state = 75, .external_lex_state = 2},
  [5698] = {.lex_state = 75, .external_lex_state = 2},
  [5699] = {.lex_state = 75, .external_lex_state = 2},
  [5700] = {.lex_state = 75, .external_lex_state = 2},
  [5701] = {.lex_state = 75, .external_lex_state = 2},
  [5702] = {.lex_state = 75, .external_lex_state = 2},
  [5703] = {.lex_state = 75, .external_lex_state = 2},
  [5704] = {.lex_state = 75, .external_lex_state = 2},
  [5705] = {.lex_state = 75, .external_lex_state = 2},
  [5706] = {.lex_state = 75, .external_lex_state = 2},
  [5707] = {.lex_state = 75, .external_lex_state = 2},
  [5708] = {.lex_state = 75, .external_lex_state = 2},
  [5709] = {.lex_state = 75, .external_lex_state = 2},
  [5710] = {.lex_state = 75, .external_lex_state = 2},
  [5711] = {.lex_state = 75, .external_lex_state = 2},
  [5712] = {.lex_state = 75, .external_lex_state = 2},
  [5713] = {.lex_state = 75, .external_lex_state = 2},
  [5714] = {.lex_state = 75, .external_lex_state = 2},
  [5715] = {.lex_state = 75, .external_lex_state = 2},
  [5716] = {.lex_state = 75, .external_lex_state = 2},
  [5717] = {.lex_state = 75, .external_lex_state = 2},
  [5718] = {.lex_state = 75, .external_lex_state = 2},
  [5719] = {.lex_state = 75, .external_lex_state = 2},
  [5720] = {.lex_state = 75, .external_lex_state = 2},
  [5721] = {.lex_state = 75, .external_lex_state = 2},
  [5722] = {.lex_state = 75, .external_lex_state = 2},
  [5723] = {.lex_state = 75, .external_lex_state = 2},
  [5724] = {.lex_state = 75, .external_lex_state = 2},
  [5725] = {.lex_state = 75, .external_lex_state = 2},
  [5726] = {.lex_state = 75, .external_lex_state = 2},
  [5727] = {.lex_state = 75, .external_lex_state = 2},
  [5728] = {.lex_state = 75, .external_lex_state = 2},
  [5729] = {.lex_state = 75, .external_lex_state = 2},
  [5730] = {.lex_state = 75, .external_lex_state = 2},
  [5731] = {.lex_state = 75, .external_lex_state = 2},
  [5732] = {.lex_state = 75, .external_lex_state = 2},
  [5733] = {.lex_state = 75, .external_lex_state = 2},
  [5734] = {.lex_state = 75, .external_lex_state = 2},
  [5735] = {.lex_state = 75, .external_lex_state = 2},
  [5736] = {.lex_state = 75, .external_lex_state = 2},
  [5737] = {.lex_state = 75, .external_lex_state = 2},
  [5738] = {.lex_state = 75, .external_lex_state = 2},
  [5739] = {.lex_state = 75, .external_lex_state = 2},
  [5740] = {.lex_state = 75, .external_lex_state = 2},
  [5741] = {.lex_state = 75, .external_lex_state = 2},
  [5742] = {.lex_state = 75, .external_lex_state = 2},
  [5743] = {.lex_state = 75, .external_lex_state = 2},
  [5744] = {.lex_state = 75, .external_lex_state = 2},
  [5745] = {.lex_state = 75, .external_lex_state = 2},
  [5746] = {.lex_state = 75, .external_lex_state = 2},
  [5747] = {.lex_state = 75, .external_lex_state = 2},
  [5748] = {.lex_state = 75, .external_lex_state = 2},
  [5749] = {.lex_state = 75, .external_lex_state = 2},
  [5750] = {.lex_state = 75, .external_lex_state = 2},
  [5751] = {.lex_state = 75, .external_lex_state = 2},
  [5752] = {.lex_state = 75, .external_lex_state = 2},
  [5753] = {.lex_state = 75, .external_lex_state = 2},
  [5754] = {.lex_state = 75, .external_lex_state = 2},
  [5755] = {.lex_state = 75, .external_lex_state = 2},
  [5756] = {.lex_state = 75, .external_lex_state = 2},
  [5757] = {.lex_state = 75, .external_lex_state = 2},
  [5758] = {.lex_state = 75, .external_lex_state = 2},
  [5759] = {.lex_state = 75, .external_lex_state = 2},
  [5760] = {.lex_state = 75, .external_lex_state = 2},
  [5761] = {.lex_state = 75, .external_lex_state = 2},
  [5762] = {.lex_state = 75, .external_lex_state = 2},
  [5763] = {.lex_state = 75, .external_lex_state = 2},
  [5764] = {.lex_state = 75, .external_lex_state = 2},
  [5765] = {.lex_state = 75, .external_lex_state = 2},
  [5766] = {.lex_state = 75, .external_lex_state = 2},
  [5767] = {.lex_state = 75, .external_lex_state = 2},
  [5768] = {.lex_state = 75, .external_lex_state = 2},
  [5769] = {.lex_state = 75, .external_lex_state = 2},
  [5770] = {.lex_state = 75, .external_lex_state = 2},
  [5771] = {.lex_state = 75, .external_lex_state = 2},
  [5772] = {.lex_state = 75, .external_lex_state = 2},
  [5773] = {.lex_state = 75, .external_lex_state = 2},
  [5774] = {.lex_state = 75, .external_lex_state = 2},
  [5775] = {.lex_state = 75, .external_lex_state = 2},
  [5776] = {.lex_state = 75, .external_lex_state = 2},
  [5777] = {.lex_state = 75, .external_lex_state = 2},
  [5778] = {.lex_state = 75, .external_lex_state = 2},
  [5779] = {.lex_state = 75, .external_lex_state = 2},
  [5780] = {.lex_state = 75, .external_lex_state = 2},
  [5781] = {.lex_state = 75, .external_lex_state = 2},
  [5782] = {.lex_state = 75, .external_lex_state = 2},
  [5783] = {.lex_state = 75, .external_lex_state = 2},
  [5784] = {.lex_state = 75, .external_lex_state = 2},
  [5785] = {.lex_state = 75, .external_lex_state = 2},
  [5786] = {.lex_state = 75, .external_lex_state = 2},
  [5787] = {.lex_state = 75, .external_lex_state = 2},
  [5788] = {.lex_state = 75, .external_lex_state = 2},
  [5789] = {.lex_state = 75, .external_lex_state = 2},
  [5790] = {.lex_state = 75, .external_lex_state = 2},
  [5791] = {.lex_state = 75, .external_lex_state = 2},
  [5792] = {.lex_state = 75, .external_lex_state = 2},
  [5793] = {.lex_state = 75, .external_lex_state = 2},
  [5794] = {.lex_state = 75, .external_lex_state = 2},
  [5795] = {.lex_state = 75, .external_lex_state = 2},
  [5796] = {.lex_state = 75, .external_lex_state = 2},
  [5797] = {.lex_state = 75, .external_lex_state = 2},
  [5798] = {.lex_state = 75, .external_lex_state = 2},
  [5799] = {.lex_state = 75, .external_lex_state = 2},
  [5800] = {.lex_state = 75, .external_lex_state = 2},
  [5801] = {.lex_state = 23, .external_lex_state = 2},
  [5802] = {.lex_state = 75, .external_lex_state = 2},
  [5803] = {.lex_state = 75, .external_lex_state = 2},
  [5804] = {.lex_state = 75, .external_lex_state = 2},
  [5805] = {.lex_state = 75, .external_lex_state = 2},
  [5806] = {.lex_state = 75, .external_lex_state = 2},
  [5807] = {.lex_state = 75, .external_lex_state = 2},
  [5808] = {.lex_state = 75, .external_lex_state = 2},
  [5809] = {.lex_state = 75, .external_lex_state = 2},
  [5810] = {.lex_state = 75, .external_lex_state = 2},
  [5811] = {.lex_state = 75, .external_lex_state = 2},
  [5812] = {.lex_state = 75, .external_lex_state = 2},
  [5813] = {.lex_state = 75, .external_lex_state = 2},
  [5814] = {.lex_state = 75, .external_lex_state = 2},
  [5815] = {.lex_state = 75, .external_lex_state = 2},
  [5816] = {.lex_state = 75, .external_lex_state = 2},
  [5817] = {.lex_state = 75, .external_lex_state = 2},
  [5818] = {.lex_state = 75, .external_lex_state = 2},
  [5819] = {.lex_state = 75, .external_lex_state = 2},
  [5820] = {.lex_state = 75, .external_lex_state = 2},
  [5821] = {.lex_state = 75, .external_lex_state = 2},
  [5822] = {.lex_state = 75, .external_lex_state = 2},
  [5823] = {.lex_state = 75, .external_lex_state = 2},
  [5824] = {.lex_state = 75, .external_lex_state = 2},
  [5825] = {.lex_state = 75, .external_lex_state = 2},
  [5826] = {.lex_state = 75, .external_lex_state = 2},
  [5827] = {.lex_state = 75, .external_lex_state = 2},
  [5828] = {.lex_state = 75, .external_lex_state = 2},
  [5829] = {.lex_state = 75, .external_lex_state = 2},
  [5830] = {.lex_state = 75, .external_lex_state = 2},
  [5831] = {.lex_state = 75, .external_lex_state = 2},
  [5832] = {.lex_state = 75, .external_lex_state = 2},
  [5833] = {.lex_state = 75, .external_lex_state = 2},
  [5834] = {.lex_state = 75, .external_lex_state = 2},
  [5835] = {.lex_state = 75, .external_lex_state = 2},
  [5836] = {.lex_state = 75, .external_lex_state = 2},
  [5837] = {.lex_state = 75, .external_lex_state = 2},
  [5838] = {.lex_state = 75, .external_lex_state = 2},
  [5839] = {.lex_state = 75, .external_lex_state = 2},
  [5840] = {.lex_state = 75, .external_lex_state = 2},
  [5841] = {.lex_state = 75, .external_lex_state = 2},
  [5842] = {.lex_state = 75, .external_lex_state = 2},
  [5843] = {.lex_state = 75, .external_lex_state = 2},
  [5844] = {.lex_state = 75, .external_lex_state = 2},
  [5845] = {.lex_state = 75, .external_lex_state = 2},
  [5846] = {.lex_state = 75, .external_lex_state = 2},
  [5847] = {.lex_state = 75, .external_lex_state = 2},
  [5848] = {.lex_state = 75, .external_lex_state = 2},
  [5849] = {.lex_state = 75, .external_lex_state = 2},
  [5850] = {.lex_state = 75, .external_lex_state = 2},
  [5851] = {.lex_state = 75, .external_lex_state = 2},
  [5852] = {.lex_state = 75, .external_lex_state = 2},
  [5853] = {.lex_state = 75, .external_lex_state = 2},
  [5854] = {.lex_state = 75, .external_lex_state = 2},
  [5855] = {.lex_state = 75, .external_lex_state = 2},
  [5856] = {.lex_state = 75, .external_lex_state = 2},
  [5857] = {.lex_state = 75, .external_lex_state = 2},
  [5858] = {.lex_state = 75, .external_lex_state = 2},
  [5859] = {.lex_state = 75, .external_lex_state = 2},
  [5860] = {.lex_state = 75, .external_lex_state = 2},
  [5861] = {.lex_state = 75, .external_lex_state = 2},
  [5862] = {.lex_state = 75, .external_lex_state = 2},
  [5863] = {.lex_state = 75, .external_lex_state = 2},
  [5864] = {.lex_state = 75, .external_lex_state = 2},
  [5865] = {.lex_state = 75, .external_lex_state = 2},
  [5866] = {.lex_state = 75, .external_lex_state = 2},
  [5867] = {.lex_state = 75, .external_lex_state = 2},
  [5868] = {.lex_state = 75, .external_lex_state = 2},
  [5869] = {.lex_state = 75, .external_lex_state = 2},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_namespace] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_debugger] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_QMARK_DOT] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_using] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_private_property_identifier] = ACTIONS(1),
    [anon_sym_target] = ACTIONS(1),
    [anon_sym_meta] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_undefined] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_readonly] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_declare] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_override] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_any] = ACTIONS(1),
    [anon_sym_number] = ACTIONS(1),
    [anon_sym_boolean] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_symbol] = ACTIONS(1),
    [anon_sym_object] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_accessor] = ACTIONS(1),
    [anon_sym_satisfies] = ACTIONS(1),
    [anon_sym_require] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_DASH_QMARK_COLON] = ACTIONS(1),
    [anon_sym_PLUS_QMARK_COLON] = ACTIONS(1),
    [anon_sym_asserts] = ACTIONS(1),
    [anon_sym_infer] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_keyof] = ACTIONS(1),
    [anon_sym_unique] = ACTIONS(1),
    [anon_sym_unknown] = ACTIONS(1),
    [anon_sym_never] = ACTIONS(1),
    [anon_sym_LBRACE_PIPE] = ACTIONS(1),
    [anon_sym_PIPE_RBRACE] = ACTIONS(1),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
    [sym__ternary_qmark] = ACTIONS(1),
    [sym_html_comment] = ACTIONS(5),
    [sym_jsx_text] = ACTIONS(1),
    [sym__function_signature_automatic_semicolon] = ACTIONS(1),
    [sym___error_recovery] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(5657),
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(16),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [sym_hash_bang_line] = ACTIONS(11),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [2] = {
    [sym_import] = STATE(3593),
    [sym_parenthesized_expression] = STATE(1213),
    [sym_expression] = STATE(2644),
    [sym_primary_expression] = STATE(1515),
    [sym_yield_expression] = STATE(1652),
    [sym_object] = STATE(1687),
    [sym_object_pattern] = STATE(3722),
    [sym_array] = STATE(1687),
    [sym_array_pattern] = STATE(3722),
    [sym_nested_identifier] = STATE(5474),
    [sym_class] = STATE(1687),
    [sym_function_expression] = STATE(1687),
    [sym_generator_function] = STATE(1687),
    [sym_arrow_function] = STATE(1687),
    [sym__call_signature] = STATE(5800),
    [sym_call_expression] = STATE(1687),
    [sym_new_expression] = STATE(1648),
    [sym_await_expression] = STATE(1652),
    [sym_member_expression] = STATE(1295),
    [sym_subscript_expression] = STATE(1295),
    [sym_assignment_expression] = STATE(1652),
    [sym__augmented_assignment_lhs] = STATE(3013),
    [sym_augmented_assignment_expression] = STATE(1652),
    [sym__destructuring_pattern] = STATE(3722),
    [sym_ternary_expression] = STATE(1652),
    [sym_binary_expression] = STATE(1652),
    [sym_unary_expression] = STATE(1652),
    [sym_update_expression] = STATE(1652),
    [sym_string] = STATE(2213),
    [sym_template_string] = STATE(1687),
    [sym_regex] = STATE(1687),
    [sym_meta_property] = STATE(1687),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(4087),
    [sym_pattern] = STATE(4312),
    [sym_rest_pattern] = STATE(3684),
    [sym_non_null_expression] = STATE(1295),
    [sym_type_assertion] = STATE(1652),
    [sym_as_expression] = STATE(1652),
    [sym_satisfies_expression] = STATE(1652),
    [sym_instantiation_expression] = STATE(1652),
    [sym_internal_module] = STATE(1652),
    [sym_nested_type_identifier] = STATE(2939),
    [sym__type_query_member_expression_in_type_annotation] = STATE(2937),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2938),
    [sym_type] = STATE(3153),
    [sym_constructor_type] = STATE(3007),
    [sym_primary_type] = STATE(2981),
    [sym_template_literal_type] = STATE(3039),
    [sym_infer_type] = STATE(3007),
    [sym_conditional_type] = STATE(3039),
    [sym_generic_type] = STATE(3039),
    [sym_type_query] = STATE(3039),
    [sym_index_type_query] = STATE(3039),
    [sym_lookup_type] = STATE(3039),
    [sym_literal_type] = STATE(3039),
    [sym__number] = STATE(3041),
    [sym_existential_type] = STATE(3039),
    [sym_flow_maybe_type] = STATE(3039),
    [sym_parenthesized_type] = STATE(3039),
    [sym_predefined_type] = STATE(3039),
    [sym_type_arguments] = STATE(539),
    [sym_object_type] = STATE(3039),
    [sym_type_parameters] = STATE(5158),
    [sym_array_type] = STATE(3039),
    [sym_tuple_type] = STATE(3039),
    [sym_readonly_type] = STATE(3007),
    [sym_union_type] = STATE(3039),
    [sym_intersection_type] = STATE(3039),
    [sym_function_type] = STATE(3007),
    [aux_sym_export_statement_repeat1] = STATE(4429),
    [sym_identifier] = ACTIONS(111),
    [anon_sym_export] = ACTIONS(113),
    [anon_sym_STAR] = ACTIONS(115),
    [anon_sym_type] = ACTIONS(113),
    [anon_sym_EQ] = ACTIONS(117),
    [anon_sym_as] = ACTIONS(120),
    [anon_sym_namespace] = ACTIONS(122),
    [anon_sym_LBRACE] = ACTIONS(124),
    [anon_sym_COMMA] = ACTIONS(126),
    [anon_sym_typeof] = ACTIONS(129),
    [anon_sym_import] = ACTIONS(131),
    [anon_sym_let] = ACTIONS(113),
    [anon_sym_const] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(138),
    [anon_sym_RPAREN] = ACTIONS(126),
    [anon_sym_await] = ACTIONS(140),
    [anon_sym_in] = ACTIONS(120),
    [anon_sym_COLON] = ACTIONS(126),
    [anon_sym_yield] = ACTIONS(142),
    [anon_sym_LBRACK] = ACTIONS(144),
    [anon_sym_DOT] = ACTIONS(120),
    [anon_sym_class] = ACTIONS(146),
    [anon_sym_async] = ACTIONS(148),
    [anon_sym_function] = ACTIONS(150),
    [anon_sym_EQ_GT] = ACTIONS(152),
    [anon_sym_QMARK_DOT] = ACTIONS(154),
    [anon_sym_new] = ACTIONS(156),
    [anon_sym_using] = ACTIONS(158),
    [anon_sym_PLUS_EQ] = ACTIONS(160),
    [anon_sym_DASH_EQ] = ACTIONS(160),
    [anon_sym_STAR_EQ] = ACTIONS(160),
    [anon_sym_SLASH_EQ] = ACTIONS(160),
    [anon_sym_PERCENT_EQ] = ACTIONS(160),
    [anon_sym_CARET_EQ] = ACTIONS(160),
    [anon_sym_AMP_EQ] = ACTIONS(160),
    [anon_sym_PIPE_EQ] = ACTIONS(160),
    [anon_sym_GT_GT_EQ] = ACTIONS(160),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(160),
    [anon_sym_LT_LT_EQ] = ACTIONS(160),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(160),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(160),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(160),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(160),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(162),
    [anon_sym_AMP_AMP] = ACTIONS(120),
    [anon_sym_PIPE_PIPE] = ACTIONS(120),
    [anon_sym_GT_GT] = ACTIONS(120),
    [anon_sym_GT_GT_GT] = ACTIONS(120),
    [anon_sym_LT_LT] = ACTIONS(120),
    [anon_sym_AMP] = ACTIONS(164),
    [anon_sym_CARET] = ACTIONS(120),
    [anon_sym_PIPE] = ACTIONS(166),
    [anon_sym_PLUS] = ACTIONS(168),
    [anon_sym_DASH] = ACTIONS(168),
    [anon_sym_SLASH] = ACTIONS(170),
    [anon_sym_PERCENT] = ACTIONS(120),
    [anon_sym_STAR_STAR] = ACTIONS(120),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(154),
    [anon_sym_EQ_EQ] = ACTIONS(120),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(154),
    [anon_sym_BANG_EQ] = ACTIONS(120),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(154),
    [anon_sym_GT_EQ] = ACTIONS(154),
    [anon_sym_GT] = ACTIONS(120),
    [anon_sym_QMARK_QMARK] = ACTIONS(120),
    [anon_sym_instanceof] = ACTIONS(120),
    [anon_sym_TILDE] = ACTIONS(175),
    [anon_sym_void] = ACTIONS(177),
    [anon_sym_delete] = ACTIONS(179),
    [anon_sym_PLUS_PLUS] = ACTIONS(181),
    [anon_sym_DASH_DASH] = ACTIONS(181),
    [anon_sym_DQUOTE] = ACTIONS(184),
    [anon_sym_SQUOTE] = ACTIONS(186),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(188),
    [sym_number] = ACTIONS(190),
    [sym_private_property_identifier] = ACTIONS(192),
    [sym_this] = ACTIONS(194),
    [sym_super] = ACTIONS(196),
    [sym_true] = ACTIONS(198),
    [sym_false] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_undefined] = ACTIONS(200),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(113),
    [anon_sym_readonly] = ACTIONS(202),
    [anon_sym_get] = ACTIONS(113),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(204),
    [anon_sym_declare] = ACTIONS(113),
    [anon_sym_public] = ACTIONS(113),
    [anon_sym_private] = ACTIONS(113),
    [anon_sym_protected] = ACTIONS(113),
    [anon_sym_override] = ACTIONS(113),
    [anon_sym_module] = ACTIONS(113),
    [anon_sym_any] = ACTIONS(206),
    [anon_sym_number] = ACTIONS(206),
    [anon_sym_boolean] = ACTIONS(206),
    [anon_sym_string] = ACTIONS(206),
    [anon_sym_symbol] = ACTIONS(206),
    [anon_sym_object] = ACTIONS(206),
    [anon_sym_abstract] = ACTIONS(208),
    [anon_sym_satisfies] = ACTIONS(120),
    [anon_sym_infer] = ACTIONS(210),
    [anon_sym_keyof] = ACTIONS(212),
    [anon_sym_unique] = ACTIONS(214),
    [anon_sym_unknown] = ACTIONS(216),
    [anon_sym_never] = ACTIONS(216),
    [anon_sym_LBRACE_PIPE] = ACTIONS(218),
    [sym__ternary_qmark] = ACTIONS(154),
    [sym_html_comment] = ACTIONS(5),
  },
  [3] = {
    [sym_import] = STATE(3593),
    [sym_parenthesized_expression] = STATE(1213),
    [sym_expression] = STATE(2644),
    [sym_primary_expression] = STATE(1515),
    [sym_yield_expression] = STATE(1652),
    [sym_object] = STATE(1687),
    [sym_object_pattern] = STATE(3722),
    [sym_array] = STATE(1687),
    [sym_array_pattern] = STATE(3722),
    [sym_nested_identifier] = STATE(5474),
    [sym_class] = STATE(1687),
    [sym_function_expression] = STATE(1687),
    [sym_generator_function] = STATE(1687),
    [sym_arrow_function] = STATE(1687),
    [sym__call_signature] = STATE(5800),
    [sym_call_expression] = STATE(1687),
    [sym_new_expression] = STATE(1648),
    [sym_await_expression] = STATE(1652),
    [sym_member_expression] = STATE(1295),
    [sym_subscript_expression] = STATE(1295),
    [sym_assignment_expression] = STATE(1652),
    [sym__augmented_assignment_lhs] = STATE(3013),
    [sym_augmented_assignment_expression] = STATE(1652),
    [sym__destructuring_pattern] = STATE(3722),
    [sym_ternary_expression] = STATE(1652),
    [sym_binary_expression] = STATE(1652),
    [sym_unary_expression] = STATE(1652),
    [sym_update_expression] = STATE(1652),
    [sym_string] = STATE(2213),
    [sym_template_string] = STATE(1687),
    [sym_regex] = STATE(1687),
    [sym_meta_property] = STATE(1687),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(4087),
    [sym_pattern] = STATE(4312),
    [sym_rest_pattern] = STATE(3684),
    [sym_non_null_expression] = STATE(1295),
    [sym_type_assertion] = STATE(1652),
    [sym_as_expression] = STATE(1652),
    [sym_satisfies_expression] = STATE(1652),
    [sym_instantiation_expression] = STATE(1652),
    [sym_internal_module] = STATE(1652),
    [sym_nested_type_identifier] = STATE(2939),
    [sym__type_query_member_expression_in_type_annotation] = STATE(2937),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2938),
    [sym_type] = STATE(3153),
    [sym_constructor_type] = STATE(3007),
    [sym_primary_type] = STATE(2981),
    [sym_template_literal_type] = STATE(3039),
    [sym_infer_type] = STATE(3007),
    [sym_conditional_type] = STATE(3039),
    [sym_generic_type] = STATE(3039),
    [sym_type_query] = STATE(3039),
    [sym_index_type_query] = STATE(3039),
    [sym_lookup_type] = STATE(3039),
    [sym_literal_type] = STATE(3039),
    [sym__number] = STATE(3041),
    [sym_existential_type] = STATE(3039),
    [sym_flow_maybe_type] = STATE(3039),
    [sym_parenthesized_type] = STATE(3039),
    [sym_predefined_type] = STATE(3039),
    [sym_type_arguments] = STATE(539),
    [sym_object_type] = STATE(3039),
    [sym_type_parameters] = STATE(5158),
    [sym_array_type] = STATE(3039),
    [sym_tuple_type] = STATE(3039),
    [sym_readonly_type] = STATE(3007),
    [sym_union_type] = STATE(3039),
    [sym_intersection_type] = STATE(3039),
    [sym_function_type] = STATE(3007),
    [aux_sym_export_statement_repeat1] = STATE(4429),
    [sym_identifier] = ACTIONS(111),
    [anon_sym_export] = ACTIONS(113),
    [anon_sym_STAR] = ACTIONS(115),
    [anon_sym_type] = ACTIONS(113),
    [anon_sym_EQ] = ACTIONS(220),
    [anon_sym_as] = ACTIONS(120),
    [anon_sym_namespace] = ACTIONS(122),
    [anon_sym_LBRACE] = ACTIONS(124),
    [anon_sym_COMMA] = ACTIONS(223),
    [anon_sym_typeof] = ACTIONS(129),
    [anon_sym_import] = ACTIONS(131),
    [anon_sym_let] = ACTIONS(113),
    [anon_sym_const] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(138),
    [anon_sym_RPAREN] = ACTIONS(223),
    [anon_sym_await] = ACTIONS(140),
    [anon_sym_in] = ACTIONS(120),
    [anon_sym_COLON] = ACTIONS(223),
    [anon_sym_yield] = ACTIONS(142),
    [anon_sym_LBRACK] = ACTIONS(144),
    [anon_sym_DOT] = ACTIONS(120),
    [anon_sym_class] = ACTIONS(146),
    [anon_sym_async] = ACTIONS(148),
    [anon_sym_function] = ACTIONS(150),
    [anon_sym_EQ_GT] = ACTIONS(225),
    [anon_sym_QMARK_DOT] = ACTIONS(154),
    [anon_sym_new] = ACTIONS(156),
    [anon_sym_using] = ACTIONS(158),
    [anon_sym_PLUS_EQ] = ACTIONS(160),
    [anon_sym_DASH_EQ] = ACTIONS(160),
    [anon_sym_STAR_EQ] = ACTIONS(160),
    [anon_sym_SLASH_EQ] = ACTIONS(160),
    [anon_sym_PERCENT_EQ] = ACTIONS(160),
    [anon_sym_CARET_EQ] = ACTIONS(160),
    [anon_sym_AMP_EQ] = ACTIONS(160),
    [anon_sym_PIPE_EQ] = ACTIONS(160),
    [anon_sym_GT_GT_EQ] = ACTIONS(160),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(160),
    [anon_sym_LT_LT_EQ] = ACTIONS(160),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(160),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(160),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(160),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(160),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(162),
    [anon_sym_AMP_AMP] = ACTIONS(120),
    [anon_sym_PIPE_PIPE] = ACTIONS(120),
    [anon_sym_GT_GT] = ACTIONS(120),
    [anon_sym_GT_GT_GT] = ACTIONS(120),
    [anon_sym_LT_LT] = ACTIONS(120),
    [anon_sym_AMP] = ACTIONS(164),
    [anon_sym_CARET] = ACTIONS(120),
    [anon_sym_PIPE] = ACTIONS(166),
    [anon_sym_PLUS] = ACTIONS(168),
    [anon_sym_DASH] = ACTIONS(168),
    [anon_sym_SLASH] = ACTIONS(170),
    [anon_sym_PERCENT] = ACTIONS(120),
    [anon_sym_STAR_STAR] = ACTIONS(120),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(154),
    [anon_sym_EQ_EQ] = ACTIONS(120),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(154),
    [anon_sym_BANG_EQ] = ACTIONS(120),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(154),
    [anon_sym_GT_EQ] = ACTIONS(154),
    [anon_sym_GT] = ACTIONS(120),
    [anon_sym_QMARK_QMARK] = ACTIONS(120),
    [anon_sym_instanceof] = ACTIONS(120),
    [anon_sym_TILDE] = ACTIONS(175),
    [anon_sym_void] = ACTIONS(177),
    [anon_sym_delete] = ACTIONS(179),
    [anon_sym_PLUS_PLUS] = ACTIONS(181),
    [anon_sym_DASH_DASH] = ACTIONS(181),
    [anon_sym_DQUOTE] = ACTIONS(184),
    [anon_sym_SQUOTE] = ACTIONS(186),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(188),
    [sym_number] = ACTIONS(190),
    [sym_private_property_identifier] = ACTIONS(192),
    [sym_this] = ACTIONS(194),
    [sym_super] = ACTIONS(196),
    [sym_true] = ACTIONS(198),
    [sym_false] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_undefined] = ACTIONS(200),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(113),
    [anon_sym_readonly] = ACTIONS(202),
    [anon_sym_get] = ACTIONS(113),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(204),
    [anon_sym_declare] = ACTIONS(113),
    [anon_sym_public] = ACTIONS(113),
    [anon_sym_private] = ACTIONS(113),
    [anon_sym_protected] = ACTIONS(113),
    [anon_sym_override] = ACTIONS(113),
    [anon_sym_module] = ACTIONS(113),
    [anon_sym_any] = ACTIONS(206),
    [anon_sym_number] = ACTIONS(206),
    [anon_sym_boolean] = ACTIONS(206),
    [anon_sym_string] = ACTIONS(206),
    [anon_sym_symbol] = ACTIONS(206),
    [anon_sym_object] = ACTIONS(206),
    [anon_sym_abstract] = ACTIONS(208),
    [anon_sym_satisfies] = ACTIONS(120),
    [anon_sym_infer] = ACTIONS(210),
    [anon_sym_keyof] = ACTIONS(212),
    [anon_sym_unique] = ACTIONS(214),
    [anon_sym_unknown] = ACTIONS(216),
    [anon_sym_never] = ACTIONS(216),
    [anon_sym_LBRACE_PIPE] = ACTIONS(218),
    [sym__ternary_qmark] = ACTIONS(154),
    [sym_html_comment] = ACTIONS(5),
  },
  [4] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(14),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5637),
    [sym_object_assignment_pattern] = STATE(4555),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5637),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5637),
    [sym_spread_element] = STATE(4576),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2202),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_rest_pattern] = STATE(4555),
    [sym_method_definition] = STATE(4576),
    [sym_pair] = STATE(4576),
    [sym_pair_pattern] = STATE(4555),
    [sym__property_name] = STATE(3648),
    [sym_computed_property_name] = STATE(3648),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_accessibility_modifier] = STATE(2786),
    [sym_override_modifier] = STATE(2808),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(14),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [aux_sym_object_repeat1] = STATE(4744),
    [aux_sym_object_pattern_repeat1] = STATE(4745),
    [sym_identifier] = ACTIONS(227),
    [anon_sym_export] = ACTIONS(229),
    [anon_sym_STAR] = ACTIONS(231),
    [anon_sym_type] = ACTIONS(233),
    [anon_sym_namespace] = ACTIONS(235),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(237),
    [anon_sym_RBRACE] = ACTIONS(239),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(241),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(243),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(245),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(247),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(249),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(251),
    [sym_private_property_identifier] = ACTIONS(253),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(255),
    [anon_sym_readonly] = ACTIONS(257),
    [anon_sym_get] = ACTIONS(259),
    [anon_sym_set] = ACTIONS(259),
    [anon_sym_declare] = ACTIONS(261),
    [anon_sym_public] = ACTIONS(263),
    [anon_sym_private] = ACTIONS(263),
    [anon_sym_protected] = ACTIONS(263),
    [anon_sym_override] = ACTIONS(265),
    [anon_sym_module] = ACTIONS(267),
    [anon_sym_any] = ACTIONS(269),
    [anon_sym_number] = ACTIONS(269),
    [anon_sym_boolean] = ACTIONS(269),
    [anon_sym_string] = ACTIONS(269),
    [anon_sym_symbol] = ACTIONS(269),
    [anon_sym_object] = ACTIONS(269),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [5] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(18),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5637),
    [sym_object_assignment_pattern] = STATE(4555),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5637),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5637),
    [sym_spread_element] = STATE(4576),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2202),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_rest_pattern] = STATE(4555),
    [sym_method_definition] = STATE(4576),
    [sym_pair] = STATE(4576),
    [sym_pair_pattern] = STATE(4555),
    [sym__property_name] = STATE(3648),
    [sym_computed_property_name] = STATE(3648),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_accessibility_modifier] = STATE(2786),
    [sym_override_modifier] = STATE(2808),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [aux_sym_object_repeat1] = STATE(4744),
    [aux_sym_object_pattern_repeat1] = STATE(4745),
    [sym_identifier] = ACTIONS(227),
    [anon_sym_export] = ACTIONS(229),
    [anon_sym_STAR] = ACTIONS(231),
    [anon_sym_type] = ACTIONS(233),
    [anon_sym_namespace] = ACTIONS(235),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(237),
    [anon_sym_RBRACE] = ACTIONS(271),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(241),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(243),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(245),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(247),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(249),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(251),
    [sym_private_property_identifier] = ACTIONS(253),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(255),
    [anon_sym_readonly] = ACTIONS(257),
    [anon_sym_get] = ACTIONS(259),
    [anon_sym_set] = ACTIONS(259),
    [anon_sym_declare] = ACTIONS(261),
    [anon_sym_public] = ACTIONS(263),
    [anon_sym_private] = ACTIONS(263),
    [anon_sym_protected] = ACTIONS(263),
    [anon_sym_override] = ACTIONS(265),
    [anon_sym_module] = ACTIONS(267),
    [anon_sym_any] = ACTIONS(269),
    [anon_sym_number] = ACTIONS(269),
    [anon_sym_boolean] = ACTIONS(269),
    [anon_sym_string] = ACTIONS(269),
    [anon_sym_symbol] = ACTIONS(269),
    [anon_sym_object] = ACTIONS(269),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [6] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(22),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5637),
    [sym_object_assignment_pattern] = STATE(4555),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5637),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5637),
    [sym_spread_element] = STATE(4721),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2202),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_rest_pattern] = STATE(4555),
    [sym_method_definition] = STATE(4721),
    [sym_pair] = STATE(4721),
    [sym_pair_pattern] = STATE(4555),
    [sym__property_name] = STATE(3648),
    [sym_computed_property_name] = STATE(3648),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_accessibility_modifier] = STATE(2786),
    [sym_override_modifier] = STATE(2808),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(22),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [aux_sym_object_repeat1] = STATE(4734),
    [aux_sym_object_pattern_repeat1] = STATE(4745),
    [sym_identifier] = ACTIONS(273),
    [anon_sym_export] = ACTIONS(275),
    [anon_sym_STAR] = ACTIONS(231),
    [anon_sym_type] = ACTIONS(277),
    [anon_sym_namespace] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(237),
    [anon_sym_RBRACE] = ACTIONS(281),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(283),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(243),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(285),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(287),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(249),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(251),
    [sym_private_property_identifier] = ACTIONS(253),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(289),
    [anon_sym_readonly] = ACTIONS(291),
    [anon_sym_get] = ACTIONS(293),
    [anon_sym_set] = ACTIONS(293),
    [anon_sym_declare] = ACTIONS(295),
    [anon_sym_public] = ACTIONS(297),
    [anon_sym_private] = ACTIONS(297),
    [anon_sym_protected] = ACTIONS(297),
    [anon_sym_override] = ACTIONS(299),
    [anon_sym_module] = ACTIONS(301),
    [anon_sym_any] = ACTIONS(303),
    [anon_sym_number] = ACTIONS(303),
    [anon_sym_boolean] = ACTIONS(303),
    [anon_sym_string] = ACTIONS(303),
    [anon_sym_symbol] = ACTIONS(303),
    [anon_sym_object] = ACTIONS(303),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [7] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(14),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5637),
    [sym_object_assignment_pattern] = STATE(4555),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5637),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5637),
    [sym_spread_element] = STATE(4576),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2202),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_rest_pattern] = STATE(4555),
    [sym_method_definition] = STATE(4576),
    [sym_pair] = STATE(4576),
    [sym_pair_pattern] = STATE(4555),
    [sym__property_name] = STATE(3648),
    [sym_computed_property_name] = STATE(3648),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_accessibility_modifier] = STATE(2786),
    [sym_override_modifier] = STATE(2808),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(14),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [aux_sym_object_repeat1] = STATE(4744),
    [aux_sym_object_pattern_repeat1] = STATE(4745),
    [sym_identifier] = ACTIONS(227),
    [anon_sym_export] = ACTIONS(229),
    [anon_sym_STAR] = ACTIONS(231),
    [anon_sym_type] = ACTIONS(233),
    [anon_sym_namespace] = ACTIONS(235),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(237),
    [anon_sym_RBRACE] = ACTIONS(305),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(241),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(243),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(245),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(247),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(249),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(251),
    [sym_private_property_identifier] = ACTIONS(253),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(255),
    [anon_sym_readonly] = ACTIONS(257),
    [anon_sym_get] = ACTIONS(259),
    [anon_sym_set] = ACTIONS(259),
    [anon_sym_declare] = ACTIONS(261),
    [anon_sym_public] = ACTIONS(263),
    [anon_sym_private] = ACTIONS(263),
    [anon_sym_protected] = ACTIONS(263),
    [anon_sym_override] = ACTIONS(265),
    [anon_sym_module] = ACTIONS(267),
    [anon_sym_any] = ACTIONS(269),
    [anon_sym_number] = ACTIONS(269),
    [anon_sym_boolean] = ACTIONS(269),
    [anon_sym_string] = ACTIONS(269),
    [anon_sym_symbol] = ACTIONS(269),
    [anon_sym_object] = ACTIONS(269),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [8] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(22),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5637),
    [sym_object_assignment_pattern] = STATE(4555),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5637),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5637),
    [sym_spread_element] = STATE(4721),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2202),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_rest_pattern] = STATE(4555),
    [sym_method_definition] = STATE(4721),
    [sym_pair] = STATE(4721),
    [sym_pair_pattern] = STATE(4555),
    [sym__property_name] = STATE(3648),
    [sym_computed_property_name] = STATE(3648),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_accessibility_modifier] = STATE(2786),
    [sym_override_modifier] = STATE(2808),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(22),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [aux_sym_object_repeat1] = STATE(4734),
    [aux_sym_object_pattern_repeat1] = STATE(4745),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_export] = ACTIONS(309),
    [anon_sym_STAR] = ACTIONS(231),
    [anon_sym_type] = ACTIONS(311),
    [anon_sym_namespace] = ACTIONS(313),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(237),
    [anon_sym_RBRACE] = ACTIONS(281),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(315),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(243),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(317),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(319),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(249),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(251),
    [sym_private_property_identifier] = ACTIONS(253),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(321),
    [anon_sym_readonly] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(325),
    [anon_sym_set] = ACTIONS(325),
    [anon_sym_declare] = ACTIONS(327),
    [anon_sym_public] = ACTIONS(329),
    [anon_sym_private] = ACTIONS(329),
    [anon_sym_protected] = ACTIONS(329),
    [anon_sym_override] = ACTIONS(331),
    [anon_sym_module] = ACTIONS(333),
    [anon_sym_any] = ACTIONS(335),
    [anon_sym_number] = ACTIONS(335),
    [anon_sym_boolean] = ACTIONS(335),
    [anon_sym_string] = ACTIONS(335),
    [anon_sym_symbol] = ACTIONS(335),
    [anon_sym_object] = ACTIONS(335),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [9] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [ts_builtin_sym_end] = ACTIONS(337),
    [sym_identifier] = ACTIONS(339),
    [anon_sym_export] = ACTIONS(342),
    [anon_sym_default] = ACTIONS(345),
    [anon_sym_type] = ACTIONS(347),
    [anon_sym_namespace] = ACTIONS(350),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(337),
    [anon_sym_typeof] = ACTIONS(356),
    [anon_sym_import] = ACTIONS(359),
    [anon_sym_with] = ACTIONS(362),
    [anon_sym_var] = ACTIONS(365),
    [anon_sym_let] = ACTIONS(368),
    [anon_sym_const] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(374),
    [anon_sym_if] = ACTIONS(377),
    [anon_sym_switch] = ACTIONS(380),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_LPAREN] = ACTIONS(386),
    [anon_sym_SEMI] = ACTIONS(389),
    [anon_sym_await] = ACTIONS(392),
    [anon_sym_while] = ACTIONS(395),
    [anon_sym_do] = ACTIONS(398),
    [anon_sym_try] = ACTIONS(401),
    [anon_sym_break] = ACTIONS(404),
    [anon_sym_continue] = ACTIONS(407),
    [anon_sym_debugger] = ACTIONS(410),
    [anon_sym_return] = ACTIONS(413),
    [anon_sym_throw] = ACTIONS(416),
    [anon_sym_case] = ACTIONS(345),
    [anon_sym_yield] = ACTIONS(419),
    [anon_sym_LBRACK] = ACTIONS(422),
    [anon_sym_class] = ACTIONS(425),
    [anon_sym_async] = ACTIONS(428),
    [anon_sym_function] = ACTIONS(431),
    [anon_sym_new] = ACTIONS(434),
    [anon_sym_using] = ACTIONS(437),
    [anon_sym_PLUS] = ACTIONS(356),
    [anon_sym_DASH] = ACTIONS(356),
    [anon_sym_SLASH] = ACTIONS(440),
    [anon_sym_LT] = ACTIONS(443),
    [anon_sym_TILDE] = ACTIONS(374),
    [anon_sym_void] = ACTIONS(356),
    [anon_sym_delete] = ACTIONS(356),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(449),
    [anon_sym_SQUOTE] = ACTIONS(452),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(455),
    [sym_number] = ACTIONS(458),
    [sym_private_property_identifier] = ACTIONS(461),
    [sym_this] = ACTIONS(464),
    [sym_super] = ACTIONS(464),
    [sym_true] = ACTIONS(464),
    [sym_false] = ACTIONS(464),
    [sym_null] = ACTIONS(464),
    [sym_undefined] = ACTIONS(467),
    [anon_sym_AT] = ACTIONS(470),
    [anon_sym_static] = ACTIONS(473),
    [anon_sym_readonly] = ACTIONS(473),
    [anon_sym_get] = ACTIONS(473),
    [anon_sym_set] = ACTIONS(473),
    [anon_sym_declare] = ACTIONS(476),
    [anon_sym_public] = ACTIONS(473),
    [anon_sym_private] = ACTIONS(473),
    [anon_sym_protected] = ACTIONS(473),
    [anon_sym_override] = ACTIONS(473),
    [anon_sym_module] = ACTIONS(479),
    [anon_sym_any] = ACTIONS(473),
    [anon_sym_number] = ACTIONS(473),
    [anon_sym_boolean] = ACTIONS(473),
    [anon_sym_string] = ACTIONS(473),
    [anon_sym_symbol] = ACTIONS(473),
    [anon_sym_object] = ACTIONS(473),
    [anon_sym_abstract] = ACTIONS(482),
    [anon_sym_interface] = ACTIONS(485),
    [anon_sym_enum] = ACTIONS(488),
    [sym_html_comment] = ACTIONS(5),
  },
  [10] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(491),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(491),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [11] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(10),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(10),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(495),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(497),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(495),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [12] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(13),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(13),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(499),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(501),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(499),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [13] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(503),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(505),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(503),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [14] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(507),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [15] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(509),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [16] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [ts_builtin_sym_end] = ACTIONS(511),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [17] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [ts_builtin_sym_end] = ACTIONS(513),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [18] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(515),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [19] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(20),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(20),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(517),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [20] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(519),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [21] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(18),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(521),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [22] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(523),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [23] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(22),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(22),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(525),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [24] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(527),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [25] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(24),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(24),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(529),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [26] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(14),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(14),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(531),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [27] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(533),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [28] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(15),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(15),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(535),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [29] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(27),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(27),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(537),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [30] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(17),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_program_repeat1] = STATE(17),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [ts_builtin_sym_end] = ACTIONS(511),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [31] = {
    [sym_import] = STATE(3663),
    [sym_parenthesized_expression] = STATE(1322),
    [sym_expression] = STATE(2126),
    [sym_primary_expression] = STATE(1515),
    [sym_yield_expression] = STATE(1652),
    [sym_object] = STATE(1687),
    [sym_object_pattern] = STATE(4425),
    [sym_assignment_pattern] = STATE(4969),
    [sym_array] = STATE(1687),
    [sym_array_pattern] = STATE(4425),
    [sym_nested_identifier] = STATE(5474),
    [sym_class] = STATE(1687),
    [sym_function_expression] = STATE(1687),
    [sym_generator_function] = STATE(1687),
    [sym_arrow_function] = STATE(1687),
    [sym__call_signature] = STATE(5508),
    [sym_call_expression] = STATE(1687),
    [sym_new_expression] = STATE(1648),
    [sym_await_expression] = STATE(1652),
    [sym_member_expression] = STATE(1396),
    [sym_subscript_expression] = STATE(1396),
    [sym_assignment_expression] = STATE(1652),
    [sym__augmented_assignment_lhs] = STATE(3003),
    [sym_augmented_assignment_expression] = STATE(1652),
    [sym__destructuring_pattern] = STATE(4425),
    [sym_spread_element] = STATE(4946),
    [sym_ternary_expression] = STATE(1652),
    [sym_binary_expression] = STATE(1652),
    [sym_unary_expression] = STATE(1652),
    [sym_update_expression] = STATE(1652),
    [sym_string] = STATE(2213),
    [sym_template_string] = STATE(1687),
    [sym_regex] = STATE(1687),
    [sym_meta_property] = STATE(1687),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(4317),
    [sym_pattern] = STATE(4406),
    [sym_rest_pattern] = STATE(4115),
    [sym_non_null_expression] = STATE(1396),
    [sym_type_assertion] = STATE(1652),
    [sym_as_expression] = STATE(1652),
    [sym_satisfies_expression] = STATE(1652),
    [sym_instantiation_expression] = STATE(1652),
    [sym_internal_module] = STATE(1652),
    [sym_nested_type_identifier] = STATE(2939),
    [sym__type_query_member_expression_in_type_annotation] = STATE(3303),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2938),
    [sym_type] = STATE(3773),
    [sym_tuple_parameter] = STATE(4568),
    [sym_optional_tuple_parameter] = STATE(4568),
    [sym_optional_type] = STATE(4568),
    [sym_rest_type] = STATE(4568),
    [sym__tuple_type_member] = STATE(4568),
    [sym_constructor_type] = STATE(3007),
    [sym_primary_type] = STATE(2981),
    [sym_template_literal_type] = STATE(3039),
    [sym_infer_type] = STATE(3007),
    [sym_conditional_type] = STATE(3039),
    [sym_generic_type] = STATE(3039),
    [sym_type_query] = STATE(3039),
    [sym_index_type_query] = STATE(3039),
    [sym_lookup_type] = STATE(3039),
    [sym_literal_type] = STATE(3039),
    [sym__number] = STATE(3041),
    [sym_existential_type] = STATE(3039),
    [sym_flow_maybe_type] = STATE(3039),
    [sym_parenthesized_type] = STATE(3039),
    [sym_predefined_type] = STATE(3039),
    [sym_type_arguments] = STATE(484),
    [sym_object_type] = STATE(3039),
    [sym_type_parameters] = STATE(5455),
    [sym_array_type] = STATE(3039),
    [sym_tuple_type] = STATE(3039),
    [sym_readonly_type] = STATE(3007),
    [sym_union_type] = STATE(3039),
    [sym_intersection_type] = STATE(3039),
    [sym_function_type] = STATE(3007),
    [aux_sym_export_statement_repeat1] = STATE(4429),
    [aux_sym_array_repeat1] = STATE(4955),
    [aux_sym_array_pattern_repeat1] = STATE(4977),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_STAR] = ACTIONS(543),
    [anon_sym_type] = ACTIONS(541),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_COMMA] = ACTIONS(549),
    [anon_sym_typeof] = ACTIONS(551),
    [anon_sym_import] = ACTIONS(131),
    [anon_sym_let] = ACTIONS(541),
    [anon_sym_const] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(553),
    [anon_sym_LPAREN] = ACTIONS(138),
    [anon_sym_await] = ACTIONS(555),
    [anon_sym_yield] = ACTIONS(557),
    [anon_sym_LBRACK] = ACTIONS(559),
    [anon_sym_RBRACK] = ACTIONS(561),
    [anon_sym_class] = ACTIONS(146),
    [anon_sym_async] = ACTIONS(563),
    [anon_sym_function] = ACTIONS(150),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(567),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_SLASH] = ACTIONS(577),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(553),
    [anon_sym_void] = ACTIONS(579),
    [anon_sym_delete] = ACTIONS(581),
    [anon_sym_PLUS_PLUS] = ACTIONS(583),
    [anon_sym_DASH_DASH] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(184),
    [anon_sym_SQUOTE] = ACTIONS(186),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(188),
    [sym_number] = ACTIONS(190),
    [sym_private_property_identifier] = ACTIONS(585),
    [sym_this] = ACTIONS(587),
    [sym_super] = ACTIONS(196),
    [sym_true] = ACTIONS(198),
    [sym_false] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(541),
    [anon_sym_readonly] = ACTIONS(591),
    [anon_sym_get] = ACTIONS(541),
    [anon_sym_set] = ACTIONS(541),
    [anon_sym_QMARK] = ACTIONS(593),
    [anon_sym_declare] = ACTIONS(541),
    [anon_sym_public] = ACTIONS(541),
    [anon_sym_private] = ACTIONS(541),
    [anon_sym_protected] = ACTIONS(541),
    [anon_sym_override] = ACTIONS(541),
    [anon_sym_module] = ACTIONS(541),
    [anon_sym_any] = ACTIONS(595),
    [anon_sym_number] = ACTIONS(595),
    [anon_sym_boolean] = ACTIONS(595),
    [anon_sym_string] = ACTIONS(595),
    [anon_sym_symbol] = ACTIONS(595),
    [anon_sym_object] = ACTIONS(595),
    [anon_sym_abstract] = ACTIONS(597),
    [anon_sym_infer] = ACTIONS(599),
    [anon_sym_keyof] = ACTIONS(601),
    [anon_sym_unique] = ACTIONS(214),
    [anon_sym_unknown] = ACTIONS(216),
    [anon_sym_never] = ACTIONS(216),
    [anon_sym_LBRACE_PIPE] = ACTIONS(218),
    [sym_html_comment] = ACTIONS(5),
  },
  [32] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(940),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(2513),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3830),
    [sym_identifier] = ACTIONS(603),
    [anon_sym_export] = ACTIONS(605),
    [anon_sym_type] = ACTIONS(607),
    [anon_sym_namespace] = ACTIONS(609),
    [anon_sym_LBRACE] = ACTIONS(611),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(613),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(615),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(623),
    [anon_sym_async] = ACTIONS(625),
    [anon_sym_function] = ACTIONS(627),
    [anon_sym_new] = ACTIONS(629),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(631),
    [anon_sym_readonly] = ACTIONS(631),
    [anon_sym_get] = ACTIONS(631),
    [anon_sym_set] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(633),
    [anon_sym_public] = ACTIONS(631),
    [anon_sym_private] = ACTIONS(631),
    [anon_sym_protected] = ACTIONS(631),
    [anon_sym_override] = ACTIONS(631),
    [anon_sym_module] = ACTIONS(635),
    [anon_sym_any] = ACTIONS(631),
    [anon_sym_number] = ACTIONS(631),
    [anon_sym_boolean] = ACTIONS(631),
    [anon_sym_string] = ACTIONS(631),
    [anon_sym_symbol] = ACTIONS(631),
    [anon_sym_object] = ACTIONS(631),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [33] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(928),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [34] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(832),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(2513),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3830),
    [sym_identifier] = ACTIONS(603),
    [anon_sym_export] = ACTIONS(605),
    [anon_sym_type] = ACTIONS(607),
    [anon_sym_namespace] = ACTIONS(609),
    [anon_sym_LBRACE] = ACTIONS(611),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(613),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(615),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(623),
    [anon_sym_async] = ACTIONS(625),
    [anon_sym_function] = ACTIONS(627),
    [anon_sym_new] = ACTIONS(629),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(631),
    [anon_sym_readonly] = ACTIONS(631),
    [anon_sym_get] = ACTIONS(631),
    [anon_sym_set] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(633),
    [anon_sym_public] = ACTIONS(631),
    [anon_sym_private] = ACTIONS(631),
    [anon_sym_protected] = ACTIONS(631),
    [anon_sym_override] = ACTIONS(631),
    [anon_sym_module] = ACTIONS(635),
    [anon_sym_any] = ACTIONS(631),
    [anon_sym_number] = ACTIONS(631),
    [anon_sym_boolean] = ACTIONS(631),
    [anon_sym_string] = ACTIONS(631),
    [anon_sym_symbol] = ACTIONS(631),
    [anon_sym_object] = ACTIONS(631),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [35] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(4697),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(2513),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3830),
    [sym_identifier] = ACTIONS(603),
    [anon_sym_export] = ACTIONS(605),
    [anon_sym_type] = ACTIONS(607),
    [anon_sym_namespace] = ACTIONS(609),
    [anon_sym_LBRACE] = ACTIONS(611),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(613),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(615),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(623),
    [anon_sym_async] = ACTIONS(625),
    [anon_sym_function] = ACTIONS(627),
    [anon_sym_new] = ACTIONS(629),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(631),
    [anon_sym_readonly] = ACTIONS(631),
    [anon_sym_get] = ACTIONS(631),
    [anon_sym_set] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(633),
    [anon_sym_public] = ACTIONS(631),
    [anon_sym_private] = ACTIONS(631),
    [anon_sym_protected] = ACTIONS(631),
    [anon_sym_override] = ACTIONS(631),
    [anon_sym_module] = ACTIONS(635),
    [anon_sym_any] = ACTIONS(631),
    [anon_sym_number] = ACTIONS(631),
    [anon_sym_boolean] = ACTIONS(631),
    [anon_sym_string] = ACTIONS(631),
    [anon_sym_symbol] = ACTIONS(631),
    [anon_sym_object] = ACTIONS(631),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [36] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(931),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(2513),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3830),
    [sym_identifier] = ACTIONS(603),
    [anon_sym_export] = ACTIONS(605),
    [anon_sym_type] = ACTIONS(607),
    [anon_sym_namespace] = ACTIONS(609),
    [anon_sym_LBRACE] = ACTIONS(611),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(613),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(615),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(623),
    [anon_sym_async] = ACTIONS(625),
    [anon_sym_function] = ACTIONS(627),
    [anon_sym_new] = ACTIONS(629),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(631),
    [anon_sym_readonly] = ACTIONS(631),
    [anon_sym_get] = ACTIONS(631),
    [anon_sym_set] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(633),
    [anon_sym_public] = ACTIONS(631),
    [anon_sym_private] = ACTIONS(631),
    [anon_sym_protected] = ACTIONS(631),
    [anon_sym_override] = ACTIONS(631),
    [anon_sym_module] = ACTIONS(635),
    [anon_sym_any] = ACTIONS(631),
    [anon_sym_number] = ACTIONS(631),
    [anon_sym_boolean] = ACTIONS(631),
    [anon_sym_string] = ACTIONS(631),
    [anon_sym_symbol] = ACTIONS(631),
    [anon_sym_object] = ACTIONS(631),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [37] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(943),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(2513),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3830),
    [sym_identifier] = ACTIONS(603),
    [anon_sym_export] = ACTIONS(605),
    [anon_sym_type] = ACTIONS(607),
    [anon_sym_namespace] = ACTIONS(609),
    [anon_sym_LBRACE] = ACTIONS(611),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(613),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(615),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(623),
    [anon_sym_async] = ACTIONS(625),
    [anon_sym_function] = ACTIONS(627),
    [anon_sym_new] = ACTIONS(629),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(631),
    [anon_sym_readonly] = ACTIONS(631),
    [anon_sym_get] = ACTIONS(631),
    [anon_sym_set] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(633),
    [anon_sym_public] = ACTIONS(631),
    [anon_sym_private] = ACTIONS(631),
    [anon_sym_protected] = ACTIONS(631),
    [anon_sym_override] = ACTIONS(631),
    [anon_sym_module] = ACTIONS(635),
    [anon_sym_any] = ACTIONS(631),
    [anon_sym_number] = ACTIONS(631),
    [anon_sym_boolean] = ACTIONS(631),
    [anon_sym_string] = ACTIONS(631),
    [anon_sym_symbol] = ACTIONS(631),
    [anon_sym_object] = ACTIONS(631),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [38] = {
    [sym_import] = STATE(3663),
    [sym_parenthesized_expression] = STATE(1322),
    [sym_expression] = STATE(2126),
    [sym_primary_expression] = STATE(1515),
    [sym_yield_expression] = STATE(1652),
    [sym_object] = STATE(1687),
    [sym_object_pattern] = STATE(4425),
    [sym_assignment_pattern] = STATE(4969),
    [sym_array] = STATE(1687),
    [sym_array_pattern] = STATE(4425),
    [sym_nested_identifier] = STATE(5474),
    [sym_class] = STATE(1687),
    [sym_function_expression] = STATE(1687),
    [sym_generator_function] = STATE(1687),
    [sym_arrow_function] = STATE(1687),
    [sym__call_signature] = STATE(5508),
    [sym_call_expression] = STATE(1687),
    [sym_new_expression] = STATE(1648),
    [sym_await_expression] = STATE(1652),
    [sym_member_expression] = STATE(1396),
    [sym_subscript_expression] = STATE(1396),
    [sym_assignment_expression] = STATE(1652),
    [sym__augmented_assignment_lhs] = STATE(3003),
    [sym_augmented_assignment_expression] = STATE(1652),
    [sym__destructuring_pattern] = STATE(4425),
    [sym_spread_element] = STATE(4946),
    [sym_ternary_expression] = STATE(1652),
    [sym_binary_expression] = STATE(1652),
    [sym_unary_expression] = STATE(1652),
    [sym_update_expression] = STATE(1652),
    [sym_string] = STATE(2213),
    [sym_template_string] = STATE(1687),
    [sym_regex] = STATE(1687),
    [sym_meta_property] = STATE(1687),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(4317),
    [sym_pattern] = STATE(4406),
    [sym_rest_pattern] = STATE(4115),
    [sym_non_null_expression] = STATE(1396),
    [sym_type_assertion] = STATE(1652),
    [sym_as_expression] = STATE(1652),
    [sym_satisfies_expression] = STATE(1652),
    [sym_instantiation_expression] = STATE(1652),
    [sym_internal_module] = STATE(1652),
    [sym_nested_type_identifier] = STATE(2939),
    [sym__type_query_member_expression_in_type_annotation] = STATE(3303),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2938),
    [sym_type] = STATE(3773),
    [sym_tuple_parameter] = STATE(4568),
    [sym_optional_tuple_parameter] = STATE(4568),
    [sym_optional_type] = STATE(4568),
    [sym_rest_type] = STATE(4568),
    [sym__tuple_type_member] = STATE(4568),
    [sym_constructor_type] = STATE(3007),
    [sym_primary_type] = STATE(2981),
    [sym_template_literal_type] = STATE(3039),
    [sym_infer_type] = STATE(3007),
    [sym_conditional_type] = STATE(3039),
    [sym_generic_type] = STATE(3039),
    [sym_type_query] = STATE(3039),
    [sym_index_type_query] = STATE(3039),
    [sym_lookup_type] = STATE(3039),
    [sym_literal_type] = STATE(3039),
    [sym__number] = STATE(3041),
    [sym_existential_type] = STATE(3039),
    [sym_flow_maybe_type] = STATE(3039),
    [sym_parenthesized_type] = STATE(3039),
    [sym_predefined_type] = STATE(3039),
    [sym_type_arguments] = STATE(484),
    [sym_object_type] = STATE(3039),
    [sym_type_parameters] = STATE(5455),
    [sym_array_type] = STATE(3039),
    [sym_tuple_type] = STATE(3039),
    [sym_readonly_type] = STATE(3007),
    [sym_union_type] = STATE(3039),
    [sym_intersection_type] = STATE(3039),
    [sym_function_type] = STATE(3007),
    [aux_sym_export_statement_repeat1] = STATE(4429),
    [aux_sym_array_repeat1] = STATE(4955),
    [aux_sym_array_pattern_repeat1] = STATE(4977),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_STAR] = ACTIONS(543),
    [anon_sym_type] = ACTIONS(541),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_COMMA] = ACTIONS(549),
    [anon_sym_typeof] = ACTIONS(551),
    [anon_sym_import] = ACTIONS(131),
    [anon_sym_let] = ACTIONS(541),
    [anon_sym_const] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(553),
    [anon_sym_LPAREN] = ACTIONS(138),
    [anon_sym_await] = ACTIONS(555),
    [anon_sym_yield] = ACTIONS(557),
    [anon_sym_LBRACK] = ACTIONS(559),
    [anon_sym_RBRACK] = ACTIONS(637),
    [anon_sym_class] = ACTIONS(146),
    [anon_sym_async] = ACTIONS(563),
    [anon_sym_function] = ACTIONS(150),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(567),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_SLASH] = ACTIONS(577),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(553),
    [anon_sym_void] = ACTIONS(579),
    [anon_sym_delete] = ACTIONS(581),
    [anon_sym_PLUS_PLUS] = ACTIONS(583),
    [anon_sym_DASH_DASH] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(184),
    [anon_sym_SQUOTE] = ACTIONS(186),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(188),
    [sym_number] = ACTIONS(190),
    [sym_private_property_identifier] = ACTIONS(585),
    [sym_this] = ACTIONS(587),
    [sym_super] = ACTIONS(196),
    [sym_true] = ACTIONS(198),
    [sym_false] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(541),
    [anon_sym_readonly] = ACTIONS(591),
    [anon_sym_get] = ACTIONS(541),
    [anon_sym_set] = ACTIONS(541),
    [anon_sym_QMARK] = ACTIONS(593),
    [anon_sym_declare] = ACTIONS(541),
    [anon_sym_public] = ACTIONS(541),
    [anon_sym_private] = ACTIONS(541),
    [anon_sym_protected] = ACTIONS(541),
    [anon_sym_override] = ACTIONS(541),
    [anon_sym_module] = ACTIONS(541),
    [anon_sym_any] = ACTIONS(595),
    [anon_sym_number] = ACTIONS(595),
    [anon_sym_boolean] = ACTIONS(595),
    [anon_sym_string] = ACTIONS(595),
    [anon_sym_symbol] = ACTIONS(595),
    [anon_sym_object] = ACTIONS(595),
    [anon_sym_abstract] = ACTIONS(597),
    [anon_sym_infer] = ACTIONS(599),
    [anon_sym_keyof] = ACTIONS(601),
    [anon_sym_unique] = ACTIONS(214),
    [anon_sym_unknown] = ACTIONS(216),
    [anon_sym_never] = ACTIONS(216),
    [anon_sym_LBRACE_PIPE] = ACTIONS(218),
    [sym_html_comment] = ACTIONS(5),
  },
  [39] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(884),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(2513),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3830),
    [sym_identifier] = ACTIONS(603),
    [anon_sym_export] = ACTIONS(605),
    [anon_sym_type] = ACTIONS(607),
    [anon_sym_namespace] = ACTIONS(609),
    [anon_sym_LBRACE] = ACTIONS(611),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(613),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(615),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(623),
    [anon_sym_async] = ACTIONS(625),
    [anon_sym_function] = ACTIONS(627),
    [anon_sym_new] = ACTIONS(629),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(631),
    [anon_sym_readonly] = ACTIONS(631),
    [anon_sym_get] = ACTIONS(631),
    [anon_sym_set] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(633),
    [anon_sym_public] = ACTIONS(631),
    [anon_sym_private] = ACTIONS(631),
    [anon_sym_protected] = ACTIONS(631),
    [anon_sym_override] = ACTIONS(631),
    [anon_sym_module] = ACTIONS(635),
    [anon_sym_any] = ACTIONS(631),
    [anon_sym_number] = ACTIONS(631),
    [anon_sym_boolean] = ACTIONS(631),
    [anon_sym_string] = ACTIONS(631),
    [anon_sym_symbol] = ACTIONS(631),
    [anon_sym_object] = ACTIONS(631),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [40] = {
    [sym_import] = STATE(3663),
    [sym_parenthesized_expression] = STATE(1322),
    [sym_expression] = STATE(2301),
    [sym_primary_expression] = STATE(1515),
    [sym_yield_expression] = STATE(1652),
    [sym_object] = STATE(1687),
    [sym_object_pattern] = STATE(4425),
    [sym_assignment_pattern] = STATE(4969),
    [sym_array] = STATE(1687),
    [sym_array_pattern] = STATE(4425),
    [sym_nested_identifier] = STATE(5474),
    [sym_class] = STATE(1687),
    [sym_function_expression] = STATE(1687),
    [sym_generator_function] = STATE(1687),
    [sym_arrow_function] = STATE(1687),
    [sym__call_signature] = STATE(5508),
    [sym_call_expression] = STATE(1687),
    [sym_new_expression] = STATE(1648),
    [sym_await_expression] = STATE(1652),
    [sym_member_expression] = STATE(1396),
    [sym_subscript_expression] = STATE(1396),
    [sym_assignment_expression] = STATE(1652),
    [sym__augmented_assignment_lhs] = STATE(3003),
    [sym_augmented_assignment_expression] = STATE(1652),
    [sym__destructuring_pattern] = STATE(4425),
    [sym_spread_element] = STATE(4971),
    [sym_ternary_expression] = STATE(1652),
    [sym_binary_expression] = STATE(1652),
    [sym_unary_expression] = STATE(1652),
    [sym_update_expression] = STATE(1652),
    [sym_string] = STATE(2213),
    [sym_template_string] = STATE(1687),
    [sym_regex] = STATE(1687),
    [sym_meta_property] = STATE(1687),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(4317),
    [sym_pattern] = STATE(4406),
    [sym_rest_pattern] = STATE(4115),
    [sym_non_null_expression] = STATE(1396),
    [sym_type_assertion] = STATE(1652),
    [sym_as_expression] = STATE(1652),
    [sym_satisfies_expression] = STATE(1652),
    [sym_instantiation_expression] = STATE(1652),
    [sym_internal_module] = STATE(1652),
    [sym_nested_type_identifier] = STATE(2939),
    [sym__type_query_member_expression_in_type_annotation] = STATE(3303),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2938),
    [sym_type] = STATE(3773),
    [sym_tuple_parameter] = STATE(4568),
    [sym_optional_tuple_parameter] = STATE(4568),
    [sym_optional_type] = STATE(4568),
    [sym_rest_type] = STATE(4568),
    [sym__tuple_type_member] = STATE(4568),
    [sym_constructor_type] = STATE(3007),
    [sym_primary_type] = STATE(2981),
    [sym_template_literal_type] = STATE(3039),
    [sym_infer_type] = STATE(3007),
    [sym_conditional_type] = STATE(3039),
    [sym_generic_type] = STATE(3039),
    [sym_type_query] = STATE(3039),
    [sym_index_type_query] = STATE(3039),
    [sym_lookup_type] = STATE(3039),
    [sym_literal_type] = STATE(3039),
    [sym__number] = STATE(3041),
    [sym_existential_type] = STATE(3039),
    [sym_flow_maybe_type] = STATE(3039),
    [sym_parenthesized_type] = STATE(3039),
    [sym_predefined_type] = STATE(3039),
    [sym_type_arguments] = STATE(484),
    [sym_object_type] = STATE(3039),
    [sym_type_parameters] = STATE(5455),
    [sym_array_type] = STATE(3039),
    [sym_tuple_type] = STATE(3039),
    [sym_readonly_type] = STATE(3007),
    [sym_union_type] = STATE(3039),
    [sym_intersection_type] = STATE(3039),
    [sym_function_type] = STATE(3007),
    [aux_sym_export_statement_repeat1] = STATE(4429),
    [aux_sym_array_repeat1] = STATE(4975),
    [aux_sym_array_pattern_repeat1] = STATE(4977),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_STAR] = ACTIONS(543),
    [anon_sym_type] = ACTIONS(541),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_COMMA] = ACTIONS(549),
    [anon_sym_typeof] = ACTIONS(551),
    [anon_sym_import] = ACTIONS(131),
    [anon_sym_let] = ACTIONS(541),
    [anon_sym_const] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(553),
    [anon_sym_LPAREN] = ACTIONS(138),
    [anon_sym_await] = ACTIONS(555),
    [anon_sym_yield] = ACTIONS(557),
    [anon_sym_LBRACK] = ACTIONS(559),
    [anon_sym_RBRACK] = ACTIONS(639),
    [anon_sym_class] = ACTIONS(146),
    [anon_sym_async] = ACTIONS(563),
    [anon_sym_function] = ACTIONS(150),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(567),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_SLASH] = ACTIONS(577),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(553),
    [anon_sym_void] = ACTIONS(579),
    [anon_sym_delete] = ACTIONS(581),
    [anon_sym_PLUS_PLUS] = ACTIONS(583),
    [anon_sym_DASH_DASH] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(184),
    [anon_sym_SQUOTE] = ACTIONS(186),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(188),
    [sym_number] = ACTIONS(190),
    [sym_private_property_identifier] = ACTIONS(585),
    [sym_this] = ACTIONS(587),
    [sym_super] = ACTIONS(196),
    [sym_true] = ACTIONS(198),
    [sym_false] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(541),
    [anon_sym_readonly] = ACTIONS(591),
    [anon_sym_get] = ACTIONS(541),
    [anon_sym_set] = ACTIONS(541),
    [anon_sym_QMARK] = ACTIONS(593),
    [anon_sym_declare] = ACTIONS(541),
    [anon_sym_public] = ACTIONS(541),
    [anon_sym_private] = ACTIONS(541),
    [anon_sym_protected] = ACTIONS(541),
    [anon_sym_override] = ACTIONS(541),
    [anon_sym_module] = ACTIONS(541),
    [anon_sym_any] = ACTIONS(595),
    [anon_sym_number] = ACTIONS(595),
    [anon_sym_boolean] = ACTIONS(595),
    [anon_sym_string] = ACTIONS(595),
    [anon_sym_symbol] = ACTIONS(595),
    [anon_sym_object] = ACTIONS(595),
    [anon_sym_abstract] = ACTIONS(597),
    [anon_sym_infer] = ACTIONS(599),
    [anon_sym_keyof] = ACTIONS(601),
    [anon_sym_unique] = ACTIONS(214),
    [anon_sym_unknown] = ACTIONS(216),
    [anon_sym_never] = ACTIONS(216),
    [anon_sym_LBRACE_PIPE] = ACTIONS(218),
    [sym_html_comment] = ACTIONS(5),
  },
  [41] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(928),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(2513),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3830),
    [sym_identifier] = ACTIONS(603),
    [anon_sym_export] = ACTIONS(605),
    [anon_sym_type] = ACTIONS(607),
    [anon_sym_namespace] = ACTIONS(609),
    [anon_sym_LBRACE] = ACTIONS(611),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(613),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(615),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(623),
    [anon_sym_async] = ACTIONS(625),
    [anon_sym_function] = ACTIONS(627),
    [anon_sym_new] = ACTIONS(629),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(631),
    [anon_sym_readonly] = ACTIONS(631),
    [anon_sym_get] = ACTIONS(631),
    [anon_sym_set] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(633),
    [anon_sym_public] = ACTIONS(631),
    [anon_sym_private] = ACTIONS(631),
    [anon_sym_protected] = ACTIONS(631),
    [anon_sym_override] = ACTIONS(631),
    [anon_sym_module] = ACTIONS(635),
    [anon_sym_any] = ACTIONS(631),
    [anon_sym_number] = ACTIONS(631),
    [anon_sym_boolean] = ACTIONS(631),
    [anon_sym_string] = ACTIONS(631),
    [anon_sym_symbol] = ACTIONS(631),
    [anon_sym_object] = ACTIONS(631),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [42] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(874),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(2513),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3830),
    [sym_identifier] = ACTIONS(603),
    [anon_sym_export] = ACTIONS(605),
    [anon_sym_type] = ACTIONS(607),
    [anon_sym_namespace] = ACTIONS(609),
    [anon_sym_LBRACE] = ACTIONS(611),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(613),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(615),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(623),
    [anon_sym_async] = ACTIONS(625),
    [anon_sym_function] = ACTIONS(627),
    [anon_sym_new] = ACTIONS(629),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(631),
    [anon_sym_readonly] = ACTIONS(631),
    [anon_sym_get] = ACTIONS(631),
    [anon_sym_set] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(633),
    [anon_sym_public] = ACTIONS(631),
    [anon_sym_private] = ACTIONS(631),
    [anon_sym_protected] = ACTIONS(631),
    [anon_sym_override] = ACTIONS(631),
    [anon_sym_module] = ACTIONS(635),
    [anon_sym_any] = ACTIONS(631),
    [anon_sym_number] = ACTIONS(631),
    [anon_sym_boolean] = ACTIONS(631),
    [anon_sym_string] = ACTIONS(631),
    [anon_sym_symbol] = ACTIONS(631),
    [anon_sym_object] = ACTIONS(631),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [43] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(815),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(2513),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3830),
    [sym_identifier] = ACTIONS(603),
    [anon_sym_export] = ACTIONS(605),
    [anon_sym_type] = ACTIONS(607),
    [anon_sym_namespace] = ACTIONS(609),
    [anon_sym_LBRACE] = ACTIONS(611),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(613),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(615),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(623),
    [anon_sym_async] = ACTIONS(625),
    [anon_sym_function] = ACTIONS(627),
    [anon_sym_new] = ACTIONS(629),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(631),
    [anon_sym_readonly] = ACTIONS(631),
    [anon_sym_get] = ACTIONS(631),
    [anon_sym_set] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(633),
    [anon_sym_public] = ACTIONS(631),
    [anon_sym_private] = ACTIONS(631),
    [anon_sym_protected] = ACTIONS(631),
    [anon_sym_override] = ACTIONS(631),
    [anon_sym_module] = ACTIONS(635),
    [anon_sym_any] = ACTIONS(631),
    [anon_sym_number] = ACTIONS(631),
    [anon_sym_boolean] = ACTIONS(631),
    [anon_sym_string] = ACTIONS(631),
    [anon_sym_symbol] = ACTIONS(631),
    [anon_sym_object] = ACTIONS(631),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [44] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(819),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(2513),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3830),
    [sym_identifier] = ACTIONS(603),
    [anon_sym_export] = ACTIONS(605),
    [anon_sym_type] = ACTIONS(607),
    [anon_sym_namespace] = ACTIONS(609),
    [anon_sym_LBRACE] = ACTIONS(611),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(613),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(615),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(623),
    [anon_sym_async] = ACTIONS(625),
    [anon_sym_function] = ACTIONS(627),
    [anon_sym_new] = ACTIONS(629),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(631),
    [anon_sym_readonly] = ACTIONS(631),
    [anon_sym_get] = ACTIONS(631),
    [anon_sym_set] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(633),
    [anon_sym_public] = ACTIONS(631),
    [anon_sym_private] = ACTIONS(631),
    [anon_sym_protected] = ACTIONS(631),
    [anon_sym_override] = ACTIONS(631),
    [anon_sym_module] = ACTIONS(635),
    [anon_sym_any] = ACTIONS(631),
    [anon_sym_number] = ACTIONS(631),
    [anon_sym_boolean] = ACTIONS(631),
    [anon_sym_string] = ACTIONS(631),
    [anon_sym_symbol] = ACTIONS(631),
    [anon_sym_object] = ACTIONS(631),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [45] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(823),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(2513),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3830),
    [sym_identifier] = ACTIONS(603),
    [anon_sym_export] = ACTIONS(605),
    [anon_sym_type] = ACTIONS(607),
    [anon_sym_namespace] = ACTIONS(609),
    [anon_sym_LBRACE] = ACTIONS(611),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(613),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(615),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(623),
    [anon_sym_async] = ACTIONS(625),
    [anon_sym_function] = ACTIONS(627),
    [anon_sym_new] = ACTIONS(629),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(631),
    [anon_sym_readonly] = ACTIONS(631),
    [anon_sym_get] = ACTIONS(631),
    [anon_sym_set] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(633),
    [anon_sym_public] = ACTIONS(631),
    [anon_sym_private] = ACTIONS(631),
    [anon_sym_protected] = ACTIONS(631),
    [anon_sym_override] = ACTIONS(631),
    [anon_sym_module] = ACTIONS(635),
    [anon_sym_any] = ACTIONS(631),
    [anon_sym_number] = ACTIONS(631),
    [anon_sym_boolean] = ACTIONS(631),
    [anon_sym_string] = ACTIONS(631),
    [anon_sym_symbol] = ACTIONS(631),
    [anon_sym_object] = ACTIONS(631),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [46] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(830),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(2513),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3830),
    [sym_identifier] = ACTIONS(603),
    [anon_sym_export] = ACTIONS(605),
    [anon_sym_type] = ACTIONS(607),
    [anon_sym_namespace] = ACTIONS(609),
    [anon_sym_LBRACE] = ACTIONS(611),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(613),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(615),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(623),
    [anon_sym_async] = ACTIONS(625),
    [anon_sym_function] = ACTIONS(627),
    [anon_sym_new] = ACTIONS(629),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(631),
    [anon_sym_readonly] = ACTIONS(631),
    [anon_sym_get] = ACTIONS(631),
    [anon_sym_set] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(633),
    [anon_sym_public] = ACTIONS(631),
    [anon_sym_private] = ACTIONS(631),
    [anon_sym_protected] = ACTIONS(631),
    [anon_sym_override] = ACTIONS(631),
    [anon_sym_module] = ACTIONS(635),
    [anon_sym_any] = ACTIONS(631),
    [anon_sym_number] = ACTIONS(631),
    [anon_sym_boolean] = ACTIONS(631),
    [anon_sym_string] = ACTIONS(631),
    [anon_sym_symbol] = ACTIONS(631),
    [anon_sym_object] = ACTIONS(631),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [47] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(841),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(2513),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3830),
    [sym_identifier] = ACTIONS(603),
    [anon_sym_export] = ACTIONS(605),
    [anon_sym_type] = ACTIONS(607),
    [anon_sym_namespace] = ACTIONS(609),
    [anon_sym_LBRACE] = ACTIONS(611),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(613),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(615),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(623),
    [anon_sym_async] = ACTIONS(625),
    [anon_sym_function] = ACTIONS(627),
    [anon_sym_new] = ACTIONS(629),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(631),
    [anon_sym_readonly] = ACTIONS(631),
    [anon_sym_get] = ACTIONS(631),
    [anon_sym_set] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(633),
    [anon_sym_public] = ACTIONS(631),
    [anon_sym_private] = ACTIONS(631),
    [anon_sym_protected] = ACTIONS(631),
    [anon_sym_override] = ACTIONS(631),
    [anon_sym_module] = ACTIONS(635),
    [anon_sym_any] = ACTIONS(631),
    [anon_sym_number] = ACTIONS(631),
    [anon_sym_boolean] = ACTIONS(631),
    [anon_sym_string] = ACTIONS(631),
    [anon_sym_symbol] = ACTIONS(631),
    [anon_sym_object] = ACTIONS(631),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [48] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(843),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(2513),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3830),
    [sym_identifier] = ACTIONS(603),
    [anon_sym_export] = ACTIONS(605),
    [anon_sym_type] = ACTIONS(607),
    [anon_sym_namespace] = ACTIONS(609),
    [anon_sym_LBRACE] = ACTIONS(611),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(613),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(615),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(623),
    [anon_sym_async] = ACTIONS(625),
    [anon_sym_function] = ACTIONS(627),
    [anon_sym_new] = ACTIONS(629),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(631),
    [anon_sym_readonly] = ACTIONS(631),
    [anon_sym_get] = ACTIONS(631),
    [anon_sym_set] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(633),
    [anon_sym_public] = ACTIONS(631),
    [anon_sym_private] = ACTIONS(631),
    [anon_sym_protected] = ACTIONS(631),
    [anon_sym_override] = ACTIONS(631),
    [anon_sym_module] = ACTIONS(635),
    [anon_sym_any] = ACTIONS(631),
    [anon_sym_number] = ACTIONS(631),
    [anon_sym_boolean] = ACTIONS(631),
    [anon_sym_string] = ACTIONS(631),
    [anon_sym_symbol] = ACTIONS(631),
    [anon_sym_object] = ACTIONS(631),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [49] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(853),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(2513),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3830),
    [sym_identifier] = ACTIONS(603),
    [anon_sym_export] = ACTIONS(605),
    [anon_sym_type] = ACTIONS(607),
    [anon_sym_namespace] = ACTIONS(609),
    [anon_sym_LBRACE] = ACTIONS(611),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(613),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(615),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(623),
    [anon_sym_async] = ACTIONS(625),
    [anon_sym_function] = ACTIONS(627),
    [anon_sym_new] = ACTIONS(629),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(631),
    [anon_sym_readonly] = ACTIONS(631),
    [anon_sym_get] = ACTIONS(631),
    [anon_sym_set] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(633),
    [anon_sym_public] = ACTIONS(631),
    [anon_sym_private] = ACTIONS(631),
    [anon_sym_protected] = ACTIONS(631),
    [anon_sym_override] = ACTIONS(631),
    [anon_sym_module] = ACTIONS(635),
    [anon_sym_any] = ACTIONS(631),
    [anon_sym_number] = ACTIONS(631),
    [anon_sym_boolean] = ACTIONS(631),
    [anon_sym_string] = ACTIONS(631),
    [anon_sym_symbol] = ACTIONS(631),
    [anon_sym_object] = ACTIONS(631),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [50] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(884),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [51] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(874),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [52] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(940),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [53] = {
    [sym_import] = STATE(3663),
    [sym_parenthesized_expression] = STATE(1322),
    [sym_expression] = STATE(2126),
    [sym_primary_expression] = STATE(1515),
    [sym_yield_expression] = STATE(1652),
    [sym_object] = STATE(1687),
    [sym_object_pattern] = STATE(4425),
    [sym_assignment_pattern] = STATE(4969),
    [sym_array] = STATE(1687),
    [sym_array_pattern] = STATE(4425),
    [sym_nested_identifier] = STATE(5474),
    [sym_class] = STATE(1687),
    [sym_function_expression] = STATE(1687),
    [sym_generator_function] = STATE(1687),
    [sym_arrow_function] = STATE(1687),
    [sym__call_signature] = STATE(5508),
    [sym_call_expression] = STATE(1687),
    [sym_new_expression] = STATE(1648),
    [sym_await_expression] = STATE(1652),
    [sym_member_expression] = STATE(1396),
    [sym_subscript_expression] = STATE(1396),
    [sym_assignment_expression] = STATE(1652),
    [sym__augmented_assignment_lhs] = STATE(3003),
    [sym_augmented_assignment_expression] = STATE(1652),
    [sym__destructuring_pattern] = STATE(4425),
    [sym_spread_element] = STATE(4946),
    [sym_ternary_expression] = STATE(1652),
    [sym_binary_expression] = STATE(1652),
    [sym_unary_expression] = STATE(1652),
    [sym_update_expression] = STATE(1652),
    [sym_string] = STATE(2213),
    [sym_template_string] = STATE(1687),
    [sym_regex] = STATE(1687),
    [sym_meta_property] = STATE(1687),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(4317),
    [sym_pattern] = STATE(4406),
    [sym_rest_pattern] = STATE(4115),
    [sym_non_null_expression] = STATE(1396),
    [sym_type_assertion] = STATE(1652),
    [sym_as_expression] = STATE(1652),
    [sym_satisfies_expression] = STATE(1652),
    [sym_instantiation_expression] = STATE(1652),
    [sym_internal_module] = STATE(1652),
    [sym_nested_type_identifier] = STATE(2939),
    [sym__type_query_member_expression_in_type_annotation] = STATE(3303),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2938),
    [sym_type] = STATE(3773),
    [sym_tuple_parameter] = STATE(4568),
    [sym_optional_tuple_parameter] = STATE(4568),
    [sym_optional_type] = STATE(4568),
    [sym_rest_type] = STATE(4568),
    [sym__tuple_type_member] = STATE(4568),
    [sym_constructor_type] = STATE(3007),
    [sym_primary_type] = STATE(2981),
    [sym_template_literal_type] = STATE(3039),
    [sym_infer_type] = STATE(3007),
    [sym_conditional_type] = STATE(3039),
    [sym_generic_type] = STATE(3039),
    [sym_type_query] = STATE(3039),
    [sym_index_type_query] = STATE(3039),
    [sym_lookup_type] = STATE(3039),
    [sym_literal_type] = STATE(3039),
    [sym__number] = STATE(3041),
    [sym_existential_type] = STATE(3039),
    [sym_flow_maybe_type] = STATE(3039),
    [sym_parenthesized_type] = STATE(3039),
    [sym_predefined_type] = STATE(3039),
    [sym_type_arguments] = STATE(484),
    [sym_object_type] = STATE(3039),
    [sym_type_parameters] = STATE(5455),
    [sym_array_type] = STATE(3039),
    [sym_tuple_type] = STATE(3039),
    [sym_readonly_type] = STATE(3007),
    [sym_union_type] = STATE(3039),
    [sym_intersection_type] = STATE(3039),
    [sym_function_type] = STATE(3007),
    [aux_sym_export_statement_repeat1] = STATE(4429),
    [aux_sym_array_repeat1] = STATE(4955),
    [aux_sym_array_pattern_repeat1] = STATE(4977),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_STAR] = ACTIONS(543),
    [anon_sym_type] = ACTIONS(541),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_COMMA] = ACTIONS(549),
    [anon_sym_typeof] = ACTIONS(551),
    [anon_sym_import] = ACTIONS(131),
    [anon_sym_let] = ACTIONS(541),
    [anon_sym_const] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(553),
    [anon_sym_LPAREN] = ACTIONS(138),
    [anon_sym_await] = ACTIONS(555),
    [anon_sym_yield] = ACTIONS(557),
    [anon_sym_LBRACK] = ACTIONS(559),
    [anon_sym_RBRACK] = ACTIONS(641),
    [anon_sym_class] = ACTIONS(146),
    [anon_sym_async] = ACTIONS(563),
    [anon_sym_function] = ACTIONS(150),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(567),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_SLASH] = ACTIONS(577),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(553),
    [anon_sym_void] = ACTIONS(579),
    [anon_sym_delete] = ACTIONS(581),
    [anon_sym_PLUS_PLUS] = ACTIONS(583),
    [anon_sym_DASH_DASH] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(184),
    [anon_sym_SQUOTE] = ACTIONS(186),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(188),
    [sym_number] = ACTIONS(190),
    [sym_private_property_identifier] = ACTIONS(585),
    [sym_this] = ACTIONS(587),
    [sym_super] = ACTIONS(196),
    [sym_true] = ACTIONS(198),
    [sym_false] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(541),
    [anon_sym_readonly] = ACTIONS(591),
    [anon_sym_get] = ACTIONS(541),
    [anon_sym_set] = ACTIONS(541),
    [anon_sym_QMARK] = ACTIONS(593),
    [anon_sym_declare] = ACTIONS(541),
    [anon_sym_public] = ACTIONS(541),
    [anon_sym_private] = ACTIONS(541),
    [anon_sym_protected] = ACTIONS(541),
    [anon_sym_override] = ACTIONS(541),
    [anon_sym_module] = ACTIONS(541),
    [anon_sym_any] = ACTIONS(595),
    [anon_sym_number] = ACTIONS(595),
    [anon_sym_boolean] = ACTIONS(595),
    [anon_sym_string] = ACTIONS(595),
    [anon_sym_symbol] = ACTIONS(595),
    [anon_sym_object] = ACTIONS(595),
    [anon_sym_abstract] = ACTIONS(597),
    [anon_sym_infer] = ACTIONS(599),
    [anon_sym_keyof] = ACTIONS(601),
    [anon_sym_unique] = ACTIONS(214),
    [anon_sym_unknown] = ACTIONS(216),
    [anon_sym_never] = ACTIONS(216),
    [anon_sym_LBRACE_PIPE] = ACTIONS(218),
    [sym_html_comment] = ACTIONS(5),
  },
  [54] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(5539),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(2513),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3830),
    [sym_identifier] = ACTIONS(603),
    [anon_sym_export] = ACTIONS(605),
    [anon_sym_type] = ACTIONS(607),
    [anon_sym_namespace] = ACTIONS(609),
    [anon_sym_LBRACE] = ACTIONS(611),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(613),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(615),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(623),
    [anon_sym_async] = ACTIONS(625),
    [anon_sym_function] = ACTIONS(627),
    [anon_sym_new] = ACTIONS(629),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(631),
    [anon_sym_readonly] = ACTIONS(631),
    [anon_sym_get] = ACTIONS(631),
    [anon_sym_set] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(633),
    [anon_sym_public] = ACTIONS(631),
    [anon_sym_private] = ACTIONS(631),
    [anon_sym_protected] = ACTIONS(631),
    [anon_sym_override] = ACTIONS(631),
    [anon_sym_module] = ACTIONS(635),
    [anon_sym_any] = ACTIONS(631),
    [anon_sym_number] = ACTIONS(631),
    [anon_sym_boolean] = ACTIONS(631),
    [anon_sym_string] = ACTIONS(631),
    [anon_sym_symbol] = ACTIONS(631),
    [anon_sym_object] = ACTIONS(631),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [55] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(815),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [56] = {
    [sym_import] = STATE(3663),
    [sym_parenthesized_expression] = STATE(1322),
    [sym_expression] = STATE(2126),
    [sym_primary_expression] = STATE(1515),
    [sym_yield_expression] = STATE(1652),
    [sym_object] = STATE(1687),
    [sym_object_pattern] = STATE(4425),
    [sym_assignment_pattern] = STATE(4969),
    [sym_array] = STATE(1687),
    [sym_array_pattern] = STATE(4425),
    [sym_nested_identifier] = STATE(5474),
    [sym_class] = STATE(1687),
    [sym_function_expression] = STATE(1687),
    [sym_generator_function] = STATE(1687),
    [sym_arrow_function] = STATE(1687),
    [sym__call_signature] = STATE(5508),
    [sym_call_expression] = STATE(1687),
    [sym_new_expression] = STATE(1648),
    [sym_await_expression] = STATE(1652),
    [sym_member_expression] = STATE(1396),
    [sym_subscript_expression] = STATE(1396),
    [sym_assignment_expression] = STATE(1652),
    [sym__augmented_assignment_lhs] = STATE(3003),
    [sym_augmented_assignment_expression] = STATE(1652),
    [sym__destructuring_pattern] = STATE(4425),
    [sym_spread_element] = STATE(4946),
    [sym_ternary_expression] = STATE(1652),
    [sym_binary_expression] = STATE(1652),
    [sym_unary_expression] = STATE(1652),
    [sym_update_expression] = STATE(1652),
    [sym_string] = STATE(2213),
    [sym_template_string] = STATE(1687),
    [sym_regex] = STATE(1687),
    [sym_meta_property] = STATE(1687),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(4317),
    [sym_pattern] = STATE(4406),
    [sym_rest_pattern] = STATE(4115),
    [sym_non_null_expression] = STATE(1396),
    [sym_type_assertion] = STATE(1652),
    [sym_as_expression] = STATE(1652),
    [sym_satisfies_expression] = STATE(1652),
    [sym_instantiation_expression] = STATE(1652),
    [sym_internal_module] = STATE(1652),
    [sym_nested_type_identifier] = STATE(2939),
    [sym__type_query_member_expression_in_type_annotation] = STATE(3303),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2938),
    [sym_type] = STATE(3773),
    [sym_tuple_parameter] = STATE(4568),
    [sym_optional_tuple_parameter] = STATE(4568),
    [sym_optional_type] = STATE(4568),
    [sym_rest_type] = STATE(4568),
    [sym__tuple_type_member] = STATE(4568),
    [sym_constructor_type] = STATE(3007),
    [sym_primary_type] = STATE(2981),
    [sym_template_literal_type] = STATE(3039),
    [sym_infer_type] = STATE(3007),
    [sym_conditional_type] = STATE(3039),
    [sym_generic_type] = STATE(3039),
    [sym_type_query] = STATE(3039),
    [sym_index_type_query] = STATE(3039),
    [sym_lookup_type] = STATE(3039),
    [sym_literal_type] = STATE(3039),
    [sym__number] = STATE(3041),
    [sym_existential_type] = STATE(3039),
    [sym_flow_maybe_type] = STATE(3039),
    [sym_parenthesized_type] = STATE(3039),
    [sym_predefined_type] = STATE(3039),
    [sym_type_arguments] = STATE(484),
    [sym_object_type] = STATE(3039),
    [sym_type_parameters] = STATE(5455),
    [sym_array_type] = STATE(3039),
    [sym_tuple_type] = STATE(3039),
    [sym_readonly_type] = STATE(3007),
    [sym_union_type] = STATE(3039),
    [sym_intersection_type] = STATE(3039),
    [sym_function_type] = STATE(3007),
    [aux_sym_export_statement_repeat1] = STATE(4429),
    [aux_sym_array_repeat1] = STATE(4955),
    [aux_sym_array_pattern_repeat1] = STATE(4977),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_STAR] = ACTIONS(543),
    [anon_sym_type] = ACTIONS(541),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_COMMA] = ACTIONS(549),
    [anon_sym_typeof] = ACTIONS(551),
    [anon_sym_import] = ACTIONS(131),
    [anon_sym_let] = ACTIONS(541),
    [anon_sym_const] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(553),
    [anon_sym_LPAREN] = ACTIONS(138),
    [anon_sym_await] = ACTIONS(555),
    [anon_sym_yield] = ACTIONS(557),
    [anon_sym_LBRACK] = ACTIONS(559),
    [anon_sym_RBRACK] = ACTIONS(643),
    [anon_sym_class] = ACTIONS(146),
    [anon_sym_async] = ACTIONS(563),
    [anon_sym_function] = ACTIONS(150),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(567),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_SLASH] = ACTIONS(577),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(553),
    [anon_sym_void] = ACTIONS(579),
    [anon_sym_delete] = ACTIONS(581),
    [anon_sym_PLUS_PLUS] = ACTIONS(583),
    [anon_sym_DASH_DASH] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(184),
    [anon_sym_SQUOTE] = ACTIONS(186),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(188),
    [sym_number] = ACTIONS(190),
    [sym_private_property_identifier] = ACTIONS(585),
    [sym_this] = ACTIONS(587),
    [sym_super] = ACTIONS(196),
    [sym_true] = ACTIONS(198),
    [sym_false] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(541),
    [anon_sym_readonly] = ACTIONS(591),
    [anon_sym_get] = ACTIONS(541),
    [anon_sym_set] = ACTIONS(541),
    [anon_sym_QMARK] = ACTIONS(593),
    [anon_sym_declare] = ACTIONS(541),
    [anon_sym_public] = ACTIONS(541),
    [anon_sym_private] = ACTIONS(541),
    [anon_sym_protected] = ACTIONS(541),
    [anon_sym_override] = ACTIONS(541),
    [anon_sym_module] = ACTIONS(541),
    [anon_sym_any] = ACTIONS(595),
    [anon_sym_number] = ACTIONS(595),
    [anon_sym_boolean] = ACTIONS(595),
    [anon_sym_string] = ACTIONS(595),
    [anon_sym_symbol] = ACTIONS(595),
    [anon_sym_object] = ACTIONS(595),
    [anon_sym_abstract] = ACTIONS(597),
    [anon_sym_infer] = ACTIONS(599),
    [anon_sym_keyof] = ACTIONS(601),
    [anon_sym_unique] = ACTIONS(214),
    [anon_sym_unknown] = ACTIONS(216),
    [anon_sym_never] = ACTIONS(216),
    [anon_sym_LBRACE_PIPE] = ACTIONS(218),
    [sym_html_comment] = ACTIONS(5),
  },
  [57] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(943),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [58] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(819),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [59] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(823),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [60] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(830),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [61] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(841),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [62] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(843),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STATE(2222),
    [sym_generator_function_declaration] = STATE(831),
    [sym_arrow_function] = STATE(2222),
    [sym__call_signature] = STATE(5821),
    [sym_call_expression] = STATE(2222),
    [sym_new_expression] = STATE(1948),
    [sym_await_expression] = STATE(2358),
    [sym_member_expression] = STATE(1362),
    [sym_subscript_expression] = STATE(1362),
    [sym_assignment_expression] = STATE(2358),
    [sym__augmented_assignment_lhs] = STATE(3025),
    [sym_augmented_assignment_expression] = STATE(2358),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2358),
    [sym_binary_expression] = STATE(2358),
    [sym_unary_expression] = STATE(2358),
    [sym_update_expression] = STATE(2358),
    [sym_sequence_expression] = STATE(5305),
    [sym_string] = STATE(2222),
    [sym_template_string] = STATE(2222),
    [sym_regex] = STATE(2222),
    [sym_meta_property] = STATE(2222),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(3806),
    [sym_non_null_expression] = STATE(1362),
    [sym_function_signature] = STATE(831),
    [sym_type_assertion] = STATE(2358),
    [sym_as_expression] = STATE(2358),
    [sym_satisfies_expression] = STATE(2358),
    [sym_instantiation_expression] = STATE(2358),
    [sym_ambient_declaration] = STATE(831),
    [sym_abstract_class_declaration] = STATE(831),
    [sym_module] = STATE(831),
    [sym_internal_module] = STATE(214),
    [sym_import_alias] = STATE(831),
    [sym_interface_declaration] = STATE(831),
    [sym_enum_declaration] = STATE(831),
    [sym_type_alias_declaration] = STATE(831),
    [sym_type_arguments] = STATE(428),
    [sym_type_parameters] = STATE(5328),
    [aux_sym_export_statement_repeat1] = STATE(3774),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_using] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [63] = {
    [sym_import] = STATE(3663),
    [sym_parenthesized_expression] = STATE(1322),
    [sym_expression] = STATE(2126),
    [sym_primary_expression] = STATE(1515),
    [sym_yield_expression] = STATE(1652),
    [sym_object] = STATE(1687),
    [sym_object_pattern] = STATE(4425),
    [sym_assignment_pattern] = STATE(4969),
    [sym_array] = STATE(1687),
    [sym_array_pattern] = STATE(4425),
    [sym_nested_identifier] = STATE(5474),
    [sym_class] = STATE(1687),
    [sym_function_expression] = STATE(1687),
    [sym_generator_function] = STATE(1687),
    [sym_arrow_function] = STATE(1687),
    [sym__call_signature] = STATE(5508),
    [sym_call_expression] = STATE(1687),
    [sym_new_expression] = STATE(1648),
    [sym_await_expression] = STATE(1652),
    [sym_member_expression] = STATE(1396),
    [sym_subscript_expression] = STATE(1396),
    [sym_assignment_expression] = STATE(1652),
    [sym__augmented_assignment_lhs] = STATE(3003),
    [sym_augmented_assignment_expression] = STATE(1652),
    [sym__destructuring_pattern] = STATE(4425),
    [sym_spread_element] = STATE(4946),
    [sym_ternary_expression] = STATE(1652),
    [sym_binary_expression] = STATE(1652),
    [sym_unary_expression] = STATE(1652),
    [sym_update_expression] = STATE(1652),
    [sym_string] = STATE(2213),
    [sym_template_string] = STATE(1687),
    [sym_regex] = STATE(1687),
    [sym_meta_property] = STATE(1687),
    [sym_decorator] = STATE(1344),
    [sym_formal_parameters] = STATE(4317),
    [sym_pattern] = STATE(4406),
    [sym_rest_pattern] = STATE(4115),
    [sym_non_null_expression] = STATE(1396),
    [sym_type_assertion] = STATE(1652),
    [sym_as_expression] = STATE(1652),
    [sym_satisfies_expression] = STATE(1652),
    [sym_instantiation_expression] = STATE(1652),
    [sym_internal_module] = STATE(1652),
    [sym_nested_type_identifier] = STATE(2939),
    [sym__type_query_member_expression_in_type_annotation] = STATE(3303),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2938),
    [sym_type] = STATE(3773),
    [sym_tuple_parameter] = STATE(4568),
    [sym_optional_tuple_parameter] = STATE(4568),
    [sym_optional_type] = STATE(4568),
    [sym_rest_type] = STATE(4568),
    [sym__tuple_type_member] = STATE(4568),
    [sym_constructor_type] = STATE(3007),
    [sym_primary_type] = STATE(2981),
    [sym_template_literal_type] = STATE(3039),
    [sym_infer_type] = STATE(3007),
    [sym_conditional_type] = STATE(3039),
    [sym_generic_type] = STATE(3039),
    [sym_type_query] = STATE(3039),
    [sym_index_type_query] = STATE(3039),
    [sym_lookup_type] = STATE(3039),
    [sym_literal_type] = STATE(3039),
    [sym__number] = STATE(3041),
    [sym_existential_type] = STATE(3039),
    [sym_flow_maybe_type] = STATE(3039),
    [sym_parenthesized_type] = STATE(3039),
    [sym_predefined_type] = STATE(3039),
    [sym_type_arguments] = STATE(484),
    [sym_object_type] = STATE(3039),
    [sym_type_parameters] = STATE(5455),
    [sym_array_type] = STATE(3039),
    [sym_tuple_type] = STATE(3039),
    [sym_readonly_type] = STATE(3007),
    [sym_union_type] = STATE(3039),
    [sym_intersection_type] = STATE(3039),
    [sym_function_type] = STATE(3007),
    [aux_sym_export_statement_repeat1] = STATE(4429),
    [aux_sym_array_repeat1] = STATE(4955),
    [aux_sym_array_pattern_repeat1] = STATE(4977),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_STAR] = ACTIONS(543),
    [anon_sym_type] = ACTIONS(541),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_COMMA] = ACTIONS(549),
    [anon_sym_typeof] = ACTIONS(551),
    [anon_sym_import] = ACTIONS(131),
    [anon_sym_let] = ACTIONS(541),
    [anon_sym_const] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(553),
    [anon_sym_LPAREN] = ACTIONS(138),
    [anon_sym_await] = ACTIONS(555),
    [anon_sym_yield] = ACTIONS(557),
    [anon_sym_LBRACK] = ACTIONS(559),
    [anon_sym_RBRACK] = ACTIONS(645),
    [anon_sym_class] = ACTIONS(146),
    [anon_sym_async] = ACTIONS(563),
    [anon_sym_function] = ACTIONS(150),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(567),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_SLASH] = ACTIONS(577),
    [anon_sym_LT] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(553),
    [anon_sym_void] = ACTIONS(579),
    [anon_sym_delete] = ACTIONS(581),
    [anon_sym_PLUS_PLUS] = ACTIONS(583),
    [anon_sym_DASH_DASH] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(184),
    [anon_sym_SQUOTE] = ACTIONS(186),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(188),
    [sym_number] = ACTIONS(190),
    [sym_private_property_identifier] = ACTIONS(585),
    [sym_this] = ACTIONS(587),
    [sym_super] = ACTIONS(196),
    [sym_true] = ACTIONS(198),
    [sym_false] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(541),
    [anon_sym_readonly] = ACTIONS(591),
    [anon_sym_get] = ACTIONS(541),
    [anon_sym_set] = ACTIONS(541),
    [anon_sym_QMARK] = ACTIONS(593),
    [anon_sym_declare] = ACTIONS(541),
    [anon_sym_public] = ACTIONS(541),
    [anon_sym_private] = ACTIONS(541),
    [anon_sym_protected] = ACTIONS(541),
    [anon_sym_override] = ACTIONS(541),
    [anon_sym_module] = ACTIONS(541),
    [anon_sym_any] = ACTIONS(595),
    [anon_sym_number] = ACTIONS(595),
    [anon_sym_boolean] = ACTIONS(595),
    [anon_sym_string] = ACTIONS(595),
    [anon_sym_symbol] = ACTIONS(595),
    [anon_sym_object] = ACTIONS(595),
    [anon_sym_abstract] = ACTIONS(597),
    [anon_sym_infer] = ACTIONS(599),
    [anon_sym_keyof] = ACTIONS(601),
    [anon_sym_unique] = ACTIONS(214),
    [anon_sym_unknown] = ACTIONS(216),
    [anon_sym_never] = ACTIONS(216),
    [anon_sym_LBRACE_PIPE] = ACTIONS(218),
    [sym_html_comment] = ACTIONS(5),
  },
  [64] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3636),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(853),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(831),
    [sym_lexical_declaration] = STATE(831),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1362),
    [sym_expression] = STATE(1902),
    [sym_primary_expression] = STATE(1810),
    [sym_yield_expression] = STATE(2358),
    [sym_object] = STATE(2222),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2222),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2222),
    [sym_class_declaration] = STATE(831),
    [sym_function_expression] = STATE(2222),
    [sym_function_declaration] = STATE(831),
    [sym_generator_function] = STA