/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.math;

import java.io.Serializable;
import java.util.Map;

public class MutableInteger
implements Serializable {
    private int value;

    public MutableInteger(int value) {
        this.value = value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public void addValue(int value) {
        this.value += value;
    }

    public void increment() {
        ++this.value;
    }

    public void decrement() {
        --this.value;
    }

    public int intValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public static <T> void addToBag(Map<T, MutableInteger> bag, T key) {
        MutableInteger.addToBag(bag, key, 1);
    }

    public static <T> void addToBag(Map<T, MutableInteger> bag, Map<T, MutableInteger> otherBag) {
        for (Map.Entry<T, MutableInteger> e : otherBag.entrySet()) {
            MutableInteger count = e.getValue();
            MutableInteger.addToBag(bag, e.getKey(), count.intValue());
        }
    }

    public static <T> void addToBag(Map<T, MutableInteger> bag, T key, int c) {
        MutableInteger count = bag.get(key);
        if (count == null) {
            count = new MutableInteger(0);
            bag.put(key, count);
        }
        count.setValue(count.intValue() + c);
    }

    public static <T> int countInBag(Map<T, MutableInteger> bag, T key) {
        MutableInteger count = bag.get(key);
        return count != null ? count.intValue() : 0;
    }
}

