/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.Orientation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SizeListener
implements WindowFrame.ElectricEventListener {
    private List<Geometric> stretchGeoms;
    private Cell stretchCell;
    private WindowFrame.ElectricEventListener oldListener;
    private Cursor oldCursor;
    private Point2D farthestCorner;
    private Point2D farthestEdge;
    private Point2D closestCorner;
    private Point2D closestEdge;
    private NodeInst selectedNode;
    private ArcInst selectedArc;
    private static Cursor sizeCursor = ToolBar.readCursor("CursorSize.gif", 14, 14);
    private static SizeListener currentListener = null;

    private SizeListener() {
    }

    public static void sizeObjects() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = wnd.getCell();
        Highlighter highlighter = wnd.getHighlighter();
        if (CircuitChangeJobs.cantEdit(cell, null, true, false, false) != 0) {
            return;
        }
        List<Geometric> geomList = highlighter.getHighlightedEObjs(true, true);
        if (geomList == null) {
            return;
        }
        int numArcs = 0;
        int numPrims = 0;
        for (Geometric geom : geomList) {
            if (geom instanceof ArcInst) {
                ++numArcs;
                continue;
            }
            NodeInst ni = (NodeInst)geom;
            if (!ni.isCellInstance()) {
                ++numPrims;
            }
            if (CircuitChangeJobs.cantEdit(cell, ni, true, false, false) == 0) continue;
            return;
        }
        if (numPrims == 0 && numArcs == 0) {
            System.out.println("You must select arcs or primitive nodes.  Cell instances cannot be resized.");
            return;
        }
        if (numPrims != 0 && numArcs != 0) {
            System.out.println("You must select either arcs or primitive nodes, but not a mix of both.");
            return;
        }
        WindowFrame.ElectricEventListener oldListener = WindowFrame.getListener();
        Cursor oldCursor = TopLevel.getCurrentCursor();
        System.out.println("Click to stretch");
        WindowFrame.ElectricEventListener newListener = oldListener;
        if (newListener == null || !(newListener instanceof SizeListener)) {
            currentListener = new SizeListener();
            newListener = currentListener;
            WindowFrame.setListener(newListener);
        }
        ((SizeListener)newListener).stretchGeoms = geomList;
        ((SizeListener)newListener).stretchCell = wnd.getCell();
        if (!(oldListener instanceof SizeListener)) {
            ((SizeListener)newListener).oldListener = oldListener;
            ((SizeListener)newListener).oldCursor = oldCursor;
        }
        TopLevel.setCurrentCursor(sizeCursor);
        ((SizeListener)newListener).selectedNode = null;
        ((SizeListener)newListener).selectedArc = null;
        ((SizeListener)newListener).showHighlight(null, wnd);
    }

    public static void restorePreviousListener(Object toDelete) {
        if (currentListener == null) {
            return;
        }
        if (SizeListener.currentListener.stretchGeoms == toDelete) {
            currentListener.restoringOriginalSetup(null);
        }
    }

    public static void sizeAllNodes() {
        new SizeObjects((Frame)TopLevel.getCurrentJFrame(), true, true);
    }

    public static void sizeAllArcs() {
        new SizeObjects((Frame)TopLevel.getCurrentJFrame(), true, false);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.findClosestObjectAndPoint(evt);
        this.showHighlight(evt, (EditWindow)evt.getSource());
    }

    private void findClosestObjectAndPoint(MouseEvent evt) {
        this.farthestCorner = null;
        this.closestCorner = null;
        this.farthestEdge = null;
        this.closestEdge = null;
        this.selectedNode = null;
        this.selectedArc = null;
        EditWindow wnd = (EditWindow)evt.getSource();
        int oldx = evt.getX();
        int oldy = evt.getY();
        Point2D pt = wnd.screenToDatabase(oldx, oldy);
        double closestDist = Double.MAX_VALUE;
        for (Geometric geom : this.stretchGeoms) {
            if (geom instanceof ArcInst) {
                ArcInst ai = (ArcInst)geom;
                long gridWidth = DBMath.lambdaToSizeGrid(ai.getLambdaBaseWidth());
                Poly poly = ai.makeLambdaPoly(gridWidth, Poly.Type.CLOSED);
                if (poly == null) continue;
                PolyBase.Point[] stretchedPoints = poly.getPoints();
                int angle = ai.getDefinedAngle();
                for (int i = 0; i < stretchedPoints.length; ++i) {
                    double cY;
                    double cX;
                    double dist;
                    int thisAng;
                    int lastI = i - 1;
                    if (lastI < 0) {
                        lastI = stretchedPoints.length - 1;
                    }
                    if ((thisAng = DBMath.figureAngle(stretchedPoints[lastI], stretchedPoints[i])) % 1800 != angle % 1800 || !((dist = pt.distance(new Point2D.Double(cX = (((Point2D)stretchedPoints[lastI]).getX() + ((Point2D)stretchedPoints[i]).getX()) / 2.0, cY = (((Point2D)stretchedPoints[lastI]).getY() + ((Point2D)stretchedPoints[i]).getY()) / 2.0))) < closestDist)) continue;
                    closestDist = dist;
                    this.farthestCorner = null;
                    this.closestCorner = null;
                    this.farthestEdge = null;
                    this.closestEdge = null;
                    this.selectedNode = null;
                    this.selectedArc = ai;
                }
                continue;
            }
            NodeInst ni = (NodeInst)geom;
            if (ni.getProto() instanceof Cell) continue;
            Poly nodePoly = ni.getBaseShape();
            PolyBase.Point[] points = nodePoly.getPoints();
            for (int i = 0; i < points.length; ++i) {
                Point2D.Double edge;
                int lastI;
                double dist = pt.distance(points[i]);
                if (dist < closestDist) {
                    closestDist = dist;
                    this.closestCorner = points[i];
                    this.farthestCorner = points[(i + points.length / 2) % points.length];
                    this.farthestEdge = null;
                    this.closestEdge = null;
                    this.selectedNode = ni;
                    this.selectedArc = null;
                }
                if ((lastI = i - 1) < 0) {
                    lastI = points.length - 1;
                }
                if (!((dist = pt.distance(edge = new Point2D.Double((((Point2D)points[i]).getX() + ((Point2D)points[lastI]).getX()) / 2.0, (((Point2D)points[i]).getY() + ((Point2D)points[lastI]).getY()) / 2.0))) < closestDist)) continue;
                closestDist = dist;
                int oppI = (i + points.length / 2) % points.length;
                lastI = oppI - 1;
                if (lastI < 0) {
                    lastI = points.length - 1;
                }
                this.closestEdge = edge;
                this.farthestEdge = new Point2D.Double((((Point2D)points[oppI]).getX() + ((Point2D)points[lastI]).getX()) / 2.0, (((Point2D)points[oppI]).getY() + ((Point2D)points[lastI]).getY()) / 2.0);
                this.farthestCorner = null;
                this.closestCorner = null;
                this.selectedNode = ni;
                this.selectedArc = null;
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.showHighlight(evt, (EditWindow)evt.getSource());
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        EditWindow wnd = (EditWindow)evt.getSource();
        this.restoringOriginalSetup(wnd);
        for (Geometric geom : this.stretchGeoms) {
            assert (geom.isLinked());
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                Point2D.Double newCenter = new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY());
                Point2D newSize = this.getNewNodeSize(evt, newCenter, ni);
                new ScaleNode(ni, EPoint.fromLambda(((Point2D)newCenter).getX(), ((Point2D)newCenter).getY()), newSize.getX(), newSize.getY());
                continue;
            }
            ArcInst ai = (ArcInst)geom;
            double newLambdaBaseWidth = this.getNewArcSize(evt, ai);
            new ScaleArc(ai, newLambdaBaseWidth);
        }
        wnd.repaint();
    }

    private void restoringOriginalSetup(EditWindow wnd) {
        WindowFrame.setListener(this.oldListener);
        TopLevel.setCurrentCursor(this.oldCursor);
        if (wnd != null) {
            Highlighter highlighter = wnd.getHighlighter();
            highlighter.clear();
            for (Geometric geom : this.stretchGeoms) {
                highlighter.addElectricObject(geom, this.stretchCell);
            }
            highlighter.finished();
        }
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        int chr = evt.getKeyCode();
        EditWindow wnd = (EditWindow)evt.getSource();
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        if (chr == 27) {
            this.restoringOriginalSetup(wnd);
            System.out.println("Sizing aborted");
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent e) {
    }

    private void showHighlight(MouseEvent evt, EditWindow wnd) {
        Highlighter highlighter = wnd.getHighlighter();
        highlighter.clear();
        for (Geometric geom : this.stretchGeoms) {
            PolyBase.Point[] stretchedPoints;
            Poly stretchedPoly;
            highlighter.addElectricObject(geom, this.stretchCell);
            double boxSize = 5.0 / wnd.getScale();
            Color dotColor = new Color(User.getColor(User.ColorPrefType.GRID));
            if (geom instanceof NodeInst) {
                Point2D newSize;
                Point2D.Double newCenter;
                NodeInst ni = (NodeInst)geom;
                if (ni.isCellInstance()) continue;
                if (evt != null) {
                    newCenter = new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY());
                    newSize = this.getNewNodeSize(evt, newCenter, ni);
                } else {
                    newCenter = new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY());
                    newSize = new Point2D.Double(ni.getLambdaBaseXSize(), ni.getLambdaBaseYSize());
                }
                stretchedPoly = ni.getBaseShape(EPoint.snap(newCenter), newSize.getX(), newSize.getY());
                stretchedPoints = stretchedPoly.getPoints();
                for (int i = 0; i < stretchedPoints.length; ++i) {
                    int lastI = i - 1;
                    if (lastI < 0) {
                        lastI = stretchedPoints.length - 1;
                    }
                    highlighter.addLine(stretchedPoints[lastI], stretchedPoints[i], this.stretchCell);
                    double cX = (((Point2D)stretchedPoints[lastI]).getX() + ((Point2D)stretchedPoints[i]).getX()) / 2.0;
                    double cY = (((Point2D)stretchedPoints[lastI]).getY() + ((Point2D)stretchedPoints[i]).getY()) / 2.0;
                    Poly poly = new Poly(cX, cY, boxSize, boxSize);
                    poly.setStyle(Poly.Type.FILLED);
                    highlighter.addPoly(poly, this.stretchCell, dotColor);
                    poly = new Poly(((Point2D)stretchedPoints[i]).getX(), ((Point2D)stretchedPoints[i]).getY(), boxSize, boxSize);
                    poly.setStyle(Poly.Type.FILLED);
                    highlighter.addPoly(poly, this.stretchCell, dotColor);
                }
                continue;
            }
            ArcInst ai = (ArcInst)geom;
            long newGridWidth = DBMath.lambdaToSizeGrid(this.getNewArcSize(evt, ai));
            stretchedPoly = ai.makeLambdaPoly(newGridWidth, Poly.Type.CLOSED);
            if (stretchedPoly == null) {
                return;
            }
            stretchedPoints = stretchedPoly.getPoints();
            int angle = ai.getDefinedAngle();
            for (int i = 0; i < stretchedPoints.length; ++i) {
                int lastI = i - 1;
                if (lastI < 0) {
                    lastI = stretchedPoints.length - 1;
                }
                highlighter.addLine(stretchedPoints[lastI], stretchedPoints[i], this.stretchCell);
                int thisAng = DBMath.figureAngle(stretchedPoints[lastI], stretchedPoints[i]);
                if (thisAng % 1800 != angle % 1800) continue;
                double cX = (((Point2D)stretchedPoints[lastI]).getX() + ((Point2D)stretchedPoints[i]).getX()) / 2.0;
                double cY = (((Point2D)stretchedPoints[lastI]).getY() + ((Point2D)stretchedPoints[i]).getY()) / 2.0;
                Poly poly = new Poly(cX, cY, boxSize, boxSize);
                poly.setStyle(Poly.Type.FILLED);
                highlighter.addPoly(poly, this.stretchCell, dotColor);
            }
        }
        highlighter.finished();
    }

    private Point2D getNewNodeSize(MouseEvent evt, Point2D newCenter, NodeInst desiredNI) {
        boolean square;
        NodeInst selNode = this.selectedNode;
        if (selNode == null) {
            selNode = desiredNI;
        }
        boolean selNodeSideways = selNode.getAngle() == 900 || selNode.getAngle() == 2700;
        EditWindow wnd = (EditWindow)evt.getSource();
        int oldx = evt.getX();
        int oldy = evt.getY();
        Point2D pt = wnd.screenToDatabase(oldx, oldy);
        double growthRatioX = 1.0;
        double growthRatioY = 1.0;
        Point2D closest = this.closestCorner != null ? this.closestCorner : this.closestEdge;
        Point2D farthest = this.farthestCorner != null ? this.farthestCorner : this.farthestEdge;
        long x = Math.round((pt.getX() - closest.getX()) / User.getAlignmentToGrid().getWidth());
        double newX = (double)x * User.getAlignmentToGrid().getWidth() + closest.getX();
        long y = Math.round((pt.getY() - closest.getY()) / User.getAlignmentToGrid().getHeight());
        double newY = (double)y * User.getAlignmentToGrid().getHeight() + closest.getY();
        pt.setLocation(newX, newY);
        boolean centerBased = (evt.getModifiersEx() & 0x40) != 0 && (evt.getModifiersEx() & 0x80) != 0;
        boolean singleAxis = (evt.getModifiersEx() & 0x40) == 0 && (evt.getModifiersEx() & 0x80) != 0 && this.farthestCorner != null;
        boolean bl = square = !selNode.isCellInstance() && ((PrimitiveNode)selNode.getProto()).isSquare();
        if ((evt.getModifiersEx() & 0x40) != 0 && (evt.getModifiersEx() & 0x80) == 0) {
            square = true;
        }
        if (closest != null && farthest != null) {
            if (centerBased) {
                double ptToCenterX = Math.abs(pt.getX());
                double closestToCenterX = Math.abs(closest.getX());
                double ptToCenterY = Math.abs(pt.getY());
                double closestToCenterY = Math.abs(closest.getY());
                if (closestToCenterX != 0.0) {
                    growthRatioX = ptToCenterX / closestToCenterX;
                }
                if (closestToCenterY != 0.0) {
                    growthRatioY = ptToCenterY / closestToCenterY;
                }
            } else {
                double ptToFarthestX = pt.getX() - farthest.getX();
                double closestToFarthestX = closest.getX() - farthest.getX();
                double ptToFarthestY = pt.getY() - farthest.getY();
                double closestToFarthestY = closest.getY() - farthest.getY();
                if (closestToFarthestX != 0.0) {
                    growthRatioX = ptToFarthestX / closestToFarthestX;
                }
                if (closestToFarthestY != 0.0) {
                    growthRatioY = ptToFarthestY / closestToFarthestY;
                }
            }
        }
        if (singleAxis) {
            double gry;
            double grx = Math.abs(growthRatioX);
            if (grx < 1.0) {
                grx = grx == 0.0 ? 9999.0 : 1.0 / grx;
            }
            if ((gry = Math.abs(growthRatioY)) < 1.0) {
                gry = gry == 0.0 ? 9999.0 : 1.0 / gry;
            }
            if (grx > gry) {
                growthRatioY = 1.0;
            } else {
                growthRatioX = 1.0;
            }
        }
        if (square) {
            if (Math.abs(growthRatioX) > Math.abs(growthRatioY)) {
                growthRatioY = growthRatioX;
            } else {
                growthRatioX = growthRatioY;
            }
        }
        if (selNodeSideways) {
            double swap = growthRatioX;
            growthRatioX = growthRatioY;
            growthRatioY = swap;
        }
        double newXSize = selNode.getLambdaBaseXSize() * growthRatioX;
        double newYSize = selNode.getLambdaBaseYSize() * growthRatioY;
        double signX = newXSize < 0.0 ? -1.0 : 1.0;
        double signY = newYSize < 0.0 ? -1.0 : 1.0;
        Point2D.Double newSize = new Point2D.Double(Math.abs(newXSize), Math.abs(newYSize));
        if (selNodeSideways) {
            newXSize = ((Point2D)newSize).getY();
            newYSize = ((Point2D)newSize).getX();
        }
        if (!centerBased) {
            if (closest != null && farthest != null) {
                double newClosestX;
                double closestX = closest.getX();
                double closestY = closest.getY();
                double farthestX = farthest.getX();
                double farthestY = farthest.getY();
                double d = closestX == farthestX ? closestX : (newClosestX = farthestX + newXSize * signX * (double)(closestX > farthestX ? 1 : -1));
                double newClosestY = closestY == farthestY ? closestY : farthestY + newYSize * signY * (double)(closestY > farthestY ? 1 : -1);
                newCenter.setLocation((farthestX + newClosestX) / 2.0, (farthestY + newClosestY) / 2.0);
            } else {
                newCenter.setLocation(desiredNI.getAnchorCenterX(), desiredNI.getAnchorCenterY());
            }
        }
        if (selNode != desiredNI) {
            double offX = newCenter.getX() - selNode.getAnchorCenterX();
            double offY = newCenter.getY() - selNode.getAnchorCenterY();
            newCenter.setLocation(desiredNI.getAnchorCenterX() + offX, desiredNI.getAnchorCenterY() + offY);
            boolean desiredNodeSideways = desiredNI.getAngle() == 900 || desiredNI.getAngle() == 2700;
            offX = ((Point2D)newSize).getX() - selNode.getXSizeWithoutOffset();
            offY = ((Point2D)newSize).getY() - selNode.getYSizeWithoutOffset();
            if (selNodeSideways) {
                offX = ((Point2D)newSize).getY() - selNode.getXSizeWithoutOffset();
                offY = ((Point2D)newSize).getX() - selNode.getYSizeWithoutOffset();
            }
            offX += desiredNI.getXSizeWithoutOffset();
            offY += desiredNI.getYSizeWithoutOffset();
            if (desiredNodeSideways) {
                double swap = offX;
                offX = offY;
                offY = swap;
            }
            ((Point2D)newSize).setLocation(offX, offY);
        }
        return newSize;
    }

    private double getNewArcSize(MouseEvent evt, ArcInst desiredAI) {
        if (evt == null) {
            return desiredAI.getLambdaBaseWidth();
        }
        EditWindow wnd = (EditWindow)evt.getSource();
        int oldx = evt.getX();
        int oldy = evt.getY();
        Point2D pt = wnd.screenToDatabase(oldx, oldy);
        Point2D ptOnLine = DBMath.closestPointToLine((Point2D)this.selectedArc.getHeadLocation(), (Point2D)this.selectedArc.getTailLocation(), pt);
        double newLambdaBaseWidth = ptOnLine.distance(pt) * 2.0;
        Point2D.Double newLambdaBaseSize = new Point2D.Double(newLambdaBaseWidth, newLambdaBaseWidth);
        EditWindow.gridAlignSize(newLambdaBaseSize, -1);
        double newWid = ((Point2D)newLambdaBaseSize).getX();
        if (this.selectedArc != desiredAI) {
            double off = newWid - this.selectedArc.getLambdaBaseWidth();
            newWid = desiredAI.getLambdaBaseWidth() + off;
        }
        return newWid;
    }

    private static class SizeObjects
    extends EDialog {
        private JTextField xSize;
        private JTextField ySize;
        private boolean nodes;

        public SizeObjects(Frame parent, boolean modal, boolean nodes) {
            super(parent, modal);
            EditWindow wnd = EditWindow.needCurrent();
            if (wnd == null) {
                return;
            }
            Highlighter highlighter = wnd.getHighlighter();
            this.getContentPane().setLayout(new GridBagLayout());
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    this.closeDialog();
                }
            });
            String label = "Width:";
            this.nodes = nodes;
            if (nodes) {
                label = "X Size:";
                this.setTitle("Set Node Size");
                JLabel ySizeLabel = new JLabel("Y Size:");
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.insets = new Insets(4, 4, 4, 4);
                this.getContentPane().add((Component)ySizeLabel, gbc);
                this.ySize = new JTextField();
                this.ySize.setColumns(6);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 1;
                gbc.weightx = 1.0;
                gbc.fill = 2;
                gbc.insets = new Insets(4, 4, 4, 4);
                this.getContentPane().add((Component)this.ySize, gbc);
                EDialog.makeTextFieldSelectAllOnTab(this.ySize);
            } else {
                this.setTitle("Set Arc Size");
            }
            this.xSize = new JTextField();
            this.xSize.setColumns(6);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.xSize, gbc);
            EDialog.makeTextFieldSelectAllOnTab(this.xSize);
            JLabel xSizeLabel = new JLabel(label);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)xSizeLabel, gbc);
            double xS = 0.0;
            double yS = 0.0;
            Technology tech = null;
            for (Geometric geom : highlighter.getHighlightedEObjs(true, true)) {
                tech = geom.getParent().getTechnology();
                if (geom instanceof NodeInst && nodes) {
                    NodeInst ni = (NodeInst)geom;
                    xS = ni.getLambdaBaseXSize();
                    yS = ni.getLambdaBaseYSize();
                    continue;
                }
                if (!(geom instanceof ArcInst) || nodes) continue;
                ArcInst ai = (ArcInst)geom;
                xS = ai.getLambdaBaseWidth();
            }
            this.xSize.setText(TextUtils.formatDistance(xS, tech));
            if (nodes) {
                this.ySize.setText(TextUtils.formatDistance(yS, tech));
            }
            JButton ok = new JButton("OK");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.ok(evt);
                }
            });
            this.getRootPane().setDefaultButton(ok);
            JButton cancel = new JButton("Cancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.cancel(evt);
                }
            });
            this.pack();
            this.finishInitialization();
            this.setVisible(true);
        }

        @Override
        protected void escapePressed() {
            this.closeDialog();
        }

        private void cancel(ActionEvent evt) {
            this.closeDialog();
        }

        private void ok(ActionEvent evt) {
            EditWindow wnd = EditWindow.needCurrent();
            if (wnd == null) {
                return;
            }
            Highlighter highlighter = wnd.getHighlighter();
            List<Geometric> highlighted = highlighter.getHighlightedEObjs(true, true);
            double xS = TextUtils.atofDistance(this.xSize.getText());
            double yS = 0.0;
            if (this.nodes) {
                yS = TextUtils.atofDistance(this.ySize.getText());
            }
            new ResizeStuff(wnd.getCell(), highlighted, xS, yS, this.nodes);
            this.closeDialog();
        }
    }

    private static class ScaleNode
    extends Job {
        private NodeInst stretchNode;
        private EPoint newCenter;
        private double newWidth;
        private double newHeight;

        protected ScaleNode(NodeInst stretchNode, EPoint newCenter, double newWidth, double newHeight) {
            super("Scale node", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.stretchNode = stretchNode;
            this.newCenter = newCenter;
            this.newWidth = newWidth;
            this.newHeight = newHeight;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.getEditingPreferences();
            if (CircuitChangeJobs.cantEdit(this.stretchNode.getParent(), null, true, false, true) != 0) {
                return false;
            }
            EPoint[] points = this.stretchNode.getTrace();
            if (points != null) {
                double percX = this.newWidth / this.stretchNode.getLambdaBaseXSize();
                double percY = this.newHeight / this.stretchNode.getLambdaBaseYSize();
                FixpTransform trans = this.stretchNode.pureRotateOut();
                Point2D[] newPoints = new Point2D[points.length];
                for (int i = 0; i < points.length; ++i) {
                    if (points[i] == null) continue;
                    Point2D.Double newPoint = new Point2D.Double(((Point2D)points[i]).getX() * percX, ((Point2D)points[i]).getY() * percY);
                    trans.transform(newPoint, newPoint);
                    ((Point2D)newPoint).setLocation(((Point2D)newPoint).getX() + this.newCenter.getX(), ((Point2D)newPoint).getY() + this.newCenter.getY());
                    newPoints[i] = newPoint;
                }
                this.stretchNode.setTrace(newPoints);
                return true;
            }
            double dWid = this.newWidth - this.stretchNode.getLambdaBaseXSize();
            double dHei = this.newHeight - this.stretchNode.getLambdaBaseYSize();
            this.stretchNode.modifyInstance(this.newCenter.getX() - this.stretchNode.getAnchorCenterX(), this.newCenter.getY() - this.stretchNode.getAnchorCenterY(), dWid, dHei, Orientation.IDENT);
            return true;
        }
    }

    private static class ScaleArc
    extends Job {
        private ArcInst stretchArc;
        private double newLambdaBaseWidth;

        protected ScaleArc(ArcInst stretchArc, double newLambdaBaseWidth) {
            super("Scale arc", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.stretchArc = stretchArc;
            this.newLambdaBaseWidth = newLambdaBaseWidth;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (CircuitChangeJobs.cantEdit(this.stretchArc.getParent(), null, true, false, true) != 0) {
                return false;
            }
            this.stretchArc.setLambdaBaseWidth(this.newLambdaBaseWidth);
            return true;
        }
    }

    private static class ResizeStuff
    extends Job {
        private Cell cell;
        private List<Geometric> highlighted;
        private double xS;
        private double yS;
        private boolean nodes;

        protected ResizeStuff(Cell cell, List<Geometric> highlighted, double xS, double yS, boolean nodes) {
            super("Resize Objects", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.highlighted = highlighted;
            this.xS = xS;
            this.yS = yS;
            this.nodes = nodes;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (CircuitChangeJobs.cantEdit(this.cell, null, true, false, true) != 0) {
                return false;
            }
            boolean didSomething = false;
            for (Geometric geom : this.highlighted) {
                if (geom instanceof NodeInst && this.nodes) {
                    NodeInst ni = (NodeInst)geom;
                    double x = this.xS;
                    double y = this.yS;
                    if (!ni.isCellInstance() && ((PrimitiveNode)ni.getProto()).isSquare()) {
                        if (y > x) {
                            x = y;
                        } else {
                            y = x;
                        }
                    }
                    ni.resize(x - ni.getLambdaBaseXSize(), y - ni.getLambdaBaseYSize());
                    didSomething = true;
                    continue;
                }
                if (!(geom instanceof ArcInst) || this.nodes) continue;
                ArcInst ai = (ArcInst)geom;
                ai.setLambdaBaseWidth(this.xS);
                didSomething = true;
            }
            if (!didSomething) {
                System.out.println("Could not find any " + (this.nodes ? "nodes" : "arcs") + " to resize");
            }
            return true;
        }
    }
}

