/* Balsa E-Mail Client
 * Copyright (C) 1997 Jay Painter
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <string.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <ctype.h>
#include "message_interface.h"
#include "gtkpage.h"
#include "mail_structs.h"
#include "main_window.h"


GtkWidget *body = NULL;
extern MainWindow *mainW;


void
display_message (Message *message)
{
  int nchars;
  int i, j;
  char *c;
  char *ts;
  char temp[1024];
  GtkPageFont font;
  GtkPageAttr attr;
  gint attri;
  

  if (!message)
    return;


  if (body)
      gtk_widget_destroy (body);

  body = gtk_page_new ();
  font.name = "times";
  font.size = 14;
  font.bold = FALSE;
  font.italic = FALSE;
  gtk_page_init_attr (GTK_PAGE (body), &attr);
  attr.font = gtk_page_find_font (GTK_PAGE (body), &font);
  attri = gtk_page_find_attr (GTK_PAGE (body), &attr);

  gtk_box_pack_start (GTK_BOX (mainW->box), body, TRUE, TRUE, 0);
  gtk_widget_show (body);

  c = mail_fetchtext (message->mailbox->stream, message->mesgno);

  /*
   * Ok, I know.  This is really, really sloppy.
   */
  gtk_page_update_begin (GTK_PAGE (body));

  i = 0;
  j = 0;
  temp[0] = '\0';
  do
    {
      switch (c[i])
	{
	case '\n':
	  /* if there is a word, write it */
	  if (j)
	    {
	      temp[j] = '\0';
	      ts = g_strdup(temp);
	      gtk_page_add_text (GTK_PAGE (body), ts, attri);
	      j = 0;
	    }

	  gtk_page_linebreak (GTK_PAGE (body));
	  i++;
	  break;

	case '\r':
	  /* if there is a word, write it */
	  if (j)
	    {
	      temp[j] = '\0';
	      ts = g_strdup(temp);
	      gtk_page_add_text (GTK_PAGE (body), ts, attri);
	      j = 0;
	    }

	  gtk_page_linebreak (GTK_PAGE (body));
	  i++;
	  break;

	case 32:
	  /* eat white space */
	  while (c[i] == 32)
	    i++;
	    
	  /* if there is a word, write it */
	  if (j)
	    {
	      temp[j] = '\0';
	      ts = g_strdup(temp);
	      gtk_page_add_text (GTK_PAGE (body), ts, attri);
	      j = 0;
	    }

	  /* now for the space */
	  gtk_page_add_space (GTK_PAGE (body), attri);
	  break;

	case '\0':
	  /* if there is a word, write it */
	  if (j)
	    {
	      temp[j] = '\0';
	      gtk_page_add_text (GTK_PAGE (body), temp, attri);
	    }
	  break;

	default:
	  temp[j] = c[i];
	  j++;
	  
	  i++;
	  break;
	}
    }
  while (c[i] != '\0');
  
  gtk_page_update_end (GTK_PAGE (body));

}









