#include <glib.h>

int
main()
{ 
  GMutex* mutex;
  GCond* cond;
  GStaticMutex static_mutex = G_STATIC_MUTEX_INIT;
  g_lock_define(test_me);

  g_thread_init( NULL );

  mutex = g_mutex_new();
  cond = g_cond_new();
 
  g_mutex_lock(mutex);
  g_mutex_unlock(mutex);
  
  g_static_mutex_lock(static_mutex);
  g_static_mutex_unlock(static_mutex);
  
  g_cond_signal(cond);
  g_cond_broadcast(cond);
  
  g_lock(test_me);
  g_unlock(test_me);
  
  g_cond_free(cond);
  g_mutex_free(mutex);

  return 0;
}
