/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.gef;

import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.Command;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.gef.graphical.tools.SelectionTool;
import org.eclipse.wb.tests.gef.CreationToolCursorTest;
import org.eclipse.wb.tests.gef.CursorLogger;
import org.eclipse.wb.tests.gef.GefCursorTestCase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class SelectionToolCursorTest
extends GefCursorTestCase {
    private SelectionTool m_tool;
    private EditPart m_buttonEditPart;
    private EditPart m_shellEditPart;
    private CursorLogger m_expectedLogger;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.m_tool = new SelectionTool();
        this.m_domain.setActiveTool((Tool)this.m_tool);
        this.m_shellEditPart = SelectionToolCursorTest.createEditPart((org.eclipse.gef.EditPart)this.m_viewer.getRootEditPart(), 20, 20, 460, 360, null, null);
        this.m_buttonEditPart = SelectionToolCursorTest.createEditPart((org.eclipse.gef.EditPart)this.m_shellEditPart, 100, 100, 200, 100, null, null);
        this.m_viewer.select((org.eclipse.gef.EditPart)this.m_buttonEditPart);
        this.m_expectedLogger = new CursorLogger();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        this.m_tool = null;
        this.m_shellEditPart = null;
        this.m_buttonEditPart = null;
        this.m_expectedLogger = null;
    }

    @Test
    public void test_Move() throws Exception {
        this.m_actualLogger.assertEmpty();
        this.m_sender.mouseEnter(0, 0);
        this.m_actualLogger.assertEmpty();
        this.m_sender.moveTo(10, 10);
        this.m_actualLogger.assertEmpty();
        this.m_sender.moveTo(120, 120);
        this.m_expectedLogger.setCursor(Cursors.SIZENW);
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        this.m_sender.moveTo(50, 50);
        this.m_expectedLogger.setCursor(null);
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        this.m_sender.moveTo(120, 130);
        this.m_expectedLogger.setCursor(Cursors.SIZEALL);
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        this.m_sender.moveTo(5, 5);
        this.m_expectedLogger.setCursor(null);
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
    }

    @Test
    public void test_ResizeTracker() throws Exception {
        this.m_actualLogger.assertEmpty();
        this.m_sender.mouseEnter(0, 0);
        this.m_actualLogger.assertEmpty();
        this.m_sender.moveTo(120, 120);
        this.m_expectedLogger.setCursor(Cursors.SIZENW);
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        this.m_sender.startDrag(120, 120, 1);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(130, 120);
        this.m_actualLogger.assertEmpty();
        this.m_sender.endDrag();
        this.m_expectedLogger.setCursor(Cursors.SIZEALL);
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        this.m_sender.moveTo(110, 220);
        this.m_expectedLogger.setCursor(null);
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        this.m_sender.moveTo(120, 220);
        this.m_expectedLogger.setCursor(Cursors.SIZESW);
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        this.m_sender.startDrag(120, 220, 1);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(100, 220);
        this.m_actualLogger.assertEmpty();
        this.m_sender.endDrag();
        this.m_expectedLogger.setCursor(null);
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        this.m_sender.moveTo(220, 120);
        this.m_expectedLogger.setCursor(Cursors.SIZEN);
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        this.m_sender.startDrag(220, 120, 1);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(220, 100);
        this.m_actualLogger.assertEmpty();
        this.m_sender.startDrag(220, 100, 2);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(220, 90);
        this.m_actualLogger.assertEmpty();
        this.m_sender.endDrag();
        this.m_expectedLogger.setCursor(null);
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
    }

    @Disabled
    @Test
    public void test_ResizeTracker_Resize() throws Exception {
        ResizeCommand command = new ResizeCommand();
        GraphicalEditPart editPart = SelectionToolCursorTest.createEditPart((org.eclipse.gef.EditPart)this.m_shellEditPart, 10, 10, 50, 60, null, command);
        command.setPart(editPart);
        this.m_viewer.select((org.eclipse.gef.EditPart)editPart);
        CursorLogger expectedLogger = new CursorLogger();
        this.m_actualLogger.assertEmpty();
        this.m_sender.mouseEnter(0, 0);
        this.m_actualLogger.assertEmpty();
        this.m_sender.moveTo(80, 30);
        expectedLogger.setCursor(Cursors.SIZENE);
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.startDrag(80, 30, 1);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(90, 30);
        this.m_actualLogger.assertEmpty();
        this.m_sender.endDrag();
        this.m_actualLogger.assertEmpty();
    }

    @Test
    public void test_ResizeTracker_NoResize() throws Exception {
        GraphicalEditPart editPart = SelectionToolCursorTest.createEditPart((org.eclipse.gef.EditPart)this.m_shellEditPart, 10, 10, 50, 60, null, new Command(){});
        this.m_viewer.select((org.eclipse.gef.EditPart)editPart);
        CursorLogger expectedLogger = new CursorLogger();
        this.m_actualLogger.assertEmpty();
        this.m_sender.mouseEnter(0, 0);
        this.m_actualLogger.assertEmpty();
        this.m_sender.moveTo(80, 30);
        expectedLogger.setCursor(Cursors.SIZENE);
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.startDrag(80, 30, 1);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(90, 30);
        this.m_actualLogger.assertEmpty();
        this.m_sender.endDrag();
        expectedLogger.setCursor(null);
        this.m_actualLogger.assertEquals(expectedLogger);
    }

    @Test
    public void test_DragEditPartTracker_Click_NoMove() throws Exception {
        CursorLogger expectedLogger = new CursorLogger();
        this.m_actualLogger.assertEmpty();
        this.m_sender.mouseEnter(0, 0);
        this.m_actualLogger.assertEmpty();
        this.m_sender.moveTo(16, 16);
        this.m_actualLogger.assertEmpty();
        this.m_sender.click(20, 20, 1);
        expectedLogger.setCursor(Cursors.SIZENW);
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.moveTo(20, 30);
        expectedLogger.setCursor(Cursors.SIZEALL);
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.startDrag(20, 30, 1);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(10, 30);
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_NO());
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.endDrag();
        expectedLogger.setCursor(null);
        this.m_actualLogger.assertEquals(expectedLogger);
    }

    @Test
    public void test_DragEditPartTracker_Move() throws Exception {
        final GraphicalEditPart editPart = SelectionToolCursorTest.createEditPart((org.eclipse.gef.EditPart)this.m_shellEditPart, 20, 20, 50, 50, null, null);
        this.m_shellEditPart.installEditPolicy((Object)"LayoutEditPolicy", (EditPolicy)new LayoutEditPolicy(){

            protected Command getMoveCommand(ChangeBoundsRequest request) {
                return new Command(){

                    public void execute() {
                        editPart.getFigure().setBounds(new Rectangle(10, 10, 50, 50));
                    }
                };
            }
        });
        this.m_viewer.select((org.eclipse.gef.EditPart)editPart);
        CursorLogger expectedLogger = new CursorLogger();
        this.m_actualLogger.assertEmpty();
        this.m_sender.mouseEnter(0, 0);
        this.m_actualLogger.assertEmpty();
        this.m_sender.moveTo(40, 50);
        expectedLogger.setCursor(Cursors.SIZEALL);
        this.m_actualLogger.assertEquals(expectedLogger);
        this.m_sender.startDrag(40, 50, 1);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(30, 50);
        this.m_actualLogger.assertEmpty();
        this.m_sender.endDrag();
        expectedLogger.setCursor(CreationToolCursorTest.CURSOR_NO());
        expectedLogger.setCursor(Cursors.SIZEALL);
        this.m_actualLogger.assertEquals(expectedLogger);
    }

    @Test
    public void test_MarqueeDragTracker() throws Exception {
        this.m_actualLogger.assertEmpty();
        this.m_sender.mouseEnter(0, 0);
        this.m_actualLogger.assertEmpty();
        this.m_sender.moveTo(50, 50);
        this.m_actualLogger.assertEmpty();
        this.m_sender.setStateMask(65536);
        this.m_sender.startDrag(50, 50, 1);
        this.m_expectedLogger.setCursor(Cursors.CROSS);
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        this.m_sender.dragTo(100, 100);
        this.m_actualLogger.assertEmpty();
        this.m_sender.dragTo(220, 120);
        this.m_actualLogger.assertEmpty();
        this.m_sender.endDrag();
        this.m_sender.setStateMask(0);
        this.m_expectedLogger.setCursor(null);
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        this.m_viewer.select((org.eclipse.gef.EditPart)this.m_buttonEditPart);
        this.m_sender.moveTo(220, 120);
        this.m_expectedLogger.setCursor(Cursors.SIZEN);
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        this.m_sender.setStateMask(65536);
        this.m_sender.startDrag(220, 120, 1);
        this.m_expectedLogger.setCursor(Cursors.CROSS);
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        this.m_sender.dragTo(230, 130);
        this.m_actualLogger.assertEmpty();
        this.m_sender.startDrag(230, 130, 2);
        this.m_expectedLogger.setCursor(Cursors.NO);
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        this.m_sender.dragTo(235, 135);
        this.m_actualLogger.assertEmpty();
        this.m_sender.endDrag();
        this.m_sender.setStateMask(0);
        this.m_expectedLogger.setCursor(null);
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
    }

    private static final class ResizeCommand
    extends Command {
        private GraphicalEditPart m_editPart;

        private ResizeCommand() {
        }

        public void setPart(GraphicalEditPart editPart) {
            this.m_editPart = editPart;
        }

        public void execute() {
            this.m_editPart.getFigure().setBounds(new Rectangle(10, 10, 60, 60));
        }
    }
}

