/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.gbl;

import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.GridBagLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.RowInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.gbl.AbstractGridBagLayoutTest;
import org.junit.jupiter.api.Test;

public class GridBagRowTest
extends AbstractGridBagLayoutTest {
    @Test
    public void test_getAlignment_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.rowHeights = new int[]{0};\n\t\tsetLayout(layout);\n\t}\n}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagRowTest.assertEquals((int)1, (int)layout.getRows().size());
        GridBagRowTest.assertSame((Object)RowInfo.Alignment.UNKNOWN, (Object)((RowInfo)layout.getRows().get(0)).getAlignment());
    }

    @Test
    public void test_getAlignment_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tgbc.anchor = GridBagConstraints.NORTH;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagRowTest.assertEquals((int)1, (int)layout.getRows().size());
        GridBagRowTest.assertSame((Object)RowInfo.Alignment.TOP, (Object)((RowInfo)layout.getRows().get(0)).getAlignment());
    }

    @Test
    public void test_getAlignment_3() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tgbc.anchor = GridBagConstraints.NORTH;\n\t\t\tadd(button, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tgbc.anchor = GridBagConstraints.SOUTH;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagRowTest.assertEquals((int)1, (int)layout.getRows().size());
        RowInfo row = (RowInfo)layout.getRows().get(0);
        GridBagRowTest.assertSame((Object)RowInfo.Alignment.UNKNOWN, (Object)row.getAlignment());
        row.setAlignment(RowInfo.Alignment.BOTTOM);
        GridBagRowTest.assertSame((Object)RowInfo.Alignment.BOTTOM, (Object)row.getAlignment());
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tgbc.anchor = GridBagConstraints.SOUTH;\n\t\t\tadd(button, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tgbc.anchor = GridBagConstraints.SOUTH;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_DELETE_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {1, 2, 3};\n\t\tlayout.rowHeights = new int[] {1, 2, 3};\n\t\tlayout.columnWeights = new double[] {0.1, 0.2, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.1, 0.2, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_1, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button_2, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagRowTest.assertEquals((int)2, (int)layout.getColumns().size());
        GridBagRowTest.assertEquals((int)2, (int)layout.getRows().size());
        layout.getRowOperations().delete(0);
        GridBagRowTest.assertEquals((int)2, (int)layout.getColumns().size());
        GridBagRowTest.assertEquals((int)1, (int)layout.getRows().size());
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {1, 2, 3};\n\t\tlayout.rowHeights = new int[] {2, 3};\n\t\tlayout.columnWeights = new double[] {0.1, 0.2, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.2, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button_2 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_2, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_DELETE_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {1, 2, 3};\n\t\tlayout.rowHeights = new int[] {1, 2, 3};\n\t\tlayout.columnWeights = new double[] {0.1, 0.2, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.1, 0.2, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tgbc.gridheight = 2;\n\t\t\tadd(button_0, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button_1, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagRowTest.assertEquals((int)2, (int)layout.getColumns().size());
        GridBagRowTest.assertEquals((int)2, (int)layout.getRows().size());
        layout.getRowOperations().delete(1);
        GridBagRowTest.assertEquals((int)2, (int)layout.getColumns().size());
        GridBagRowTest.assertEquals((int)1, (int)layout.getRows().size());
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {1, 2, 3};\n\t\tlayout.rowHeights = new int[] {1, 3};\n\t\tlayout.columnWeights = new double[] {0.1, 0.2, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.1, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 0, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_0, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_MOVE_backward() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {1, 2, 3, 4};\n\t\tlayout.rowHeights = new int[] {1, 2, 3, 4};\n\t\tlayout.columnWeights = new double[] {0.1, 0.2, 0.3, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.1, 0.2, 0.3, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_0, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 5);\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button_1, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 2;\n\t\t\tgbc.gridy = 2;\n\t\t\tadd(button_2, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        final GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagRowTest.assertEquals((int)3, (int)layout.getRows().size());
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                layout.getRowOperations().move(2, 0);
            }
        });
        GridBagRowTest.assertEquals((int)3, (int)layout.getRows().size());
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {1, 2, 3, 4};\n\t\tlayout.rowHeights = new int[] {3, 1, 2, 4};\n\t\tlayout.columnWeights = new double[] {0.1, 0.2, 0.3, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.3, 0.1, 0.2, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button_2 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 0);\n\t\t\tgbc.gridx = 2;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_2, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button_0, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 0, 5);\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 2;\n\t\t\tadd(button_1, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_MOVE_forward() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {1, 2, 3, 4};\n\t\tlayout.rowHeights = new int[] {1, 2, 3, 4};\n\t\tlayout.columnWeights = new double[] {0.1, 0.2, 0.3, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.1, 0.2, 0.3, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_0, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 5);\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button_1, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 2;\n\t\t\tgbc.gridy = 2;\n\t\t\tadd(button_2, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        final GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagRowTest.assertEquals((int)3, (int)layout.getRows().size());
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                layout.getRowOperations().move(0, 3);
            }
        });
        GridBagRowTest.assertEquals((int)3, (int)layout.getRows().size());
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {1, 2, 3, 4};\n\t\tlayout.rowHeights = new int[] {2, 3, 1, 4};\n\t\tlayout.columnWeights = new double[] {0.1, 0.2, 0.3, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.2, 0.3, 0.1, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 5);\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_1, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 0);\n\t\t\tgbc.gridx = 2;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button_2, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 0, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 2;\n\t\t\tadd(button_0, gbc);\n\t\t}\n\t}\n}");
    }
}

