/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component;

import javax.swing.JList;
import javax.swing.ListModel;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.property.editor.models.list.ListModelPropertyEditor;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class JListTest
extends SwingModelTest {
    @Test
    public void test_parsing() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JList list = new JList();", "    add(list);", "    list.setModel(new AbstractListModel() {", "      String[] values = {'111', '222', '333'};", "      public int getSize() {", "        return values.length;", "      }", "      public Object getElementAt(int i) {", "        return values[i];", "      }", "    });", "  }", "}");
        this.refresh();
        ComponentInfo listInfo = (ComponentInfo)JListTest.getJavaInfoByName("list");
        JList listObject = (JList)listInfo.getObject();
        ListModel model = listObject.getModel();
        JListTest.assertNotNull(model);
        JListTest.assertEquals((int)3, (int)model.getSize());
        JListTest.assertEquals((Object)"111", model.getElementAt(0));
        JListTest.assertEquals((Object)"222", model.getElementAt(1));
        JListTest.assertEquals((Object)"333", model.getElementAt(2));
        Property modelProperty = listInfo.getPropertyByTitle("model");
        Object[] actualItems = ListModelPropertyEditor.getItems((Property)modelProperty);
        JListTest.assertArrayEquals((Object[])new String[]{"111", "222", "333"}, (Object[])actualItems);
    }

    @Test
    public void test_nullModelValues() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JList list = new JList();", "    add(list);", "    list.setModel(new AbstractListModel() {", "      String[] values = null;", "      public int getSize() {", "        return values.length;", "      }", "      public Object getElementAt(int i) {", "        return values[i];", "      }", "    });", "  }", "}");
        this.refresh();
        ComponentInfo listInfo = (ComponentInfo)JListTest.getJavaInfoByName("list");
        JList listObject = (JList)listInfo.getObject();
        ListModel model = listObject.getModel();
        JListTest.assertNotNull(model);
        JListTest.assertEquals((int)0, (int)model.getSize());
    }

    @Test
    public void test_setSelectedIndex() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JList list = new JList();", "    add(list);", "    list.setModel(new AbstractListModel() {", "      String[] values = {'111', '222', '333'};", "      public int getSize() {", "        return values.length;", "      }", "      public Object getElementAt(int i) {", "        return values[i];", "      }", "    });", "  }", "}");
        this.refresh();
        ComponentInfo listInfo = (ComponentInfo)JListTest.getJavaInfoByName("list");
        listInfo.getPropertyByTitle("selectedIndex").setValue((Object)1);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JList list = new JList();", "    add(list);", "    list.setModel(new AbstractListModel() {", "      String[] values = {'111', '222', '333'};", "      public int getSize() {", "        return values.length;", "      }", "      public Object getElementAt(int i) {", "        return values[i];", "      }", "    });", "    list.setSelectedIndex(1);", "  }", "}");
    }

    @Test
    public void test_modelEditor() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JList list = new JList();", "    add(list);", "  }", "}");
        this.refresh();
        ComponentInfo listInfo = (ComponentInfo)JListTest.getJavaInfoByName("list");
        Property modelProperty = listInfo.getPropertyByTitle("model");
        JListTest.assertEquals((int)0, (int)ListModelPropertyEditor.getItems((Property)modelProperty).length);
        ListModelPropertyEditor.setItems((Property)modelProperty, (String[])new String[]{"aaa", "bbb"});
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JList list = new JList();", "    list.setModel(new AbstractListModel() {", "      String[] values = new String[] {'aaa', 'bbb'};", "      public int getSize() {", "        return values.length;", "      }", "      public Object getElementAt(int index) {", "        return values[index];", "      }", "    });", "    add(list);", "  }", "}");
    }
}

