/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.databinding.rcp.model.widgets;

import java.util.List;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.rcp.databinding.DatabindingsProvider;
import org.eclipse.wb.internal.rcp.databinding.model.BindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.IObservableFactory;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.WidgetsObserveTypeContainer;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.bindables.WidgetBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.bindables.WidgetPropertyBindableInfo;
import org.eclipse.wb.internal.rcp.model.jface.DialogInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.databinding.rcp.model.AbstractBindingTest;
import org.junit.jupiter.api.Test;

public class WidgetBindableTest
extends AbstractBindingTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_widgets() throws Exception {
        CompositeInfo shell = this.parseComposite("import java.io.File;", "public class Test {", "  protected Shell m_shell;", "  private Label m_label;", "  private Button m_button;", "  private Text m_text;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new GridLayout());", "    m_label = new Label(m_shell, SWT.NONE);", "    m_button = new Button(m_shell, SWT.NONE);", "    m_text = new Text(m_shell, SWT.BORDER);", "  }", "}");
        WidgetBindableTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        WidgetBindableTest.assertInstanceOf(WidgetsObserveTypeContainer.class, provider.getContainers().get(1));
        List observes = provider.getObserves(ObserveType.WIDGETS);
        WidgetBindableTest.assertNotNull((Object)observes);
        WidgetBindableTest.assertEquals((int)1, (int)observes.size());
        WidgetBindableTest.assertBindable(shell, WidgetBindableInfo.class, null, true, "m_shell|m_shell|org.eclipse.swt.widgets.Shell", observes.get(0));
        List widgetChildren = shell.getChildrenControls();
        List children = ((IObserveInfo)observes.get(0)).getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        WidgetBindableTest.assertEquals((int)3, (int)children.size());
        WidgetBindableTest.assertBindable(widgetChildren.get(0), WidgetBindableInfo.class, observes.get(0), false, "m_label|m_label|org.eclipse.swt.widgets.Label", children.get(0));
        WidgetBindableTest.assertBindable(widgetChildren.get(1), WidgetBindableInfo.class, observes.get(0), false, "m_button|m_button|org.eclipse.swt.widgets.Button", children.get(1));
        WidgetBindableTest.assertBindable(widgetChildren.get(2), WidgetBindableInfo.class, observes.get(0), false, "m_text|m_text|org.eclipse.swt.widgets.Text", children.get(2));
    }

    @Test
    public void test_widget_Shell_properties() throws Exception {
        WidgetBindableInfo root = this.parseBindings("  //", "    //");
        List properties = root.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        this.widget_Link_Shell_properties(properties);
    }

    @Test
    public void test_widget_Label_properties() throws Exception {
        this.widget_Label_CLabel_properties("  private Label m_label;", "    m_label = new Label(m_shell, SWT.NONE);");
    }

    @Test
    public void test_widget_CLabel_properties() throws Exception {
        this.widget_Label_CLabel_properties("  private CLabel m_clabel;", "    m_clabel = new CLabel(m_shell, SWT.NONE);");
    }

    @Test
    public void test_widget_Link_properties() throws Exception {
        WidgetBindableInfo root = this.parseBindings("  private Link m_link;", "    m_link = new Link(m_shell, SWT.NONE);");
        List children = root.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        List properties = ((IObserveInfo)children.get(0)).getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        this.widget_Link_Shell_properties(properties);
    }

    private void widget_Label_CLabel_properties(String fieldLine, String createLine) throws Exception {
        WidgetBindableInfo root = this.parseBindings(fieldLine, createLine);
        List children = root.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        List properties = ((IObserveInfo)children.get(0)).getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        WidgetBindableTest.assertEquals((int)12, (int)properties.size());
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "background|observeBackground|org.eclipse.swt.graphics.Color", properties.get(0));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "bounds|observeBounds|org.eclipse.swt.graphics.Rectangle", properties.get(1));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "enabled|observeEnabled|boolean", properties.get(2));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "focused|observeFocus|boolean", properties.get(3));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "font|observeFont|org.eclipse.swt.graphics.Font", properties.get(4));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "foreground|observeForeground|org.eclipse.swt.graphics.Color", properties.get(5));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "image|observeImage|org.eclipse.swt.graphics.Image", properties.get(6));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "location|observeLocation|org.eclipse.swt.graphics.Point", properties.get(7));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "size|observeSize|org.eclipse.swt.graphics.Point", properties.get(8));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "text|observeText|java.lang.String", properties.get(9));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "tooltipText|observeTooltipText|java.lang.String", properties.get(10));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "visible|observeVisible|boolean", properties.get(11));
    }

    private void widget_Link_Shell_properties(List<IObserveInfo> properties) throws Exception {
        WidgetBindableTest.assertEquals((int)11, (int)properties.size());
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "background|observeBackground|org.eclipse.swt.graphics.Color", properties.get(0));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "bounds|observeBounds|org.eclipse.swt.graphics.Rectangle", properties.get(1));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "enabled|observeEnabled|boolean", properties.get(2));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "focused|observeFocus|boolean", properties.get(3));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "font|observeFont|org.eclipse.swt.graphics.Font", properties.get(4));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "foreground|observeForeground|org.eclipse.swt.graphics.Color", properties.get(5));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "location|observeLocation|org.eclipse.swt.graphics.Point", properties.get(6));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "size|observeSize|org.eclipse.swt.graphics.Point", properties.get(7));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "text|observeText|java.lang.String", properties.get(8));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "tooltipText|observeTooltipText|java.lang.String", properties.get(9));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "visible|observeVisible|boolean", properties.get(10));
    }

    @Test
    public void test_widget_Composite_properties() throws Exception {
        WidgetBindableInfo root = this.parseBindings("  private Composite m_composite;", "    m_composite = new Composite(m_shell, SWT.NONE);");
        List children = root.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        List properties = ((IObserveInfo)children.get(0)).getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        WidgetBindableTest.assertEquals((int)10, (int)properties.size());
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "background|observeBackground|org.eclipse.swt.graphics.Color", properties.get(0));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "bounds|observeBounds|org.eclipse.swt.graphics.Rectangle", properties.get(1));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "enabled|observeEnabled|boolean", properties.get(2));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "focused|observeFocus|boolean", properties.get(3));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "font|observeFont|org.eclipse.swt.graphics.Font", properties.get(4));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "foreground|observeForeground|org.eclipse.swt.graphics.Color", properties.get(5));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "location|observeLocation|org.eclipse.swt.graphics.Point", properties.get(6));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "size|observeSize|org.eclipse.swt.graphics.Point", properties.get(7));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "tooltipText|observeTooltipText|java.lang.String", properties.get(8));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "visible|observeVisible|boolean", properties.get(9));
    }

    @Test
    public void test_widget_Form_properties() throws Exception {
        WidgetBindableInfo root = this.parseBindings("  private Form m_form;", "    m_form = new Form(m_shell, SWT.NONE);");
        List children = root.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        List properties = ((IObserveInfo)children.get(0)).getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        WidgetBindableTest.assertEquals((int)11, (int)properties.size());
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "background|observeBackground|org.eclipse.swt.graphics.Color", properties.get(0));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "bounds|observeBounds|org.eclipse.swt.graphics.Rectangle", properties.get(1));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "enabled|observeEnabled|boolean", properties.get(2));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "focused|observeFocus|boolean", properties.get(3));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "font|observeFont|org.eclipse.swt.graphics.Font", properties.get(4));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "foreground|observeForeground|org.eclipse.swt.graphics.Color", properties.get(5));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "location|observeLocation|org.eclipse.swt.graphics.Point", properties.get(6));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "size|observeSize|org.eclipse.swt.graphics.Point", properties.get(7));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "text|observeText|java.lang.String", properties.get(8));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "tooltipText|observeTooltipText|java.lang.String", properties.get(9));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "visible|observeVisible|boolean", properties.get(10));
    }

    @Test
    public void test_widget_Button_properties() throws Exception {
        WidgetBindableInfo root = this.parseBindings("  private Button m_button;", "    m_button = new Button(m_shell, SWT.NONE);");
        List children = root.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        List properties = ((IObserveInfo)children.get(0)).getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        WidgetBindableTest.assertEquals((int)13, (int)properties.size());
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "background|observeBackground|org.eclipse.swt.graphics.Color", properties.get(0));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "bounds|observeBounds|org.eclipse.swt.graphics.Rectangle", properties.get(1));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "enabled|observeEnabled|boolean", properties.get(2));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "focused|observeFocus|boolean", properties.get(3));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "font|observeFont|org.eclipse.swt.graphics.Font", properties.get(4));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "foreground|observeForeground|org.eclipse.swt.graphics.Color", properties.get(5));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "image|observeImage|org.eclipse.swt.graphics.Image", properties.get(6));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "location|observeLocation|org.eclipse.swt.graphics.Point", properties.get(7));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "selection|observeSelection|boolean", properties.get(8));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "size|observeSize|org.eclipse.swt.graphics.Point", properties.get(9));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "text|observeText|java.lang.String", properties.get(10));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "tooltipText|observeTooltipText|java.lang.String", properties.get(11));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "visible|observeVisible|boolean", properties.get(12));
    }

    @Test
    public void test_widget_Text_properties() throws Exception {
        WidgetBindableInfo root = this.parseBindings("  private Text m_text;", "    m_text = new Text(m_shell, SWT.NONE);");
        List children = root.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        List properties = ((IObserveInfo)children.get(0)).getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        WidgetBindableTest.assertEquals((int)13, (int)properties.size());
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "background|observeBackground|org.eclipse.swt.graphics.Color", properties.get(0));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "bounds|observeBounds|org.eclipse.swt.graphics.Rectangle", properties.get(1));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "editable|observeEditable|boolean", properties.get(2));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "enabled|observeEnabled|boolean", properties.get(3));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "focused|observeFocus|boolean", properties.get(4));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "font|observeFont|org.eclipse.swt.graphics.Font", properties.get(5));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "foreground|observeForeground|org.eclipse.swt.graphics.Color", properties.get(6));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "location|observeLocation|org.eclipse.swt.graphics.Point", properties.get(7));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "message|observeMessage|java.lang.String", properties.get(8));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "size|observeSize|org.eclipse.swt.graphics.Point", properties.get(9));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "text|observeText|java.lang.String", properties.get(10));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "tooltipText|observeTooltipText|java.lang.String", properties.get(11));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "visible|observeVisible|boolean", properties.get(12));
    }

    @Test
    public void test_widget_Spinner_properties() throws Exception {
        this.widget_Spinner_Scale_properties("  private Spinner m_spinner;", "    m_spinner = new Spinner(m_shell, SWT.NONE);");
    }

    @Test
    public void test_widget_Scale_properties() throws Exception {
        this.widget_Spinner_Scale_properties("  private Scale m_scale;", "    m_scale = new Scale(m_shell, SWT.NONE);");
    }

    private void widget_Spinner_Scale_properties(String fieldLine, String createLine) throws Exception {
        WidgetBindableInfo root = this.parseBindings(fieldLine, createLine);
        List children = root.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        List properties = ((IObserveInfo)children.get(0)).getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        WidgetBindableTest.assertEquals((int)13, (int)properties.size());
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "background|observeBackground|org.eclipse.swt.graphics.Color", properties.get(0));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "bounds|observeBounds|org.eclipse.swt.graphics.Rectangle", properties.get(1));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "enabled|observeEnabled|boolean", properties.get(2));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "focused|observeFocus|boolean", properties.get(3));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "font|observeFont|org.eclipse.swt.graphics.Font", properties.get(4));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "foreground|observeForeground|org.eclipse.swt.graphics.Color", properties.get(5));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "location|observeLocation|org.eclipse.swt.graphics.Point", properties.get(6));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "maximum|observeMax|int", properties.get(7));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "minimum|observeMin|int", properties.get(8));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "selection|observeSelection|int", properties.get(9));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "size|observeSize|org.eclipse.swt.graphics.Point", properties.get(10));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "tooltipText|observeTooltipText|java.lang.String", properties.get(11));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "visible|observeVisible|boolean", properties.get(12));
    }

    @Test
    public void test_widget_Combo_properties() throws Exception {
        this.widget_Combo_CCombo_properties("  private Combo m_combo;", "    m_combo = new Combo(m_shell, SWT.NONE);");
    }

    @Test
    public void test_widget_CCombo_properties() throws Exception {
        this.widget_Combo_CCombo_properties("  private CCombo m_ccombo;", "    m_ccombo = new CCombo(m_shell, SWT.NONE);");
    }

    private void widget_Combo_CCombo_properties(String fieldLine, String createLine) throws Exception {
        WidgetBindableInfo root = this.parseBindings(fieldLine, createLine);
        List children = root.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        List properties = ((IObserveInfo)children.get(0)).getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        WidgetBindableTest.assertEquals((int)14, (int)properties.size());
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "background|observeBackground|org.eclipse.swt.graphics.Color", properties.get(0));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "bounds|observeBounds|org.eclipse.swt.graphics.Rectangle", properties.get(1));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "enabled|observeEnabled|boolean", properties.get(2));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "focused|observeFocus|boolean", properties.get(3));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "font|observeFont|org.eclipse.swt.graphics.Font", properties.get(4));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "foreground|observeForeground|org.eclipse.swt.graphics.Color", properties.get(5));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "items|observeItems|java.util.List", properties.get(6));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "bounds|observeBounds|org.eclipse.swt.graphics.Rectangle", properties.get(1));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "location|observeLocation|org.eclipse.swt.graphics.Point", properties.get(7));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "selection|observeSelection|java.lang.String", properties.get(8));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "singleSelectionIndex|observeSingleSelectionIndex|int", properties.get(9));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "size|observeSize|org.eclipse.swt.graphics.Point", properties.get(10));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "text|observeText|java.lang.String", properties.get(11));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "tooltipText|observeTooltipText|java.lang.String", properties.get(12));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "visible|observeVisible|boolean", properties.get(13));
    }

    @Test
    public void test_widget_List_properties() throws Exception {
        WidgetBindableInfo root = this.parseBindings("  private List m_list;", "    m_list = new List(m_shell, SWT.NONE);");
        List children = root.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        List properties = ((IObserveInfo)children.get(0)).getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        WidgetBindableTest.assertEquals((int)13, (int)properties.size());
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "background|observeBackground|org.eclipse.swt.graphics.Color", properties.get(0));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "bounds|observeBounds|org.eclipse.swt.graphics.Rectangle", properties.get(1));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "enabled|observeEnabled|boolean", properties.get(2));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "focused|observeFocus|boolean", properties.get(3));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "font|observeFont|org.eclipse.swt.graphics.Font", properties.get(4));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "foreground|observeForeground|org.eclipse.swt.graphics.Color", properties.get(5));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "items|observeItems|java.util.List", properties.get(6));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "location|observeLocation|org.eclipse.swt.graphics.Point", properties.get(7));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "selection|observeSelection|java.lang.String", properties.get(8));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "singleSelectionIndex|observeSingleSelectionIndex|int", properties.get(9));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "size|observeSize|org.eclipse.swt.graphics.Point", properties.get(10));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "tooltipText|observeTooltipText|java.lang.String", properties.get(11));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "visible|observeVisible|boolean", properties.get(12));
    }

    @Test
    public void test_widget_Table_properties() throws Exception {
        WidgetBindableInfo root = this.parseBindings("  private Table m_table;", "    m_table = new Table(m_shell, SWT.NONE);");
        List children = root.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        List properties = ((IObserveInfo)children.get(0)).getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        WidgetBindableTest.assertEquals((int)11, (int)properties.size());
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "background|observeBackground|org.eclipse.swt.graphics.Color", properties.get(0));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "bounds|observeBounds|org.eclipse.swt.graphics.Rectangle", properties.get(1));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "enabled|observeEnabled|boolean", properties.get(2));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "focused|observeFocus|boolean", properties.get(3));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "font|observeFont|org.eclipse.swt.graphics.Font", properties.get(4));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "foreground|observeForeground|org.eclipse.swt.graphics.Color", properties.get(5));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "location|observeLocation|org.eclipse.swt.graphics.Point", properties.get(6));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "singleSelectionIndex|observeSingleSelectionIndex|int", properties.get(7));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "size|observeSize|org.eclipse.swt.graphics.Point", properties.get(8));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "tooltipText|observeTooltipText|java.lang.String", properties.get(9));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "visible|observeVisible|boolean", properties.get(10));
    }

    @Test
    public void test_widget_Viewer_properties() throws Exception {
        WidgetBindableInfo root = this.parseBindings("  private TableViewer m_viewer;", "    m_viewer = new TableViewer(m_shell, SWT.NONE);");
        List controls = root.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        List children = ((IObserveInfo)controls.get(0)).getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        List properties = ((IObserveInfo)children.get(0)).getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        WidgetBindableTest.assertEquals((int)5, (int)properties.size());
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "single selection|observeSingleSelection|java.lang.Object", properties.get(0));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "part of selection|observeSingleSelection|java.lang.Object", properties.get(1));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "multi selection|observeMultiSelection|java.lang.Object", properties.get(2));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "filters|observeFilters|org.eclipse.jface.viewers.ViewerFilter", properties.get(3));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "input|setInput|java.lang.Object", properties.get(4));
        WidgetPropertyBindableInfo inputProperty = (WidgetPropertyBindableInfo)properties.get(4);
        WidgetBindableTest.assertNotNull((Object)inputProperty.getObservableFactory());
        WidgetBindableTest.assertNull((Object)inputProperty.getObservableFactory().createObservable(null, null, null, false));
        WidgetBindableTest.assertNull((Object)inputProperty.getObservableFactory().createObservable((BindableInfo)children.get(0), (BindableInfo)inputProperty, IObservableFactory.Type.Input, false));
    }

    @Test
    public void test_widget_CheckboxTableViewer_properties() throws Exception {
        this.widget_Checkable_properties("  private CheckboxTableViewer m_viewer;", "    m_viewer = new CheckboxTableViewer(m_shell, SWT.NONE);");
    }

    @Test
    public void test_widget_CheckboxTreeViewer_properties() throws Exception {
        this.widget_Checkable_properties("  private CheckboxTreeViewer m_viewer;", "    m_viewer = new CheckboxTreeViewer(m_shell, SWT.NONE);");
    }

    private void widget_Checkable_properties(String fieldLine, String createLine) throws Exception {
        WidgetBindableInfo root = this.parseBindings(fieldLine, createLine);
        List controls = root.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        List children = ((IObserveInfo)controls.get(0)).getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        List properties = ((IObserveInfo)children.get(0)).getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        WidgetBindableTest.assertEquals((int)6, (int)properties.size());
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "single selection|observeSingleSelection|java.lang.Object", properties.get(0));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "part of selection|observeSingleSelection|java.lang.Object", properties.get(1));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "multi selection|observeMultiSelection|java.lang.Object", properties.get(2));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "checked elements|observeCheckedElements|java.lang.Object", properties.get(3));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "filters|observeFilters|org.eclipse.jface.viewers.ViewerFilter", properties.get(4));
        WidgetBindableTest.assertBindableProperty(WidgetPropertyBindableInfo.class, "input|setInput|java.lang.Object", properties.get(5));
    }

    private WidgetBindableInfo parseBindings(String fieldLine, String createLine) throws Exception {
        CompositeInfo shell = this.parseComposite("import java.io.File;", "public class Test {", "  protected Shell m_shell;", fieldLine, "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_shell.setLayout(new GridLayout());", createLine, "  }", "}");
        WidgetBindableTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        WidgetBindableTest.assertInstanceOf(WidgetsObserveTypeContainer.class, provider.getContainers().get(1));
        List observes = provider.getObserves(ObserveType.WIDGETS);
        WidgetBindableTest.assertNotNull((Object)observes);
        WidgetBindableTest.assertEquals((int)1, (int)observes.size());
        return (WidgetBindableInfo)observes.get(0);
    }

    @Test
    public void test_widget_noProperties() throws Exception {
        DialogInfo dialog = (DialogInfo)this.parseJavaInfo("import java.io.File;", "public class Test extends org.eclipse.jface.dialogs.Dialog {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected Control createDialogArea(Composite parent) {", "    Composite container = (Composite) super.createDialogArea(parent);", "    return container;", "  }", "}");
        WidgetBindableTest.assertNotNull((Object)dialog);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List observes = provider.getObserves(ObserveType.WIDGETS);
        WidgetBindableTest.assertNotNull((Object)observes);
        WidgetBindableTest.assertEquals((int)1, (int)observes.size());
        WidgetBindableInfo dialogBindable = (WidgetBindableInfo)observes.get(0);
        WidgetBindableTest.assertEquals((Object)"(org.eclipse.jface.dialogs.Dialog)", (Object)dialogBindable.getPresentation().getText());
        WidgetBindableTest.assertTrue((boolean)dialogBindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).isEmpty());
        WidgetBindableInfo parentInCreateDialogArea = (WidgetBindableInfo)dialogBindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).get(0);
        WidgetBindableTest.assertEquals((Object)"parent in createDialogArea(...)", (Object)parentInCreateDialogArea.getPresentation().getText());
        WidgetBindableTest.assertTrue((boolean)parentInCreateDialogArea.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).isEmpty());
    }

    public static void assertBindable(Object javaInfo, Class<?> testClass, Object testParent, boolean childrenState, String testString, Object object) throws Exception {
        WidgetBindableTest.assertInstanceOf(testClass, (Object)object);
        WidgetBindableTest.assertSame((Object)javaInfo, (Object)ReflectionUtils.getFieldObject((Object)object, (String)"m_javaInfo"));
        BindableInfo bindable = (BindableInfo)object;
        WidgetBindableTest.assertSame((Object)ObserveType.WIDGETS, (Object)bindable.getType());
        WidgetBindableTest.assertNotNull((Object)bindable.getObjectType());
        WidgetBindableTest.assertEquals((Object)testString, (Object)(bindable.getPresentation().getText() + "|" + bindable.getReference() + "|" + bindable.getObjectType().getName()));
        WidgetBindableTest.assertSame((Object)testParent, (Object)bindable.getParent());
        WidgetBindableTest.assertNotNull((Object)bindable.getPresentation());
        WidgetBindableTest.assertNotNull((Object)bindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable));
        WidgetBindableTest.assertEquals((Object)childrenState, (Object)(!bindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).isEmpty() ? 1 : 0));
        WidgetBindableTest.assertNotNull((Object)bindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable));
        WidgetBindableTest.assertFalse((boolean)bindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).isEmpty());
    }

    public static void assertBindableProperty(Class<?> testClass, String testString, Object object) throws Exception {
        WidgetBindableTest.assertInstanceOf(testClass, (Object)object);
        BindableInfo bindable = (BindableInfo)object;
        WidgetBindableTest.assertSame((Object)ObserveType.WIDGETS, (Object)bindable.getType());
        WidgetBindableTest.assertNotNull((Object)bindable.getPresentation());
        WidgetBindableTest.assertNotNull((Object)bindable.getObjectType());
        WidgetBindableTest.assertEquals((Object)testString, (Object)(bindable.getPresentation().getText() + "|" + bindable.getReference() + "|" + bindable.getObjectType().getName()));
        WidgetBindableTest.assertNull((Object)bindable.getParent());
        WidgetBindableTest.assertNotNull((Object)bindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable));
        WidgetBindableTest.assertTrue((boolean)bindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable).isEmpty());
        WidgetBindableTest.assertNotNull((Object)bindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable));
        WidgetBindableTest.assertTrue((boolean)bindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).isEmpty());
    }
}

