/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.palette;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.PaletteInfo;
import org.eclipse.wb.core.editor.palette.model.entry.ComponentEntryInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.palette.PaletteManager;
import org.eclipse.wb.internal.core.editor.palette.command.CategoryAddCommand;
import org.eclipse.wb.internal.core.editor.palette.command.Command;
import org.eclipse.wb.internal.core.editor.palette.model.entry.InstanceFactoryEntryInfo;
import org.eclipse.wb.internal.core.editor.palette.model.entry.StaticFactoryEntryInfo;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.core.TestProject;
import org.eclipse.wb.tests.designer.core.annotations.DisposeProjectAfter;
import org.eclipse.wb.tests.designer.core.palette.AbstractPaletteTest;
import org.junit.jupiter.api.Test;

public class PaletteManagerTest
extends AbstractPaletteTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_dynamic() throws Exception {
        JavaInfo panel = this.parseEmptyPanel();
        PaletteManager manager = new PaletteManager(panel, "test.toolkit");
        PaletteManagerTest.assertNull((Object)manager.getPalette());
        manager.reloadPalette();
        PaletteInfo palette = manager.getPalette();
        PaletteManagerTest.assertNotNull((Object)palette);
        PaletteManagerTest.assertEquals((int)0, (int)palette.getCategories().size());
        PaletteManagerTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1' description='description 1'>", "  <component class='javax.swing.JPanel'/>", "</category>"});
        try {
            manager.reloadPalette();
            palette = manager.getPalette();
            PaletteManagerTest.assertNotNull((Object)palette);
            PaletteManagerTest.assertEquals((int)1, (int)palette.getCategories().size());
            CategoryInfo category = palette.getCategory("category_1");
            PaletteManagerTest.assertEquals((int)1, (int)category.getEntries().size());
            ComponentEntryInfo componentEntry = (ComponentEntryInfo)category.getEntries().get(0);
            PaletteManagerTest.assertEquals((Object)"category_1 javax.swing.JPanel", (Object)componentEntry.getId());
        }
        finally {
            PaletteManagerTest.removeToolkitExtension();
        }
        manager.reloadPalette();
        palette = manager.getPalette();
        PaletteManagerTest.assertNotNull((Object)palette);
        PaletteManagerTest.assertEquals((int)0, (int)palette.getCategories().size());
    }

    @Test
    public void test_duplicateCategory() throws Exception {
        JavaInfo panel = this.parseEmptyPanel();
        PaletteManager manager = new PaletteManager(panel, "test.toolkit");
        PaletteManagerTest.addPaletteExtension(new String[]{"<category id='category_1' name='name 1' description='desc 1'>", "  <component class='javax.swing.JButton'/>", "</category>", "<category id='category_1' name='name 2' description='desc 2'>", "  <component class='javax.swing.JTextField'/>", "</category>"});
        try {
            manager.reloadPalette();
            PaletteInfo palette = manager.getPalette();
            PaletteManagerTest.assertEquals((int)1, (int)palette.getCategories().size());
            CategoryInfo category = palette.getCategory("category_1");
            PaletteManagerTest.assertEquals((Object)"name 1", (Object)category.getName());
            PaletteManagerTest.assertEquals((Object)"desc 1", (Object)category.getDescription());
            PaletteManagerTest.assertEquals((int)2, (int)category.getEntries().size());
            ComponentEntryInfo componentEntry = (ComponentEntryInfo)category.getEntries().get(0);
            PaletteManagerTest.assertEquals((Object)"javax.swing.JButton", (Object)componentEntry.getClassName());
            componentEntry = (ComponentEntryInfo)category.getEntries().get(1);
            PaletteManagerTest.assertEquals((Object)"javax.swing.JTextField", (Object)componentEntry.getClassName());
        }
        finally {
            PaletteManagerTest.removeToolkitExtension();
        }
    }

    @Test
    public void test_getPaletteCopy() throws Exception {
        PaletteManagerTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'/>"});
        JavaInfo panel = this.parseEmptyPanel();
        PaletteManager manager = new PaletteManager(panel, "test.toolkit");
        manager.reloadPalette();
        PaletteInfo palette = manager.getPalette();
        PaletteManagerTest.assertEquals((int)1, (int)palette.getCategories().size());
        PaletteManagerTest.assertNotNull((Object)palette.getCategory("category_1"));
        PaletteInfo paletteCopy = manager.getPaletteCopy();
        PaletteManagerTest.assertNotSame((Object)palette, (Object)paletteCopy);
        PaletteManagerTest.assertEquals((int)1, (int)paletteCopy.getCategories().size());
        PaletteManagerTest.assertNotNull((Object)paletteCopy.getCategory("category_1"));
    }

    @Test
    public void test_parse_outsideCategory() throws Exception {
        PaletteManagerTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'/>", "<component class='javax.swing.JButton' category='category_1'/>"});
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = palette.getCategory("category_1");
        PaletteManagerTest.assertEquals((int)1, (int)category.getEntries().size());
    }

    @Test
    public void test_parse_outsideCategory_noCategory() throws Exception {
        PaletteManagerTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'/>", "<component class='javax.swing.JButton'/>"});
        DesignerPlugin.setDisplayExceptionOnConsole((boolean)false);
        try {
            PaletteInfo palette = this.loadPalette();
            CategoryInfo category = palette.getCategory("category_1");
            PaletteManagerTest.assertEquals((int)0, (int)category.getEntries().size());
        }
        finally {
            DesignerPlugin.setDisplayExceptionOnConsole((boolean)true);
        }
    }

    @Test
    public void test_command_1() throws Exception {
        PaletteManager manager = this.loadManager();
        PaletteInfo palette = manager.getPalette();
        PaletteManagerTest.assertEquals((int)0, (int)palette.getCategories().size());
        manager.commands_add((Command)new CategoryAddCommand("new id", "new name", "new description", true, true, null));
        manager.commands_write();
        PaletteManagerTest.assertEquals((int)1, (int)palette.getCategories().size());
        CategoryInfo category = palette.getCategory("new id");
        PaletteManagerTest.assertEquals((Object)"new name", (Object)category.getName());
        PaletteManagerTest.assertEquals((Object)"new description", (Object)category.getDescription());
        manager.reloadPalette();
        palette = manager.getPalette();
        PaletteManagerTest.assertEquals((int)1, (int)palette.getCategories().size());
        PaletteManagerTest.assertNotNull((Object)palette.getCategory("new id"));
    }

    @Test
    public void test_command_2() throws Exception {
        PaletteManager manager = this.loadManager();
        PaletteInfo palette = manager.getPalette();
        PaletteManagerTest.assertEquals((int)0, (int)palette.getCategories().size());
    }

    @Test
    public void test_commandsInProject() throws Exception {
        String commandsFilePath = "wbp-meta/test.toolkit.wbp-palette-commands.xml";
        PaletteManagerTest.setFileContent(commandsFilePath, "");
        PaletteManager manager = this.loadManager();
        PaletteInfo palette = manager.getPalette();
        PaletteManagerTest.assertEquals((int)0, (int)palette.getCategories().size());
        manager.commands_add((Command)new CategoryAddCommand("new id", "new name", "new description", true, true, null));
        manager.commands_write();
        PaletteManagerTest.assertEquals((int)1, (int)palette.getCategories().size());
        CategoryInfo category = palette.getCategory("new id");
        PaletteManagerTest.assertEquals((Object)"new name", (Object)category.getName());
        PaletteManagerTest.assertEquals((Object)"new description", (Object)category.getDescription());
        String commands = PaletteManagerTest.getFileContent(commandsFilePath);
        PaletteManagerTest.assertNotEquals((Object)commands, (Object)"<commands/>");
        manager.reloadPalette();
        palette = manager.getPalette();
        PaletteManagerTest.assertEquals((int)1, (int)palette.getCategories().size());
        PaletteManagerTest.assertNotNull((Object)palette.getCategory("new id"));
    }

    @DisposeProjectAfter
    @Test
    public void test_applyCommandsFromJar() throws Exception {
        String jarPath = TestUtils.createTemporaryJar("wbp-meta/test.toolkit.wbp-palette-commands.xml", PaletteManagerTest.getSourceDQ("<commands>", "  <addCategory id='myID' name='myName' description='myDescription'/>", "</commands>"));
        ProjectUtils.addExternalJar((IJavaProject)m_javaProject, (String)jarPath, null);
        PaletteInfo palette = this.loadPalette();
        List categories = palette.getCategories();
        Assertions.assertThat((List)categories).hasSize(1);
        CategoryInfo category = (CategoryInfo)categories.get(0);
        PaletteManagerTest.assertEquals((Object)"myID", (Object)category.getId());
        PaletteManagerTest.assertEquals((Object)"myName", (Object)category.getName());
        PaletteManagerTest.assertEquals((Object)"myDescription", (Object)category.getDescription());
    }

    @Test
    public void test_categoryOrder_nextCategory() throws Exception {
        PaletteManagerTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'/>", "<category id='category_2' name='category 2'/>", "<category id='category_3' name='category 3' next='category_2'/>"});
        PaletteInfo palette = this.loadPalette();
        List categories = palette.getCategories();
        Assertions.assertThat((List)categories).hasSize(3);
        PaletteManagerTest.assertEquals((Object)"category_1", (Object)((CategoryInfo)categories.get(0)).getId());
        PaletteManagerTest.assertEquals((Object)"category_3", (Object)((CategoryInfo)categories.get(1)).getId());
        PaletteManagerTest.assertEquals((Object)"category_2", (Object)((CategoryInfo)categories.get(2)).getId());
    }

    @Test
    public void test_categoryOrder_nextCategory_2() throws Exception {
        PaletteManagerTest.addPaletteExtension("palette_1", new String[]{"<category id='category_3' name='category 3' next='category_2'/>"});
        PaletteManagerTest.addPaletteExtension("palette_2", new String[]{"<category id='category_1' name='category 1'/>", "<category id='category_2' name='category 2'/>"});
        try {
            PaletteInfo palette = this.loadPalette();
            List categories = palette.getCategories();
            Assertions.assertThat((List)categories).hasSize(3);
            PaletteManagerTest.assertEquals((Object)"category_1", (Object)((CategoryInfo)categories.get(0)).getId());
            PaletteManagerTest.assertEquals((Object)"category_3", (Object)((CategoryInfo)categories.get(1)).getId());
            PaletteManagerTest.assertEquals((Object)"category_2", (Object)((CategoryInfo)categories.get(2)).getId());
        }
        finally {
            PaletteManagerTest.removeToolkitExtension("palette_1");
            PaletteManagerTest.removeToolkitExtension("palette_2");
        }
    }

    @Test
    public void test_customPalette_project_1() throws Exception {
        PaletteManagerTest.setFileContent("wbp-meta", "test.toolkit.wbp-palette.xml", PaletteManagerTest.getSourceDQ("<palette>", "  <category id='categoryId.1' name='name 1' description='desc 1'>", "    <component class='javax.swing.JButton'/>", "    <component class='javax.swing.JTextField'/>", "  </category>", "  <category id='categoryId.2' name='name 1' description='desc 1' open='false'/>", "</palette>"));
        PaletteInfo palette = this.loadPalette();
        PaletteManagerTest.assertEquals((int)2, (int)palette.getCategories().size());
        CategoryInfo category = (CategoryInfo)palette.getCategories().get(0);
        PaletteManagerTest.assertEquals((Object)"categoryId.1", (Object)category.getId());
        PaletteManagerTest.assertEquals((Object)"name 1", (Object)category.getName());
        PaletteManagerTest.assertEquals((Object)"desc 1", (Object)category.getDescription());
        PaletteManagerTest.assertTrue((boolean)category.isOpen());
        PaletteManagerTest.assertEquals((int)2, (int)category.getEntries().size());
        ComponentEntryInfo component = (ComponentEntryInfo)category.getEntries().get(0);
        PaletteManagerTest.assertEquals((Object)"javax.swing.JButton", (Object)component.getClassName());
        PaletteManagerTest.assertEquals((Object)"categoryId.1 javax.swing.JButton", (Object)component.getId());
        PaletteManagerTest.assertTrue((boolean)component.isVisible());
        PaletteManagerTest.assertTrue((boolean)component.initialize(null, this.m_lastParseInfo));
        PaletteManagerTest.assertEquals((Object)"JButton", (Object)component.getName());
        PaletteManagerTest.assertEquals((Object)"An implementation of a \"push\" button.", (Object)component.getDescription());
        component = (ComponentEntryInfo)category.getEntries().get(1);
        PaletteManagerTest.assertEquals((Object)"javax.swing.JTextField", (Object)component.getClassName());
        category = (CategoryInfo)palette.getCategories().get(1);
        PaletteManagerTest.assertEquals((Object)"categoryId.2", (Object)category.getId());
        PaletteManagerTest.assertFalse((boolean)category.isOpen());
    }

    @Test
    public void test_customPalette_project_duplicateCategoryDeclaration() throws Exception {
        PaletteManagerTest.setFileContent("wbp-meta", "test.toolkit.wbp-palette.xml", PaletteManagerTest.getSourceDQ("<palette>", "  <category id='categoryId.1' name='name 1' description='desc 1'>", "    <component class='javax.swing.JButton'/>", "  </category>", "  <category id='categoryId.1' name='name 2' description='desc 2'>", "    <component class='javax.swing.JTextField'/>", "  </category>", "</palette>"));
        PaletteInfo palette = this.loadPalette();
        PaletteManagerTest.assertEquals((int)1, (int)palette.getCategories().size());
        CategoryInfo category = (CategoryInfo)palette.getCategories().get(0);
        PaletteManagerTest.assertEquals((Object)"categoryId.1", (Object)category.getId());
        PaletteManagerTest.assertEquals((Object)"name 1", (Object)category.getName());
        PaletteManagerTest.assertEquals((Object)"desc 1", (Object)category.getDescription());
        PaletteManagerTest.assertTrue((boolean)category.isOpen());
        PaletteManagerTest.assertEquals((int)2, (int)category.getEntries().size());
        ComponentEntryInfo component = (ComponentEntryInfo)category.getEntries().get(0);
        PaletteManagerTest.assertEquals((Object)"javax.swing.JButton", (Object)component.getClassName());
        component = (ComponentEntryInfo)category.getEntries().get(1);
        PaletteManagerTest.assertEquals((Object)"javax.swing.JTextField", (Object)component.getClassName());
    }

    @Test
    public void test_customPalette_project_2() throws Exception {
        PaletteManagerTest.setFileContent("wbp-meta", "test.toolkit.wbp-palette.xml", PaletteManagerTest.getSourceDQ("<palette>", "  <category id='categoryId.1' name='name 1' description='desc 1'>", "    <component id='myButton.id' class='javax.swing.JButton' name='my name' description='my desc' visible='false'/>", "  </category>", "</palette>"));
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = (CategoryInfo)palette.getCategories().get(0);
        ComponentEntryInfo component = (ComponentEntryInfo)category.getEntries().get(0);
        PaletteManagerTest.assertEquals((Object)"javax.swing.JButton", (Object)component.getClassName());
        PaletteManagerTest.assertEquals((Object)"myButton.id", (Object)component.getId());
        PaletteManagerTest.assertEquals((Object)"my name", (Object)component.getName());
        PaletteManagerTest.assertEquals((Object)"my desc", (Object)component.getDescription());
        PaletteManagerTest.assertFalse((boolean)component.isVisible());
    }

    @Test
    public void test_customPalette_project_3() throws Exception {
        PaletteManagerTest.setFileContent("wbp-meta", "test.toolkit.wbp-palette.xml", PaletteManagerTest.getSourceDQ("<palette>", "  <category id='categoryId.1' name='name 1' description='desc 1'>", "    <component creationId='creationId' class='javax.swing.JButton'/>", "  </category>", "</palette>"));
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = (CategoryInfo)palette.getCategories().get(0);
        ComponentEntryInfo component = (ComponentEntryInfo)category.getEntries().get(0);
        PaletteManagerTest.assertEquals((Object)"javax.swing.JButton", (Object)component.getClassName());
        PaletteManagerTest.assertEquals((Object)"categoryId.1 javax.swing.JButton creationId", (Object)component.getId());
    }

    @Test
    public void test_customPalette_project_4() throws Exception {
        PaletteInfo palette;
        PaletteManagerTest.setFileContent("wbp-meta", "test.toolkit.wbp-palette.xml", PaletteManagerTest.getSourceDQ("<palette>", "  <category id='categoryId.1' name='name 1' description='desc 1'>", "    <component no-class-attribute='javax.swing.JButton'/>", "  </category>", "</palette>"));
        final boolean[] exceptionHappened = new boolean[1];
        ILogListener logListener = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                exceptionHappened[0] = true;
                PaletteManagerTest.assertEquals((int)4, (int)status.getSeverity());
                PaletteManagerTest.assertEquals((Object)"org.eclipse.wb.core", (Object)status.getPlugin());
                PaletteManagerTest.assertEquals((int)4, (int)status.getCode());
            }
        };
        ILog log = DesignerPlugin.getDefault().getLog();
        try {
            log.addLogListener(logListener);
            DesignerPlugin.setDisplayExceptionOnConsole((boolean)false);
            palette = this.loadPalette();
        }
        finally {
            log.removeLogListener(logListener);
            DesignerPlugin.setDisplayExceptionOnConsole((boolean)true);
        }
        PaletteManagerTest.assertTrue((boolean)exceptionHappened[0]);
        CategoryInfo category = (CategoryInfo)palette.getCategories().get(0);
        PaletteManagerTest.assertEquals((int)0, (int)category.getEntries().size());
    }

    @Test
    public void test_customPalette_project_5() throws Exception {
        PaletteManagerTest.setFileContent("wbp-meta", "test.toolkit.wbp-palette.xml", PaletteManagerTest.getSourceDQ("<palette>", "  <category id='categoryId.1' name='name 1' description='desc 1'/>", "  <component class='javax.swing.JButton' category='categoryId.1'/>", "</palette>"));
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = (CategoryInfo)palette.getCategories().get(0);
        ComponentEntryInfo component = (ComponentEntryInfo)category.getEntries().get(0);
        PaletteManagerTest.assertEquals((Object)"javax.swing.JButton", (Object)component.getClassName());
    }

    @DisposeProjectAfter
    @Test
    public void test_customPalette_project_6() throws Exception {
        TestProject myTestProject = new TestProject("myProject");
        IJavaProject myJavaProject = myTestProject.getJavaProject();
        Path path = new Path("wbp-meta/test.toolkit.wbp-palette.xml");
        PaletteManagerTest.setFileContent(myJavaProject.getProject().getFile((IPath)path), PaletteManagerTest.getSourceDQ("<palette>", "  <category id='categoryId.1' name='name 1' description='desc 1'/>", "</palette>"));
        try {
            ProjectUtils.requireProject((IJavaProject)m_javaProject, (IJavaProject)myJavaProject);
            PaletteManagerTest.setFileContent("wbp-meta", "test.toolkit.wbp-palette.xml", PaletteManagerTest.getSourceDQ("<palette>", "  <category id='categoryId.2' name='name 2' description='desc 2'/>", "</palette>"));
            PaletteInfo palette = this.loadPalette();
            PaletteManagerTest.assertEquals((int)2, (int)palette.getCategories().size());
            CategoryInfo category = (CategoryInfo)palette.getCategories().get(0);
            PaletteManagerTest.assertEquals((Object)"categoryId.1", (Object)category.getId());
            category = (CategoryInfo)palette.getCategories().get(1);
            PaletteManagerTest.assertEquals((Object)"categoryId.2", (Object)category.getId());
        }
        finally {
            myTestProject.dispose();
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_customPalette_project_7() throws Exception {
        String jarPath = TestUtils.createTemporaryJar("wbp-meta/test.toolkit.wbp-palette.xml", PaletteManagerTest.getSourceDQ("<palette>", "  <category id='categoryId.1' name='name 1' description='desc 1'/>", "</palette>"));
        ProjectUtils.addClasspathEntry((IJavaProject)m_javaProject, (IClasspathEntry)JavaCore.newLibraryEntry((IPath)new Path(jarPath), null, null));
        PaletteManagerTest.setFileContent("wbp-meta", "test.toolkit.wbp-palette.xml", PaletteManagerTest.getSourceDQ("<palette>", "  <category id='categoryId.2' name='name 2' description='desc 2'/>", "</palette>"));
        PaletteInfo palette = this.loadPalette();
        PaletteManagerTest.assertEquals((int)2, (int)palette.getCategories().size());
        CategoryInfo category = (CategoryInfo)palette.getCategories().get(0);
        PaletteManagerTest.assertEquals((Object)"categoryId.1", (Object)category.getId());
        category = (CategoryInfo)palette.getCategories().get(1);
        PaletteManagerTest.assertEquals((Object)"categoryId.2", (Object)category.getId());
    }

    @Test
    public void test_customPalette_project_nextCategory() throws Exception {
        PaletteManagerTest.addPaletteExtension("palette_1", new String[]{"<category id='category_1' name='category_1'/>", "<category id='category_2' name='category_2'/>"});
        PaletteManagerTest.setFileContent("wbp-meta", "test.toolkit.wbp-palette.xml", PaletteManagerTest.getSourceDQ("<!-- filler filler filler filler filler -->", "<palette>", "  <category id='fromProject' name='fromProject' next='category_2'/>", "</palette>"));
        try {
            PaletteInfo palette = this.loadPalette();
            List categories = palette.getCategories();
            Assertions.assertThat((List)categories).hasSize(3);
            PaletteManagerTest.assertEquals((Object)"category_1", (Object)((CategoryInfo)categories.get(0)).getId());
            PaletteManagerTest.assertEquals((Object)"fromProject", (Object)((CategoryInfo)categories.get(1)).getId());
            PaletteManagerTest.assertEquals((Object)"category_2", (Object)((CategoryInfo)categories.get(2)).getId());
        }
        finally {
            PaletteManagerTest.removeToolkitExtension("palette_1");
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_customPalette_project_whenOneFileMissing() throws Exception {
        TestProject myTestProject = new TestProject("myProject");
        IJavaProject myJavaProject = myTestProject.getJavaProject();
        Path path = new Path("wbp-meta/test.toolkit.wbp-palette.xml");
        IFile file = myJavaProject.getProject().getFile((IPath)path);
        PaletteManagerTest.setFileContent(file, PaletteManagerTest.getSource("<palette>", "  <category id='categoryId.1' name='name 1' description='desc 1'/>", "</palette>"));
        file.getLocation().toFile().delete();
        try {
            ProjectUtils.requireProject((IJavaProject)m_javaProject, (IJavaProject)myJavaProject);
            PaletteManagerTest.setFileContent("wbp-meta", "test.toolkit.wbp-palette.xml", PaletteManagerTest.getSourceDQ("<palette>", "  <category id='categoryId.2' name='name 2' description='desc 2'/>", "</palette>"));
            PaletteInfo palette = this.loadPalette();
            Assertions.assertThat((List)palette.getCategories()).hasSize(1);
            CategoryInfo category = (CategoryInfo)palette.getCategories().get(0);
            PaletteManagerTest.assertEquals((Object)"categoryId.2", (Object)category.getId());
            List warnings = this.m_lastState.getWarnings();
            Assertions.assertThat((List)warnings).hasSize(1);
            EditorWarning warning = (EditorWarning)warnings.get(0);
            Assertions.assertThat((String)warning.getMessage()).contains(new CharSequence[]{"myProject/wbp-meta/test.toolkit.wbp-palette.xml"});
        }
        finally {
            myTestProject.dispose();
        }
    }

    @Test
    public void test_customPalette_project_descriptionFromProject() throws Exception {
        PaletteManagerTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "  // filler filler filler filler", "}"));
        PaletteManagerTest.setFileContentSrc("test/MyButton.wbp-component.xml", PaletteManagerTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <description>My description</description>", "</component>"));
        PaletteManagerTest.setFileContent("wbp-meta", "test.toolkit.wbp-palette.xml", PaletteManagerTest.getSourceDQ("<palette>", "  <category id='categoryId.1' name='name 1'>", "    <component class='test.MyButton'/>", "  </category>", "</palette>"));
        PaletteManagerTest.waitForAutoBuild();
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = (CategoryInfo)palette.getCategories().get(0);
        ComponentEntryInfo component = (ComponentEntryInfo)category.getEntries().get(0);
        PaletteManagerTest.assertEquals((Object)"test.MyButton", (Object)component.getClassName());
        PaletteManagerTest.assertEquals((Object)"categoryId.1 test.MyButton", (Object)component.getId());
        PaletteManagerTest.assertTrue((boolean)component.isVisible());
        PaletteManagerTest.assertTrue((boolean)component.initialize(null, this.m_lastParseInfo));
        PaletteManagerTest.assertEquals((Object)"MyButton", (Object)component.getName());
        PaletteManagerTest.assertEquals((Object)"My description", (Object)component.getDescription());
    }

    @Test
    public void test_customPalette_project_staticFactory() throws Exception {
        PaletteManagerTest.setFileContentSrc("test/MyFactory.java", this.getTestSource("public class MyFactory {", "  public static JButton createFirst() {", "    return new JButton();", "  }", "  public static JButton createSecond() {", "    return new JButton();", "  }", "}"));
        PaletteManagerTest.setFileContent("wbp-meta", "test.toolkit.wbp-palette.xml", PaletteManagerTest.getSourceDQ("<palette>", "  <category id='categoryId.1' name='name 1' description='desc 1'>", "    <static-factory class='test.MyFactory'>", "      <method signature='createFirst()'/>", "      <method signature='createSecond()' name='Some name' description='Some description'/>", "    </static-factory>", "  </category>", "</palette>"));
        PaletteManagerTest.waitForAutoBuild();
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = (CategoryInfo)palette.getCategories().get(0);
        Assertions.assertThat((List)category.getEntries()).hasSize(2);
        StaticFactoryEntryInfo entry = (StaticFactoryEntryInfo)category.getEntries().get(0);
        PaletteManagerTest.assertTrue((boolean)entry.initialize(null, this.m_lastParseInfo));
        PaletteManagerTest.assertEquals((Object)"test.MyFactory", (Object)entry.getFactoryClassName());
        PaletteManagerTest.assertEquals((Object)"categoryId.1 test.MyFactory createFirst()", (Object)entry.getId());
        PaletteManagerTest.assertEquals((Object)"createFirst()", (Object)entry.getMethodSignature());
        PaletteManagerTest.assertEquals((Object)"createFirst()", (Object)entry.getName());
        PaletteManagerTest.assertEquals((Object)"Class: test.MyFactory<br/>Method: createFirst()", (Object)entry.getDescription());
        entry = (StaticFactoryEntryInfo)category.getEntries().get(1);
        PaletteManagerTest.assertTrue((boolean)entry.initialize(null, this.m_lastParseInfo));
        PaletteManagerTest.assertEquals((Object)"test.MyFactory", (Object)entry.getFactoryClassName());
        PaletteManagerTest.assertEquals((Object)"categoryId.1 test.MyFactory createSecond()", (Object)entry.getId());
        PaletteManagerTest.assertEquals((Object)"createSecond()", (Object)entry.getMethodSignature());
        PaletteManagerTest.assertEquals((Object)"Some name", (Object)entry.getName());
        PaletteManagerTest.assertEquals((Object)"Some description", (Object)entry.getDescription());
    }

    @Test
    public void test_customPalette_project_instanceFactory() throws Exception {
        PaletteManagerTest.setFileContentSrc("test/MyFactory.java", this.getTestSource("public class MyFactory {", "  public JButton createFirst() {", "    return new JButton();", "  }", "  public JButton createSecond() {", "    return new JButton();", "  }", "}"));
        PaletteManagerTest.setFileContent("wbp-meta", "test.toolkit.wbp-palette.xml", PaletteManagerTest.getSourceDQ("<palette>", "  <category id='categoryId.1' name='name 1' description='desc 1'>", "    <instance-factory class='test.MyFactory'>", "      <method signature='createFirst()'/>", "      <method signature='createSecond()' name='Some name' description='Some description'/>", "    </instance-factory>", "  </category>", "</palette>"));
        PaletteManagerTest.waitForAutoBuild();
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = (CategoryInfo)palette.getCategories().get(0);
        Assertions.assertThat((List)category.getEntries()).hasSize(2);
        InstanceFactoryEntryInfo entry = (InstanceFactoryEntryInfo)category.getEntries().get(0);
        PaletteManagerTest.assertTrue((boolean)entry.initialize(null, this.m_lastParseInfo));
        PaletteManagerTest.assertEquals((Object)"test.MyFactory", (Object)entry.getFactoryClassName());
        PaletteManagerTest.assertEquals((Object)"categoryId.1 test.MyFactory createFirst()", (Object)entry.getId());
        PaletteManagerTest.assertEquals((Object)"createFirst()", (Object)entry.getMethodSignature());
        PaletteManagerTest.assertEquals((Object)"createFirst()", (Object)entry.getName());
        PaletteManagerTest.assertEquals((Object)"Class: test.MyFactory<br/>Method: createFirst()", (Object)entry.getDescription());
        entry = (InstanceFactoryEntryInfo)category.getEntries().get(1);
        PaletteManagerTest.assertTrue((boolean)entry.initialize(null, this.m_lastParseInfo));
        PaletteManagerTest.assertEquals((Object)"test.MyFactory", (Object)entry.getFactoryClassName());
        PaletteManagerTest.assertEquals((Object)"categoryId.1 test.MyFactory createSecond()", (Object)entry.getId());
        PaletteManagerTest.assertEquals((Object)"createSecond()", (Object)entry.getMethodSignature());
        PaletteManagerTest.assertEquals((Object)"Some name", (Object)entry.getName());
        PaletteManagerTest.assertEquals((Object)"Some description", (Object)entry.getDescription());
    }

    @Test
    public void test_condition_true() throws Exception {
        PaletteManagerTest.addPaletteExtension(new String[]{"<category id='category' name='category'>", "  <component class='javax.swing.JButton' condition='version > 3.0'/>", "</category>"});
        JavaInfo panel = this.parseEmptyPanel();
        this.m_lastState.addVersions(Map.of("version", "3.5"));
        PaletteInfo palette = this.loadPalette(panel);
        PaletteManagerTest.assertNoErrors(panel);
        CategoryInfo category = palette.getCategory("category");
        Assertions.assertThat((List)category.getEntries()).hasSize(1);
    }

    @Test
    public void test_condition_false() throws Exception {
        PaletteManagerTest.addPaletteExtension(new String[]{"<category id='category' name='category'>", "  <component class='javax.swing.JButton' condition='version > 3.0'/>", "</category>"});
        JavaInfo panel = this.parseEmptyPanel();
        this.m_lastState.addVersions(Map.of("version", "2.1"));
        PaletteInfo palette = this.loadPalette(panel);
        PaletteManagerTest.assertNoErrors(panel);
        CategoryInfo category = palette.getCategory("category");
        Assertions.assertThat((List)category.getEntries()).isEmpty();
    }

    @Test
    public void test_condition_notBoolean() throws Exception {
        PaletteManagerTest.addPaletteExtension(new String[]{"<category id='category' name='category'>", "  <component class='javax.swing.JButton' condition='42'/>", "</category>"});
        JavaInfo panel = this.parseEmptyPanel();
        this.m_lastState.addVersions(Map.of("version", "2.1"));
        PaletteInfo palette = this.loadPalette(panel);
        PaletteManagerTest.assertNoErrors(panel);
        CategoryInfo category = palette.getCategory("category");
        Assertions.assertThat((List)category.getEntries()).isEmpty();
    }

    @Test
    public void test_condition_useRootModel() throws Exception {
        PaletteManagerTest.addPaletteExtension(new String[]{"<category id='category' name='category'>", "  <component class='javax.swing.JButton' condition='rootModel.getObject() is javax.swing.JPanel'/>", "</category>"});
        JavaInfo panel = this.parseEmptyPanel();
        this.refresh();
        PaletteInfo palette = this.loadPalette(panel);
        PaletteManagerTest.assertNoErrors(panel);
        CategoryInfo category = palette.getCategory("category");
        Assertions.assertThat((List)category.getEntries()).hasSize(1);
    }

    @Test
    public void test_condition_invalid() throws Exception {
        PaletteManagerTest.addPaletteExtension(new String[]{"<category id='category' name='category'>", "  <component class='javax.swing.JButton' condition='!@#$%'/>", "</category>"});
        JavaInfo panel = this.parseEmptyPanel();
        DesignerPlugin.setDisplayExceptionOnConsole((boolean)false);
        try {
            PaletteInfo palette = this.loadPalette(panel);
            CategoryInfo category = palette.getCategory("category");
            Assertions.assertThat((List)category.getEntries()).isEmpty();
        }
        finally {
            DesignerPlugin.setDisplayExceptionOnConsole((boolean)true);
        }
    }

    @Test
    public void test_categoryCondition_true() throws Exception {
        PaletteManagerTest.addPaletteExtension(new String[]{"<category id='category' name='category' condition='true'/>"});
        JavaInfo panel = this.parseEmptyPanel();
        PaletteInfo palette = this.loadPalette(panel);
        PaletteManagerTest.assertNoErrors(panel);
        Assertions.assertThat((List)palette.getCategories()).hasSize(1);
    }

    @Test
    public void test_categoryCondition_false() throws Exception {
        PaletteManagerTest.addPaletteExtension(new String[]{"<category id='category' name='category' condition='false'/>"});
        JavaInfo panel = this.parseEmptyPanel();
        PaletteInfo palette = this.loadPalette(panel);
        PaletteManagerTest.assertNoErrors(panel);
        Assertions.assertThat((List)palette.getCategories()).isEmpty();
    }

    @Test
    public void test_paletteCondition_true() throws Exception {
        PaletteManagerTest.addToolkitExtension("testPaletteId", new String[]{"<palette condition='true'>", "  <category id='theID' name='category'/>", "</palette>"});
        JavaInfo panel = this.parseEmptyPanel();
        PaletteInfo palette = this.loadPalette(panel);
        PaletteManagerTest.assertNoErrors(panel);
        Assertions.assertThat((List)palette.getCategories()).hasSize(1);
    }

    @Test
    public void test_paletteCondition_false() throws Exception {
        PaletteManagerTest.addToolkitExtension("testPaletteId", new String[]{"<palette condition='false'>", "  <category id='theID' name='category'/>", "</palette>"});
        JavaInfo panel = this.parseEmptyPanel();
        PaletteInfo palette = this.loadPalette(panel);
        PaletteManagerTest.assertNoErrors(panel);
        Assertions.assertThat((List)palette.getCategories()).isEmpty();
    }
}

