/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.nls;

import java.util.List;
import javax.swing.JFrame;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.nls.NlsSupport;
import org.eclipse.wb.internal.core.nls.SourceDescription;
import org.eclipse.wb.internal.core.nls.bundle.pure.field.FieldSource;
import org.eclipse.wb.internal.core.nls.bundle.pure.field.FieldSourceNewComposite;
import org.eclipse.wb.internal.core.nls.bundle.pure.field.SourceParameters;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.edit.IEditableSupport;
import org.eclipse.wb.internal.core.nls.edit.StringPropertyInfo;
import org.eclipse.wb.internal.core.nls.model.AbstractSource;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.nls.AbstractNlsTest;
import org.eclipse.wb.tests.designer.core.nls.NlsTestUtils;
import org.junit.jupiter.api.Test;

public class SourceFieldTest
extends AbstractNlsTest {
    @Test
    public void test_notDirectCases_1() throws Exception {
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle('title');", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        SourceFieldTest.assertEquals((int)0, (int)support.getSources().length);
    }

    @Test
    public void test_notDirectCases_2() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo frame = this.parseContainer("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "    ResourceBundle bundle;", "    bundle = ResourceBundle.getBundle('test.messages');", "    setTitle(bundle.getString('frame.title'));", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        SourceFieldTest.assertEquals((int)0, (int)support.getSources().length);
    }

    @Test
    public void test_notDirectCases_3() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo frame = this.parseContainer("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  ResourceBundle m_bundle = new java.util.PropertyResourceBundle((java.io.Reader)null);", "  public Test() throws Exception {", "    setTitle(m_bundle.getString('frame.title'));", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        SourceFieldTest.assertEquals((int)0, (int)support.getSources().length);
    }

    @Test
    public void test_notDirectCases_4() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo frame = this.parseContainer("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  ResourceBundle m_bundle = ResourceBundle.getBundle(null);", "  public Test() throws Exception {", "    setTitle(m_bundle.getString('frame.title'));", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        SourceFieldTest.assertEquals((int)0, (int)support.getSources().length);
    }

    @Test
    public void test_parse() throws Exception {
        SourceFieldTest.setFileContentSrc("test/messages.properties", SourceFieldTest.getSourceDQ("frame.title=My JFrame", "frame.name=My name"));
        SourceFieldTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public Test() {", "    setTitle(m_bundle.getString('frame.title')); //$NON-NLS-1$", "    setName(m_bundle.getString('frame.name')); //$NON-NLS-1$", "  }", "}");
        SourceFieldTest.assertNoErrors((JavaInfo)frame);
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        AbstractSource[] sources = support.getSources();
        SourceFieldTest.assertEquals((int)1, (int)sources.length);
        FieldSource source = (FieldSource)sources[0];
        SourceFieldTest.assertEquals((Object)"Field ResourceBundle: m_bundle", (Object)ReflectionUtils.invokeMethod((Object)source, (String)"getBundleComment()", (Object[])new Object[0]));
        frame.refresh();
        try {
            JFrame jFrame = (JFrame)frame.getObject();
            SourceFieldTest.assertEquals((Object)"My JFrame", (Object)jFrame.getTitle());
            SourceFieldTest.assertEquals((Object)"My name", (Object)jFrame.getName());
        }
        finally {
            frame.refresh_dispose();
        }
    }

    @Test
    public void test_useSpecificCreation_butWithWbpTag() throws Exception {
        SourceFieldTest.setFileContentSrc("test/messages.properties", SourceFieldTest.getSourceDQ("frame.title=My JFrame", "frame.name=My name"));
        SourceFieldTest.setFileContentSrc("test/MyResourceBundleFactory.java", SourceFieldTest.getSourceDQ("package test;", "import java.util.ResourceBundle;", "public class MyResourceBundleFactory {", "  public static ResourceBundle getMainBundle() {", "    return ResourceBundle.getBundle('test.messages');", "  }", "}"));
        SourceFieldTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  /**", "  * @wbp.nls.resourceBundle test.messages", "  */", "  private static final ResourceBundle m_bundle = MyResourceBundleFactory.getMainBundle();", "  public Test() {", "    setTitle(m_bundle.getString('frame.title')); //$NON-NLS-1$", "  }", "}");
        frame.refresh();
        SourceFieldTest.assertNoErrors((JavaInfo)frame);
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        Object[] sources = support.getSources();
        Assertions.assertThat((Object[])sources).hasSize(1);
        FieldSource source = (FieldSource)sources[0];
        SourceFieldTest.assertNotNull((Object)source);
        JFrame jFrame = (JFrame)frame.getObject();
        SourceFieldTest.assertEquals((Object)"My JFrame", (Object)jFrame.getTitle());
    }

    @Test
    public void test_parse_getWithLocale() throws Exception {
        SourceFieldTest.setFileContentSrc("test/messages.properties", SourceFieldTest.getSourceDQ("frame.title=My JFrame"));
        SourceFieldTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("import java.util.ResourceBundle;", "import java.util.Locale;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages', Locale.getDefault()); //$NON-NLS-1$", "  public Test() {", "    setTitle(m_bundle.getString('frame.title')); //$NON-NLS-1$", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        AbstractSource[] sources = support.getSources();
        SourceFieldTest.assertEquals((int)1, (int)sources.length);
        SourceFieldTest.assertInstanceOf(FieldSource.class, (Object)sources[0]);
        frame.refresh();
        try {
            JFrame jFrame = (JFrame)frame.getObject();
            SourceFieldTest.assertEquals((Object)"My JFrame", (Object)jFrame.getTitle());
        }
        finally {
            frame.refresh_dispose();
        }
    }

    @Test
    public void test_setValue() throws Exception {
        SourceFieldTest.setFileContentSrc("test/messages.properties", SourceFieldTest.getSourceDQ("frame.title=My JFrame", "frame.name=My name"));
        SourceFieldTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public Test() {", "    setTitle(m_bundle.getString('frame.title')); //$NON-NLS-1$", "  }", "}");
        AbstractSource.setLocaleInfo((JavaInfo)frame, (LocaleInfo)LocaleInfo.DEFAULT);
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        GenericProperty titleProperty = (GenericProperty)frame.getPropertyByTitle("title");
        support.setValue(titleProperty.getExpression(), "New title");
        String newProperties = SourceFieldTest.getFileContentSrc("test/messages.properties");
        SourceFieldTest.assertTrue((boolean)newProperties.contains("#Field ResourceBundle: m_bundle"));
        SourceFieldTest.assertTrue((boolean)newProperties.contains("frame.title=New title"));
    }

    @Test
    public void test_setValue2() throws Exception {
        SourceFieldTest.setFileContentSrc("test/messages.properties", SourceFieldTest.getSourceDQ("frame.title=My JFrame", "frame.name=My name"));
        SourceFieldTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public Test() {", "    setTitle(m_bundle.getString('frame.title')); //$NON-NLS-1$", "  }", "}");
        AbstractSource.setLocaleInfo((JavaInfo)frame, (LocaleInfo)LocaleInfo.DEFAULT);
        Property titleProperty = frame.getPropertyByTitle("title");
        titleProperty.setValue((Object)"New title");
        String newProperties = SourceFieldTest.getFileContentSrc("test/messages.properties");
        SourceFieldTest.assertTrue((boolean)newProperties.contains("#Field ResourceBundle: m_bundle"));
        SourceFieldTest.assertTrue((boolean)newProperties.contains("frame.title=New title"));
    }

    @Test
    public void test_possibleSources() throws Exception {
        SourceFieldTest.setFileContentSrc("test/not-a-properties.text", "");
        SourceFieldTest.setFileContentSrc("test/messages2.properties", SourceFieldTest.getSourceDQ("#Invalid comment for Direct ResourceBundle"));
        SourceFieldTest.setFileContentSrc("test/messages.properties", SourceFieldTest.getSourceDQ("#Field ResourceBundle: m_bundle"));
        SourceFieldTest.setFileContentSrc("test/messages_it.properties", SourceFieldTest.getSourceDQ("#We need only default *.properties file"));
        SourceFieldTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle('My JFrame');", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        List editableSources = editableSupport.getEditableSources();
        SourceFieldTest.assertEquals((int)1, (int)editableSources.size());
        IEditableSource editableSource = (IEditableSource)editableSources.get(0);
        SourceFieldTest.assertEquals((Object)"test.messages (ResourceBundle in field 'm_bundle')", (Object)editableSource.getLongTitle());
        StringPropertyInfo propertyInfo = (StringPropertyInfo)editableSupport.getProperties((JavaInfo)frame).get(0);
        editableSupport.externalizeProperty(propertyInfo, editableSource, true);
        support.applyEditable(editableSupport);
        this.assertEditor("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public Test() {", "    setTitle(m_bundle.getString('Test.this.title')); //$NON-NLS-1$", "  }", "}");
        String newProperties = SourceFieldTest.getFileContentSrc("test/messages.properties");
        SourceFieldTest.assertTrue((boolean)newProperties.contains("#Field ResourceBundle: m_bundle"));
        SourceFieldTest.assertTrue((boolean)newProperties.contains("Test.this.title=My JFrame"));
        newProperties = SourceFieldTest.getFileContentSrc("test/messages_it.properties");
        SourceFieldTest.assertTrue((boolean)newProperties.contains("#Field ResourceBundle: m_bundle"));
        SourceFieldTest.assertTrue((boolean)newProperties.contains("Test.this.title=My JFrame"));
    }

    @Test
    public void test_renameKey() throws Exception {
        SourceFieldTest.setFileContentSrc("test/messages.properties", SourceFieldTest.getSourceDQ("frame.title=My JFrame"));
        SourceFieldTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public Test() {", "    setTitle(m_bundle.getString('frame.title')); //$NON-NLS-1$", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        IEditableSource editableSource = (IEditableSource)editableSupport.getEditableSources().get(0);
        editableSource.renameKey("frame.title", "frame.title2");
        support.applyEditable(editableSupport);
        this.assertEditor("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public Test() {", "    setTitle(m_bundle.getString('frame.title2')); //$NON-NLS-1$", "  }", "}");
        String newProperties = SourceFieldTest.getFileContentSrc("test/messages.properties");
        SourceFieldTest.assertFalse((boolean)newProperties.contains("frame.title=My JFrame"));
        SourceFieldTest.assertTrue((boolean)newProperties.contains("frame.title2=My JFrame"));
    }

    @Test
    public void test_internalize() throws Exception {
        SourceFieldTest.setFileContentSrc("test/messages.properties", SourceFieldTest.getSourceDQ("frame.title=My JFrame"));
        SourceFieldTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public Test() {", "    setTitle(m_bundle.getString('frame.title')); //$NON-NLS-1$", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        IEditableSource editableSource = (IEditableSource)editableSupport.getEditableSources().get(0);
        editableSource.internalizeKey("frame.title");
        support.applyEditable(editableSupport);
        this.assertEditor("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public Test() {", "    setTitle('My JFrame');", "  }", "}");
        String newProperties = SourceFieldTest.getFileContentSrc("test/messages.properties");
        SourceFieldTest.assertFalse((boolean)newProperties.contains("frame.title=My JFrame"));
    }

    @Test
    public void test_create() throws Exception {
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle('My JFrame');", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        IEditableSource editableSource = NlsTestUtils.createEmptyEditable("test.messages");
        SourceParameters parameters = new SourceParameters();
        IJavaProject javaProject = this.m_lastEditor.getJavaProject();
        parameters.m_propertySourceFolder = javaProject.findPackageFragmentRoot((IPath)new Path("/TestProject/src"));
        parameters.m_propertyPackage = javaProject.findPackageFragment((IPath)new Path("/TestProject/src/test"));
        parameters.m_propertyFileName = "messages.properties";
        parameters.m_propertyBundleName = "test.messages";
        parameters.m_propertyFileExists = false;
        parameters.m_fieldName = "m_bundle";
        editableSupport.addSource(editableSource, new SourceDescription(FieldSource.class, FieldSourceNewComposite.class), (Object)parameters);
        StringPropertyInfo propertyInfo = (StringPropertyInfo)editableSupport.getProperties((JavaInfo)frame).get(0);
        editableSupport.externalizeProperty(propertyInfo, editableSource, true);
        support.applyEditable(editableSupport);
        this.assertEditor("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public Test() {", "    setTitle(m_bundle.getString('Test.this.title')); //$NON-NLS-1$", "  }", "}");
        String newProperties = SourceFieldTest.getFileContentSrc("test/messages.properties");
        SourceFieldTest.assertTrue((boolean)newProperties.contains("#Field ResourceBundle: m_bundle"));
        SourceFieldTest.assertTrue((boolean)newProperties.contains("Test.this.title=My JFrame"));
    }
}

