/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.parser;

import javax.swing.JTextField;
import org.eclipse.wb.core.model.IJavaInfoInitializationParticipator;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.model.ObjectInfoVisitor;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class ParserBroadcastsTest
extends SwingModelTest {
    private static final String POINT_ID = "org.eclipse.wb.core.java.javaInfoInitializationParticipators";

    @Test
    public void test_noExternalListener() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    Component notBoundComponentObject = new JTextField();", "    add(new JButton());", "  }", "}");
        panel.refresh();
        ParserBroadcastsTest.assertEquals((int)0, (int)MyParticipator.m_refreshCount);
    }

    @Test
    public void test_extraListenersEvicted() throws Exception {
        ParserBroadcastsTest.addParticipatorExtension(MyParticipator.class.getName());
        try {
            ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    Component notBoundComponentObject = new JTextField();", "    add(new JButton());", "  }", "}");
            panel.accept(new ObjectInfoVisitor(){

                public void endVisit(ObjectInfo objectInfo) throws Exception {
                    if (objectInfo instanceof JavaInfo) {
                        JavaInfo javaInfo = (JavaInfo)objectInfo;
                        ParserBroadcastsTest.assertNotSame(JTextField.class, (Object)javaInfo.getDescription().getComponentClass());
                    }
                }
            });
            ParserBroadcastsTest.assertEquals((int)0, (int)MyParticipator.m_refreshCount);
            panel.refresh();
            ParserBroadcastsTest.assertEquals((int)1, (int)MyParticipator.m_refreshCount);
        }
        finally {
            ParserBroadcastsTest.removeParticipatorExtension();
            MyParticipator.m_refreshCount = 0;
        }
    }

    private static void addParticipatorExtension(String className) throws Exception {
        String contribution = "  <participator class='" + className + "'/>";
        TestUtils.addDynamicExtension(POINT_ID, contribution);
    }

    private static void removeParticipatorExtension() throws Exception {
        TestUtils.removeDynamicExtension(POINT_ID);
    }

    public static final class MyParticipator
    implements IJavaInfoInitializationParticipator {
        private static int m_refreshCount;

        public void process(final JavaInfo javaInfo) throws Exception {
            javaInfo.addBroadcastListener((Object)new ObjectEventListener(){

                public void refreshed() throws Exception {
                    if (javaInfo.isRoot()) {
                        ++m_refreshCount;
                    }
                }
            });
        }
    }
}

