/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.eval.other;

import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.tests.designer.core.eval.AbstractEngineTest;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FieldTest
extends AbstractEngineTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject == null) {
            FieldTest.do_projectCreate();
        }
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_beanFieldValue() throws Exception {
        FieldTest.setFileContentSrc("test/TestBean.java", FieldTest.getSourceDQ("package test;", "class TestBean {", "  public int value = 5;", "}"));
        FieldTest.waitForAutoBuild();
        FieldTest.assertEquals((Object)5, (Object)this.evaluateExpression("new TestBean().value", "int"));
    }

    @Test
    public void test_localFieldValue_thisQualifier() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tprivate int value = 5;\n\tint foo() {\n\t\treturn this.value;\n\t}\n}");
        FieldTest.assertEquals((Object)5, (Object)this.evaluateSingleMethod(typeDeclaration, "foo()"));
    }

    @Test
    public void test_localFieldValue_defaultValue_false() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tprivate boolean value;\n\tboolean foo() {\n\t\treturn this.value;\n\t}\n}");
        FieldTest.assertEquals((Object)false, (Object)this.evaluateSingleMethod(typeDeclaration, "foo()"));
    }

    @Test
    public void test_localFieldValue_defaultValue_zero() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tprivate int value;\n\tint foo() {\n\t\treturn this.value;\n\t}\n}");
        FieldTest.assertEquals((Object)0, (Object)this.evaluateSingleMethod(typeDeclaration, "foo()"));
    }

    @Test
    public void test_localFieldValue_defaultValue_null() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tprivate Object value;\n\tObject foo() {\n\t\treturn this.value;\n\t}\n}");
        FieldTest.assertEquals(null, (Object)this.evaluateSingleMethod(typeDeclaration, "foo()"));
    }

    @Test
    public void test_localFieldValue_noQualifier() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tprivate int value = 5;\n\tint foo() {\n\t\treturn value;\n\t}\n}");
        FieldTest.assertEquals((Object)5, (Object)this.evaluateSingleMethod(typeDeclaration, "foo()"));
    }
}

