/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core;

import java.io.InputStream;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.BundleResourceProvider;
import org.eclipse.wb.internal.core.utils.check.AssertionFailedException;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.core.TestBundle;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.jupiter.api.Test;
import org.osgi.framework.Bundle;

public class BundleResourceProviderTest
extends DesignerTestCase {
    private static final String BUNDLE_ID = "org.eclipse.wb.core";

    @Test
    public void test_noSuchBundle() throws Exception {
        try {
            BundleResourceProvider.get((String)"no.such.bundle");
            BundleResourceProviderTest.fail();
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
    }

    @Test
    public void test_instanceBundle() throws Exception {
        Bundle bundle = Platform.getBundle((String)BUNDLE_ID);
        BundleResourceProvider.get((Bundle)bundle);
    }

    @Test
    public void test_getFile() throws Exception {
        BundleResourceProvider provider = BundleResourceProvider.get((String)BUNDLE_ID);
        try {
            provider.getFile("noSuchFile.txt");
        }
        catch (Throwable e) {
            ((AbstractStringAssert)Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{BUNDLE_ID})).contains(new CharSequence[]{"noSuchFile.txt"});
        }
        BundleResourceProviderTest.assertGoodFile(provider, "plugin.xml");
        BundleResourceProviderTest.assertGoodFile(provider, "icons/test.png");
        BundleResourceProviderTest.assertGoodFile(provider, "/icons/test.png");
        BundleResourceProviderTest.assertGoodFile(provider, "icons//test.png");
        BundleResourceProviderTest.assertGoodFile(provider, "//icons/test.png");
        BundleResourceProviderTest.assertGoodFile(provider, "//icons//test.png");
    }

    @Test
    public void test_getFileString() throws Exception {
        BundleResourceProvider provider = BundleResourceProvider.get((String)BUNDLE_ID);
        try {
            provider.getFile("noSuchFile.txt");
        }
        catch (Throwable e) {
            ((AbstractStringAssert)Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{BUNDLE_ID})).contains(new CharSequence[]{"noSuchFile.txt"});
        }
        String content = provider.getFileString("plugin.xml");
        Assertions.assertThat((String)content).contains(new CharSequence[]{"<!-- Extension points -->"});
    }

    private static void assertGoodFile(BundleResourceProvider provider, String path) throws Exception {
        InputStream stream = provider.getFile(path);
        BundleResourceProviderTest.assertNotNull((Object)stream);
        stream.close();
    }

    @Test
    public void test_getImage() throws Exception {
        BundleResourceProvider provider = BundleResourceProvider.get((String)BUNDLE_ID);
        try {
            provider.getImage("noSuchImage.png");
        }
        catch (Throwable e) {
            ((AbstractStringAssert)Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{BUNDLE_ID})).contains(new CharSequence[]{"noSuchImage.png"});
        }
        Image image = provider.getImage("icons/test.png");
        BundleResourceProviderTest.assertNotNull((Object)image);
        BundleResourceProviderTest.assertSame((Object)image, (Object)provider.getImage("icons/test.png"));
        BundleResourceProviderTest.assertSame((Object)image, (Object)provider.getImage("/icons/test.png"));
    }

    @Test
    public void test_getImage_disposeWhenUninstall() throws Exception {
        Image image;
        TestBundle testBundle = new TestBundle();
        try {
            testBundle.setFile("icons/test.png", TestUtils.createImagePNG(1, 1));
            testBundle.install();
            BundleResourceProvider provider = BundleResourceProvider.get((String)testBundle.getId());
            image = provider.getImage("icons/test.png");
            BundleResourceProviderTest.assertNotNull((Object)image);
            BundleResourceProviderTest.assertFalse((boolean)image.isDisposed());
        }
        finally {
            testBundle.dispose();
        }
        BundleResourceProviderTest.waitEventLoop(0);
        BundleResourceProviderTest.assertTrue((boolean)image.isDisposed());
    }

    @Test
    public void test_getImageDescriptor() throws Exception {
        BundleResourceProvider provider = BundleResourceProvider.get((String)BUNDLE_ID);
        try {
            provider.getImageDescriptor("noSuchImage.png");
        }
        catch (Throwable e) {
            ((AbstractStringAssert)Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{BUNDLE_ID})).contains(new CharSequence[]{"noSuchImage.png"});
        }
        ImageDescriptor descriptor = provider.getImageDescriptor("icons/test.png");
        BundleResourceProviderTest.assertNotNull((Object)descriptor);
        BundleResourceProviderTest.assertSame((Object)descriptor, (Object)provider.getImageDescriptor("icons/test.png"));
        BundleResourceProviderTest.assertSame((Object)descriptor, (Object)provider.getImageDescriptor("/icons/test.png"));
    }
}

