/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.FormLayout;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.lang.reflect.Method;
import org.eclipse.wb.internal.swing.FormLayout.model.FormColumnInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormDimensionInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormDimensionTemplate;
import org.eclipse.wb.internal.swing.FormLayout.model.FormRowInfo;
import org.eclipse.wb.tests.designer.Expectations;
import org.eclipse.wb.tests.designer.swing.model.layout.FormLayout.AbstractFormLayoutTest;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class FormDimensionInfoTest
extends AbstractFormLayoutTest {
    @Test
    public void test_accessors() throws Exception {
        FormColumnInfo column = new FormColumnInfo(FormSpecs.DEFAULT_COLSPEC);
        FormDimensionInfoTest.assertEquals((Object)"default", (Object)column.getDisplayString());
        FormDimensionInfoTest.assertSame((Object)Sizes.DEFAULT, (Object)column.getSize().getSize());
        FormDimensionInfoTest.assertSame((Object)ColumnSpec.DEFAULT, (Object)column.getAlignment());
        FormDimensionInfoTest.assertEquals((double)0.0, (double)column.getWeight(), (double)0.001);
        FormDimensionInfoTest.assertFalse((boolean)column.hasGrow());
        column.setAlignment(ColumnSpec.LEFT);
        column.setWeight(0.2);
        FormDimensionInfoTest.assertEquals((Object)"left:default:grow(0.2)", (Object)column.getDisplayString());
        FormDimensionInfoTest.assertTrue((boolean)column.hasGrow());
    }

    @Test
    public void test_equals2() throws Exception {
        FormColumnInfo column = new FormColumnInfo(FormSpecs.DEFAULT_COLSPEC);
        FormColumnInfo column2 = new FormColumnInfo(FormSpecs.DEFAULT_COLSPEC);
        FormColumnInfo column3 = new FormColumnInfo(FormSpecs.PREF_COLSPEC);
        FormDimensionInfoTest.assertTrue((boolean)column.equals2((Object)column2));
        FormDimensionInfoTest.assertFalse((boolean)column.equals2((Object)column3));
    }

    @Test
    public void test_assign() throws Exception {
        FormColumnInfo target = new FormColumnInfo(FormSpecs.DEFAULT_COLSPEC);
        FormColumnInfo source = new FormColumnInfo(FormSpecs.GROWING_BUTTON_COLSPEC);
        FormDimensionInfoTest.assertEquals((Object)"default", (Object)target.getDisplayString());
        FormDimensionInfoTest.assertEquals((Object)"50dlu<preferred:grow", (Object)source.getDisplayString());
        target.assign((FormDimensionInfo)source);
        FormDimensionInfoTest.assertEquals((Object)"50dlu<preferred:grow", (Object)target.getDisplayString());
    }

    @Test
    public void test_FormDimensionInfo_sourceParseEncode() throws Exception {
        this.check_FormDimensionInfo_sourceParse("70dlu", "70dlu");
        this.check_FormDimensionInfo_sourceParse("70dlu:grow", "70dlu:grow");
        this.check_FormDimensionInfo_sourceParse("left:70dlu:grow", "left:70dlu:grow");
        this.check_FormDimensionInfo_sourceParse("right:70dlu", "right:70dlu");
        this.check_FormDimensionInfo_sourceParse("70dlu:none", "70dlu");
        this.check_FormDimensionInfo_sourceParse("70dlu:g(0.5)", "70dlu:grow(0.5)");
    }

    private void check_FormDimensionInfo_sourceParse(String toParse, String expected) throws Exception {
        FormColumnInfo column = new FormColumnInfo(ColumnSpec.decode((String)toParse));
        FormDimensionInfoTest.assertEquals((Object)("com.jgoodies.forms.layout.ColumnSpec.decode(\"" + expected + "\")"), (Object)column.getSource());
        FormDimensionInfoTest.assertEquals((Object)expected, (Object)column.getDisplayString());
        FormDimensionInfoTest.assertEquals((Object)column.getDisplayString(), (Object)column.toString());
    }

    @Test
    public void test_source_row() throws Exception {
        FormRowInfo row = new FormRowInfo(RowSpec.decode((String)"4cm"));
        FormDimensionInfoTest.assertEquals((Object)"com.jgoodies.forms.layout.RowSpec.decode(\"4cm\")", (Object)row.getSource());
    }

    @Test
    public void test_source_columnTemplate() throws Exception {
        FormColumnInfo column = new FormColumnInfo(FormSpecs.GLUE_COLSPEC);
        FormDimensionInfoTest.assertEquals((Object)"com.jgoodies.forms.layout.FormSpecs.GLUE_COLSPEC", (Object)column.getSource());
    }

    @Test
    public void test_sourceBounded_column() throws Exception {
        this.check_getAlignmentSource(true, ColumnSpec.LEFT, "com.jgoodies.forms.layout.ColumnSpec.LEFT");
        this.check_getAlignmentSource(true, ColumnSpec.CENTER, "com.jgoodies.forms.layout.ColumnSpec.CENTER");
        this.check_getAlignmentSource(true, ColumnSpec.RIGHT, "com.jgoodies.forms.layout.ColumnSpec.RIGHT");
        this.check_getAlignmentSource(true, ColumnSpec.FILL, "com.jgoodies.forms.layout.ColumnSpec.FILL");
    }

    @Test
    public void test_sourceBounded_row() throws Exception {
        this.check_getAlignmentSource(false, RowSpec.TOP, "com.jgoodies.forms.layout.RowSpec.TOP");
        this.check_getAlignmentSource(false, RowSpec.CENTER, "com.jgoodies.forms.layout.RowSpec.CENTER");
        this.check_getAlignmentSource(false, RowSpec.BOTTOM, "com.jgoodies.forms.layout.RowSpec.BOTTOM");
        this.check_getAlignmentSource(false, RowSpec.FILL, "com.jgoodies.forms.layout.RowSpec.FILL");
    }

    public void check_getAlignmentSource(boolean horizontal, FormSpec.DefaultAlignment alignment, String alignmentName) throws Exception {
        Method method = FormDimensionInfo.class.getDeclaredMethod("getAlignmentSource", Boolean.TYPE, FormSpec.DefaultAlignment.class);
        method.setAccessible(true);
        FormDimensionInfoTest.assertEquals((Object)alignmentName, (Object)method.invoke(null, horizontal, alignment));
    }

    @Test
    public void test_sourceBounded() throws Exception {
        Size size = Sizes.bounded((Size)Sizes.DEFAULT, (Size)Sizes.constant((String)"3cm", (boolean)true), (Size)Sizes.constant((String)"40mm", (boolean)true));
        FormColumnInfo column = new FormColumnInfo(new ColumnSpec(ColumnSpec.LEFT, size, 0.0));
        FormDimensionInfoTest.assertEquals((Object)"new com.jgoodies.forms.layout.ColumnSpec(com.jgoodies.forms.layout.ColumnSpec.LEFT, com.jgoodies.forms.layout.Sizes.bounded(com.jgoodies.forms.layout.Sizes.DEFAULT, com.jgoodies.forms.layout.Sizes.constant(\"3cm\", true), com.jgoodies.forms.layout.Sizes.constant(\"40mm\", true)), 0)", (Object)column.getSource());
    }

    @Test
    public void test_toolTip() throws Exception {
        FormDimensionInfoTest.assertEquals((Object)"default", (Object)new FormColumnInfo(FormSpecs.DEFAULT_COLSPEC).getToolTip());
        FormDimensionInfoTest.assertEquals((Object)"minimum", (Object)new FormColumnInfo(FormSpecs.MIN_COLSPEC).getToolTip());
        FormDimensionInfoTest.assertEquals((Object)"100dlu<preferred", (Object)new FormColumnInfo(ColumnSpec.decode((String)"max(100dlu;pref)")).getToolTip());
    }

    @Test
    public void test_copyColumn() throws Exception {
        FormColumnInfo column = new FormColumnInfo(ColumnSpec.decode((String)"min(100dlu;default)"));
        FormDimensionInfoTest.assertEquals((Object)"default<100dlu", (Object)column.copy().getToolTip());
    }

    @Test
    public void test_copyRow() throws Exception {
        FormRowInfo row = new FormRowInfo(RowSpec.decode((String)"min(100dlu;default)"));
        FormDimensionInfoTest.assertEquals((Object)"default<100dlu", (Object)row.copy().getToolTip());
    }

    @Test
    public void test_columnTemplates() throws Exception {
        FormColumnInfo column = new FormColumnInfo(FormSpecs.DEFAULT_COLSPEC);
        FormDimensionTemplate[] templates = column.getTemplates(true);
        FormDimensionInfoTest.assertEquals((int)5, (int)templates.length);
        FormDimensionInfoTest.assertTrue((boolean)column.isTemplate(templates[0]));
        FormDimensionTemplate template = templates[4];
        FormDimensionInfoTest.assertEquals((Object)"GROWING_BUTTON_COLSPEC", (Object)template.getFieldName());
        FormDimensionInfoTest.assertTrue((boolean)template.isComponent());
        FormDimensionInfoTest.assertEquals((Object)"growing button", (Object)template.getTitle());
        FormDimensionInfoTest.assertNotNull((Object)template.getIcon());
        templates = column.getTemplates(false);
        FormDimensionInfoTest.assertEquals((int)4, (int)templates.length);
        template = templates[3];
        FormDimensionInfoTest.assertEquals((Object)"LABEL_COMPONENT_GAP_COLSPEC", (Object)template.getFieldName());
        FormDimensionInfoTest.assertFalse((boolean)template.isComponent());
    }

    @Test
    public void test_columnTemplates2() throws Exception {
        FormColumnInfo column = new FormColumnInfo(FormSpecs.RELATED_GAP_COLSPEC);
        FormDimensionTemplate[] templates = column.getTemplates(true);
        FormDimensionInfoTest.assertEquals((int)4, (int)templates.length);
        FormDimensionTemplate template = templates[3];
        FormDimensionInfoTest.assertEquals((Object)"LABEL_COMPONENT_GAP_COLSPEC", (Object)template.getFieldName());
        FormDimensionInfoTest.assertFalse((boolean)template.isComponent());
        FormDimensionInfoTest.assertEquals((int)5, (int)column.getTemplates(false).length);
    }

    @Test
    public void test_columnTemplates_set() throws Exception {
        FormColumnInfo column = new FormColumnInfo(FormSpecs.DEFAULT_COLSPEC);
        FormDimensionInfoTest.assertEquals((Object)"default", (Object)column.getToolTip());
        column.setTemplate(column.getTemplates(true)[1]);
        FormDimensionInfoTest.assertEquals((Object)"preferred", (Object)column.getToolTip());
    }

    @Test
    public void test_rowTemplates() throws Exception {
        FormRowInfo row = new FormRowInfo(FormSpecs.DEFAULT_ROWSPEC);
        FormDimensionInfoTest.assertEquals((int)4, (int)row.getTemplates(true).length);
        FormDimensionInfoTest.assertEquals((int)6, (int)row.getTemplates(false).length);
    }

    @Disabled
    @Test
    public void test_convertToNearestGap_columns() throws Exception {
        this.check_convertToNearestGap_column("4px", 5, "LABEL_COMPONENT_GAP_COLSPEC");
        this.check_convertToNearestGap_column("3px", 0, null);
        this.check_convertToNearestGap_column("5px", 1, "LABEL_COMPONENT_GAP_COLSPEC");
        String desc = Expectations.get("8px", new Expectations.StrValue("kosta-home", "10px"), new Expectations.StrValue("scheglov-win", "8px"));
        this.check_convertToNearestGap_column(desc, 10, "RELATED_GAP_COLSPEC");
        this.check_convertToNearestGap_column("12px", 10, "UNRELATED_GAP_COLSPEC");
        this.check_convertToNearestGap_column("20px", 10, "UNRELATED_GAP_COLSPEC");
        this.check_convertToNearestGap_column("20px", 5, null);
    }

    @Disabled
    @Test
    public void test_convertToNearestGap_rows() throws Exception {
        this.check_convertToNearestGap_row("4px", 5, "LABEL_COMPONENT_GAP_ROWSPEC");
        this.check_convertToNearestGap_row("5px", 5, "LINE_GAP_ROWSPEC");
        this.check_convertToNearestGap_row("6px", 5, "RELATED_GAP_ROWSPEC");
    }

    private void check_convertToNearestGap_column(String desc, int maxDelta, String expectedTemplateField) throws Exception {
        FormColumnInfo dimension = new FormColumnInfo(ColumnSpec.decode((String)desc));
        this.check_convertToNearestGap((FormDimensionInfo)dimension, maxDelta, expectedTemplateField);
    }

    private void check_convertToNearestGap_row(String desc, int maxDelta, String expectedTemplateField) throws Exception {
        FormRowInfo dimension = new FormRowInfo(RowSpec.decode((String)desc));
        this.check_convertToNearestGap((FormDimensionInfo)dimension, maxDelta, expectedTemplateField);
    }

    private void check_convertToNearestGap(FormDimensionInfo dimension, int maxDelta, String expectedTemplateField) throws Exception {
        dimension.convertToNearestGap(maxDelta);
        FormDimensionTemplate template = dimension.getTemplate();
        if (expectedTemplateField == null) {
            FormDimensionInfoTest.assertNull((Object)template);
        } else {
            FormDimensionInfoTest.assertNotNull((Object)template);
            FormDimensionInfoTest.assertEquals((Object)expectedTemplateField, (Object)template.getFieldName());
        }
    }
}

