/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.databinding.rcp;

import java.util.List;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfo;
import org.eclipse.wb.internal.core.databinding.parser.AstModelSupport;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.tests.designer.core.AbstractJavaTest;
import org.eclipse.wb.tests.designer.databinding.rcp.UtilsTest;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class AstModelSupportTest
extends AbstractJavaTest {
    @BeforeAll
    public static void setUpClass() throws Exception {
        AstModelSupportTest.do_projectCreate();
    }

    @Test
    public void test_method() throws Exception {
        TypeDeclaration type = this.createTypeDeclaration_Test("public class Test {\n\tpublic void foo() {\n\t\tcreate(\"aaa\");\n\t\tString name = create(\"aaa\");\n\t\tfoo(name, create(\"aaa\"));\n\t}\n\tstatic String create(String value) {\n\t\treturn \"zzz: \" + value;\n\t}\n\tvoid foo(String name, String value) {\n\t}\n}");
        MethodDeclaration method = AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"foo()");
        AstModelSupportTest.assertNotNull((Object)method);
        List statements = method.getBody().statements();
        AstModelSupportTest.assertNotNull((Object)statements);
        AstModelSupportTest.assertEquals((int)3, (int)statements.size());
        MethodInvocation invocation0 = UtilsTest.getMethodInvocation(statements, 0);
        TestModel model = new TestModel();
        AstModelSupportTest.assertNull((Object)model.getVariableIdentifier());
        AstModelSupport support = new AstModelSupport((AstObjectInfo)model, (Expression)invocation0);
        AstModelSupportTest.assertNull((Object)model.getVariableIdentifier());
        AstModelSupportTest.assertSame((Object)((Object)model), (Object)support.getModel());
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)invocation0));
        MethodInvocation invocation2 = UtilsTest.getMethodInvocation(statements, 2);
        AstModelSupportTest.assertFalse((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation2).get(0)));
        AstModelSupportTest.assertFalse((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation2).get(1)));
    }

    @Test
    public void test_field_assignment_method() throws Exception {
        TypeDeclaration type = this.createTypeDeclaration_Test("public class Test {\n\tprivate String m_name;\n\t\tpublic void foo() {\n\t\tm_name = create(\"aaa\");\n\t\tString name = create(\"aaa\");\n\t\tfoo(name, m_name);\n\t}\n\tstatic String create(String value) {\n\t\treturn \"zzz: \" + value;\n\t}\n\tvoid foo(String name, String value) {\n\t}\n}");
        MethodDeclaration method = AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"foo()");
        AstModelSupportTest.assertNotNull((Object)method);
        List statements = method.getBody().statements();
        AstModelSupportTest.assertNotNull((Object)statements);
        AstModelSupportTest.assertEquals((int)3, (int)statements.size());
        Assignment assignment = UtilsTest.getAssignment(statements, 0);
        AstModelSupportTest.assertInstanceOf(MethodInvocation.class, (Object)assignment.getRightHandSide());
        TestModel model = new TestModel();
        AstModelSupportTest.assertNull((Object)model.getVariableIdentifier());
        AstModelSupport support = new AstModelSupport((AstObjectInfo)model, assignment.getRightHandSide());
        AstModelSupportTest.assertEquals((Object)"m_name", (Object)model.getVariableIdentifier());
        AstModelSupportTest.assertSame((Object)((Object)model), (Object)support.getModel());
        MethodInvocation invocation = UtilsTest.getMethodInvocation(statements, 2);
        AstModelSupportTest.assertFalse((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation).get(0)));
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation).get(1)));
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation).get(1)));
    }

    @Test
    public void test_local_variable_method() throws Exception {
        TypeDeclaration type = this.createTypeDeclaration_Test("public class Test {\n\tpublic void foo() {\n\t\tString name = create(\"aaa\");\n\t\tString name2 = create(\"aaa\");\n\t\tfoo(name, name2);\n\t}\n\tstatic String create(String value) {\n\t\treturn \"zzz: \" + value;\n\t}\n\tvoid foo(String name, String value) {\n\t}\n}");
        MethodDeclaration method = AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"foo()");
        AstModelSupportTest.assertNotNull((Object)method);
        List statements = method.getBody().statements();
        AstModelSupportTest.assertNotNull((Object)statements);
        AstModelSupportTest.assertEquals((int)3, (int)statements.size());
        VariableDeclarationStatement statement = (VariableDeclarationStatement)statements.get(0);
        TestModel model = new TestModel();
        AstModelSupportTest.assertNull((Object)model.getVariableIdentifier());
        AstModelSupport support = new AstModelSupport((AstObjectInfo)model, ((VariableDeclarationFragment)DomGenerics.fragments((VariableDeclarationStatement)statement).get(0)).getInitializer());
        AstModelSupportTest.assertEquals((Object)"name", (Object)model.getVariableIdentifier());
        AstModelSupportTest.assertSame((Object)((Object)model), (Object)support.getModel());
        MethodInvocation invocation2 = UtilsTest.getMethodInvocation(statements, 2);
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation2).get(0)));
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation2).get(0)));
        AstModelSupportTest.assertFalse((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation2).get(1)));
    }

    @Test
    public void test_local_variable_assignment_method() throws Exception {
        TypeDeclaration type = this.createTypeDeclaration_Test("public class Test {\n\tpublic void foo() {\n\t\tString name;\n\t\tString name2 = create(\"aaa\");\n\t\tname = create(\"aaa\");\n\t\tfoo(name, name2);\n\t}\n\tstatic String create(String value) {\n\t\treturn \"zzz: \" + value;\n\t}\n\tvoid foo(String name, String value) {\n\t}\n}");
        MethodDeclaration method = AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"foo()");
        AstModelSupportTest.assertNotNull((Object)method);
        List statements = method.getBody().statements();
        AstModelSupportTest.assertNotNull((Object)statements);
        AstModelSupportTest.assertEquals((int)4, (int)statements.size());
        Assignment statement2 = UtilsTest.getAssignment(statements, 2);
        TestModel model = new TestModel();
        AstModelSupportTest.assertNull((Object)model.getVariableIdentifier());
        AstModelSupport support = new AstModelSupport((AstObjectInfo)model, statement2.getRightHandSide());
        AstModelSupportTest.assertEquals((Object)"name", (Object)model.getVariableIdentifier());
        AstModelSupportTest.assertSame((Object)((Object)model), (Object)support.getModel());
        MethodInvocation invocation3 = UtilsTest.getMethodInvocation(statements, 3);
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation3).get(0)));
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation3).get(0)));
        AstModelSupportTest.assertFalse((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation3).get(1)));
    }

    @Test
    public void test_constructor() throws Exception {
        TypeDeclaration type = this.createTypeDeclaration_Test("public class Test {\n\tpublic void foo() {\n\t\tnew String(\"aaa\");\n\t\tString name = new String(\"aaa\");\n\t\tfoo(name, new String(\"aaa\"));\n\t}\n\tvoid foo(String name, String value) {\n\t}\n}");
        MethodDeclaration method = AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"foo()");
        AstModelSupportTest.assertNotNull((Object)method);
        List statements = method.getBody().statements();
        AstModelSupportTest.assertNotNull((Object)statements);
        AstModelSupportTest.assertEquals((int)3, (int)statements.size());
        ClassInstanceCreation creation0 = UtilsTest.getClassInstanceCreation(statements, 0);
        TestModel model = new TestModel();
        AstModelSupportTest.assertNull((Object)model.getVariableIdentifier());
        AstModelSupport support = new AstModelSupport((AstObjectInfo)model, (Expression)creation0);
        AstModelSupportTest.assertNull((Object)model.getVariableIdentifier());
        AstModelSupportTest.assertSame((Object)((Object)model), (Object)support.getModel());
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)creation0));
        MethodInvocation invocation2 = UtilsTest.getMethodInvocation(statements, 2);
        AstModelSupportTest.assertFalse((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation2).get(0)));
        AstModelSupportTest.assertFalse((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation2).get(1)));
    }

    @Test
    public void test_field_assignment_constructor() throws Exception {
        TypeDeclaration type = this.createTypeDeclaration_Test("public class Test {\n\tprivate String m_name;\n\tpublic void foo() {\n\t\tm_name = new String(\"aaa\");\n\t\tString name = new String(\"aaa\");\n\t\tfoo(name, m_name);\n\t}\n\tvoid foo(String name, String value) {\n\t}\n}");
        MethodDeclaration method = AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"foo()");
        AstModelSupportTest.assertNotNull((Object)method);
        List statements = method.getBody().statements();
        AstModelSupportTest.assertNotNull((Object)statements);
        AstModelSupportTest.assertEquals((int)3, (int)statements.size());
        Assignment assignment = UtilsTest.getAssignment(statements, 0);
        TestModel model = new TestModel();
        AstModelSupportTest.assertNull((Object)model.getVariableIdentifier());
        AstModelSupport support = new AstModelSupport((AstObjectInfo)model, assignment.getRightHandSide());
        AstModelSupportTest.assertEquals((Object)"m_name", (Object)model.getVariableIdentifier());
        AstModelSupportTest.assertSame((Object)((Object)model), (Object)support.getModel());
        MethodInvocation invocation = UtilsTest.getMethodInvocation(statements, 2);
        AstModelSupportTest.assertFalse((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation).get(0)));
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation).get(1)));
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation).get(1)));
    }

    @Test
    public void test_local_variable_constructor() throws Exception {
        TypeDeclaration type = this.createTypeDeclaration_Test("public class Test {\n\tpublic void foo() {\n\t\tString name = new String(\"aaa\");\n\t\tString name2 = new String(\"aaa\");\n\t\tfoo(name, name2);\n\t}\n\tvoid foo(String name, String value) {\n\t}\n}");
        MethodDeclaration method = AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"foo()");
        AstModelSupportTest.assertNotNull((Object)method);
        List statements = method.getBody().statements();
        AstModelSupportTest.assertNotNull((Object)statements);
        AstModelSupportTest.assertEquals((int)3, (int)statements.size());
        VariableDeclarationStatement statement = (VariableDeclarationStatement)statements.get(0);
        TestModel model = new TestModel();
        AstModelSupportTest.assertNull((Object)model.getVariableIdentifier());
        AstModelSupport support = new AstModelSupport((AstObjectInfo)model, ((VariableDeclarationFragment)DomGenerics.fragments((VariableDeclarationStatement)statement).get(0)).getInitializer());
        AstModelSupportTest.assertEquals((Object)"name", (Object)model.getVariableIdentifier());
        AstModelSupportTest.assertSame((Object)((Object)model), (Object)support.getModel());
        MethodInvocation invocation2 = UtilsTest.getMethodInvocation(statements, 2);
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation2).get(0)));
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation2).get(0)));
        AstModelSupportTest.assertFalse((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation2).get(1)));
    }

    @Test
    public void test_local_variable_assignment_constructor() throws Exception {
        TypeDeclaration type = this.createTypeDeclaration_Test("public class Test {\n\tpublic void foo() {\n\t\tString name;\n\t\tString name2 = new String(\"aaa\");\n\t\tname = new String(\"aaa\");\n\t\tfoo(name, name2);\n\t}\n\tvoid foo(String name, String value) {\n\t}\n}");
        MethodDeclaration method = AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"foo()");
        AstModelSupportTest.assertNotNull((Object)method);
        List statements = method.getBody().statements();
        AstModelSupportTest.assertNotNull((Object)statements);
        AstModelSupportTest.assertEquals((int)4, (int)statements.size());
        Assignment statement2 = UtilsTest.getAssignment(statements, 2);
        TestModel model = new TestModel();
        AstModelSupportTest.assertNull((Object)model.getVariableIdentifier());
        AstModelSupport support = new AstModelSupport((AstObjectInfo)model, statement2.getRightHandSide());
        AstModelSupportTest.assertEquals((Object)"name", (Object)model.getVariableIdentifier());
        AstModelSupportTest.assertSame((Object)((Object)model), (Object)support.getModel());
        MethodInvocation invocation3 = UtilsTest.getMethodInvocation(statements, 3);
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation3).get(0)));
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation3).get(0)));
        AstModelSupportTest.assertFalse((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation3).get(1)));
    }

    private static class TestModel
    extends AstObjectInfo {
        private TestModel() {
        }
    }
}

