/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.gef;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Tool;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.wb.gef.graphical.tools.SelectionTool;
import org.eclipse.wb.gef.tree.TreeEditPart;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.gef.RequestsLogger;
import org.eclipse.wb.tests.gef.TreeToolTest;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TreeDragToolTest
extends TreeToolTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.m_domain.setActiveTool((Tool)new SelectionTool());
    }

    @Test
    public void test_DoubleClick() throws Exception {
        RequestsLogger actualLogger = new RequestsLogger();
        TreeToolTest.ILayoutEditPolicy ipolicy = (request, editPart) -> true;
        TreeEditPart parent = this.addEditPart((EditPart)this.m_viewer.getRootEditPart(), "parent", actualLogger, ipolicy);
        TreeEditPart child1 = this.addEditPart((EditPart)parent, "child1", actualLogger, ipolicy);
        TreeDragToolTest.refreshTreeParst(parent);
        this.m_viewer.expandAll();
        Point location = TreeDragToolTest.getOnLocation(parent);
        this.m_sender.doubleClick(location.x, location.y, 3);
        actualLogger.assertEmpty();
        RequestsLogger expectedLogger = new RequestsLogger();
        this.m_sender.doubleClick(location.x, location.y, 1);
        expectedLogger.log((EditPart)parent, "performRequest[ SelectionRequest(type=open, location=Point(" + (double)location.x + ", " + (double)location.y + "), stateMask=0, button=0) ]");
        TreeDragToolTest.assertLoggers(expectedLogger, actualLogger);
        location = TreeDragToolTest.getOnLocation(child1);
        this.m_sender.doubleClick(location.x, location.y, 1);
        expectedLogger.log((EditPart)child1, "performRequest[ SelectionRequest(type=open, location=Point(" + (double)location.x + ", " + (double)location.y + "), stateMask=0, button=0) ]");
        TreeDragToolTest.assertLoggers(expectedLogger, actualLogger);
    }

    @Test
    public void test_Drag_1() throws Exception {
        RequestsLogger actualLogger = new RequestsLogger();
        TreeToolTest.ILayoutEditPolicy ipolicy = (request, editPart) -> true;
        TreeEditPart parent = this.addEditPart((EditPart)this.m_viewer.getRootEditPart(), "parent", actualLogger, ipolicy);
        TreeEditPart child1 = this.addEditPart((EditPart)parent, "child1", actualLogger, ipolicy);
        TreeEditPart child2 = this.addEditPart((EditPart)parent, "child2", actualLogger, ipolicy);
        TreeEditPart child3 = this.addEditPart((EditPart)parent, "child3", actualLogger, ipolicy);
        TreeDragToolTest.refreshTreeParst(parent);
        this.m_viewer.expandAll();
        this.m_viewer.select((EditPart)child3);
        DropTarget dropTarget = (DropTarget)this.m_viewer.getTree().getData("DropTarget");
        RequestsLogger expectedLogger = new RequestsLogger();
        Event event = this.createDNDEvent(child3, TreeDragToolTest.getOnLocation(child3));
        dropTarget.notifyListeners(2002, event);
        actualLogger.assertEmpty();
        event = this.createDNDEvent(child3, TreeDragToolTest.getAfterLocation(child2));
        dropTarget.notifyListeners(2004, event);
        expectedLogger.log((EditPart)parent, "getMoveCommand(parts=[child3], next=child3)");
        TreeDragToolTest.assertLoggers(expectedLogger, actualLogger);
        event = this.createDNDEvent(child3, TreeDragToolTest.getOnLocation(child2));
        dropTarget.notifyListeners(2004, event);
        expectedLogger.log((EditPart)child2, "getAddCommand(parts=[child3], next=null)");
        TreeDragToolTest.assertLoggers(expectedLogger, actualLogger);
        event = this.createDNDEvent(child3, TreeDragToolTest.getBeforeLocation(child2));
        dropTarget.notifyListeners(2004, event);
        expectedLogger.log((EditPart)parent, "getMoveCommand(parts=[child3], next=child2)");
        TreeDragToolTest.assertLoggers(expectedLogger, actualLogger);
        event = this.createDNDEvent(child3, TreeDragToolTest.getAfterLocation(child1));
        dropTarget.notifyListeners(2004, event);
        expectedLogger.log((EditPart)parent, "getMoveCommand(parts=[child3], next=child2)");
        TreeDragToolTest.assertLoggers(expectedLogger, actualLogger);
        event = this.createDNDEvent(child3, TreeDragToolTest.getOnLocation(child1));
        dropTarget.notifyListeners(2004, event);
        expectedLogger.log((EditPart)child1, "getAddCommand(parts=[child3], next=null)");
        TreeDragToolTest.assertLoggers(expectedLogger, actualLogger);
        event = this.createDNDEvent(child3, TreeDragToolTest.getBeforeLocation(child1));
        dropTarget.notifyListeners(2004, event);
        expectedLogger.log((EditPart)parent, "getMoveCommand(parts=[child3], next=child1)");
        TreeDragToolTest.assertLoggers(expectedLogger, actualLogger);
        event = this.createDNDEvent(child3, TreeDragToolTest.getAfterLocation(parent));
        dropTarget.notifyListeners(2004, event);
        actualLogger.assertEmpty();
        event = this.createDNDEvent(child3, TreeDragToolTest.getOnLocation(parent));
        dropTarget.notifyListeners(2004, event);
        expectedLogger.log((EditPart)parent, "getMoveCommand(parts=[child3], next=null)");
        TreeDragToolTest.assertLoggers(expectedLogger, actualLogger);
        event = this.createDNDEvent(child3, TreeDragToolTest.getBeforeLocation(parent));
        dropTarget.notifyListeners(2004, event);
        actualLogger.assertEmpty();
        event = this.createDNDEvent(child3, TreeDragToolTest.getAfterLocation(child3));
        dropTarget.notifyListeners(2004, event);
        expectedLogger.log((EditPart)parent, "getMoveCommand(parts=[child3], next=null)");
        TreeDragToolTest.assertLoggers(expectedLogger, actualLogger);
        event = this.createDNDEvent(child3, TreeDragToolTest.getBeforeLocation(child3));
        dropTarget.notifyListeners(2004, event);
        expectedLogger.log((EditPart)parent, "getMoveCommand(parts=[child3], next=child3)");
        TreeDragToolTest.assertLoggers(expectedLogger, actualLogger);
    }

    @Test
    public void test_Drag_2() throws Exception {
        RequestsLogger actualLogger = new RequestsLogger();
        TreeToolTest.ILayoutEditPolicy ipolicy = (request, editPart) -> true;
        TreeEditPart parent = this.addEditPart((EditPart)this.m_viewer.getRootEditPart(), "parent", actualLogger, ipolicy);
        TreeEditPart child1 = this.addEditPart((EditPart)parent, "child1", actualLogger, null);
        this.addEditPart((EditPart)parent, "child2", actualLogger, ipolicy);
        TreeEditPart child3 = this.addEditPart((EditPart)parent, "child3", actualLogger, ipolicy);
        TreeDragToolTest.refreshTreeParst(parent);
        this.m_viewer.expandAll();
        this.m_viewer.select((EditPart)child3);
        DropTarget dropTarget = (DropTarget)this.m_viewer.getTree().getData("DropTarget");
        RequestsLogger expectedLogger = new RequestsLogger();
        Event event = this.createDNDEvent(child3, TreeDragToolTest.getOnLocation(child3));
        dropTarget.notifyListeners(2002, event);
        actualLogger.assertEmpty();
        event = this.createDNDEvent(child3, TreeDragToolTest.getAfterLocation(child1));
        dropTarget.notifyListeners(2004, event);
        expectedLogger.log((EditPart)parent, "getMoveCommand(parts=[child3], next=child2)");
        TreeDragToolTest.assertLoggers(expectedLogger, actualLogger);
        event = this.createDNDEvent(child3, TreeDragToolTest.getOnLocation(child1));
        dropTarget.notifyListeners(2004, event);
        expectedLogger.log((EditPart)parent, "getMoveCommand(parts=[child3], next=child2)");
        TreeDragToolTest.assertLoggers(expectedLogger, actualLogger);
        event = this.createDNDEvent(child3, TreeDragToolTest.getBeforeLocation(child1));
        dropTarget.notifyListeners(2004, event);
        expectedLogger.log((EditPart)parent, "getMoveCommand(parts=[child3], next=child1)");
        TreeDragToolTest.assertLoggers(expectedLogger, actualLogger);
    }

    @Test
    public void test_Drag_3() throws Exception {
        RequestsLogger actualLogger = new RequestsLogger();
        TreeToolTest.ILayoutEditPolicy ipolicy = (request, editPart) -> true;
        TreeEditPart parent = this.addEditPart((EditPart)this.m_viewer.getRootEditPart(), "parent", actualLogger, (request, editPart) -> !"child1".equals(editPart.getModel()));
        TreeEditPart child1 = this.addEditPart((EditPart)parent, "child1", actualLogger, ipolicy);
        this.addEditPart((EditPart)parent, "child2", actualLogger, ipolicy);
        TreeEditPart child3 = this.addEditPart((EditPart)parent, "child3", actualLogger, ipolicy);
        TreeDragToolTest.refreshTreeParst(parent);
        this.m_viewer.expandAll();
        this.m_viewer.select((EditPart)child3);
        DropTarget dropTarget = (DropTarget)this.m_viewer.getTree().getData("DropTarget");
        RequestsLogger expectedLogger = new RequestsLogger();
        Event event = this.createDNDEvent(child3, TreeDragToolTest.getOnLocation(child3));
        dropTarget.notifyListeners(2002, event);
        actualLogger.assertEmpty();
        event = this.createDNDEvent(child3, TreeDragToolTest.getAfterLocation(child1));
        dropTarget.notifyListeners(2004, event);
        actualLogger.assertEmpty();
        event = this.createDNDEvent(child3, TreeDragToolTest.getOnLocation(child1));
        dropTarget.notifyListeners(2004, event);
        expectedLogger.log((EditPart)child1, "getAddCommand(parts=[child3], next=null)");
        TreeDragToolTest.assertLoggers(expectedLogger, actualLogger);
        event = this.createDNDEvent(child3, TreeDragToolTest.getBeforeLocation(child1));
        dropTarget.notifyListeners(2004, event);
        actualLogger.assertEmpty();
    }

    private Event createDNDEvent(TreeEditPart dragPart, Point dropLocation) throws Exception {
        Class dndClass = ReflectionUtils.getClassByName((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"org.eclipse.swt.dnd.DNDEvent");
        Event event = (Event)ReflectionUtils.newInstance((Class)dndClass, (String)"<init>()", (Object[])new Object[0]);
        event.widget = this.m_viewer.getControl();
        event.item = dragPart.getWidget();
        org.eclipse.swt.graphics.Point p = Display.getCurrent().map(this.m_viewer.getControl(), null, dropLocation.getSWTPoint());
        event.x = p.x;
        event.y = p.y;
        return event;
    }
}

