/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.widgets;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryInfo;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.FactoryDescriptionHelper;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swt.model.layout.RowLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class LiveImagesManagerTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_noSourceChange() throws Exception {
        this.parseSource("test", "Test.java", LiveImagesManagerTest.getSourceDQ("package test;", "import org.eclipse.swt.widgets.Shell;", "public class Test extends Shell {", "  public Test() {", "  }", "}"));
        String originalSource = this.m_lastEditor.getSource();
        ControlInfo button = BTestUtils.createButton();
        Image image = button.getImage();
        LiveImagesManagerTest.assertNotNull((Object)image);
        LiveImagesManagerTest.assertEquals((Object)originalSource, (Object)this.m_lastEditor.getSource());
        LiveImagesManagerTest.assertEquals((Object)originalSource, (Object)this.m_lastEditor.getModelUnit().getSource());
        LiveImagesManagerTest.assertTrue((boolean)this.m_lastEditor.getModelUnit().isConsistent());
        Dimension preferredSize = button.getPreferredSize();
        LiveImagesManagerTest.assertNotNull((Object)preferredSize);
    }

    @Test
    public void test_onShell() throws Exception {
        this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        ControlInfo button = BTestUtils.createButton();
        LiveImagesManagerTest.assertNotNull((Object)button.getImage());
        LiveImagesManagerTest.assertNotNull((Object)button.getPreferredSize());
    }

    @Test
    public void test_onComposite() throws Exception {
        this.parseComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        ControlInfo label = BTestUtils.createControl("org.eclipse.swt.widgets.Label");
        LiveImagesManagerTest.assertNotNull((Object)label.getImage());
        LiveImagesManagerTest.assertNotNull((Object)label.getPreferredSize());
    }

    @Test
    public void test_noDispose() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "  }", "}");
        RowLayoutInfo rowLayout = (RowLayoutInfo)shell.getLayout();
        shell.refresh();
        ControlInfo button = BTestUtils.createButton();
        Image image = button.getImage();
        LiveImagesManagerTest.assertNotNull((Object)image);
        LiveImagesManagerTest.assertFalse((boolean)image.isDisposed());
        rowLayout.command_CREATE(button, null);
        button = BTestUtils.createButton();
        image = button.getImage();
        LiveImagesManagerTest.assertNotNull((Object)image);
        LiveImagesManagerTest.assertFalse((boolean)image.isDisposed());
    }

    @Test
    public void test_withShell() throws Exception {
        this.parseComposite("public class Test {", "  private static Shell shell;", "  public static void main(String[] args) {", "    shell = new Shell();", "  }", "}");
        ControlInfo text = BTestUtils.createControl("org.eclipse.swt.widgets.Text");
        LiveImagesManagerTest.assertNotNull((Object)text.getImage());
        LiveImagesManagerTest.assertNotNull((Object)text.getPreferredSize());
    }

    @Test
    public void test_customComponent() throws Exception {
        LiveImagesManagerTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "  }", "}"));
        LiveImagesManagerTest.waitForAutoBuild();
        this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        ControlInfo myComposite = BTestUtils.createControl("test.MyComposite");
        LiveImagesManagerTest.assertNotNull((Object)myComposite.getImage());
        LiveImagesManagerTest.assertNotNull((Object)myComposite.getPreferredSize());
    }

    @Test
    public void test_copyPaste() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)button);
        AbstractComponentInfo pasteButton = (AbstractComponentInfo)memento.create((JavaInfo)shell);
        LiveImagesManagerTest.assertNotNull((Object)pasteButton.getImage());
        LiveImagesManagerTest.assertNotNull((Object)pasteButton.getPreferredSize());
    }

    @Test
    public void test_instanceFactory() throws Exception {
        LiveImagesManagerTest.setFileContentSrc("test/InstanceFactory.java", this.getTestSource("public final class InstanceFactory {", "  public Button createButton(Composite parent) {", "    return new Button(parent, SWT.NONE);", "  }", "}"));
        LiveImagesManagerTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public final class Test extends Shell {", "  private final InstanceFactory m_factory = new InstanceFactory();", "  public Test() {", "  }", "}");
        shell.refresh();
        Class<?> factoryClass = this.m_lastLoader.loadClass("test.InstanceFactory");
        InstanceFactoryInfo factoryInfo = (InstanceFactoryInfo)InstanceFactoryInfo.getFactories((JavaInfo)shell, factoryClass).get(0);
        FactoryMethodDescription description = FactoryDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, factoryClass, (String)"createButton(org.eclipse.swt.widgets.Composite)", (boolean)false);
        ControlInfo newButton = (ControlInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("org.eclipse.swt.widgets.Button"), (CreationSupport)new InstanceFactoryCreationSupport(factoryInfo, description));
        LiveImagesManagerTest.assertNotNull((Object)newButton.getImage());
    }
}

