/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.widgets;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class CompositeTopBoundsSupportTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_setSize_Composite_noSizeInvocations() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        composite.refresh();
        CompositeTopBoundsSupportTest.assertEquals((Object)new Dimension(450, 300), (Object)composite.getBounds().getSize());
        composite.getTopBoundsSupport().setSize(500, 400);
        composite.refresh();
        CompositeTopBoundsSupportTest.assertEquals((Object)new Dimension(500, 400), (Object)composite.getBounds().getSize());
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
    }

    @Test
    public void test_setSize_Composite_setSize_Point() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setSize(new Point(250, 200));", "  }", "}");
        composite.refresh();
        CompositeTopBoundsSupportTest.assertEquals((Object)new Dimension(250, 200), (Object)composite.getBounds().getSize());
        composite.getTopBoundsSupport().setSize(500, 400);
        composite.refresh();
        CompositeTopBoundsSupportTest.assertEquals((Object)new Dimension(500, 400), (Object)composite.getBounds().getSize());
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setSize(new Point(500, 400));", "  }", "}");
    }

    @Test
    public void test_setSize_Composite_setSize_ints() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setSize(250, 200);", "  }", "}");
        composite.refresh();
        CompositeTopBoundsSupportTest.assertEquals((Object)new Dimension(250, 200), (Object)composite.getBounds().getSize());
        composite.getTopBoundsSupport().setSize(500, 400);
        composite.refresh();
        CompositeTopBoundsSupportTest.assertEquals((Object)new Dimension(500, 400), (Object)composite.getBounds().getSize());
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setSize(500, 400);", "  }", "}");
    }

    @Test
    public void test_setSize_Shell_noSizeInvocations() throws Exception {
        CompositeInfo composite = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        composite.refresh();
        CompositeTopBoundsSupportTest.assertEquals((Object)new Dimension(450, 300), (Object)composite.getBounds().getSize());
        composite.getTopBoundsSupport().setSize(500, 400);
        composite.refresh();
        CompositeTopBoundsSupportTest.assertEquals((Object)new Dimension(500, 400), (Object)composite.getBounds().getSize());
        this.assertEditor("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "    setSize(500, 400);", "  }", "}");
    }
}

