/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.property;

import java.util.List;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.swt.model.jface.resource.LocalResourceManagerInfo;
import org.eclipse.wb.internal.swt.model.jface.resource.ManagerContainerInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class LocalResourceManagerTest
extends RcpModelTest {
    @Test
    public void test_parseJavaInfo1() throws Exception {
        this.test_parseJavaInfo("public class Test extends Shell {", "  private ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());", "}");
    }

    @Test
    public void test_parseJavaInfo2() throws Exception {
        this.test_parseJavaInfo("public class Test extends Shell {", "  private ResourceManager resourceManager;", "  public Test() {", "    resourceManager = new LocalResourceManager(JFaceResources.getResources());", "  }", "}");
    }

    private void test_parseJavaInfo(String ... lines) throws Exception {
        CompositeInfo shell = this.parseComposite(lines);
        shell.refresh();
        List children = ManagerContainerInfo.getManagers((JavaInfo)shell, LocalResourceManagerInfo.class);
        LocalResourceManagerTest.assertEquals((int)1, (int)children.size());
        LocalResourceManagerInfo containerInfo = (LocalResourceManagerInfo)children.get(0);
        LocalResourceManagerTest.assertNotNull((Object)containerInfo);
        VariableSupport variableSupport = containerInfo.getVariableSupport();
        LocalResourceManagerTest.assertEquals((Object)variableSupport.getName(), (Object)"resourceManager");
    }

    @Test
    public void test_createResourceManager1() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "}");
        ManagerContainerInfo.getResourceManagerInfo((JavaInfo)shell);
        shell.refresh();
        this.assertEditor("public class Test extends Shell {", "  private LocalResourceManager localResourceManager;", "  public Test() {", "    createResourceManager();", "  }", "  private void createResourceManager() {", "    localResourceManager = new LocalResourceManager(JFaceResources.getResources(),this);", "  }", "}");
    }

    @Test
    public void test_createResourceManager2() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test {", "  private Shell shell;", "  public Test() {", "    shell = new Shell();", "  }", "}");
        ManagerContainerInfo.getResourceManagerInfo((JavaInfo)shell);
        shell.refresh();
        this.assertEditor("public class Test {", "  private Shell shell;", "  private LocalResourceManager localResourceManager;", "  public Test() {", "    shell = new Shell();", "    createResourceManager();", "  }", "  private void createResourceManager() {", "    localResourceManager = new LocalResourceManager(JFaceResources.getResources(),shell);", "  }", "}");
    }

    @Test
    public void test_createResourceManager3() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test {", "  private Shell shell;", "  public Test() {", "    shell = new Shell();", "    new Composite(shell, SWT.NONE);", "  }", "}");
        ManagerContainerInfo.getResourceManagerInfo((JavaInfo)shell);
        shell.refresh();
        this.assertEditor("public class Test {", "  private Shell shell;", "  private LocalResourceManager localResourceManager;", "  public Test() {", "    shell = new Shell();", "    createResourceManager();", "    new Composite(shell, SWT.NONE);", "  }", "  private void createResourceManager() {", "    localResourceManager = new LocalResourceManager(JFaceResources.getResources(),shell);", "  }", "}");
    }

    @Test
    public void test_createResourceManager4() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    new Composite(this, SWT.NONE);", "  }", "}");
        ManagerContainerInfo.getResourceManagerInfo((JavaInfo)shell);
        shell.refresh();
        this.assertEditor("public class Test extends Shell {", "  private LocalResourceManager localResourceManager;", "  public Test() {", "    createResourceManager();", "    new Composite(this, SWT.NONE);", "  }", "  private void createResourceManager() {", "    localResourceManager = new LocalResourceManager(JFaceResources.getResources(),this);", "  }", "}");
    }

    @Test
    public void test_createResourceManager5() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    super(SWT.NONE);", "  }", "}");
        ManagerContainerInfo.getResourceManagerInfo((JavaInfo)shell);
        shell.refresh();
        this.assertEditor("public class Test extends Shell {", "  private LocalResourceManager localResourceManager;", "  public Test() {", "    super(SWT.NONE);", "    createResourceManager();", "  }", "  private void createResourceManager() {", "    localResourceManager = new LocalResourceManager(JFaceResources.getResources(),this);", "  }", "}");
    }

    @Test
    public void test_useResourceManager1() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private LocalResourceManager resourceManager;", "  public Test() {", "    super(SWT.NONE);", "    createResourceManager();", "  }", "  private void createResourceManager() {", "    resourceManager = new LocalResourceManager(JFaceResources.getResources(),this);", "  }", "}");
        shell.addMethodInvocation("setBackground(Color)", "resourceManager.create(new RGB(1,1,1))");
        shell.refresh();
        this.assertEditor("public class Test extends Shell {", "  private LocalResourceManager resourceManager;", "  public Test() {", "    super(SWT.NONE);", "    createResourceManager();", "    setBackground(resourceManager.create(new RGB(1,1,1)));", "  }", "  private void createResourceManager() {", "    resourceManager = new LocalResourceManager(JFaceResources.getResources(),this);", "  }", "}");
    }

    @Test
    public void test_useResourceManager2() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private LocalResourceManager resourceManager;", "  public Test() {", "    super(SWT.NONE);", "    createResourceManager1();", "  }", "  private void createResourceManager1() {", "    createResourceManager();", "  }", "  private void createResourceManager() {", "    resourceManager = new LocalResourceManager(JFaceResources.getResources(),this);", "  }", "}");
        shell.addMethodInvocation("setBackground(Color)", "resourceManager.create(new RGB(1,1,1))");
        shell.refresh();
        this.assertEditor("public class Test extends Shell {", "  private LocalResourceManager resourceManager;", "  public Test() {", "    super(SWT.NONE);", "    createResourceManager1();", "    setBackground(resourceManager.create(new RGB(1,1,1)));", "  }", "  private void createResourceManager1() {", "    createResourceManager();", "  }", "  private void createResourceManager() {", "    resourceManager = new LocalResourceManager(JFaceResources.getResources(),this);", "  }", "}");
    }

    @Test
    public void test_useResourceManager3() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private LocalResourceManager resourceManager;", "  public Test() {", "    super(SWT.NONE);", "    resourceManager = new LocalResourceManager(JFaceResources.getResources(),this);", "  }", "}");
        shell.addMethodInvocation("setBackground(Color)", "resourceManager.create(new RGB(1,1,1))");
        shell.refresh();
        this.assertEditor("public class Test extends Shell {", "  private LocalResourceManager resourceManager;", "  public Test() {", "    super(SWT.NONE);", "    resourceManager = new LocalResourceManager(JFaceResources.getResources(),this);", "    setBackground(resourceManager.create(new RGB(1,1,1)));", "  }", "}");
    }

    @Test
    public void test_useResourceManager4() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(),this);", "  public Test() {", "    super(SWT.NONE);", "  }", "}");
        shell.addMethodInvocation("setBackground(Color)", "resourceManager.create(new RGB(1,1,1))");
        shell.refresh();
        this.assertEditor("public class Test extends Shell {", "  private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(),this);", "  public Test() {", "    super(SWT.NONE);", "    setBackground(resourceManager.create(new RGB(1,1,1)));", "  }", "}");
    }
}

