/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.property;

import java.io.File;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.eclipse.wb.tests.designer.swt.model.property.PropertyEditorTestUtils;

public abstract class ImageDescriptorPropertyEditorTest
extends RcpModelTest {
    protected final GenericProperty createImageDescriptorPropertyForSource(String source) throws Exception {
        ImageDescriptorPropertyEditorTest.setFileContentSrc("test/MyControl.java", ImageDescriptorPropertyEditorTest.getSourceDQ("package test;", "", "import org.eclipse.swt.SWT;", "import org.eclipse.swt.widgets.*;", "import org.eclipse.jface.resource.*;", "", "public class MyControl extends Composite {", "  public MyControl(Composite composite, int style) {", "    super(composite, style);", "  }", "  public void setImageDescriptor(ImageDescriptor descriptor) {", "  }", "}"));
        ImageDescriptorPropertyEditorTest.waitForAutoBuild();
        this.m_waitForAutoBuild = true;
        CompositeInfo shell = (CompositeInfo)this.parseSource("test", "Test.java", ImageDescriptorPropertyEditorTest.getSourceDQ("package test;", "", "import org.eclipse.swt.SWT;", "import org.eclipse.swt.widgets.*;", "import org.eclipse.jface.resource.*;", "", "public class Test extends Shell {", "  public Test() {", "    MyControl control = new MyControl(this, SWT.NONE);", "  }", "}"));
        ControlInfo control = (ControlInfo)shell.getChildrenControls().get(0);
        shell.refresh();
        ImageDescriptorPropertyEditorTest.assertNoErrors((JavaInfo)shell);
        GenericProperty property = (GenericProperty)control.getPropertyByTitle("imageDescriptor");
        property.setExpression(source, Property.UNKNOWN_VALUE);
        ImageDescriptorPropertyEditorTest.assertNoErrors((JavaInfo)shell);
        return property;
    }

    protected final void assert_getText_getClipboardSource_forSource(String source, String expectedText, String expectedClipboardSource) throws Exception {
        GenericProperty property = this.createImageDescriptorPropertyForSource(source);
        ImageDescriptorPropertyEditorTest.assertEquals((Object)expectedText, (Object)PropertyEditorTestUtils.getText((Property)property));
        ImageDescriptorPropertyEditorTest.assertEquals((Object)expectedClipboardSource, (Object)PropertyEditorTestUtils.getClipboardSource((Property)property));
    }

    protected static File createTempImage() throws Exception {
        File file = File.createTempFile("testcase", ".png");
        Image image = new Image(null, 1, 1);
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image.getImageData()};
        loader.save(file.getAbsolutePath(), 5);
        image.dispose();
        return file;
    }
}

