/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.menu;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Tool;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.gef.core.tools.PasteTool;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.swt.model.widgets.menu.MenuInfo;
import org.eclipse.wb.internal.swt.model.widgets.menu.MenuItemInfo;
import org.eclipse.wb.tests.designer.rcp.RcpGefTest;
import org.eclipse.wb.tests.designer.swt.model.menu.MenuFeedbackTester;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class MenuComplexTest
extends RcpGefTest {
    private MenuFeedbackTester menuTester;

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Override
    protected void fetchContentFields() {
        super.fetchContentFields();
        this.menuTester = new MenuFeedbackTester(this.canvas);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.menuTester = null;
        super.tearDown();
    }

    @Test
    public void test_selectDeepItemInTree() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    Menu popup = new Menu(this);", "    setMenu(popup);", "    {", "      MenuItem item_1 = new MenuItem(popup, SWT.CASCADE);", "      item_1.setText('Item 1');", "      {", "        Menu menu_1 = new Menu(item_1);", "        item_1.setMenu(menu_1);", "        {", "          MenuItem item_2 = new MenuItem(menu_1, SWT.NONE);", "          item_2.setText('Item 2');", "        }", "      }", "    }", "  }", "}");
        MenuInfo popupInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        MenuItemInfo item_1 = (MenuItemInfo)popupInfo.getChildrenItems().get(0);
        MenuInfo menu_1 = (MenuInfo)item_1.getChildren(MenuInfo.class).get(0);
        MenuItemInfo item_2 = (MenuItemInfo)menu_1.getChildrenItems().get(0);
        GraphicalEditPart popupPart = this.canvas.getEditPart(popupInfo);
        this.tree.select(item_2);
        EditPart dropPart = (EditPart)popupPart.getChildren().get(0);
        GraphicalEditPart itemPart_1 = this.canvas.getEditPart(item_1);
        GraphicalEditPart menuPart_1 = this.canvas.getEditPart(menu_1);
        GraphicalEditPart itemPart_2 = this.canvas.getEditPart(item_2);
        MenuComplexTest.assertNotNull((Object)dropPart);
        MenuComplexTest.assertNotNull((Object)itemPart_1);
        MenuComplexTest.assertNotNull((Object)menuPart_1);
        MenuComplexTest.assertNotNull((Object)itemPart_2);
        MenuComplexTest.assertEquals((int)2, (int)itemPart_2.getSelected());
        this.tree.select(shellInfo);
        MenuComplexTest.assertTrue((boolean)popupPart.getChildren().isEmpty());
        this.canvas.assertNullEditPart(item_1);
        this.canvas.assertNullEditPart(menu_1);
        this.canvas.assertNullEditPart(item_2);
    }

    @Test
    public void test_selectSubMenu() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    {", "      MenuItem item = new MenuItem(bar, SWT.CASCADE);", "      item.setText('Item');", "      {", "        Menu menu = new Menu(item);", "        item.setMenu(menu);", "      }", "    }", "  }", "}");
        MenuInfo barInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        MenuItemInfo item = (MenuItemInfo)barInfo.getChildrenItems().get(0);
        MenuInfo menu = (MenuInfo)item.getChildren(MenuInfo.class).get(0);
        this.canvas.assertNullEditPart(menu);
        this.tree.select(menu);
        MenuComplexTest.assertNotNull((Object)this.canvas.getEditPart(menu));
        MenuComplexTest.waitEventLoop(0);
    }

    @Test
    public void test_barSubMenuLocation() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    {", "      MenuItem item = new MenuItem(bar, SWT.CASCADE);", "      item.setText('Item');", "      {", "        Menu menu = new Menu(item);", "        item.setMenu(menu);", "      }", "    }", "  }", "}");
        MenuInfo barInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        MenuItemInfo itemInfo = (MenuItemInfo)barInfo.getChildrenItems().get(0);
        MenuInfo menuInfo = (MenuInfo)itemInfo.getChildren(MenuInfo.class).get(0);
        this.tree.select(itemInfo);
        MenuComplexTest.assertEquals((Object)this.canvas.getAbsoluteBounds(itemInfo).getBottomLeft(), (Object)this.canvas.getEditPart(menuInfo).getFigure().getLocation());
    }

    @Test
    public void test_popupSubMenuLocation() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    Menu popup = new Menu(this);", "    setMenu(bar);", "    {", "      MenuItem item = new MenuItem(popup, SWT.CASCADE);", "      item.setText('Item');", "      {", "        Menu menu = new Menu(item);", "        item.setMenu(menu);", "      }", "    }", "  }", "}");
        MenuInfo popupInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        MenuItemInfo itemInfo = (MenuItemInfo)popupInfo.getChildrenItems().get(0);
        MenuInfo menuInfo = (MenuInfo)itemInfo.getChildren(MenuInfo.class).get(0);
        this.tree.select(itemInfo);
        MenuComplexTest.assertEquals((Object)this.canvas.getAbsoluteBounds(itemInfo).getTopRight().getTranslated(-3, -2), (Object)this.canvas.getEditPart(menuInfo).getFigure().getLocation());
    }

    @Test
    public void test_twoPopupMenus() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button 1');", "      {", "        Menu popup_1 = new Menu(button_1);", "        button_1.setMenu(popup_1);", "      }", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button 2');", "      {", "        Menu popup_2 = new Menu(button_2);", "        button_2.setMenu(popup_2);", "      }", "    }", "  }", "}");
        ControlInfo button_1 = (ControlInfo)shellInfo.getChildrenControls().get(0);
        ControlInfo button_2 = (ControlInfo)shellInfo.getChildrenControls().get(1);
        MenuInfo popup_1 = (MenuInfo)button_1.getChildren(MenuInfo.class).get(0);
        MenuInfo popup_2 = (MenuInfo)button_2.getChildren(MenuInfo.class).get(0);
        GraphicalEditPart popupPart_1 = this.canvas.getEditPart(popup_1);
        GraphicalEditPart popupPart_2 = this.canvas.getEditPart(popup_2);
        MenuComplexTest.assertEquals((int)0, (int)popupPart_1.getChildren().size());
        MenuComplexTest.assertEquals((int)0, (int)popupPart_2.getChildren().size());
        this.tree.select(popup_1);
        MenuComplexTest.assertEquals((int)1, (int)popupPart_1.getChildren().size());
        MenuComplexTest.assertEquals((int)0, (int)popupPart_2.getChildren().size());
        this.tree.select(popup_2);
        MenuComplexTest.assertEquals((int)0, (int)popupPart_1.getChildren().size());
        MenuComplexTest.assertEquals((int)1, (int)popupPart_2.getChildren().size());
    }

    @Test
    public void test_deleteUp() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    Menu popup = new Menu(this);", "    setMenu(popup);", "    new MenuItem(popup, SWT.NONE).setText('Item 1');", "    new MenuItem(popup, SWT.NONE).setText('Item 2');", "    new MenuItem(popup, SWT.NONE).setText('Item 3');", "  }", "}");
        MenuInfo popupInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        MenuItemInfo item_1 = (MenuItemInfo)popupInfo.getChildrenItems().get(0);
        MenuItemInfo item_2 = (MenuItemInfo)popupInfo.getChildrenItems().get(1);
        GraphicalEditPart popupPart = this.canvas.getEditPart(popupInfo);
        this.tree.select(item_2);
        EditPart dropPart = (EditPart)popupPart.getChildren().get(0);
        MenuComplexTest.assertEquals((int)3, (int)dropPart.getChildren().size());
        GraphicalEditPart itemPart_1 = this.canvas.getEditPart(item_1);
        GraphicalEditPart itemPart_2 = this.canvas.getEditPart(item_2);
        MenuComplexTest.assertNotNull((Object)dropPart);
        MenuComplexTest.assertNotNull((Object)itemPart_1);
        MenuComplexTest.assertNotNull((Object)itemPart_2);
        MenuComplexTest.assertEquals((int)2, (int)itemPart_2.getSelected());
        item_2.delete();
        MenuComplexTest.assertSame((Object)dropPart, popupPart.getChildren().get(0));
        MenuComplexTest.assertSame((Object)itemPart_1, (Object)this.canvas.getEditPart(item_1));
        MenuComplexTest.assertEquals((int)2, (int)itemPart_1.getSelected());
    }

    @Test
    public void test_deleteFirst() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    Menu popup = new Menu(this);", "    setMenu(popup);", "    new MenuItem(popup, SWT.NONE).setText('Item 1');", "    new MenuItem(popup, SWT.NONE).setText('Item 2');", "    new MenuItem(popup, SWT.NONE).setText('Item 3');", "  }", "}");
        MenuInfo popupInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        MenuItemInfo item_1 = (MenuItemInfo)popupInfo.getChildrenItems().get(0);
        MenuItemInfo item_2 = (MenuItemInfo)popupInfo.getChildrenItems().get(1);
        GraphicalEditPart popupPart = this.canvas.getEditPart(popupInfo);
        this.tree.select(item_1);
        EditPart dropPart = (EditPart)popupPart.getChildren().get(0);
        MenuComplexTest.assertEquals((int)3, (int)dropPart.getChildren().size());
        GraphicalEditPart itemPart_1 = this.canvas.getEditPart(item_1);
        GraphicalEditPart itemPart_2 = this.canvas.getEditPart(item_2);
        MenuComplexTest.assertNotNull((Object)dropPart);
        MenuComplexTest.assertNotNull((Object)itemPart_1);
        MenuComplexTest.assertNotNull((Object)itemPart_2);
        MenuComplexTest.assertEquals((int)2, (int)itemPart_1.getSelected());
        item_1.delete();
        MenuComplexTest.assertSame((Object)dropPart, popupPart.getChildren().get(0));
        MenuComplexTest.assertSame((Object)itemPart_2, (Object)this.canvas.getEditPart(item_2));
        MenuComplexTest.assertEquals((int)2, (int)itemPart_2.getSelected());
    }

    @Test
    public void test_deleteSole() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    Menu popup = new Menu(this);", "    setMenu(popup);", "    new MenuItem(popup, SWT.NONE);", "  }", "}");
        MenuInfo popupInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        MenuItemInfo item = (MenuItemInfo)popupInfo.getChildrenItems().get(0);
        GraphicalEditPart popupPart = this.canvas.getEditPart(popupInfo);
        this.tree.select(item);
        EditPart dropPart = (EditPart)popupPart.getChildren().get(0);
        GraphicalEditPart itemPart = this.canvas.getEditPart(item);
        MenuComplexTest.assertNotNull((Object)dropPart);
        MenuComplexTest.assertNotNull((Object)itemPart);
        MenuComplexTest.assertEquals((int)2, (int)itemPart.getSelected());
        item.delete();
        MenuComplexTest.assertSame((Object)dropPart, popupPart.getChildren().get(0));
        MenuComplexTest.assertEquals((int)2, (int)popupPart.getSelected());
    }

    @Test
    public void test_deleteItemWithSubmenu() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    {", "      MenuItem item_1 = new MenuItem(bar, SWT.NONE);", "      item_1.setText('Item 1');", "    }", "    {", "      MenuItem item_2 = new MenuItem(bar, SWT.CASCADE);", "      item_2.setText('Item 2');", "      {", "        Menu menu_2 = new Menu(item_2);", "        item_2.setMenu(menu_2);", "      }", "    }", "  }", "}");
        this.assertJavaInfo("bar");
        this.assertJavaInfo("item_1");
        this.assertJavaInfo("item_2");
        this.assertJavaInfo("menu_2");
        MenuInfo barInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        MenuItemInfo item_1 = (MenuItemInfo)barInfo.getChildrenItems().get(0);
        MenuItemInfo item_2 = (MenuItemInfo)barInfo.getChildrenItems().get(1);
        MenuInfo menu_2 = (MenuInfo)item_2.getChildren(MenuInfo.class).get(0);
        this.tree.select(item_2);
        this.canvas.assertPrimarySelected(item_2);
        this.canvas.assertNotNullEditPart(menu_2);
        item_2.delete();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    {", "      MenuItem item_1 = new MenuItem(bar, SWT.NONE);", "      item_1.setText('Item 1');", "    }", "  }", "}");
        this.canvas.assertPrimarySelected(item_1);
        this.assertSelectionModels(item_1);
    }

    @Test
    public void test_deleteBarWithSubmenu() throws Exception {
        CompositeInfo shellInfo = this.openComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    {", "      MenuItem item = new MenuItem(bar, SWT.CASCADE);", "      item.setText('Item');", "      {", "        Menu menu = new Menu(item);", "        item.setMenu(menu);", "      }", "    }", "  }", "}");
        MenuInfo barInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        barInfo.delete();
        this.assertEditor("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_CREATE_popup_newItem_deep() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    Menu popup = new Menu(this);", "    setMenu(popup);", "    {", "      MenuItem item_1 = new MenuItem(popup, SWT.CASCADE);", "      item_1.setText('Item 1');", "      {", "        Menu menu_1 = new Menu(item_1);", "        item_1.setMenu(menu_1);", "        {", "          MenuItem item_2 = new MenuItem(menu_1, SWT.NONE);", "          item_2.setText('Item 2');", "        }", "      }", "    }", "  }", "}");
        MenuInfo popupInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        MenuItemInfo item_1 = (MenuItemInfo)popupInfo.getChildrenItems().get(0);
        MenuInfo menu_1 = (MenuInfo)item_1.getChildren(MenuInfo.class).get(0);
        MenuItemInfo item_2 = (MenuItemInfo)menu_1.getChildrenItems().get(0);
        GraphicalEditPart popupPart = this.canvas.getEditPart(popupInfo);
        this.loadCreationTool("org.eclipse.swt.widgets.MenuItem");
        this.canvas.moveTo(popupPart);
        this.menuTester.assertMenuTargetFeedback(popupPart);
        GraphicalEditPart itemPart_1 = this.canvas.getEditPart(item_1);
        this.canvas.moveTo((Object)itemPart_1, 1, 1);
        this.menuTester.assertMenuLineFeedback(itemPart_1, 8);
        this.canvas.assertNullEditPart(menu_1);
        this.canvas.moveTo((Object)itemPart_1, 1, -1);
        this.menuTester.assertMenuLineFeedback(itemPart_1, 32);
        this.canvas.assertNullEditPart(menu_1);
        this.canvas.moveTo((Object)itemPart_1, 1, itemPart_1.getFigure().getSize().height / 2);
        this.menuTester.assertMenuTargetFeedback(itemPart_1);
        GraphicalEditPart menuPart_1 = this.canvas.getEditPart(menu_1);
        GraphicalEditPart itemPart_2 = this.canvas.getEditPart(item_2);
        MenuComplexTest.assertNotNull((Object)menuPart_1);
        MenuComplexTest.assertNotNull((Object)itemPart_2);
    }

    @Test
    public void test_CREATE_bar_newItem_before() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    {", "      MenuItem item_1 = new MenuItem(bar, SWT.NONE);", "      item_1.setText('Item 1');", "    }", "  }", "}");
        MenuInfo barInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        MenuItemInfo item = (MenuItemInfo)barInfo.getChildrenItems().get(0);
        this.loadCreationTool("org.eclipse.swt.widgets.MenuItem");
        this.canvas.moveTo((Object)item, 1, 1);
        this.menuTester.assertMenuLineFeedback(item, 1);
        this.canvas.click();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    {", "      MenuItem menuItem = new MenuItem(bar, SWT.NONE);", "      menuItem.setText('New Item');", "    }", "    {", "      MenuItem item_1 = new MenuItem(bar, SWT.NONE);", "      item_1.setText('Item 1');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_bar_newItem_after() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    {", "      MenuItem item_1 = new MenuItem(bar, SWT.NONE);", "      item_1.setText('Item 1');", "    }", "  }", "}");
        MenuInfo barInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        MenuItemInfo item = (MenuItemInfo)barInfo.getChildrenItems().get(0);
        GraphicalEditPart itemPart = this.canvas.getEditPart(item);
        this.loadCreationTool("org.eclipse.swt.widgets.MenuItem");
        this.canvas.moveTo((Object)itemPart, -1, 1);
        this.menuTester.assertMenuLineFeedback(itemPart, 4);
        this.canvas.click();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    {", "      MenuItem item_1 = new MenuItem(bar, SWT.NONE);", "      item_1.setText('Item 1');", "    }", "    {", "      MenuItem menuItem = new MenuItem(bar, SWT.NONE);", "      menuItem.setText('New Item');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_bar_submenu() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    {", "      MenuItem item = new MenuItem(bar, SWT.CASCADE);", "      item.setText('Item');", "      {", "        Menu menu = new Menu(item);", "        item.setMenu(menu);", "      }", "    }", "  }", "}");
        MenuInfo barInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        MenuItemInfo itemInfo = (MenuItemInfo)barInfo.getChildrenItems().get(0);
        MenuInfo menuInfo = (MenuInfo)itemInfo.getChildren(MenuInfo.class).get(0);
        GraphicalEditPart itemPart = this.canvas.getEditPart(itemInfo);
        Object newItemInfo = this.loadCreationTool("org.eclipse.swt.widgets.MenuItem");
        this.canvas.assertNullEditPart(menuInfo);
        this.canvas.moveTo((Object)itemPart, 1, 1);
        this.menuTester.assertMenuLineFeedback(itemPart, 1);
        this.canvas.assertNullEditPart(menuInfo);
        this.canvas.moveTo((Object)itemPart, itemPart.getFigure().getSize().width / 2, 1);
        this.menuTester.assertMenuTargetFeedback(itemPart);
        GraphicalEditPart menuPart = this.canvas.getEditPart(menuInfo);
        MenuComplexTest.assertNotNull((Object)menuPart);
        this.canvas.moveTo((Object)menuPart, 1, 1);
        this.canvas.click();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    {", "      MenuItem item = new MenuItem(bar, SWT.CASCADE);", "      item.setText('Item');", "      {", "        Menu menu = new Menu(item);", "        item.setMenu(menu);", "        {", "          MenuItem menuItem = new MenuItem(menu, SWT.NONE);", "          menuItem.setText('New Item');", "        }", "      }", "    }", "  }", "}");
        MenuComplexTest.assertSame((Object)menuPart, (Object)this.canvas.getEditPart(menuInfo));
        GraphicalEditPart newItemPart = this.canvas.getEditPart(newItemInfo);
        MenuComplexTest.assertSame((Object)menuPart, (Object)newItemPart.getParent());
        this.canvas.assertPrimarySelected(newItemPart);
    }

    @Test
    public void test_CREATE_bar_notItem() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    {", "      MenuItem item_1 = new MenuItem(bar, SWT.NONE);", "      item_1.setText('Item 1');", "    }", "  }", "}");
        MenuInfo barInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        GraphicalEditPart barPart = this.canvas.getEditPart(barInfo);
        this.loadCreationTool("org.eclipse.swt.widgets.Button");
        this.canvas.moveTo((Object)barPart, 1, 1);
        this.menuTester.assertMenuNoFeedbacks();
    }

    @Test
    public void test_PASTE_item() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    {", "      MenuItem item = new MenuItem(bar, SWT.NONE);", "      item.setText('item');", "    }", "  }", "}");
        MenuInfo barInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        MenuItemInfo itemInfo = (MenuItemInfo)barInfo.getChildrenItems().get(0);
        GraphicalEditPart itemPart = this.canvas.getEditPart(itemInfo);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)itemInfo);
        PasteTool pasteTool = new PasteTool(List.of(memento));
        this.m_viewerCanvas.getEditDomain().setActiveTool((Tool)pasteTool);
        this.canvas.moveTo((Object)itemPart, 1, 1);
        this.menuTester.assertMenuLineFeedback(itemPart, 1);
        this.canvas.click();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    {", "      MenuItem item = new MenuItem(bar, SWT.NONE);", "      item.setText('item');", "    }", "    {", "      MenuItem item = new MenuItem(bar, SWT.NONE);", "      item.setText('item');", "    }", "  }", "}");
    }

    @Test
    public void test_PASTE_notItem() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    setLayout(new RowLayout());", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
        MenuInfo barInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        ControlInfo buttonInfo = (ControlInfo)shellInfo.getChildrenControls().get(0);
        GraphicalEditPart barPart = this.canvas.getEditPart(barInfo);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)buttonInfo);
        PasteTool pasteTool = new PasteTool(List.of(memento));
        this.m_viewerCanvas.getEditDomain().setActiveTool((Tool)pasteTool);
        this.canvas.moveTo((Object)barPart, 1, 1);
        this.menuTester.assertMenuNoFeedbacks();
        this.canvas.click();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_PASTE_notItem2() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    Menu popup = new Menu(this);", "    setMenu(popup);", "    setLayout(new RowLayout());", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
        MenuInfo popupInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        ControlInfo buttonInfo = (ControlInfo)shellInfo.getChildrenControls().get(0);
        GraphicalEditPart popupPart = this.canvas.getEditPart(popupInfo);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)buttonInfo);
        PasteTool pasteTool = new PasteTool(List.of(memento));
        this.m_viewerCanvas.getEditDomain().setActiveTool((Tool)pasteTool);
        MenuComplexTest.assertEquals((int)0, (int)popupPart.getChildren().size());
        this.canvas.moveTo((Object)popupPart, 1, 1);
        this.menuTester.assertMenuNoFeedbacks();
        MenuComplexTest.assertEquals((int)0, (int)popupPart.getChildren().size());
        this.canvas.click();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu popup = new Menu(this);", "    setMenu(popup);", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_MOVE_item() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    {", "      MenuItem menuItem = new MenuItem(bar, SWT.NONE);", "      menuItem.setText('Item 1');", "    }", "    {", "      MenuItem menuItem = new MenuItem(bar, SWT.NONE);", "      menuItem.setText('Item 2');", "    }", "  }", "}");
        MenuInfo barInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        MenuItemInfo item_1 = (MenuItemInfo)barInfo.getChildrenItems().get(0);
        MenuItemInfo item_2 = (MenuItemInfo)barInfo.getChildrenItems().get(1);
        GraphicalEditPart itemPart_1 = this.canvas.getEditPart(item_1);
        GraphicalEditPart itemPart_2 = this.canvas.getEditPart(item_2);
        this.canvas.beginDrag(itemPart_2).dragTo(itemPart_1);
        this.menuTester.assertFeedback_selection_line(itemPart_2, itemPart_1, 1);
        this.canvas.endDrag();
        this.menuTester.assertFeedback_selection(itemPart_2);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    {", "      MenuItem menuItem = new MenuItem(bar, SWT.NONE);", "      menuItem.setText('Item 2');", "    }", "    {", "      MenuItem menuItem = new MenuItem(bar, SWT.NONE);", "      menuItem.setText('Item 1');", "    }", "  }", "}");
        MenuComplexTest.assertSame((Object)itemPart_2, (Object)this.canvas.getEditPart(item_2));
        MenuComplexTest.assertEquals((int)2, (int)itemPart_2.getSelected());
    }

    @Test
    public void test_ADD_item() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    {", "      MenuItem item_1 = new MenuItem(bar, SWT.CASCADE);", "      item_1.setText('Item 1');", "      {", "        Menu menu_1 = new Menu(item_1);", "        item_1.setMenu(menu_1);", "        {", "          MenuItem item_2 = new MenuItem(menu_1, SWT.NONE);", "          item_2.setText('Item 2');", "        }", "      }", "    }", "  }", "}");
        MenuInfo barInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        MenuItemInfo item_1 = (MenuItemInfo)barInfo.getChildrenItems().get(0);
        MenuInfo menu_1 = (MenuInfo)item_1.getChildren(MenuInfo.class).get(0);
        MenuItemInfo item_2 = (MenuItemInfo)menu_1.getChildrenItems().get(0);
        GraphicalEditPart itemPart_1 = this.canvas.getEditPart(item_1);
        this.tree.select(item_2);
        GraphicalEditPart itemPart_2 = this.canvas.getEditPart(item_2);
        MenuComplexTest.assertEquals((int)2, (int)itemPart_2.getSelected());
        this.canvas.beginDrag(itemPart_2).dragTo(itemPart_1);
        this.menuTester.assertFeedback_selection_line(itemPart_2, itemPart_1, 1);
        this.canvas.endDrag();
        itemPart_2 = this.canvas.getEditPart(item_2);
        this.menuTester.assertFeedback_selection(itemPart_2);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    {", "      MenuItem item_2 = new MenuItem(bar, SWT.NONE);", "      item_2.setText('Item 2');", "    }", "    {", "      MenuItem item_1 = new MenuItem(bar, SWT.CASCADE);", "      item_1.setText('Item 1');", "      {", "        Menu menu_1 = new Menu(item_1);", "        item_1.setMenu(menu_1);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_badOnOwnMenu() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    {", "      MenuItem item = new MenuItem(bar, SWT.CASCADE);", "      item.setText('Item');", "      {", "        Menu menu = new Menu(item);", "        item.setMenu(menu);", "      }", "    }", "  }", "}");
        String source = this.m_lastEditor.getSource();
        MenuInfo barInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        MenuItemInfo item = (MenuItemInfo)barInfo.getChildrenItems().get(0);
        MenuInfo menu = (MenuInfo)item.getChildren(MenuInfo.class).get(0);
        this.tree.select(item);
        this.canvas.beginDrag(item).dragTo(menu);
        this.menuTester.assertFeedback_selection(item);
        this.canvas.endDrag();
        this.menuTester.assertFeedback_selection(item);
        MenuComplexTest.assertEditor(source, this.m_lastEditor);
    }

    @Test
    public void test_ADD_badNotMenu() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    setLayout(new RowLayout());", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
        String source = this.m_lastEditor.getSource();
        MenuInfo barInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        ControlInfo buttonInfo = (ControlInfo)shellInfo.getChildrenControls().get(0);
        this.canvas.beginDrag(buttonInfo).dragTo(barInfo);
        this.menuTester.assertMenuNoFeedbacks();
        this.canvas.endDrag();
        this.menuTester.assertMenuNoFeedbacks();
        MenuComplexTest.assertEditor(source, this.m_lastEditor);
    }

    @Test
    public void test_ADD_fromPopup_onBar() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Menu bar = new Menu(this, SWT.BAR);", "      setMenuBar(bar);", "      new MenuItem(bar, SWT.NONE).setText('Long item to shift next one');", "      {", "        MenuItem item = new MenuItem(bar, SWT.CASCADE);", "        item.setText('Item');", "        {", "          Menu menu = new Menu(item);", "          item.setMenu(menu);", "        }", "      }", "    }", "    {", "      Menu popup = new Menu(this);", "      setMenu(popup);", "      {", "        MenuItem item_2 = new MenuItem(popup, SWT.NONE);", "        item_2.setText('Item 2');", "      }", "    }", "  }", "}");
        MenuInfo barInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        MenuInfo popupInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(1);
        MenuItemInfo itemInfo = (MenuItemInfo)barInfo.getChildrenItems().get(1);
        MenuInfo menuInfo = (MenuInfo)itemInfo.getChildren(MenuInfo.class).get(0);
        MenuItemInfo itemInfo_2 = (MenuItemInfo)popupInfo.getChildrenItems().get(0);
        GraphicalEditPart popupPart = this.canvas.getEditPart(popupInfo);
        GraphicalEditPart itemPart = this.canvas.getEditPart(itemInfo);
        this.tree.select(itemInfo_2);
        EditPart popupMenuPart = (EditPart)popupPart.getChildren().get(0);
        MenuComplexTest.assertNotNull((Object)popupMenuPart);
        GraphicalEditPart itemPart_2 = this.canvas.getEditPart(itemInfo_2);
        this.canvas.beginDrag(itemPart_2);
        this.canvas.assertNullEditPart(menuInfo);
        this.canvas.dragTo((Object)itemPart, itemPart.getFigure().getSize().width / 2, 0);
        this.menuTester.assertFeedback_selection_target(itemPart_2, itemPart);
        GraphicalEditPart menuPart = this.canvas.getEditPart(menuInfo);
        MenuComplexTest.assertNotNull((Object)menuPart);
        this.canvas.target(shellInfo).outY(-5).drag();
        this.canvas.target(menuInfo).inX(20).drag();
        this.canvas.target(menuInfo).in(20, 5).drag();
        this.menuTester.assertFeedback_selection_emptyFlow(itemPart_2, menuPart, false);
        this.canvas.endDrag();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    {", "      Menu bar = new Menu(this, SWT.BAR);", "      setMenuBar(bar);", "      new MenuItem(bar, SWT.NONE).setText(\"Long item to shift next one\");", "      {", "        MenuItem item = new MenuItem(bar, SWT.CASCADE);", "        item.setText(\"Item\");", "        {", "          Menu menu = new Menu(item);", "          item.setMenu(menu);", "          {", "            MenuItem item_2 = new MenuItem(menu, SWT.NONE);", "            item_2.setText(\"Item 2\");", "          }", "        }", "      }", "    }", "    {", "      Menu popup = new Menu(this);", "      setMenu(popup);", "    }", "  }", "}");
        MenuComplexTest.assertSame((Object)menuPart, (Object)this.canvas.getEditPart(menuInfo));
        MenuComplexTest.assertEquals((int)0, (int)popupPart.getChildren().size());
        GraphicalEditPart newItemPart_2 = this.canvas.getEditPart(itemInfo_2);
        MenuComplexTest.assertNotSame((Object)newItemPart_2, (Object)itemPart_2);
        MenuComplexTest.assertEquals((int)2, (int)newItemPart_2.getSelected());
    }

    @Test
    public void test_showOnlyOneDropDownOnCanvas() throws Exception {
        CompositeInfo shellInfo = this.openComposite("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    {", "      MenuItem item_1 = new MenuItem(bar, SWT.CASCADE);", "      item_1.setText('Item 1');", "      {", "        Menu menu_1 = new Menu(item_1);", "        item_1.setMenu(menu_1);", "      }", "    }", "    {", "      MenuItem item_2 = new MenuItem(bar, SWT.CASCADE);", "      item_2.setText('Item 2');", "    }", "  }", "}");
        MenuInfo barInfo = (MenuInfo)shellInfo.getChildren(MenuInfo.class).get(0);
        MenuItemInfo itemInfo_1 = (MenuItemInfo)barInfo.getChildrenItems().get(0);
        MenuItemInfo itemInfo_2 = (MenuItemInfo)barInfo.getChildrenItems().get(1);
        MenuInfo menuInfo_1 = itemInfo_1.getSubMenu();
        GraphicalEditPart shellPart = this.canvas.getEditPart(shellInfo);
        GraphicalEditPart itemPart_1 = this.canvas.getEditPart(itemInfo_1);
        GraphicalEditPart itemPart_2 = this.canvas.getEditPart(itemInfo_2);
        this.loadCreationTool("org.eclipse.swt.widgets.MenuItem");
        this.canvas.assertNullEditPart(menuInfo_1);
        this.canvas.moveTo((Object)itemPart_1, itemPart_1.getFigure().getSize().width / 2, 0);
        GraphicalEditPart menuPart_1 = this.canvas.getEditPart(menuInfo_1);
        MenuComplexTest.assertNotNull((Object)menuPart_1);
        this.canvas.moveTo(menuPart_1);
        MenuComplexTest.assertSame((Object)menuPart_1, (Object)this.canvas.getEditPart(menuInfo_1));
        this.canvas.moveTo((Object)shellPart, 100, 100);
        MenuComplexTest.assertSame((Object)menuPart_1, (Object)this.canvas.getEditPart(menuInfo_1));
        this.canvas.moveTo((Object)itemPart_2, itemPart_2.getFigure().getSize().width / 2, 0);
        this.canvas.assertNullEditPart(menuInfo_1);
    }
}

