/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.property;

import java.awt.Font;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.internal.swing.model.property.editor.font.DerivedFontInfo;
import org.eclipse.wb.internal.swing.model.property.editor.font.ExplicitFontInfo;
import org.eclipse.wb.internal.swing.model.property.editor.font.NullFontInfo;
import org.eclipse.wb.internal.swing.model.property.editor.font.UiManagerFontInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class FontPropertyEditorTest
extends SwingModelTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_FontInfo_Null() throws Exception {
        NullFontInfo fontInfo = new NullFontInfo();
        FontPropertyEditorTest.assertSame(null, (Object)fontInfo.getFont());
        FontPropertyEditorTest.assertEquals(null, (Object)fontInfo.getText());
        FontPropertyEditorTest.assertEquals((Object)"null", (Object)fontInfo.getSource());
    }

    @Test
    public void test_FontInfo_Explicit() throws Exception {
        Font font = new Font("Arial", 0, 12);
        ExplicitFontInfo fontInfo = new ExplicitFontInfo(font);
        FontPropertyEditorTest.assertSame((Object)font, (Object)fontInfo.getFont());
        Assertions.assertThat((String)fontInfo.getText()).matches((CharSequence)"\\w+ 12");
        Assertions.assertThat((String)fontInfo.getSource()).matches((CharSequence)"new java.awt.Font\\(\"\\w+\", java.awt.Font.PLAIN, 12\\)");
        FontPropertyEditorTest.assertEquals((Object)fontInfo.getSource(), (Object)fontInfo.getClipboardSource());
        font = new Font("Arial", 1, 12);
        fontInfo = new ExplicitFontInfo(font);
        FontPropertyEditorTest.assertSame((Object)font, (Object)fontInfo.getFont());
        Assertions.assertThat((String)fontInfo.getText()).matches((CharSequence)"\\w+ 12 Bold");
        Assertions.assertThat((String)fontInfo.getSource()).matches((CharSequence)"new java.awt.Font\\(\"\\w+\", java.awt.Font.BOLD, 12\\)");
        FontPropertyEditorTest.assertEquals((Object)fontInfo.getSource(), (Object)fontInfo.getClipboardSource());
        font = new Font("Arial", 2, 12);
        fontInfo = new ExplicitFontInfo(font);
        FontPropertyEditorTest.assertSame((Object)font, (Object)fontInfo.getFont());
        Assertions.assertThat((String)fontInfo.getText()).matches((CharSequence)"\\w+ 12 Italic");
        Assertions.assertThat((String)fontInfo.getSource()).matches((CharSequence)"new java.awt.Font\\(\"\\w+\", java.awt.Font.ITALIC, 12\\)");
        FontPropertyEditorTest.assertEquals((Object)fontInfo.getSource(), (Object)fontInfo.getClipboardSource());
        font = new Font("Arial", 3, 12);
        fontInfo = new ExplicitFontInfo(font);
        FontPropertyEditorTest.assertSame((Object)font, (Object)fontInfo.getFont());
        Assertions.assertThat((String)fontInfo.getText()).matches((CharSequence)"\\w+ 12 Bold Italic");
        Assertions.assertThat((String)fontInfo.getSource()).matches((CharSequence)"new java.awt.Font\\(\"\\w+\", java.awt.Font.BOLD \\| java.awt.Font.ITALIC, 12\\)");
        FontPropertyEditorTest.assertEquals((Object)fontInfo.getSource(), (Object)fontInfo.getClipboardSource());
    }

    @Test
    public void test_FontInfo_UIManager() throws Exception {
        Font font = new Font("Arial", 0, 12);
        UiManagerFontInfo fontInfo = new UiManagerFontInfo("key", font);
        FontPropertyEditorTest.assertSame((Object)font, (Object)fontInfo.getFont());
        FontPropertyEditorTest.assertEquals((Object)"key", (Object)fontInfo.getKey());
        Assertions.assertThat((String)fontInfo.getValueText()).matches((CharSequence)"\\w+ 12");
        Assertions.assertThat((String)fontInfo.getText()).matches((CharSequence)"key, \\w+ 12");
        FontPropertyEditorTest.assertEquals((Object)"javax.swing.UIManager.getFont(\"key\")", (Object)fontInfo.getSource());
        FontPropertyEditorTest.assertEquals((Object)fontInfo.getSource(), (Object)fontInfo.getClipboardSource());
    }

    @Test
    public void test_FontInfo_Derived() throws Exception {
        Font baseFont = new Font("Arial", 1, 12);
        String baseFontSource = "button.getFont()";
        String baseFontClipboardSource = "%this%.getFont()";
        DerivedFontInfo fontInfo = new DerivedFontInfo(baseFont, baseFontSource, baseFontClipboardSource, null, null, null, null, null);
        Font font = fontInfo.getFont();
        FontPropertyEditorTest.assertEquals((int)1, (int)font.getStyle());
        FontPropertyEditorTest.assertEquals((int)12, (int)font.getSize());
        if (EnvironmentUtils.IS_WINDOWS) {
            FontPropertyEditorTest.assertEquals((Object)"Arial", (Object)font.getFamily());
            FontPropertyEditorTest.assertEquals((Object)"<no changes>, Arial 12 Bold", (Object)fontInfo.getText());
        }
        FontPropertyEditorTest.assertNull((Object)fontInfo.getSource());
        FontPropertyEditorTest.assertNull((Object)fontInfo.getClipboardSource());
        fontInfo = new DerivedFontInfo(baseFont, baseFontSource, baseFontClipboardSource, "Tahoma", null, null, null, null);
        font = fontInfo.getFont();
        FontPropertyEditorTest.assertEquals((int)1, (int)font.getStyle());
        FontPropertyEditorTest.assertEquals((int)12, (int)font.getSize());
        if (EnvironmentUtils.IS_WINDOWS) {
            FontPropertyEditorTest.assertEquals((Object)"Tahoma", (Object)font.getFamily());
            FontPropertyEditorTest.assertEquals((Object)"*Tahoma, Tahoma 12 Bold", (Object)fontInfo.getText());
            FontPropertyEditorTest.assertEquals((Object)"new java.awt.Font(\"Tahoma\", button.getFont().getStyle(), button.getFont().getSize())", (Object)fontInfo.getSource());
            FontPropertyEditorTest.assertEquals((Object)"new java.awt.Font(\"Tahoma\", %this%.getFont().getStyle(), %this%.getFont().getSize())", (Object)fontInfo.getClipboardSource());
        }
        fontInfo = new DerivedFontInfo(baseFont, baseFontSource, baseFontClipboardSource, "Tahoma", null, null, Integer.valueOf(5), null);
        font = fontInfo.getFont();
        FontPropertyEditorTest.assertEquals((int)1, (int)font.getStyle());
        FontPropertyEditorTest.assertEquals((int)17, (int)font.getSize());
        if (EnvironmentUtils.IS_WINDOWS) {
            FontPropertyEditorTest.assertEquals((Object)"Tahoma", (Object)font.getFamily());
            FontPropertyEditorTest.assertEquals((Object)"*Tahoma +5, Tahoma 17 Bold", (Object)fontInfo.getText());
            FontPropertyEditorTest.assertEquals((Object)"new java.awt.Font(\"Tahoma\", button.getFont().getStyle(), button.getFont().getSize() + 5)", (Object)fontInfo.getSource());
            FontPropertyEditorTest.assertEquals((Object)"new java.awt.Font(\"Tahoma\", %this%.getFont().getStyle(), %this%.getFont().getSize() + 5)", (Object)fontInfo.getClipboardSource());
        }
        fontInfo = new DerivedFontInfo(baseFont, baseFontSource, baseFontClipboardSource, "Tahoma", null, null, null, Integer.valueOf(20));
        font = fontInfo.getFont();
        FontPropertyEditorTest.assertEquals((int)1, (int)font.getStyle());
        FontPropertyEditorTest.assertEquals((int)20, (int)font.getSize());
        if (EnvironmentUtils.IS_WINDOWS) {
            FontPropertyEditorTest.assertEquals((Object)"Tahoma", (Object)font.getFamily());
            FontPropertyEditorTest.assertEquals((Object)"*Tahoma 20, Tahoma 20 Bold", (Object)fontInfo.getText());
            FontPropertyEditorTest.assertEquals((Object)"new java.awt.Font(\"Tahoma\", button.getFont().getStyle(), 20)", (Object)fontInfo.getSource());
        }
        fontInfo = new DerivedFontInfo(baseFont, baseFontSource, baseFontClipboardSource, null, Boolean.TRUE, null, null, null);
        font = fontInfo.getFont();
        FontPropertyEditorTest.assertEquals((int)1, (int)font.getStyle());
        FontPropertyEditorTest.assertEquals((int)12, (int)font.getSize());
        if (EnvironmentUtils.IS_WINDOWS) {
            FontPropertyEditorTest.assertEquals((Object)"Arial", (Object)font.getFamily());
            FontPropertyEditorTest.assertEquals((Object)"+Bold, Arial 12 Bold", (Object)fontInfo.getText());
            FontPropertyEditorTest.assertEquals((Object)"button.getFont().deriveFont(button.getFont().getStyle() | java.awt.Font.BOLD)", (Object)fontInfo.getSource());
        }
        fontInfo = new DerivedFontInfo(baseFont, baseFontSource, baseFontClipboardSource, null, Boolean.FALSE, null, null, null);
        font = fontInfo.getFont();
        FontPropertyEditorTest.assertEquals((int)0, (int)font.getStyle());
        FontPropertyEditorTest.assertEquals((int)12, (int)font.getSize());
        if (EnvironmentUtils.IS_WINDOWS) {
            FontPropertyEditorTest.assertEquals((Object)"Arial", (Object)font.getFamily());
            FontPropertyEditorTest.assertEquals((Object)"-Bold, Arial 12", (Object)fontInfo.getText());
            FontPropertyEditorTest.assertEquals((Object)"button.getFont().deriveFont(button.getFont().getStyle() & ~java.awt.Font.BOLD)", (Object)fontInfo.getSource());
        }
        fontInfo = new DerivedFontInfo(baseFont, baseFontSource, baseFontClipboardSource, null, null, Boolean.TRUE, null, null);
        font = fontInfo.getFont();
        FontPropertyEditorTest.assertEquals((int)3, (int)font.getStyle());
        FontPropertyEditorTest.assertEquals((int)12, (int)font.getSize());
        if (EnvironmentUtils.IS_WINDOWS) {
            FontPropertyEditorTest.assertEquals((Object)"Arial", (Object)font.getFamily());
            FontPropertyEditorTest.assertEquals((Object)"+Italic, Arial 12 Bold Italic", (Object)fontInfo.getText());
            FontPropertyEditorTest.assertEquals((Object)"button.getFont().deriveFont(button.getFont().getStyle() | java.awt.Font.ITALIC)", (Object)fontInfo.getSource());
        }
        fontInfo = new DerivedFontInfo(baseFont, baseFontSource, baseFontClipboardSource, null, null, Boolean.FALSE, null, null);
        font = fontInfo.getFont();
        FontPropertyEditorTest.assertEquals((int)1, (int)font.getStyle());
        FontPropertyEditorTest.assertEquals((int)12, (int)font.getSize());
        if (EnvironmentUtils.IS_WINDOWS) {
            FontPropertyEditorTest.assertEquals((Object)"Arial", (Object)font.getFamily());
            FontPropertyEditorTest.assertEquals((Object)"-Italic, Arial 12 Bold", (Object)fontInfo.getText());
        }
        FontPropertyEditorTest.assertEquals((Object)"button.getFont().deriveFont(button.getFont().getStyle() & ~java.awt.Font.ITALIC)", (Object)fontInfo.getSource());
        fontInfo = new DerivedFontInfo(baseFont, baseFontSource, baseFontClipboardSource, null, Boolean.TRUE, Boolean.TRUE, null, null);
        font = fontInfo.getFont();
        FontPropertyEditorTest.assertEquals((int)3, (int)font.getStyle());
        FontPropertyEditorTest.assertEquals((int)12, (int)font.getSize());
        if (EnvironmentUtils.IS_WINDOWS) {
            FontPropertyEditorTest.assertEquals((Object)"Arial", (Object)font.getFamily());
            FontPropertyEditorTest.assertEquals((Object)"+Bold +Italic, Arial 12 Bold Italic", (Object)fontInfo.getText());
        }
        FontPropertyEditorTest.assertEquals((Object)"button.getFont().deriveFont(button.getFont().getStyle() | java.awt.Font.BOLD | java.awt.Font.ITALIC)", (Object)fontInfo.getSource());
        fontInfo = new DerivedFontInfo(baseFont, baseFontSource, baseFontClipboardSource, null, Boolean.FALSE, Boolean.TRUE, null, null);
        font = fontInfo.getFont();
        FontPropertyEditorTest.assertEquals((int)2, (int)font.getStyle());
        FontPropertyEditorTest.assertEquals((int)12, (int)font.getSize());
        if (EnvironmentUtils.IS_WINDOWS) {
            FontPropertyEditorTest.assertEquals((Object)"Arial", (Object)font.getFamily());
            FontPropertyEditorTest.assertEquals((Object)"-Bold +Italic, Arial 12 Italic", (Object)fontInfo.getText());
        }
        FontPropertyEditorTest.assertEquals((Object)"button.getFont().deriveFont(button.getFont().getStyle() & ~java.awt.Font.BOLD | java.awt.Font.ITALIC)", (Object)fontInfo.getSource());
        fontInfo = new DerivedFontInfo(baseFont, baseFontSource, baseFontClipboardSource, null, Boolean.TRUE, Boolean.FALSE, null, null);
        font = fontInfo.getFont();
        FontPropertyEditorTest.assertEquals((int)1, (int)font.getStyle());
        FontPropertyEditorTest.assertEquals((int)12, (int)font.getSize());
        if (EnvironmentUtils.IS_WINDOWS) {
            FontPropertyEditorTest.assertEquals((Object)"Arial", (Object)font.getFamily());
            FontPropertyEditorTest.assertEquals((Object)"+Bold -Italic, Arial 12 Bold", (Object)fontInfo.getText());
        }
        FontPropertyEditorTest.assertEquals((Object)"button.getFont().deriveFont(button.getFont().getStyle() & ~java.awt.Font.ITALIC | java.awt.Font.BOLD)", (Object)fontInfo.getSource());
        fontInfo = new DerivedFontInfo(baseFont, baseFontSource, baseFontClipboardSource, null, Boolean.FALSE, Boolean.FALSE, null, null);
        font = fontInfo.getFont();
        FontPropertyEditorTest.assertEquals((int)0, (int)font.getStyle());
        FontPropertyEditorTest.assertEquals((int)12, (int)font.getSize());
        if (EnvironmentUtils.IS_WINDOWS) {
            FontPropertyEditorTest.assertEquals((Object)"Arial", (Object)font.getFamily());
            FontPropertyEditorTest.assertEquals((Object)"-Bold -Italic, Arial 12", (Object)fontInfo.getText());
        }
        FontPropertyEditorTest.assertEquals((Object)"button.getFont().deriveFont(button.getFont().getStyle() & ~java.awt.Font.BOLD & ~java.awt.Font.ITALIC)", (Object)fontInfo.getSource());
        fontInfo = new DerivedFontInfo(baseFont, baseFontSource, baseFontClipboardSource, null, null, null, Integer.valueOf(5), null);
        font = fontInfo.getFont();
        FontPropertyEditorTest.assertEquals((int)1, (int)font.getStyle());
        FontPropertyEditorTest.assertEquals((int)17, (int)font.getSize());
        if (EnvironmentUtils.IS_WINDOWS) {
            FontPropertyEditorTest.assertEquals((Object)"Arial", (Object)font.getFamily());
            FontPropertyEditorTest.assertEquals((Object)"+5, Arial 17 Bold", (Object)fontInfo.getText());
        }
        FontPropertyEditorTest.assertEquals((Object)"button.getFont().deriveFont(button.getFont().getSize() + 5f)", (Object)fontInfo.getSource());
        fontInfo = new DerivedFontInfo(baseFont, baseFontSource, baseFontClipboardSource, null, null, null, Integer.valueOf(-5), null);
        font = fontInfo.getFont();
        FontPropertyEditorTest.assertEquals((int)1, (int)font.getStyle());
        FontPropertyEditorTest.assertEquals((int)7, (int)font.getSize());
        if (EnvironmentUtils.IS_WINDOWS) {
            FontPropertyEditorTest.assertEquals((Object)"Arial", (Object)font.getFamily());
            FontPropertyEditorTest.assertEquals((Object)"-5, Arial 7 Bold", (Object)fontInfo.getText());
        }
        FontPropertyEditorTest.assertEquals((Object)"button.getFont().deriveFont(button.getFont().getSize() - 5f)", (Object)fontInfo.getSource());
        fontInfo = new DerivedFontInfo(baseFont, baseFontSource, baseFontClipboardSource, null, null, null, null, Integer.valueOf(20));
        font = fontInfo.getFont();
        FontPropertyEditorTest.assertEquals((int)1, (int)font.getStyle());
        FontPropertyEditorTest.assertEquals((int)20, (int)font.getSize());
        if (EnvironmentUtils.IS_WINDOWS) {
            FontPropertyEditorTest.assertEquals((Object)"Arial", (Object)font.getFamily());
            FontPropertyEditorTest.assertEquals((Object)"20, Arial 20 Bold", (Object)fontInfo.getText());
        }
        FontPropertyEditorTest.assertEquals((Object)"button.getFont().deriveFont(20f)", (Object)fontInfo.getSource());
        fontInfo = new DerivedFontInfo(baseFont, baseFontSource, baseFontClipboardSource, null, Boolean.FALSE, null, null, Integer.valueOf(20));
        font = fontInfo.getFont();
        FontPropertyEditorTest.assertEquals((int)0, (int)font.getStyle());
        FontPropertyEditorTest.assertEquals((int)20, (int)font.getSize());
        if (EnvironmentUtils.IS_WINDOWS) {
            FontPropertyEditorTest.assertEquals((Object)"Arial", (Object)font.getFamily());
            FontPropertyEditorTest.assertEquals((Object)"20 -Bold, Arial 20", (Object)fontInfo.getText());
        }
        FontPropertyEditorTest.assertEquals((Object)"button.getFont().deriveFont(button.getFont().getStyle() & ~java.awt.Font.BOLD, 20f)", (Object)fontInfo.getSource());
        fontInfo = new DerivedFontInfo(baseFont, baseFontSource, baseFontClipboardSource, null, null, Boolean.FALSE, null, Integer.valueOf(20));
        font = fontInfo.getFont();
        FontPropertyEditorTest.assertEquals((int)1, (int)font.getStyle());
        FontPropertyEditorTest.assertEquals((int)20, (int)font.getSize());
        if (EnvironmentUtils.IS_WINDOWS) {
            FontPropertyEditorTest.assertEquals((Object)"Arial", (Object)font.getFamily());
            FontPropertyEditorTest.assertEquals((Object)"20 -Italic, Arial 20 Bold", (Object)fontInfo.getText());
        }
        FontPropertyEditorTest.assertEquals((Object)"button.getFont().deriveFont(button.getFont().getStyle() & ~java.awt.Font.ITALIC, 20f)", (Object)fontInfo.getSource());
    }

    @Test
    public void test_decodeFontInfo_null() throws Exception {
        String text = null;
        String source = "null";
        this.assertFont(source, text);
    }

    @Test
    public void test_decodeFontInfo_explicit() throws Exception {
        String text = "Arial 15 Bold Italic";
        String source = "new Font(\"Arial\", Font.BOLD | Font.ITALIC, 15)";
        String clipboard = "new java.awt.Font(\"Arial\", java.awt.Font.BOLD | java.awt.Font.ITALIC, 15)";
        this.assertFont(source, text, clipboard);
    }

    @Test
    public void test_decodeFontInfo_UIManager() throws Exception {
        String text = "Button.font, Dialog 12 Bold";
        String source = "javax.swing.UIManager.getFont(\"Button.font\")";
        this.assertFont(source, text);
    }

    @Test
    public void test_decodeFontInfo_derived_newSize() throws Exception {
        String text = "20, Dialog 20 Bold";
        String source = "button.getFont().deriveFont(20f)";
        this.assertFont2(source, text);
    }

    @Test
    public void test_decodeFontInfo_derived_plusSize() throws Exception {
        String text = "+5, Dialog 17 Bold";
        String source = "button.getFont().deriveFont(button.getFont().getSize() + 5f)";
        this.assertFont2(source, text);
    }

    @Test
    public void test_decodeFontInfo_derived_minusSize() throws Exception {
        String text = "-5, Dialog 7 Bold";
        String source = "button.getFont().deriveFont(button.getFont().getSize() - 5f)";
        this.assertFont2(source, text);
    }

    @Test
    public void test_decodeFontInfo_derived_unknownSize() throws Exception {
        String text = "15, Dialog 15 Bold";
        String source = "button.getFont().deriveFont(5f + 10f)";
        String clipboardSource = "%this%.getFont().deriveFont(15f)";
        this.assertFont(source, text, clipboardSource);
    }

    @Test
    public void test_decodeFontInfo_derived_plusBold() throws Exception {
        String text = "+Bold, Dialog 12 Bold";
        String source = "button.getFont().deriveFont(button.getFont().getStyle() | java.awt.Font.BOLD)";
        this.assertFont2(source, text);
    }

    @Test
    public void test_decodeFontInfo_derived_plusItalic() throws Exception {
        String text = "+Italic, Dialog 12 Bold Italic";
        String source = "button.getFont().deriveFont(button.getFont().getStyle() | java.awt.Font.ITALIC)";
        this.assertFont2(source, text);
    }

    @Test
    public void test_decodeFontInfo_derived_plusBoldItalic() throws Exception {
        String text = "+Bold +Italic, Dialog 12 Bold Italic";
        String source = "button.getFont().deriveFont(button.getFont().getStyle() | java.awt.Font.BOLD | java.awt.Font.ITALIC)";
        this.assertFont2(source, text);
    }

    @Test
    public void test_decodeFontInfo_derived_minusBold() throws Exception {
        String text = "-Bold, Dialog 12";
        String source = "button.getFont().deriveFont(button.getFont().getStyle() & ~java.awt.Font.BOLD)";
        this.assertFont2(source, text);
    }

    @Test
    public void test_decodeFontInfo_derived_minusItalic() throws Exception {
        String text = "-Italic, Dialog 12 Bold";
        String source = "button.getFont().deriveFont(button.getFont().getStyle() & ~java.awt.Font.ITALIC)";
        this.assertFont2(source, text);
    }

    @Test
    public void test_decodeFontInfo_derived_minusBoldItalic() throws Exception {
        String text = "-Bold -Italic, Dialog 12";
        String source = "button.getFont().deriveFont(button.getFont().getStyle() & ~java.awt.Font.BOLD & ~java.awt.Font.ITALIC)";
        this.assertFont2(source, text);
    }

    @Test
    public void test_decodeFontInfo_derived_minusBold_plusItalic() throws Exception {
        String text = "-Bold +Italic, Dialog 12 Italic";
        String source = "button.getFont().deriveFont(button.getFont().getStyle() & ~java.awt.Font.BOLD | java.awt.Font.ITALIC)";
        this.assertFont2(source, text);
    }

    @Test
    public void test_decodeFontInfo_derived_plusBold_minusItalic() throws Exception {
        String text = "+Bold -Italic, Dialog 12 Bold";
        String source = "button.getFont().deriveFont(button.getFont().getStyle() & ~java.awt.Font.ITALIC | java.awt.Font.BOLD)";
        this.assertFont2(source, text);
    }

    @Test
    public void test_decodeFontInfo_derived_minusBold_plusSize() throws Exception {
        String text = "+5 -Bold, Dialog 17";
        String source = "button.getFont().deriveFont(button.getFont().getStyle() & ~java.awt.Font.BOLD, button.getFont().getSize() + 5f)";
        this.assertFont2(source, text);
    }

    @Test
    public void test_decodeFontInfo_derived_newFamily() throws Exception {
        String text = "*Arial +5 -Bold, Arial 17";
        String source = "new java.awt.Font(\"Arial\", button.getFont().getStyle() & ~java.awt.Font.BOLD, button.getFont().getSize() + 5)";
        String clipboardSource = null;
        this.assertFont(source, text, clipboardSource);
    }

    private void assertFont2(String fontSource, String expectedText) throws Exception {
        String expectedClipboard = StringUtils.replace((String)fontSource, (String)"button.", (String)"%this%.");
        this.assertFont(fontSource, expectedText, expectedClipboard);
    }

    private void assertFont(String fontSource, String expectedText) throws Exception {
        this.assertFont(fontSource, expectedText, fontSource);
    }

    private void assertFont(String fontSource, String expectedText, String expectedClipboard) throws Exception {
        Object fontLine = fontSource != null ? "    button.setFont(" + fontSource + ");" : "";
        ContainerInfo panel = this.parseContainer(new String[]{"public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", fontLine, "    add(button);", "  }", "}"});
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property property = button.getPropertyByTitle("font");
        if (EnvironmentUtils.IS_WINDOWS) {
            FontPropertyEditorTest.assertEquals((Object)expectedText, (Object)FontPropertyEditorTest.getPropertyText(property));
        }
        GenericPropertyImpl genericProperty = (GenericPropertyImpl)property;
        String actualClipboard = genericProperty.getClipboardSource();
        if (EnvironmentUtils.IS_WINDOWS) {
            FontPropertyEditorTest.assertEquals((Object)expectedClipboard, (Object)actualClipboard);
        }
    }

    @Test
    public void test_copyPaste_null() throws Exception {
        String originalSource;
        String expectedSource = originalSource = "null";
        this.check_copyPaste(originalSource, expectedSource);
    }

    @Disabled
    @Test
    public void test_copyPaste_explicit() throws Exception {
        String originalSource;
        String expectedSource = originalSource = "new Font(\"Arial\", Font.BOLD | Font.ITALIC, 15)";
        this.check_copyPaste(originalSource, expectedSource);
    }

    @Test
    public void test_copyPaste_derived() throws Exception {
        String originalSource;
        String expectedSource = originalSource = "myLabel.getFont().deriveFont(20f)";
        this.check_copyPaste(originalSource, expectedSource);
    }

    private void check_copyPaste(String originalSource, String expectedSource) throws Exception {
        String[] lines1 = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      JLabel myLabel = new JLabel();", "      myLabel.setFont(" + originalSource + ");", "      add(myLabel);", "    }", "  }", "}"};
        ContainerInfo panel = this.parseContainer(lines1);
        panel.refresh();
        ComponentInfo label = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)label);
        ComponentInfo newLabel = (ComponentInfo)memento.create((JavaInfo)panel);
        ((FlowLayoutInfo)panel.getLayout()).add(newLabel, null);
        memento.apply();
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      JLabel myLabel = new JLabel();", "      myLabel.setFont(" + originalSource + ");", "      add(myLabel);", "    }", "    {", "      JLabel myLabel = new JLabel();", "      myLabel.setFont(" + expectedSource + ");", "      add(myLabel);", "    }", "  }", "}"};
        this.assertEditor(lines);
    }
}

