/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout;

import java.awt.GridLayout;
import java.util.List;
import javax.swing.JButton;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildAddAfter;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.generation.statement.StatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.generation.statement.block.BlockStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.generation.statement.flat.FlatStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.generation.statement.lazy.LazyStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.variable.description.FieldInitializerVariableDescription;
import org.eclipse.wb.internal.core.model.variable.description.FieldUniqueVariableDescription;
import org.eclipse.wb.internal.core.model.variable.description.LazyVariableDescription;
import org.eclipse.wb.internal.core.model.variable.description.LocalUniqueVariableDescription;
import org.eclipse.wb.internal.core.model.variable.description.VariableSupportDescription;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swing.Activator;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.BorderLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.GridLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingTestUtils;
import org.eclipse.wb.tests.designer.swing.model.layout.AbstractLayoutTest;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class LayoutManagersTest
extends AbstractLayoutTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_isActive() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        LayoutInfo oldLayout = panel.getLayout();
        LayoutManagersTest.assertTrue((boolean)oldLayout.isActive());
        LayoutInfo newLayout = (LayoutInfo)LayoutManagersTest.createJavaInfo("java.awt.BorderLayout");
        panel.setLayout(newLayout);
        LayoutManagersTest.assertFalse((boolean)oldLayout.isActive());
        LayoutManagersTest.assertTrue((boolean)newLayout.isActive());
        newLayout.delete();
        LayoutManagersTest.assertTrue((boolean)oldLayout.isActive());
        LayoutManagersTest.assertFalse((boolean)newLayout.isActive());
    }

    @Test
    public void test_isActive_forDisconnected() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        LayoutInfo newLayout = (LayoutInfo)LayoutManagersTest.createJavaInfo("java.awt.FlowLayout");
        LayoutManagersTest.assertFalse((boolean)newLayout.isActive());
    }

    @Test
    public void test_getComponents() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        LayoutInfo layout = panel.getLayout();
        ComponentInfo button = (ComponentInfo)LayoutManagersTest.getJavaInfoByName("button");
        Assertions.assertThat((List)layout.getComponents()).containsExactly((Object[])new ComponentInfo[]{button});
    }

    @Test
    public void test_getComponents_ifNotActive() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)LayoutManagersTest.getJavaInfoByName("button");
        LayoutInfo oldLayout = panel.getLayout();
        LayoutInfo newLayout = (LayoutInfo)LayoutManagersTest.createJavaInfo("java.awt.BorderLayout");
        panel.setLayout(newLayout);
        LayoutManagersTest.assertFalse((boolean)oldLayout.isActive());
        LayoutManagersTest.assertTrue((boolean)newLayout.isActive());
        Assertions.assertThat((List)oldLayout.getComponents()).isEmpty();
        Assertions.assertThat((List)newLayout.getComponents()).containsExactly((Object[])new ComponentInfo[]{button});
    }

    @Test
    public void test_isManagedObject_simpleFalse() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        LayoutInfo layout = panel.getLayout();
        Object newObject = LayoutManagersTest.createJavaInfo("java.lang.Object");
        LayoutManagersTest.assertFalse((boolean)layout.isManagedObject(newObject));
        newObject = LayoutManagersTest.createJButton();
        LayoutManagersTest.assertFalse((boolean)layout.isManagedObject(newObject));
    }

    @Test
    public void test_isManagedObject_simpleTrue() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        LayoutInfo layout = panel.getLayout();
        ComponentInfo button = (ComponentInfo)LayoutManagersTest.getJavaInfoByName("button");
        LayoutManagersTest.assertTrue((boolean)layout.isManagedObject((Object)button));
    }

    @Test
    public void test_isManagedObject_falseBecauseNotActive() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)LayoutManagersTest.getJavaInfoByName("button");
        LayoutInfo oldLayout = panel.getLayout();
        LayoutInfo newLayout = (LayoutInfo)LayoutManagersTest.createJavaInfo("java.awt.BorderLayout");
        panel.setLayout(newLayout);
        LayoutManagersTest.assertFalse((boolean)oldLayout.isActive());
        LayoutManagersTest.assertTrue((boolean)newLayout.isActive());
        LayoutManagersTest.assertFalse((boolean)oldLayout.isManagedObject((Object)button));
        LayoutManagersTest.assertTrue((boolean)newLayout.isManagedObject((Object)button));
    }

    @Test
    public void test_isManagedObject_falseBecauseIndirectlyExposed() throws Exception {
        LayoutManagersTest.setFileContentSrc("test/Super.java", this.getTestSource("public class Super extends JPanel {", "  private JPanel panel = new JPanel();", "  private JButton button = new JButton();", "  public Super() {", "    setLayout(new GridBagLayout());", "    add(panel);", "    panel.add(button);", "  }", "  public JButton getButton() {", "    return button;", "  }", "}"));
        LayoutManagersTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends Super {", "  public Test() {", "  }", "}");
        ComponentInfo button = (ComponentInfo)LayoutManagersTest.getJavaInfoByName("getButton()");
        LayoutManagersTest.assertNotNull((Object)button);
        LayoutInfo layout = panel.getLayout();
        LayoutManagersTest.assertFalse((boolean)layout.isManagedObject((Object)button));
    }

    @Test
    public void test_3_BorderLayout_add_1_local_flat() throws Exception {
        String[] initialLines = new String[]{"class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    panel.setLayout(new BorderLayout());", "  }", "}"};
        String[] expectedLines = new String[]{"class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    panel.setLayout(new BorderLayout());", "    ", "    JButton button = new JButton(\"New button\");", "    panel.add(button, BorderLayout.NORTH);", "  }", "}"};
        this.check_BorderLayout_add(initialLines, LocalUniqueVariableDescription.INSTANCE, FlatStatementGeneratorDescription.INSTANCE, expectedLines, new String[]{"new JButton(\"New button\")", "panel.add(button, BorderLayout.NORTH)"}, new String[]{"new JPanel()", "panel.setLayout(new BorderLayout())", "panel.add(button, BorderLayout.NORTH)"});
    }

    @Test
    public void test_2_BorderLayout() throws Exception {
        ContainerInfo panel = (ContainerInfo)this.parseSource("test", "Test.java", LayoutManagersTest.getSourceDQ("package test;", "import java.awt.*;", "import javax.swing.*;", "class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    panel.setLayout(new BorderLayout());", "  }", "}"));
        LayoutManagersTest.assertEquals((int)1, (int)panel.getChildren().size());
        LayoutManagersTest.assertSame(BorderLayoutInfo.class, ((ObjectInfo)panel.getChildren().get(0)).getClass());
        LayoutManagersTest.assertSame((Object)panel.getLayout(), panel.getChildren().get(0));
    }

    @Test
    public void test_3_BorderLayout_add_2_field_flat() throws Exception {
        String[] initialLines = new String[]{"class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    panel.setLayout(new BorderLayout());", "  }", "}"};
        String[] expectedLines = new String[]{"class Test {", "  private static JButton button;", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    panel.setLayout(new BorderLayout());", "    ", "    button = new JButton(\"New button\");", "    panel.add(button, BorderLayout.NORTH);", "  }", "}"};
        this.check_BorderLayout_add(initialLines, FieldUniqueVariableDescription.INSTANCE, FlatStatementGeneratorDescription.INSTANCE, expectedLines, new String[]{"new JButton(\"New button\")", "panel.add(button, BorderLayout.NORTH)"}, new String[]{"new JPanel()", "panel.setLayout(new BorderLayout())", "panel.add(button, BorderLayout.NORTH)"});
    }

    @Test
    public void test_3_BorderLayout_add_fieldInitializer_flat() throws Exception {
        String[] initialLines = new String[]{"class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    panel.setLayout(new BorderLayout());", "  }", "}"};
        String[] expectedLines = new String[]{"class Test {", "  private static final JButton button = new JButton(\"New button\");", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    panel.setLayout(new BorderLayout());", "    ", "    panel.add(button, BorderLayout.NORTH);", "  }", "}"};
        this.check_BorderLayout_add(initialLines, FieldInitializerVariableDescription.INSTANCE, FlatStatementGeneratorDescription.INSTANCE, expectedLines, new String[]{"new JButton(\"New button\")", "panel.add(button, BorderLayout.NORTH)"}, new String[]{"new JPanel()", "panel.setLayout(new BorderLayout())", "panel.add(button, BorderLayout.NORTH)"});
    }

    @Test
    public void test_3_BorderLayout_add_4_local_block() throws Exception {
        String[] initialLines = new String[]{"class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    panel.setLayout(new BorderLayout());", "  }", "}"};
        String[] expectedLines = new String[]{"class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    panel.setLayout(new BorderLayout());", "    {", "      JButton button = new JButton(\"New button\");", "      panel.add(button, BorderLayout.NORTH);", "    }", "  }", "}"};
        this.check_BorderLayout_add(initialLines, LocalUniqueVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE, expectedLines, new String[]{"new JButton(\"New button\")", "panel.add(button, BorderLayout.NORTH)"}, new String[]{"new JPanel()", "panel.setLayout(new BorderLayout())", "panel.add(button, BorderLayout.NORTH)"});
    }

    @Test
    public void test_3_BorderLayout_add_5_lazy() throws Exception {
        String[] initialLines = new String[]{"class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    panel.setLayout(new BorderLayout());", "  }", "}"};
        String[] expectedLines = new String[]{"class Test {", "  private static JButton button;", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    panel.setLayout(new BorderLayout());", "    panel.add(getButton(), BorderLayout.NORTH);", "  }", "  private static JButton getButton() {", "    if (button == null) {", "      button = new JButton(\"New button\");", "    }", "    return button;", "  }", "}"};
        ContainerInfo panel = this.check_BorderLayout_add(initialLines, LazyVariableDescription.INSTANCE, LazyStatementGeneratorDescription.INSTANCE, expectedLines, new String[]{"new JButton(\"New button\")", "panel.add(getButton(), BorderLayout.NORTH)"}, new String[]{"new JPanel()", "panel.setLayout(new BorderLayout())", "panel.add(getButton(), BorderLayout.NORTH)"});
        LayoutManagersTest.assert_creation((JavaInfo)panel);
    }

    private ContainerInfo check_BorderLayout_add(String[] initialLines, VariableSupportDescription variable, StatementGeneratorDescription statement, String[] expectedLines, String[] expectedChildNodes, String[] expectedParentNodes) throws Exception {
        ContainerInfo panel = this.parseContainer(initialLines);
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getChildren().get(0);
        LayoutManagersTest.assertEquals((int)0, (int)panel.getChildrenComponents().size());
        ComponentInfo newComponent = (ComponentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, JButton.class, (CreationSupport)new ConstructorCreationSupport());
        SwingTestUtils.setGenerations(variable, statement);
        try {
            layout.command_CREATE(newComponent, "North");
        }
        finally {
            SwingTestUtils.setGenerationDefaults();
        }
        LayoutManagersTest.assertEquals((Object)this.getTestSource(expectedLines), (Object)this.m_lastEditor.getSource());
        LayoutManagersTest.assertAST(this.m_lastEditor);
        LayoutManagersTest.assertEquals((int)1, (int)panel.getChildrenComponents().size());
        LayoutManagersTest.assertSame((Object)newComponent, panel.getChildrenComponents().get(0));
        LayoutManagersTest.assertSame((Object)panel, (Object)newComponent.getParent());
        LayoutManagersTest.assertRelatedNodes((JavaInfo)newComponent, expectedChildNodes);
        LayoutManagersTest.assertRelatedNodes((JavaInfo)panel, expectedParentNodes);
        return panel;
    }

    @Test
    public void test_getPresentation() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        LayoutInfo layout = panel.getLayout();
        LayoutManagersTest.assertVisible((ObjectInfo)layout, false);
    }

    @Test
    public void test_delete() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new java.awt.BorderLayout());", "  }", "}");
        LayoutInfo layout = panel.getLayout();
        LayoutManagersTest.assertTrue((boolean)(layout instanceof BorderLayoutInfo));
        layout.delete();
        layout = panel.getLayout();
        LayoutManagersTest.assertTrue((boolean)(layout instanceof FlowLayoutInfo));
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Disabled
    @Test
    public void test_delete2() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new java.awt.BorderLayout());", "  }", "}");
        Property layoutProperty = panel.getPropertyByTitle("Layout");
        layoutProperty.setValue(Property.UNKNOWN_VALUE);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_replace() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        LayoutManagersTest.assertInstanceOf(FlowLayoutInfo.class, (Object)panel.getLayout());
        LayoutInfo gridLayout = (LayoutInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, GridLayout.class, (CreationSupport)new ConstructorCreationSupport());
        panel.setLayout(gridLayout);
        LayoutManagersTest.assertInstanceOf(GridLayoutInfo.class, (Object)panel.getLayout());
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridLayout(1, 0, 0, 0));", "  }", "}");
    }

    @Test
    public void test_replace2() throws Exception {
        final ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "  }", "}");
        final StringBuffer buffer = new StringBuffer();
        panel.addBroadcastListener((Object)new ObjectInfoChildAddAfter(){

            public void invoke(ObjectInfo parent, ObjectInfo child) throws Exception {
                if (parent == panel && child instanceof LayoutInfo) {
                    LayoutInfo newLayout = (LayoutInfo)child;
                    buffer.append("layout added: " + newLayout.getDescription().getComponentClass().getName());
                }
            }
        });
        LayoutInfo gridLayout = (LayoutInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, GridLayout.class, (CreationSupport)new ConstructorCreationSupport());
        panel.setLayout(gridLayout);
        LayoutManagersTest.assertEquals((Object)"layout added: java.awt.GridLayout", (Object)buffer.toString());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridLayout(1, 0, 0, 0));", "  }", "}");
    }

    @Test
    public void test_layoutComplexProperty() throws Exception {
        ContainerInfo panel = (ContainerInfo)this.parseSource("test", "Test.java", LayoutManagersTest.getSourceDQ("package test;", "import javax.swing.*;", "class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "  }", "}"));
        Property layoutProperty = panel.getPropertyByTitle("Layout");
        LayoutManagersTest.assertTrue((boolean)(layoutProperty instanceof ComplexProperty));
        LayoutManagersTest.assertTrue((boolean)layoutProperty.isModified());
        LayoutManagersTest.assertEquals((Object)"(java.awt.FlowLayout)", (Object)LayoutManagersTest.getPropertyText(layoutProperty));
        Property[] subProperties = LayoutManagersTest.getSubProperties(layoutProperty);
        Property hgapProperty = LayoutManagersTest.getPropertyByTitle(subProperties, "hgap");
        LayoutManagersTest.assertNotNull((Object)hgapProperty);
        LayoutManagersTest.assertFalse((boolean)hgapProperty.isModified());
        LayoutManagersTest.assertEquals((Object)5, (Object)hgapProperty.getValue());
        Property vgapProperty = LayoutManagersTest.getPropertyByTitle(subProperties, "vgap");
        LayoutManagersTest.assertNotNull((Object)vgapProperty);
        LayoutManagersTest.assertFalse((boolean)vgapProperty.isModified());
        LayoutManagersTest.assertEquals((Object)5, (Object)vgapProperty.getValue());
    }

    @Test
    public void test_removeConstraints_whenReplaceLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      Button button = new Button();", "      add(button, BorderLayout.WEST);", "    }", "  }", "}");
        this.refresh();
        panel.getLayout().delete();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      Button button = new Button();", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_removeConstraints_whenReplaceLayout_addDeprecated() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      Button button = new Button();", "      add('name', button);", "    }", "  }", "}");
        this.refresh();
        panel.getLayout().delete();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      Button button = new Button();", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_removeConstraints_whenReparent() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel inner = new JPanel();", "      inner.setLayout(null);", "      add(inner);", "      {", "        Button button = new Button();", "        button.setBounds(10, 20, 100, 50);", "        inner.add(button);", "      }", "    }", "  }", "}");
        ContainerInfo inner = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)inner.getChildrenComponents().get(0);
        ((FlowLayoutInfo)panel.getLayout()).move(button, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel inner = new JPanel();", "      inner.setLayout(null);", "      add(inner);", "    }", "    {", "      Button button = new Button();", "      add(button);", "    }", "  }", "}");
    }

    private void check_nameTemplate(String template, String ... lines) throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      JPanel panel = new JPanel();", "      panel.setLayout(new FlowLayout(FlowLayout.CENTER));", "      add(panel);", "    }", "  }", "}");
        panel.refresh();
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        LayoutInfo layout = innerPanel.getLayout();
        Activator.getDefault().getPreferenceStore().setValue("templateLayoutName", template);
        layout.getPropertyByTitle("hgap").setValue((Object)7);
        this.assertEditor(lines);
    }

    @Test
    public void test_nameTemplate_useDefaultName() throws Exception {
        this.check_nameTemplate("${defaultName}", "class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      JPanel panel = new JPanel();", "      FlowLayout flowLayout = new FlowLayout(FlowLayout.CENTER);", "      flowLayout.setHgap(7);", "      panel.setLayout(flowLayout);", "      add(panel);", "    }", "  }", "}");
    }

    @Test
    public void test_nameTemplate_alternativeTemplate_1() throws Exception {
        this.check_nameTemplate("${layoutAcronym}${containerName-cap}", "class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      JPanel panel = new JPanel();", "      FlowLayout flPanel = new FlowLayout(FlowLayout.CENTER);", "      flPanel.setHgap(7);", "      panel.setLayout(flPanel);", "      add(panel);", "    }", "  }", "}");
    }

    @Test
    public void test_nameTemplate_alternativeTemplate_2() throws Exception {
        this.check_nameTemplate("${containerName}${layoutClassName}", "class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      JPanel panel = new JPanel();", "      FlowLayout panelFlowLayout = new FlowLayout(FlowLayout.CENTER);", "      panelFlowLayout.setHgap(7);", "      panel.setLayout(panelFlowLayout);", "      add(panel);", "    }", "  }", "}");
    }

    @Test
    public void test_nameTemplate_ignoreDuringParsing() throws Exception {
        LayoutManagersTest.setFileContentSrc("test/MyLayout.java", this.getTestSource("public class MyLayout extends FlowLayout {", "  public MyLayout(Container container) {", "    container.setLayout(this);", "  }", "}"));
        LayoutManagersTest.setFileContentSrc("test/MyLayout.wbp-component.xml", LayoutManagersTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"));
        LayoutManagersTest.waitForAutoBuild();
        Activator.getDefault().getPreferenceStore().setValue("templateLayoutName", "${containerName}${layoutClassName}");
        String[] lines = new String[]{"class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      JPanel panel = new JPanel();", "      MyLayout layout = new MyLayout(panel);", "      panel.setLayout(layout);", "      add(panel);", "    }", "  }", "}"};
        this.parseJavaInfo(lines);
        this.assertEditor(lines);
    }

    @Test
    public void test_customImplementationOf_LayoutManager() throws Exception {
        LayoutManagersTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel() {", "    final LayoutManager layout = new FlowLayout();", "    setLayout(new LayoutManager() {", "      public void addLayoutComponent(String name, Component comp) {", "        layout.addLayoutComponent(name, comp);", "      }", "      public void removeLayoutComponent(Component comp) {", "        layout.removeLayoutComponent(comp);", "      }", "      public Dimension preferredLayoutSize(Container parent) {", "        return layout.preferredLayoutSize(parent);", "      }", "      public Dimension minimumLayoutSize(Container parent) {", "        return layout.minimumLayoutSize(parent);", "      }", "      public void layoutContainer(Container parent) {", "        layout.layoutContainer(parent);", "      }", "    });", "  }", "}"));
        LayoutManagersTest.waitForAutoBuild();
        this.parseJavaInfo("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        LayoutManagersTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: test.MyPanel$1} {implicit-layout} {}");
    }
}

