/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.ImplicitObjectAssociation;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.ImplicitLayoutCreationSupport;
import org.eclipse.wb.internal.swing.model.layout.ImplicitLayoutVariableSupport;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.AbstractLayoutTest;
import org.junit.jupiter.api.Test;

public class ImplicitLayoutTest
extends AbstractLayoutTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_1_implicitLayout_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "  }", "}");
        ImplicitLayoutTest.assertEquals((int)1, (int)panel.getChildren().size());
        ImplicitLayoutTest.assertSame(FlowLayoutInfo.class, ((ObjectInfo)panel.getChildren().get(0)).getClass());
        ImplicitLayoutTest.assertSame((Object)panel.getLayout(), panel.getChildren().get(0));
        LayoutInfo layout = panel.getLayout();
        ImplicitLayoutTest.assertTrue((boolean)layout.canDelete());
        ImplicitLayoutTest.assertInstanceOf(ImplicitObjectAssociation.class, (Object)layout.getAssociation());
        CreationSupport creationSupport = layout.getCreationSupport();
        ImplicitLayoutTest.assertInstanceOf(ImplicitLayoutCreationSupport.class, (Object)creationSupport);
        ImplicitLayoutTest.assertEquals((Object)panel.getCreationSupport().getNode(), (Object)creationSupport.getNode());
        ImplicitLayoutTest.assertEquals((Object)"implicit-layout: java.awt.FlowLayout", (Object)creationSupport.toString());
        VariableSupport variableSupport = layout.getVariableSupport();
        ImplicitLayoutTest.assertInstanceOf(ImplicitLayoutVariableSupport.class, (Object)variableSupport);
        ImplicitLayoutTest.assertEquals((Object)"implicit-layout", (Object)variableSupport.toString());
        ImplicitLayoutTest.assertEquals((Object)"(implicit layout)", (Object)variableSupport.getTitle());
        ImplicitLayoutTest.assertFalse((boolean)variableSupport.hasName());
        try {
            variableSupport.getName();
            ImplicitLayoutTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            variableSupport.setName("foo");
            ImplicitLayoutTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ImplicitLayoutTest.assertFalse((boolean)variableSupport.canConvertLocalToField());
        try {
            variableSupport.convertLocalToField();
            ImplicitLayoutTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ImplicitLayoutTest.assertFalse((boolean)variableSupport.canConvertFieldToLocal());
        try {
            variableSupport.convertFieldToLocal();
            ImplicitLayoutTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        StatementTarget target = variableSupport.getStatementTarget();
        this.assertEditor("class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    FlowLayout flowLayout = (FlowLayout) panel.getLayout();", "  }", "}");
        ClassInstanceCreation panelCreation = ((ConstructorCreationSupport)panel.getCreationSupport()).getCreation();
        Statement expectedStatement = ImplicitLayoutTest.getStatement(AstNodeUtils.getEnclosingBlock((ASTNode)panelCreation), 1);
        ImplicitLayoutTest.assertTarget(target, null, expectedStatement, false);
        ImplicitLayoutTest.assertInstanceOf(ImplicitObjectAssociation.class, (Object)layout.getAssociation());
    }

    @Test
    public void test_1_implicitLayout_2() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        LayoutInfo layout = panel.getLayout();
        ImplicitLayoutTest.assertInstanceOf(ImplicitLayoutCreationSupport.class, (Object)layout.getCreationSupport());
        NodeTarget target = ImplicitLayoutTest.getNodeBlockTarget((JavaInfo)panel, false, new int[0]);
        String accessExpression = layout.getVariableSupport().getAccessExpression(target);
        ImplicitLayoutTest.assertEquals((Object)"flowLayout.", (Object)accessExpression);
        ImplicitLayoutTest.assertInstanceOf(ImplicitLayoutCreationSupport.class, (Object)layout.getCreationSupport());
        ImplicitLayoutTest.assertInstanceOf(LocalUniqueVariableSupport.class, (Object)layout.getVariableSupport());
        ImplicitLayoutTest.assertInstanceOf(ImplicitObjectAssociation.class, (Object)layout.getAssociation());
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    FlowLayout flowLayout = (FlowLayout) getLayout();", "  }", "}");
    }

    @Test
    public void test_1_implicitLayout_3() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "class Test extends JPanel {", "  public Test() {", "    FlowLayout flowLayout = (FlowLayout) getLayout();", "  }", "}");
        LayoutInfo layout = panel.getLayout();
        ImplicitLayoutTest.assertInstanceOf(ImplicitLayoutCreationSupport.class, (Object)layout.getCreationSupport());
        VariableSupport variableSupport = layout.getVariableSupport();
        ImplicitLayoutTest.assertInstanceOf(LocalUniqueVariableSupport.class, (Object)variableSupport);
        ImplicitLayoutTest.assertEquals((Object)"flowLayout", (Object)variableSupport.getName());
        ImplicitLayoutTest.assertInstanceOf(ImplicitObjectAssociation.class, (Object)layout.getAssociation());
        panel.getLayout().delete();
        this.assertEditor("// filler filler filler", "class Test extends JPanel {", "  public Test() {", "  }", "}");
        layout = panel.getLayout();
        ImplicitLayoutTest.assertInstanceOf(ImplicitLayoutCreationSupport.class, (Object)layout.getCreationSupport());
        ImplicitLayoutTest.assertInstanceOf(ImplicitLayoutVariableSupport.class, (Object)layout.getVariableSupport());
        ImplicitLayoutTest.assertInstanceOf(ImplicitObjectAssociation.class, (Object)layout.getAssociation());
    }
}

