/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.wb.core.editor.IDesignPageSite;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.editor.DesignPageSite;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.InnerClassPropertyEditor;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class InnerClassPropertyEditorTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_generateInner() throws Exception {
        this.declareButtonAndProvider();
        this.declareProviderProperty_inner();
        InnerClassPropertyEditorTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property property = button.getPropertyByTitle("labelProvider");
        InnerClassPropertyEditor propertyEditor = (InnerClassPropertyEditor)property.getEditor();
        InnerClassPropertyEditorTest.assertEquals((Object)"<double click>", (Object)InnerClassPropertyEditorTest.getPropertyText(property));
        propertyEditor.activate(null, property, null);
        this.assertEditor("public class Test extends JPanel {", "  private class LabelProvider implements ILabelProvider {", "    public String getText(Object o) {", "      return null;", "    }", "  }", "  public Test() {", "    MyButton button = new MyButton();", "    button.setLabelProvider(new LabelProvider());", "    add(button);", "  }", "}");
        InnerClassPropertyEditorTest.assertEquals((Object)"test.Test.LabelProvider", (Object)InnerClassPropertyEditorTest.getPropertyText(property));
        int expectedPosition = ((GenericProperty)property).getExpression().getStartPosition();
        IDesignPageSite designerPageSite = (IDesignPageSite)Mockito.mock(IDesignPageSite.class);
        DesignPageSite.Helper.setSite((ObjectInfo)button, (IDesignPageSite)designerPageSite);
        propertyEditor.doubleClick(property, null);
        ((IDesignPageSite)Mockito.verify((Object)designerPageSite)).openSourcePosition(expectedPosition);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{designerPageSite});
    }

    @Test
    public void test_openExternalClass() throws Exception {
        this.declareButtonAndProvider();
        this.declareProviderProperty_inner();
        InnerClassPropertyEditorTest.setFileContentSrc("test/ExternalLabelProvider.java", this.getTestSource("public class ExternalLabelProvider implements ILabelProvider {", "  public ExternalLabelProvider(long level) {", "  }", "  public String getText(Object o) {", "    return null;", "  }", "}"));
        InnerClassPropertyEditorTest.waitForAutoBuild();
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)InnerClassPropertyEditorTest.getJavaInfoByName("button");
        final Property property = button.getPropertyByTitle("labelProvider");
        InnerClassPropertyEditorTest.assertEquals((Object)"<double click>", (Object)InnerClassPropertyEditorTest.getPropertyText(property));
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                InnerClassPropertyEditorTest.openPropertyDialog(property);
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                InnerClassPropertyEditorTest.animateOpenTypeSelection(bot, "ExternalLabelPro", "OK");
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    button.setLabelProvider(new ExternalLabelProvider(0L));", "    add(button);", "  }", "}");
        InnerClassPropertyEditorTest.assertEquals((Object)"test.ExternalLabelProvider", (Object)InnerClassPropertyEditorTest.getPropertyText(property));
    }

    @Test
    public void test_openExternalClass_abstract() throws Exception {
        this.declareButtonAndProvider();
        this.declareProviderProperty_inner();
        InnerClassPropertyEditorTest.setFileContentSrc("test/AbstractLabelProvider.java", this.getTestSource("public abstract class AbstractLabelProvider implements ILabelProvider {", "  public AbstractLabelProvider(long level) {", "  }", "  public String getText(Object o) {", "    return null;", "  }", "}"));
        InnerClassPropertyEditorTest.waitForAutoBuild();
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)InnerClassPropertyEditorTest.getJavaInfoByName("button");
        final Property property = button.getPropertyByTitle("labelProvider");
        InnerClassPropertyEditorTest.assertEquals((Object)"<double click>", (Object)InnerClassPropertyEditorTest.getPropertyText(property));
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                InnerClassPropertyEditorTest.openPropertyDialog(property);
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                InnerClassPropertyEditorTest.animateOpenTypeSelection(bot, "AbstractLabelPro", "OK");
                bot.shell("Error").bot().button("OK").click();
            }
        });
    }

    @Test
    public void test_generateAnonymous() throws Exception {
        this.declareButtonAndProvider();
        InnerClassPropertyEditorTest.setFileContentSrc("test/MyButton.wbp-component.xml", InnerClassPropertyEditorTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <property id='setLabelProvider(test.ILabelProvider)'>", "    <editor id='innerClass'>", "      <parameter name='mode'>anonymous</parameter>", "      <parameter name='class'>test.ILabelProvider</parameter>", "      <parameter name='source'><![CDATA[", "new test.ILabelProvider() {", "  public String getText(Object o) {", "    return null;", "  }", "}", "      ]]></parameter>", "    </editor>", "  </property>", "</component>"));
        InnerClassPropertyEditorTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property property = button.getPropertyByTitle("labelProvider");
        InnerClassPropertyEditor propertyEditor = (InnerClassPropertyEditor)property.getEditor();
        InnerClassPropertyEditorTest.assertEquals((Object)"<double click>", (Object)InnerClassPropertyEditorTest.getPropertyText(property));
        propertyEditor.activate(null, property, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    button.setLabelProvider(new ILabelProvider() {", "      public String getText(Object o) {", "        return null;", "      }", "    });", "    add(button);", "  }", "}");
        InnerClassPropertyEditorTest.assertEquals((Object)"<anonymous>", (Object)InnerClassPropertyEditorTest.getPropertyText(property));
    }

    @Test
    public void test_templateExpression() throws Exception {
        this.declareButtonAndProvider();
        InnerClassPropertyEditorTest.setFileContentSrc("test/AbstractLabelProvider.java", this.getTestSource("public abstract class AbstractLabelProvider implements ILabelProvider {", "  public AbstractLabelProvider(JLabel label) {", "  }", "}"));
        InnerClassPropertyEditorTest.setFileContentSrc("test/MyButton.wbp-component.xml", InnerClassPropertyEditorTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <property id='setLabelProvider(test.ILabelProvider)'>", "    <editor id='innerClass'>", "      <parameter name='mode'>anonymous</parameter>", "      <parameter name='class'>test.ILabelProvider</parameter>", "      <parameter name='source'><![CDATA[", "new test.AbstractLabelProvider(${parent.firstChild[javax.swing.JLabel].expression}) {", "  public String getText(Object o) {", "    return null;", "  }", "}", "      ]]></parameter>", "    </editor>", "  </property>", "</component>"));
        InnerClassPropertyEditorTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JLabel myLabel = new JLabel();", "    add(myLabel);", "    //", "    MyButton button = new MyButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(1);
        Property property = button.getPropertyByTitle("labelProvider");
        InnerClassPropertyEditor propertyEditor = (InnerClassPropertyEditor)property.getEditor();
        InnerClassPropertyEditorTest.assertEquals((Object)"<double click>", (Object)InnerClassPropertyEditorTest.getPropertyText(property));
        propertyEditor.activate(null, property, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JLabel myLabel = new JLabel();", "    add(myLabel);", "    //", "    MyButton button = new MyButton();", "    button.setLabelProvider(new AbstractLabelProvider(myLabel) {", "      public String getText(Object o) {", "        return null;", "      }", "    });", "    add(button);", "  }", "}");
        InnerClassPropertyEditorTest.assertEquals((Object)"<anonymous>", (Object)InnerClassPropertyEditorTest.getPropertyText(property));
    }

    private void declareButtonAndProvider() throws Exception {
        InnerClassPropertyEditorTest.setFileContentSrc("test/ILabelProvider.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public interface ILabelProvider {", "  String getText(Object o);", "}"));
        InnerClassPropertyEditorTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public void setLabelProvider(ILabelProvider provider) {", "  }", "}"));
    }

    private void declareProviderProperty_inner() throws Exception {
        InnerClassPropertyEditorTest.setFileContentSrc("test/MyButton.wbp-component.xml", InnerClassPropertyEditorTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <property id='setLabelProvider(test.ILabelProvider)'>", "    <editor id='innerClass'>", "      <parameter name='mode'>inner</parameter>", "      <parameter name='name'>LabelProvider</parameter>", "      <parameter name='class'>test.ILabelProvider</parameter>", "      <parameter name='source'><![CDATA[", "private class ${name} implements test.ILabelProvider {", "  public String getText(Object o) {", "    return null;", "  }", "}", "      ]]></parameter>", "    </editor>", "  </property>", "</component>"));
    }
}

