/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.association;

import org.eclipse.wb.core.model.association.AssociationObject;
import org.eclipse.wb.core.model.association.AssociationObjects;
import org.eclipse.wb.core.model.association.ConstructorChildAssociation;
import org.eclipse.wb.core.model.association.EmptyAssociation;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.core.model.association.InvocationVoidAssociation;
import org.eclipse.wb.internal.core.model.nonvisual.NonVisualAssociation;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class AssociationObjectsTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_no() throws Exception {
        AssociationObject associationObject = AssociationObjects.no();
        AssociationObjectsTest.assertEquals((Object)"NO", (Object)associationObject.toString());
        AssociationObjectsTest.assertNull((Object)associationObject.getAssociation());
        AssociationObjectsTest.assertFalse((boolean)associationObject.isRequired());
    }

    @Test
    public void test_empty() throws Exception {
        AssociationObject associationObject = AssociationObjects.empty();
        AssociationObjectsTest.assertEquals((Object)"empty", (Object)associationObject.toString());
        AssociationObjectsTest.assertInstanceOf(EmptyAssociation.class, (Object)associationObject.getAssociation());
        AssociationObjectsTest.assertFalse((boolean)associationObject.isRequired());
    }

    @Test
    public void test_nonVisual() throws Exception {
        AssociationObject associationObject = AssociationObjects.nonVisual();
        AssociationObjectsTest.assertEquals((Object)"nonVisual", (Object)associationObject.toString());
        AssociationObjectsTest.assertInstanceOf(NonVisualAssociation.class, (Object)associationObject.getAssociation());
        AssociationObjectsTest.assertFalse((boolean)associationObject.isRequired());
    }

    @Test
    public void test_constructorChild() throws Exception {
        AssociationObject associationObject = AssociationObjects.constructorChild();
        AssociationObjectsTest.assertEquals((Object)"constructorChild", (Object)associationObject.toString());
        AssociationObjectsTest.assertInstanceOf(ConstructorChildAssociation.class, (Object)associationObject.getAssociation());
        AssociationObjectsTest.assertFalse((boolean)associationObject.isRequired());
    }

    @Test
    public void test_invocationVoid() throws Exception {
        AssociationObject associationObject = AssociationObjects.invocationVoid();
        AssociationObjectsTest.assertEquals((Object)"invocationVoid", (Object)associationObject.toString());
        AssociationObjectsTest.assertInstanceOf(InvocationVoidAssociation.class, (Object)associationObject.getAssociation());
        AssociationObjectsTest.assertFalse((boolean)associationObject.isRequired());
    }

    @Test
    public void test_invocationChildNull() throws Exception {
        AssociationObject associationObject = AssociationObjects.invocationChildNull();
        AssociationObjectsTest.assertEquals((Object)"invocationChildNull", (Object)associationObject.toString());
        AssociationObjectsTest.assertInstanceOf(InvocationChildAssociation.class, (Object)associationObject.getAssociation());
        AssociationObjectsTest.assertFalse((boolean)associationObject.isRequired());
    }

    @Test
    public void test_invocationChild_withRequired() throws Exception {
        String source = "%parent%.add(%child%)";
        AssociationObject associationObject = AssociationObjects.invocationChild((String)source, (boolean)false);
        AssociationObjectsTest.assertEquals((Object)source, (Object)associationObject.toString());
        AssociationObjectsTest.assertInstanceOf(InvocationChildAssociation.class, (Object)associationObject.getAssociation());
        AssociationObjectsTest.assertFalse((boolean)associationObject.isRequired());
        associationObject = AssociationObjects.invocationChild((String)source, (boolean)true);
        AssociationObjectsTest.assertEquals((Object)source, (Object)associationObject.toString());
        AssociationObjectsTest.assertInstanceOf(InvocationChildAssociation.class, (Object)associationObject.getAssociation());
        AssociationObjectsTest.assertTrue((boolean)associationObject.isRequired());
    }
}

