/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildGraphical;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildTree;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildrenGraphical;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildrenTree;
import org.eclipse.wb.tests.designer.core.model.TestObjectInfo;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.jupiter.api.Test;

public class DefaultObjectPresentationTest
extends DesignerTestCase {
    @Test
    public void test_getIcon() throws Exception {
        TestObjectInfo parent = new TestObjectInfo();
        DefaultObjectPresentationTest.assertNull((Object)parent.getPresentation().getIcon());
    }

    @Test
    public void test_getChildrenTree() throws Exception {
        TestObjectInfo parent = new TestObjectInfo();
        TestObjectInfo child_1 = new TestObjectInfo("1");
        final TestObjectInfo child_2 = new TestObjectInfo("2");
        TestObjectInfo child_3 = new TestObjectInfo("3");
        parent.addChild(child_1);
        parent.addChild(child_2);
        parent.addChild(child_3);
        parent.addBroadcastListener(new ObjectInfoChildTree(){

            public void invoke(ObjectInfo object, boolean[] visible) throws Exception {
                if (object == child_2) {
                    visible[0] = false;
                }
            }
        });
        List children = parent.getPresentation().getChildrenTree();
        DefaultObjectPresentationTest.assertEquals((int)2, (int)children.size());
        DefaultObjectPresentationTest.assertSame((Object)((Object)child_1), children.get(0));
        DefaultObjectPresentationTest.assertSame((Object)((Object)child_3), children.get(1));
    }

    @Test
    public void test_getChildrenTree_childrenBroadcast() throws Exception {
        TestObjectInfo parent = new TestObjectInfo();
        final TestObjectInfo child_1 = new TestObjectInfo("1");
        TestObjectInfo child_2 = new TestObjectInfo("2");
        TestObjectInfo child_3 = new TestObjectInfo("3");
        parent.addChild(child_1);
        parent.addChild(child_2);
        parent.addChild(child_3);
        parent.addBroadcastListener(new ObjectInfoChildrenTree(){

            public void invoke(ObjectInfo p, List<ObjectInfo> children) throws Exception {
                children.remove(child_1);
                children.add(child_1);
            }
        });
        List children = parent.getPresentation().getChildrenTree();
        Assertions.assertThat((List)children).containsExactly((Object[])new ObjectInfo[]{child_2, child_3, child_1});
    }

    @Test
    public void test_getChildrenGraphical() throws Exception {
        TestObjectInfo parent = new TestObjectInfo();
        TestObjectInfo child_1 = new TestObjectInfo("1");
        final TestObjectInfo child_2 = new TestObjectInfo("2");
        TestObjectInfo child_3 = new TestObjectInfo("3");
        parent.addChild(child_1);
        parent.addChild(child_2);
        parent.addChild(child_3);
        parent.addBroadcastListener(new ObjectInfoChildGraphical(){

            public void invoke(ObjectInfo object, boolean[] visible) throws Exception {
                if (object == child_2) {
                    visible[0] = false;
                }
            }
        });
        List children = parent.getPresentation().getChildrenGraphical();
        DefaultObjectPresentationTest.assertEquals((int)2, (int)children.size());
        DefaultObjectPresentationTest.assertSame((Object)((Object)child_1), children.get(0));
        DefaultObjectPresentationTest.assertSame((Object)((Object)child_3), children.get(1));
    }

    @Test
    public void test_getChildrenGraphical_childrenBroadcast() throws Exception {
        TestObjectInfo parent = new TestObjectInfo();
        final TestObjectInfo child_1 = new TestObjectInfo("1");
        TestObjectInfo child_2 = new TestObjectInfo("2");
        TestObjectInfo child_3 = new TestObjectInfo("3");
        parent.addChild(child_1);
        parent.addChild(child_2);
        parent.addChild(child_3);
        parent.addBroadcastListener(new ObjectInfoChildrenGraphical(){

            public void invoke(List<ObjectInfo> children) throws Exception {
                children.remove(child_1);
                children.add(child_1);
            }
        });
        List children = parent.getPresentation().getChildrenGraphical();
        Assertions.assertThat((List)children).containsExactly((Object[])new ObjectInfo[]{child_2, child_3, child_1});
    }
}

