/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.ClassCriteria;
import org.burningwave.core.classes.ClassHunter;
import org.burningwave.core.classes.ClassPathHunterImpl;
import org.burningwave.core.classes.ClassPathScanner;
import org.burningwave.core.classes.PathScannerClassLoader;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.PathHelper;

public interface ClassPathHunter
extends ClassPathScanner<Collection<Class<?>>, SearchResult> {
    public static ClassPathHunter create(PathHelper pathHelper, Object defaultPathScannerClassLoaderOrDefaultPathScannerClassLoaderSupplier, Map<?, ?> config) {
        return new ClassPathHunterImpl(pathHelper, defaultPathScannerClassLoaderOrDefaultPathScannerClassLoaderSupplier, config);
    }

    public static class SearchResult
    extends org.burningwave.core.classes.SearchResult<Collection<Class<?>>> {
        Collection<FileSystemItem> classPaths;

        SearchResult(ClassPathHunterImpl.SearchContext context) {
            super(context);
        }

        public Collection<FileSystemItem> getClassPaths(ClassCriteria criteria) {
            ClassCriteria criteriaCopy = (ClassCriteria)criteria.createCopy().init(this.context.getSearchConfig().getClassCriteria().getClassSupplier(), this.context.getSearchConfig().getClassCriteria().getByteCodeSupplier());
            Optional.ofNullable(this.context.getSearchConfig().getClassCriteria().getClassesToBeUploaded()).ifPresent(classesToBeUploaded -> criteriaCopy.useClasses((Collection<Class<?>>)classesToBeUploaded));
            HashMap itemsFound = new HashMap();
            this.getItemsFoundFlatMap().forEach((path, classColl) -> {
                for (Class cls : classColl) {
                    if (!((ClassCriteria.TestContext)criteriaCopy.testWithFalseResultForNullEntityOrTrueResultForNullPredicate(cls)).getResult().booleanValue()) continue;
                    itemsFound.put(path, classColl);
                    break;
                }
            });
            criteriaCopy.close();
            return itemsFound.keySet().stream().map(absolutePath -> FileSystemItem.ofPath(absolutePath)).collect(Collectors.toCollection(HashSet::new));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<FileSystemItem> getClassPaths() {
            if (this.classPaths == null) {
                Map itemsFoundFlatMaps;
                Map map = itemsFoundFlatMaps = this.context.getItemsFoundFlatMap();
                synchronized (map) {
                    if (this.classPaths == null) {
                        this.classPaths = itemsFoundFlatMaps.keySet().stream().map(path -> FileSystemItem.ofPath(path)).collect(Collectors.toCollection(HashSet::new));
                    }
                }
            }
            return this.classPaths;
        }

        @Override
        public void close() {
            this.classPaths = null;
            super.close();
        }
    }

    public static abstract class Configuration {
        public static final Map<String, Object> DEFAULT_VALUES;

        static {
            HashMap<String, Object> defaultValues = new HashMap<String, Object>();
            defaultValues.put("class-path-hunter.default-path-scanner-class-loader.supplier.imports", "${code-executor.common.imports}" + StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator() + "${" + "class-path-hunter.default-path-scanner-class-loader" + "." + "supplier" + ".additional-imports}" + StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator() + PathScannerClassLoader.class.getName() + StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator());
            defaultValues.put("class-path-hunter.default-path-scanner-class-loader.supplier.name", ClassHunter.class.getPackage().getName() + ".DefaultPathScannerClassLoaderRetrieverForClassHunter");
            defaultValues.put("class-path-hunter.default-path-scanner-class-loader", componentSupplier -> componentSupplier.getPathScannerClassLoader());
            defaultValues.put("class-path-hunter.new-isolated-path-scanner-class-loader.search-config.check-file-option", "${hunters.default-search-config.check-file-option}");
            DEFAULT_VALUES = Collections.unmodifiableMap(defaultValues);
        }

        public static abstract class Key {
            public static final String NAME_IN_CONFIG_PROPERTIES = "class-path-hunter";
            public static final String DEFAULT_PATH_SCANNER_CLASS_LOADER = "class-path-hunter.default-path-scanner-class-loader";
            public static final String PATH_SCANNER_CLASS_LOADER_SEARCH_CONFIG_CHECK_FILE_OPTIONS = "class-path-hunter.new-isolated-path-scanner-class-loader.search-config.check-file-option";
        }
    }
}

