/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.property;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.rcp.ToolkitProvider;
import org.eclipse.wb.internal.swt.model.jface.resource.ManagerContainerInfo;
import org.eclipse.wb.internal.swt.model.property.editor.image.ImagePropertyEditor;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.swt.model.property.ImagePropertyEditorTest;
import org.eclipse.wb.tests.designer.swt.model.property.PropertyEditorTestUtils;
import org.eclipse.wb.tests.designer.tests.common.GenericPropertyNoValue;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ImagePropertyEditorTestWithManager
extends ImagePropertyEditorTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        ToolkitProvider.DESCRIPTION.getPreferences().setValue("useResourceManager", true);
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_textSource_noValue() throws Exception {
        GenericPropertyNoValue property = new GenericPropertyNoValue(null, null, ImagePropertyEditor.INSTANCE);
        ImagePropertyEditorTestWithManager.assertNull((Object)PropertyEditorTestUtils.getText((Property)property));
        ImagePropertyEditorTestWithManager.assertNull((Object)PropertyEditorTestUtils.getClipboardSource((Property)property));
    }

    @Test
    public void test_textSource_nullValue() throws Exception {
        this.assert_getText_getClipboardSource_forSource("null", "(null)", "null");
    }

    @Test
    public void test_textSource_absolutePath() throws Exception {
        File file = ImagePropertyEditorTestWithManager.createTempImage();
        try {
            String path = FilenameUtils.separatorsToUnix((String)file.getCanonicalPath());
            this.assert_getText_getClipboardSource_forSource("new Image(null, \"" + path + "\")", "File: " + path, ImagePropertyEditor.getInvocationSource((JavaInfo)this.shell(), null, (String)("\"" + path + "\"")));
        }
        finally {
            file.delete();
        }
    }

    @Ignore
    @Test
    public void test_textSource_image_over_classpath() throws Exception {
        this.assert_getText_getClipboardSource_forSource("new Image(null, getClass().getResourceAsStream(\"/javax/swing/plaf/basic/icons/JavaCup16.png\"))", "Classpath: /javax/swing/plaf/basic/icons/JavaCup16.png", ImagePropertyEditor.getInvocationSource((JavaInfo)this.shell(), (String)"{wbp_classTop}", (String)"/javax/swing/plaf/basic/icons/JavaCup16.png"));
    }

    @Ignore
    @Test
    public void test_textSource_image_over_classpath_OtherClass() throws Exception {
        this.assert_getText_getClipboardSource_forSource("new Image(null, java.lang.String.class.getResourceAsStream(\"/javax/swing/plaf/basic/icons/JavaCup16.png\"))", "Classpath: /javax/swing/plaf/basic/icons/JavaCup16.png", ImagePropertyEditor.getInvocationSource((JavaInfo)this.shell(), (String)"{wbp_classTop}", (String)"/javax/swing/plaf/basic/icons/JavaCup16.png"));
    }

    @Test
    public void test_textSource_absolutePath2() throws Exception {
        File file = ImagePropertyEditorTestWithManager.createTempImage();
        CompositeInfo shell = this.shell();
        try {
            String path = FilenameUtils.separatorsToUnix((String)file.getCanonicalPath());
            this.assert_getText_getClipboardSource_forSource2(ImagePropertyEditor.getInvocationSource((JavaInfo)shell, null, (String)("\"" + path + "\"")), "File: " + path, ImagePropertyEditor.getInvocationSource((JavaInfo)shell, null, (String)("\"" + path + "\"")));
        }
        finally {
            file.delete();
        }
    }

    @Test
    public void test_textSource_image_over_classpath2() throws Exception {
        CompositeInfo shell = this.shell();
        this.assert_getText_getClipboardSource_forSource2(ImagePropertyEditor.getInvocationSource((JavaInfo)shell, (String)"getClass()", (String)"\"/javax/swing/plaf/basic/icons/JavaCup16.png\""), "Classpath: /javax/swing/plaf/basic/icons/JavaCup16.png", ImagePropertyEditor.getInvocationSource((JavaInfo)shell, (String)"{wbp_classTop}", (String)"\"/javax/swing/plaf/basic/icons/JavaCup16.png\""));
    }

    @Test
    public void test_textSource_image_over_classpath_OtherClass2() throws Exception {
        CompositeInfo shell = this.shell();
        this.assert_getText_getClipboardSource_forSource2(ImagePropertyEditor.getInvocationSource((JavaInfo)shell, (String)"java.lang.String.class", (String)"\"/javax/swing/plaf/basic/icons/JavaCup16.png\""), "Classpath: /javax/swing/plaf/basic/icons/JavaCup16.png", ImagePropertyEditor.getInvocationSource((JavaInfo)shell, (String)"{wbp_classTop}", (String)"\"/javax/swing/plaf/basic/icons/JavaCup16.png\""));
    }

    private void assert_getText_getClipboardSource_forSource2(String imageSource, String expectedText, String expectedClipboardSource) throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        ImagePropertyEditorTestWithManager.waitForAutoBuild();
        ManagerContainerInfo.getResourceManagerInfo((JavaInfo)shell);
        shell.addMethodInvocation("setImage(org.eclipse.swt.graphics.Image)", imageSource);
        shell.refresh();
        Property property = shell.getPropertyByTitle("image");
        ImagePropertyEditorTestWithManager.assertEquals((Object)expectedText, (Object)PropertyEditorTestUtils.getText(property));
        ImagePropertyEditorTestWithManager.assertEquals((Object)expectedClipboardSource, (Object)PropertyEditorTestUtils.getClipboardSource(property));
    }

    @Test
    public void test_textSource_order() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        ManagerContainerInfo.getResourceManagerInfo((JavaInfo)shell);
        shell.addMethodInvocation("setImage(org.eclipse.swt.graphics.Image)", ImagePropertyEditor.getInvocationSource((JavaInfo)shell, (String)"java.lang.String.class", (String)"\"/javax/swing/plaf/basic/icons/JavaCup16.png\""));
        shell.refresh();
        this.assertEditor("// filler filler filler", "public class Test extends Shell {", "  private LocalResourceManager localResourceManager;", "  public Test() {", "    createResourceManager();", "    setImage(localResourceManager.create(ImageDescriptor.createFromFile(String.class, \"/javax/swing/plaf/basic/icons/JavaCup16.png\")));", "  }", "  private void createResourceManager() {", "    localResourceManager = new LocalResourceManager(JFaceResources.getResources(),this);", "  }", "}");
    }

    private CompositeInfo shell() throws Exception {
        return this.parseComposite("public class Test extends Shell {}");
    }
}

