/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.menu;

import java.util.function.Predicate;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.tests.gef.GraphicalRobot;

public final class MenuFeedbackTester {
    private final GraphicalRobot canvas;

    public MenuFeedbackTester(GraphicalRobot canvas) {
        this.canvas = canvas;
    }

    private static Predicate<IFigure> getSelectionPredicate(GraphicalEditPart part) {
        Rectangle partBounds = part.getFigure().getBounds().getCopy();
        FigureUtils.translateFigureToAbsolute((IFigure)part.getFigure(), (Translatable)partBounds);
        return feedback -> partBounds.equals((Object)feedback.getBounds());
    }

    private Predicate<IFigure> getSelectionPredicate(Object object) {
        return MenuFeedbackTester.getSelectionPredicate(this.canvas.getEditPart(object));
    }

    public void assertMenuNoFeedbacks() {
        this.canvas.assertFigures("Menu Feedback Layer", new Predicate[0]);
    }

    public void assertMenuFeedbacks(Predicate<IFigure> p) {
        this.assertMenuFeedbacks(new Predicate[]{p});
    }

    public void assertMenuFeedbacks(Predicate<IFigure> p1, Predicate<IFigure> p2) {
        this.assertMenuFeedbacks(new Predicate[]{p1, p2});
    }

    public void assertMenuFeedbacks(Predicate<IFigure> ... predicates) {
        this.canvas.assertFigures("Menu Feedback Layer", predicates);
    }

    public void assertFeedback_selection(Object object) {
        this.assertMenuFeedbacks(this.getSelectionPredicate(object));
    }

    public void assertFeedback_selection_line(Object selection, Object lineObject, int location) {
        Predicate<IFigure> linePredicate = this.canvas.getLinePredicate(lineObject, location);
        Predicate<IFigure> selectionPredicate = this.getSelectionPredicate(selection);
        this.assertMenuFeedbacks(selectionPredicate, linePredicate);
    }

    public void assertFeedback_selection_target(Object selection, Object targetObject) {
        Predicate<IFigure> targetPredicate = this.canvas.getTargetPredicate(targetObject);
        Predicate<IFigure> selectionPredicate = this.getSelectionPredicate(selection);
        this.assertMenuFeedbacks(selectionPredicate, targetPredicate);
    }

    public void assertFeedback_selection_emptyFlow(Object selection, Object hostObject, boolean horizontal) {
        Predicate<IFigure> targetPredicate = this.canvas.getEmptyFlowContainerPredicate(hostObject, horizontal);
        Predicate<IFigure> flowPredicate = this.getSelectionPredicate(selection);
        this.assertMenuFeedbacks(flowPredicate, targetPredicate);
    }

    public void assertMenuLineFeedback(Object object, int location) {
        this.assertMenuFeedbacks(this.canvas.getLinePredicate(object, location));
    }

    public void assertMenuTargetFeedback(Object object) {
        this.assertMenuFeedbacks(this.canvas.getTargetPredicate(object));
    }
}

