/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.layouts.grid;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.jface.action.IAction;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class GridLayoutSelectionActionsTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_emptySelection() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout());", "  }", "}");
        shell.refresh();
        List<Object> actions = GridLayoutSelectionActionsTest.getSelectionActions(new ObjectInfo[0]);
        Assertions.assertThat(actions).isEmpty();
    }

    @Test
    public void test_selectionActions() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Label label = new Label(this, SWT.NONE);", "      label.setText('Label:');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.grabExcessHorizontalSpace = true;", "        button.setLayoutData(gridData);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo label = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(1);
        List<Object> actions = GridLayoutSelectionActionsTest.getSelectionActions(new ObjectInfo[]{button});
        GridLayoutSelectionActionsTest.assertEquals((long)13L, (long)actions.size());
        GridLayoutSelectionActionsTest.assertNotNull((Object)GridLayoutSelectionActionsTest.findAction(actions, "Left"));
        GridLayoutSelectionActionsTest.assertTrue((boolean)GridLayoutSelectionActionsTest.findAction(actions, "Left").isChecked());
        GridLayoutSelectionActionsTest.assertNotNull((Object)GridLayoutSelectionActionsTest.findAction(actions, "Center"));
        GridLayoutSelectionActionsTest.assertFalse((boolean)GridLayoutSelectionActionsTest.findAction(actions, "Center").isChecked());
        GridLayoutSelectionActionsTest.assertNotNull((Object)GridLayoutSelectionActionsTest.findAction(actions, "Right"));
        GridLayoutSelectionActionsTest.assertFalse((boolean)GridLayoutSelectionActionsTest.findAction(actions, "Right").isChecked());
        GridLayoutSelectionActionsTest.assertNotNull((Object)GridLayoutSelectionActionsTest.findAction(actions, "Fill"));
        GridLayoutSelectionActionsTest.assertFalse((boolean)GridLayoutSelectionActionsTest.findAction(actions, "Fill").isChecked());
        GridLayoutSelectionActionsTest.assertNotNull((Object)GridLayoutSelectionActionsTest.findAction(actions, "Top"));
        GridLayoutSelectionActionsTest.assertNotNull((Object)GridLayoutSelectionActionsTest.findAction(actions, "Bottom"));
        GridLayoutSelectionActionsTest.assertNotNull((Object)GridLayoutSelectionActionsTest.findAction(actions, "Horizontal grab"));
        GridLayoutSelectionActionsTest.assertNotNull((Object)GridLayoutSelectionActionsTest.findAction(actions, "Vertical grab"));
        GridLayoutSelectionActionsTest.assertTrue((boolean)GridLayoutSelectionActionsTest.findAction(actions, "Horizontal grab").isChecked());
        GridLayoutSelectionActionsTest.assertFalse((boolean)GridLayoutSelectionActionsTest.findAction(actions, "Vertical grab").isChecked());
        actions = GridLayoutSelectionActionsTest.getSelectionActions(new ObjectInfo[]{label, button});
        GridLayoutSelectionActionsTest.assertFalse((boolean)GridLayoutSelectionActionsTest.findAction(actions, "Horizontal grab").isChecked());
    }

    @Test
    public void test_grabAction() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Label label = new Label(this, SWT.NONE);", "      label.setText('Label:');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.grabExcessHorizontalSpace = true;", "        button.setLayoutData(gridData);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(1);
        List<Object> actions = GridLayoutSelectionActionsTest.getSelectionActions(new ObjectInfo[]{button});
        IAction verticalGrab = GridLayoutSelectionActionsTest.findAction(actions, "Vertical grab");
        verticalGrab.setChecked(true);
        verticalGrab.run();
        IAction horizontalGrab = GridLayoutSelectionActionsTest.findAction(actions, "Horizontal grab");
        horizontalGrab.setChecked(false);
        horizontalGrab.run();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Label label = new Label(this, SWT.NONE);", "      label.setText('Label:');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData();", "        gridData.grabExcessVerticalSpace = true;", "        button.setLayoutData(gridData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_alignmentAction() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Label label = new Label(this, SWT.NONE);", "      label.setText('Label:');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        GridData gridData = new GridData(SWT.LEFT, SWT.CENTER, false, false);", "        button.setLayoutData(gridData);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(1);
        List<Object> actions = GridLayoutSelectionActionsTest.getSelectionActions(new ObjectInfo[]{button});
        IAction rightAlignment = GridLayoutSelectionActionsTest.findAction(actions, "Right");
        rightAlignment.setChecked(true);
        rightAlignment.run();
        IAction bottomAction = GridLayoutSelectionActionsTest.findAction(actions, "Bottom");
        bottomAction.setChecked(true);
        bottomAction.run();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Label label = new Label(this, SWT.NONE);", "      label.setText('Label:');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.RIGHT, SWT.BOTTOM, false, false));", "    }", "  }", "}");
        actions = GridLayoutSelectionActionsTest.getSelectionActions(new ObjectInfo[]{shell, button});
        GridLayoutSelectionActionsTest.assertTrue((boolean)actions.isEmpty());
    }

    @Test
    public void test_indirectExposedChild() throws Exception {
        GridLayoutSelectionActionsTest.setFileContentSrc("test/ImplicitComposite.java", this.getTestSource("public class ImplicitComposite extends Composite {", "  private Button m_button;", "  public ImplicitComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout());", "    {", "      Composite container = new Composite(this, SWT.NONE);", "      container.setLayout(new RowLayout());", "      {", "        m_button = new Button(container, SWT.NONE);", "        m_button.setLayoutData(new RowData());", "      }", "    }", "  }", "  public Button getButton() {", "    return m_button;", "  }", "}"));
        GridLayoutSelectionActionsTest.waitForAutoBuild();
        CompositeInfo composite = this.parseComposite("public class Test extends ImplicitComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        GridLayoutSelectionActionsTest.assertHierarchy("{this: test.ImplicitComposite} {this} {}", "  {implicit-layout: org.eclipse.swt.layout.GridLayout} {implicit-layout} {}", "  {method: public org.eclipse.swt.widgets.Button test.ImplicitComposite.getButton()} {property} {}");
        composite.refresh();
        ControlInfo button = (ControlInfo)composite.getChildrenControls().get(0);
        List<Object> actions = GridLayoutSelectionActionsTest.getSelectionActions(new ObjectInfo[]{button});
        Assertions.assertThat(actions).isEmpty();
    }
}

