/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.property;

import java.util.List;
import javax.swing.JLabel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.internal.core.model.property.order.TabOrderInfo;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.swing.Activator;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.internal.swing.model.property.TabOrderProperty;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.After;
import org.junit.Ignore;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class TabOrderPropertyValueTest
extends SwingModelTest {
    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        TabOrderPropertyValueTest.do_projectDispose();
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getValue_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FlowLayout());", "    JButton button = new JButton('Button');", "    add(button);", "    JComboBox combo = new JComboBox();", "    add(combo);", "  }", "}");
        panel.refresh();
        TabOrderProperty property = (TabOrderProperty)panel.getPropertyByTitle("tab order");
        Object value = property.getValue();
        TabOrderPropertyValueTest.assertNotNull((Object)value);
        TabOrderPropertyValueTest.assertInstanceOf(TabOrderInfo.class, value);
        TabOrderInfo tabOrderInfo = (TabOrderInfo)value;
        TabOrderPropertyValueTest.assertEquals((long)2L, (long)tabOrderInfo.getInfos().size());
        TabOrderPropertyValueTest.assertEquals((long)2L, (long)tabOrderInfo.getOrderedInfos().size());
        List components = panel.getChildrenComponents();
        TabOrderPropertyValueTest.assertEquals((long)2L, (long)components.size());
        TabOrderPropertyValueTest.assertSame(components.get(0), tabOrderInfo.getInfos().get(0));
        TabOrderPropertyValueTest.assertSame(components.get(1), tabOrderInfo.getInfos().get(1));
        TabOrderPropertyValueTest.assertSame(components.get(0), tabOrderInfo.getOrderedInfos().get(0));
        TabOrderPropertyValueTest.assertSame(components.get(1), tabOrderInfo.getOrderedInfos().get(1));
    }

    @Ignore
    @Test
    public void test_getValue_2() throws Exception {
        ProjectUtils.ensureResourceType((IJavaProject)m_javaProject, (Bundle)Activator.getDefault().getBundle(), (String)"org.eclipse.wb.swing.FocusTraversalOnArray");
        ContainerInfo panel = this.parseContainer("import org.eclipse.wb.swing.FocusTraversalOnArray;", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new FlowLayout());", "    JButton button = new JButton('Button');", "    add(button);", "    JComboBox combo = new JComboBox();", "    add(combo);", "    setFocusTraversalPolicy(new FocusTraversalOnArray(new Component[]{combo}));", "  }", "}");
        panel.refresh();
        TabOrderProperty property = (TabOrderProperty)panel.getPropertyByTitle("tab order");
        Object value = property.getValue();
        TabOrderPropertyValueTest.assertNotNull((Object)value);
        TabOrderPropertyValueTest.assertInstanceOf(TabOrderInfo.class, value);
        TabOrderInfo tabOrderInfo = (TabOrderInfo)value;
        TabOrderPropertyValueTest.assertEquals((long)2L, (long)tabOrderInfo.getInfos().size());
        TabOrderPropertyValueTest.assertEquals((long)1L, (long)tabOrderInfo.getOrderedInfos().size());
        List components = panel.getChildrenComponents();
        TabOrderPropertyValueTest.assertEquals((long)2L, (long)components.size());
        TabOrderPropertyValueTest.assertSame(components.get(0), tabOrderInfo.getInfos().get(1));
        TabOrderPropertyValueTest.assertSame(components.get(1), tabOrderInfo.getInfos().get(0));
        TabOrderPropertyValueTest.assertSame(components.get(1), tabOrderInfo.getOrderedInfos().get(0));
    }

    @Ignore
    @Test
    public void test_setValue() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FlowLayout());", "    JButton button = new JButton('Button');", "    add(button);", "    JComboBox combo = new JComboBox();", "    add(combo);", "  }", "}");
        panel.refresh();
        TabOrderProperty property = (TabOrderProperty)panel.getPropertyByTitle("tab order");
        TabOrderPropertyValueTest.assertFalse((boolean)property.isModified());
        IJavaProject javaProject = m_testProject.getJavaProject();
        TabOrderPropertyValueTest.assertTrue((javaProject.findType("org.eclipse.wb.swing.FocusTraversalOnArray") == null ? 1 : 0) != 0);
        TabOrderInfo newValue = new TabOrderInfo();
        newValue.addOrderedInfo((AbstractComponentInfo)panel.getChildrenComponents().get(1));
        property.setValue((Object)newValue);
        TabOrderPropertyValueTest.assertTrue((javaProject.findType("org.eclipse.wb.swing.FocusTraversalOnArray") != null ? 1 : 0) != 0);
        this.assertEditor("import org.eclipse.wb.swing.FocusTraversalOnArray;", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new FlowLayout());", "    JButton button = new JButton('Button');", "    add(button);", "    JComboBox combo = new JComboBox();", "    add(combo);", "    setFocusTraversalPolicy(new FocusTraversalOnArray(new Component[]{combo}));", "  }", "}");
        TabOrderPropertyValueTest.assertTrue((boolean)property.isModified());
        FlowLayoutInfo layout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = TabOrderPropertyValueTest.createComponent(JLabel.class);
        layout.add(newComponent, null);
        this.assertEditor("import org.eclipse.wb.swing.FocusTraversalOnArray;", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new FlowLayout());", "    JButton button = new JButton('Button');", "    add(button);", "    JComboBox combo = new JComboBox();", "    add(combo);", "    {", "      JLabel label = new JLabel('New label');", "      add(label);", "    }", "    setFocusTraversalPolicy(new FocusTraversalOnArray(new Component[]{combo}));", "  }", "}");
    }
}

