/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.property;

import org.eclipse.core.resources.IFile;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class IconPropertyEditorTest
extends SwingModelTest {
    @Test
    public void test_getText_noIcon() throws Exception {
        this.assertIconPropertyText(null, new String[]{"public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}"});
    }

    @Test
    public void test_getText_null() throws Exception {
        this.assertIconPropertyText("(null)", new String[]{"public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    button.setIcon(null);", "    add(button);", "  }", "}"});
    }

    @Test
    public void test_getText_fromFile_1() throws Exception {
        IFile imageFile = TestUtils.createImagePNG(m_testProject, "1.png", 10, 10);
        try {
            String absoluteImagePath = imageFile.getLocation().toPortableString();
            this.assertIconPropertyText("File: " + absoluteImagePath, new String[]{"public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    button.setIcon(new ImageIcon(\"" + absoluteImagePath + "\"));", "    add(button);", "  }", "}"});
        }
        finally {
            IconPropertyEditorTest.forceDeleteFile(imageFile);
        }
    }

    @Test
    public void test_getText_fromFile_2() throws Exception {
        IFile imageFile = TestUtils.createImagePNG(m_testProject, "1.png", 10, 10);
        try {
            String absoluteImagePath = imageFile.getLocation().toPortableString();
            this.assertIconPropertyText("File: " + absoluteImagePath, new String[]{"public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    button.setIcon(new ImageIcon(\"" + absoluteImagePath + "\", \"some description\"));", "    add(button);", "  }", "}"});
        }
        finally {
            IconPropertyEditorTest.forceDeleteFile(imageFile);
        }
    }

    @Test
    public void test_getText_Class_getResource_1() throws Exception {
        this.assertIconPropertyText("Classpath: /javax/swing/plaf/basic/icons/JavaCup16.png", new String[]{"public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    button.setIcon(new ImageIcon(Test.class.getResource(\"/javax/swing/plaf/basic/icons/JavaCup16.png\")));", "    add(button);", "  }", "}"});
    }

    @Test
    public void test_getText_Class_getResource_2() throws Exception {
        this.assertIconPropertyText("Classpath: /javax/swing/plaf/basic/icons/JavaCup16.png", new String[]{"public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    button.setIcon(      new ImageIcon(Test.class.getResource(\"/javax/swing/plaf/basic/icons/JavaCup16.png\"),       \"Some description\"));", "    add(button);", "  }", "}"});
    }

    @Test
    public void test_getText_Class_getResource_3() throws Exception {
        this.assertIconPropertyText("Classpath: /javax/swing/plaf/basic/icons/JavaCup16.png", new String[]{"public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    Icon icon = new ImageIcon(Test.class.getResource(\"/javax/swing/plaf/basic/icons/JavaCup16.png\"));", "    button.setIcon(icon);", "    add(button);", "  }", "}"});
    }

    @Test
    public void test_getText_Class_getResource_4() throws Exception {
        this.assertIconPropertyText("Classpath: /javax/swing/plaf/basic/icons/JavaCup16.png", new String[]{"public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    java.net.URL url = Test.class.getResource(\"/javax/swing/plaf/basic/icons/JavaCup16.png\");", "    Icon icon = new ImageIcon(url);", "    button.setIcon(icon);", "    add(button);", "  }", "}"});
    }

    private void assertIconPropertyText(String expectedText, String[] lines) throws Exception {
        ContainerInfo panel = this.parseContainer(lines);
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property iconProperty = button.getPropertyByTitle("icon");
        IconPropertyEditorTest.assertEquals((Object)expectedText, (Object)IconPropertyEditorTest.getPropertyText(iconProperty));
    }
}

