/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.bean;

import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.eclipse.gef.Tool;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo;
import org.eclipse.wb.internal.swing.model.bean.ActionInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.JToolBarInfo;
import org.eclipse.wb.internal.swing.model.component.menu.JMenuBarInfo;
import org.eclipse.wb.internal.swing.model.component.menu.JMenuInfo;
import org.eclipse.wb.internal.swing.model.component.menu.JMenuItemInfo;
import org.eclipse.wb.internal.swing.palette.ActionExternalEntryInfo;
import org.eclipse.wb.internal.swing.palette.ActionNewEntryInfo;
import org.eclipse.wb.internal.swing.palette.ActionUseEntryInfo;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.Ignore;
import org.junit.Test;

public class ActionGefTest
extends SwingGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_JToolBar_ActionNewEntryInfo() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJToolBar toolBar = new JToolBar();\n\t\t\tadd(toolBar, BorderLayout.NORTH);\n\t\t}\n\t}\n}");
        ActionGefTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new BorderLayout())/ /add(toolBar, BorderLayout.NORTH)/}", "  {new: java.awt.BorderLayout} {empty} {/setLayout(new BorderLayout())/}", "  {new: javax.swing.JToolBar} {local-unique: toolBar} {/new JToolBar()/ /add(toolBar, BorderLayout.NORTH)/}");
        panel.refresh();
        JToolBarInfo toolBar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        ActionNewEntryInfo entry = new ActionNewEntryInfo();
        entry.initialize((IEditPartViewer)this.m_viewerCanvas, (JavaInfo)panel);
        org.eclipse.wb.gef.core.tools.Tool tool = entry.createTool();
        this.m_viewerCanvas.getEditDomain().setActiveTool((Tool)tool);
        this.canvas.target(panel).in(100, 100).move();
        this.canvas.target(toolBar).in(20, 5).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tprivate final Action action = new SwingAction();\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJToolBar toolBar = new JToolBar();\n\t\t\tadd(toolBar, BorderLayout.NORTH);\n\t\t\t{\n\t\t\t\tJButton button = toolBar.add(action);\n\t\t\t}\n\t\t}\n\t}\n\tprivate class SwingAction extends AbstractAction {\n\t\tpublic SwingAction() {\n\t\t\tputValue(NAME, \"SwingAction\");\n\t\t\tputValue(SHORT_DESCRIPTION, \"Some short description\");\n\t\t}\n\t\tpublic void actionPerformed(ActionEvent e) {\n\t\t}\n\t}\n}");
        ActionGefTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new BorderLayout())/ /add(toolBar, BorderLayout.NORTH)/}", "  {new: java.awt.BorderLayout} {empty} {/setLayout(new BorderLayout())/}", "  {new: javax.swing.JToolBar} {local-unique: toolBar} {/new JToolBar()/ /add(toolBar, BorderLayout.NORTH)/ /toolBar.add(action)/}", "    {implicit-factory} {local-unique: button} {/toolBar.add(action)/}", "  {org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo}", "    {innerAction} {field-initializer: action} {/new SwingAction()/ /toolBar.add(action)/}");
        ComponentInfo button = (ComponentInfo)toolBar.getChildrenComponents().get(0);
        this.canvas.assertPrimarySelected(button);
    }

    @Test
    public void test_JToolBar_ActionUseEntryInfo_canvas() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tprivate ExternalAction action = new ExternalAction();\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJToolBar toolBar = new JToolBar();\n\t\t\tadd(toolBar, BorderLayout.NORTH);\n\t\t}\n\t}\n}");
        ActionGefTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new BorderLayout())/ /add(toolBar, BorderLayout.NORTH)/}", "  {new: java.awt.BorderLayout} {empty} {/setLayout(new BorderLayout())/}", "  {new: javax.swing.JToolBar} {local-unique: toolBar} {/new JToolBar()/ /add(toolBar, BorderLayout.NORTH)/}", "  {org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo}", "    {new: test.ExternalAction} {field-initializer: action} {/new ExternalAction()/}");
        panel.refresh();
        JToolBarInfo toolBar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)panel).get(0);
        this.loadUseAction(action);
        this.canvas.target(toolBar).in(10, 5).move();
        this.canvas.click();
        ActionGefTest.assertNoErrors((JavaInfo)panel);
        this.assertEditor("public class Test extends JPanel {\n\tprivate ExternalAction action = new ExternalAction();\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJToolBar toolBar = new JToolBar();\n\t\t\tadd(toolBar, BorderLayout.NORTH);\n\t\t\t{\n\t\t\t\tJButton button = toolBar.add(action);\n\t\t\t}\n\t\t}\n\t}\n}");
        ComponentInfo button = (ComponentInfo)toolBar.getChildrenComponents().get(0);
        this.tree.assertPrimarySelected(button);
        this.canvas.assertPrimarySelected(button);
    }

    @Test
    public void test_JToolBar_ActionUseEntryInfo_tree() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tprivate ExternalAction action = new ExternalAction();\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJToolBar toolBar = new JToolBar();\n\t\t\tadd(toolBar, BorderLayout.NORTH);\n\t\t}\n\t}\n}");
        ActionGefTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new BorderLayout())/ /add(toolBar, BorderLayout.NORTH)/}", "  {new: java.awt.BorderLayout} {empty} {/setLayout(new BorderLayout())/}", "  {new: javax.swing.JToolBar} {local-unique: toolBar} {/new JToolBar()/ /add(toolBar, BorderLayout.NORTH)/}", "  {org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo}", "    {new: test.ExternalAction} {field-initializer: action} {/new ExternalAction()/}");
        panel.refresh();
        JToolBarInfo toolBar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)panel).get(0);
        this.loadUseAction(action);
        this.tree.moveOn(toolBar);
        this.tree.click();
        ActionGefTest.assertNoErrors((JavaInfo)panel);
        this.assertEditor("public class Test extends JPanel {\n\tprivate ExternalAction action = new ExternalAction();\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJToolBar toolBar = new JToolBar();\n\t\t\tadd(toolBar, BorderLayout.NORTH);\n\t\t\t{\n\t\t\t\tJButton button = toolBar.add(action);\n\t\t\t}\n\t\t}\n\t}\n}");
        ComponentInfo button = (ComponentInfo)toolBar.getChildrenComponents().get(0);
        this.tree.assertPrimarySelected(button);
        this.canvas.assertPrimarySelected(button);
    }

    @Ignore
    @Test
    public void test_JToolBar_ActionExternalEntryInfo() throws Exception {
        this.createExternalAction();
        final ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJToolBar toolBar = new JToolBar();\n\t\t\tadd(toolBar, BorderLayout.NORTH);\n\t\t}\n\t}\n}");
        ActionGefTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new BorderLayout())/ /add(toolBar, BorderLayout.NORTH)/}", "  {new: java.awt.BorderLayout} {empty} {/setLayout(new BorderLayout())/}", "  {new: javax.swing.JToolBar} {local-unique: toolBar} {/new JToolBar()/ /add(toolBar, BorderLayout.NORTH)/}");
        panel.refresh();
        JToolBarInfo toolBar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                ActionExternalEntryInfo entry = new ActionExternalEntryInfo();
                entry.initialize((IEditPartViewer)ActionGefTest.this.m_viewerCanvas, (JavaInfo)panel);
                org.eclipse.wb.gef.core.tools.Tool tool = entry.createTool();
                ActionGefTest.this.m_viewerCanvas.getEditDomain().setActiveTool((Tool)tool);
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                ActionGefTest.animateOpenTypeSelection(bot, "ExternalAction", "OK");
            }
        });
        this.canvas.target(toolBar).in(10, 5).move();
        this.canvas.click();
        ActionGefTest.assertNoErrors((JavaInfo)panel);
        this.assertEditor("public class Test extends JPanel {\n\tprivate final ExternalAction externalAction = new ExternalAction();\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJToolBar toolBar = new JToolBar();\n\t\t\tadd(toolBar, BorderLayout.NORTH);\n\t\t\t{\n\t\t\t\tJButton button = toolBar.add(externalAction);\n\t\t\t}\n\t\t}\n\t}\n}");
        ActionGefTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new BorderLayout())/ /add(toolBar, BorderLayout.NORTH)/}", "  {new: java.awt.BorderLayout} {empty} {/setLayout(new BorderLayout())/}", "  {new: javax.swing.JToolBar} {local-unique: toolBar} {/new JToolBar()/ /add(toolBar, BorderLayout.NORTH)/ /toolBar.add(externalAction)/}", "    {implicit-factory} {local-unique: button} {/toolBar.add(externalAction)/}", "  {org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo}", "    {new: test.ExternalAction} {field-initializer: externalAction} {/new ExternalAction()/ /toolBar.add(externalAction)/}");
        ComponentInfo button = (ComponentInfo)toolBar.getChildrenComponents().get(0);
        this.canvas.assertPrimarySelected(button);
    }

    @Test
    public void test_JButton_setAction() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tprivate ExternalAction action = new ExternalAction();\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        ActionGefTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button)/}", "  {org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo}", "    {new: test.ExternalAction} {field-initializer: action} {/new ExternalAction()/}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)panel).get(0);
        this.loadUseAction(action);
        this.canvas.target(button).in(10, 5).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tprivate ExternalAction action = new ExternalAction();\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setAction(action);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        this.canvas.assertPrimarySelected(button);
    }

    @Test
    public void test_JMenu_dropBetween_JMenuItem() throws Exception {
        this.createExternalAction();
        ContainerInfo frame = this.openContainer("public class Test extends JFrame {\n\tprivate ExternalAction action = new ExternalAction();\n\tpublic Test() {\n\t\t{\n\t\t\tJMenuBar menuBar = new JMenuBar();\n\t\t\tsetJMenuBar(menuBar);\n\t\t\t{\n\t\t\t\tJMenu menu = new JMenu(\"Menu\");\n\t\t\t\tmenuBar.add(menu);\n\t\t\t\t{\n\t\t\t\t\tJMenuItem item_1 = new JMenuItem(\"AAA AAA AAA\");\n\t\t\t\t\tmenu.add(item_1);\n\t\t\t\t}\n\t\t\t\t{\n\t\t\t\t\tJMenuItem item_2 = new JMenuItem(\"BBB BBB BBB\");\n\t\t\t\t\tmenu.add(item_2);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}");
        ActionGefTest.assertHierarchy("{this: javax.swing.JFrame} {this} {/setJMenuBar(menuBar)/}", "  {method: public java.awt.Container javax.swing.JFrame.getContentPane()} {property} {}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "  {new: javax.swing.JMenuBar} {local-unique: menuBar} {/new JMenuBar()/ /setJMenuBar(menuBar)/ /menuBar.add(menu)/}", "    {new: javax.swing.JMenu} {local-unique: menu} {/new JMenu('Menu')/ /menuBar.add(menu)/ /menu.add(item_1)/ /menu.add(item_2)/}", "      {new: javax.swing.JMenuItem} {local-unique: item_1} {/new JMenuItem('AAA AAA AAA')/ /menu.add(item_1)/}", "      {new: javax.swing.JMenuItem} {local-unique: item_2} {/new JMenuItem('BBB BBB BBB')/ /menu.add(item_2)/}", "  {org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo}", "    {new: test.ExternalAction} {field-initializer: action} {/new ExternalAction()/}");
        frame.refresh();
        JMenuBarInfo bar = (JMenuBarInfo)frame.getChildren(JMenuBarInfo.class).get(0);
        JMenuInfo menu = (JMenuInfo)bar.getChildrenMenus().get(0);
        JMenuItemInfo item_2 = (JMenuItemInfo)menu.getChildrenItems().get(1);
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)frame).get(0);
        this.tree.select(menu);
        this.canvas.assertNotNullEditPart(item_2);
        this.loadUseAction(action);
        this.canvas.target(item_2).in(10, 1).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JFrame {\n\tprivate ExternalAction action = new ExternalAction();\n\tpublic Test() {\n\t\t{\n\t\t\tJMenuBar menuBar = new JMenuBar();\n\t\t\tsetJMenuBar(menuBar);\n\t\t\t{\n\t\t\t\tJMenu menu = new JMenu(\"Menu\");\n\t\t\t\tmenuBar.add(menu);\n\t\t\t\t{\n\t\t\t\t\tJMenuItem item_1 = new JMenuItem(\"AAA AAA AAA\");\n\t\t\t\t\tmenu.add(item_1);\n\t\t\t\t}\n\t\t\t\t{\n\t\t\t\t\tJMenuItem menuItem = menu.add(action);\n\t\t\t\t}\n\t\t\t\t{\n\t\t\t\t\tJMenuItem item_2 = new JMenuItem(\"BBB BBB BBB\");\n\t\t\t\t\tmenu.add(item_2);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}");
        JMenuItemInfo newItem = (JMenuItemInfo)menu.getChildrenItems().get(1);
        ActionGefTest.assertEquals((Object)"menuItem", (Object)newItem.getVariableSupport().getName());
        this.canvas.assertPrimarySelected(newItem);
    }

    private void createExternalAction() throws Exception {
        ActionGefTest.setFileContentSrc("test/ExternalAction.java", this.getTestSource("public class ExternalAction extends AbstractAction {\n\tpublic ExternalAction() {\n\t\tputValue(NAME, \"My name\");\n\t\tputValue(SHORT_DESCRIPTION, \"My short description\");\n\t}\n\tpublic void actionPerformed(ActionEvent e) {\n\t}\n}"));
        ActionGefTest.waitForAutoBuild();
    }

    private void loadUseAction(ActionInfo action) throws Exception {
        ActionUseEntryInfo entry = new ActionUseEntryInfo(action);
        entry.initialize((IEditPartViewer)this.m_viewerCanvas, action.getRootJava());
        org.eclipse.wb.gef.core.tools.Tool tool = entry.createTool();
        this.m_viewerCanvas.getEditDomain().setActiveTool((Tool)tool);
    }
}

