/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.swing2swt;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.generic.FlowContainerFactory;
import org.eclipse.wb.internal.rcp.swing2swt.layout.BoxLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.rcp.swing2swt.AbstractSwing2SwtTest;
import org.junit.Test;

public class BoxLayoutTest
extends AbstractSwing2SwtTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse() throws Exception {
        CompositeInfo shell = this.parseComposite("import swing2swt.layout.BoxLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new BoxLayout(BoxLayout.X_AXIS));", "  }", "}");
        shell.refresh();
        BoxLayoutTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new BoxLayout(BoxLayout.X_AXIS))/}", "  {new: swing2swt.layout.BoxLayout} {empty} {/setLayout(new BoxLayout(BoxLayout.X_AXIS))/}");
        BoxLayoutInfo layout = (BoxLayoutInfo)shell.getLayout();
        Assertions.assertThat((List)new FlowContainerFactory((JavaInfo)layout, true).get()).isNotEmpty();
        Assertions.assertThat((List)new FlowContainerFactory((JavaInfo)layout, false).get()).isNotEmpty();
    }

    @Test
    public void test_axis() throws Exception {
        CompositeInfo shell = this.parseComposite("import swing2swt.layout.BoxLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new BoxLayout(BoxLayout.X_AXIS));", "  }", "}");
        shell.refresh();
        BoxLayoutInfo layout = (BoxLayoutInfo)shell.getLayout();
        BoxLayoutTest.assertTrue((boolean)layout.isHorizontal());
        layout.getPropertyByTitle("axis").setValue((Object)1);
        this.assertEditor("import swing2swt.layout.BoxLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new BoxLayout(BoxLayout.Y_AXIS));", "  }", "}");
        BoxLayoutTest.assertFalse((boolean)layout.isHorizontal());
    }
}

