/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.widgets;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.rcp.model.widgets.AbstractTabItemInfo;
import org.eclipse.wb.internal.rcp.model.widgets.CTabFolderInfo;
import org.eclipse.wb.internal.rcp.model.widgets.CTabItemInfo;
import org.eclipse.wb.internal.swt.model.layout.FillLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class CTabFolderTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_unselectedTab_setRedraw() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "    {", "      CTabItem item_1 = new CTabItem(tabFolder, SWT.NONE);", "      {", "        Button button_1 = new Button(tabFolder, SWT.NONE);", "        item_1.setControl(button_1);", "      }", "    }", "    {", "      CTabItem item_2 = new CTabItem(tabFolder, SWT.NONE);", "      {", "        Button button_2 = new Button(tabFolder, SWT.NONE);", "        item_2.setControl(button_2);", "      }", "    }", "  }", "}");
        shell.refresh();
        CTabFolderInfo tabFolder = (CTabFolderInfo)shell.getChildrenControls().get(0);
        CTabItemInfo item_2 = (CTabItemInfo)tabFolder.getItems2().get(1);
        ControlInfo button_2 = item_2.getControl();
        CTabFolderTest.assertNotSame((Object)item_2, (Object)tabFolder.getSelectedItem());
        CTabFolderTest.assertTrue((boolean)button_2.getBounds().isEmpty());
        CTabFolderTest.assertEquals((long)0L, (long)ReflectionUtils.getFieldInt((Object)button_2.getObject(), (String)"drawCount"));
    }

    @Test
    public void test_getSelectedItem_0() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        CTabFolderInfo tabFolder = (CTabFolderInfo)shell.getChildrenControls().get(0);
        CTabFolderTest.assertNull((Object)tabFolder.getSelectedItem());
        Assertions.assertThat((List)tabFolder.getPresentation().getChildrenTree()).isEmpty();
        Assertions.assertThat((List)tabFolder.getPresentation().getChildrenGraphical()).isEmpty();
    }

    @Test
    public void test_getSelectedItem_1() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "    CTabItem item_1 = new CTabItem(tabFolder, SWT.NONE);", "    CTabItem item_2 = new CTabItem(tabFolder, SWT.NONE);", "  }", "}");
        shell.refresh();
        CTabFolderInfo tabFolder = (CTabFolderInfo)shell.getChildrenControls().get(0);
        CTabItemInfo item_1 = (CTabItemInfo)tabFolder.getItems2().get(0);
        CTabItemInfo item_2 = (CTabItemInfo)tabFolder.getItems2().get(1);
        CTabFolderTest.assertSame((Object)item_1, (Object)tabFolder.getSelectedItem());
        item_2.doSelect();
        CTabFolderTest.assertSame((Object)item_2, (Object)tabFolder.getSelectedItem());
        CTabFolderTest.assertSame((Object)tabFolder.getWidget().getSelection(), (Object)item_2.getObject());
        Assertions.assertThat((List)tabFolder.getPresentation().getChildrenTree()).containsOnly((Object[])new ObjectInfo[]{item_1, item_2});
        CTabFolderTest.assertEquals((Object)tabFolder.getPresentation().getChildrenGraphical(), List.of(item_1, item_2));
    }

    @Test
    public void test_doSelect() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "    CTabItem item_1 = new CTabItem(tabFolder, SWT.NONE);", "    CTabItem item_2 = new CTabItem(tabFolder, SWT.NONE);", "  }", "}");
        shell.refresh();
        CTabFolderInfo tabFolder = (CTabFolderInfo)shell.getChildrenControls().get(0);
        CTabItemInfo item_1 = (CTabItemInfo)tabFolder.getItems2().get(0);
        CTabItemInfo item_2 = (CTabItemInfo)tabFolder.getItems2().get(1);
        CTabFolderTest.assertSame((Object)item_1, (Object)tabFolder.getSelectedItem());
        final AtomicInteger refreshCount = new AtomicInteger();
        shell.addBroadcastListener((Object)new ObjectEventListener(){

            public void refreshed() throws Exception {
                refreshCount.incrementAndGet();
            }
        });
        item_2.doSelect();
        CTabFolderTest.assertSame((Object)item_2, (Object)tabFolder.getSelectedItem());
        CTabFolderTest.assertEquals((long)1L, (long)refreshCount.get());
        item_2.doSelect();
        CTabFolderTest.assertEquals((long)1L, (long)refreshCount.get());
    }

    @Test
    public void test_selecting() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "    {", "      CTabItem item_1 = new CTabItem(tabFolder, SWT.NONE);", "      {", "        Button button_1 = new Button(tabFolder, SWT.NONE);", "        item_1.setControl(button_1);", "      }", "    }", "    {", "      CTabItem item_2 = new CTabItem(tabFolder, SWT.NONE);", "      {", "        Button button_2 = new Button(tabFolder, SWT.NONE);", "        item_2.setControl(button_2);", "      }", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        CTabFolderInfo tabFolder = (CTabFolderInfo)shell.getChildrenControls().get(0);
        CTabItemInfo item_1 = (CTabItemInfo)tabFolder.getItems2().get(0);
        CTabItemInfo item_2 = (CTabItemInfo)tabFolder.getItems2().get(1);
        ControlInfo button_1 = item_1.getControl();
        ControlInfo button_2 = item_2.getControl();
        ControlInfo button_3 = (ControlInfo)shell.getChildrenControls().get(1);
        boolean[] refresh = new boolean[1];
        shell.getBroadcastObject().selecting((ObjectInfo)button_3, refresh);
        CTabFolderTest.assertFalse((boolean)refresh[0]);
        refresh = new boolean[1];
        shell.getBroadcastObject().selecting((ObjectInfo)button_2, refresh);
        CTabFolderTest.assertTrue((boolean)refresh[0]);
        CTabFolderTest.assertSame((Object)tabFolder.getSelectedItem(), (Object)item_2);
        refresh = new boolean[1];
        shell.getBroadcastObject().selecting((ObjectInfo)button_2, refresh);
        CTabFolderTest.assertFalse((boolean)refresh[0]);
        CTabFolderTest.assertSame((Object)tabFolder.getSelectedItem(), (Object)item_2);
        refresh = new boolean[1];
        shell.getBroadcastObject().selecting((ObjectInfo)button_1, refresh);
        CTabFolderTest.assertTrue((boolean)refresh[0]);
        CTabFolderTest.assertSame((Object)tabFolder.getSelectedItem(), (Object)item_1);
    }

    @Test
    public void test_deleteSelectedTabItem() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "    CTabItem item_1 = new CTabItem(tabFolder, SWT.NONE);", "    CTabItem item_2 = new CTabItem(tabFolder, SWT.NONE);", "  }", "}");
        shell.refresh();
        CTabFolderInfo tabFolder = (CTabFolderInfo)shell.getChildrenControls().get(0);
        CTabItemInfo item_1 = (CTabItemInfo)tabFolder.getItems2().get(0);
        CTabItemInfo item_2 = (CTabItemInfo)tabFolder.getItems2().get(1);
        item_2.doSelect();
        CTabFolderTest.assertEquals((Object)tabFolder.getSelectedItem(), (Object)item_2);
        item_2.delete();
        CTabFolderTest.assertEquals((Object)tabFolder.getSelectedItem(), (Object)item_1);
    }

    @Test
    public void test_presentation_getChildren() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "    {", "      CTabItem item_1 = new CTabItem(tabFolder, SWT.NONE);", "      {", "        Button button_1 = new Button(tabFolder, SWT.NONE);", "        item_1.setControl(button_1);", "      }", "    }", "    {", "      CTabItem item_2 = new CTabItem(tabFolder, SWT.NONE);", "      {", "        Button button_2 = new Button(tabFolder, SWT.NONE);", "        item_2.setControl(button_2);", "      }", "    }", "  }", "}");
        shell.refresh();
        CTabFolderInfo tabFolder = (CTabFolderInfo)shell.getChildrenControls().get(0);
        CTabItemInfo item_1 = (CTabItemInfo)tabFolder.getItems2().get(0);
        CTabItemInfo item_2 = (CTabItemInfo)tabFolder.getItems2().get(1);
        ControlInfo button_1 = item_1.getControl();
        ControlInfo button_2 = item_2.getControl();
        CTabFolderTest.assertSame((Object)item_1, (Object)tabFolder.getSelectedItem());
        List childrenGraphical = tabFolder.getPresentation().getChildrenGraphical();
        Assertions.assertThat((List)childrenGraphical).containsOnly((Object[])new ObjectInfo[]{item_1, item_2, button_1});
        item_2.doSelect();
        CTabFolderTest.assertSame((Object)item_2, (Object)tabFolder.getSelectedItem());
        CTabFolderTest.assertSame((Object)tabFolder.getWidget().getSelection(), (Object)item_2.getObject());
        childrenGraphical = tabFolder.getPresentation().getChildrenGraphical();
        Assertions.assertThat((List)childrenGraphical).containsOnly((Object[])new ObjectInfo[]{item_1, item_2, button_2});
    }

    @Test
    public void test_parseItems() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setSize(500, 350);", "    setLayout(new FillLayout());", "    {", "      CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "      {", "        CTabItem item = new CTabItem(tabFolder, SWT.NONE);", "        item.setText('000');", "      }", "      {", "        CTabItem item = new CTabItem(tabFolder, SWT.NONE);", "        item.setText('111');", "      }", "    }", "  }", "}");
        shell.refresh();
        CTabFolderInfo tabFolder = (CTabFolderInfo)shell.getChildrenControls().get(0);
        List items = tabFolder.getItems2();
        CTabFolderTest.assertEquals((long)2L, (long)items.size());
        CTabItemInfo item_0 = (CTabItemInfo)items.get(0);
        CTabItemInfo item_1 = (CTabItemInfo)items.get(1);
        CTabFolderTest.assertEquals((Object)"000", (Object)item_0.getWidget().getText());
        CTabFolderTest.assertEquals((Object)"111", (Object)item_1.getWidget().getText());
        Rectangle modelBounds_0 = item_0.getModelBounds();
        Assertions.assertThat((int)modelBounds_0.width).isGreaterThan(25);
        Assertions.assertThat((int)modelBounds_0.height).isGreaterThan(17);
        Rectangle modelBounds_1 = item_1.getModelBounds();
        Assertions.assertThat((int)modelBounds_1.width).isGreaterThan(25);
        Assertions.assertThat((int)modelBounds_1.height).isGreaterThan(17);
        CTabFolderTest.assertNull((Object)item_0.getControl());
        Assertions.assertThat((List)item_0.getPresentation().getChildrenTree()).isEmpty();
    }

    @Test
    public void test_setControl_get() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setSize(500, 350);", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "    {", "      CTabItem item = new CTabItem(tabFolder, SWT.NONE);", "      {", "        Button button = new Button(tabFolder, SWT.NONE);", "        item.setControl(button);", "      }", "    }", "  }", "}");
        shell.refresh();
        CTabFolderInfo tabFolder = (CTabFolderInfo)shell.getChildrenControls().get(0);
        CTabItemInfo item = (CTabItemInfo)tabFolder.getItems2().get(0);
        ControlInfo button = (ControlInfo)tabFolder.getChildrenControls().get(0);
        CTabFolderTest.assertSame((Object)button, (Object)item.getControl());
        Assertions.assertThat((int)button.getBounds().width).isGreaterThan(400);
        Assertions.assertThat((int)button.getBounds().height).isGreaterThan(250);
        Assertions.assertThat((List)item.getPresentation().getChildrenTree()).containsOnly((Object[])new ObjectInfo[]{button});
        Assertions.assertThat((List)tabFolder.getPresentation().getChildrenTree()).containsOnly((Object[])new ObjectInfo[]{item});
    }

    @Test
    public void test_CREATE_control_onItem() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "    {", "      CTabItem item = new CTabItem(tabFolder, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        CTabFolderInfo tabFolder = (CTabFolderInfo)shell.getChildrenControls().get(0);
        CTabItemInfo item = (CTabItemInfo)tabFolder.getItems2().get(0);
        CTabFolderTest.assertNull((Object)item.getControl());
        ControlInfo button = BTestUtils.createButton();
        item.command_CREATE(button);
        CTabFolderTest.assertSame((Object)button, (Object)item.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "    {", "      CTabItem item = new CTabItem(tabFolder, SWT.NONE);", "      {", "        Button button = new Button(tabFolder, SWT.NONE);", "        item.setControl(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_control_onFolder() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        CTabFolderInfo tabFolder = (CTabFolderInfo)CTabFolderTest.getJavaInfoByName("tabFolder");
        ControlInfo button = BTestUtils.createButton();
        tabFolder.command_CREATE(button, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "    {", "      CTabItem tabItem = new CTabItem(tabFolder, SWT.NONE);", "      tabItem.setText('New Item');", "      {", "        Button button = new Button(tabFolder, SWT.NONE);", "        tabItem.setControl(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_control_onItem() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "    {", "      CTabItem item = new CTabItem(tabFolder, SWT.NONE);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        CTabFolderInfo tabFolder = (CTabFolderInfo)shell.getChildrenControls().get(0);
        CTabItemInfo item = (CTabItemInfo)tabFolder.getItems2().get(0);
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(1);
        CTabFolderTest.assertNull((Object)item.getControl());
        item.command_ADD(button);
        CTabFolderTest.assertSame((Object)button, (Object)item.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "    {", "      CTabItem item = new CTabItem(tabFolder, SWT.NONE);", "      {", "        Button button = new Button(tabFolder, SWT.NONE);", "        item.setControl(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_control_onFolder() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        CTabFolderInfo tabFolder = (CTabFolderInfo)CTabFolderTest.getJavaInfoByName("tabFolder");
        ControlInfo button = (ControlInfo)CTabFolderTest.getJavaInfoByName("button");
        tabFolder.command_MOVE(button, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "    {", "      CTabItem tabItem = new CTabItem(tabFolder, SWT.NONE);", "      tabItem.setText('New Item');", "      {", "        Button button = new Button(tabFolder, SWT.NONE);", "        tabItem.setControl(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_control_toOtherItem() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "    {", "      CTabItem item_1 = new CTabItem(tabFolder, SWT.NONE);", "    }", "    {", "      CTabItem item_2 = new CTabItem(tabFolder, SWT.NONE);", "      {", "        Button button = new Button(tabFolder, SWT.NONE);", "        item_2.setControl(button);", "      }", "    }", "  }", "}");
        shell.refresh();
        CTabFolderInfo tabFolder = (CTabFolderInfo)shell.getChildrenControls().get(0);
        CTabItemInfo item_1 = (CTabItemInfo)tabFolder.getItems2().get(0);
        CTabItemInfo item_2 = (CTabItemInfo)tabFolder.getItems2().get(1);
        ControlInfo button = item_2.getControl();
        CTabFolderTest.assertEquals((long)(tabFolder.getChildrenJava().indexOf(item_2) + 1), (long)tabFolder.getChildrenJava().indexOf(button));
        item_1.command_ADD(button);
        CTabFolderTest.assertNull((Object)item_2.getControl());
        CTabFolderTest.assertSame((Object)button, (Object)item_1.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "    {", "      CTabItem item_1 = new CTabItem(tabFolder, SWT.NONE);", "      {", "        Button button = new Button(tabFolder, SWT.NONE);", "        item_1.setControl(button);", "      }", "    }", "    {", "      CTabItem item_2 = new CTabItem(tabFolder, SWT.NONE);", "    }", "  }", "}");
        CTabFolderTest.assertEquals((long)(tabFolder.getChildrenJava().indexOf(item_1) + 1), (long)tabFolder.getChildrenJava().indexOf(button));
    }

    @Test
    public void test_setControl_DELETE() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "    {", "      CTabItem item = new CTabItem(tabFolder, SWT.NONE);", "      {", "        Button button = new Button(tabFolder, SWT.NONE);", "        item.setControl(button);", "      }", "    }", "  }", "}");
        shell.refresh();
        CTabFolderInfo tabFolder = (CTabFolderInfo)shell.getChildrenControls().get(0);
        CTabItemInfo item = (CTabItemInfo)tabFolder.getItems2().get(0);
        item.delete();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_setControl_moveOut() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "    {", "      CTabItem item = new CTabItem(tabFolder, SWT.NONE);", "      {", "        Button button = new Button(tabFolder, SWT.NONE);", "        item.setControl(button);", "      }", "    }", "  }", "}");
        shell.refresh();
        FillLayoutInfo fillLayout = (FillLayoutInfo)shell.getLayout();
        CTabFolderInfo tabFolder = (CTabFolderInfo)shell.getChildrenControls().get(0);
        CTabItemInfo item = (CTabItemInfo)tabFolder.getItems2().get(0);
        ControlInfo button = item.getControl();
        fillLayout.command_MOVE(button, null);
        CTabFolderTest.assertNull((Object)item.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "    {", "      CTabItem item = new CTabItem(tabFolder, SWT.NONE);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_item() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        CTabFolderInfo tabFolder = (CTabFolderInfo)shell.getChildrenControls().get(0);
        CTabItemInfo newItem = (CTabItemInfo)CTabFolderTest.createJavaInfo("org.eclipse.swt.custom.CTabItem");
        tabFolder.command_CREATE((AbstractTabItemInfo)newItem, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "      {", "        CTabItem tabItem = new CTabItem(tabFolder, SWT.NONE);", "        tabItem.setText('New Item');", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_item_empty() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "      {", "        CTabItem item = new CTabItem(tabFolder, SWT.NONE);", "        item.setText('000');", "      }", "      {", "        CTabItem item = new CTabItem(tabFolder, SWT.NONE);", "        item.setText('111');", "      }", "    }", "  }", "}");
        shell.refresh();
        CTabFolderInfo tabFolder = (CTabFolderInfo)shell.getChildrenControls().get(0);
        List items = tabFolder.getItems2();
        tabFolder.command_MOVE((AbstractTabItemInfo)items.get(1), (AbstractTabItemInfo)items.get(0));
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "      {", "        CTabItem item = new CTabItem(tabFolder, SWT.NONE);", "        item.setText('111');", "      }", "      {", "        CTabItem item = new CTabItem(tabFolder, SWT.NONE);", "        item.setText('000');", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_item_withControl() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "    {", "      CTabItem item_1 = new CTabItem(tabFolder, SWT.NONE);", "    }", "    {", "      CTabItem item_2 = new CTabItem(tabFolder, SWT.NONE);", "      {", "        Button button = new Button(tabFolder, SWT.NONE);", "        item_2.setControl(button);", "      }", "    }", "  }", "}");
        shell.refresh();
        CTabFolderInfo tabFolder = (CTabFolderInfo)shell.getChildrenControls().get(0);
        CTabItemInfo item_1 = (CTabItemInfo)tabFolder.getItems2().get(0);
        CTabItemInfo item_2 = (CTabItemInfo)tabFolder.getItems2().get(1);
        ControlInfo button = item_2.getControl();
        CTabFolderTest.assertEquals((long)(tabFolder.getChildrenJava().indexOf(item_2) + 1), (long)tabFolder.getChildrenJava().indexOf(button));
        tabFolder.command_MOVE((AbstractTabItemInfo)item_2, (AbstractTabItemInfo)item_1);
        CTabFolderTest.assertSame((Object)button, (Object)item_2.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CTabFolder tabFolder = new CTabFolder(this, SWT.NONE);", "    {", "      CTabItem item_2 = new CTabItem(tabFolder, SWT.NONE);", "      {", "        Button button = new Button(tabFolder, SWT.NONE);", "        item_2.setControl(button);", "      }", "    }", "    {", "      CTabItem item_1 = new CTabItem(tabFolder, SWT.NONE);", "    }", "  }", "}");
        CTabFolderTest.assertEquals((long)(tabFolder.getChildrenJava().indexOf(item_2) + 1), (long)tabFolder.getChildrenJava().indexOf(button));
    }
}

