/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.description;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;
import org.eclipse.wb.internal.core.model.description.resource.IDescriptionVersionsProvider;
import org.eclipse.wb.internal.core.model.description.resource.IDescriptionVersionsProviderFactory;
import org.eclipse.wb.internal.rcp.RcpDescriptionVersionsProviderFactory;
import org.eclipse.wb.tests.designer.core.annotations.DisposeProjectAfter;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Ignore;
import org.junit.Test;

public class RcpDescriptionVersionsProviderFactoryTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @DisposeProjectAfter
    @Test
    public void test_notRCP() throws Exception {
        RcpDescriptionVersionsProviderFactoryTest.do_projectDispose();
        RcpDescriptionVersionsProviderFactoryTest.do_projectCreate();
        this.parseSource("test", "Test.java", RcpDescriptionVersionsProviderFactoryTest.getSource("import javax.swing.*;", "public class Test extends JPanel {", "  public Test() {", "  }", "}"));
        IDescriptionVersionsProviderFactory providerFactory = RcpDescriptionVersionsProviderFactory.INSTANCE;
        IDescriptionVersionsProvider provider = providerFactory.getProvider(m_javaProject, this.m_lastLoader);
        RcpDescriptionVersionsProviderFactoryTest.assertNull((Object)provider);
        Assertions.assertThat((Map)providerFactory.getVersions(m_javaProject, this.m_lastLoader)).isEmpty();
    }

    @Ignore
    @Test
    public void test_37() throws Exception {
        this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        IDescriptionVersionsProviderFactory providerFactory = RcpDescriptionVersionsProviderFactory.INSTANCE;
        IDescriptionVersionsProvider provider = providerFactory.getProvider(m_javaProject, this.m_lastLoader);
        Class<?> componentClass = this.m_lastLoader.loadClass("org.eclipse.swt.widgets.Button");
        List versions = provider.getVersions(componentClass);
        Assertions.assertThat((List)versions).containsExactly((Object[])new String[]{"3.7", "3.6", "3.5", "3.4", "3.3", "3.2"});
        componentClass = this.m_lastLoader.loadClass("org.eclipse.jface.viewers.TableViewer");
        versions = provider.getVersions(componentClass);
        Assertions.assertThat((List)versions).containsExactly((Object[])new String[]{"3.7", "3.6", "3.5", "3.4", "3.3", "3.2"});
        List versions2 = provider.getVersions(Object.class);
        Assertions.assertThat((List)versions2).isEmpty();
        Assertions.assertThat((Map)providerFactory.getVersions(m_javaProject, this.m_lastLoader)).contains(new Map.Entry[]{MapEntry.entry((Object)"rcp_version", (Object)"3.7")});
        Assertions.assertThat((Map)this.m_lastState.getVersions()).contains(new Map.Entry[]{MapEntry.entry((Object)"rcp_version", (Object)"3.7")});
    }
}

