/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp;

import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.core.TestProject;
import org.eclipse.wb.tests.designer.core.model.parser.AbstractJavaInfoRelatedTest;

public final class BTestUtils {
    public static void configureSWT(TestProject testProject) throws Exception {
        if (EnvironmentUtils.IS_WINDOWS) {
            testProject.addPlugin("org.eclipse.swt.win32.win32.x86_64");
        } else if (EnvironmentUtils.IS_LINUX) {
            testProject.addPlugin("org.eclipse.swt.gtk.linux.x86_64");
        } else if (EnvironmentUtils.IS_MAC) {
            testProject.addPlugin("org.eclipse.swt.cocoa.macosx.x86_64");
        } else {
            throw new UnsupportedOperationException("Unsupported platform.");
        }
    }

    public static void configure(TestProject testProject) throws Exception {
        BTestUtils.configureSWT(testProject);
        testProject.addPlugin("org.eclipse.jface");
        testProject.addPlugin("org.eclipse.osgi");
        testProject.addPlugin("org.eclipse.equinox.common");
        testProject.addPlugin("org.eclipse.equinox.registry");
        testProject.addPlugin("org.eclipse.core.runtime");
        testProject.addPlugin("org.eclipse.core.jobs");
        testProject.addPlugin("org.eclipse.core.commands");
        testProject.addPlugin("org.eclipse.ui.forms");
        testProject.addPlugin("org.eclipse.ui.workbench");
        testProject.addPlugin("org.eclipse.ui.views");
    }

    public static ControlInfo createControl(String componentClassName) throws Exception {
        return (ControlInfo)AbstractJavaInfoRelatedTest.createJavaInfo(componentClassName);
    }

    public static LayoutInfo createLayout(String layoutClassName) throws Exception {
        return (LayoutInfo)AbstractJavaInfoRelatedTest.createJavaInfo(layoutClassName);
    }

    public static ControlInfo createButton() throws Exception {
        return (ControlInfo)AbstractJavaInfoRelatedTest.createJavaInfo("org.eclipse.swt.widgets.Button", "empty");
    }
}

