/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util.ui;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.assertj.core.api.Assertions;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.wb.internal.core.utils.ui.ImageUtils;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.Test;

public class ImageUtilsTest
extends DesignerTestCase {
    @Test
    public void test_getBytesPNG() throws Exception {
        org.eclipse.swt.graphics.Image image = new org.eclipse.swt.graphics.Image(null, 32, 16);
        try {
            byte[] bytes = ImageUtils.getBytesPNG((org.eclipse.swt.graphics.Image)image);
            Assertions.assertThat((int)bytes.length).isGreaterThan(50);
            org.eclipse.swt.graphics.Image loadedImage = new org.eclipse.swt.graphics.Image(null, (InputStream)new ByteArrayInputStream(bytes));
            try {
                Rectangle bounds = loadedImage.getBounds();
                ImageUtilsTest.assertEquals((long)32L, (long)bounds.width);
                ImageUtilsTest.assertEquals((long)16L, (long)bounds.height);
            }
            finally {
                loadedImage.dispose();
            }
        }
        finally {
            image.dispose();
        }
    }

    @Test
    public void test_convertToSWT_BufferedImage() throws Exception {
        BufferedImage awtImage = new BufferedImage(10, 20, 2);
        ImageDescriptor swtImage = ImageUtils.convertToSWT((Image)awtImage);
        ImageData imageData = swtImage.getImageData(100);
        ImageUtilsTest.assertEquals((long)10L, (long)imageData.width);
        ImageUtilsTest.assertEquals((long)20L, (long)imageData.height);
    }

    @Test
    public void test_convertToSWT_ToolkitImage() throws Exception {
        byte[] bytes = TestUtils.createImagePNG(10, 20);
        Toolkit tk = Toolkit.getDefaultToolkit();
        Image awtImage = tk.createImage(bytes);
        ImageDescriptor swtImage = ImageUtils.convertToSWT((Image)awtImage);
        ImageData imageData = swtImage.getImageData(100);
        ImageUtilsTest.assertEquals((long)10L, (long)imageData.width);
        ImageUtilsTest.assertEquals((long)20L, (long)imageData.height);
    }
}

