/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.nls.ui;

import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.matchers.WithText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotStyledText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.nls.ui.NewSourceDialog;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.Test;

public class NewSourceDialogTest
extends SwingModelTest {
    @Test
    public void test_openDialog() throws Exception {
        ContainerInfo frame = this.parseContainer("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        final NewSourceDialog newSourceDialog = new NewSourceDialog(null, (JavaInfo)frame);
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                newSourceDialog.open();
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) throws Exception {
                SWTBot shell = bot.shell("New source").bot();
                NewSourceDialogTest.assertTrue((boolean)shell.radio("Classic Eclipse messages class").isEnabled());
                NewSourceDialogTest.assertTrue((boolean)shell.radio("Modern Eclipse messages class").isEnabled());
                NewSourceDialogTest.assertTrue((boolean)shell.radio("Direct ResourceBundle usage").isEnabled());
                NewSourceDialogTest.assertTrue((boolean)shell.radio("ResourceBundle in field").isEnabled());
                shell.button("Cancel").click();
            }
        });
    }

    @Test
    public void test_DirectSource() throws Exception {
        ContainerInfo frame = this.parseContainer("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        final NewSourceDialog newSourceDialog = new NewSourceDialog(null, (JavaInfo)frame);
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                newSourceDialog.open();
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) throws Exception {
                SWTBot shell = bot.shell("New source").bot();
                SWTBotButton okButton = shell.button("OK");
                shell.radio("Direct ResourceBundle usage").click();
                SWTBotStyledText styledText = shell.styledText();
                NewSourceDialogTest.assertEquals((Object)"button.setText( ResourceBundle.getBundle(\"full.bundle.name\").getString(\"some.key\") );", (Object)styledText.getText());
                Widget widget = (Widget)shell.getFinder().findControls(WithText.withText((String)"Property file location and name")).getFirst();
                SWTBot group = new SWTBot(widget);
                SWTBotText sourceFolderText = group.textWithLabel("Source folder: ");
                NewSourceDialogTest.assertEquals((Object)"TestProject/src", (Object)sourceFolderText.getText());
                sourceFolderText.setText("no-such-folder");
                NewSourceDialogTest.assertFalse((boolean)okButton.isEnabled());
                sourceFolderText.setText("TestProject/src");
                NewSourceDialogTest.assertTrue((boolean)okButton.isEnabled());
                SWTBotText packageText = group.textWithLabel("Package:");
                NewSourceDialogTest.assertEquals((Object)"test", (Object)packageText.getText());
                packageText.setText("no-such-package");
                NewSourceDialogTest.assertFalse((boolean)okButton.isEnabled());
                packageText.setText("test");
                NewSourceDialogTest.assertTrue((boolean)okButton.isEnabled());
                SWTBotText fileText = group.textWithLabel("Property file name:");
                NewSourceDialogTest.assertEquals((Object)"messages.properties", (Object)fileText.getText());
                fileText.setText("bad-file-name");
                NewSourceDialogTest.assertFalse((boolean)okButton.isEnabled());
                fileText.setText("messages.properties");
                NewSourceDialogTest.assertTrue((boolean)okButton.isEnabled());
                okButton.click();
            }
        });
    }
}

